// src/routes/cases.ts
import apiClient from "@/lib/apiClient";

export type CaseStatus =
  | "all"
  | "new"
  | "in_progress"
  | "needs_decision"
  | "blocked"
  | "closed";
export type CaseRole =
  | "owner"
  | "editor"
  | "contributor"
  | "viewer"
  | "external";

export type CaseListItem = {
  id: string;
  title: string;
  description: string | null;
  case_type: string | null;
  status: CaseStatus;
  priority: number;
  owner_user_id: string | null;
  due_at: string | null;
  created_at: string;
  updated_at: string;
};

export const casesApi = {
  list: (params?: { status?: CaseStatus; mine?: 0 | 1; q?: string }) =>
    apiClient.get<{ cases: CaseListItem[] }>("/api/admin/cases", { params }),

  create: (payload: {
    title: string;
    description?: string;
    caseType?: string;
    priority?: number;
    dueAt?: string; // ISO
  }) => apiClient.post<{ id: string }>("/api/admin/cases", payload),

  detail: (caseId: string) =>
    apiClient.get<{
      case: CaseListItem;
      members: {
        user_id: string;
        role: CaseRole;
        is_active: boolean;
        joined_at: string;
      }[];
    }>(`/api/admin/cases/${caseId}`),

  addMember: (caseId: string, payload: { userId: string; role?: CaseRole }) =>
    apiClient.post(`/api/admin/cases/${caseId}/members`, payload),

  listMembers: (caseId: string) =>
    apiClient.get<{
      members: {
        user_id: string;
        role: CaseRole;
        is_active: boolean;
        joined_at: string;
      }[];
    }>(`/api/admin/cases/${caseId}/members`),
};

export default casesApi;
