import apiClient from "@/lib/apiClient";

export type DecisionStatus =
  | "draft"
  | "proposed"
  | "approved"
  | "rejected"
  | "superseded"
  | string;

export type Decision = {
  id: string;
  case_id: string;
  title: string;
  body: string | null;
  status: DecisionStatus;
  created_by: string | null;
  created_at: string;
  updated_at: string;
};

export const decisionsApi = {
  listByCase: (caseId: string) =>
    apiClient.get<{ decisions: Decision[] }>(
      `/api/admin/decisions/by-case/${caseId}`
    ),

  create: (
    caseId: string,
    payload: { title: string; body?: string; status?: DecisionStatus }
  ) =>
    apiClient.post<{ id: string }>(
      `/api/admin/decisions/by-case/${caseId}`,
      payload
    ),

  updateStatus: (decisionId: string, payload: { status: DecisionStatus }) =>
    apiClient.patch(`/api/admin/decisions/${decisionId}/status`, payload),
};

export default decisionsApi;
