// src/routes/threads.ts
import apiClient from "@/lib/apiClient";

export type Thread = {
  id: string;
  case_id: string;
  title: string;
  description: string | null;
  input_due_at: string | null;
  created_by: string | null;
  created_at: string;
  updated_at: string;
};

export type ThreadComment = {
  id: string;
  thread_id: string;
  author_id: string | null;
  comment_type: "comment" | "question" | "proposal" | "stance" | string;
  body: string;
  created_at: string;
  updated_at: string;
};

export type ThreadAttachment = {
  id: string;
  original_name: string;
  mime_type: string | null;
  size_bytes: string | number | null;
  uploaded_at: string;
  uploaded_by: string | null;
  downloadUrl: string; // backend prebuilt
};

export const threadsApi = {
  listByCase: (caseId: string) =>
    apiClient.get<{ threads: Thread[] }>(
      `/api/admin/threads/by-case/${caseId}`
    ),

  create: (
    caseId: string,
    payload: { title: string; description?: string; inputDueAt?: string }
  ) =>
    apiClient.post<{ id: string }>(
      `/api/admin/threads/by-case/${caseId}`,
      payload
    ),

  listComments: (threadId: string) =>
    apiClient.get<{ comments: ThreadComment[] }>(
      `/api/admin/threads/${threadId}/comments`
    ),

  createComment: (
    threadId: string,
    payload: {
      body: string;
      commentType?: "comment" | "question" | "proposal" | "stance";
    }
  ) =>
    apiClient.post<{ id: string }>(
      `/api/admin/threads/${threadId}/comments`,
      payload
    ),

  listAttachments: (threadId: string) =>
    apiClient.get<{ attachments: ThreadAttachment[] }>(
      `/api/admin/threads/${threadId}/attachments`
    ),
};

export default threadsApi;
