import apiClient from "@/lib/apiClient";
import { wrapApiWithTokenRefresh } from "@/lib/withTokenRefresh";

const baseUsersApi = {
  getList: (query) => apiClient.get(`/api/admin/admin-users/list${query}`),
  postCreate: (data) =>
    apiClient.post(`/api/admin//register/admin-user-register`, data),
  getEdit: (id) => apiClient.get(`/api/admin/admin-users/id/${id}`),
  postEdit: (id, data) =>
    apiClient.post(`/api/admin/admin-users/admin-edit/id/${id}`, data),
  //   deleteProduct: (ids) => apiClient.post(`/api/admin/products/delete`, ids),
};
const usersApi = wrapApiWithTokenRefresh(baseUsersApi, [""]);

export default usersApi;
