import apiClient from "@/lib/apiClient";

export const aclApi = {
  /* Users */
  listUsers: () => apiClient.get("/api/admin/acl/users"),
  createUser: (payload: {
    username: string;
    email: string;
    password: string;
    roleId?: string;
  }) => apiClient.post("/api/admin/acl/users", payload),
  updateUser: (
    id: string,
    payload: Partial<{
      username: string;
      email: string;
      password: string;
      isActive: boolean;
    }>
  ) => apiClient.patch(`/api/admin/acl/users/${id}`, payload),
  deleteUser: (id: string) => apiClient.delete(`/api/admin/acl/users/${id}`),

  /* Roles */
  listRoles: () => apiClient.get("/api/admin/acl/roles"),
  assignRoleToUser: (userId: string, roleId: string) =>
    apiClient.post(`/api/admin/acl/users/${userId}/roles/${roleId}`),
  revokeRoleFromUser: (userId: string, roleId: string) =>
    apiClient.delete(`/api/admin/acl/users/${userId}/roles/${roleId}`),

  /* Resources */
  listResources: () => apiClient.get("/api/admin/acl/resources"),

  /* Role permissions */
  grantRolePermission: (payload: {
    roleId: string;
    resourceId: string;
    action: "read" | "create" | "update" | "delete" | "manage";
    effect: "allow" | "deny";
  }) => apiClient.post("/api/admin/acl/permissions/role", payload),
  revokeRolePermission: (payload: {
    roleId: string;
    resourceId: string;
    action: "read" | "create" | "update" | "delete" | "manage";
  }) => apiClient.delete("/api/admin/acl/permissions/role", { data: payload }),

  /* User overrides */
  grantUserPermission: (payload: {
    userId: string;
    resourceId: string;
    action: "read" | "create" | "update" | "delete" | "manage";
    effect: "allow" | "deny";
  }) => apiClient.post("/api/admin/acl/permissions/user", payload),
  revokeUserPermission: (payload: {
    userId: string;
    resourceId: string;
    action: "read" | "create" | "update" | "delete" | "manage";
  }) => apiClient.delete("/api/admin/acl/permissions/user", { data: payload }),
  listRolePermissions: (roleId: string) =>
    apiClient.get(`/api/admin/acl/permissions/role/${roleId}`),
  listUserPermissions: (userId: string) =>
    apiClient.get(`/api/admin/acl/permissions/user/${userId}`),
};

export default aclApi;
