// src/api/admin-menu-section.ts
import apiClient from "@/lib/apiClient";
import { wrapApiWithTokenRefresh } from "@/lib/withTokenRefresh";

const baseAdminMenuSectionApi = {
  // expects your server to support pagination like your category list
  getAll: (query: string) =>
    apiClient.get(`/api/admin/admin-menu-section/list${query}`),

  getCreate: () => apiClient.get("/api/admin/admin-menu-section/create"),
  postCreate: (data: any) =>
    apiClient.post("/api/admin/admin-menu-section/create", data),

  getById: (id: string) =>
    apiClient.get(`/api/admin/admin-menu-section/edit/${id}`),
  update: (id: string, data: any) =>
    apiClient.post(`/api/admin/admin-menu-section/edit/${id}`, data),

  // optional (if you implement them server-side)
  deleteSections: (ids: string[]) =>
    apiClient.post("/api/admin/admin-menu-section/delete", ids),
  updateSorting: (id: string, sorting: number) =>
    apiClient.post(`/api/admin/admin-menu-section/update-sorting`, {
      id,
      sorting,
    }),
};

const adminMenuSectionApi = wrapApiWithTokenRefresh(baseAdminMenuSectionApi, [
  "getAll",
]);

export default adminMenuSectionApi;
