import apiClient from "@/lib/apiClient";
import { wrapApiWithTokenRefresh } from "@/lib/withTokenRefresh";

const baseAdminMenuApi = {
  getAdminMenuTree: () => apiClient.get(`/api/admin/admin-menu/tree`),
  getAll: (query) => apiClient.get(`/api/admin/admin-menu/list${query}`),
  getById: (id) => apiClient.get(`/api/admin/admin-menu/edit/${id}`),
  getCreate: () => apiClient.get("/api/admin/admin-menu/create"),
  postCreate: (data) => apiClient.post("/api/admin/admin-menu/create", data),
  updateSorting: (id, sorting) =>
    apiClient.post(`/api/admin/admin-menu/reorder-single`, {
      id,
      sorting,
    }),
  update: (id, data) =>
    apiClient.post(`/api/admin/admin-menu/edit/${id}`, data),
  deleteAdminMenu: (ids) =>
    apiClient.post("/api/admin/admin-menu/delete-menu", ids),
};
const adminMenuApi = wrapApiWithTokenRefresh(baseAdminMenuApi, ["getAll"]);

export default adminMenuApi;
