// src/api/routes/antivirus-types.js
import apiClient from "@/lib/apiClient";
import { wrapApiWithTokenRefresh } from "@/lib/withTokenRefresh";

const baseAntivirusTypesApi = {
  getList: (query) => apiClient.get(`/api/admin/antivirus-types/list${query}`),
  postCreate: (data) => apiClient.post("/api/admin/antivirus-types/save", data),
  getEdit: (id) => apiClient.get(`/api/admin/antivirus-types/${id}`),
  postEdit: (id, data) =>
    apiClient.post(`/api/admin/antivirus-types/edit/${id}`, data),
  delete: (ids) => apiClient.post("/api/admin/antivirus-types/delete", { ids }),
};

const antivirusTypesApi = wrapApiWithTokenRefresh(baseAntivirusTypesApi, [
  "getList",
]);
export default antivirusTypesApi;
