import apiClient from "@/lib/apiClient";
import { wrapApiWithTokenRefresh } from "@/lib/withTokenRefresh";

const baseArticlesApi = {
  getAll: (query) => apiClient.get(`/api/admin/articles/list${query}`),
  delete: (ids) => apiClient.post(`/api/admin/articles/delete-article`, ids),
  getCreateArticle: () => apiClient.get(`/api/admin/articles/create`),
  putCreateArticle: (data) => apiClient.put(`/api/admin/articles/create`, data),
  getEditArticle: (id) => apiClient.get(`/api/admin/articles/edit/${id}`),
  postEditArticle: (id, data) =>
    apiClient.post(`/api/admin/articles/edit/${id}`, data),
};

const articlesApi = wrapApiWithTokenRefresh(baseArticlesApi, ["getAll"]);
export default articlesApi;
