// src/api/routes/case-types.ts
import apiClient from "@/lib/apiClient";

export type CaseType = {
  id: string;
  key: string;
  name: string;
  description?: string | null;
  is_active: boolean;
  created_at: string;
  updated_at: string;
};

export const caseTypesApi = {
  list: (params?: { q?: string; includeInactive?: 0 | 1 }) =>
    apiClient.get<{ caseTypes: CaseType[] }>(`/api/admin/case-types`, {
      params,
    }),

  create: (payload: { key: string; name: string; description?: string }) =>
    apiClient.post<{ caseType: CaseType }>(`/api/admin/case-types`, payload),

  update: (
    caseTypeId: string,
    payload: { name?: string; description?: string | null; isActive?: boolean }
  ) => apiClient.patch(`/api/admin/case-types/${caseTypeId}`, payload),
};

export default caseTypesApi;
