import apiClient from "@/lib/apiClient";
import { wrapApiWithTokenRefresh } from "@/lib/withTokenRefresh";

const baseChatApi = {
  getMessages: (conversationId?: string) =>
    apiClient.get("/api/admin/chat/messages", {
      params: conversationId ? { conversationId } : {},
    }),

  getConversations: () => apiClient.get("/api/admin/chat/conversations"),

  createConversation: (payload: { name?: string; members: string[] }) =>
    apiClient.post("/api/admin/chat/conversations", payload),

  uploadFile: (formData: FormData) =>
    apiClient.post("/api/admin/chat/upload", formData, {
      headers: { "Content-Type": "multipart/form-data" },
    }),
};

const chatApi = wrapApiWithTokenRefresh(baseChatApi, ["getMessages"]);

export default chatApi;
