import apiClient from "@/lib/apiClient";
import { wrapApiWithTokenRefresh } from "@/lib/withTokenRefresh";

const baseDeliveryApi = {
  getList: (query) => apiClient.get(`/api/admin/delivery-price/list${query}`),
  putCreate: (data) => apiClient.put("/api/admin/delivery-price/create", data),
  getEdit: (id) => apiClient.get(`/api/admin/delivery-price/edit/${id}`),
  postEdit: (id, data) =>
    apiClient.post(`/api/admin/delivery-price/edit/${id}`, data),
  delete: (ids) => apiClient.post("/api/admin/delivery-price/delete", ids),
};
const deliveryApi = wrapApiWithTokenRefresh(baseDeliveryApi, []);
export default deliveryApi;
