// src/api/routes/device-modelss.js
import apiClient from "@/lib/apiClient";
import { wrapApiWithTokenRefresh } from "@/lib/withTokenRefresh";

const baseDeviceModelsApi = {
  getList: (query) => apiClient.get(`/api/admin/device-models/list${query}`),
  postCreate: (data) => apiClient.post("/api/admin/device-models/save", data),
  getEdit: (id) => apiClient.get(`/api/admin/device-models/${id}`),
  postEdit: (id, data) =>
    apiClient.post(`/api/admin/device-models/edit/${id}`, data),
  delete: (ids) => apiClient.post("/api/admin/device-models/delete", { ids }),
};

const deviceModelsApi = wrapApiWithTokenRefresh(baseDeviceModelsApi, [
  "getList",
]);
export default deviceModelsApi;
