import apiClient from "@/lib/apiClient";
import { wrapApiWithTokenRefresh } from "@/lib/withTokenRefresh";

const baseDocumentsApi = {
  removeAttachedDocument: (id) =>
    apiClient.delete(`/api/admin/document/documents/${id}`),
  getDocumentDownloadUrl: (docId) =>
    `${process.env.SERVER_URL}/api/admin/document/documents/${docId}/download`,
  updateDocumentMetadata: (id, data) =>
    apiClient.post(`/api/admin/document/documents/${id}`, data),
  getDocumentTypes: () => apiClient.get("/api/admin/document/types"),
  getDocumentTypesList: (query) =>
    apiClient.get(`/api/admin/document/list${query}`),
  postNewDocumentType: (data) =>
    apiClient.post("/api/admin/document/types", data),
  getEditDocumentType: (id) => apiClient.get(`/api/admin/document/types/${id}`),
  editDocumentType: (id, data) =>
    apiClient.put(`/api/admin/document/types/${id}`, data),
  deleteDocumentType: (ids) =>
    apiClient.delete(`/api/admin/document/types/delete`, ids),
  removeFilingDocument: (filingId, docId) =>
    apiClient.delete(`/api/admin/document/${filingId}/documents/${docId}`),

  filingDocumentDownloadUrl: (docId) =>
    `${process.env.SERVER_URL}/api/admin/document/documents/filing/${docId}/download`,

  updateFilingMetadata: (docId, data) =>
    apiClient.post(`/api/admin/document/documents/filing/${docId}`, data),
  downloadFilingDocument: (docId) =>
    apiClient.get(`/api/admin/document/documents/filing/${docId}/download`, {
      responseType: "blob",
    }),
};

const documentsApi = wrapApiWithTokenRefresh(baseDocumentsApi, [
  "filingDocumentDownloadUrl",
]);

export default documentsApi;
