// app/api/routes/domain-registry.ts (or wherever you define this client)
import apiClient from "@/lib/apiClient";
import { wrapApiWithTokenRefresh } from "@/lib/withTokenRefresh";

const baseDomainRegistrarApi = {
  getList: (query = "") =>
    apiClient.get(`/api/admin/domain-registrars${query}`, {
      withCredentials: true,
    }),
  create: (payload: {
    name: string;
    email?: string | null;
    url?: string | null;
    password?: string | null;
  }) =>
    apiClient.post(`/api/admin/domain-registrars`, payload, {
      withCredentials: true,
    }),
  getOne: (id: string) =>
    apiClient.get(`/api/admin/domain-registrars/${id}`, {
      withCredentials: true,
    }),
  update: (
    id: string,
    payload: {
      name?: string;
      email?: string | null;
      url?: string | null;
      password?: string | null; // optional: send to change, null to clear
    }
  ) =>
    apiClient.put(`/api/admin/domain-registrars/${id}`, payload, {
      withCredentials: true,
    }),
  remove: (id: string) =>
    apiClient.delete(`/api/admin/domain-registrars/${id}`, {
      withCredentials: true,
    }),
  getPassword: (id: string) =>
    apiClient.get(`/api/admin/domain-registrars/${id}/password`, {
      withCredentials: true,
    }),
  setPassword: (id: string, password: string | null) =>
    apiClient.put(
      `/api/admin/domain-registrars/${id}/password`,
      { password },
      { withCredentials: true }
    ),
};

const domainRegistrarApi = wrapApiWithTokenRefresh(baseDomainRegistrarApi, []);
export default domainRegistrarApi;
