// src/lib/api/routes/faqs.ts
import apiClient from "@/lib/apiClient";
import { wrapApiWithTokenRefresh } from "@/lib/withTokenRefresh";

const baseFaqsApi = {
  // query should include ? if needed, e.g. "?search=..."
  getList: (query = "") => apiClient.get(`/api/admin/faqs/list${query}`),

  // view-only (public-ish) version
  getView: (id: string) => apiClient.get(`/api/admin/faqs/${id}/view`),

  // full admin version (for editing)
  getItem: (id: string) => apiClient.get(`/api/admin/faqs/${id}`),

  // create or update
  upsertItem: (payload: object) => apiClient.post(`/api/admin/faqs`, payload),

  // download DOCX
  download: (id: string) =>
    apiClient.get(`/api/admin/faqs/${id}/export-docx`, {
      // depends on your apiClient impl, but usually:
      responseType: "blob",
    }),
};

const faqsApi = wrapApiWithTokenRefresh(baseFaqsApi, []);

export default faqsApi;
