import apiClient from "@/lib/apiClient";
import { wrapApiWithTokenRefresh } from "@/lib/withTokenRefresh";

const baseInventoryApi = {
  upload: (data) => apiClient.post("/api/admin/assets-inventory/upload", data),
  getList: (query) => apiClient.get(`/api/admin/assets-inventory/list${query}`),
  download: (query = "") =>
    apiClient.get(`/api/admin/assets-inventory/download${query}`, {
      responseType: "blob",
    }),
  createAsset: (data) =>
    apiClient.post("/api/admin/assets-inventory/create", data),
  updateAsset: (id, data) =>
    apiClient.post(`/api/admin/assets-inventory/update/${id}`, data),
  getOne: (id) => apiClient.get(`/api/admin/assets-inventory/get-one/${id}`),
  getAssetDocuments: (id) =>
    apiClient.get(`/api/admin/assets-inventory/${id}/documents`),
  getAssetMovements: (id) =>
    apiClient(`/api/admin/assets-inventory/${id}/movement`),
  attachDocumentToAsset: (id, data) =>
    apiClient.post(`/api/admin/assets-inventory/${id}/documents`, data),
  // 🔑 New endpoints for filter select options:
  getSites: () => apiClient.get("/api/admin/assets-inventory/filters/sites"),
  getDepartments: () =>
    apiClient.get("/api/admin/assets-inventory/filters/departments"),
  getBuyers: () => apiClient.get("/api/admin/assets-inventory/filters/buyers"),
  getAssetTypes: () =>
    apiClient.get("/api/admin/assets-inventory/filters/asset-types"),
  getLocations: () =>
    apiClient.get("/api/admin/assets-inventory/filters/locations"),
  getBrands: () => apiClient.get("/api/admin/assets-inventory/filters/brands"),
  getReferences: () => apiClient.get("/api/admin/assets-inventory/references"),
  delete: (ids) =>
    apiClient.post("/api/admin/assets-inventory/delete", {
      ids,
    }),
};
const inventoryApi = wrapApiWithTokenRefresh(baseInventoryApi, []);

export default inventoryApi;
