import apiClient from "@/lib/apiClient";

export type LookupUser = {
  id: string;
  name: string;
  email: string | null;
  username: string | null;
};

export type LookupCase = {
  id: string;
  title: string;
  status: string;
  priority: number;
  due_at: string | null;
  updated_at: string | null;
};

export type LookupThread = {
  id: string;
  case_id: string;
  title: string;
  input_due_at: string | null;
  updated_at: string | null;
  case_title?: string | null;
};

export const lookupsApi = {
  users: (params?: { q?: string; limit?: number }) =>
    apiClient.get<{ users: LookupUser[] }>("/api/admin/lookups/users", {
      params,
    }),

  cases: (params?: { q?: string; limit?: number }) =>
    apiClient.get<{ cases: LookupCase[] }>("/api/admin/lookups/cases", {
      params,
    }),

  threads: (params?: { q?: string; limit?: number; caseId?: string }) =>
    apiClient.get<{ threads: LookupThread[] }>("/api/admin/lookups/threads", {
      params,
    }),
};

export default lookupsApi;
