// src/api/routes/me.ts
import apiClient from "@/lib/apiClient";

export type MeResponse = {
  user: {
    id: string;
    name?: string | null;
    email?: string | null;
    username?: string | null;
    accessLevel?: string | null;
  };
  preferences: {
    dashboardCases: Record<string, any>;
  };
};

export const meApi = {
  get: () => apiClient.get<MeResponse>(`/api/admin/me`),
  saveDashboardCases: (dashboardCases: Record<string, any>) =>
    apiClient.patch(`/api/admin/me/dashboard-cases`, { dashboardCases }),
};

export default meApi;
