// src/api/routes/office-versions.js
import apiClient from "@/lib/apiClient";
import { wrapApiWithTokenRefresh } from "@/lib/withTokenRefresh";

const baseOfficeVersionsApi = {
  getList: (query) => apiClient.get(`/api/admin/office-versions/list${query}`),
  postCreate: (data) => apiClient.post("/api/admin/office-versions/save", data),
  getEdit: (id) => apiClient.get(`/api/admin/office-versions/${id}`),
  postEdit: (id, data) =>
    apiClient.post(`/api/admin/office-versions/edit/${id}`, data),
  delete: (ids) => apiClient.post("/api/admin/office-versions/delete", { ids }),
};

const officeVersionsApi = wrapApiWithTokenRefresh(baseOfficeVersionsApi, [
  "getList",
]);
export default officeVersionsApi;
