// api/org-structure.ts
import apiClient from "@/lib/apiClient";
import { wrapApiWithTokenRefresh } from "@/lib/withTokenRefresh";

const baseOrgApi = {
  // Tree
  getTree: (withCounts = true) =>
    apiClient.get(`/api/admin/org-structure/tree?withCounts=${withCounts}`),

  // Move & Reorder (NEW)
  moveDepartment: (payload: {
    department_id: string;
    to_site_id: string;
    before_id?: string;
  }) => apiClient.post("/api/admin/org-structure/move/department", payload),

  moveLocation: (payload: {
    location_id: string;
    to_department_id: string;
    before_id?: string;
  }) => apiClient.post("/api/admin/org-structure/move/location", payload),

  reorderSiblings: (payload: {
    type: "department" | "location";
    parent_id: string;
    ordered_ids: string[];
  }) => apiClient.post("/api/admin/org-structure/reorder", payload),

  // Sites
  listSites: () => apiClient.get("/api/admin/org-structure/sites"),
  createSite: (data: { name: string }) =>
    apiClient.post("/api/admin/org-structure/sites", data),
  updateSite: (id: string, data: { name: string }) =>
    apiClient.patch(`/api/admin/org-structure/sites/${id}`, data),
  deleteSite: (id: string) =>
    apiClient.delete(`/api/admin/org-structure/sites/${id}`),

  // Departments
  listDepartmentsBySite: (siteId: string) =>
    apiClient.get(`/api/admin/org-structure/sites/${siteId}/departments`),
  createDepartment: (data: { name: string; site_id: string }) =>
    apiClient.post("/api/admin/org-structure/departments", data),
  updateDepartment: (id: string, data: { name?: string; site_id?: string }) =>
    apiClient.patch(`/api/admin/org-structure/departments/${id}`, data),
  deleteDepartment: (id: string) =>
    apiClient.delete(`/api/admin/org-structure/departments/${id}`),

  // Locations
  listLocationsByDepartment: (departmentId: string) =>
    apiClient.get(
      `/api/admin/org-structure/departments/${departmentId}/locations`
    ),
  createLocation: (data: { name: string; department_id: string }) =>
    apiClient.post("/api/admin/org-structure/locations", data),
  updateLocation: (
    id: string,
    data: { name?: string; department_id?: string }
  ) => apiClient.patch(`/api/admin/org-structure/locations/${id}`, data),
  deleteLocation: (id: string) =>
    apiClient.delete(`/api/admin/org-structure/locations/${id}`),
};

const orgApi = wrapApiWithTokenRefresh(baseOrgApi, []);
export default orgApi;
