// src/api/routes/os-types.js
import apiClient from "@/lib/apiClient";
import { wrapApiWithTokenRefresh } from "@/lib/withTokenRefresh";

const baseOsTypesApi = {
  getList: (query) => apiClient.get(`/api/admin/os-types/list${query}`),
  postCreate: (data) => apiClient.post("/api/admin/os-types/save", data),
  getEdit: (id) => apiClient.get(`/api/admin/os-types/${id}`),
  postEdit: (id, data) =>
    apiClient.post(`/api/admin/os-types/edit/${id}`, data),
  delete: (ids) => apiClient.post("/api/admin/os-types/delete", { ids }),
};

const osTypesApi = wrapApiWithTokenRefresh(baseOsTypesApi, ["getList"]);
export default osTypesApi;
