import apiClient from "@/lib/apiClient";
import { wrapApiWithTokenRefresh } from "@/lib/withTokenRefresh";

const basePagessApi = {
  getAll: (query) => apiClient.get(`/api/admin/pages/list${query}`),
  getCreatePage: () => apiClient.get(`/api/admin/pages/create`),
  putCreatePage: (data) => apiClient.put(`/api/admin/pages/create`, data),
  getUpdatePage: (id) => apiClient.get(`/api/admin/pages/edit/${id}`),
  postUpdatePage: (id, data) =>
    apiClient.post(`/api/admin/pages/edit/${id}`, data),
  deletePage: (ids) => apiClient.post(`/api/admin/pages/delete-page`, ids),
};
const pagesApi = wrapApiWithTokenRefresh(basePagessApi, [""]);
export default pagesApi;
