import apiClient from "@/lib/apiClient";
import { wrapApiWithTokenRefresh } from "@/lib/withTokenRefresh";

const basePartnerCompanyApi = {
  getList: (query) => apiClient.get(`/api/admin/partner-company/list${query}`),
  getAllNames: () => apiClient.get("/api/admin/partner-company/all-names"),
  getAllGroupNames: () =>
    apiClient.get("/api/admin/partner-company/all-group-names"),
  getAllShortNames: () =>
    apiClient.get("/api/admin/partner-company/all-short-codes"),
  postCreate: (data) =>
    apiClient.post("/api/admin/partner-company/create", data),
  getEdit: (id) => apiClient.get(`/api/admin/partner-company/edit/${id}`),
  postEdit: (id, data) =>
    apiClient.post(`/api/admin/partner-company/edit/${id}`, data),
  delete: (ids) => apiClient.post("/api/admin/partner-company/delete", { ids }),
  upload: (data) => apiClient.post("/api/admin/partner-company/upload", data),
};
const partnerCompanyApi = wrapApiWithTokenRefresh(basePartnerCompanyApi, [
  "getCompanyList",
]);
export default partnerCompanyApi;
