import apiClient from "@/lib/apiClient";
import { wrapApiWithTokenRefresh } from "@/lib/withTokenRefresh";

const baseProductBrandsApi = {
  getList: (query) => apiClient.get(`/api/admin/product-brands/list${query}`),
  getCreate: () => apiClient.get("/api/admin/product-brands/create"),
  putCreate: (data) => apiClient.put("/api/admin/product-brands/create", data),
  getEdit: (id) => apiClient.get(`/api/admin/product-brands/edit/${id}`),
  postEdit: (id, data) =>
    apiClient.post(`/api/admin/product-brands/edit/${id}`, data),
  delete: (ids) =>
    apiClient.post("/api/admin/product-brands/delete-brands", ids),
  getReorder: () => apiClient.get("/api/admin/product-brands/reorder"),
  postReorder: (data) =>
    apiClient.post("/api/admin/product-brands/reorder", data),
  getBrandsSelect: () =>
    apiClient.get(`/api/admin/product-brands/get-brands-select`),
};
const productBrandsApi = wrapApiWithTokenRefresh(baseProductBrandsApi, []);
export default productBrandsApi;
