import apiClient from "@/lib/apiClient";
import { wrapApiWithTokenRefresh } from "@/lib/withTokenRefresh";

const baseProductsApi = {
  createProduct: (parent, data) =>
    apiClient.post(`/api/admin/products/create/${parent}`, data),
  postEdit: (id, data) =>
    apiClient.post(`/api/admin/products/edit/${id}`, data),
  deleteProduct: (ids) => apiClient.post(`/api/admin/products/delete`, ids),
};
const productsApi = wrapApiWithTokenRefresh(baseProductsApi, [""]);

export default productsApi;
