import apiClient from "@/lib/apiClient";
import { wrapApiWithTokenRefresh } from "@/lib/withTokenRefresh";

const baseQmsApi = {
  // categories
  getCategories: () => apiClient.get("/api/admin/qms/categories"),
  createCategory: (data: any) =>
    apiClient.post("/api/admin/qms/categories", data),
  updateCategory: (id: string, data: any) =>
    apiClient.patch(`/api/admin/qms/categories/${id}`, data),
  deleteCategory: (id: string) =>
    apiClient.delete(`/api/admin/qms/categories/${id}`),
  reorderCategories: (data: {
    parentId: string | null;
    orderedIds: string[];
  }) => apiClient.patch(`/api/admin/qms/categories/reorder`, data),

  // documents
  listDocuments: (query: string) =>
    apiClient.get(`/api/admin/qms/documents${query}`),
  createDocument: (data: any) =>
    apiClient.post(`/api/admin/qms/documents`, data),
  updateDocument: (id: string, data: any) =>
    apiClient.patch(`/api/admin/qms/documents/${id}`, data),
  deleteDocument: (id: string) =>
    apiClient.delete(`/api/admin/qms/documents/${id}`),
  getDocumentDetail: (id: string) =>
    apiClient.get(`/api/admin/qms/documents/${id}`),

  // versions
  listVersions: (docId: string) =>
    apiClient.get(`/api/admin/qms/documents/${docId}/versions`),
  uploadVersion: (docId: string, form: FormData) =>
    apiClient.post(`/api/admin/qms/documents/${docId}/versions`, form, {
      headers: { "Content-Type": "multipart/form-data" },
    }),
  setDefaultVersion: (docId: string, defaultVersionId: string | null) =>
    apiClient.patch(`/api/admin/qms/documents/${docId}/default-version`, {
      defaultVersionId,
    }),
  downloadVersionUrl: (versionId: string) =>
    `/api/admin/qms/versions/${versionId}/download`,

  // acl
  listRoles: () => apiClient.get(`/api/admin/qms/acl/roles`),
  listAcl: (params: {
    objectType: "category" | "document";
    objectId: string;
  }) =>
    apiClient.get(
      `/api/admin/qms/acl?objectType=${params.objectType}&objectId=${params.objectId}`
    ),
  saveAclBulk: (payload: any) => apiClient.put(`/api/admin/qms/acl`, payload),
  listApprovalRequests: (params?: Record<string, any>) =>
    apiClient.get("/api/admin/qms/approval-requests", { params }),
  getApprovalRequest: (id: string) =>
    apiClient.get(`/api/admin/qms/approval-requests/${id}`),
  createApprovalRequest: (versionId: string, body: any) =>
    apiClient.post(
      `/api/admin/qms/versions/${versionId}/approval-requests`,
      body
    ),
  approveApprovalRequest: (id: string) =>
    apiClient.post(`/api/admin/qms/approval-requests/${id}/approve`),
  denyApprovalRequest: (id: string, reason: string) =>
    apiClient.post(`/api/admin/qms/approval-requests/${id}/deny`, { reason }),
  cancelApprovalRequest: (id: string) =>
    apiClient.post(`/api/admin/qms/approval-requests/${id}/cancel`),
  listWorkItems: (params?: Record<string, any>) =>
    apiClient.get("/api/admin/qms/work-items", { params }),
  getWorkItemDetail: (id: string) =>
    apiClient.get(`/api/admin/qms/work-items/${id}`),
  createWorkItem: (body: any) =>
    apiClient.post("/api/admin/qms/work-items", body),
  updateWorkItem: (id: string, body: any) =>
    apiClient.patch(`/api/admin/qms/work-items/${id}`, body),
  addWorkItemComment: (id: string, body: { body: string }) =>
    apiClient.post(`/api/admin/qms/work-items/${id}/comments`, body),
  listEnrollments: (params?: Record<string, any>) =>
    apiClient.get("/api/admin/qms/training/enrollments", { params }),
  getEnrollmentDetail: (id: string) =>
    apiClient.get(`/api/admin/qms/training/enrollments/${id}`),
  completeTrainingItem: (enrollmentId: string, packageItemId: string) =>
    apiClient.post(
      `/api/admin/qms/training/enrollments/${enrollmentId}/complete-item`,
      {
        packageItemId,
      }
    ),
  getEnrollmentItemLink: (enrollmentId: string, packageItemId: string) =>
    apiClient.get(
      `/api/admin/qms/training/enrollments/${enrollmentId}/items/${packageItemId}/link`
    ),
  downloadEnrollmentItem: (enrollmentId: string, packageItemId: string) =>
    apiClient.get(
      `/api/admin/qms/training/enrollments/${enrollmentId}/items/${packageItemId}/download`,
      { responseType: "blob" }
    ),
  // training packages
  listPackages: (params?: Record<string, any>) =>
    apiClient.get("/api/admin/qms/training/packages", { params }),
  upsertPackage: (body: any) =>
    apiClient.post("/api/admin/qms/training/packages", body),
  getPackageDetail: (id: string) =>
    apiClient.get(`/api/admin/qms/training/packages/${id}`),
  replacePackageItems: (id: string, items: any[]) =>
    apiClient.put(`/api/admin/qms/training/packages/${id}/items`, { items }),
  createAssignment: (body: any) =>
    apiClient.post("/api/admin/qms/training/assignments", body),
};

export default wrapApiWithTokenRefresh(baseQmsApi, [
  "listDocuments",
  "getCategories",
]);
