import apiClient from "@/lib/apiClient";
import { wrapApiWithTokenRefresh } from "@/lib/withTokenRefresh";

const baseSessionApi = {
  createAdminSession: (credentials) =>
    apiClient.get(`/api/admin/session/create`, "POST", credentials),
  getAdminSession: (sessionId, adminId) =>
    apiClient.get(`/api/admin/session/${sessionId}/${adminId}`),
};

const sessionApi = wrapApiWithTokenRefresh(baseSessionApi, [
  "createAdminSession",
  "getAdminSession",
]);

export default sessionApi;
