// src/api/routes/ssd-sizes.js
import apiClient from "@/lib/apiClient";
import { wrapApiWithTokenRefresh } from "@/lib/withTokenRefresh";

const baseSsdSizesApi = {
  getList: (query) => apiClient.get(`/api/admin/ssd-sizes/list${query}`),
  postCreate: (data) => apiClient.post("/api/admin/ssd-sizes/save", data),
  getEdit: (id) => apiClient.get(`/api/admin/ssd-sizes/${id}`),
  postEdit: (id, data) =>
    apiClient.post(`/api/admin/ssd-sizes/edit/${id}`, data),
  delete: (ids) => apiClient.post("/api/admin/ssd-sizes/delete", { ids }),
};

const ssdSizesApi = wrapApiWithTokenRefresh(baseSsdSizesApi, ["getList"]);
export default ssdSizesApi;
