// src/api/routes/ssd-types.js
import apiClient from "@/lib/apiClient";
import { wrapApiWithTokenRefresh } from "@/lib/withTokenRefresh";

const baseSsdTypesApi = {
  getList: (query) => apiClient.get(`/api/admin/ssd-types/list${query}`),
  postCreate: (data) => apiClient.post("/api/admin/ssd-types/save", data),
  getEdit: (id) => apiClient.get(`/api/admin/ssd-types/${id}`),
  postEdit: (id, data) =>
    apiClient.post(`/api/admin/ssd-types/edit/${id}`, data),
  delete: (ids) => apiClient.post("/api/admin/ssd-types/delete", { ids }),
};

const ssdTypesApi = wrapApiWithTokenRefresh(baseSsdTypesApi, ["getList"]);
export default ssdTypesApi;
