"use client";
import { useAuth } from "@/context/AuthContext";
import { useRouter } from "next/navigation";
import { useEffect, useState } from "react";
import MediaGalleryModal from "@/components/media-store/GalleryModal/MediaGalleryModal";

const Dashboard = () => {
  const { user, isAuthenticated, loading } = useAuth();
  const router = useRouter();
  const [modalOpen, setModalOpen] = useState(false);

  useEffect(() => {
    if (!loading && !isAuthenticated) {
      // If user is not authenticated *after* loading, redirect to login
      router.push("/");
    } else {
      router.push("/admin/dashboard");
    }
  }, [loading, router, isAuthenticated]);

  if (!isAuthenticated) {
    // While router is redirecting
    return null;
  }

  return <div>dashboard</div>;
};

export default Dashboard;
