// app/admin/domain-registry/create/page.tsx
"use client";

import { useRouter } from "next/navigation";
import toast from "react-hot-toast";
import ApiCall from "@/api/api-calls";
import DomainRegistryForm, {
  DomainUpsertPayload,
} from "@/components/domain-registry/DomainRegistryForm";

export default function DomainRegistryCreatePage() {
  const router = useRouter();

  const handleCreate = async (payload: DomainUpsertPayload) => {
    try {
      const res = await ApiCall.domainRegistry.create(payload);
      if (res?.status === 201) {
        toast.success("Létrehozva");
        router.push("/admin/domain-registry/list");
      } else {
        toast.error(res?.data?.error ?? "Sikertelen létrehozás");
      }
    } catch (e: any) {
      toast.error(e?.response?.data?.error ?? "Sikertelen létrehozás");
    }
  };

  return (
    <main className="p-4 space-y-4 max-w-3xl">
      <h1 className="text-xl font-semibold">Új domain felvétele</h1>
      <DomainRegistryForm onSubmit={handleCreate} />
    </main>
  );
}
