// app/admin/email-registry/upload/page.tsx
"use client";

import { useRef, useState } from "react";
import toast from "react-hot-toast";
import ApiCall from "@/api/api-calls";

export default function EmailRegistryUploadPage() {
  const fileInputRef = useRef<HTMLInputElement | null>(null);
  const [status, setStatus] = useState<string | null>(null);
  const [busy, setBusy] = useState(false);

  const onSubmit = async (e: React.FormEvent) => {
    e.preventDefault();
    if (!fileInputRef.current?.files?.[0]) {
      setStatus("Nincs kiválasztott fájl");
      return;
    }
    setBusy(true);
    setStatus("Feltöltés folyamatban…");

    try {
      const form = new FormData();
      form.append("file", fileInputRef.current.files[0]);
      const res = await ApiCall.emailRegistry.upload(form); // see API wrapper below
      if (res.status === 200) {
        toast.success("Sikeres import");
        setStatus("Sikeres import.");
      } else {
        toast.error(res.data?.error ?? "Hiba történt");
        setStatus(`❌ ${res.data?.error ?? "Sikertelen import"}`);
      }
    } catch (err: any) {
      console.error(err);
      toast.error("Feltöltési hiba");
      setStatus("❌ Feltöltési hiba");
    } finally {
      setBusy(false);
    }
  };

  return (
    <main className="max-w-xl mx-auto py-10 px-4">
      <h1 className="text-2xl font-bold mb-4">
        E-mail nyilvántartás feltöltés
      </h1>
      <form onSubmit={onSubmit} className="space-y-4">
        <input
          type="file"
          accept=".xlsx,.xls"
          ref={fileInputRef}
          className="block w-full border rounded px-3 py-2"
        />
        <button
          type="submit"
          disabled={busy}
          className="bg-blue-600 text-white px-4 py-2 rounded hover:bg-blue-700 disabled:opacity-60">
          {busy ? "Feltöltés…" : "Feltöltés"}
        </button>
        {status && <p className="text-sm mt-2">{status}</p>}
        <p className="text-xs text-gray-500">
          Elvárt lapok: <code>email_cimek</code>, <code>email_tipus</code>,{" "}
          <code>munkatarsak</code>, <code>cegcsoport</code>,{" "}
          <code>boolean</code>, (opcionális) <code>atiranyitasok</code>.
        </p>
      </form>
    </main>
  );
}
