"use client";
import React, { useCallback, useEffect, useState } from "react";
import Input from "@/components/shared/input/Input";
import Button from "@/components/shared/button/Button";
import {
  VALIDATOR_REQUIRE,
  VALIDATOR_MINLENGTH,
  VALIDATOR_MAXLENGTH,
} from "@/utils/validators";
import { useForm } from "@/hooks/custom-form-hook";
import ApiCall from "@/api/api-calls";
import toast from "react-hot-toast";

const ExchangeRate = () => {
  const [data, setData] = useState(null);
  const [formState, handleInput] = useForm(data, false);

  useEffect(() => {
    const fetchRate = async () => {
      const response = await ApiCall.globals.getExchangeRateEdit();
      if (response.status === 200) {
        setData(response?.data?.body?.exchangeRate);
      } else {
        toast.error("Az adatok betöltése nem sikerült.");
      }
    };
    fetchRate();
  }, []);

  const handleFormSubmit = useCallback(() => {
    const ret = {
      newExchangeRate: formState.inputs.exchangeRate.value,
    };
    const fetchData = async () => {
      const response = await ApiCall.globals.postExchangeRateEdit(ret);
      if (response.status === 200) {
        toast.success(response?.data?.message);
      } else {
        toast.error(response?.data?.error);
      }
    };
    fetchData();
  }, [formState.inputs]);

  return (
    <>
      {data && (
        <>
          <div className="p-10">
            <h1 className="font-bold my-2">EUR-HUF átváltási összeg:</h1>
            <Input
              element="input"
              id="exchangeRate"
              type="number"
              name="exchangeRate"
              placeholder="EUR-HUF átváltási összeg"
              inputcls="w-full border-2 text-center p-2 my-2 outline-blue-500"
              className="w-100"
              validators={[
                VALIDATOR_REQUIRE(),
                VALIDATOR_MINLENGTH(2),
                VALIDATOR_MAXLENGTH(254),
              ]}
              errorText={"Nem lehet üres"}
              onInput={handleInput}
              initialValid={true}
              value={data?.exchangeRate}
            />

            <Button
              btntext={"Mentés"}
              disabled={!formState.isValid}
              onClick={handleFormSubmit}
              className="bg-blue-500/75 enabled:hover:bg-blue-500 px-4 py-2 text-white"
            />
          </div>
        </>
      )}
    </>
  );
};

export default ExchangeRate;
