"use client";
import React, { useState } from "react";
import ApiCall from "@/api/api-calls";
import toast from "react-hot-toast";
import SuneditorComponent from "@/components/shared/texteditor/SuneditorComponent";
import { useParams, useRouter } from "next/navigation";

const FrontendMessageCreate = () => {
  const [messageParts, setMessageParts] = useState([]);
  const [messageType, setMessageType] = useState("");
  const router = useRouter();

  const addPart = (type) => {
    setMessageParts([...messageParts, { type, content: "", key: "" }]);
  };
  const updateMessageType = (e) => setMessageType(e.target.value);
  const updatePart = (index, key, value) => {
    const updatedParts = [...messageParts];
    updatedParts[index][key] = value;
    setMessageParts(updatedParts);
  };

  const saveMessage = async () => {
    const response = await ApiCall.messages.putCreateFrontendMessage({
      messageParts,
      messageType,
    });
    if (response.status === 200) {
      toast.success(response.data.message || "Sikeres mentés.");
      router.push("/admin/frontend-messages/list");
    } else {
      toast.error(response.data.error || "Sikertelen mentés!");
    }
  };

  return (
    <div className="p-4">
      <h2 className="text-xl font-bold">
        Kosár szállítási információk szerkesztő
      </h2>
      <input
        type="text"
        name="messageType"
        placeholder="Üzenet típusa"
        value={messageType}
        onChange={(e) => updateMessageType(e)}
        className="border p-2 rounded w-full mb-4"
      />
      {messageParts.map((part, index) => (
        <div key={index} className="flex items-center gap-2 mb-2 w-full">
          {part.type === "text" ? (
            <SuneditorComponent
              lang={"en"}
              name={"content"}
              defaultValue={part.key}
              placeholder={"Ide gépelheti a szöveget..."}
              onChange={(value) => updatePart(index, "content", value)}
              options={{
                buttonList: [
                  ["font", "fontSize", "formatBlock"],
                  [
                    "bold",
                    "underline",
                    "italic",
                    "strike",
                    "subscript",
                    "superscript",
                  ],
                  ["align", "list", "table"],
                  ["fontColor", "hiliteColor"],
                  ["outdent", "indent"],
                  ["undo", "redo"],
                  ["removeFormat"],
                  ["link", "image"],
                  ["preview", "print"],
                  ["fullScreen", "showBlocks", "codeView"],
                ],
                tableWidth: "100%",
                tableStyles: {
                  border: "1px solid black",
                },
              }}
            />
          ) : (
            // <textarea
            //   type="text"
            //   placeholder="Static text"
            //   value={part.content}
            //   onChange={(e) => updatePart(index, "content", e.target.value)}
            //   className="border p-2 rounded w-full"
            // />
            <input
              type="text"
              placeholder="Variable key (e.g., name)"
              value={part.key}
              onChange={(e) => updatePart(index, "key", e.target.value)}
              className="border p-2 rounded w-full"
            />
          )}
        </div>
      ))}

      <div className="flex gap-2 mb-4">
        <button
          onClick={() => addPart("text")}
          className="px-3 py-1 bg-gray-500 text-white rounded">
          + Add Text
        </button>
        <button
          onClick={() => addPart("variable")}
          className="px-3 py-1 bg-blue-500 text-white rounded">
          + Add Variable
        </button>
      </div>

      <button
        onClick={saveMessage}
        className="mt-2 px-4 py-2 bg-green-600 text-white rounded">
        Save Message
      </button>
    </div>
  );
};

export default FrontendMessageCreate;
