"use client";
import "../globals.css";
import "material-icons/iconfont/material-icons.css";
import Sidebar from "@/components/layout/Sidebar";
// import TopNavBar from "@/components/layout/TopNavBar";
import SocketStatusNotifier from "@/components/SocketStatusNotifier";
import { MyApprovalsProvider } from "@/hooks/useMyApprovalsBadge";
import { useSelector } from "react-redux";
import { IRootState } from "@/store/store";
import clsx from "clsx";
import SocketNotifications from "@/components/socket/SocketNotifications";
import AdminChatFloatingWidget from "@/components/connected-users/AdminChatFloatingWidget";
import dynamic from "next/dynamic";

const TopNavBar = dynamic(() => import("@/components/layout/TopNavBar"), {
  ssr: false,
});
export default function RootLayout({ children }) {
  const { sidebar: isSidebarOpen } = useSelector(
    (s: IRootState) => s.themeConfig
  );

  return (
    <>
      <div className="h-screen">
        {/* Fixed Sidebar */}
        <Sidebar />

        {/* Content wrapper: shift by the sidebar width on lg+ screens */}
        <div
          className={clsx(
            "flex flex-col h-full w-auto relative overflow-x-auto overflow-y-hidden transition-all duration-300",
            // On mobile/tablet the sidebar overlays the content => no margin-left.
            // On lg+ we push content by 260px when open and 72px when collapsed.
            isSidebarOpen ? "lg:ml-[260px]" : "lg:ml-[72px]"
          )}>
          <TopNavBar />
          <main className="flex-1 p-4 overflow-y-auto bg-[#fafafa]">
            {children}
            <AdminChatFloatingWidget />
            {/* <SocketStatusNotifier /> */}
            <SocketNotifications />
          </main>
        </div>
      </div>

      <div id="modal-root"></div>
    </>
  );
}

// "use client";
// import "../globals.css";
// import "material-icons/iconfont/material-icons.css";
// import Sidebar from "@/components/layout/Sidebar";
// import TopNavBar from "@/components/layout/TopNavBar";
// import SocketStatusNotifier from "@/components/SocketStatusNotifier";

// export default function RootLayout({ children }) {
//   return (
//     <>
//       {/* Main Layout */}
//       <div className="flex h-screen">
//         {/* Sidebar */}
//         <Sidebar />
//         {/* Main Content Area */}
//         <div className="flex flex-col flex-1 h-full w-full relative overflow-x-auto overflow-y-hidden">
//           {/* Top Navbar */}
//           <TopNavBar />
//           {/* Main Content */}
//           <main className="flex-1 p-4 overflow-y-auto bg-gray-50">
//             {children}
//             <SocketStatusNotifier />
//           </main>
//         </div>
//       </div>
//       <div id="modal-root"></div>
//     </>
//   );
// }
