"use client";
import { useEffect, useState } from "react";
import ApiCall from "@/api/api-calls";

export default function MaintenanceMode() {
  const [maintenance, setMaintenance] = useState(false);
  const [loading, setLoading] = useState(true);
  const [saving, setSaving] = useState(false);

  const fetchStatus = async () => {
    try {
      const res = await ApiCall.layoutSettings.getMaintenanceStatus();
      const data = res.data;
      setMaintenance(data.maintenanceMode);
    } catch (error) {
      console.error("Failed to fetch status", error);
    } finally {
      setLoading(false);
    }
  };

  const toggleMaintenance = async () => {
    try {
      setSaving(true);
      const res = await ApiCall.layoutSettings.setMaintenanceStatus({
        enable: !maintenance,
      });
      const data = await res.data;
      setMaintenance(data.maintenanceMode);
    } catch (error) {
      console.error("Failed to toggle maintenance mode", error);
    } finally {
      setSaving(false);
    }
  };

  useEffect(() => {
    fetchStatus();
  }, []);

  return (
    <div className="p-10 max-w-xl mx-auto">
      <h1 className="text-3xl font-bold mb-6">🛠 Admin Settings</h1>

      {loading ? (
        <p>Loading maintenance status...</p>
      ) : (
        <div className="flex items-center gap-4">
          <span className="text-lg">
            Maintenance Mode:{" "}
            <strong className={maintenance ? "text-red-600" : "text-green-600"}>
              {maintenance ? "ENABLED" : "DISABLED"}
            </strong>
          </span>
          <button
            onClick={toggleMaintenance}
            disabled={saving}
            className="bg-blue-600 text-white px-4 py-2 rounded hover:bg-blue-700 transition">
            {saving ? "Saving..." : maintenance ? "Disable" : "Enable"}
          </button>
        </div>
      )}
    </div>
  );
}
