"use client";
import { useEffect, useState, useCallback } from "react";
import { useForm } from "@/hooks/custom-form-hook";
import Input from "@/components/shared/input/Input";
import ApiCall from "@/api/api-calls";
import { useRouter } from "next/navigation";
import toast from "react-hot-toast";
import {
  VALIDATOR_REQUIRE,
  VALIDATOR_MAXLENGTH,
  VALIDATOR_MINLENGTH,
  VALIDATOR_EMAIL,
  VALIDATOR_PHONE_HU,
  VALIDATOR_TAXNUMBER_HU,
} from "@/utils/validators";
import Select from "react-select";

const CreateCompanyGroup = () => {
  const router = useRouter();
  const [formState, handleInput] = useForm({}, false);
  const [companyOptions, setCompanyOptions] = useState([]);

  useEffect(() => {
    const fetchCompanies = async () => {
      try {
        const res = await ApiCall.ownCompanies.getAllNames();
        if (res.status === 200) {
          setCompanyOptions(res.data.companies);
        }
      } catch (error) {
        console.error("Failed to load companies", error);
      }
    };
    fetchCompanies();
  }, []);

  const handleSubmit = async () => {
    const payload = Object.fromEntries(
      Object.entries(formState.inputs).map(([k, v]) => [k, v.value])
    );

    const res = await ApiCall.ownCompanyGroups.postSave(payload);
    if (res.status === 200) {
      toast.success("Mentés sikeres");
      router.push("/admin/own-company-group/list");
    } else {
      toast.error(res.data?.error || "Hiba történt");
    }
  };

  return (
    <div className="p-6 max-w-2xl mx-auto">
      <h2 className="text-xl font-bold mb-4">Új cégcsoport</h2>
      <Input
        element="input"
        id="name"
        type="text"
        name="name"
        placeholder="Cégcsoport neve"
        validators={[VALIDATOR_REQUIRE(), VALIDATOR_MINLENGTH(2)]}
        errorText="Kötelező mező"
        initialValid={false}
        onInput={handleInput}
      />
      <Input
        id="description"
        name="description"
        placeholder="Leírás"
        element="textarea"
        onInput={handleInput}
        initialValid={true}
      />
      <div className="mb-4">
        <label className="text-sm text-gray-600 mb-1 block">
          Cégcsoport cégeinek kiválasztása (opcionális):
        </label>
        <Select
          id="company_ids"
          name="company_ids"
          options={companyOptions}
          isClearable
          isMulti
          placeholder="Válassz cégeket a cégcsoportba"
          onChange={(selected) => {
            const selectedIds = selected?.map((opt) => opt.value) || [];
            handleInput("company_ids", selectedIds, true);
          }}
        />
      </div>
      <button
        className="mt-4 bg-green-600 hover:bg-green-700 text-white px-4 py-2 rounded"
        onClick={handleSubmit}
        disabled={!formState.isValid}>
        Mentés
      </button>
    </div>
  );
};
export default CreateCompanyGroup;
