"use client";

import { useRef, useState } from "react";
import ApiCall from "@/api/api-calls";
import toast from "react-hot-toast";

const UploadPage = () => {
  const fileInputRef = useRef(null);
  const [uploadStatus, setUploadStatus] = useState(null);

  const handleSubmit = async (e) => {
    e.preventDefault();
    setUploadStatus("Uploading...");

    const formData = new FormData();
    const file = fileInputRef.current.files[0];
    if (!file) {
      setUploadStatus("No file selected");
      return;
    }

    formData.append("file", file);

    try {
      const res = await ApiCall.partnerCompanies.upload(formData);
      console.log("res", res);
      if (res.statusText === "OK") {
        const summary = res.data.summary;
        setUploadStatus(
          `Sikeres feltöltés! Új sorok száma: ${summary.inserted}, kihagyva: ${
            summary.skipped
          }${
            summary.updated !== undefined
              ? `, frissítve: ${summary.updated}`
              : ""
          }`
        );
        toast.success();
      } else {
        setUploadStatus(`❌ Failed: ${res.error || "Unknown error"}`);
      }
    } catch (error) {
      console.error("Upload error:", error);
      setUploadStatus("❌ Upload failed.");
    }
  };

  return (
    <main className="max-w-lg mx-auto py-10 px-4">
      <h1 className="text-2xl font-bold mb-4">Upload Excel File</h1>
      <form onSubmit={handleSubmit} className="space-y-4">
        <input
          type="file"
          name="file"
          accept=".xlsx"
          ref={fileInputRef}
          className="block w-full border rounded px-3 py-2"
        />
        <button
          type="submit"
          className="bg-blue-600 text-white px-4 py-2 rounded hover:bg-blue-700">
          Upload
        </button>
        {uploadStatus && <p className="mt-2 text-sm">{uploadStatus}</p>}
      </form>
    </main>
  );
};
export default UploadPage;
