// src/app/admin/phone-registry/create/page.tsx
"use client";

import { useRouter } from "next/navigation";
import { useState } from "react";
import toast from "react-hot-toast";
import ApiCall from "@/api/api-calls";
import PhoneRegistryForm, {
  PhoneUpsertPayload,
} from "@/components/phone-registry/PhoneRegistryForm";

export default function PhoneRegistryCreatePage() {
  const router = useRouter();
  const [saving, setSaving] = useState(false);

  const handleSubmit = async (payload: PhoneUpsertPayload) => {
    setSaving(true);
    try {
      await ApiCall.phoneRegistry.upsert(payload);
      toast.success("Új telefonszám mentve");
      router.push("/admin/phone-registry/list");
    } catch (e: any) {
      console.error(e);
      toast.error(e?.response?.data?.message || "Mentés sikertelen");
    } finally {
      setSaving(false);
    }
  };

  return (
    <main className="p-4 space-y-4">
      <h1 className="text-xl font-semibold">Új telefonvonal</h1>
      <PhoneRegistryForm initial={{}} onSubmit={handleSubmit} saving={saving} />
    </main>
  );
}
