// app/api/export-contracts/route.js
import { NextResponse } from "next/server";
import path from "path";
import fs from "fs";
import exportContractsToExcel from "@/scripts/exportContracts"; // adjust if your TS config isn't set up for @
import { cwd } from "process"; // gets the project root

export async function GET() {
  try {
    const contractsRoot =
      process.env.CONTRACTS_PATH || path.join(cwd(), "public", "upload");
    const outputFile = path.join("/tmp", `contracts-${Date.now()}.xlsx`);

    await exportContractsToExcel(contractsRoot, outputFile);

    const fileBuffer = fs.readFileSync(outputFile);

    // Remove the temporary file after reading
    fs.unlinkSync(outputFile);

    return new NextResponse(fileBuffer, {
      status: 200,
      headers: {
        "Content-Disposition": 'attachment; filename="contracts.xlsx"',
        "Content-Type":
          "application/vnd.openxmlformats-officedocument.spreadsheetml.sheet",
      },
    });
  } catch (err) {
    console.error(err);
    return NextResponse.json({ error: "Export failed" }, { status: 500 });
  }
}
