"use client";
import { Provider } from "react-redux";
import { makeStore } from "@/store/store";
import { AuthProvider } from "@/context/AuthContext";
import { PageEditorProvider } from "@/context/PageEditorContext";
import { Toaster } from "react-hot-toast";
import SocketMessageHandler from "@/components/SocketMessageHandler";
import SocketStatusBanner from "@/components/features/socket-status/SocketStatusBanner";
import { MyApprovalsProvider } from "@/hooks/useMyApprovalsBadge";
import { AdminMenuProvider } from "@/hooks/useAdminMenu";

const store = makeStore();

export default function Providers({ children }) {
  return (
    <AuthProvider>
      <AdminMenuProvider>
        <Provider store={store}>
          <MyApprovalsProvider>
            <PageEditorProvider>
              {children}
              <SocketMessageHandler />
              {/* <SocketStatusBanner /> */}
            </PageEditorProvider>
          </MyApprovalsProvider>
        </Provider>
        <Toaster position="bottom-right" toastOptions={{ duration: 4000 }} />
      </AdminMenuProvider>
    </AuthProvider>
  );
}
