const icons = {
  menu: (
    <svg
      xmlns="http://www.w3.org/2000/svg"
      width="100%"
      height="100%"
      viewBox="0 0 30 30"
      className="pointer-events-none">
      <rect className="hide" x="5" y="7" width="20" height="3"></rect>
      <rect className="turn rightr" x="5" y="13" width="20" height="3"></rect>
      <rect className="turn leftr" x="5" y="13" width="20" height="3"></rect>
      <rect className="hide" x="5" y="19" width="20" height="3"></rect>
    </svg>
  ),
  home: (
    <svg
      xmlns="http://www.w3.org/2000/svg"
      width="100%"
      height="100%"
      viewBox="0 0 24 24"
      fillRule="evenodd"
      clipRule="evenodd"
      className="pointer-events-none ">
      <path d="M22 11.414v12.586h-20v-12.586l-1.293 1.293-.707-.707 12-12 12 12-.707.707-1.293-1.293zm-6 11.586h5v-12.586l-9-9-9 9v12.586h5v-9h8v9zm-1-7.889h-6v7.778h6v-7.778z" />
    </svg>
  ),
  user: (
    <svg
      xmlns="http://www.w3.org/2000/svg"
      width="100%"
      height="100%"
      viewBox="0 0 24 24"
      fillRule="evenodd"
      clipRule="evenodd"
      className="pointer-events-none ">
      <path d="M12 0c-5.083 0-8.465 4.949-3.733 13.678 1.596 2.945-1.725 3.641-5.09 4.418-3.073.709-3.187 2.235-3.177 4.904l.004 1h23.99l.004-.969c.012-2.688-.093-4.223-3.177-4.935-3.438-.794-6.639-1.49-5.09-4.418 4.719-8.912 1.251-13.678-3.731-13.678m0 1c1.89 0 3.39.764 4.225 2.15 1.354 2.251.866 5.824-1.377 10.06-.577 1.092-.673 2.078-.283 2.932.937 2.049 4.758 2.632 6.032 2.928 2.303.534 2.412 1.313 2.401 3.93h-21.998c-.01-2.615.09-3.396 2.401-3.93 1.157-.266 5.138-.919 6.049-2.94.387-.858.284-1.843-.304-2.929-2.231-4.115-2.744-7.764-1.405-10.012.84-1.412 2.353-2.189 4.259-2.189" />
    </svg>
  ),
  email: (
    <svg
      xmlns="http://www.w3.org/2000/svg"
      width="100%"
      viewBox="0 0 24 24"
      height="100%"
      className="pointer-events-none "
      fillRule="evenodd"
      clipRule="evenodd">
      <path d="M24 21h-24v-18h24v18zm-23-16.477v15.477h22v-15.477l-10.999 10-11.001-10zm21.089-.523h-20.176l10.088 9.171 10.088-9.171z" />
    </svg>
  ),
  upload: (
    <svg
      xmlns="http://www.w3.org/2000/svg"
      width="100%"
      height="100%"
      fill="currentColor"
      className="bi bi-upload pointer-events-none"
      viewBox="0 0 16 16">
      <path d="M.5 9.9a.5.5 0 0 1 .5.5v2.5a1 1 0 0 0 1 1h12a1 1 0 0 0 1-1v-2.5a.5.5 0 0 1 1 0v2.5a2 2 0 0 1-2 2H2a2 2 0 0 1-2-2v-2.5a.5.5 0 0 1 .5-.5z" />
      <path d="M7.646 1.146a.5.5 0 0 1 .708 0l3 3a.5.5 0 0 1-.708.708L8.5 2.707V11.5a.5.5 0 0 1-1 0V2.707L5.354 4.854a.5.5 0 1 1-.708-.708l3-3z" />
    </svg>
  ),
  plus: (
    <svg
      xmlns="http://www.w3.org/2000/svg"
      fillRule="evenodd"
      clipRule="evenodd"
      width="100%"
      height="100%"
      viewBox="0 0 24 24"
      className="pointer-events-none">
      <path d="M11.5 0c6.347 0 11.5 5.153 11.5 11.5s-5.153 11.5-11.5 11.5-11.5-5.153-11.5-11.5 5.153-11.5 11.5-11.5zm0 1c5.795 0 10.5 4.705 10.5 10.5s-4.705 10.5-10.5 10.5-10.5-4.705-10.5-10.5 4.705-10.5 10.5-10.5zm.5 10h6v1h-6v6h-1v-6h-6v-1h6v-6h1v6z"></path>
    </svg>
  ),
  clone: (
    <svg
      width="100%"
      height="100%"
      className="pointer-events-none"
      clipRule="evenodd"
      fillRule="evenodd"
      strokeLinejoin="round"
      strokeMiterlimit="2"
      viewBox="0 0 24 24"
      xmlns="http://www.w3.org/2000/svg">
      <path
        d="m6 19v2c0 .621.52 1 1 1h2v-1.5h-1.5v-1.5zm7.5 3h-3.5v-1.5h3.5zm4.5 0h-3.5v-1.5h3.5zm4-3h-1.5v1.5h-1.5v1.5h2c.478 0 1-.379 1-1zm-1.5-1v-3.363h1.5v3.363zm0-4.363v-3.637h1.5v3.637zm-13-3.637v3.637h-1.5v-3.637zm11.5-4v1.5h1.5v1.5h1.5v-2c0-.478-.379-1-1-1zm-10 0h-2c-.62 0-1 .519-1 1v2h1.5v-1.5h1.5zm4.5 1.5h-3.5v-1.5h3.5zm3-1.5v-2.5h-13v13h2.5v-1.863h1.5v3.363h-4.5c-.48 0-1-.379-1-1v-14c0-.481.38-1 1-1h14c.621 0 1 .522 1 1v4.5h-3.5v-1.5z"
        fillRule="nonzero"
      />
    </svg>
  ),
  minus: (
    <svg
      xmlns="http://www.w3.org/2000/svg"
      fillRule="evenodd"
      clipRule="evenodd"
      width="100%"
      height="100%"
      viewBox="0 0 24 24"
      className="pointer-events-none ">
      <path d="M11.5 0c6.347 0 11.5 5.153 11.5 11.5s-5.153 11.5-11.5 11.5-11.5-5.153-11.5-11.5 5.153-11.5 11.5-11.5zm0 1c5.795 0 10.5 4.705 10.5 10.5s-4.705 10.5-10.5 10.5-10.5-4.705-10.5-10.5 4.705-10.5 10.5-10.5zm-6.5 10h13v1h-13v-1z"></path>
    </svg>
  ),
  clear: (
    <svg
      xmlns="http://www.w3.org/2000/svg"
      width="100%"
      viewBox="0 0 24 24"
      height="100%"
      fillRule="evenodd"
      clipRule="evenodd"
      className="pointer-events-none">
      <path d="M12 11.293l10.293-10.293.707.707-10.293 10.293 10.293 10.293-.707.707-10.293-10.293-10.293 10.293-.707-.707 10.293-10.293-10.293-10.293.707-.707 10.293 10.293z" />
    </svg>
  ),
  change: (
    <svg
      xmlns="http://www.w3.org/2000/svg"
      width="100%"
      height="100%"
      viewBox="0 0 40 40"
      className="pointer-events-none change">
      <polygon
        points="18 12.5 24 9 22 12.5 24 16 18 12.5"
        style={{ fill: "#157efc" }}></polygon>
      <polygon
        points="24 28.5 18 32 20 28.5 18 25 24 28.5"
        style={{ fill: "#157efc" }}></polygon>
      <polyline
        points="21 28.5 12.5 28.5 12.5 12.5 16 12.5"
        style={{ fill: "none", stroke: "#157efc" }}></polyline>
      <polyline
        points="21 12.5 28.5 12.5 28.5 28.5 26 28.5"
        style={{ fill: "none", stroke: "#157efc" }}></polyline>
    </svg>
  ),
  move: (
    <svg
      xmlns="http://www.w3.org/2000/svg"
      width="100%"
      height="100%"
      viewBox="0 0 24 24"
      className="pointer-events-none "
      style={{ fill: "rgb(8 145 178)" }}>
      <path d="M6 6h-6v-6h6v6zm9-6h-6v6h6v-6zm9 0h-6v6h6v-6zm-18 9h-6v6h6v-6zm9 0h-6v6h6v-6zm9 0h-6v6h6v-6zm-18 9h-6v6h6v-6zm9 0h-6v6h6v-6zm9 0h-6v6h6v-6z" />
    </svg>
  ),
  up: (
    <svg
      xmlns="http://www.w3.org/2000/svg"
      width="100%"
      height="100%"
      viewBox="0 0 24 24"
      className="pointer-events-none "
      fillRule="evenodd"
      clipRule="evenodd">
      <path d="M11 2.206l-6.235 7.528-.765-.645 7.521-9 7.479 9-.764.646-6.236-7.53v21.884h-1v-21.883z" />
    </svg>
  ),
  down: (
    <svg
      xmlns="http://www.w3.org/2000/svg"
      width="100%"
      height="100%"
      viewBox="0 0 24 24"
      className="pointer-events-none "
      fillRule="evenodd"
      clipRule="evenodd">
      <path d="M11 21.883l-6.235-7.527-.765.644 7.521 9 7.479-9-.764-.645-6.236 7.529v-21.884h-1v21.883z" />
    </svg>
  ),
  left: (
    <svg
      xmlns="http://www.w3.org/2000/svg"
      width="100%"
      height="100%"
      viewBox="0 0 24 24"
      className="pointer-events-none "
      fillRule="evenodd"
      clipRule="evenodd">
      <path d="M2.117 12l7.527 6.235-.644.765-9-7.521 9-7.479.645.764-7.529 6.236h21.884v1h-21.883z" />
    </svg>
  ),
  right: (
    <svg
      xmlns="http://www.w3.org/2000/svg"
      width="100%"
      height="100%"
      viewBox="0 0 24 24"
      className="pointer-events-none "
      fillRule="evenodd"
      clipRule="evenodd">
      <path d="M21.883 12l-7.527 6.235.644.765 9-7.521-9-7.479-.645.764 7.529 6.236h-21.884v1h21.883z" />
    </svg>
  ),
  edit: (
    <svg
      xmlns="http://www.w3.org/2000/svg"
      width="100%"
      height="100%"
      className="pointer-events-none "
      viewBox="0 0 24 24">
      <path d="M7.127 22.564l-7.126 1.436 1.438-7.125 5.688 5.689zm-4.274-7.104l5.688 5.689 15.46-15.46-5.689-5.689-15.459 15.46z" />
    </svg>
  ),
  trash: (
    <svg
      xmlns="http://www.w3.org/2000/svg"
      width="100%"
      height="100%"
      className="pointer-events-none "
      viewBox="0 0 24 24">
      <path d="M9 19c0 .552-.448 1-1 1s-1-.448-1-1v-10c0-.552.448-1 1-1s1 .448 1 1v10zm4 0c0 .552-.448 1-1 1s-1-.448-1-1v-10c0-.552.448-1 1-1s1 .448 1 1v10zm4 0c0 .552-.448 1-1 1s-1-.448-1-1v-10c0-.552.448-1 1-1s1 .448 1 1v10zm5-17v2h-20v-2h5.711c.9 0 1.631-1.099 1.631-2h5.315c0 .901.73 2 1.631 2h5.712zm-3 4v16h-14v-16h-2v18h18v-18h-2z" />
    </svg>
  ),
  preview: (
    <svg
      xmlns="http://www.w3.org/2000/svg"
      width="100%"
      height="100%"
      className="pointer-events-none "
      viewBox="0 0 24 24">
      <path d="M12.015 7c4.751 0 8.063 3.012 9.504 4.636-1.401 1.837-4.713 5.364-9.504 5.364-4.42 0-7.93-3.536-9.478-5.407 1.493-1.647 4.817-4.593 9.478-4.593zm0-2c-7.569 0-12.015 6.551-12.015 6.551s4.835 7.449 12.015 7.449c7.733 0 11.985-7.449 11.985-7.449s-4.291-6.551-11.985-6.551zm-.015 5c1.103 0 2 .897 2 2s-.897 2-2 2-2-.897-2-2 .897-2 2-2zm0-2c-2.209 0-4 1.792-4 4 0 2.209 1.791 4 4 4s4-1.791 4-4c0-2.208-1.791-4-4-4z" />
    </svg>
  ),
  clock: (
    <svg
      xmlns="http://www.w3.org/2000/svg"
      width="100%"
      height="100%"
      className="pointer-events-none "
      fillRule="evenodd"
      clipRule="evenodd">
      <path d="M12 0c6.623 0 12 5.377 12 12s-5.377 12-12 12-12-5.377-12-12 5.377-12 12-12zm0 1c6.071 0 11 4.929 11 11s-4.929 11-11 11-11-4.929-11-11 4.929-11 11-11zm0 11h6v1h-7v-9h1v8z" />
    </svg>
  ),
  submenu: (
    <svg
      xmlns="http://www.w3.org/2000/svg"
      width="100%"
      height="100%"
      className="pointer-events-none size-12"
      viewBox="0 0 24 24">
      <path d="M0 7.33l2.829-2.83 9.175 9.339 9.167-9.339 2.829 2.83-11.996 12.17z" />
    </svg>
  ),
  word: (
    <svg
      xmlns="http://www.w3.org/2000/svg"
      viewBox="0 0 64 64"
      width="100%"
      height="100%"
      className="pointer-events-none">
      <radialGradient
        id="oh5rQBLtPGcKsWd6BdZgSa"
        cx="32"
        cy="31.5"
        r="31.259"
        gradientUnits="userSpaceOnUse">
        <stop offset="0" stopColor="#f7e9c2" />
        <stop offset=".644" stopColor="#fff3db" />
        <stop offset="1" stopColor="#fff5e0" />
      </radialGradient>
      <path
        fill="url(#oh5rQBLtPGcKsWd6BdZgSa)"
        d="M55,43l-2.983,0c-1.308,0-2.499-0.941-2.629-2.243C49.238,39.261,50.409,38,51.875,38 l6.755,0c1.451,0,2.789-0.972,3.071-2.395C62.081,33.693,60.609,32,58.761,32H50v-8h11c1.657,0,3-1.343,3-3v0c0-1.657-1.343-3-3-3 l-5,0v-4l2.118,0c1.308,0,2.5-0.942,2.63-2.243C60.898,10.26,59.727,9,58.261,9H44.5C43.672,9,43,8.328,43,7.5S43.672,6,44.5,6 l3.857,0c1.308,0,2.5-0.942,2.63-2.243C51.136,2.26,49.966,1,48.5,1L15.643,1c-1.308,0-2.5,0.942-2.63,2.243 C12.864,4.74,14.034,6,15.5,6l3.75,0c1.308,0,2.499,0.941,2.63,2.242C22.03,9.739,20.859,11,19.393,11L6.126,11 c-1.457,0-2.803,0.975-3.083,2.405C2.669,15.312,4.14,17,5.984,17l1.766,0c2.089,0,3.955,1.527,4.153,3.607 C12.131,22.993,10.261,25,7.922,25L7,25v8h1.5c3.038,0,5.5,2.462,5.5,5.5v0c0,3.038-2.462,5.5-5.5,5.5H6.131 c-1.451,0-2.789,0.972-3.071,2.395C2.681,48.307,4.152,50,6,50c0.603,0,2,0,3.5,0s2,1.498,2,2c0,1.105-0.895,2-2,2l-5.31,0 c-2.086,0-3.959,1.514-4.169,3.59C-0.22,59.972,1.665,62,4,62h55.5c2.485,0,4.5-2.015,4.5-4.5v0c0-2.485-2.015-4.5-4.5-4.5H55V43z"
      />
      <linearGradient
        id="oh5rQBLtPGcKsWd6BdZgSb"
        x1="36"
        x2="36"
        y1="22"
        y2="8"
        gradientUnits="userSpaceOnUse">
        <stop offset="0" stopColor="#56aeee" />
        <stop offset="1" stopColor="#3694d9" />
      </linearGradient>
      <path
        fill="url(#oh5rQBLtPGcKsWd6BdZgSb)"
        d="M16,10v12h40V10c0-1.105-0.895-2-2-2H18 C16.895,8,16,8.895,16,10z"
      />
      <linearGradient
        id="oh5rQBLtPGcKsWd6BdZgSc"
        x1="36"
        x2="36"
        y1="34"
        y2="20"
        gradientUnits="userSpaceOnUse">
        <stop offset="0" stopColor="#2c7fd9" />
        <stop offset="1" stopColor="#2a78cc" />
      </linearGradient>
      <path fill="url(#oh5rQBLtPGcKsWd6BdZgSc)" d="M56,20H16v14h40V20z" />
      <linearGradient
        id="oh5rQBLtPGcKsWd6BdZgSd"
        x1="36"
        x2="36"
        y1="46"
        y2="32"
        gradientUnits="userSpaceOnUse">
        <stop offset="0" stopColor="#195ec4" />
        <stop offset="1" stopColor="#1759ba" />
      </linearGradient>
      <path fill="url(#oh5rQBLtPGcKsWd6BdZgSd)" d="M16,32v14h40V32H16z" />
      <linearGradient
        id="oh5rQBLtPGcKsWd6BdZgSe"
        x1="36"
        x2="36"
        y1="56"
        y2="44"
        gradientUnits="userSpaceOnUse">
        <stop offset="0" stopColor="#1348a8" />
        <stop offset="1" stopColor="#104196" />
      </linearGradient>
      <path
        fill="url(#oh5rQBLtPGcKsWd6BdZgSe)"
        d="M18,56h36c1.105,0,2-0.895,2-2V44H16v10 C16,55.105,16.895,56,18,56z"
      />
      <linearGradient
        id="oh5rQBLtPGcKsWd6BdZgSf"
        x1="-402.119"
        x2="-400.786"
        y1="-347.143"
        y2="-347.143"
        gradientTransform="matrix(0 -14 -14 0 -4836 -5606)"
        gradientUnits="userSpaceOnUse">
        <stop offset="0" stopColor="#4d9cd6" />
        <stop offset="1" stopColor="#2a79ce" />
        <stop offset="1" stopColor="#3085c3" />
      </linearGradient>
      <path
        fill="url(#oh5rQBLtPGcKsWd6BdZgSf)"
        d="M16,17l0,4h16l0-2c0-1.105-0.895-2-2-2H16 z"
      />
      <linearGradient
        id="oh5rQBLtPGcKsWd6BdZgSg"
        x1="-402.083"
        x2="-401"
        y1="-347.143"
        y2="-347.143"
        gradientTransform="matrix(0 -14 -14 0 -4836 -5594)"
        gradientUnits="userSpaceOnUse">
        <stop offset="0" stopColor="#0b3463" />
        <stop offset="0" stopColor="#1f5999" />
        <stop offset="1" stopColor="#1858ba" />
      </linearGradient>
      <rect
        width="16"
        height="13"
        x="16"
        y="20"
        fill="url(#oh5rQBLtPGcKsWd6BdZgSg)"
      />
      <linearGradient
        id="oh5rQBLtPGcKsWd6BdZgSh"
        x1="-402.083"
        x2="-401"
        y1="-347.143"
        y2="-347.143"
        gradientTransform="matrix(0 -14 -14 0 -4836 -5582)"
        gradientUnits="userSpaceOnUse">
        <stop offset="0" stopColor="#12458f" />
        <stop offset="1" stopColor="#134897" />
        <stop offset="1" stopColor="#0b2a59" />
      </linearGradient>
      <rect
        width="16"
        height="13"
        x="16"
        y="32"
        fill="url(#oh5rQBLtPGcKsWd6BdZgSh)"
      />
      <linearGradient
        id="oh5rQBLtPGcKsWd6BdZgSi"
        x1="-399"
        x2="-398"
        y1="-349"
        y2="-349"
        gradientTransform="matrix(0 -12 -12 0 -4164 -4732)"
        gradientUnits="userSpaceOnUse">
        <stop offset="0" stopColor="#114197" />
        <stop offset="0" stopColor="#114197" />
        <stop offset="1" stopColor="#0d367c" />
      </linearGradient>
      <path
        fill="url(#oh5rQBLtPGcKsWd6BdZgSi)"
        d="M32,44l-16,0v5h14c1.105,0,2-0.895,2-2V44"
      />
      <linearGradient
        id="oh5rQBLtPGcKsWd6BdZgSj"
        x1="17"
        x2="17"
        y1="-891.11"
        y2="-865.11"
        gradientTransform="translate(0 910.11)"
        gradientUnits="userSpaceOnUse">
        <stop offset="0" stopColor="#2368c4" />
        <stop offset="1" stopColor="#1146ac" />
      </linearGradient>
      <path
        fill="url(#oh5rQBLtPGcKsWd6BdZgSj)"
        d="M6,19h22c1.105,0,2,0.895,2,2v22 c0,1.105-0.895,2-2,2H6c-1.105,0-2-0.895-2-2V21C4,19.895,4.895,19,6,19z"
      />
      <path
        fill="#fff"
        d="M26.132,25h-1.868c-0.239,0-0.444,0.169-0.49,0.403l-2.088,10.563l-2.639-10.583 c-0.056-0.223-0.256-0.379-0.485-0.379h-2.206c-0.232,0-0.433,0.159-0.487,0.385l-2.517,10.627l-2.26-10.616 c-0.049-0.231-0.253-0.396-0.489-0.396H8.68c-0.227,0-0.393,0.212-0.34,0.432l3.184,13.178c0.054,0.224,0.255,0.383,0.486,0.383 h2.444c0.233,0,0.435-0.16,0.487-0.387l2.425-10.456l2.574,10.465C19.994,38.843,20.195,39,20.425,39h2.395 c0.231,0,0.432-0.159,0.486-0.383l3.167-13.185C26.526,25.212,26.359,25,26.132,25z"
      />
    </svg>
  ),
  excel: (
    <svg
      xmlns="http://www.w3.org/2000/svg"
      viewBox="0 0 64 64"
      width="100%"
      height="100%"
      className="pointer-events-none">
      <path
        fill="#169154"
        d="M29,6H15.744C14.781,6,14,6.781,14,7.744v7.259h15V6z"
      />
      <path
        fill="#18482a"
        d="M14,33.054v7.202C14,41.219,14.781,42,15.743,42H29v-8.946H14z"
      />
      <path fill="#0c8045" d="M14 15.003H29V24.005000000000003H14z" />
      <path fill="#17472a" d="M14 24.005H29V33.055H14z" />
      <g>
        <path
          fill="#29c27f"
          d="M42.256,6H29v9.003h15V7.744C44,6.781,43.219,6,42.256,6z"
        />
        <path
          fill="#27663f"
          d="M29,33.054V42h13.257C43.219,42,44,41.219,44,40.257v-7.202H29z"
        />
        <path fill="#19ac65" d="M29 15.003H44V24.005000000000003H29z" />
        <path fill="#129652" d="M29 24.005H44V33.055H29z" />
      </g>
      <path
        fill="#0c7238"
        d="M22.319,34H5.681C4.753,34,4,33.247,4,32.319V15.681C4,14.753,4.753,14,5.681,14h16.638 C23.247,14,24,14.753,24,15.681v16.638C24,33.247,23.247,34,22.319,34z"
      />
      <path
        fill="#fff"
        d="M9.807 19L12.193 19 14.129 22.754 16.175 19 18.404 19 15.333 24 18.474 29 16.123 29 14.013 25.07 11.912 29 9.526 29 12.719 23.982z"
      />
    </svg>
  ),
  search: (
    <svg
      xmlns="http://www.w3.org/2000/svg"
      width="100%"
      height="100%"
      viewBox="0 0 24 24"
      fillRule="evenodd"
      clipRule="evenodd">
      <path d="M15.853 16.56c-1.683 1.517-3.911 2.44-6.353 2.44-5.243 0-9.5-4.257-9.5-9.5s4.257-9.5 9.5-9.5 9.5 4.257 9.5 9.5c0 2.442-.923 4.67-2.44 6.353l7.44 7.44-.707.707-7.44-7.44zm-6.353-15.56c4.691 0 8.5 3.809 8.5 8.5s-3.809 8.5-8.5 8.5-8.5-3.809-8.5-8.5 3.809-8.5 8.5-8.5z" />
    </svg>
  ),
  cart: (
    <svg
      xmlns="http://www.w3.org/2000/svg"
      width="100%"
      height="100%"
      viewBox="0 0 24 24">
      <path d="M8 9h-7.161l-.839-2h8v2zm0 2h-6.322l.839 2h5.483v-2zm8.53-4h-6.53v2h5.966l.564-2zm-1.694 6l.564-2h-5.4v2h4.836zm-6.336 5c-.828 0-1.5.672-1.5 1.5 0 .829.672 1.5 1.5 1.5s1.5-.671 1.5-1.5c0-.828-.672-1.5-1.5-1.5zm11.305-15l-3.432 12h-13.017l.839 2h13.659l3.474-12h1.929l.743-2h-4.195zm-6.305 15c-.828 0-1.5.671-1.5 1.5s.672 1.5 1.5 1.5 1.5-.671 1.5-1.5c0-.828-.672-1.5-1.5-1.5z"></path>
    </svg>
  ),
  chevronRight: (
    <svg
      xmlns="http://www.w3.org/2000/svg"
      width="100%"
      height="100%"
      viewBox="0 0 24 24"
      fillRule="evenodd"
      clipRule="evenodd"
      className="pointer-events-none">
      <path d="M4 .755l14.374 11.245-14.374 11.219.619.781 15.381-12-15.391-12-.609.755z" />
    </svg>
  ),
  chevronDown: (
    <svg
      width="100%"
      height="100%"
      viewBox="0 0 24 24"
      xmlns="http://www.w3.org/2000/svg"
      fillRule="evenodd"
      clipRule="evenodd">
      <path d="M23.245 4l-11.245 14.374-11.219-14.374-.781.619 12 15.381 12-15.391-.755-.609z" />
    </svg>
  ),
  chevronUp: (
    <svg
      width="100%"
      height="100%"
      viewBox="0 0 24 24"
      xmlns="http://www.w3.org/2000/svg"
      fillRule="evenodd"
      clipRule="evenodd">
      <path d="M23.245 20l-11.245-14.374-11.219 14.374-.781-.619 12-15.381 12 15.391-.755.609z" />
    </svg>
  ),
  checkMark: (
    <svg
      xmlns="http://www.w3.org/2000/svg"
      width="100%"
      height="100%"
      fillRule="evenodd"
      clipRule="evenodd"
      className="pointer-events-none">
      <path d="M19 22h-19v-19h19v2h-1v-1h-17v17h17v-9.502h1v10.502zm5-19.315l-14.966 15.872-5.558-6.557.762-.648 4.833 5.707 14.201-15.059.728.685z" />
    </svg>
  ),
  emptyBox: (
    <svg
      xmlns="http://www.w3.org/2000/svg"
      width="100%"
      height="100%"
      clipRule="evenodd"
      fillRule="evenodd"
      strokeLinejoin="round"
      strokeMiterlimit="2"
      viewBox="0 0 24 24"
      className="pointer-events-none">
      <path
        d="m21 4c0-.478-.379-1-1-1h-16c-.62 0-1 .519-1 1v16c0 .621.52 1 1 1h16c.478 0 1-.379 1-1zm-16.5.5h15v15h-15z"
        fillRule="nonzero"
      />
    </svg>
  ),
  eye: (
    <svg
      xmlns="http://www.w3.org/2000/svg"
      className="pointer-events-none"
      width="100%"
      height="100%"
      clipRule="evenodd"
      fillRule="evenodd"
      strokeLinejoin="round"
      strokeMiterlimit="2"
      viewBox="0 0 24 24">
      <path
        d="m11.998 5c-4.078 0-7.742 3.093-9.853 6.483-.096.159-.145.338-.145.517s.048.358.144.517c2.112 3.39 5.776 6.483 9.854 6.483 4.143 0 7.796-3.09 9.864-6.493.092-.156.138-.332.138-.507s-.046-.351-.138-.507c-2.068-3.403-5.721-6.493-9.864-6.493zm8.413 7c-1.837 2.878-4.897 5.5-8.413 5.5-3.465 0-6.532-2.632-8.404-5.5 1.871-2.868 4.939-5.5 8.404-5.5 3.518 0 6.579 2.624 8.413 5.5zm-8.411-4c2.208 0 4 1.792 4 4s-1.792 4-4 4-4-1.792-4-4 1.792-4 4-4zm0 1.5c-1.38 0-2.5 1.12-2.5 2.5s1.12 2.5 2.5 2.5 2.5-1.12 2.5-2.5-1.12-2.5-2.5-2.5z"
        fillRule="nonzero"></path>
    </svg>
  ),
  closedEye: (
    <svg
      xmlns="http://www.w3.org/2000/svg"
      className="pointer-events-none"
      width="100%"
      height="100%"
      clipRule="evenodd"
      fillRule="evenodd"
      strokeLinejoin="round"
      strokeMiterlimit="2"
      viewBox="0 0 24 24">
      <path
        d="m17.069 6.546 2.684-2.359c.143-.125.32-.187.497-.187.418 0 .75.34.75.75 0 .207-.086.414-.254.562l-16.5 14.501c-.142.126-.319.187-.496.187-.415 0-.75-.334-.75-.75 0-.207.086-.414.253-.562l2.438-2.143c-1.414-1.132-2.627-2.552-3.547-4.028-.096-.159-.144-.338-.144-.517s.049-.358.145-.517c2.111-3.39 5.775-6.483 9.853-6.483 1.815 0 3.536.593 5.071 1.546zm2.319 1.83c.966.943 1.803 2.014 2.474 3.117.092.156.138.332.138.507s-.046.351-.138.507c-2.068 3.403-5.721 6.493-9.864 6.493-1.297 0-2.553-.313-3.729-.849l1.247-1.096c.795.285 1.626.445 2.482.445 3.516 0 6.576-2.622 8.413-5.5-.595-.932-1.318-1.838-2.145-2.637zm-3.434 3.019c.03.197.046.399.046.605 0 2.208-1.792 4-4 4-.384 0-.756-.054-1.107-.156l1.58-1.389c.895-.171 1.621-.821 1.901-1.671zm-.058-3.818c-1.197-.67-2.512-1.077-3.898-1.077-3.465 0-6.533 2.632-8.404 5.5.853 1.308 1.955 2.567 3.231 3.549l1.728-1.519c-.351-.595-.553-1.289-.553-2.03 0-2.208 1.792-4 4-4 .925 0 1.777.315 2.455.843zm-2.6 2.285c-.378-.23-.822-.362-1.296-.362-1.38 0-2.5 1.12-2.5 2.5 0 .36.076.701.213 1.011z"
        fillRule="nonzero"></path>
    </svg>
  ),
  logout: (
    <svg
      xmlns="http://www.w3.org/2000/svg"
      width="100%"
      height="100%"
      viewBox="0 0 24 24"
      className="pointer-events-none ">
      <path d="M16 10v-5l8 7-8 7v-5h-8v-4h8zm-16-8v20h14v-2h-12v-16h12v-2h-14z" />
    </svg>
  ),
  delivery: (
    <svg
      xmlns="http://www.w3.org/2000/svg"
      width="100%"
      height="100%"
      viewBox="0 0 24 24"
      fillRule="evenodd"
      clipRule="evenodd"
      className="pointer-events-none">
      <path d="M5 11v1h8v-7h-10v-1c0-.552.448-1 1-1h10c.552 0 1 .448 1 1v2h4.667c1.117 0 1.6.576 1.936 1.107.594.94 1.536 2.432 2.109 3.378.188.312.288.67.288 1.035v4.48c0 1.089-.743 2-2 2h-1c0 1.656-1.344 3-3 3s-3-1.344-3-3h-4c0 1.656-1.344 3-3 3s-3-1.344-3-3h-1c-.552 0-1-.448-1-1v-6h-2v-2h7v2h-3zm3 5.8c.662 0 1.2.538 1.2 1.2 0 .662-.538 1.2-1.2 1.2-.662 0-1.2-.538-1.2-1.2 0-.662.538-1.2 1.2-1.2zm10 0c.662 0 1.2.538 1.2 1.2 0 .662-.538 1.2-1.2 1.2-.662 0-1.2-.538-1.2-1.2 0-.662.538-1.2 1.2-1.2zm-3-2.8h-10v2h.765c.549-.614 1.347-1 2.235-1 .888 0 1.686.386 2.235 1h5.53c.549-.614 1.347-1 2.235-1 .888 0 1.686.386 2.235 1h1.765v-4.575l-1.711-2.929c-.179-.307-.508-.496-.863-.496h-4.426v6zm1-5v3h5l-1.427-2.496c-.178-.312-.509-.504-.868-.504h-2.705zm-16-3h8v2h-8v-2z"></path>
    </svg>
  ),
  orders: (
    <svg
      xmlns="http://www.w3.org/2000/svg"
      width="100%"
      height="100%"
      viewBox="0 0 24 24"
      fillRule="evenodd"
      clipRule="evenodd"
      className="pointer-events-none ">
      <path d="M13.403 24h-13.403v-22h3c1.231 0 2.181-1.084 3-2h8c.821.916 1.772 2 3 2h3v9.15c-.485-.098-.987-.15-1.5-.15l-.5.016v-7.016h-4l-2 2h-3.897l-2.103-2h-4v18h9.866c.397.751.919 1.427 1.537 2zm5.097-11c3.035 0 5.5 2.464 5.5 5.5s-2.465 5.5-5.5 5.5c-3.036 0-5.5-2.464-5.5-5.5s2.464-5.5 5.5-5.5zm0 2c1.931 0 3.5 1.568 3.5 3.5s-1.569 3.5-3.5 3.5c-1.932 0-3.5-1.568-3.5-3.5s1.568-3.5 3.5-3.5zm2.5 4h-3v-3h1v2h2v1zm-15.151-4.052l-1.049-.984-.8.823 1.864 1.776 3.136-3.192-.815-.808-2.336 2.385zm6.151 1.052h-2v-1h2v1zm2-2h-4v-1h4v1zm-8.151-4.025l-1.049-.983-.8.823 1.864 1.776 3.136-3.192-.815-.808-2.336 2.384zm8.151 1.025h-4v-1h4v1zm0-2h-4v-1h4v1zm-5-6c0 .552.449 1 1 1 .553 0 1-.448 1-1s-.447-1-1-1c-.551 0-1 .448-1 1z"></path>
    </svg>
  ),
  favourite: (
    <svg
      xmlns="http://www.w3.org/2000/svg"
      width="100%"
      height="100%"
      viewBox="0 0 24 24"
      className="pointer-events-none ">
      <path d="M12 4.248c-3.148-5.402-12-3.825-12 2.944 0 4.661 5.571 9.427 12 15.808 6.43-6.381 12-11.147 12-15.808 0-6.792-8.875-8.306-12-2.944z"></path>
    </svg>
  ),
  dollar: (
    <svg
      xmlns="http://www.w3.org/2000/svg"
      width="100%"
      height="100%"
      viewBox="0 0 24 24"
      className="pointer-events-none">
      <path d="M10.553 3.123c.47-.079.953-.123 1.447-.123 4.971 0 9 4.029 9 9 0 1.742-.5 3.363-1.359 4.738.226-.877.359-1.791.359-2.738 0-5.537-4.116-10.119-9.447-10.877zm12.447 8.877c0 .947-.133 1.861-.359 2.738.859-1.375 1.359-2.996 1.359-4.738 0-4.971-4.029-9-9-9-.494 0-.977.044-1.447.123 5.331.758 9.447 5.34 9.447 10.877zm-5 2c0 4.971-4.029 9-9 9s-9-4.029-9-9 4.029-9 9-9 9 4.029 9 9zm-5.584 1.736c0-1.787-1.86-2.285-3.286-2.955-.864-.449-.757-1.525.483-1.597.691-.042 1.396.162 2.036.387l.302-1.372c-.756-.23-1.43-.335-2.035-.352v-.847h-.832v.889c-1.621.223-2.488 1.24-2.488 2.375 0 2.032 2.373 2.342 3.148 2.703 1.061.474.863 1.458-.094 1.675-.83.188-1.893-.14-2.688-.45l-.378 1.37c.744.385 1.637.591 2.5.605v.833h.832v-.877c1.381-.194 2.503-.956 2.5-2.387z" />
    </svg>
  ),
  divider: (
    <svg
      data-name="Layer 1"
      xmlns="http://www.w3.org/2000/svg"
      viewBox="0 0 1200 120"
      preserveAspectRatio="none">
      <path
        d="M0,0V46.29c47.79,22.2,103.59,32.17,158,28,70.36-5.37,136.33-33.31,206.8-37.5C438.64,32.43,512.34,53.67,583,72.05c69.27,18,138.3,24.88,209.4,13.08,36.15-6,69.85-17.84,104.45-29.34C989.49,25,1113-14.29,1200,52.47V0Z"
        opacity=".25"
        className="shape-fill"></path>
      <path
        d="M0,0V15.81C13,36.92,27.64,56.86,47.69,72.05,99.41,111.27,165,111,224.58,91.58c31.15-10.15,60.09-26.07,89.67-39.8,40.92-19,84.73-46,130.83-49.67,36.26-2.85,70.9,9.42,98.6,31.56,31.77,25.39,62.32,62,103.63,73,40.44,10.79,81.35-6.69,119.13-24.28s75.16-39,116.92-43.05c59.73-5.85,113.28,22.88,168.9,38.84,30.2,8.66,59,6.17,87.09-7.5,22.43-10.89,48-26.93,60.65-49.24V0Z"
        opacity=".5"
        className="shape-fill"></path>
      <path
        d="M0,0V5.63C149.93,59,314.09,71.32,475.83,42.57c43-7.64,84.23-20.12,127.61-26.46,59-8.63,112.48,12.24,165.56,35.4C827.93,77.22,886,95.24,951.2,90c86.53-7,172.46-45.71,248.8-84.81V0Z"
        className="shape-fill"></path>
    </svg>
  ),
  phone: (
    <svg
      width="100%"
      height="100%"
      viewBox="0 0 24 24"
      className="pointer-events-none"
      xmlns="http://www.w3.org/2000/svg"
      fillRule="evenodd"
      clipRule="evenodd">
      <path d="M8.26 1.289l-1.564.772c-5.793 3.02 2.798 20.944 9.31 20.944.46 0 .904-.094 1.317-.284l1.542-.755-2.898-5.594-1.54.754c-.181.087-.384.134-.597.134-2.561 0-6.841-8.204-4.241-9.596l1.546-.763-2.875-5.612zm7.746 22.711c-5.68 0-12.221-11.114-12.221-17.832 0-2.419.833-4.146 2.457-4.992l2.382-1.176 3.857 7.347-2.437 1.201c-1.439.772 2.409 8.424 3.956 7.68l2.399-1.179 3.816 7.36s-2.36 1.162-2.476 1.215c-.547.251-1.129.376-1.733.376" />
    </svg>
  ),
  add: (
    <svg
      width="100%"
      height="100%"
      viewBox="0 0 24 24"
      className="pointer-events-none"
      xmlns="http://www.w3.org/2000/svg"
      fillRule="evenodd"
      clipRule="evenodd">
      <path d="M11 11v-11h1v11h11v1h-11v11h-1v-11h-11v-1h11z" />
    </svg>
  ),
  airCloudBrain: (
    <svg
      xmlns="http://www.w3.org/2000/svg"
      width="100%"
      height="100%"
      viewBox="0 0 1024 1024"
      className="pointer-events-none">
      <path
        d="M248.954 535.284a136.326 136.326 0 0 1-74.346-22.008c-30.744-19.924-51.838-50.536-59.394-86.206-7.542-35.6-0.704-72.042 19.252-102.624a136.98 136.98 0 0 1 28.658-31.782 8.01 8.01 0 0 1 11.25 1.196 8.012 8.012 0 0 1-1.194 11.248 120.438 120.438 0 0 0-25.318 28.074c-17.622 26.996-23.656 59.162-17.004 90.576 6.666 31.478 25.294 58.506 52.448 76.102 55.858 36.216 130.868 20.362 167.154-35.35a7.98 7.98 0 0 1 11.062-2.334 7.992 7.992 0 0 1 2.334 11.062c-26.17 40.17-70.106 62.046-114.902 62.046zM861.124 374.146a7.986 7.986 0 0 1-7.76-9.914c4.386-17.708 4.668-35.842 0.828-53.906-13.802-64.978-78.024-106.636-143.242-92.866-4.214 0.914-8.556-1.826-9.476-6.166a7.996 7.996 0 0 1 6.166-9.478c73.838-15.598 146.552 31.588 162.198 105.184 4.34 20.454 4.028 41.01-0.954 61.072a8 8 0 0 1-7.76 6.074z"
        fill=""
      />
      <path
        d="M784.804 224.316a7.992 7.992 0 0 1-7.994-8.558c0.766-10.828-0.046-21.938-2.404-33.032-13.13-61.792-70.436-102.496-133.06-94.596-4.326 0.454-8.386-2.552-8.932-6.942a7.994 7.994 0 0 1 6.932-8.922c71.23-8.892 135.84 37.184 150.706 107.132 2.67 12.554 3.576 25.162 2.716 37.482a7.994 7.994 0 0 1-7.964 7.436zM387.814 566.104c-39.324 0-79.788-9.852-112.052-36.458a7.982 7.982 0 0 1-1.084-11.25 7.984 7.984 0 0 1 11.25-1.086c50.652 41.752 130.634 38.644 187.43 17.02 34.436-13.11 51.752-29.628 53.274-39.434 0.68-4.364 4.874-7.298 9.12-6.674a8 8 0 0 1 6.684 9.124c-2.876 18.494-26.568 37.904-63.384 51.924-25.886 9.854-58.16 16.834-91.238 16.834z"
        fill=""
      />
      <path
        d="M329.168 225.768a8.01 8.01 0 0 1-7.816-6.33c-10.078-47.404-1.124-95.83 25.216-136.364 26.442-40.676 67.288-68.638 114.996-78.726 98.18-20.758 194.862 41.986 215.674 139.798a8 8 0 0 1-6.152 9.486c-4.214 0.92-8.57-1.828-9.492-6.16-18.97-89.208-107.252-146.418-196.718-127.478-43.532 9.204-80.786 34.702-104.894 71.792-24.022 36.952-32.18 81.1-22.982 124.326a8.008 8.008 0 0 1-6.16 9.484 8.24 8.24 0 0 1-1.672 0.172zM638.02 557.112c-42.392 0-82.348-15.038-115.3-43.922a7.996 7.996 0 0 1-0.742-11.282c2.912-3.334 7.948-3.646 11.29-0.742 39.02 34.21 88.842 47.044 140.37 36.162 25.418-5.402 48.496-16.186 68.59-32.056a7.986 7.986 0 0 1 11.226 1.32 8.004 8.004 0 0 1-1.326 11.234c-22.032 17.394-47.326 29.228-75.182 35.146-13.102 2.764-26.124 4.14-38.926 4.14z"
        fill=""
      />
      <path
        d="M199.512 391.104a7.994 7.994 0 0 1-6.52-3.358c-14.426-20.282-24.396-43.024-29.626-67.6-10.078-47.436-1.116-95.884 25.24-136.418 26.442-40.666 67.272-68.608 114.964-78.686a187.796 187.796 0 0 1 37.73-4.014h0.04a7.996 7.996 0 0 1 0.038 15.99 171.248 171.248 0 0 0-34.498 3.67c-43.516 9.188-80.764 34.678-104.872 71.754-24.03 36.958-32.196 81.128-23 124.378 4.77 22.422 13.856 43.164 27.004 61.652a7.996 7.996 0 0 1-6.5 12.632zM795.062 526.468c-28.134 0-49.962-7.184-50.462-7.356a7.994 7.994 0 0 1-4.996-10.124c1.436-4.194 6.01-6.426 10.132-5.012 4.028 1.342 98.602 32.18 137.636-47.928 29.212-59.988-28.262-124.606-28.856-125.254a7.996 7.996 0 0 1 0.578-11.29 7.98 7.98 0 0 1 11.29 0.562c2.67 2.966 65.25 73.384 31.352 142.984-25.278 51.896-71.028 63.418-106.674 63.418zM248.156 815.77c-39.674 0-71.948-32.274-71.948-71.95 0-23.794 12.14-46.186 31.978-59.504v-4.452a7.988 7.988 0 0 1 7.994-7.992h63.954a7.988 7.988 0 0 1 7.994 7.992v4.452c19.836 13.302 31.978 35.708 31.978 59.504 0 39.676-32.274 71.95-71.95 71.95z m-23.982-127.908v0.874a8.02 8.02 0 0 1-3.974 6.918c-17.534 10.196-28.002 28.198-28.002 48.168 0 30.854 25.108 55.96 55.96 55.96 30.854 0 55.96-25.108 55.96-55.96 0-19.97-10.47-37.988-28.004-48.168a8.026 8.026 0 0 1-3.974-6.918v-0.874h-47.966z"
        fill=""
      />
      <path
        d="M280.134 687.862H216.18a7.99 7.99 0 0 1-7.994-7.996V631.9c0-2.124 0.842-4.152 2.342-5.652l15.988-15.988a7.988 7.988 0 0 1 5.652-2.342h31.976a7.98 7.98 0 0 1 5.652 2.342l15.988 15.988a7.988 7.988 0 0 1 2.342 5.652v47.964a7.988 7.988 0 0 1-7.992 7.998z m-55.96-15.988h47.964v-36.662l-11.304-11.304h-25.356l-11.304 11.304v36.662z"
        fill=""
      />
      <path
        d="M280.134 655.882H216.18a7.988 7.988 0 0 1-7.994-7.994 7.99 7.99 0 0 1 7.994-7.994h63.954a7.99 7.99 0 0 1 7.994 7.994 7.988 7.988 0 0 1-7.994 7.994zM248.156 719.838a7.978 7.978 0 0 1-5.652-2.342l-15.988-15.988c-3.124-3.124-3.124-8.182 0-11.304s8.182-3.124 11.304 0l10.336 10.336 10.336-10.336c3.124-3.124 8.182-3.124 11.304 0s3.124 8.182 0 11.304l-15.988 15.988a7.97 7.97 0 0 1-5.652 2.342z"
        fill=""
      />
      <path
        d="M232.168 751.814a7.988 7.988 0 0 1-7.994-7.994v-47.964a7.988 7.988 0 0 1 7.994-7.994 7.988 7.988 0 0 1 7.994 7.994v47.964a7.988 7.988 0 0 1-7.994 7.994zM264.144 751.814a7.988 7.988 0 0 1-7.994-7.994v-47.964a7.988 7.988 0 0 1 7.994-7.994 7.988 7.988 0 0 1 7.994 7.994v47.964a7.988 7.988 0 0 1-7.994 7.994z"
        fill=""
      />
      <path
        d="M248.156 623.906a7.99 7.99 0 0 1-7.994-7.994v-63.956a7.99 7.99 0 0 1 7.994-7.994 7.99 7.99 0 0 1 7.994 7.994v63.956a7.988 7.988 0 0 1-7.994 7.994z"
        fill=""
      />
      <path
        d="M775.78 783.792c-39.674 0-71.95-32.274-71.95-71.948 0-23.794 12.148-46.186 31.978-59.504v-4.452a7.99 7.99 0 0 1 7.994-7.994h63.954a7.99 7.99 0 0 1 7.996 7.994v4.452c19.828 13.302 31.976 35.708 31.976 59.504 0 39.674-32.272 71.948-71.948 71.948z m-23.984-127.91v0.876c0 2.842-1.514 5.48-3.982 6.916-17.534 10.198-27.994 28.2-27.994 48.17 0 30.854 25.108 55.958 55.958 55.958 30.854 0 55.96-25.106 55.96-55.958 0-19.97-10.46-37.988-27.996-48.17a8.008 8.008 0 0 1-3.98-6.916v-0.876h-47.966z"
        fill=""
      />
      <path
        d="M807.756 655.882h-63.954a7.988 7.988 0 0 1-7.994-7.994v-47.964a7.98 7.98 0 0 1 2.342-5.652l15.988-15.988a7.99 7.99 0 0 1 5.652-2.344h31.976c2.124 0 4.154 0.844 5.652 2.344l15.988 15.988a7.982 7.982 0 0 1 2.344 5.652v47.964a7.986 7.986 0 0 1-7.994 7.994z m-55.96-15.988h47.966v-36.662l-11.304-11.302H763.1l-11.304 11.302v36.662z"
        fill=""
      />
      <path
        d="M807.756 623.906h-63.954c-4.418 0-7.994-3.576-7.994-7.994s3.576-7.994 7.994-7.994h63.954c4.42 0 7.996 3.576 7.996 7.994s-3.576 7.994-7.996 7.994zM775.78 687.862a7.97 7.97 0 0 1-5.652-2.344l-15.988-15.988a7.992 7.992 0 1 1 11.304-11.304l10.336 10.338 10.336-10.338a7.992 7.992 0 0 1 11.304 0 7.988 7.988 0 0 1 0 11.304l-15.988 15.988a7.964 7.964 0 0 1-5.652 2.344z"
        fill=""
      />
      <path
        d="M759.792 719.838a7.99 7.99 0 0 1-7.994-7.994v-47.966c0-4.418 3.576-7.994 7.994-7.994s7.994 3.576 7.994 7.994v47.966a7.992 7.992 0 0 1-7.994 7.994zM791.768 719.838a7.99 7.99 0 0 1-7.994-7.994v-47.966a7.99 7.99 0 0 1 7.994-7.994 7.99 7.99 0 0 1 7.996 7.994v47.966a7.99 7.99 0 0 1-7.996 7.994z"
        fill=""
      />
      <path
        d="M775.78 591.93a7.99 7.99 0 0 1-7.994-7.994v-31.978a7.99 7.99 0 0 1 7.994-7.994 7.988 7.988 0 0 1 7.994 7.994v31.978a7.988 7.988 0 0 1-7.994 7.994z"
        fill=""
      />
      <path
        d="M503.974 943.678c-39.676 0-71.95-32.274-71.95-71.95 0-23.794 12.14-46.186 31.976-59.504v-4.45a7.99 7.99 0 0 1 7.994-7.994h63.956a7.99 7.99 0 0 1 7.994 7.994v4.45c19.83 13.302 31.976 35.708 31.976 59.504 0.002 39.676-32.272 71.95-71.946 71.95z m-23.982-127.908v0.874a8.02 8.02 0 0 1-3.974 6.918c-17.536 10.196-28.004 28.2-28.004 48.168 0 30.854 25.108 55.96 55.96 55.96s55.958-25.108 55.958-55.96c0-19.968-10.46-37.988-27.994-48.168a8.01 8.01 0 0 1-3.982-6.918v-0.874h-47.964z"
        fill=""
      />
      <path
        d="M535.952 815.77h-63.956a7.99 7.99 0 0 1-7.994-7.994v-47.964c0-2.124 0.844-4.154 2.342-5.652l15.988-15.99a7.992 7.992 0 0 1 5.652-2.342h31.978c2.124 0 4.152 0.844 5.652 2.342l15.988 15.99a7.99 7.99 0 0 1 2.342 5.652v47.964a7.988 7.988 0 0 1-7.992 7.994z m-55.96-15.988h47.966V763.12l-11.304-11.304h-25.358l-11.304 11.304v36.662z"
        fill=""
      />
      <path
        d="M535.952 783.792h-63.956a7.988 7.988 0 0 1-7.994-7.992 7.99 7.99 0 0 1 7.994-7.996h63.956a7.99 7.99 0 0 1 7.994 7.996 7.99 7.99 0 0 1-7.994 7.992zM503.974 847.746a7.96 7.96 0 0 1-5.652-2.342l-15.99-15.988a7.992 7.992 0 1 1 11.304-11.304l10.336 10.336 10.336-10.336a7.992 7.992 0 1 1 11.304 11.304l-15.99 15.988a7.95 7.95 0 0 1-5.648 2.342z"
        fill=""
      />
      <path
        d="M487.986 879.724a7.99 7.99 0 0 1-7.994-7.996v-47.964c0-4.418 3.576-7.994 7.994-7.994s7.994 3.576 7.994 7.994v47.964a7.99 7.99 0 0 1-7.994 7.996zM519.962 879.724a7.99 7.99 0 0 1-7.994-7.996v-47.964c0-4.418 3.576-7.994 7.994-7.994s7.994 3.576 7.994 7.994v47.964a7.99 7.99 0 0 1-7.994 7.996z"
        fill=""
      />
      <path
        d="M503.974 751.814a7.99 7.99 0 0 1-7.996-7.994v-191.864a7.99 7.99 0 0 1 7.996-7.994 7.99 7.99 0 0 1 7.994 7.994v191.864a7.988 7.988 0 0 1-7.994 7.994z"
        fill=""
      />
      <path
        d="M647.872 879.708h-47.966a7.988 7.988 0 0 1-7.992-7.996 7.986 7.986 0 0 1 7.992-7.992h47.966a7.988 7.988 0 0 1 7.994 7.992 7.99 7.99 0 0 1-7.994 7.996z"
        fill=""
      />
      <path
        d="M408.042 879.708h-47.966a7.99 7.99 0 0 1-7.994-7.996 7.988 7.988 0 0 1 7.994-7.992h47.966a7.988 7.988 0 0 1 7.994 7.992 7.99 7.99 0 0 1-7.994 7.996z"
        fill=""
      />
      <path
        d="M402.218 981.462a7.96 7.96 0 0 1-5.652-2.342 7.988 7.988 0 0 1 0-11.304l33.928-33.912a7.988 7.988 0 0 1 11.304 0 7.988 7.988 0 0 1 0 11.304l-33.928 33.912a7.956 7.956 0 0 1-5.652 2.342z"
        fill=""
      />
      <path
        d="M503.974 1023.622a7.99 7.99 0 0 1-7.996-7.994v-47.964a7.99 7.99 0 0 1 7.996-7.996 7.99 7.99 0 0 1 7.994 7.996v47.964a7.992 7.992 0 0 1-7.994 7.994z"
        fill=""
      />
      <path
        d="M605.744 981.462a7.968 7.968 0 0 1-5.652-2.342l-33.928-33.912a7.988 7.988 0 0 1 0-11.304 7.988 7.988 0 0 1 11.304 0l33.928 33.912a7.988 7.988 0 0 1 0 11.304 7.95 7.95 0 0 1-5.652 2.342z"
        fill=""
      />
    </svg>
  ),
  svg7x24: (
    <svg
      xmlns="http://www.w3.org/2000/svg"
      width="100%"
      height="100%"
      viewBox="0 0 1024 1024"
      className="pointer-events-none">
      <path
        d="M925 620.2H407.3c-22 0-39.9-17.9-39.9-39.9V305.8c0-22 17.9-39.9 39.9-39.9H925c22 0 39.9 17.9 39.9 39.9v274.6c0 22-17.9 39.8-39.9 39.8z"
        fill="#FFFFFF"
      />
      <path
        d="M443.2 699.1c-16.6-11.6-30.4-16.7-40.9-15.2-8.1 1.2-14.2 6.2-20.8 11.5-7 5.7-14.9 12.2-25.7 12.5-10.1 0.3-20.4-5.8-34.2-20.2-22.1-23.1-64.1-81-63.5-112.9-0.3-5.1 0.1-16.4 8-25.1 5.3-5.8 12.6-9 20.8-9 1.6-0.5 6.7-3.1 11-9.9 5.5-8.7 10.5-25.2 3.2-54.8-12.8-52.2-33.6-60.8-36.5-61.8h-1.2c-7.1 0-33.5 1.3-53 19.7-15.9 15.1-23.8 38.6-23.3 70 1.1 71.3 29.5 142.1 84.5 210.4 25.6 31.8 97.9 96.5 158 93.4 44.4-2.3 56.7-43.9 57.5-46.5l0.3-1.4c0.6-4.1 1.7-28.6-44.2-60.7z"
        fill="#E6E6E6"
      />
      <path
        d="M431.7 402.4h68.1c-14.1 17.7-25.3 37.8-33.7 60.2-8.4 22.5-12.9 44.5-13.4 66.1h28.9c-0.1-13.8 2.2-29.4 6.8-47 4.6-17.5 11.2-34.1 20-49.6 8.7-15.6 17.3-27.5 25.8-35.8v-21.7H431.7v27.8zM659.7 415.5h-35.2l-21.1 31.2-20-31.2h-36.6l39.2 54.9-40.9 58.3h35.1l23.2-35 23.1 35h36.7l-41.8-59.5zM740.3 475.3c9.4-8.7 16-15.3 19.6-19.9 5.5-7 9.5-13.6 12-20s3.8-13.1 3.8-20.1c0-12.4-4.4-22.7-13.2-31-8.8-8.3-20.9-12.5-36.3-12.5-14.1 0-25.8 3.6-35.2 10.8-9.4 7.2-15 19-16.7 35.5l29.8 3c0.6-8.7 2.7-15 6.4-18.8 3.7-3.8 8.7-5.7 14.9-5.7 6.3 0 11.3 1.8 14.9 5.4 3.6 3.6 5.4 8.7 5.4 15.4 0 6-2.1 12.2-6.2 18.3-3.1 4.5-11.3 13-24.8 25.6-16.8 15.6-28 28.1-33.7 37.5-5.7 9.4-9.1 19.4-10.2 29.9h105v-27.8h-59.5c1.6-2.7 3.6-5.5 6.1-8.3 2.5-2.8 8.5-8.6 17.9-17.3zM883.7 371.8h-25.2L790.7 471v26.2h64v31.4h29v-31.4h19.4V471h-19.4v-99.2z m-29 99.2h-35.9l35.9-53.4V471zM634.1 666c-4.5-2.5-10.2-0.9-12.8 3.6-1.5 2.6-3 5.3-4.6 7.9-2.7 4.4-1.2 10.2 3.2 12.9 1.5 0.9 3.2 1.3 4.8 1.3 3.2 0 6.3-1.6 8-4.5 1.6-2.7 3.3-5.5 4.9-8.3 2.6-4.7 1-10.4-3.5-12.9zM609.4 705.7c-4.1-3.2-10-2.4-13.1 1.7-1.8 2.4-3.7 4.8-5.7 7.1-3.3 4-2.7 9.9 1.3 13.2 1.7 1.4 3.8 2.1 5.9 2.1 2.7 0 5.4-1.2 7.3-3.4 2-2.5 4-5 6-7.6 3.2-4 2.4-9.9-1.7-13.1zM566 741.4l-6.6 6.3c-3.8 3.5-4 9.4-0.5 13.2 1.8 2 4.4 3 6.9 3 2.3 0 4.5-0.8 6.3-2.5 2.4-2.2 4.7-4.4 7-6.6 3.7-3.6 3.8-9.5 0.2-13.2-3.6-3.7-9.6-3.8-13.3-0.2zM652.9 623.1c-4.8-1.9-10.3 0.5-12.1 5.3-1.1 2.8-2.2 5.7-3.4 8.4-2 4.8 0.2 10.3 5 12.3 1.2 0.5 2.4 0.7 3.6 0.7 3.7 0 7.1-2.2 8.6-5.7 1.2-3 2.5-6 3.6-8.9 1.9-4.8-0.5-10.3-5.3-12.1zM531.3 770.8c-2.4 1.8-4.9 3.6-7.4 5.3-4.3 2.9-5.3 8.8-2.4 13 1.8 2.6 4.7 4.1 7.7 4.1 1.8 0 3.7-0.5 5.3-1.6 2.6-1.8 5.3-3.7 7.9-5.6 4.2-3.1 5.1-8.9 2-13.1-3.1-4.3-8.9-5.2-13.1-2.1z"
        fill="#005BFF"
      />
      <path
        d="M927.4 265.9H592.6c0.3-5.5-1.7-11-6.1-15-63.8-57.7-146.4-89.5-232.5-89.5-46.8 0-92.2 9.2-135 27.3-41.3 17.5-78.4 42.5-110.2 74.3S52 331.9 34.5 373.2C16.4 416 7.2 461.4 7.2 508.2s9.2 92.2 27.3 135C52 684.5 77 721.6 108.8 753.4c31.8 31.8 68.9 56.8 110.2 74.3 42.8 18.1 88.2 27.3 135 27.3 22.9 0 45.8-2.2 68-6.7 2.6-0.5 5-1.6 7.1-3 0.8 0 1.7-0.1 2.5-0.1 27.6-1.4 51.3-12.8 69-33.1 1.6-1.8 3.2-3.7 4.7-5.7 0.4-0.5 0.8-1 1.2-1.6 11.3-15.4 15.8-30 16.8-33.5 2.7-8.6 12.2-53.5-58.6-102.8-58.9-41.1-91.2-14.7-106.8-2-0.7 0.6-1.6 1.3-2.4 1.9-6.8-5.8-19.7-19.8-34.3-41.3-18.1-26.6-24.7-44-25.6-50 10.5-2.6 21.4-9.9 29.5-20.1 12-15.1 23.9-42.9 12.4-90-7.7-31.3-19.4-55.3-35-71.2-15.6-15.9-29.7-18.5-33.7-18.9-0.5 0-47.5-3.9-83 28.7-24.7 22.6-36.8 55.9-36.2 98.9 0.8 50.7 13.9 101.5 38.9 151 20.8 41.1 44.9 71.1 53.9 82.3 14.8 18.4 49.8 53.9 92.6 79-161.7-9.9-290.3-144.5-290.3-308.7 0-170.5 138.7-309.3 309.3-309.3 70.2 0 137.7 23.7 192.3 67H404.9c-20.7 0-37.5 16.8-37.5 37.5v279.4c0 20.7 16.8 37.5 37.5 37.5h522.6c20.7 0 37.5-16.8 37.5-37.5V303.4c-0.1-20.7-16.9-37.5-37.6-37.5zM271.6 714.2c-55-68.4-83.4-139.2-84.5-210.4-0.5-31.4 7.4-54.9 23.3-70 19.5-18.4 45.9-19.7 53-19.7h1.2c2.9 1 23.7 9.6 36.5 61.8 7.3 29.6 2.2 46.2-3.2 54.8-4.3 6.9-9.4 9.4-11 9.9-8.2 0.1-15.6 3.2-20.8 9-7.9 8.7-8.3 20-8 25.1-0.6 31.9 41.4 89.9 63.5 112.9 13.9 14.5 24.1 20.5 34.2 20.2 10.8-0.3 18.7-6.8 25.7-12.5 6.5-5.3 12.6-10.3 20.8-11.5 10.5-1.5 24.3 3.6 40.9 15.2 46 32.1 44.8 56.6 44.2 60.6l-0.3 1.4c-0.7 2.6-13 44.2-57.5 46.5-60.1 3.3-132.4-61.4-158-93.3z m674.6-131.4c0 10.3-8.4 18.7-18.7 18.7H404.9c-10.3 0-18.7-8.4-18.7-18.7V303.4c0-10.3 8.4-18.7 18.7-18.7h522.6c10.3 0 18.7 8.4 18.7 18.7v279.4z"
        fill="#005BFF"
      />
      <path
        d="M1014.6 484.2c-5.2 0-9.4 4.2-9.4 9.4v126.3c0 23.5-19.1 42.6-42.6 42.6H710.5c-5.2 0-9.4 4.2-9.4 9.4s4.2 9.4 9.4 9.4h252.2c33.8 0 61.3-27.5 61.3-61.3V493.6c0-5.2-4.2-9.4-9.4-9.4z"
        fill="#06F3FF"
      />
    </svg>
  ),
  clientCentric: (
    <svg
      xmlns="http://www.w3.org/2000/svg"
      width="100%"
      height="100%"
      viewBox="0 0 152 145"
      className="pointer-events-none">
      <path
        fillRule="evenodd"
        clipRule="evenodd"
        d="M11.248 0.304067C6.19987 1.49571 1.70616 6.51221 0.489313 12.3144C-0.158286 15.4038 -0.165409 100.728 0.481893 103.787C1.7572 109.814 6.28179 114.74 11.5581 115.845C13.517 116.256 31.7426 116.295 32.8036 115.891C34.6099 115.203 35.1409 112.551 33.7507 111.158L32.9743 110.38L22.667 110.231C12.7515 110.088 12.3132 110.058 11.1346 109.427C9.47229 108.536 7.62477 106.362 6.80473 104.332L6.12716 102.654V74.1254V45.5972L70.605 45.5224L135.083 45.4472V60.6036V75.7598L133.97 75.7664C132.633 75.7741 130.481 76.7012 129.402 77.7339L128.618 78.484L126.582 77.6008C125.463 77.1152 124.258 76.6305 123.905 76.5241C123.396 76.3705 123.221 76.013 123.054 74.7824C122.701 72.17 121.429 70.2961 119.247 69.1725C117.803 68.4293 112.618 68.1042 110.019 68.5939C106.768 69.2067 104.637 71.4675 104.309 74.6514L104.145 76.2454L101.505 77.3624L98.8655 78.4795L97.9439 77.7033C96.3656 76.3735 95.2713 75.9542 93.3838 75.9551C92.1527 75.9557 91.2368 76.1482 90.4158 76.5791C88.8176 77.4177 83.8752 82.4702 83.305 83.8481C82.3695 86.1084 83.0269 89.377 84.7884 91.2227L85.5069 91.9754L84.3616 94.6401L83.2163 97.3045L81.6222 97.4641C79.8014 97.6465 78.5884 98.221 77.4651 99.4325C75.8882 101.133 75.6172 102.071 75.4837 106.294L75.359 110.231H66.1701H56.9811L56.1136 111.1C54.6576 112.558 55.0591 114.883 56.9331 115.843C57.3812 116.072 61.5547 116.175 70.4418 116.175H83.3024L84.4346 118.857L85.5669 121.539L84.689 122.54C82.8064 124.687 82.3737 127.774 83.6152 130.2C84.3916 131.717 89.1085 136.29 90.5921 136.964C92.4355 137.801 94.5412 137.749 96.4018 136.821C97.2281 136.409 98.1259 135.826 98.3971 135.526C98.8735 134.999 98.9818 135.017 101.521 136.053L104.152 137.125L104.471 139.048C104.884 141.541 105.958 143.081 108.04 144.17C109.54 144.955 109.838 145 113.491 145C115.616 145 117.864 144.847 118.486 144.661C120.996 143.908 122.827 141.507 123.13 138.573C123.22 137.695 123.442 136.975 123.624 136.973C123.805 136.971 125.017 136.504 126.317 135.936L128.681 134.903L129.582 135.776C131.469 137.605 134.654 138.119 137.012 136.976C138.561 136.226 143.537 131.174 144.132 129.748C145.096 127.439 144.518 124.343 142.788 122.553L141.916 121.651L142.948 119.284C143.515 117.983 143.981 116.751 143.983 116.546C143.985 116.318 144.402 116.175 145.065 116.175C146.97 116.175 148.521 115.514 149.931 114.103C151.688 112.343 152 111.188 152 106.442C152 102.784 151.955 102.486 151.171 100.984C150.037 98.81 148.439 97.7179 146.05 97.4837L144.219 97.3045L143.539 95.4894C143.165 94.4912 142.648 93.2678 142.392 92.7706C141.968 91.9498 141.968 91.8313 142.39 91.48C142.646 91.2672 143.242 90.4179 143.715 89.5927C145.286 86.8513 144.804 83.8633 142.355 81.1484L141.342 80.026L141.253 46.6159L141.163 13.2059L140.352 10.8054C138.982 6.74965 136.07 3.03326 133.057 1.49393C129.947 -0.0944354 133.075 -0.0204403 70.3943 0.0116538C37.9859 0.0285924 11.8689 0.157563 11.248 0.304067ZM129.245 6.39988C131.049 7.01531 132.976 8.90946 134.069 11.1406L134.935 12.9088L135.02 26.207L135.106 39.5053H70.5252H5.94463L6.03931 26.5042C6.13161 13.7857 6.14853 13.4665 6.80829 11.825C7.90316 9.09965 10.095 6.93745 12.5064 6.20285C12.9154 6.07834 39.036 5.96482 70.5522 5.95086C122.292 5.92768 127.989 5.97136 129.245 6.39988ZM25.2702 13.2184C23.433 13.7245 20.9486 15.3045 20.0265 16.5535C18.3493 18.8248 18.0003 19.9142 18.0041 22.8639C18.0074 25.2026 18.1246 25.9235 18.688 27.0647C19.7828 29.283 21.2611 30.776 23.4135 31.8369C25.1473 32.6915 25.6839 32.8119 27.779 32.8152C29.7805 32.8184 30.4557 32.6838 31.948 31.9849C34.2443 30.9091 36.315 28.7214 37.1531 26.4858C38.0236 24.1637 37.8936 20.6797 36.8575 18.5627C34.7645 14.2864 29.7648 11.9804 25.2702 13.2184ZM51.3667 13.1489C46.2216 14.6047 43.0741 19.4881 44.0039 24.5726C44.621 27.9481 46.6433 30.5219 49.8682 32.036C52.2254 33.1426 55.5542 33.1367 57.9611 32.0217C60.0897 31.0357 61.915 29.212 62.9187 27.0682C63.5755 25.6653 63.7046 24.9753 63.7046 22.8639C63.7046 20.7002 63.5856 20.0955 62.8754 18.6471C60.786 14.3872 55.6545 11.9355 51.3667 13.1489ZM86.9274 13.0829C80.836 14.5203 77.3763 21.2782 79.8572 26.8935C80.6737 28.7416 82.9382 31.0393 84.8881 31.9982L86.5576 32.819H102.287C118.012 32.819 118.018 32.8187 119.478 32.1447C121.715 31.1118 123.297 29.6423 124.397 27.5767C126.815 23.033 125.464 17.5871 121.183 14.6258C118.59 12.8324 117.806 12.7569 102.151 12.7899C94.3908 12.8065 87.5402 12.9382 86.9274 13.0829ZM30.3676 19.7909C32.1917 21.4434 32.2593 24.1346 30.5172 25.733C29.1478 26.9898 27.7238 27.2575 26.2517 26.5348C23.4983 25.1836 22.9873 21.8125 25.2277 19.7823C26.4698 18.6566 29.1211 18.661 30.3676 19.7909ZM56.433 19.8491C58.2146 21.1766 58.301 24.0249 56.6113 25.7167C55.3007 27.029 53.8693 27.273 52.2072 26.4673C50.6271 25.7015 49.9039 24.531 49.9039 22.7394C49.9039 21.6066 50.0718 21.1858 50.8732 20.3103C52.3877 18.6554 54.5863 18.4729 56.433 19.8491ZM117.828 19.565C119.649 20.8648 120.148 23.2181 118.976 24.9744C117.592 27.0483 117.791 27.0233 102.696 27.0236C95.2479 27.0239 88.7218 26.9375 88.1929 26.8317C86.9024 26.5731 85.3481 24.9675 85.0985 23.6347C84.8507 22.3126 85.7381 20.1136 86.735 19.5796C88.1899 18.7998 89.3705 18.7425 102.881 18.7965L116.83 18.8521L117.828 19.565ZM47.0274 62.6874C46.6697 62.8315 46.1625 63.2776 45.9001 63.6784C45.3463 64.5245 39.4826 88.7226 39.4191 90.4236C39.3838 91.3659 39.5455 91.7175 40.3412 92.4295C42.0508 93.959 44.418 93.318 45.1276 91.1335C45.815 89.018 51.1269 66.3369 51.1382 65.4692C51.1545 64.2276 50.6633 63.3798 49.613 62.836C48.6469 62.3358 47.9919 62.2981 47.0274 62.6874ZM27.1685 65.1465C25.911 65.873 17.564 75.5785 17.2099 76.7256C16.6024 78.6946 17.1381 79.6444 21.8728 84.9881C24.2546 87.676 26.4755 90.1095 26.8082 90.3953C27.1768 90.7121 27.9012 90.9154 28.6607 90.9154C30.3697 90.9154 31.5028 89.7659 31.5028 88.0323C31.5028 86.895 31.2532 86.5342 27.6445 82.4574C25.5225 80.0598 23.7862 78.0017 23.7862 77.8834C23.7862 77.7651 24.5543 76.8014 25.4928 75.7417C31.7022 68.7309 31.5028 68.9975 31.5028 67.7116C31.5028 65.4496 29.1024 64.0291 27.1685 65.1465ZM60.0526 65.5042C59.0035 66.3883 58.718 67.5595 59.2551 68.7764C59.4715 69.2667 61.2612 71.4732 63.2319 73.6796C65.2028 75.8861 66.8165 77.7761 66.818 77.8792C66.8198 77.9826 65.1423 79.9549 63.0903 82.2624C58.615 87.2953 58.1653 88.4082 59.9045 90.1496C60.4833 90.7294 60.9661 90.913 61.8901 90.9059C62.5617 90.9008 63.3242 90.7335 63.5847 90.5344C64.8942 89.5336 73.0966 79.9469 73.3806 79.0854C73.9956 77.2198 73.5373 76.2727 70.1447 72.3985C68.4002 70.4063 66.0989 67.8739 65.0307 66.7705C63.3342 65.0187 62.952 64.7646 62.0097 64.7646C61.2929 64.7646 60.6358 65.013 60.0526 65.5042ZM116.979 76.7256C116.98 78.1811 117.148 79.2174 117.499 79.9202C117.969 80.8628 118.282 81.0464 120.837 81.8791C122.388 82.3846 124.755 83.3542 126.098 84.0336C127.441 84.7132 128.847 85.2692 129.223 85.2692C130.07 85.2692 130.97 84.679 132.785 82.932L134.196 81.5733L136.42 83.7851C137.644 85.0018 138.644 86.1393 138.644 86.3132C138.644 86.4867 137.978 87.2858 137.164 88.089C136.349 88.8923 135.536 89.9945 135.357 90.5386C135.058 91.4449 135.156 91.7819 136.519 94.5646C137.338 96.235 138.283 98.5461 138.619 99.7006C139.5 102.727 140.099 103.195 143.336 103.39L145.916 103.545L146.001 106.473C146.056 108.376 145.966 109.546 145.742 109.816C145.502 110.106 144.706 110.231 143.1 110.231C140.012 110.231 139.562 110.601 138.503 114.012C138.057 115.447 137.092 117.78 136.357 119.198C135.13 121.567 135.049 121.857 135.352 122.779C135.534 123.33 136.349 124.438 137.164 125.242C137.978 126.045 138.644 126.844 138.644 127.017C138.644 127.419 134.429 131.627 134.027 131.627C133.862 131.627 133.007 130.897 132.127 130.005C129.909 127.756 129.389 127.697 126.228 129.339C124.814 130.074 122.492 131.03 121.069 131.463C117.667 132.5 117.275 132.977 117.275 136.089C117.275 137.696 117.15 138.494 116.861 138.734C116.591 138.958 115.423 139.049 113.522 138.993L110.598 138.908L110.443 136.325C110.249 133.089 109.781 132.489 106.758 131.593C105.605 131.251 103.331 130.304 101.705 129.488C98.9792 128.121 98.6669 128.03 97.6973 128.321C97.1091 128.497 95.9973 129.295 95.1743 130.132C94.3649 130.954 93.5609 131.627 93.3876 131.627C93.214 131.627 92.0936 130.641 90.8975 129.436C88.4932 127.012 88.441 126.689 90.2458 125.402C91.3154 124.64 92.345 123.024 92.345 122.109C92.345 121.733 91.7576 120.278 91.0397 118.875C90.3218 117.472 89.4376 115.32 89.0749 114.095C88.1133 110.845 87.5928 110.414 84.4005 110.231L81.8089 110.083L81.7249 106.74L81.6409 103.396L83.8024 103.396C85.2665 103.396 86.2985 103.228 87.0007 102.876C87.9448 102.403 88.1317 102.077 89.0948 99.2361C89.6765 97.52 90.6459 95.1931 91.2486 94.0651C91.8517 92.9373 92.345 91.7605 92.345 91.4503C92.345 90.5531 91.6083 89.3844 90.1428 87.9562C89.3952 87.2275 88.7835 86.4953 88.7835 86.3292C88.7835 85.8359 92.7335 82.0003 93.2413 82.0003C93.4983 82.0003 94.2364 82.5462 94.8817 83.2134C96.2386 84.6166 97.3527 85.2692 98.3912 85.2692C98.7946 85.2692 100.261 84.6743 101.649 83.9471C103.037 83.2199 105.152 82.3379 106.347 81.9867C107.827 81.5522 108.78 81.072 109.336 80.4812C110.083 79.6872 110.152 79.4165 110.152 77.2905C110.152 76.0127 110.241 74.8781 110.35 74.7694C110.459 74.6603 111.995 74.5711 113.764 74.5711H116.979L116.979 76.7256ZM109.262 89.0046C104.275 90.3101 99.6282 94.1088 97.4445 98.6646C95.9192 101.847 95.4942 104.07 95.6732 107.929C95.7854 110.35 95.9851 111.401 96.6473 113.054C98.823 118.489 102.644 122.175 108.124 124.123C110.912 125.114 115.781 125.235 118.611 124.383C124.795 122.523 129.573 117.736 131.404 111.569C132.204 108.873 132.146 104.443 131.274 101.613C129.376 95.4517 124.108 90.4052 118.093 88.985C115.761 88.4346 111.402 88.4441 109.262 89.0046ZM118.892 95.6193C126.521 99.1939 128.378 109.008 122.586 115.14C116.702 121.369 106.633 119.822 102.822 112.103C101.9 110.235 101.714 109.521 101.605 107.437C101.445 104.385 101.984 102.357 103.598 99.9428C105.06 97.7559 107.294 96.0353 109.828 95.1453C112.658 94.1513 116.149 94.3337 118.892 95.6193ZM43.3412 110.677C41.6198 111.614 41.526 114.079 43.1593 115.455C43.9327 116.106 44.2877 116.21 45.2887 116.076C46.9241 115.856 47.8263 114.785 47.8263 113.064C47.8263 111.984 47.6755 111.643 46.9131 111.001C45.8844 110.134 44.5598 110.014 43.3412 110.677Z"
      />
    </svg>
  ),
  dataBackup: (
    <svg
      xmlns="http://www.w3.org/2000/svg"
      width="100%"
      height="100%"
      viewBox="0 0 152 152"
      className="pointer-events-none">
      <path
        fillRule="evenodd"
        clipRule="evenodd"
        d="M78.4771 0.142456C69.2971 1.18871 62.4873 3.35167 55.9715 7.29029C44.45 14.2547 35.7288 25.8994 32.6172 38.4732L31.8732 41.4794L28.8682 41.6551C15.4898 42.438 4.30412 51.6049 0.845581 64.6207C0.161304 67.1962 0.0605352 68.1584 0.0542929 72.179C0.0483478 76.2205 0.142577 77.1404 0.821801 79.671C3.22331 88.6168 9.02777 95.6996 17.2254 99.6872C20.2702 101.168 25.6106 102.662 26.7973 102.364C28.0865 102.04 28.9845 100.887 28.9845 99.5544C28.9845 97.6426 28.1453 96.9515 24.8229 96.1288C21.2651 95.2475 19.1602 94.3133 16.339 92.3629C6.59535 85.6276 3.11452 72.6543 8.16188 61.8844C10.5533 56.7821 14.2868 52.8735 19.1867 50.3429C23.3607 48.1867 25.3895 47.7228 30.8251 47.6806C36.5454 47.6363 36.7184 47.5397 37.4568 43.975C39.5396 33.9202 43.0978 26.8318 49.4349 20.1126C59.353 9.59681 74.26 4.3364 88.4333 6.35044C98.6785 7.80629 107.067 12.0151 114.457 19.407C119.232 24.1844 122.372 28.9231 124.704 34.8764C125.089 35.8573 125.577 36.9338 125.79 37.2688C126.002 37.6035 127.549 38.5648 129.228 39.4047C137.089 43.338 142.884 50.4692 145.113 58.9522C145.793 61.5366 145.895 62.5258 145.902 66.5316C145.909 70.5939 145.818 71.4731 145.134 73.9657C142.16 84.7959 134.259 92.7849 123.54 95.8003C121.724 96.3116 120.791 96.7438 120.316 97.2954C119.28 98.4965 119.518 100.53 120.81 101.521C122.636 102.924 130.64 100.216 136.504 96.2117C146.362 89.4809 152.6 76.8453 151.954 64.9147C151.252 51.9283 144.253 40.7729 132.94 34.6065L130.462 33.2556L129.454 30.8147C127.392 25.82 123.292 19.7743 119.006 15.4062C110.831 7.0751 100.402 1.92258 88.6429 0.404615C85.4745 -0.00467359 80.8192 -0.124458 78.4771 0.142456ZM48.6849 49.7496C44.7109 50.8199 40.8297 53.863 39.1383 57.2345C38.1128 59.2791 37.3058 62.3445 37.312 64.1728C37.3236 67.6575 39.0587 71.8321 41.5758 74.4305L43.1376 76.043L41.5375 77.6951C39.4992 79.7995 37.9422 83.0021 37.5144 85.9712C36.9 90.2362 38.4755 95.0085 41.5431 98.1755L43.1376 99.8216L41.5375 101.474C39.0132 104.079 37.3076 108.246 37.3076 111.807C37.3076 113.538 38.1399 116.639 39.1383 118.63C40.2524 120.851 43.0538 123.639 45.3218 124.783C48.6091 126.443 49.7307 126.563 61.9053 126.568L72.9779 126.572L72.9681 130.659L72.958 134.746L71.4177 135.638C65.302 139.178 65.8412 148.366 72.3391 151.341C74.2588 152.22 77.6421 152.22 79.5618 151.341C86.0598 148.366 86.599 139.178 80.4833 135.638L78.9429 134.746L78.9328 130.659L78.923 126.572H90.1562C102.365 126.572 103.25 126.479 106.56 124.848C108.661 123.813 111.84 120.64 112.875 118.547C115.843 112.543 114.832 105.96 110.218 101.25L108.851 99.8543L110.519 98.0534C116.034 92.0971 115.905 83.2765 110.218 77.4712L108.851 76.0757L110.519 74.2748C114.889 69.5551 115.774 63.1833 112.875 57.3174C111.84 55.2243 108.661 52.0514 106.56 51.0167C102.971 49.2479 103.735 49.2904 75.8137 49.3118C54.808 49.3278 49.9604 49.406 48.6849 49.7496ZM103.662 56.2209C105.704 57.2238 107.242 58.9314 108.051 61.0946C109.636 65.3299 107.737 70.0856 103.662 72.0866L101.96 72.9221L76.8422 73.0148C59.2422 73.0796 51.2672 73.0089 50.1965 72.7779C45.7157 71.8113 42.5639 66.9195 43.5288 62.4292C44.2 59.3068 46.6455 56.594 49.6433 55.6461C50.5701 55.353 56.4753 55.2826 76.3964 55.3277L101.96 55.3854L103.662 56.2209ZM52.062 61.6677C50.4239 63.306 51.3679 66.1779 53.6978 66.644C55.4736 66.9992 76.9189 66.8199 78.031 66.4407C78.7253 66.2035 79.2592 65.7344 79.6379 65.0276C80.3136 63.7668 80.1311 62.6596 79.0731 61.6017L78.3556 60.8842H65.6007H52.8459L52.062 61.6677ZM85.737 61.753C85.0937 62.3962 84.8681 62.9039 84.8681 63.7079C84.8681 65.2164 86.1819 66.5316 87.6887 66.5316C89.164 66.5316 89.8917 66.0807 90.4071 64.8475C91.6455 61.8841 88.013 59.4771 85.737 61.753ZM96.1408 61.753C94.9708 62.9229 94.9554 64.3844 96.0995 65.6649C97.5534 67.2922 100.223 66.7117 100.914 64.618C101.864 61.7399 98.2959 59.5981 96.1408 61.753ZM103.662 79.9995C107.737 82.0005 109.636 86.7562 108.051 90.9914C107.242 93.1547 105.704 94.8623 103.662 95.8651L101.96 96.7007L76.8422 96.7934C59.2422 96.8582 51.2672 96.7875 50.1965 96.5565C45.7157 95.5899 42.5639 90.6981 43.5288 86.2078C43.9672 84.1688 45.5248 81.7535 47.1101 80.6549C49.4935 79.0032 48.7274 79.0439 76.3964 79.1063L101.96 79.164L103.662 79.9995ZM52.062 85.4463C50.4239 87.0846 51.3679 89.9565 53.6978 90.4225C55.4736 90.7777 76.9189 90.5985 78.031 90.2192C78.7253 89.982 79.2592 89.513 79.6379 88.8062C80.3136 87.5453 80.1311 86.4381 79.0731 85.3803L78.3556 84.6628H65.6007H52.8459L52.062 85.4463ZM85.737 85.5316C85.0937 86.1748 84.8681 86.6825 84.8681 87.4865C84.8681 88.9949 86.1819 90.3102 87.6887 90.3102C89.164 90.3102 89.8917 89.8593 90.4071 88.6261C91.6455 85.6627 88.013 83.2557 85.737 85.5316ZM96.1408 85.5316C95.002 86.6703 94.9649 88.1163 96.0415 89.3956C97.4273 91.0426 100.23 90.4677 100.914 88.3966C101.864 85.5185 98.2959 83.3766 96.1408 85.5316ZM103.662 103.778C107.737 105.779 109.636 110.535 108.051 114.77C107.242 116.933 105.704 118.641 103.662 119.644L101.96 120.479L76.8422 120.561C60.026 120.616 51.233 120.539 50.2381 120.329C45.7567 119.382 42.5645 114.471 43.5255 110.002C43.9672 107.947 45.5195 105.536 47.1101 104.433C49.4935 102.782 48.7274 102.822 76.3964 102.885L101.96 102.943L103.662 103.778ZM52.062 109.225C50.4239 110.863 51.3679 113.735 53.6978 114.201C55.4736 114.556 76.9189 114.377 78.031 113.998C78.7253 113.761 79.2592 113.292 79.6379 112.585C80.3136 111.324 80.1311 110.217 79.0731 109.159L78.3556 108.441H65.6007H52.8459L52.062 109.225ZM85.737 109.31C85.0937 109.953 84.8681 110.461 84.8681 111.265C84.8681 114.393 89.469 115.181 90.4981 112.229C91.5117 109.321 87.925 107.122 85.737 109.31ZM96.1408 109.31C95.002 110.449 94.9649 111.895 96.0415 113.174C97.4273 114.821 100.23 114.246 100.914 112.175C101.864 109.297 98.2959 107.155 96.1408 109.31ZM1.78579 140.526C-0.106521 141.301 -0.609474 143.781 0.833096 145.224L1.65054 146.041L29.1301 146.12L56.6094 146.199L57.5784 145.333C58.3816 144.616 58.5478 144.253 58.5478 143.217C58.5478 142.183 58.3813 141.819 57.5835 141.107L56.6195 140.245L29.4999 140.264C14.584 140.274 2.11277 140.392 1.78579 140.526ZM78.0244 141.293C79.7708 143.038 78.4421 146.028 75.9202 146.028C74.911 146.028 74.5466 145.855 73.807 145.028C73.0624 144.194 72.9414 143.855 73.0817 142.991C73.4972 140.43 76.224 139.493 78.0244 141.293ZM94.8261 140.524C93.8873 140.912 93.1802 141.866 92.9977 142.991C92.8574 143.856 92.9783 144.194 93.7289 145.034L94.6287 146.041H122.439H150.25L151.068 145.224C152.208 144.083 152.208 142.352 151.068 141.211L150.25 140.394L122.835 140.336C107.757 140.304 95.153 140.389 94.8261 140.524Z"
      />
    </svg>
  ),
  dataSecurity: (
    <svg
      xmlns="http://www.w3.org/2000/svg"
      width="100%"
      height="100%"
      viewBox="0 0 139 152"
      className="pointer-events-none">
      <path
        fillRule="evenodd"
        clipRule="evenodd"
        d="M21.741 0.477394C18.6798 1.4214 16.0387 4.10914 15.1171 7.21842C14.8453 8.13452 14.6693 9.91952 14.6693 11.7562V14.7835L11.039 14.9079C7.91607 15.0148 7.1749 15.14 5.73494 15.8038C3.6119 16.7829 1.78817 18.6044 0.784732 20.7483L0 22.4249V80.7573V139.09L0.876896 140.825C1.96835 142.985 4.11362 144.953 6.24881 145.753C7.8654 146.359 8.17864 146.363 56.2995 146.363H104.723L106.083 147.541C109.042 150.107 112.45 151.995 114.131 152C116.711 152.008 120.658 149.528 124.926 145.217C131.265 138.814 136.355 129.269 138.293 120.147C139.152 116.106 139.249 109.585 138.471 108.161C137.582 106.532 135.993 105.496 126.541 100.379L117.354 95.4057L117.206 61.1131C117.077 31.3003 117 26.7507 116.616 26.287C115.99 25.5324 87.0519 0.831248 86.2805 0.393681C85.2652 -0.182222 23.6205 -0.102367 21.741 0.477394ZM81.9983 14.1871C82.0975 22.3911 82.1011 22.4317 82.8879 24.1229C84.4977 27.5825 87.8269 30.1666 91.5659 30.8592C92.5776 31.0465 97.0857 31.1822 102.295 31.1822H111.279L111.278 63.317L111.276 95.4517L102.196 100.35C97.2022 103.044 92.5918 105.624 91.9508 106.083C90.1476 107.374 89.6598 108.779 89.6521 112.705C89.645 116.239 90.1814 120.063 91.1317 123.254C91.4554 124.341 91.72 125.309 91.72 125.406C91.72 125.503 87.4392 125.583 82.2072 125.583H72.6944L71.6868 126.592C70.6087 127.672 70.4309 128.571 71.0334 129.895C71.7502 131.472 72.1218 131.52 83.6297 131.521L94.239 131.522L95.2578 133.495C95.8182 134.581 96.979 136.551 97.8375 137.873L99.3987 140.277L54.1916 140.352C3.83683 140.436 7.66803 140.595 6.4201 138.371L5.7788 137.228L5.7794 80.7169C5.77969 27.5027 5.80992 24.1467 6.29801 23.1881C7.23951 21.3381 8.10455 20.9531 11.5751 20.8394L14.6628 20.7385L14.7401 72.3506L14.8174 123.963L15.793 125.948C16.854 128.107 18.3704 129.614 20.5737 130.702C21.9103 131.362 22.1198 131.373 35.0545 131.457L48.1789 131.543L49.057 130.664C50.2054 129.513 50.2738 127.792 49.22 126.564L48.5049 125.731L35.9053 125.583C23.7506 125.44 23.2761 125.413 22.4695 124.819C22.0098 124.481 21.3997 123.747 21.114 123.187C20.6238 122.226 20.5989 119 20.6694 65.4166L20.7444 8.66471L21.3582 7.82638C21.6957 7.36537 22.4292 6.75473 22.9881 6.46945C23.9349 5.98557 25.9779 5.95025 52.9513 5.94995L81.8987 5.94936L81.9983 14.1871ZM98.6359 18.664L105.996 24.9482H98.9945C90.9868 24.9482 90.336 24.7923 88.8309 22.5161C88.0198 21.2891 88.015 21.2532 87.9187 15.3481L87.8218 9.41338L89.5486 10.8965C90.4984 11.7122 94.5878 15.2077 98.6359 18.664ZM31.6797 18.2392C30.5429 19.378 30.3938 20.3772 31.1655 21.6857C31.437 22.1462 31.9766 22.6677 32.3649 22.845C32.85 23.0661 39.2342 23.1671 52.7593 23.1671H72.4478L73.4089 22.3068C74.2043 21.5949 74.3702 21.2316 74.3702 20.1985C74.3702 19.1654 74.2043 18.8021 73.4089 18.0902L72.4478 17.2299H52.5676H32.6873L31.6797 18.2392ZM32.5984 35.7496C31.4337 36.2582 30.9726 36.8474 30.7918 38.0577C30.5799 39.4758 31.5123 40.8547 32.9534 41.2554C34.6118 41.7168 62.1956 41.6526 63.5668 41.1845C64.3051 40.9322 64.7632 40.5038 65.1559 39.6984C65.6502 38.6847 65.665 38.4528 65.2966 37.472C64.4849 35.31 64.7096 35.3376 48.1567 35.3504C36.7473 35.359 33.2898 35.4477 32.5984 35.7496ZM77.1343 39.9552C73.4365 40.8532 69.4855 43.6903 67.4007 46.945C66.0932 48.9856 65.0895 51.8791 64.8583 54.2732C64.6678 56.2449 64.6524 56.2731 63.4495 56.8796C62.6988 57.2578 61.9778 57.9397 61.5659 58.6608C60.9012 59.8244 60.8988 59.8743 60.9732 71.4063L61.0479 82.9837L61.7594 83.9832C62.1509 84.5327 63.0177 85.2312 63.6857 85.5352C64.8222 86.052 65.9418 86.088 81.0627 86.0942L97.225 86.1007L98.5301 85.4328C99.2476 85.0653 100.109 84.3879 100.445 83.9268C101.037 83.1135 101.055 82.7326 101.055 71.1388V59.1889L100.239 58.1178C99.7908 57.5288 98.9574 56.8778 98.3872 56.6712C97.5047 56.3515 97.3506 56.1583 97.3506 55.371C97.3506 50.0834 93.6071 43.9978 88.7974 41.4659C85.2202 39.5829 80.9468 39.0293 77.1343 39.9552ZM85.6039 46.5766C88.7411 48.1235 90.8431 51.071 91.2971 54.5597L91.5001 56.1182H81.0897C72.1906 56.1182 70.6792 56.0555 70.6792 55.6874C70.6792 54.8132 71.3576 52.0836 71.7893 51.22C74.343 46.1141 80.4818 44.0506 85.6039 46.5766ZM32.1207 54.1886C30.4202 55.1142 30.3064 57.5852 31.902 58.9303L32.7919 59.6805H41.9369C47.0312 59.6805 51.4115 59.5549 51.8264 59.397C52.8556 59.0048 53.6122 57.7355 53.576 56.4613C53.5535 55.6622 53.3132 55.184 52.6248 54.5677L51.7034 53.7433L42.2991 53.7552C34.7546 53.7647 32.7415 53.8505 32.1207 54.1886ZM95.2762 71.1095V80.1636H81.0514H66.8267V71.1095V62.0553H81.0514H95.2762V71.1095ZM80.2465 67.0208C79.8853 67.0867 79.252 67.5427 78.8389 68.0346C78.1831 68.8153 78.0879 69.2072 78.0879 71.1276C78.0879 73.1343 78.1629 73.4107 78.9468 74.2891C79.6574 75.0858 80.0201 75.2521 81.0514 75.2521C82.0827 75.2521 82.4455 75.0858 83.1561 74.2891C83.9411 73.4092 84.0149 73.1361 84.0149 71.1095C84.0149 69.0988 83.9391 68.8118 83.2 68.0257C82.3637 67.1366 81.4035 66.8098 80.2465 67.0208ZM32.7466 72.0612C31.867 72.3833 30.9741 73.449 30.7987 74.3862C30.593 75.4845 31.2515 77.0083 32.1376 77.483C32.495 77.6747 36.2933 77.7887 42.318 77.7887H51.9283L52.6766 77.0395C53.6163 76.0981 53.8469 74.9442 53.3393 73.7268C52.5871 71.9237 52.1367 71.8489 42.1705 71.875C37.2318 71.8878 32.991 71.9718 32.7466 72.0612ZM32.0798 90.5773C30.5376 91.4771 30.3538 94.0274 31.7375 95.33L32.4973 96.0454L43.2847 96.1303C55.3432 96.225 55.518 96.1995 56.3347 94.242C56.8531 92.9994 56.6412 92.0091 55.644 91.0098L54.8918 90.2567L43.7453 90.2656C36.7268 90.2716 32.4063 90.3867 32.0798 90.5773ZM123.752 105.678L133.061 110.708L133.153 112.098C133.291 114.197 132.395 119.694 131.393 122.889C130.202 126.684 127.125 132.831 124.769 136.121C122.347 139.504 119.28 142.665 116.571 144.571L114.457 146.058L113.286 145.398C105.722 141.14 97.812 128.451 96.0298 117.716C95.7589 116.083 95.5785 113.827 95.6288 112.701L95.7207 110.655L104.908 105.669C109.96 102.926 114.173 100.674 114.269 100.665C114.365 100.655 118.633 102.911 123.752 105.678ZM31.8904 109.125C30.3423 110.43 30.3761 112.486 31.9663 113.776C32.5522 114.251 34.1791 114.289 54.1806 114.296L75.7628 114.302L76.629 113.434C78.0219 112.039 77.6176 109.516 75.8736 108.72C75.2943 108.455 69.7125 108.365 53.9444 108.365H32.7919L31.8904 109.125ZM121.503 114.352C121.177 114.532 118.96 116.699 116.577 119.167L112.244 123.653L110.502 121.997C109.544 121.086 108.394 120.248 107.947 120.136C105.978 119.642 103.813 121.754 104.299 123.694C104.563 124.75 110.048 130.048 111.362 130.516C113.086 131.131 113.757 130.651 119.557 124.656C122.583 121.529 125.221 118.688 125.419 118.343C125.865 117.567 125.9 116.231 125.495 115.473C124.849 114.264 122.734 113.67 121.503 114.352ZM58.5037 126.409C57.6698 127.156 57.505 127.509 57.505 128.551C57.505 129.584 57.671 129.948 58.4664 130.66C59.7819 131.837 61.2239 131.834 62.4043 130.652C64.1883 128.865 63.2225 126.016 60.7189 125.679C59.6633 125.538 59.3697 125.634 58.5037 126.409Z"
      />
    </svg>
  ),
  qualityServices: (
    <svg
      xmlns="http://www.w3.org/2000/svg"
      width="100%"
      height="100%"
      viewBox="0 0 152 152"
      className="pointer-events-none">
      <path
        fillRule="evenodd"
        clipRule="evenodd"
        d="M69.0487 0.284773C37.7299 3.19813 11.516 25.0397 2.8496 55.4419C1.06738 61.6943 0.00208202 69.442 3.11002e-06 76.169C-0.00504568 93.0797 6.13725 110.41 16.8362 123.673C19.9472 127.529 26.3787 133.779 30.1552 136.617C55.4612 155.63 89.7582 157.151 116.343 140.44C122.842 136.354 130.231 129.826 134.986 123.97C140.058 117.721 144.948 109.065 147.554 101.72C155.391 79.6322 152.772 55.2702 140.451 35.6636C128.899 17.2816 109.885 4.56659 88.6499 1.02381C82.5364 0.00407128 75.0876 -0.276928 69.0487 0.284773ZM82.1161 6.19674C90.7597 6.98924 98.6414 9.19772 106.469 13.0206C124.611 21.8807 138.004 37.8982 143.588 57.4134C144.165 59.4315 145.523 65.9482 145.523 66.7024C145.523 66.7603 143.901 66.7704 141.919 66.7246L138.315 66.6412L137.62 63.1893C137.237 61.2909 136.467 58.3413 135.908 56.6345C127.115 29.787 101.619 11.9673 73.652 13.1222C57.4885 13.7896 43.0317 20.129 31.6004 31.5627C22.5993 40.5653 16.8876 51.1307 14.4036 63.3738L13.7407 66.6412L10.1368 66.7246C8.15468 66.7704 6.53284 66.7603 6.53284 66.7024C6.53284 65.8724 7.91709 59.3563 8.5972 56.9836C17.8341 24.7676 49.0992 3.16961 82.1161 6.19674ZM81.7134 19.2777C103.212 21.4527 121.298 35.2032 129.179 55.365C130.383 58.445 131.645 62.8997 132.015 65.3788L132.226 66.7897H76.0618C22.7674 66.7897 19.8976 66.7633 19.9038 66.2699C19.9175 65.1477 21.1262 60.3353 22.1487 57.3302C27.3665 41.9959 39.1976 29.4665 54.3018 23.2791C62.9682 19.7292 72.4685 18.3424 81.7134 19.2777ZM74.3921 27.1C74.0832 27.326 72.955 28.8278 71.8852 30.4378L69.9397 33.3648L66.5296 34.3103C62.626 35.3927 61.7725 36.0429 61.7725 37.935C61.7725 38.8758 62.1206 39.4832 64.018 41.8542L66.2635 44.6603L66.1712 48.5705C66.0821 52.3402 66.1044 52.5081 66.7845 53.2337C67.9911 54.5211 68.8652 54.5021 72.6277 53.1075L76.0279 51.8475L79.4281 53.1075C83.1906 54.5021 84.0647 54.5211 85.2713 53.2337C85.952 52.5075 85.9737 52.3429 85.8811 48.5643L85.7851 44.6472L88.0342 41.8459C89.9349 39.4782 90.2833 38.8722 90.2833 37.933C90.2833 36.0402 89.4161 35.3769 85.519 34.2874L82.1161 33.3363L80.1706 30.4235C77.9375 27.0801 77.5042 26.6895 76.0279 26.6895C75.4369 26.6895 74.7007 26.8742 74.3921 27.1ZM77.1986 36.762C78.1401 38.2291 79.1053 38.8273 81.2923 39.2993L82.2507 39.5064L81.0696 41.0706C79.9458 42.5593 79.8887 42.7391 79.8887 44.7862C79.8887 46.3908 79.7943 46.8988 79.5175 46.7847C79.3135 46.7007 78.4445 46.398 77.5871 46.1116C76.1016 45.6162 75.9542 45.6162 74.4687 46.1116C73.6113 46.398 72.7426 46.7007 72.5383 46.7847C72.2615 46.8988 72.1671 46.3908 72.1671 44.7862C72.1671 42.7391 72.11 42.5593 70.9862 41.0706L69.8051 39.5064L70.7635 39.2993C72.9505 38.8273 73.9157 38.2291 74.8572 36.762C75.3719 35.96 75.8987 35.3036 76.0279 35.3036C76.1571 35.3036 76.6839 35.96 77.1986 36.762ZM44.4816 36.4796C44.0747 36.7998 43.1731 37.9347 42.4778 39.002C41.4188 40.6277 41.0267 40.991 40.0592 41.242C39.4242 41.4065 38.3874 41.6757 37.7554 41.8393C36.1502 42.2558 35.0992 43.1712 34.8791 44.3448C34.6572 45.5265 34.9346 46.1176 36.8446 48.534L38.263 50.3284L38.0967 52.7534C37.9027 55.5821 38.2734 56.7994 39.5255 57.4469C40.6989 58.0538 41.2127 57.9985 43.8906 56.9755L46.2546 56.0728L48.5269 56.9755C51.0275 57.9691 51.5817 58.0437 52.6963 57.5357C54.0719 56.909 54.382 56.0413 54.3249 52.9807L54.2727 50.1855L55.8241 48.2358C58.7266 44.5875 58.1255 42.7527 53.6401 41.5675L51.1213 40.9022L49.8437 38.9408C49.1407 37.862 48.3047 36.7359 47.9855 36.4386C47.2097 35.7156 45.426 35.7367 44.4816 36.4796ZM104.07 36.4386C103.751 36.7359 102.915 37.862 102.212 38.9408L100.934 40.9022L98.4157 41.5675C93.9303 42.7527 93.3292 44.5875 96.2317 48.2358L97.7831 50.1855L97.7308 52.9807C97.6738 56.0413 97.9839 56.909 99.3595 57.5357C100.474 58.0437 101.028 57.9691 103.529 56.9755L105.801 56.0728L108.165 56.9755C110.843 57.9985 111.357 58.0538 112.53 57.4469C113.781 56.8 114.153 55.5815 113.96 52.7626L113.794 50.3468L115.406 48.2863C117.188 46.008 117.498 45.2271 117.097 44.0229C116.707 42.8543 115.688 42.2148 113.093 41.509C110.807 40.8879 110.806 40.8867 109.56 38.9747C108.875 37.9226 107.981 36.7998 107.574 36.4796C106.63 35.7367 104.846 35.7156 104.07 36.4386ZM48.4998 46.294C49.2313 46.294 49.4059 46.8718 48.8574 47.4777C48.5827 47.7816 48.286 48.5658 48.1981 49.2201C48.0454 50.3596 48.0056 50.3979 47.2697 50.1178C46.5492 49.8439 45.8454 49.9039 44.7233 50.3346C44.3506 50.4775 44.2502 50.3121 44.2502 49.554C44.2502 49.025 43.9752 48.1466 43.639 47.6028L43.0278 46.6133L44.0474 46.1874C44.6084 45.953 45.3135 45.4347 45.6146 45.0355L46.1617 44.3098L47.0972 45.3019C47.6118 45.8476 48.2429 46.294 48.4998 46.294ZM108.021 46.1927L109.028 46.6133L108.417 47.6028C108.081 48.1466 107.806 49.025 107.806 49.554C107.806 50.3121 107.705 50.4775 107.332 50.3346C106.21 49.9039 105.507 49.8439 104.786 50.1178C104.05 50.3979 104.01 50.3596 103.858 49.2201C103.77 48.5658 103.486 47.7961 103.227 47.5101C102.569 46.7829 102.621 46.6555 103.773 46.1743C104.332 45.9408 105.015 45.405 105.291 44.9841L105.793 44.2183L106.403 44.9951C106.739 45.4225 107.467 45.9613 108.021 46.1927ZM146.025 77.8544C145.661 88.1343 143.76 96.2669 139.535 105.628L138.027 108.969H113.269H88.5109L87.5477 109.83C86.7506 110.542 86.5843 110.906 86.5843 111.94C86.5843 112.973 86.7506 113.337 87.5477 114.049L88.5109 114.91H103.119H117.727L116.553 116.135C111.483 121.424 103.129 126.781 95.6291 129.554C89.2017 131.929 83.6917 132.858 76.0279 132.858C68.36 132.858 62.8411 131.927 56.4267 129.551C48.9088 126.767 40.681 121.488 35.5031 116.126L34.3291 114.91H48.937H63.5449L64.5081 114.049C65.3052 113.337 65.4715 112.973 65.4715 111.94C65.4715 110.906 65.3052 110.542 64.5081 109.83L63.5449 108.969H38.794H14.0431L12.7019 106.073C8.46682 96.9267 6.39652 88.1685 6.03063 77.8544L5.84887 72.7305H76.0279H146.207L146.025 77.8544ZM23.8243 80.7517C20.8818 81.3716 18.0467 83.6737 16.5888 86.6271C16.0115 87.7966 15.8971 88.4943 15.8971 90.8499C15.8971 93.2054 16.0115 93.9031 16.5888 95.0726C17.682 97.287 19.42 99.041 21.5705 100.1C23.2253 100.914 23.8439 101.057 25.7871 101.072C27.3015 101.084 28.5313 100.911 29.4579 100.556C30.7029 100.079 30.9247 100.069 31.5368 100.461C33.6484 101.815 36.2316 100.584 36.2316 98.2247C36.2316 97.5879 36.0237 96.7496 35.7698 96.362C35.3507 95.7222 35.354 95.4994 35.8057 93.9453C36.5084 91.528 36.2761 88.4355 35.2322 86.301C33.2436 82.2357 28.2679 79.8155 23.8243 80.7517ZM41.2135 80.9166C40.7684 81.1581 40.2673 81.6119 40.0998 81.9247C39.919 82.2631 39.7954 85.0953 39.7954 88.909C39.7954 96.0059 39.9335 96.7161 41.6667 98.525C44.9716 101.975 50.424 101.969 53.7788 98.5117C55.5919 96.6433 55.8328 95.4774 55.8328 88.5739V82.5423L54.9721 81.579C54.2599 80.7817 53.8964 80.6154 52.8629 80.6154C51.8294 80.6154 51.4658 80.7817 50.7537 81.579L49.893 82.5423V88.2837C49.893 93.6943 49.858 94.057 49.2842 94.5762C48.5759 95.2175 46.8946 95.304 46.2083 94.7345C45.8082 94.4021 45.7349 93.5324 45.7334 89.1056C45.7316 83.0345 45.5009 81.8522 44.1579 81.0333C43.0365 80.3492 42.3115 80.3207 41.2135 80.9166ZM65.1879 80.8652C64.6975 81.0788 64.1374 81.4453 63.9429 81.68C63.7484 81.9143 62.2382 85.6442 60.5872 89.9682C57.3729 98.3866 57.2467 99.0368 58.5843 100.286C60.2386 101.83 62.5467 101.219 63.4609 98.9947L63.9999 97.6838L66.391 97.6829L68.7817 97.6817L69.425 99.0056C69.8212 99.8216 70.4321 100.518 71.0171 100.82C72.9006 101.795 75.1369 100.357 75.1369 98.173C75.1369 97.5353 69.9394 83.3256 69.2022 81.9482C68.9061 81.3951 67.1625 80.4452 66.4795 80.4651C66.2591 80.4716 65.6779 80.6516 65.1879 80.8652ZM80.5979 80.7333C80.2531 80.8788 79.685 81.3615 79.3357 81.8056C78.7216 82.5862 78.7008 82.8845 78.7008 90.8852V99.1574L79.5671 100.128C80.4156 101.078 80.4916 101.1 83.299 101.201C84.8755 101.258 86.609 101.222 87.1516 101.12C89.6076 100.659 90.5411 97.8938 88.8212 96.1737C88.0693 95.4216 87.7316 95.3054 86.2968 95.3054H84.6405V88.9238V82.5423L83.8238 81.6455C82.9471 80.6834 81.6116 80.3056 80.5979 80.7333ZM96.4532 80.9166C96.008 81.1581 95.507 81.6119 95.3395 81.9247C95.1521 82.2749 95.0351 85.7304 95.0351 90.9128C95.0351 100.331 95.0416 100.363 97.0766 100.973C98.0151 101.254 98.3679 101.227 99.168 100.813C100.833 99.9526 100.975 99.1675 100.975 90.8499C100.975 82.6035 100.824 81.7423 99.2309 80.9187C98.1273 80.3477 97.5019 80.3474 96.4532 80.9166ZM107.141 80.9184C106.364 81.3402 105.43 82.716 105.43 83.4384C105.43 83.6262 105.637 84.2158 105.889 84.7487C106.399 85.8225 107.379 86.3943 108.71 86.3943H109.587V92.7759V99.1574L110.448 100.121C111.609 101.421 113.347 101.483 114.562 100.268L115.379 99.4518L115.469 92.9229L115.559 86.3943H116.56C117.743 86.3943 119.233 85.2703 119.509 84.1697C119.778 83.0977 118.989 81.4605 117.941 80.9187C116.68 80.2667 108.343 80.2664 107.141 80.9184ZM122.952 80.7826C121.874 81.2056 121.184 82.2336 121.177 83.4289C121.171 84.2348 121.706 85.3044 123.514 88.1085L125.858 91.743L125.713 94.7865C125.531 98.6144 125.917 99.9639 127.426 100.773C128.669 101.439 129.789 101.266 130.803 100.252C131.418 99.6374 131.489 99.2311 131.63 95.5264L131.785 91.4736L134.051 87.9805C136.593 84.0607 136.81 83.1652 135.575 81.6969C133.926 79.7367 131.894 80.3115 130.045 83.2608C129.374 84.3307 128.783 85.2061 128.732 85.2061C128.68 85.2061 128.143 84.3916 127.538 83.3963C126.478 81.6503 125.067 80.4366 124.14 80.4734C123.895 80.4832 123.36 80.6222 122.952 80.7826ZM27.8354 86.9776C29.1517 87.5753 30.2889 89.0421 30.2906 90.145C30.2918 90.7174 30.1671 90.7628 28.9696 90.6277C27.7841 90.4943 27.5497 90.5763 26.7057 91.4205C25.8412 92.2851 25.7758 92.4848 25.9074 93.8556C26.0503 95.3408 26.0467 95.3479 25.2757 95.1581C21.1396 94.1393 20.3653 88.9604 24.0658 87.0626C25.6458 86.2523 26.21 86.2395 27.8354 86.9776ZM74.1833 109.83C73.3862 110.542 73.2199 110.906 73.2199 111.94C73.2199 114.908 77.2271 115.988 78.5746 113.382C79.4177 111.751 79.0004 110.184 77.5188 109.418C76.2272 108.75 75.2578 108.87 74.1833 109.83ZM28.0644 116.724C31.7013 121.156 38.26 126.719 43.7008 129.988C50.6319 134.151 58.6099 137.039 66.6271 138.285C70.7611 138.927 80.532 138.996 84.6405 138.411C100.057 136.217 114.376 128.222 124.482 116.164L125.547 114.894L129.939 114.976L134.331 115.059L132.055 118.08C127.985 123.482 121.702 129.561 116.27 133.35C106.981 139.831 96.5595 143.872 84.789 145.56C81.3297 146.055 70.7261 146.055 67.2668 145.56C53.995 143.657 42.5328 138.799 32.2222 130.705C28.0285 127.414 20.7844 119.634 18.2748 115.727L17.7501 114.91L22.1648 114.912L26.5795 114.914L28.0644 116.724Z"
      />
    </svg>
  ),
  growthGraph: (
    <svg
      xmlns="http://www.w3.org/2000/svg"
      width="100%"
      height="100%"
      viewBox="0 0 152 153"
      className="pointer-events-none">
      <path
        fillRule="evenodd"
        clipRule="evenodd"
        d="M1.89829 0.253431C1.55328 0.393614 0.984806 0.874243 0.635339 1.3211L0 2.1335V76.514V150.895L0.867128 151.871L1.73426 152.847L75.8948 152.923L150.055 153L151.028 152.126L152 151.252V100.39V49.5286L151.019 48.6474L150.039 47.766L137.102 47.85L124.166 47.9337L123.299 48.9099L122.432 49.8861V98.4523V147.018H119.019H115.606L115.527 116.207L115.449 85.3964L114.468 84.5149L113.487 83.6338L100.551 83.7178L87.6144 83.8015L86.7476 84.7777L85.8807 85.7539V116.386V147.018H82.4663H79.0519L78.9746 104.251L78.8974 61.4845L77.9167 60.6031L76.9361 59.7219L63.9996 59.8059L51.0631 59.8896L50.1963 60.8658L49.3294 61.842V104.43V147.018H45.9177H42.5059L42.426 125.174L42.346 103.33L41.3654 102.449L40.3848 101.568L27.4795 101.652L14.5742 101.735L13.7504 102.564L12.9267 103.393L12.8467 125.205L12.7668 147.018H9.35684H5.94687L5.8708 74.3617L5.79472 1.70488L4.82418 0.832696C3.84145 -0.0505483 3.03792 -0.209562 1.89829 0.253431ZM132.61 0.403478C130.287 1.06105 128.752 1.944 127.172 3.53294C123.751 6.97505 122.715 12.3582 124.655 16.6199C125.104 17.6075 125.306 18.41 125.155 18.6082C124.413 19.5826 106.574 43.1636 106.53 43.2296C106.501 43.2727 105.858 43.0326 105.102 42.6961C101.743 41.2019 96.371 41.8828 93.8356 44.1242C93.1907 44.6942 94.1238 45.4522 83.8475 36.0103L75.425 28.2716L75.6755 26.8939C76.8339 20.5193 73.9808 14.9682 68.4229 12.782C66.0358 11.8432 62.3396 11.8432 59.9525 12.782C55.1934 14.6537 52.4428 18.8344 52.4592 24.1713C52.4657 26.289 52.5997 27.0003 53.2654 28.4446L54.0639 30.1773L44.2235 42.1939C38.8116 48.8032 34.1615 54.45 33.8902 54.7423C33.4186 55.2513 33.3339 55.245 31.9283 54.6018C29.8586 53.6543 25.8361 53.6659 23.4012 54.626C16.3206 57.4183 13.6616 66.02 17.8929 72.4454C20.0138 75.6661 23.5254 77.4807 27.6364 77.4807C34.5172 77.4807 39.3863 72.4735 39.3649 65.4192C39.3583 63.3015 39.2243 62.5902 38.5587 61.1459L37.7602 59.4132L47.6005 47.3966C53.0125 40.7873 57.6625 35.1405 57.9338 34.8482C58.4057 34.3389 58.4857 34.3425 59.8137 34.9334C63.1833 36.4327 68.5519 35.7554 71.0911 33.5103C71.736 32.9403 70.8029 32.1823 81.0792 41.6242L89.5017 49.363L89.2512 50.7406C88.0928 57.1152 90.9459 62.6664 96.5038 64.8525C98.8909 65.7914 102.587 65.7914 104.974 64.8525C109.733 62.9808 112.484 58.8001 112.468 53.4633C112.461 51.3357 112.328 50.6363 111.649 49.1627C111.164 48.1094 110.94 47.2692 111.091 47.0705C111.834 46.0961 129.672 22.5151 129.716 22.449C129.746 22.406 130.425 22.6708 131.227 23.0378C133.285 23.98 137.314 23.9662 139.743 23.0086C146.823 20.2162 149.482 11.6146 145.251 5.18914C142.67 1.26968 137.057 -0.855182 132.61 0.403478ZM138.661 6.89136C139.22 7.27156 140.043 8.10907 140.49 8.7526C141.177 9.74285 141.302 10.2286 141.302 11.9164C141.302 13.6043 141.177 14.09 140.49 15.0803C139.136 17.0294 137.804 17.745 135.529 17.745C133.99 17.745 133.335 17.5946 132.441 17.0357C130.209 15.6392 129.135 12.8364 129.833 10.2271C130.225 8.76545 132.176 6.66868 133.537 6.24634C135.005 5.79082 137.506 6.10556 138.661 6.89136ZM67.3418 18.8473C67.9005 19.2275 68.7233 20.065 69.17 20.7085C69.8561 21.6967 69.9821 22.1842 69.9797 23.847C69.9765 26.1311 69.2122 27.5533 67.2616 28.9043C65.6818 29.9983 62.7975 30.0395 61.1218 28.9916C58.8889 27.5951 57.8153 24.7924 58.5136 22.183C58.905 20.7214 60.8559 18.6246 62.2175 18.2023C63.6855 17.7467 66.1867 18.0615 67.3418 18.8473ZM104.003 48.7921C105.782 49.976 106.534 51.4595 106.534 53.7876C106.534 55.4477 106.407 55.9394 105.721 56.926C104.364 58.8817 103.038 59.5907 100.739 59.5907C98.4401 59.5907 97.1145 58.8817 95.7567 56.926C95.0706 55.9379 94.9446 55.4504 94.947 53.7876C94.9493 52.1502 95.0819 51.6263 95.7362 50.6704C96.541 49.4951 98.0642 48.2837 99.112 47.986C100.369 47.6291 102.877 48.0422 104.003 48.7921ZM146.205 100.39V147.018H137.29H128.375V100.39V53.7622H137.29H146.205V100.39ZM30.9007 60.748C32.6799 61.932 33.4311 63.4154 33.4311 65.7435C33.4311 67.4036 33.3039 67.8953 32.6186 68.882C31.2609 70.8377 29.9352 71.5466 27.6364 71.5466C26.0204 71.5466 25.4617 71.4106 24.564 70.7994C22.2806 69.2448 21.2702 66.6145 21.9623 64.0288C22.3537 62.5671 24.3045 60.4704 25.6662 60.048C27.1775 59.579 29.6393 59.9081 30.9007 60.748ZM73.1026 106.368V147.018H64.1877H55.2727V106.368V65.7181H64.1877H73.1026V106.368ZM136.217 77.967C135.872 78.1072 135.303 78.5878 134.954 79.0346C134.328 79.8357 134.319 80.0237 134.319 92.6545V105.462L135.136 106.374C135.649 106.947 136.352 107.35 137.027 107.457C137.933 107.602 138.257 107.488 139.107 106.724L140.113 105.82V92.619V79.4184L139.143 78.5462C138.16 77.663 137.357 77.504 136.217 77.967ZM109.654 118.324V147.018H100.739H91.8241V118.324V89.63H100.739H109.654V118.324ZM36.5513 127.291V147.018H27.6364H18.7214V127.291V107.564H27.6364H36.5513V127.291ZM136.217 113.835C135.281 114.215 134.319 115.6 134.319 116.566C134.319 117.763 135.684 119.199 137.027 119.413C137.932 119.558 138.257 119.444 139.1 118.686C139.935 117.936 140.1 117.58 140.1 116.531C140.1 115.491 139.934 115.125 139.136 114.408C138.16 113.53 137.355 113.372 136.217 113.835Z"
      />
    </svg>
  ),
  agileDevelopment: (
    <svg
      xmlns="http://www.w3.org/2000/svg"
      width="100%"
      height="100%"
      viewBox="0 0 152 147"
      className="pointer-events-none">
      <path
        fillRule="evenodd"
        clipRule="evenodd"
        d="M41.0128 0.26001C38.0149 0.768015 35.6275 2.4845 34.2332 5.13484C33.4893 6.54824 33.437 6.91775 33.3396 11.4281L33.2362 16.2196L27.6895 16.3302C21.0731 16.4619 19.9566 16.8021 17.562 19.4168C15.5523 21.6116 15.1591 22.9441 15.1591 27.5636V31.3331L10.9245 31.4553C7.05743 31.5671 6.55789 31.6457 5.1719 32.3616C4.33716 32.7928 3.05785 33.8076 2.3289 34.6166C-0.192576 37.4156 0.00355466 32.821 0.00355466 89.0598C0.00355466 144.128 -0.116798 140.645 1.8772 143.254C2.93987 144.645 4.61828 145.895 6.23666 146.501C7.08002 146.817 14.4055 146.911 43.8159 146.983C65.536 147.036 81.1649 146.96 82.3637 146.794C85.9345 146.3 88.453 144.505 89.8491 141.458C90.3667 140.329 90.4966 139.375 90.5863 136.044L90.6954 131.999L94.6049 131.857C97.2328 131.761 98.9721 131.548 99.91 131.208C101.847 130.505 103.822 128.672 104.813 126.658C105.6 125.059 105.653 124.7 105.752 120.315L105.857 115.667L111.398 115.568C116.458 115.477 117.074 115.408 118.492 114.77C119.347 114.386 120.596 113.476 121.268 112.749C123.166 110.693 123.706 109.179 123.864 105.46L123.999 102.267L127.65 105.813C132.36 110.387 133.517 111.021 137.147 111.016C140.856 111.012 141.877 110.465 146.402 106.053C151.042 101.53 151.974 99.9361 151.992 96.4936C152.016 92.1212 152.581 92.851 137.405 77.6547L123.923 64.1542V44.3799C123.923 29.6119 123.832 24.4079 123.565 23.8237C123.241 23.1125 118.915 19.3376 102.378 5.33116C98.7953 2.29678 96.3517 0.442986 95.6917 0.25823C94.4572 -0.0872606 43.0522 -0.0854814 41.0128 0.26001ZM92.1803 13.0865C92.2722 19.8382 92.2906 20.0165 93.0647 21.6644C94.122 23.9153 95.985 25.8696 98.0268 26.8705L99.7035 27.692L108.767 27.8403L117.831 27.9886L117.908 42.8906C117.95 51.0869 117.882 57.7927 117.758 57.7927C117.632 57.7927 113.118 53.3793 107.725 47.9852C100.058 40.3156 97.5641 37.9977 96.286 37.3509C93.2754 35.8284 74.7797 28.9494 73.6905 28.9473C72.0835 28.9447 70.7652 29.7744 70.1183 31.1961C69.808 31.8785 69.551 32.6822 69.5474 32.982C69.54 33.5917 77.2111 53.8482 78.1894 55.8025C78.6072 56.6373 85.3057 63.5412 98.3968 76.6292L117.979 96.2074V101.476C117.979 105.43 117.871 107.003 117.544 107.783C116.737 109.711 116.942 109.69 98.5014 109.69H81.9762L81.1076 110.557C80.1801 111.483 79.9391 113.025 80.545 114.155C81.2743 115.515 82.0511 115.622 91.2478 115.622H99.9091L99.8063 119.768L99.7035 123.915L98.732 124.884L97.7606 125.853H60.5328C25.1669 125.853 23.2641 125.826 22.4876 125.319C22.0383 125.024 21.5426 124.449 21.3863 124.039C20.923 122.823 21.0172 24.9144 21.4826 23.985C22.232 22.488 23.4584 22.1908 28.5317 22.2762L33.1378 22.3539L33.2864 65.6515L33.435 108.949L34.0736 110.328C34.8884 112.087 36.6435 113.838 38.5097 114.755C39.9409 115.458 40.1611 115.475 48.6743 115.568L57.376 115.662L58.4066 114.634C59.5379 113.505 59.7076 112.555 59.0167 111.222C58.2696 109.78 57.7888 109.703 49.0859 109.62L40.9631 109.542L40.0966 108.574L39.2297 107.605V58.07C39.2297 4.88811 39.1617 7.37179 40.6413 6.51177C40.9833 6.31307 49.882 6.20631 66.6239 6.20038L92.0861 6.19148L92.1803 13.0865ZM105.64 15.9592L112.467 21.7608L107.008 21.8418C100.637 21.9364 99.9115 21.7341 98.7495 19.5411C98.1314 18.3747 98.069 17.8655 98.069 13.9862C98.069 10.6491 98.1502 9.76353 98.4405 9.93642C98.6449 10.0583 101.884 12.7686 105.64 15.9592ZM47.5505 13.6375C45.6233 14.3919 45.1425 16.8827 46.6361 18.3732L47.5047 19.2401H65.3805H83.2564L84.125 18.3732C85.6477 16.8537 85.1244 14.3157 83.1467 13.6277C81.9483 13.2107 48.6167 13.2199 47.5505 13.6375ZM47.1864 28.006C45.4902 28.9248 45.2186 31.1935 46.6361 32.608L47.5047 33.4749H54.0882H60.6716L61.5402 32.608C62.9215 31.2296 62.5821 28.8447 60.8799 27.9663C59.6779 27.3462 48.3445 27.3788 47.1864 28.006ZM84.9936 39.2495C89.1614 40.8281 92.6692 42.2136 92.7886 42.3287C92.9081 42.444 90.8065 44.7296 88.1189 47.4081C85.4311 50.0866 83.1794 52.218 83.1149 52.1442C83.0505 52.0703 81.7203 48.6735 80.159 44.5958C78.598 40.5182 77.2188 36.9265 77.0949 36.6143C76.9645 36.2866 76.9847 36.1169 77.1424 36.213C77.2928 36.3047 80.8259 37.6709 84.9936 39.2495ZM15.1591 80.8715C15.1591 120.075 15.2067 124.552 15.6364 125.811C16.286 127.713 18.6098 130.191 20.5765 131.078L22.1426 131.784L53.4442 131.865L84.7458 131.946L84.6468 135.523L84.5479 139.1L83.5773 139.964L82.6068 140.829L45.2426 140.82C16.3329 140.813 7.7745 140.729 7.41909 140.449C7.16649 140.25 6.73174 139.758 6.45329 139.354C5.98109 138.671 5.94692 135.282 5.94692 89.2955C5.94692 45.8482 6.00041 39.8663 6.39653 39.1024C7.14242 37.6629 8.0892 37.3554 11.816 37.342L15.1591 37.3302V80.8715ZM46.6361 42.6454C45.7086 43.5709 45.4676 45.1133 46.0735 46.2432C46.7936 47.586 47.6337 47.7097 56.0346 47.7097H63.9541L64.9645 46.7014C65.6052 46.062 65.9749 45.4055 65.9749 44.9072C65.9749 43.8939 65.2358 42.474 64.5054 42.084C64.1529 41.8957 60.7848 41.7785 55.7193 41.7785H47.5047L46.6361 42.6454ZM114.485 63.0545L131.053 79.5859L125.781 84.8528L120.509 90.1197L103.792 73.4391L87.0759 56.7589L92.1979 51.6412C95.0147 48.8266 97.4545 46.5235 97.6191 46.5235C97.7837 46.5235 105.374 53.9624 114.485 63.0545ZM46.5368 56.9259C45.1238 58.6014 45.7086 60.8929 47.7469 61.6661C48.1516 61.8197 52.9708 61.9442 58.4907 61.9439C67.4254 61.9436 68.6125 61.8879 69.5409 61.425C71.3367 60.5297 71.6686 58.2177 70.2101 56.7619L69.4598 56.0134H58.3831H47.3062L46.5368 56.9259ZM48.4954 69.5608C47.9525 69.8277 47.1502 70.5148 46.7124 71.0877L45.916 72.1295V79.1743C45.916 85.8267 45.9502 86.2644 46.5288 87.0378C46.8658 87.4883 47.5106 88.1318 47.9617 88.4681C48.7626 89.0651 49.1552 89.0817 64.4302 89.1615C75.2516 89.2181 80.3201 89.1434 80.8624 88.9192C81.9509 88.4693 83.3625 86.9032 83.7651 85.6992C84.1919 84.4231 84.2127 74.3644 83.7919 72.8523C83.3984 71.4386 82.1679 69.9822 80.9311 69.4664C80.1537 69.1423 76.9321 69.0634 64.7214 69.0688C51.2205 69.0747 49.3694 69.1307 48.4954 69.5608ZM78.1588 79.1449V83.2968H64.9348H51.7108V79.1449V74.9931H64.9348H78.1588V79.1449ZM140.625 89.1538C144.971 93.5206 145.899 94.6028 146.066 95.504C146.176 96.1016 146.17 96.9023 146.051 97.2834C145.791 98.1223 139.849 104.234 138.722 104.823C137.697 105.358 136.589 105.356 135.572 104.817C135.13 104.584 132.497 102.115 129.721 99.3311L124.672 94.2694L129.866 89.0797C132.723 86.2253 135.133 83.8899 135.223 83.8899C135.312 83.8899 137.743 86.2588 140.625 89.1538ZM47.1864 96.8077C45.4902 97.7264 45.2186 99.9951 46.6361 101.41L47.5047 102.277H72.7729C91.7304 102.277 98.2357 102.188 98.8203 101.922C99.2488 101.727 99.7899 101.2 100.023 100.751C100.713 99.4189 100.548 98.4631 99.436 97.3536L98.4256 96.3453L73.2109 96.3572C51.5379 96.3673 47.8824 96.4308 47.1864 96.8077ZM67.735 110.557C66.8075 111.483 66.5665 113.025 67.1725 114.155C67.5632 114.884 68.9861 115.622 70.0015 115.622C71.0627 115.622 72.8097 113.875 72.8097 112.814C72.8097 110.064 69.6413 108.655 67.735 110.557Z"
      />
    </svg>
  ),
  dedicatedTeam: (
    <svg
      xmlns="http://www.w3.org/2000/svg"
      width="100%"
      height="100%"
      viewBox="0 0 152 152"
      className="pointer-events-none">
      <path
        fillRule="evenodd"
        clipRule="evenodd"
        d="M74.9272 0.252027C74.5823 0.391433 74.0079 0.877424 73.6506 1.33161C73.0167 2.13803 73.0037 2.33183 73.0898 9.52449L73.1783 16.891L73.9951 17.7079C75.1354 18.8481 76.8652 18.8481 78.0049 17.7076L78.8217 16.8901V9.29264V1.69543L77.8516 0.828082C76.8694 -0.0502682 76.0662 -0.208401 74.9272 0.252027ZM108.227 12.5801C107.737 12.7974 104.496 15.8391 101.024 19.3394C95.045 25.3684 94.7123 25.7628 94.7123 26.8255C94.7123 28.4609 95.9987 29.6849 97.7179 29.6849C98.9719 29.6849 99.0604 29.6118 105.189 23.5172C108.6 20.125 111.581 16.9882 111.814 16.5468C112.451 15.3374 112.327 14.3333 111.42 13.3699C110.422 12.3096 109.405 12.0582 108.227 12.5801ZM41.269 13.5596C40.4098 14.3576 40.2535 14.8092 40.3233 16.2921C40.3664 17.2058 51.5985 28.6467 53.0807 29.2866C55.0594 30.1409 56.9907 28.7682 56.9907 26.5077C56.9907 25.4492 56.6577 25.0572 50.6712 19.0663C44.7157 13.106 44.2886 12.7421 43.2505 12.7421C42.4601 12.7421 41.9002 12.9731 41.269 13.5596ZM74.0679 23.8631C73.1314 24.8004 72.8733 25.9138 73.3342 27.0273C73.8237 28.21 74.7041 28.7932 76 28.7932C77.2959 28.7932 78.1763 28.21 78.6658 27.0273C79.4472 25.1401 78.0774 23.1456 76 23.1456C75.1116 23.1456 74.5921 23.3385 74.0679 23.8631ZM73.3595 35.3872C64.5754 36.1273 56.3788 41.9001 52.4433 50.1188C51.8825 51.2894 51.3478 52.5384 51.2549 52.8942C51.0954 53.5041 50.9962 53.4631 49.5268 52.1769C46.1194 49.1938 42.5061 47.8179 37.5067 47.5997C32.7716 47.3928 30.527 47.7983 27.0248 49.4928C21.9169 51.9647 18.195 56.714 17.041 62.2329C16.4119 65.2428 16.4173 79.9138 17.0488 82.9462C17.9461 87.2556 20.5964 91.4551 23.9714 93.9157L25.7699 95.2268L25.7865 96.9451C25.7978 98.0732 25.6757 98.703 25.4322 98.7785C25.2281 98.8415 22.5214 99.5014 19.4175 100.245C11.9501 102.034 9.74025 103.102 6.18016 106.641C4.01517 108.793 3.39173 109.644 2.2378 112.021C0.270629 116.073 -0.0953009 118.294 0.0187551 125.496L0.111129 131.33L0.934471 132.153L1.75781 132.977L14.41 133.06L27.0619 133.144L26.8784 134.063C26.7771 134.569 26.6945 137.502 26.6945 140.581V146.18L17.1961 146.266L7.69794 146.352L6.88143 147.17C5.74205 148.311 5.74205 150.042 6.88172 151.183L7.69853 152H76H144.301L145.118 151.183C146.258 150.042 146.258 148.311 145.119 147.17L144.302 146.352L134.804 146.266L125.305 146.18V140.581C125.305 137.502 125.223 134.569 125.122 134.063L124.938 133.144L137.59 133.06L150.242 132.977L151.066 132.153L151.889 131.33L151.981 125.496C152.095 118.294 151.729 116.073 149.762 112.021C148.608 109.644 147.985 108.793 145.82 106.641C142.26 103.102 140.05 102.034 132.583 100.245C129.479 99.5014 126.772 98.8415 126.568 98.7785C126.324 98.703 126.202 98.0732 126.213 96.9451L126.23 95.2268L128.029 93.9157C131.355 91.4907 134.087 87.1641 134.956 82.9462C135.583 79.9049 135.585 65.2259 134.959 62.2329C133.805 56.714 130.083 51.9647 124.975 49.4928C121.473 47.7983 119.228 47.3928 114.493 47.5997C109.494 47.8179 105.881 49.1938 102.473 52.1769C101.004 53.4631 100.905 53.5041 100.745 52.8942C100.652 52.5384 100.118 51.2894 99.5567 50.1188C96.7716 44.3027 91.4706 39.3301 85.6582 37.0809C81.5638 35.4966 77.9568 34.9999 73.3595 35.3872ZM80.7072 41.7672C86.1745 42.9077 91.3266 47.0046 93.9297 52.2819C95.3667 55.1951 96.1835 58.2231 96.1924 60.6724L96.1974 62.0843H94.9149C93.2032 62.0843 90.9241 61.3804 89.6936 60.4721C89.1426 60.0654 88.1755 59.0447 87.5443 58.2041L86.3966 56.6754L87.6141 55.2929C88.2836 54.5323 89.027 53.5327 89.2662 53.071C90.3464 50.985 88.2768 48.5434 85.9285 49.1332C85.5082 49.2387 83.8996 50.5968 82.3542 52.1511C75.8161 58.7261 67.872 62.0828 58.847 62.084L55.8026 62.0843L55.8076 60.6724C55.8165 58.2282 56.6322 55.1972 58.0593 52.3039C61.0806 46.1786 66.9982 42.0434 73.7723 41.3234C76.2522 41.0601 77.7863 41.1582 80.7072 41.7672ZM40.3694 53.8882C43.6702 54.7508 46.8097 57.2018 48.2449 60.036C49.1062 61.7371 49.8622 64.4732 49.8622 65.8902V66.8961L48.3028 66.7058C44.4748 66.2392 43.0782 65.8105 39.3999 63.973C37.9745 63.2614 36.5342 62.6788 36.1992 62.6788C35.8641 62.6788 34.4239 63.2614 32.9985 63.973C29.3202 65.8105 27.9236 66.2392 24.0956 66.7058L22.5362 66.8961V65.8902C22.5362 64.4732 23.2921 61.7371 24.1535 60.036C25.5581 57.2619 28.7 54.7733 31.8924 53.9066C33.867 53.3707 38.3514 53.3608 40.3694 53.8882ZM119.971 53.8882C123.272 54.7508 126.411 57.2018 127.847 60.036C128.708 61.7371 129.464 64.4732 129.464 65.8902V66.8961L127.904 66.7058C124.076 66.2392 122.68 65.8105 119.002 63.973C117.576 63.2614 116.136 62.6788 115.801 62.6788C115.466 62.6788 114.026 63.2614 112.6 63.973C108.922 65.8105 107.525 66.2392 103.697 66.7058L102.138 66.8961V65.8902C102.138 64.4732 102.894 61.7371 103.755 60.036C105.16 57.2619 108.302 54.7733 111.494 53.9066C113.469 53.3707 117.953 53.3608 119.971 53.8882ZM84.6103 63.8678C87.3115 66.5655 90.7937 68.0291 94.5109 68.0291H96.2637L96.1175 74.3455C95.9539 81.405 95.7353 82.479 93.6469 86.4828C92.8631 87.9851 91.7828 89.3979 90.2555 90.9168C87.7314 93.4273 85.668 94.7542 82.4855 95.914C80.4996 96.6375 79.9254 96.7079 76 96.7079C72.0746 96.7079 71.5004 96.6375 69.5145 95.914C63.3024 93.6505 58.6834 88.8361 56.6161 82.4701C56.1326 80.9818 56.0031 79.552 55.8834 74.3869L55.7375 68.1121L60.1513 67.9522C64.7756 67.7848 67.4093 67.3392 71.1995 66.0831C73.9485 65.1721 78.2764 63.0703 80.3068 61.6607L81.7919 60.6296L82.3827 61.4313C82.7076 61.8721 83.7101 62.9686 84.6103 63.8678ZM37.9169 69.9264C40.6907 71.3291 46.5813 72.785 49.4832 72.785C49.9596 72.785 50.0142 79.0348 49.5589 81.4374C48.6441 86.2649 45.0427 90.1633 40.3694 91.3846C38.2617 91.9354 34.2142 91.9262 32.0522 91.3656C27.3269 90.1401 23.7602 86.2967 22.8395 81.4374C22.3841 79.0348 22.4388 72.785 22.9152 72.785C25.7963 72.785 32.3046 71.1481 34.7141 69.8171C36.0572 69.0754 36.2467 69.082 37.9169 69.9264ZM117.518 69.9264C120.292 71.3291 126.183 72.785 129.085 72.785C129.561 72.785 129.616 79.0348 129.161 81.4374C128.248 86.2534 124.636 90.1499 119.961 91.362C117.787 91.9259 113.743 91.9366 111.631 91.3846C107.13 90.2085 103.805 86.7934 102.581 82.0908C102.002 79.8686 101.954 72.785 102.517 72.785C105.398 72.785 111.906 71.1481 114.316 69.8171C115.659 69.0754 115.848 69.082 117.518 69.9264ZM57.0518 94.6504C58.0647 95.7339 59.7348 97.2213 60.7637 97.9561L62.6341 99.2919V101.346C62.6341 102.476 62.5824 103.401 62.5188 103.401C62.4555 103.401 61.5176 102.986 60.4346 102.479C59.3517 101.972 56.2959 101.028 53.6441 100.381C50.9923 99.7348 48.3215 99.0743 47.7087 98.9138L46.5949 98.6222V96.85C46.5949 95.8757 46.7024 95.0782 46.834 95.0782C47.3737 95.0782 51.0722 91.7351 51.9579 90.4468L52.9108 89.0608L54.0605 90.8707C54.6929 91.8662 56.039 93.567 57.0518 94.6504ZM101.15 91.7999C101.668 92.3884 102.831 93.4002 103.734 94.0485L105.377 95.2268L105.391 96.9243L105.405 98.6222L104.291 98.9138C103.679 99.0743 101.008 99.7348 98.3559 100.381C95.7041 101.028 92.6483 101.972 91.5654 102.479C90.4825 102.986 89.5445 103.401 89.4812 103.401C89.4176 103.401 89.3659 102.476 89.3659 101.346V99.2919L91.2556 97.9424C93.5596 96.2969 96.6537 93.004 98.0122 90.7509L99.0191 89.0813L99.6132 89.9053C99.9399 90.3586 100.631 91.2111 101.15 91.7999ZM40.6545 99.203C40.6545 101.581 37.1491 114.99 36.3584 115.637C36.0257 115.909 35.7278 116.106 35.6963 116.074C35.6648 116.044 34.7625 112.602 33.6914 108.427C32.4618 103.635 31.7439 100.241 31.7439 99.2205V97.6047H36.1992H40.6545V99.203ZM120.256 99.2205C120.256 100.241 119.538 103.635 118.309 108.427C117.238 112.602 116.333 116.046 116.299 116.08C116.265 116.114 115.96 115.917 115.621 115.642C114.824 114.995 111.346 101.621 111.346 99.203V97.6047H115.801H120.256V99.2205ZM70.8021 102.355C71.8272 102.602 74.0355 102.785 76 102.785C77.9645 102.785 80.1729 102.602 81.1979 102.355C82.178 102.118 83.0801 101.922 83.2028 101.919C83.3254 101.917 83.4258 103.352 83.4261 105.11C83.4264 108.226 83.3364 108.656 79.7894 122.499C77.789 130.305 76.0847 136.691 76.0018 136.689C75.9192 136.688 74.2096 130.234 72.2026 122.347C68.6859 108.527 68.554 107.898 68.5641 104.961C68.5697 103.286 68.6749 101.917 68.7972 101.919C68.9196 101.922 69.822 102.118 70.8021 102.355ZM28.7148 112.987C29.8943 117.606 30.8582 121.507 30.8561 121.656C30.8543 121.806 30.2849 123.108 29.5905 124.549L28.3281 127.17L17.0793 127.175L5.83086 127.18L5.97017 122.647C6.09224 118.671 6.20451 117.867 6.88499 116.105C8.29614 112.45 10.6444 109.819 14.02 108.11C15.2945 107.464 24.0011 105.009 26.4094 104.616C26.4979 104.602 27.5351 108.368 28.7148 112.987ZM51.2867 105.925C55.3749 106.89 57.4062 107.47 56.9907 107.555C56.554 107.644 45.4475 110.529 44.8532 110.708C44.2591 110.887 44.1772 110.832 44.3209 110.355C44.4142 110.045 44.781 108.618 45.1357 107.183C45.6546 105.085 45.8749 104.602 46.262 104.714C46.5269 104.791 48.7878 105.336 51.2867 105.925ZM106.984 107.63C107.403 109.301 107.705 110.71 107.654 110.761C107.604 110.811 106.443 110.529 105.073 110.135C103.704 109.74 100.979 109.051 99.0191 108.603C97.0588 108.155 95.3474 107.69 95.2158 107.57C95.0845 107.45 95.5523 107.196 96.2554 107.006C97.6442 106.632 105.734 104.653 106.037 104.614C106.139 104.601 106.565 105.958 106.984 107.63ZM131.305 106.048C136.719 107.35 138.923 108.291 141.13 110.238C142.962 111.856 144.149 113.604 145.115 116.105C145.795 117.867 145.908 118.671 146.03 122.647L146.169 127.18L134.921 127.175L123.672 127.17L122.41 124.549C121.715 123.108 121.144 121.806 121.14 121.656C121.137 121.507 122.101 117.606 123.284 112.987C125.024 106.192 125.521 104.616 125.89 104.723C126.14 104.796 128.577 105.392 131.305 106.048ZM63.7915 113.433C63.9508 114.046 65.4329 119.831 67.0852 126.289C68.7372 132.746 70.1624 138.297 70.2515 138.624C70.3409 138.951 65.2582 134.072 58.9566 127.783C52.655 121.493 47.5994 116.247 47.7218 116.125C47.955 115.891 62.1137 112.385 62.9937 112.343C63.3404 112.326 63.5943 112.673 63.7915 113.433ZM96.5589 114.117C100.689 115.106 104.166 116.013 104.284 116.132C104.404 116.25 99.3607 121.49 93.0787 127.775L81.6565 139.203L84.1886 129.253C88.0371 114.131 88.5307 112.318 88.8001 112.318C88.9371 112.318 92.4285 113.128 96.5589 114.117ZM55.2085 132.679L68.7206 146.204H50.6778H32.6349V140.582C32.6349 132.804 33.3228 129.605 35.9452 125.188C36.8663 123.637 40.9762 119.155 41.4772 119.155C41.5978 119.155 47.7771 125.241 55.2085 132.679ZM112.9 121.332C115.205 123.658 116.608 125.767 117.779 128.67C118.998 131.689 119.365 134.447 119.365 140.582V146.204H101.322H83.2794L96.7915 132.679C104.223 125.241 110.402 119.155 110.523 119.155C110.643 119.155 111.713 120.134 112.9 121.332Z"
      />
    </svg>
  ),
  excellentSupport: (
    <svg
      xmlns="http://www.w3.org/2000/svg"
      width="100%"
      height="100%"
      viewBox="0 0 137 152"
      className="pointer-events-none">
      <path
        fillRule="evenodd"
        clipRule="evenodd"
        d="M61.1019 0.428366C48.3817 1.85645 35.8576 7.10333 25.9445 15.1576C12.1792 26.3418 3.00886 43.2464 1.25331 60.6731C1.03198 62.8697 0.947834 69.4618 1.00887 79.7787L1.1022 95.5307L2.23375 97.9084C2.85597 99.2161 3.74012 100.898 4.19849 101.645L5.03196 103.004L3.44797 104.566C1.71435 106.276 0.507836 108.448 0.115838 110.566C-0.20979 112.324 0.180134 115.541 0.922353 117.224C1.98635 119.637 5.19552 124.783 6.41655 126.034C9.47461 129.167 14.5765 130.074 19.028 128.276C19.3377 128.151 19.7875 128.592 20.5095 129.728C22.828 133.374 26.8218 135.693 31.3243 136.007C34.5121 136.23 36.7817 135.618 40.5094 133.532C44.5933 131.245 46.1598 130.033 47.6439 128.011C49.3446 125.694 50.1663 123.408 50.3574 120.462C50.5414 117.624 50.1361 115.602 48.8735 113.066C47.2578 109.82 31.4271 82.4836 30.2372 80.884C28.2484 78.2116 24.5255 76.022 21.1907 75.5634L19.8503 75.3792L20.0046 68.3657C20.1735 60.6865 20.5439 58.1632 22.2778 52.8869C26.9483 38.6715 38.3797 26.7906 51.9864 22.0097C55.4169 20.8043 56.1781 20.3825 56.5997 19.4541C57.3396 17.8254 56.8018 16.3052 55.219 15.552C53.9331 14.9398 53.1011 15.1199 48.3198 17.0458C41.3974 19.8339 35.8049 23.5835 30.1116 29.2536C25.3836 33.9622 22.4716 37.9992 19.6337 43.7796C17.2446 48.6448 16.0731 52.0422 14.9724 57.295C14.2796 60.6015 14.1641 61.9766 14.0138 68.7042L13.8429 76.3537L10.4355 78.2549L7.0281 80.1562L6.93951 72.0915C6.84707 63.666 7.0681 60.4603 8.0998 55.2592C9.87224 46.3233 14.3253 36.8906 20.3063 29.4022C36.5675 9.04261 63.5413 0.924999 87.9166 9.05539C110.34 16.5343 126.426 35.6807 129.982 59.1229C130.478 62.3945 131.012 80.2245 130.613 80.2245C130.498 80.2245 129.155 79.5014 127.629 78.6178C126.103 77.7339 124.577 76.9226 124.237 76.8144C123.655 76.6292 123.62 76.4051 123.616 72.8488C123.605 64.3376 122.805 57.6841 121.113 52.0401C117.324 39.3958 108.444 27.9524 97.0769 21.0652C92.2161 18.1202 84.9729 15.1362 82.6849 15.1362C81.7599 15.1362 81.303 15.3345 80.5975 16.0421C79.7969 16.8452 79.7134 17.0898 79.8612 18.1966C80.0796 19.8303 80.9291 20.538 83.668 21.3687C86.2917 22.1643 91.8508 24.7729 94.5474 26.4738C105.804 33.5735 113.86 45.2073 116.538 58.2297C117.21 61.5005 117.767 68.7895 117.636 72.6205L117.546 75.2701L115.731 75.6407C112.065 76.3891 108.837 78.4939 106.699 81.5296C105.69 82.9612 89.7145 110.553 88.4179 113.103C87.3039 115.293 86.7978 117.903 86.9842 120.496C87.3691 125.847 89.8144 129.333 95.6114 132.797C99.6108 135.187 101.284 135.824 104.076 136.019C109.189 136.377 114.186 133.954 116.819 129.837C117.67 128.507 117.883 128.343 118.556 128.497C118.978 128.595 120.09 128.83 121.028 129.021L122.731 129.369L122.725 132.363C122.714 138.136 121.977 140.631 119.537 143.152C118.84 143.873 117.507 144.821 116.574 145.259L114.879 146.056L97.2043 146.141L79.5291 146.226L79.4242 140.791C79.3235 135.576 79.2858 135.284 78.4924 133.573C77.4118 131.244 75.4005 129.219 73.1345 128.18C71.6053 127.479 70.933 127.35 68.8056 127.35C66.6782 127.35 66.0059 127.479 64.4767 128.18C62.2118 129.219 60.2009 131.242 59.1168 133.573C58.2892 135.352 58.2868 135.375 58.1905 142.682L58.0939 150.008L58.981 151.004L59.8682 152H87.6701H115.472L117.477 151.305C121.315 149.976 124.863 146.949 126.577 143.541C128.115 140.484 128.398 139.017 128.576 133.187L128.742 127.748L130.551 125.905C131.8 124.634 132.971 122.957 134.33 120.496C136.706 116.193 136.992 115.343 137 112.554C137.009 109.164 135.665 106.233 133.076 104.001L132.215 103.258L133.689 100.732C136.632 95.6867 136.511 96.6535 136.493 78.2927C136.478 63.295 136.434 61.9698 135.828 58.0642C134.591 50.1026 131.826 41.7945 128.285 35.4066C114.777 11.0312 88.503 -2.64772 61.1019 0.428366ZM67.4299 13.3367C65.7733 14.0434 65.3049 16.5566 66.5576 18.0174C67.5632 19.1898 69.6183 19.2112 70.7653 18.0611C71.8382 16.9846 71.8687 15.1018 70.8302 14.0598C70.0329 13.2603 68.4157 12.9161 67.4299 13.3367ZM22.7892 82.2557C23.4725 82.607 24.4725 83.3535 25.0114 83.9144C26.0597 85.0063 43.6122 115.356 44.174 117.048C45.0904 119.809 44.201 123.276 42.0238 125.431C40.8522 126.591 36.0244 129.401 34.4028 129.867C31.7216 130.639 28.5098 129.758 26.5243 127.706C25.1827 126.32 8.01062 96.779 7.24944 94.5481C6.24648 91.6076 7.35195 87.6158 9.69268 85.7258C10.9638 84.6999 14.2488 82.7856 16.2038 81.9317C17.8343 81.2196 21.0855 81.3795 22.7892 82.2557ZM120.934 81.8523C122.897 82.5472 127.616 85.456 128.52 86.5286C130.428 88.793 131.059 92.4178 129.991 94.9809C129.025 97.2991 111.875 126.752 110.946 127.688C109.225 129.42 107.771 129.996 105.102 130.002C102.781 130.007 102.669 129.972 99.7684 128.372C94.487 125.458 92.4864 122.644 92.8923 118.699C93.095 116.727 92.8535 117.187 102.793 99.8402C111.818 84.0882 112.67 82.8753 115.388 81.9106C117.037 81.3254 119.375 81.3007 120.934 81.8523ZM51.7112 93.1272C51.0208 93.7228 50.8798 94.0803 50.8798 95.2335C50.8798 97.0622 51.9153 98.057 53.8187 98.057C56.523 98.057 57.7642 95.0873 55.8587 93.1759C54.8163 92.1304 52.8928 92.1078 51.7112 93.1272ZM66.8207 92.9367C65.3229 94.1175 65.3567 96.5828 66.8841 97.5868C67.7807 98.1761 69.6625 98.1952 70.4767 97.623C72.7819 96.0033 71.5843 92.402 68.7449 92.4166C67.9967 92.4204 67.2038 92.635 66.8207 92.9367ZM81.4384 93.1935C80.8408 93.7929 80.6574 94.2723 80.6574 95.2335C80.6574 97.0512 81.7178 98.057 83.6343 98.057C84.8506 98.057 85.1569 97.9286 85.8162 97.1425C86.3071 96.5575 86.5833 95.8698 86.5833 95.2335C86.5833 94.5972 86.3071 93.9094 85.8162 93.3245C85.1569 92.5384 84.8506 92.41 83.6343 92.41C82.5009 92.41 82.0645 92.5658 81.4384 93.1935ZM12.4862 116.012C15.4361 121.163 16.2935 122.887 16.0038 123.084C15.7931 123.228 14.8559 123.298 13.9214 123.24C12.5715 123.155 11.9982 122.952 11.1309 122.248C9.92972 121.272 6.46366 115.552 5.973 113.735C5.58989 112.317 6.02129 110.605 7.07907 109.344C7.71314 108.588 7.92232 108.49 8.22039 108.81C8.42098 109.026 10.3407 112.267 12.4862 116.012ZM130.116 109.538C130.983 110.644 131.35 112.254 131.043 113.604C130.695 115.134 127.242 121.13 126.205 122.006C125.097 122.941 123.332 123.443 122.019 123.196L120.953 122.995L121.472 122.018C123.11 118.932 129.108 108.756 129.288 108.756C129.406 108.756 129.779 109.108 130.116 109.538ZM71.5662 134.106C73.3048 135.436 73.5463 136.346 73.5463 141.568V146.204H68.8056H64.0649V141.588C64.0649 135.795 64.3644 134.943 66.8803 133.579C68.1508 132.89 70.2912 133.131 71.5662 134.106Z"
      />
    </svg>
  ),
  facebook: (
    <svg
      xmlns="http://www.w3.org/2000/svg"
      width="100%"
      height="100%"
      className="pointer-events-none"
      viewBox="0 0 1.6 3.08">
      <g>
        <path d="m1.04.54s.1-.07.19-.07c.09,0,.19.01.29.04l.08-.44c-.17-.06-.34-.08-.52-.08s-.32.03-.43.09c-.11.06-.19.14-.23.24-.04.09-.06.25-.06.44v.17h-.35v.5h.35v1.58c.15.03.3.05.45.05.06,0,.12,0,.18-.01v-1.62h.46v-.5h-.46v-.16c0-.12.02-.2.06-.24Z" />
      </g>
    </svg>
  ),
  instagram: (
    <svg
      xmlns="http://www.w3.org/2000/svg"
      width="100%"
      height="100%"
      className="pointer-events-none"
      viewBox="0 0 2.27 2.26">
      <g>
        <path d="m1.97,0H.3c-.2,0-.3.1-.3.3v1.66c0,.19.11.3.29.3h1.68c.19,0,.3-.11.3-.3V.3c0-.19-.11-.3-.3-.3Zm-.18.25q.22,0,.22.22t-.22.22-.22-.22.22-.22Zm-.65.44c.24,0,.44.2.44.44,0,.24-.2.44-.44.44-.24,0-.44-.21-.43-.44,0-.24.2-.43.44-.43Zm.87,1.18c0,.11-.03.14-.13.14H.39c-.1,0-.13-.03-.13-.14,0-.27,0-.55,0-.82,0-.08.02-.1.09-.09.1,0,.11,0,.09.1-.04.35.2.69.55.76.36.07.71-.14.81-.49.03-.11.04-.22.02-.33,0-.04,0-.05.04-.05.16-.01.16-.01.16.15v.77Z" />
      </g>
    </svg>
  ),
  puzzle01: (
    <svg
      xmlns="http://www.w3.org/2000/svg"
      width="100%"
      height="100%"
      className="pointer-events-none"
      viewBox="0 0 145.59 145.59">
      <defs>
        <filter id="drop-shadow-1" filterUnits="userSpaceOnUse">
          <feOffset dx="3" dy="3" />
          <feGaussianBlur result="blur" stdDeviation="3" />
          <feFlood flood-color="#000" floodOpacity=".25" />
          <feComposite in2="blur" operator="in" />
          <feComposite in="SourceGraphic" />
        </filter>
        <linearGradient
          id="linear-gradient"
          x1=".5"
          y1="72.8"
          x2="145.09"
          y2="72.8"
          gradientUnits="userSpaceOnUse">
          <stop offset="0" stopColor="#fde07e" />
          <stop offset="1" stopColor="#fdc400" />
        </linearGradient>
      </defs>
      <g id="OBJECTS">
        <g style={{ filter: "url(#drop-shadow-1)" }}>
          <path
            d="m33.64,126.95c2.4-2.4,2.77-6.27,2.77-6.27.13-1.38,1.05-3.32,2.03-4.3l.51-.51c.98-.98,2.59-.98,3.58,0l28.49,28.49c.98.98,2.59.98,3.58,0l28.48-28.49c.98-.98,2.59-.98,3.58,0l.02.02c.98.98,1.9,2.92,2.03,4.31,0,0,.38,3.87,2.77,6.26,4.14,4.14,10.85,4.14,14.99,0,4.14-4.14,4.14-10.85,0-14.99-2.4-2.4-6.27-2.77-6.27-2.77-1.38-.13-3.32-1.05-4.31-2.03l-.02-.02c-.98-.98-.98-2.59,0-3.58l28.49-28.48c.98-.98.98-2.59,0-3.58l-28.48-28.48c-.98-.98-2.59-.98-3.58,0l-.32.32c-.98.98-1.9,2.92-2.03,4.3,0,0-.38,3.87-2.78,6.27-4.14,4.14-10.85,4.14-14.99,0-4.14-4.14-4.14-10.85,0-14.99,2.4-2.4,6.27-2.77,6.27-2.77,1.38-.13,3.32-1.05,4.31-2.03l.32-.32c.98-.98.98-2.59,0-3.58L74.59,1.24c-.98-.98-2.59-.98-3.58,0l-28.49,28.49c-.98.98-.98,2.59,0,3.58l.3.3c.98.98,2.92,1.9,4.31,2.03,0,0,3.87.38,6.27,2.77,4.14,4.14,4.14,10.85,0,14.99-4.14,4.14-10.85,4.14-14.99,0-2.4-2.4-2.77-6.26-2.77-6.26-.14-1.39-1.05-3.32-2.03-4.31l-.3-.3c-.98-.98-2.59-.98-3.58,0L1.24,71.01c-.98.98-.98,2.59,0,3.58l28.48,28.48c.98.98.98,2.59,0,3.58l-.51.51c-.98.98-2.92,1.9-4.31,2.03,0,0-3.87.37-6.27,2.77-4.14,4.14-4.14,10.85,0,14.99,4.14,4.14,10.85,4.14,14.99,0Z"
            style={{ fill: " url(#linear-gradient)", strokeWidth: "0px" }}
          />
          <path
            d="m92.09,70.07s0-.03,0-.05l-.05-.05c-6.44-8.01-18.15-9.29-26.17-2.85-.33.27-.65.55-.97.84h-13.9c-.89,0-1.62.72-1.62,1.62v13.18c0,.89.72,1.62,1.62,1.62h8.05c1.47,10.2,10.93,17.28,21.13,15.81,4.66-.67,8.89-3.08,11.85-6.74l.05-.04v-.05c5.45-6.8,5.45-16.48,0-23.28h0Zm-15.38-5.33v8.88c-1.77-.04-3.53-.25-5.25-.63v-3.46c0-.29-.09-.57-.24-.81,1.57-2.29,3.48-3.69,5.5-3.98h0Zm0,16.17h-5.25v-6.25c1.73.36,3.49.56,5.25.6v5.65Zm-5.12-15.19c-.68.68-1.29,1.43-1.81,2.24h-2.31c1.27-.94,2.65-1.69,4.13-2.24h0Zm-20.54,17.04v-13.19h14.05c.09.02.18.02.27,0h4.49v13.18h-3.88c-.4,0-.74.28-.81.67l-.52,3.04-1.67-3.24c-.14-.27-.42-.44-.72-.44l-11.21-.03Zm12.72,9.08c-1.62-2.21-2.68-4.79-3.09-7.5h1.1l2.56,4.99c.14.27.42.44.72.44h.12c.34-.05.62-.32.67-.66l.53-3.12c.19,1.37.48,2.72.88,4.05-1.22.48-2.39,1.09-3.49,1.81h0Zm1.02,1.26c.95-.61,1.95-1.13,2.99-1.55.82,2.3,2.12,4.41,3.82,6.16-2.61-.96-4.95-2.55-6.81-4.62h0Zm11.92,5.61c-3.04-.45-5.75-3.42-7.39-7.7,2.39-.74,4.88-1.15,7.39-1.2v8.9Zm0-10.52c-2.7.05-5.37.49-7.94,1.28-.49-1.67-.81-3.39-.96-5.14h2.05c.89,0,1.62-.73,1.62-1.62v-.19h5.25l-.02,5.66Zm14.53-16.58c2,2.7,3.15,5.94,3.3,9.3h-5.6c-.05-2.54-.45-5.06-1.18-7.49,1.22-.48,2.38-1.09,3.48-1.8h0Zm-1.03-1.22c-.94.6-1.94,1.12-2.98,1.53-.82-2.29-2.12-4.39-3.81-6.15,2.6.97,4.93,2.55,6.78,4.62h0Zm-11.89-5.66c3.1.44,5.8,3.39,7.41,7.69-2.4.75-4.9,1.15-7.41,1.21v-8.9Zm0,10.52c2.69-.05,5.36-.49,7.92-1.3.65,2.27,1.01,4.6,1.06,6.96h-8.98v-5.66Zm0,7.28h8.98c-.05,2.35-.41,4.69-1.06,6.96-2.56-.8-5.23-1.24-7.92-1.3v-5.66Zm0,16.18v-8.9c2.52.05,5.03.46,7.44,1.21-1.62,4.3-4.34,7.25-7.44,7.7h0Zm5.11-1c1.69-1.76,2.98-3.85,3.81-6.15,1.04.4,2.03.9,2.98,1.49-1.85,2.08-4.17,3.68-6.78,4.66h0Zm7.8-5.89c-1.09-.72-2.26-1.32-3.48-1.8.73-2.44,1.13-4.95,1.18-7.49h5.6c-.16,3.36-1.31,6.59-3.31,9.29h0Z"
            style={{ fill: "#fff", strokeWidth: "0px" }}
          />
          <path
            d="m33.64,126.95c2.4-2.4,2.77-6.27,2.77-6.27.13-1.38,1.05-3.32,2.03-4.3l.51-.51c.98-.98,2.59-.98,3.58,0l28.49,28.49c.98.98,2.59.98,3.58,0l28.48-28.49c.98-.98,2.59-.98,3.58,0l.02.02c.98.98,1.9,2.92,2.03,4.31,0,0,.38,3.87,2.77,6.26,4.14,4.14,10.85,4.14,14.99,0,4.14-4.14,4.14-10.85,0-14.99-2.4-2.4-6.27-2.77-6.27-2.77-1.38-.13-3.32-1.05-4.31-2.03l-.02-.02c-.98-.98-.98-2.59,0-3.58l28.49-28.48c.98-.98.98-2.59,0-3.58l-28.48-28.48c-.98-.98-2.59-.98-3.58,0l-.32.32c-.98.98-1.9,2.92-2.03,4.3,0,0-.38,3.87-2.78,6.27-4.14,4.14-10.85,4.14-14.99,0-4.14-4.14-4.14-10.85,0-14.99,2.4-2.4,6.27-2.77,6.27-2.77,1.38-.13,3.32-1.05,4.31-2.03l.32-.32c.98-.98.98-2.59,0-3.58L74.59,1.24c-.98-.98-2.59-.98-3.58,0l-28.49,28.49c-.98.98-.98,2.59,0,3.58l.3.3c.98.98,2.92,1.9,4.31,2.03,0,0,3.87.38,6.27,2.77,4.14,4.14,4.14,10.85,0,14.99-4.14,4.14-10.85,4.14-14.99,0-2.4-2.4-2.77-6.26-2.77-6.26-.14-1.39-1.05-3.32-2.03-4.31l-.3-.3c-.98-.98-2.59-.98-3.58,0L1.24,71.01c-.98.98-.98,2.59,0,3.58l28.48,28.48c.98.98.98,2.59,0,3.58l-.51.51c-.98.98-2.92,1.9-4.31,2.03,0,0-3.87.37-6.27,2.77-4.14,4.14-4.14,10.85,0,14.99,4.14,4.14,10.85,4.14,14.99,0Z"
            style={{ fill: "none", stroke: "#fff", strokeLinejoin: "round" }}
          />
        </g>
      </g>
    </svg>
  ),
  puzzle02: (
    <svg
      xmlns="http://www.w3.org/2000/svg"
      width="100%"
      height="100%"
      className="pointer-events-none"
      viewBox="0 0 145.59 145.59">
      <defs>
        <filter id="drop-shadow-1" filterUnits="userSpaceOnUse">
          <feOffset dx="3" dy="3" />
          <feGaussianBlur result="blur" stdDeviation="3" />
          <feFlood flood-color="#000" floodOpacity=".25" />
          <feComposite in2="blur" operator="in" />
          <feComposite in="SourceGraphic" />
        </filter>
        <linearGradient
          id="linear-gradient"
          x1=".5"
          y1="72.8"
          x2="145.09"
          y2="72.8"
          gradientUnits="userSpaceOnUse">
          <stop offset="0" stopColor="#bfe472" />
          <stop offset="1" stopColor="#8bca00" />
        </linearGradient>
      </defs>
      <g id="OBJECTS">
        <g style={{ filter: "url(#drop-shadow-1)" }}>
          <path
            d="m126.95,33.63c-2.4,2.4-6.26,2.77-6.26,2.77-1.38.13-3.32,1.05-4.31,2.03l-.51.51c-.98.98-.98,2.59,0,3.57l28.49,28.49c.98.98.98,2.59,0,3.58l-28.48,28.48c-.98.98-.98,2.59,0,3.58l.02.02c.98.98,2.92,1.9,4.3,2.03,0,0,3.87.38,6.27,2.77,4.14,4.14,4.14,10.85,0,15-4.14,4.14-10.85,4.14-14.99,0-2.4-2.4-2.77-6.27-2.77-6.27-.13-1.38-1.05-3.32-2.03-4.3l-.02-.02c-.98-.98-2.59-.98-3.58,0l-28.49,28.49c-.98.98-2.59.98-3.58,0l-28.48-28.48c-.98-.98-.98-2.59,0-3.58l.32-.32c.98-.98,2.92-1.9,4.3-2.03,0,0,3.87-.38,6.27-2.77,4.14-4.14,4.14-10.85,0-14.99-4.14-4.14-10.85-4.14-14.99,0-2.4,2.4-2.77,6.27-2.77,6.27-.13,1.38-1.05,3.32-2.03,4.3l-.32.32c-.98.98-2.59.98-3.58,0L1.24,74.58c-.98-.98-.98-2.59,0-3.58l28.49-28.49c.98-.98,2.59-.98,3.58,0l.3.3c.98.98,1.9,2.92,2.03,4.31,0,0,.38,3.87,2.78,6.27,4.14,4.14,10.85,4.14,14.99,0,4.14-4.14,4.14-10.85,0-14.99-2.4-2.4-6.26-2.77-6.26-2.77-1.39-.14-3.32-1.05-4.31-2.03l-.3-.3c-.98-.98-.98-2.59,0-3.58L71.01,1.24c.98-.98,2.59-.98,3.58,0l28.49,28.49c.98.98,2.59.98,3.58,0l.51-.51c.98-.98,1.9-2.92,2.03-4.3,0,0,.38-3.87,2.77-6.27,4.14-4.14,10.85-4.14,14.99,0,4.14,4.14,4.14,10.85,0,14.99Z"
            style={{ fill: " url(#linear-gradient)", strokeWidth: "0px" }}
          />
          <path
            d="m102.61,62.93l6.99-6.99c.32-.32.32-.83,0-1.15-.14-.14-.34-.23-.55-.24l.03.05-3.8-.13-.13-3.8c-.02-.45-.39-.8-.84-.78-.21,0-.4.09-.55.24l-6.98,6.95c-.16.16-.24.38-.24.6v.81c-8.3-5.72-19.67-3.62-25.39,4.68-5.72,8.3-3.62,19.67,4.67,25.39,8.3,5.72,19.67,3.63,25.39-4.68,4.29-6.24,4.29-14.48,0-20.71h.81c.21,0,.42-.08.58-.23h0Zm.24,10.6c.01,9.2-7.43,16.66-16.63,16.67-9.2.01-16.66-7.43-16.67-16.63-.01-9.2,7.43-16.66,16.63-16.67,3.81,0,7.5,1.3,10.47,3.69l.04,1.35-3.23,3.23c-4.6-4.04-11.61-3.58-15.64,1.03-4.03,4.6-3.58,11.61,1.03,15.64,4.6,4.04,11.61,3.57,15.65-1.03,3.62-4.14,3.67-10.3.1-14.5l3.24-3.23,1.34.05c2.38,2.95,3.69,6.61,3.7,10.4h0Zm-17.17.54c.32.31.82.31,1.14,0l1.62-1.62c.16.32.24.68.24,1.05,0,1.34-1.09,2.43-2.43,2.43s-2.42-1.09-2.42-2.43,1.09-2.43,2.42-2.43c.36,0,.72.08,1.05.24l-1.62,1.62c-.32.31-.32.83,0,1.14h0Zm2.8-3.95c-1.86-1.23-4.37-.72-5.61,1.14-1.23,1.86-.72,4.37,1.14,5.61,1.86,1.23,4.37.72,5.61-1.14.9-1.36.9-3.11,0-4.46l3.84-3.84c3.36,3.99,2.85,9.95-1.14,13.32-3.99,3.36-9.95,2.85-13.31-1.14-3.36-3.99-2.85-9.96,1.14-13.32,3.52-2.97,8.66-2.97,12.18,0l-3.84,3.83Zm9.84-8.69l-.11-3.44,5.42-5.42.09,2.69c0,.45.36.81.81.81l2.7.09-5.45,5.39-3.45-.12Z"
            style={{ fill: "#fff", strokeWidth: "0px" }}
          />
          <path
            d="m126.95,33.63c-2.4,2.4-6.26,2.77-6.26,2.77-1.38.13-3.32,1.05-4.31,2.03l-.51.51c-.98.98-.98,2.59,0,3.57l28.49,28.49c.98.98.98,2.59,0,3.58l-28.48,28.48c-.98.98-.98,2.59,0,3.58l.02.02c.98.98,2.92,1.9,4.3,2.03,0,0,3.87.38,6.27,2.77,4.14,4.14,4.14,10.85,0,15-4.14,4.14-10.85,4.14-14.99,0-2.4-2.4-2.77-6.27-2.77-6.27-.13-1.38-1.05-3.32-2.03-4.3l-.02-.02c-.98-.98-2.59-.98-3.58,0l-28.49,28.49c-.98.98-2.59.98-3.58,0l-28.48-28.48c-.98-.98-.98-2.59,0-3.58l.32-.32c.98-.98,2.92-1.9,4.3-2.03,0,0,3.87-.38,6.27-2.77,4.14-4.14,4.14-10.85,0-14.99-4.14-4.14-10.85-4.14-14.99,0-2.4,2.4-2.77,6.27-2.77,6.27-.13,1.38-1.05,3.32-2.03,4.3l-.32.32c-.98.98-2.59.98-3.58,0L1.24,74.58c-.98-.98-.98-2.59,0-3.58l28.49-28.49c.98-.98,2.59-.98,3.58,0l.3.3c.98.98,1.9,2.92,2.03,4.31,0,0,.38,3.87,2.78,6.27,4.14,4.14,10.85,4.14,14.99,0,4.14-4.14,4.14-10.85,0-14.99-2.4-2.4-6.26-2.77-6.26-2.77-1.39-.14-3.32-1.05-4.31-2.03l-.3-.3c-.98-.98-.98-2.59,0-3.58L71.01,1.24c.98-.98,2.59-.98,3.58,0l28.49,28.49c.98.98,2.59.98,3.58,0l.51-.51c.98-.98,1.9-2.92,2.03-4.3,0,0,.38-3.87,2.77-6.27,4.14-4.14,10.85-4.14,14.99,0,4.14,4.14,4.14,10.85,0,14.99Z"
            style={{ fill: "none", stroke: "#fff", strokeLinejoin: "round" }}
          />
        </g>
      </g>
    </svg>
  ),
  puzzle03: (
    <svg
      xmlns="http://www.w3.org/2000/svg"
      width="100%"
      height="100%"
      className="pointer-events-none"
      viewBox="0 0 145.59 145.59">
      <defs>
        <filter id="drop-shadow-1" filterUnits="userSpaceOnUse">
          <feOffset dx="3" dy="3" />
          <feGaussianBlur result="blur" stdDeviation="3" />
          <feFlood flood-color="#000" floodOpacity=".25" />
          <feComposite in2="blur" operator="in" />
          <feComposite in="SourceGraphic" />
        </filter>
        <linearGradient
          id="linear-gradient"
          x1=".5"
          y1="72.8"
          x2="145.09"
          y2="72.8"
          gradientUnits="userSpaceOnUse">
          <stop offset="0" stopColor="#bfe472" />
          <stop offset="1" stopColor="#8bca00" />
        </linearGradient>
      </defs>
      <g xmlns="http://www.w3.org/2000/svg" id="OBJECTS">
        <g style={{ filter: "url(#drop-shadow-1)" }}>
          <path
            d="m111.96,18.64c-2.4,2.4-2.77,6.27-2.77,6.27-.13,1.38-1.05,3.32-2.03,4.3l-.51.51c-.98.98-2.59.98-3.58,0L74.59,1.24c-.98-.98-2.59-.98-3.58,0l-28.48,28.49c-.98.98-2.59.98-3.58,0l-.02-.02c-.98-.98-1.9-2.92-2.03-4.31,0,0-.38-3.87-2.77-6.26-4.14-4.14-10.85-4.14-14.99,0-4.14,4.14-4.14,10.85,0,14.99,2.4,2.4,6.27,2.77,6.27,2.77,1.38.13,3.32,1.05,4.31,2.03l.02.02c.98.98.98,2.59,0,3.58L1.24,71.01c-.98.98-.98,2.59,0,3.58l28.49,28.48c.98.98,2.59.98,3.58,0l.31-.32c.98-.98,1.9-2.92,2.03-4.3,0,0,.38-3.87,2.77-6.27,4.14-4.14,10.85-4.14,14.99,0,4.14,4.14,4.14,10.85,0,14.99-2.4,2.4-6.26,2.77-6.26,2.77-1.38.13-3.32,1.05-4.31,2.03l-.31.32c-.98.98-.98,2.59,0,3.57l28.48,28.49c.98.98,2.59.98,3.58,0l28.48-28.49c.98-.98.98-2.59,0-3.58l-.3-.3c-.99-.98-2.92-1.9-4.31-2.03,0,0-3.87-.38-6.27-2.77-4.14-4.14-4.14-10.85,0-14.99,4.14-4.14,10.85-4.14,14.99,0,2.4,2.4,2.77,6.26,2.77,6.26.13,1.38,1.05,3.32,2.03,4.3l.3.3c.98.98,2.59.98,3.57,0l28.49-28.48c.98-.98.98-2.59,0-3.58l-28.49-28.48c-.98-.98-.98-2.59,0-3.58l.51-.51c.98-.98,2.92-1.9,4.3-2.03,0,0,3.87-.38,6.27-2.77,4.14-4.14,4.14-10.85,0-14.99-4.14-4.14-10.85-4.14-14.99,0Z"
            style={{ fill: " url(#linear-gradient)", strokeWidth: "0px" }}
          />
          <g>
            <path
              d="m91.35,44.56s-.07,0-.1,0h0s-17.2,2.08-17.2,2.08l-17.2-2.09c-.44-.06-.85.26-.9.71,0,.03,0,.07,0,.1v11.8c-2.48,2.73-2.59,6.86-.26,9.71l-6.14,6.12c-.34.29-.38.8-.09,1.14.29.34.8.38,1.14.09.03-.02.06-.06.09-.09l5.25-5.25v3.99c0,.41.31.76.72.81l17.32,2.1h.2l17.28-2.1c.41-.05.71-.4.71-.81v-27.51c0-.45-.36-.81-.81-.81Zm-34.08,13.54s.03-.03.05-.05c2.27-2.27,5.95-2.27,8.22,0,2.27,2.27,2.26,5.95,0,8.22-2.27,2.27-5.94,2.27-8.21,0-2.27-2.24-2.29-5.9-.05-8.17Zm15.97,15.97l-15.68-1.9v-3.68c3.5,2.14,8.07,1.04,10.21-2.46,2.15-3.5,1.04-8.07-2.46-10.21-2.38-1.46-5.37-1.46-7.75,0v-9.55l15.68,1.9v25.9Zm17.3-1.9l-15.68,1.9v-25.89l15.68-1.9v25.89Z"
              style={{ fill: "#fff", strokeWidth: "0px" }}
            />
            <path
              d="m59.31,52.72h.02l11.33,1.37h.07c.45.03.83-.31.86-.76.02-.45-.31-.83-.76-.86l-11.33-1.38c-.45-.05-.85.27-.9.71-.05.45.26.85.71.91Z"
              style={{ fill: "#fff", strokeWidth: "0px" }}
            />
            <path
              d="m77.05,54.09h.09l11.33-1.37c.45-.05.77-.46.71-.91-.05-.45-.46-.77-.91-.71l-11.33,1.38c-.45.03-.79.41-.76.86.03.45.41.78.86.76Z"
              style={{ fill: "#fff", strokeWidth: "0px" }}
            />
            <path
              d="m77.05,60.91h.09l11.33-1.37c.45-.05.77-.46.71-.91-.05-.45-.46-.76-.91-.71l-11.33,1.38c-.45.02-.79.41-.76.85.03.45.41.79.86.76Z"
              style={{ fill: "#fff", strokeWidth: "0px" }}
            />
            <path
              d="m77.05,67.72h.09l11.33-1.37c.45-.05.77-.46.71-.91-.05-.45-.46-.77-.91-.71l-11.33,1.38c-.45.03-.79.41-.76.86.03.45.41.79.86.76Z"
              style={{ fill: "#fff", strokeWidth: "0px" }}
            />
          </g>
          <path
            d="m111.96,18.64c-2.4,2.4-2.77,6.27-2.77,6.27-.13,1.38-1.05,3.32-2.03,4.3l-.51.51c-.98.98-2.59.98-3.58,0L74.59,1.24c-.98-.98-2.59-.98-3.58,0l-28.48,28.49c-.98.98-2.59.98-3.58,0l-.02-.02c-.98-.98-1.9-2.92-2.03-4.31,0,0-.38-3.87-2.77-6.26-4.14-4.14-10.85-4.14-14.99,0-4.14,4.14-4.14,10.85,0,14.99,2.4,2.4,6.27,2.77,6.27,2.77,1.38.13,3.32,1.05,4.31,2.03l.02.02c.98.98.98,2.59,0,3.58L1.24,71.01c-.98.98-.98,2.59,0,3.58l28.49,28.48c.98.98,2.59.98,3.58,0l.31-.32c.98-.98,1.9-2.92,2.03-4.3,0,0,.38-3.87,2.77-6.27,4.14-4.14,10.85-4.14,14.99,0,4.14,4.14,4.14,10.85,0,14.99-2.4,2.4-6.26,2.77-6.26,2.77-1.38.13-3.32,1.05-4.31,2.03l-.31.32c-.98.98-.98,2.59,0,3.57l28.48,28.49c.98.98,2.59.98,3.58,0l28.48-28.49c.98-.98.98-2.59,0-3.58l-.3-.3c-.99-.98-2.92-1.9-4.31-2.03,0,0-3.87-.38-6.27-2.77-4.14-4.14-4.14-10.85,0-14.99,4.14-4.14,10.85-4.14,14.99,0,2.4,2.4,2.77,6.26,2.77,6.26.13,1.38,1.05,3.32,2.03,4.3l.3.3c.98.98,2.59.98,3.57,0l28.49-28.48c.98-.98.98-2.59,0-3.58l-28.49-28.48c-.98-.98-.98-2.59,0-3.58l.51-.51c.98-.98,2.92-1.9,4.3-2.03,0,0,3.87-.38,6.27-2.77,4.14-4.14,4.14-10.85,0-14.99-4.14-4.14-10.85-4.14-14.99,0Z"
            style={{ fill: "none", stroke: "#fff", strokeLinejoin: "round" }}
          />
        </g>
      </g>
    </svg>
  ),
  puzzle04: (
    <svg
      xmlns="http://www.w3.org/2000/svg"
      width="100%"
      height="100%"
      className="pointer-events-none"
      viewBox="0 0 145.59 145.59">
      <defs>
        <filter id="drop-shadow-1" filterUnits="userSpaceOnUse">
          <feOffset dx="3" dy="3" />
          <feGaussianBlur result="blur" stdDeviation="3" />
          <feFlood flood-color="#000" floodOpacity=".25" />
          <feComposite in2="blur" operator="in" />
          <feComposite in="SourceGraphic" />
        </filter>
        <linearGradient
          id="linear-gradient"
          x1=".5"
          y1="72.8"
          x2="145.09"
          y2="72.8"
          gradientUnits="userSpaceOnUse">
          <stop offset="0" stopColor="#bfe472" />
          <stop offset="1" stopColor="#8bca00" />
        </linearGradient>
      </defs>
      <g xmlns="http://www.w3.org/2000/svg" id="OBJECTS">
        <g style={{ filter: "url(#drop-shadow-1)" }}>
          <path
            d="m33.63,18.64c2.4,2.4,2.78,6.27,2.78,6.27.13,1.38,1.05,3.32,2.03,4.3l.51.51c.98.98,2.59.98,3.58,0L71.01,1.24c.98-.98,2.59-.98,3.58,0l28.48,28.48c.98.98,2.59.98,3.57,0l.02-.02c.99-.99,1.9-2.92,2.03-4.31,0,0,.38-3.87,2.77-6.27,4.14-4.14,10.85-4.14,14.99,0,4.14,4.14,4.14,10.85,0,14.99-2.4,2.4-6.27,2.77-6.27,2.77-1.38.13-3.32,1.05-4.3,2.03l-.02.02c-.98.98-.98,2.59,0,3.57l28.49,28.49c.98.98.98,2.59,0,3.58l-28.48,28.49c-.99.98-2.59.98-3.58,0l-.32-.32c-.98-.98-1.9-2.92-2.03-4.31,0,0-.38-3.87-2.77-6.27-4.14-4.14-10.85-4.14-14.99,0-4.14,4.14-4.14,10.85,0,14.99,2.4,2.4,6.27,2.77,6.27,2.77,1.39.13,3.32,1.05,4.31,2.03l.32.32c.98.98.98,2.59,0,3.58l-28.49,28.48c-.98.98-2.59.98-3.58,0l-28.48-28.48c-.98-.98-.98-2.59,0-3.58l.3-.3c.99-.99,2.92-1.9,4.31-2.03,0,0,3.87-.38,6.27-2.77,4.14-4.14,4.14-10.85,0-14.99-4.14-4.14-10.85-4.14-14.99,0-2.4,2.4-2.77,6.26-2.77,6.26-.14,1.39-1.05,3.32-2.03,4.31l-.3.3c-.98.98-2.59.98-3.58,0L1.24,74.58c-.98-.98-.98-2.59,0-3.57l28.49-28.49c.98-.98.98-2.59,0-3.57l-.51-.51c-.98-.98-2.92-1.9-4.31-2.03,0,0-3.87-.38-6.27-2.77-4.14-4.14-4.14-10.85,0-14.99,4.14-4.14,10.85-4.14,14.99,0Z"
            style={{ fill: " url(#linear-gradient)", strokeWidth: "0px" }}
          />
          <g>
            <path
              d="m82.4,50.82h-27.29v-5.57s.04-.08.08-.08h8.29v2.99c0,.4.33.73.73.73s.73-.33.73-.73v-2.99h9.06c.4,0,.73-.33.73-.73s-.33-.73-.73-.73h-18.81c-.85,0-1.53.69-1.53,1.54v29.13c0,.85.69,1.54,1.53,1.54h6.2c.4,0,.73-.33.73-.73s-.33-.73-.73-.73h-6.2s-.08-.04-.08-.08v-12.03h18.67c.41,0,.73-.32.73-.73s-.33-.73-.73-.73h-8.24v-5.17c0-.4-.33-.72-.73-.72h-5.1c-.4,0-.73.32-.73.72s.33.73.73.73h4.37v4.45h-8.97v-8.63h16.93v4.71c0,.4.33.73.73.73s.73-.33.73-.73v-4.71h8.17v14.29c0,.4.33.73.73.73s.73-.33.73-.73v-15.01c0-.4-.33-.73-.73-.73h0Z"
              style={{ fill: "#fff", strokeWidth: "0px" }}
            />
            <path
              d="m88.45,43.72h-8.16c-.4,0-.73.33-.73.73s.33.73.73.73h8.16s.08.04.08.08v29.13s-.03.08-.08.08h-20.34v-7.17h1.89c.4,0,.73-.33.73-.73s-.33-.73-.73-.73h-8.92c-.4,0-.73.33-.73.73s.33.73.73.73h5.57v7.9c0,.4.33.73.73.73h21.07c.85,0,1.53-.69,1.53-1.54v-29.13c0-.85-.69-1.54-1.53-1.54h0Z"
              style={{ fill: "#fff", strokeWidth: "0px" }}
            />
            <path
              d="m78.09,56.9c-.4,0-.73.33-.73.73h-.03v11.79h-6.25c-.4,0-.73.33-.73.73s.33.73.73.73h7c.4,0,.73-.33.73-.73v-12.52c0-.4-.33-.73-.73-.73h0Z"
              style={{ fill: "#fff", strokeWidth: "0px" }}
            />
          </g>
          <path
            d="m33.63,18.64c2.4,2.4,2.78,6.27,2.78,6.27.13,1.38,1.05,3.32,2.03,4.3l.51.51c.98.98,2.59.98,3.58,0L71.01,1.24c.98-.98,2.59-.98,3.58,0l28.48,28.48c.98.98,2.59.98,3.57,0l.02-.02c.99-.99,1.9-2.92,2.03-4.31,0,0,.38-3.87,2.77-6.27,4.14-4.14,10.85-4.14,14.99,0,4.14,4.14,4.14,10.85,0,14.99-2.4,2.4-6.27,2.77-6.27,2.77-1.38.13-3.32,1.05-4.3,2.03l-.02.02c-.98.98-.98,2.59,0,3.57l28.49,28.49c.98.98.98,2.59,0,3.58l-28.48,28.49c-.99.98-2.59.98-3.58,0l-.32-.32c-.98-.98-1.9-2.92-2.03-4.31,0,0-.38-3.87-2.77-6.27-4.14-4.14-10.85-4.14-14.99,0-4.14,4.14-4.14,10.85,0,14.99,2.4,2.4,6.27,2.77,6.27,2.77,1.39.13,3.32,1.05,4.31,2.03l.32.32c.98.98.98,2.59,0,3.58l-28.49,28.48c-.98.98-2.59.98-3.58,0l-28.48-28.48c-.98-.98-.98-2.59,0-3.58l.3-.3c.99-.99,2.92-1.9,4.31-2.03,0,0,3.87-.38,6.27-2.77,4.14-4.14,4.14-10.85,0-14.99-4.14-4.14-10.85-4.14-14.99,0-2.4,2.4-2.77,6.26-2.77,6.26-.14,1.39-1.05,3.32-2.03,4.31l-.3.3c-.98.98-2.59.98-3.58,0L1.24,74.58c-.98-.98-.98-2.59,0-3.57l28.49-28.49c.98-.98.98-2.59,0-3.57l-.51-.51c-.98-.98-2.92-1.9-4.31-2.03,0,0-3.87-.38-6.27-2.77-4.14-4.14-4.14-10.85,0-14.99,4.14-4.14,10.85-4.14,14.99,0Z"
            style={{ fill: "none", stroke: "#fff", strokeLinejoin: "round" }}
          />
        </g>
      </g>
    </svg>
  ),
  puzzle05: (
    <svg
      xmlns="http://www.w3.org/2000/svg"
      width="100%"
      height="100%"
      className="pointer-events-none"
      viewBox="0 0 145.59 145.59">
      <defs>
        <filter id="drop-shadow-1" filterUnits="userSpaceOnUse">
          <feOffset dx="3" dy="3" />
          <feGaussianBlur result="blur" stdDeviation="3" />
          <feFlood flood-color="#000" floodOpacity=".25" />
          <feComposite in2="blur" operator="in" />
          <feComposite in="SourceGraphic" />
        </filter>
        <linearGradient
          id="linear-gradient"
          x1=".5"
          y1="72.8"
          x2="145.09"
          y2="72.8"
          gradientUnits="userSpaceOnUse">
          <stop offset="0" stopColor="#bfe472" />
          <stop offset="1" stopColor="#8bca00" />
        </linearGradient>
      </defs>
      <g xmlns="http://www.w3.org/2000/svg" id="OBJECTS">
        <g style={{ filter: "url(#drop-shadow-1)" }}>
          <path
            d="m111.96,18.64c-2.4,2.4-2.77,6.27-2.77,6.27-.13,1.38-1.05,3.32-2.03,4.3l-.51.51c-.98.98-2.59.98-3.58,0L74.59,1.24c-.98-.98-2.59-.98-3.58,0l-28.48,28.48c-.99.98-2.59.98-3.58,0l-.02-.02c-.98-.98-1.9-2.92-2.03-4.31,0,0-.38-3.87-2.77-6.26-4.14-4.14-10.85-4.14-14.99,0-4.14,4.14-4.14,10.85,0,14.99,2.4,2.4,6.27,2.77,6.27,2.77,1.38.13,3.32,1.05,4.31,2.03l.02.02c.98.98.98,2.59,0,3.58L1.24,71.01c-.98.98-.98,2.59,0,3.58l28.48,28.48c.98.98,2.59.98,3.58,0l.32-.31c.98-.98,1.9-2.92,2.03-4.3,0,0,.38-3.87,2.77-6.27,4.14-4.14,10.85-4.14,14.99,0,4.14,4.14,4.14,10.85,0,14.99-2.4,2.4-6.26,2.77-6.26,2.77-1.38.13-3.32,1.05-4.31,2.03l-.32.32c-.98.98-.99,2.59,0,3.57l28.49,28.48c.98.98,2.59.98,3.58,0l28.49-28.49c.98-.98.98-2.59,0-3.57l-.3-.3c-.98-.99-2.92-1.9-4.31-2.03,0,0-3.87-.38-6.27-2.77-4.14-4.14-4.14-10.85,0-14.99,4.14-4.14,10.85-4.14,14.99,0,2.4,2.4,2.77,6.27,2.77,6.27.14,1.38,1.05,3.32,2.03,4.3l.3.3c.98.98,2.59.98,3.57,0l28.49-28.48c.98-.98.98-2.59,0-3.58l-28.49-28.48c-.98-.98-.98-2.59,0-3.58l.51-.51c.98-.98,2.92-1.9,4.3-2.03,0,0,3.87-.37,6.27-2.77,4.14-4.14,4.14-10.85,0-14.99-4.14-4.14-10.85-4.14-14.99,0Z"
            style={{ fill: " url(#linear-gradient)", strokeWidth: "0px" }}
          />
          <path
            d="m86.68,46.15h-7.1v-4.14c0-.94-.76-1.7-1.7-1.7h-10.87c-.94,0-1.7.76-1.7,1.7v4.14h-7.09c-2.55,0-5.52,1.39-5.52,5.32v18.25c0,3.92,2.98,5.31,5.52,5.31h28.46c4.08,0,5.52-2.86,5.52-5.31v-18.24c0-3.94-2.97-5.33-5.52-5.33h0Zm-19.66-4.13h10.86s0,4.13,0,4.13h-10.86v-4.13Zm19.66,31.31h-28.46c-1.15,0-3.83-.36-3.83-3.62v-6h12.74c0,.06,0,.12,0,.19v2.63c0,1.04.85,1.88,1.89,1.88h2.58v1.7c0,.47.38.85.85.85s.85-.38.85-.85v-1.7h2.55c1.04,0,1.88-.84,1.88-1.88v-2.63c0-.06,0-.13,0-.19h12.74l.03,6c0,1.09-.37,3.62-3.82,3.62h0Zm-14.23-8.96c-.47,0-.85.38-.85.85v1.49h-2.55c-.1,0-.19-.08-.19-.19v-2.63c0-.1.08-.19.19-.19h6.8c.1,0,.18.08.18.19v2.63c0,.1-.08.19-.18.19h-2.55v-1.49c0-.47-.38-.85-.85-.85h0Zm18.05-2.35h-36.11v-10.53c0-3.27,2.68-3.62,3.83-3.62h28.46c1.15,0,3.82.35,3.82,3.62v10.53Z"
            style={{ fill: "#fff", strokeWidth: "0px" }}
          />
          <path
            d="m111.96,18.64c-2.4,2.4-2.77,6.27-2.77,6.27-.13,1.38-1.05,3.32-2.03,4.3l-.51.51c-.98.98-2.59.98-3.58,0L74.59,1.24c-.98-.98-2.59-.98-3.58,0l-28.48,28.48c-.99.98-2.59.98-3.58,0l-.02-.02c-.98-.98-1.9-2.92-2.03-4.31,0,0-.38-3.87-2.77-6.26-4.14-4.14-10.85-4.14-14.99,0-4.14,4.14-4.14,10.85,0,14.99,2.4,2.4,6.27,2.77,6.27,2.77,1.38.13,3.32,1.05,4.31,2.03l.02.02c.98.98.98,2.59,0,3.58L1.24,71.01c-.98.98-.98,2.59,0,3.58l28.48,28.48c.98.98,2.59.98,3.58,0l.32-.31c.98-.98,1.9-2.92,2.03-4.3,0,0,.38-3.87,2.77-6.27,4.14-4.14,10.85-4.14,14.99,0,4.14,4.14,4.14,10.85,0,14.99-2.4,2.4-6.26,2.77-6.26,2.77-1.38.13-3.32,1.05-4.31,2.03l-.32.32c-.98.98-.99,2.59,0,3.57l28.49,28.48c.98.98,2.59.98,3.58,0l28.49-28.49c.98-.98.98-2.59,0-3.57l-.3-.3c-.98-.99-2.92-1.9-4.31-2.03,0,0-3.87-.38-6.27-2.77-4.14-4.14-4.14-10.85,0-14.99,4.14-4.14,10.85-4.14,14.99,0,2.4,2.4,2.77,6.27,2.77,6.27.14,1.38,1.05,3.32,2.03,4.3l.3.3c.98.98,2.59.98,3.57,0l28.49-28.48c.98-.98.98-2.59,0-3.58l-28.49-28.48c-.98-.98-.98-2.59,0-3.58l.51-.51c.98-.98,2.92-1.9,4.3-2.03,0,0,3.87-.37,6.27-2.77,4.14-4.14,4.14-10.85,0-14.99-4.14-4.14-10.85-4.14-14.99,0Z"
            style={{ fill: "none", stroke: "#fff", strokeLinejoin: "round" }}
          />
        </g>
      </g>
    </svg>
  ),
  puzzle06: (
    <svg
      xmlns="http://www.w3.org/2000/svg"
      width="100%"
      height="100%"
      className="pointer-events-none"
      viewBox="0 0 145.59 145.59">
      <defs>
        <filter id="drop-shadow-1" filterUnits="userSpaceOnUse">
          <feOffset dx="3" dy="3" />
          <feGaussianBlur result="blur" stdDeviation="3" />
          <feFlood flood-color="#000" floodOpacity=".25" />
          <feComposite in2="blur" operator="in" />
          <feComposite in="SourceGraphic" />
        </filter>
        <linearGradient
          id="linear-gradient"
          x1=".5"
          y1="72.8"
          x2="145.09"
          y2="72.8"
          gradientUnits="userSpaceOnUse">
          <stop offset="0" stopColor="#bfe472" />
          <stop offset="1" stopColor="#8bca00" />
        </linearGradient>
      </defs>
      <g xmlns="http://www.w3.org/2000/svg" id="OBJECTS">
        <g style={{ filter: "url(#drop-shadow-1)" }}>
          <path
            d="m18.64,33.63c2.4,2.4,6.27,2.77,6.27,2.77,1.38.13,3.32,1.05,4.31,2.03l.51.51c.98.98.98,2.59,0,3.57L1.24,71.01c-.98.98-.98,2.59,0,3.58l28.48,28.48c.98.98.98,2.59,0,3.58l-.02.02c-.98.99-2.92,1.9-4.3,2.03,0,0-3.87.38-6.27,2.77-4.14,4.14-4.14,10.85,0,14.99,4.14,4.14,10.85,4.14,14.99,0,2.4-2.4,2.78-6.27,2.78-6.27.13-1.39,1.05-3.32,2.03-4.3l.02-.02c.98-.98,2.59-.98,3.58,0l28.49,28.49c.98.98,2.59.98,3.58,0l28.49-28.49c.98-.98.98-2.59,0-3.58l-.31-.32c-.98-.98-2.92-1.9-4.31-2.03,0,0-3.87-.38-6.27-2.77-4.14-4.14-4.14-10.85,0-14.99,4.14-4.14,10.85-4.14,14.99,0,2.4,2.4,2.77,6.27,2.77,6.27.13,1.38,1.05,3.32,2.03,4.3l.32.32c.99.98,2.59.98,3.58,0l28.49-28.48c.98-.98.98-2.59,0-3.58l-28.49-28.49c-.98-.98-2.59-.98-3.58,0l-.3.3c-.98.98-1.9,2.92-2.03,4.3,0,0-.37,3.87-2.77,6.27-4.14,4.14-10.85,4.14-14.99,0-4.14-4.14-4.14-10.85,0-14.99,2.4-2.4,6.26-2.77,6.26-2.77,1.38-.14,3.32-1.05,4.31-2.03l.3-.3c.98-.98.98-2.59,0-3.58L74.59,1.24c-.98-.98-2.59-.98-3.58,0l-28.48,28.48c-.98.98-2.59.98-3.58,0l-.51-.51c-.98-.98-1.9-2.92-2.03-4.31,0,0-.38-3.87-2.77-6.26-4.14-4.14-10.85-4.14-14.99,0-4.14,4.14-4.14,10.85,0,14.99Z"
            style={{ fill: " url(#linear-gradient)", strokeWidth: "0px" }}
          />
          <g>
            <path
              d="m72.67,54.41h-28.85c-2.7,0-5.6,1.47-5.6,5.6v19.34c0,4.12,2.9,5.6,5.6,5.6h10.68v3.56h-1.78c-.48,0-.86.39-.86.86s.39.86.86.86h11.38c.48,0,.86-.39.86-.86s-.39-.86-.86-.86h-2.11v-3.56h10.68c4.12,0,5.6-2.89,5.6-5.6v-19.34c0-4.12-2.89-5.6-5.6-5.6h0Zm-12.4,34.1h-4.05v-3.56h4.05v3.56Zm16.28-9.16c0,1.16-.38,3.87-3.87,3.87h-28.85c-1.16,0-3.88-.38-3.88-3.87v-1.22h36.61v1.22Zm0-2.95h-36.61v-16.4c0-3.49,2.71-3.87,3.88-3.87h28.85c1.16,0,3.87.38,3.87,3.87v16.4Z"
              style={{ fill: "#fff", strokeWidth: "0px" }}
            />
            <path
              d="m64.51,61.82h0c-1.8-3.44-6.04-4.77-9.48-2.97-2.31,1.21-3.76,3.59-3.77,6.2,0,.47.38.86.86.86h6.13c.14,0,.27-.03.4-.1l5.46-2.85c.43-.2.61-.71.41-1.14h0Zm-6.47,2.36h-5.02c.43-2.56,2.64-4.43,5.23-4.43,1.67,0,3.24.78,4.24,2.12l-4.45,2.31Z"
              style={{ fill: "#fff", strokeWidth: "0px" }}
            />
            <path
              d="m65.29,64.65c-.21-.42-.73-.59-1.15-.37,0,0,0,0,0,0l-5.28,2.75h-5.95c-.47,0-.86.38-.86.85,0,3.88,3.14,7.02,7.02,7.03,3.87,0,7.02-3.14,7.02-7.02h0c0-1.13-.28-2.25-.81-3.25h0Zm-6.21,8.54h-.03c-2.59,0-4.8-1.88-5.22-4.44h5.22c.14,0,.28-.03.4-.1l4.64-2.43c.17.52.26,1.07.27,1.62.02,2.93-2.34,5.33-5.27,5.35h0Z"
              style={{ fill: "#fff", strokeWidth: "0px" }}
            />
          </g>
          <path
            d="m18.64,33.63c2.4,2.4,6.27,2.77,6.27,2.77,1.38.13,3.32,1.05,4.31,2.03l.51.51c.98.98.98,2.59,0,3.57L1.24,71.01c-.98.98-.98,2.59,0,3.58l28.48,28.48c.98.98.98,2.59,0,3.58l-.02.02c-.98.99-2.92,1.9-4.3,2.03,0,0-3.87.38-6.27,2.77-4.14,4.14-4.14,10.85,0,14.99,4.14,4.14,10.85,4.14,14.99,0,2.4-2.4,2.78-6.27,2.78-6.27.13-1.39,1.05-3.32,2.03-4.3l.02-.02c.98-.98,2.59-.98,3.58,0l28.49,28.49c.98.98,2.59.98,3.58,0l28.49-28.49c.98-.98.98-2.59,0-3.58l-.31-.32c-.98-.98-2.92-1.9-4.31-2.03,0,0-3.87-.38-6.27-2.77-4.14-4.14-4.14-10.85,0-14.99,4.14-4.14,10.85-4.14,14.99,0,2.4,2.4,2.77,6.27,2.77,6.27.13,1.38,1.05,3.32,2.03,4.3l.32.32c.99.98,2.59.98,3.58,0l28.49-28.48c.98-.98.98-2.59,0-3.58l-28.49-28.49c-.98-.98-2.59-.98-3.58,0l-.3.3c-.98.98-1.9,2.92-2.03,4.3,0,0-.37,3.87-2.77,6.27-4.14,4.14-10.85,4.14-14.99,0-4.14-4.14-4.14-10.85,0-14.99,2.4-2.4,6.26-2.77,6.26-2.77,1.38-.14,3.32-1.05,4.31-2.03l.3-.3c.98-.98.98-2.59,0-3.58L74.59,1.24c-.98-.98-2.59-.98-3.58,0l-28.48,28.48c-.98.98-2.59.98-3.58,0l-.51-.51c-.98-.98-1.9-2.92-2.03-4.31,0,0-.38-3.87-2.77-6.26-4.14-4.14-10.85-4.14-14.99,0-4.14,4.14-4.14,10.85,0,14.99Z"
            style={{ fill: "none", stroke: "#fff", strokeLinejoin: "round" }}
          />
        </g>
      </g>
    </svg>
  ),
  puzzle07: (
    <svg
      xmlns="http://www.w3.org/2000/svg"
      width="100%"
      height="100%"
      className="pointer-events-none"
      viewBox="0 0 145.59 145.59">
      <defs>
        <filter id="drop-shadow-1" filterUnits="userSpaceOnUse">
          <feOffset dx="3" dy="3" />
          <feGaussianBlur result="blur" stdDeviation="3" />
          <feFlood flood-color="#000" floodOpacity=".25" />
          <feComposite in2="blur" operator="in" />
          <feComposite in="SourceGraphic" />
        </filter>
        <linearGradient
          id="linear-gradient"
          x1=".5"
          y1="72.8"
          x2="145.09"
          y2="72.8"
          gradientUnits="userSpaceOnUse">
          <stop offset="0" stopColor="#bfe472" />
          <stop offset="1" stopColor="#8bca00" />
        </linearGradient>
      </defs>
      <g xmlns="http://www.w3.org/2000/svg" id="OBJECTS">
        <g style={{ filter: "url(#drop-shadow-1)" }}>
          <path
            d="m33.63,126.95c2.4-2.4,2.77-6.27,2.77-6.27.13-1.38,1.05-3.32,2.03-4.31l.51-.51c.98-.98,2.59-.98,3.58,0l28.49,28.49c.98.98,2.59.98,3.58,0l28.49-28.48c.98-.98,2.59-.98,3.57,0l.02.02c.98.98,1.9,2.92,2.03,4.31,0,0,.37,3.87,2.77,6.26,4.14,4.14,10.85,4.14,14.99,0,4.14-4.14,4.14-10.85,0-14.99-2.4-2.4-6.27-2.77-6.27-2.77-1.39-.13-3.32-1.05-4.31-2.03l-.02-.02c-.99-.98-.98-2.59,0-3.58l28.48-28.49c.98-.98.98-2.59,0-3.58l-28.48-28.48c-.98-.98-2.59-.98-3.58,0l-.32.31c-.98.98-1.9,2.92-2.03,4.3,0,0-.38,3.87-2.78,6.27-4.14,4.14-10.85,4.14-14.99,0-4.14-4.14-4.14-10.85,0-14.99,2.4-2.4,6.27-2.77,6.27-2.77,1.38-.13,3.32-1.05,4.3-2.03l.32-.32c.98-.98.98-2.59,0-3.58L74.59,1.24c-.98-.98-2.59-.98-3.58,0l-28.49,28.49c-.98.98-.98,2.59,0,3.58l.3.3c.98.99,2.92,1.9,4.31,2.03,0,0,3.87.38,6.27,2.77,4.14,4.14,4.14,10.85,0,14.99-4.14,4.14-10.85,4.14-14.99,0-2.4-2.4-2.77-6.27-2.77-6.27-.14-1.38-1.05-3.32-2.03-4.3l-.3-.3c-.98-.98-2.59-.98-3.58,0L1.24,71.01c-.98.98-.98,2.59,0,3.58l28.49,28.49c.98.98.98,2.59,0,3.58l-.51.51c-.98.98-2.92,1.9-4.31,2.03,0,0-3.87.37-6.27,2.77-4.14,4.14-4.14,10.85,0,14.99,4.14,4.14,10.85,4.14,14.99,0Z"
            style={{ fill: " url(#linear-gradient)", strokeWidth: "0px" }}
          />
          <g>
            <path
              d="m72.41,65.62c-11.08,0-20.07,8.99-20.07,20.07s8.98,20.06,20.07,20.06,20.07-8.98,20.07-20.06c-.01-11.08-8.99-20.05-20.07-20.07h0Zm.86,38.37v-3.53c0-.48-.39-.86-.86-.86s-.86.38-.86.86v3.53c-9.44-.45-16.99-8-17.44-17.44h3.53c.48,0,.86-.39.86-.86s-.39-.86-.86-.86h-3.53c.45-9.44,8-16.99,17.44-17.44v3.53c0,.48.38.86.86.86s.86-.38.86-.86v-3.53c9.44.45,16.99,8,17.44,17.44h-3.53c-.47,0-.86.39-.86.86s.39.86.86.86h3.54c-.45,9.44-8.01,16.99-17.45,17.44h0Z"
              style={{ fill: "#fff", strokeWidth: "0px" }}
            />
            <path
              d="m81.5,93.69l-8.22-8.36v-8.69c0-.47-.39-.86-.86-.86s-.86.39-.86.86v9.04c0,.23.09.44.25.6l8.46,8.61c.33.34.88.35,1.22.01.34-.33.35-.88.01-1.22h0Z"
              style={{ fill: "#fff", strokeWidth: "0px" }}
            />
          </g>
          <path
            d="m33.63,126.95c2.4-2.4,2.77-6.27,2.77-6.27.13-1.38,1.05-3.32,2.03-4.31l.51-.51c.98-.98,2.59-.98,3.58,0l28.49,28.49c.98.98,2.59.98,3.58,0l28.49-28.48c.98-.98,2.59-.98,3.57,0l.02.02c.98.98,1.9,2.92,2.03,4.31,0,0,.37,3.87,2.77,6.26,4.14,4.14,10.85,4.14,14.99,0,4.14-4.14,4.14-10.85,0-14.99-2.4-2.4-6.27-2.77-6.27-2.77-1.39-.13-3.32-1.05-4.31-2.03l-.02-.02c-.99-.98-.98-2.59,0-3.58l28.48-28.49c.98-.98.98-2.59,0-3.58l-28.48-28.48c-.98-.98-2.59-.98-3.58,0l-.32.31c-.98.98-1.9,2.92-2.03,4.3,0,0-.38,3.87-2.78,6.27-4.14,4.14-10.85,4.14-14.99,0-4.14-4.14-4.14-10.85,0-14.99,2.4-2.4,6.27-2.77,6.27-2.77,1.38-.13,3.32-1.05,4.3-2.03l.32-.32c.98-.98.98-2.59,0-3.58L74.59,1.24c-.98-.98-2.59-.98-3.58,0l-28.49,28.49c-.98.98-.98,2.59,0,3.58l.3.3c.98.99,2.92,1.9,4.31,2.03,0,0,3.87.38,6.27,2.77,4.14,4.14,4.14,10.85,0,14.99-4.14,4.14-10.85,4.14-14.99,0-2.4-2.4-2.77-6.27-2.77-6.27-.14-1.38-1.05-3.32-2.03-4.3l-.3-.3c-.98-.98-2.59-.98-3.58,0L1.24,71.01c-.98.98-.98,2.59,0,3.58l28.49,28.49c.98.98.98,2.59,0,3.58l-.51.51c-.98.98-2.92,1.9-4.31,2.03,0,0-3.87.37-6.27,2.77-4.14,4.14-4.14,10.85,0,14.99,4.14,4.14,10.85,4.14,14.99,0Z"
            style={{ fill: "none", stroke: "#fff", strokeLinejoin: "round" }}
          />
        </g>
      </g>
    </svg>
  ),
  puzzle08: (
    <svg
      xmlns="http://www.w3.org/2000/svg"
      width="100%"
      height="100%"
      className="pointer-events-none"
      viewBox="0 0 145.59 145.59">
      <defs>
        <filter id="drop-shadow-1" filterUnits="userSpaceOnUse">
          <feOffset dx="3" dy="3" />
          <feGaussianBlur result="blur" stdDeviation="3" />
          <feFlood flood-color="#000" floodOpacity=".25" />
          <feComposite in2="blur" operator="in" />
          <feComposite in="SourceGraphic" />
        </filter>
        <linearGradient
          id="linear-gradient"
          x1=".5"
          y1="72.8"
          x2="145.09"
          y2="72.8"
          gradientUnits="userSpaceOnUse">
          <stop offset="0" stopColor="#bfe472" />
          <stop offset="1" stopColor="#8bca00" />
        </linearGradient>
      </defs>
      <g xmlns="http://www.w3.org/2000/svg" id="OBJECTS">
        <g style={{ filter: "url(#drop-shadow-1)" }}>
          <path
            d="m126.95,111.96c-2.4-2.4-6.27-2.78-6.27-2.78-1.38-.13-3.32-1.05-4.3-2.03l-.51-.51c-.98-.98-.98-2.59,0-3.58l28.48-28.48c.98-.98.98-2.59,0-3.58l-28.49-28.49c-.98-.98-.98-2.59,0-3.57l.02-.02c.98-.98,2.92-1.9,4.3-2.03,0,0,3.87-.37,6.26-2.77,4.14-4.14,4.14-10.85,0-14.99-4.14-4.14-10.85-4.14-14.99,0-2.4,2.4-2.77,6.27-2.77,6.27-.13,1.38-1.05,3.32-2.03,4.3l-.02.02c-.98.98-2.59.98-3.58,0L74.58,1.24c-.98-.98-2.59-.98-3.58,0l-28.48,28.48c-.98.98-.98,2.59,0,3.58l.32.32c.98.98,2.92,1.9,4.3,2.03,0,0,3.87.38,6.27,2.77,4.14,4.14,4.14,10.85,0,14.99-4.14,4.14-10.85,4.14-14.99,0-2.4-2.4-2.77-6.26-2.77-6.26-.13-1.39-1.05-3.32-2.03-4.31l-.32-.32c-.98-.98-2.59-.98-3.58,0L1.24,71.01c-.98.98-.98,2.59,0,3.58l28.48,28.49c.98.98,2.59.98,3.58,0l.3-.3c.98-.98,1.9-2.92,2.03-4.31,0,0,.38-3.87,2.77-6.27,4.14-4.14,10.85-4.14,14.99,0,4.14,4.14,4.14,10.85,0,14.99-2.4,2.4-6.26,2.77-6.26,2.77-1.38.14-3.32,1.05-4.3,2.03l-.3.3c-.98.98-.98,2.59,0,3.57l28.48,28.49c.98.98,2.59.98,3.58,0l28.49-28.49c.98-.98,2.59-.98,3.58,0l.51.51c.98.98,1.9,2.92,2.03,4.3,0,0,.38,3.87,2.77,6.26,4.14,4.14,10.85,4.14,14.99,0,4.14-4.14,4.14-10.85,0-14.99Z"
            style={{ fill: " url(#linear-gradient)", strokeWidth: "0px" }}
          />
          <path
            d="m104.8,82.65h-2.8v-22.67c-.09-2.49-2.19-4.42-4.68-4.33-2.35.09-4.24,1.97-4.33,4.33v22.67h-2.86v-19.29c-.1-2.49-2.19-4.42-4.68-4.33-2.35.09-4.24,1.98-4.33,4.33v19.29h-2.86v-15.92c-.1-2.49-2.19-4.43-4.68-4.33-2.35.09-4.24,1.98-4.33,4.33v15.92h-2.8c-.37,0-.68.3-.68.68s.3.67.68.67h38.35c.37,0,.68-.3.68-.67s-.3-.68-.68-.68h0Zm-34.21,0v-15.92c.08-1.74,1.56-3.09,3.3-3.01,1.63.08,2.93,1.38,3.01,3.01v15.92s-6.31,0-6.31,0Zm11.88,0v-19.29c.08-1.74,1.56-3.09,3.3-3.01,1.63.08,2.93,1.38,3.01,3.01v19.29s-6.31,0-6.31,0Zm11.88,0v-22.67c.08-1.74,1.56-3.09,3.3-3.01,1.63.08,2.93,1.38,3.01,3.01v22.67s-6.3,0-6.3,0Z"
            style={{ fill: "#fff", strokeWidth: "0px" }}
          />
          <path
            d="m126.95,111.96c-2.4-2.4-6.27-2.78-6.27-2.78-1.38-.13-3.32-1.05-4.3-2.03l-.51-.51c-.98-.98-.98-2.59,0-3.58l28.48-28.48c.98-.98.98-2.59,0-3.58l-28.49-28.49c-.98-.98-.98-2.59,0-3.57l.02-.02c.98-.98,2.92-1.9,4.3-2.03,0,0,3.87-.37,6.26-2.77,4.14-4.14,4.14-10.85,0-14.99-4.14-4.14-10.85-4.14-14.99,0-2.4,2.4-2.77,6.27-2.77,6.27-.13,1.38-1.05,3.32-2.03,4.3l-.02.02c-.98.98-2.59.98-3.58,0L74.58,1.24c-.98-.98-2.59-.98-3.58,0l-28.48,28.48c-.98.98-.98,2.59,0,3.58l.32.32c.98.98,2.92,1.9,4.3,2.03,0,0,3.87.38,6.27,2.77,4.14,4.14,4.14,10.85,0,14.99-4.14,4.14-10.85,4.14-14.99,0-2.4-2.4-2.77-6.26-2.77-6.26-.13-1.39-1.05-3.32-2.03-4.31l-.32-.32c-.98-.98-2.59-.98-3.58,0L1.24,71.01c-.98.98-.98,2.59,0,3.58l28.48,28.49c.98.98,2.59.98,3.58,0l.3-.3c.98-.98,1.9-2.92,2.03-4.31,0,0,.38-3.87,2.77-6.27,4.14-4.14,10.85-4.14,14.99,0,4.14,4.14,4.14,10.85,0,14.99-2.4,2.4-6.26,2.77-6.26,2.77-1.38.14-3.32,1.05-4.3,2.03l-.3.3c-.98.98-.98,2.59,0,3.57l28.48,28.49c.98.98,2.59.98,3.58,0l28.49-28.49c.98-.98,2.59-.98,3.58,0l.51.51c.98.98,1.9,2.92,2.03,4.3,0,0,.38,3.87,2.77,6.26,4.14,4.14,10.85,4.14,14.99,0,4.14-4.14,4.14-10.85,0-14.99Z"
            style={{ fill: "none", stroke: "#fff", strokeLinejoin: "round" }}
          />
        </g>
      </g>
    </svg>
  ),
  puzzle09: (
    <svg
      xmlns="http://www.w3.org/2000/svg"
      width="100%"
      height="100%"
      className="pointer-events-none"
      viewBox="0 0 145.59 145.59">
      <defs>
        <filter id="drop-shadow-1" filterUnits="userSpaceOnUse">
          <feOffset dx="3" dy="3" />
          <feGaussianBlur result="blur" stdDeviation="3" />
          <feFlood flood-color="#000" floodOpacity=".25" />
          <feComposite in2="blur" operator="in" />
          <feComposite in="SourceGraphic" />
        </filter>
        <linearGradient
          id="linear-gradient"
          x1=".5"
          y1="72.8"
          x2="145.09"
          y2="72.8"
          gradientUnits="userSpaceOnUse">
          <stop offset="0" stopColor="#bfe472" />
          <stop offset="1" stopColor="#8bca00" />
        </linearGradient>
      </defs>
      <g xmlns="http://www.w3.org/2000/svg" id="OBJECTS">
        <g style={{ filter: "url(#drop-shadow-1)" }}>
          <path
            d="m33.64,126.95c2.4-2.4,2.77-6.27,2.77-6.27.13-1.39,1.05-3.32,2.03-4.3l.51-.51c.98-.98,2.59-.98,3.58,0l28.49,28.48c.98.99,2.59.98,3.58,0l28.48-28.48c.98-.98,2.59-.98,3.58,0l.02.02c.98.98,1.9,2.92,2.03,4.3,0,0,.38,3.86,2.77,6.26,4.14,4.14,10.85,4.14,14.99,0,4.14-4.14,4.14-10.85,0-14.99-2.4-2.4-6.27-2.77-6.27-2.77-1.38-.13-3.32-1.05-4.31-2.03l-.02-.02c-.98-.98-.98-2.59,0-3.58l28.49-28.49c.98-.98.98-2.59,0-3.58l-28.48-28.48c-.98-.98-2.59-.98-3.58,0l-.32.32c-.98.98-1.9,2.92-2.03,4.3,0,0-.38,3.87-2.77,6.27-4.14,4.14-10.85,4.14-14.99,0-4.14-4.14-4.14-10.85,0-14.99,2.4-2.4,6.27-2.77,6.27-2.77,1.38-.13,3.32-1.05,4.31-2.03l.31-.32c.98-.98.98-2.59,0-3.58L74.59,1.24c-.98-.98-2.59-.98-3.58,0l-28.49,28.49c-.98.98-.98,2.59,0,3.58l.3.3c.98.98,2.92,1.9,4.31,2.03,0,0,3.87.38,6.27,2.77,4.14,4.14,4.14,10.85,0,14.99-4.14,4.14-10.85,4.14-14.99,0-2.4-2.4-2.77-6.26-2.77-6.26-.14-1.39-1.05-3.32-2.03-4.31l-.3-.3c-.99-.98-2.59-.98-3.58,0L1.24,71.01c-.98.98-.98,2.59,0,3.58l28.48,28.48c.98.98.98,2.59,0,3.58l-.51.51c-.98.98-2.92,1.9-4.31,2.03,0,0-3.87.37-6.27,2.77-4.14,4.14-4.14,10.85,0,14.99,4.14,4.14,10.85,4.14,14.99,0Z"
            style={{ fill: "#a9bdcc", opacity: ".5", strokeWidth: "0px" }}
          />
          <path
            d="m33.64,126.95c2.4-2.4,2.77-6.27,2.77-6.27.13-1.39,1.05-3.32,2.03-4.3l.51-.51c.98-.98,2.59-.98,3.58,0l28.49,28.48c.98.99,2.59.98,3.58,0l28.48-28.48c.98-.98,2.59-.98,3.58,0l.02.02c.98.98,1.9,2.92,2.03,4.3,0,0,.38,3.86,2.77,6.26,4.14,4.14,10.85,4.14,14.99,0,4.14-4.14,4.14-10.85,0-14.99-2.4-2.4-6.27-2.77-6.27-2.77-1.38-.13-3.32-1.05-4.31-2.03l-.02-.02c-.98-.98-.98-2.59,0-3.58l28.49-28.49c.98-.98.98-2.59,0-3.58l-28.48-28.48c-.98-.98-2.59-.98-3.58,0l-.32.32c-.98.98-1.9,2.92-2.03,4.3,0,0-.38,3.87-2.77,6.27-4.14,4.14-10.85,4.14-14.99,0-4.14-4.14-4.14-10.85,0-14.99,2.4-2.4,6.27-2.77,6.27-2.77,1.38-.13,3.32-1.05,4.31-2.03l.31-.32c.98-.98.98-2.59,0-3.58L74.59,1.24c-.98-.98-2.59-.98-3.58,0l-28.49,28.49c-.98.98-.98,2.59,0,3.58l.3.3c.98.98,2.92,1.9,4.31,2.03,0,0,3.87.38,6.27,2.77,4.14,4.14,4.14,10.85,0,14.99-4.14,4.14-10.85,4.14-14.99,0-2.4-2.4-2.77-6.26-2.77-6.26-.14-1.39-1.05-3.32-2.03-4.31l-.3-.3c-.99-.98-2.59-.98-3.58,0L1.24,71.01c-.98.98-.98,2.59,0,3.58l28.48,28.48c.98.98.98,2.59,0,3.58l-.51.51c-.98.98-2.92,1.9-4.31,2.03,0,0-3.87.37-6.27,2.77-4.14,4.14-4.14,10.85,0,14.99,4.14,4.14,10.85,4.14,14.99,0Z"
            style={{
              fill: "none",
              opacity: ".5",
              stroke: "#fff",
              strokeLinejoin: "round",
            }}
          />
        </g>
      </g>
    </svg>
  ),
  twitter: (
    <svg
      xmlns="http://www.w3.org/2000/svg"
      width="100%"
      height="100%"
      className="pointer-events-none"
      viewBox="0 0 2.67 2.19">
      <g>
        <path
          d="m0,1.95c.2.01.39-.02.57-.1.08-.04.16-.08.23-.14-.09,0-.17-.02-.24-.06-.12-.06-.21-.16-.26-.29t.02-.03c.09,0,.15,0,.2-.01-.05-.02-.09-.03-.13-.05-.18-.1-.28-.26-.3-.47,0-.02,0-.03.03-.02.06.04.13.05.22.06-.04-.03-.07-.06-.09-.08C.1.59.06.33.16.13c.01-.03.02-.03.04,0,.26.3.58.48.96.54.04,0,.08,0,.12.02.03,0,.03,0,.03-.03-.04-.23.07-.46.27-.58.21-.12.48-.08.65.08.02.02.04.02.06.01.1-.02.2-.06.29-.11,0,0,.01,0,.02-.01-.04.13-.12.23-.23.3.11-.01.2-.04.3-.08,0,.01,0,.02-.01.03-.06.09-.14.17-.23.23-.02.01-.02.02-.02.05,0,.4-.12.76-.38,1.08-.24.29-.55.46-.92.52-.39.06-.76,0-1.1-.21,0,0,0,0-.01,0Z"
          style={{ fillRule: "evenodd", strokeWidth: "0px" }}
        />
      </g>
    </svg>
  ),
  viber: (
    <svg
      xmlns="http://www.w3.org/2000/svg"
      width="100%"
      height="100%"
      className="pointer-events-none"
      viewBox="0 0 2.55 2.57">
      <g>
        <g>
          <path
            d="m2.52.98C2.38.4,1.88,0,1.28,0c-.08,0-.17,0-.24.03C.19.19-.25,1.13.16,1.88c.01.02.01.04.01.06-.06.19-.11.39-.17.59t.02.03c.21-.06.41-.11.62-.16.02,0,.03,0,.05,0,.26.13.54.17.84.12.7-.14,1.16-.85.99-1.54Zm-1.06,1.33c-.06.01-.12.02-.15.01-.23,0-.41-.05-.57-.15-.02-.01-.04-.02-.06-.01-.12.03-.23.06-.34.09-.02,0-.03,0-.02-.02.03-.1.06-.21.09-.32,0-.03,0-.05-.01-.08-.23-.38-.22-.84.04-1.19C.69.3,1.06.15,1.5.24c.43.09.71.37.81.8.14.59-.26,1.18-.85,1.27Z"
            style={{ fillRule: "evenodd", strokeWidth: "0px" }}
          />
          <path
            d="m1.61,1.88s-.09,0-.13-.02c-.29-.08-.51-.26-.69-.51-.07-.09-.13-.19-.15-.3-.03-.13.01-.25.11-.34.03-.03.13-.05.17-.03.01.01.02.02.03.03.04.09.07.17.11.26,0,.02,0,.04,0,.05-.02.04-.05.07-.08.11-.02.02-.02.04,0,.07.1.17.25.3.44.37.03.01.05,0,.07-.01.03-.04.06-.08.1-.12.02-.03.04-.03.07-.02.06.03.12.06.18.08.02,0,.03.01.04.02.06.03.06.04.06.1,0,.13-.11.2-.23.23-.03,0-.06,0-.08,0Z"
            style={{ fillRule: "evenodd", strokeWidth: "0px" }}
          />
        </g>
      </g>
    </svg>
  ),
  backToTop: (
    <svg
      xmlns="http://www.w3.org/2000/svg"
      width="100%"
      height="100%"
      className="pointer-events-none"
      viewBox="0 0 32 32"
      fill="black">
      <polygon points="16,14 6,24 7.4,25.4 16,16.8 24.6,25.4 26,24 " />
      <rect x="4" y="8" width="24" height="2" />
      <rect id="_Transparent_Rectangle_" fill="none" width="32" height="32" />
    </svg>
  ),
  globe: (
    <svg
      xmlns="http://www.w3.org/2000/svg"
      width="100%"
      height="100%"
      className="pointer-events-none"
      viewBox="0 0 512 512">
      <title>world-globe-glyph</title>
      <path
        d="M.9,270.51c.17,2.85.37,5.68.64,8.53.75,8.65,1.87,17.28,3.42,25.86,7.26,39.57,24.64,76.72,48.87,108.61,29.07,37.16,68.65,65.83,112.27,83.2a257,257,0,0,0,79.77,15.11l1.51.18s0-.11,0-.15c2.86.07,5.72,0,8.58,0a286.31,286.31,0,0,0,87-14c44-17.36,84.4-45.62,113.89-83.18,23-29.76,39.75-63.81,48-100.22,1.12-4.54,2.14-9.11,3-13.71a259.88,259.88,0,0,0,3.59-37.55c.09-2.82.13-5.66.11-8.49,0-.3,0-.57,0-.88,0-3.57-.16-7.13-.34-10.71,0-.55-.06-1.11-.08-1.67-.18-2.84-.38-5.7-.64-8.53-.76-8.66-1.88-17.29-3.43-25.86-7.26-39.57-24.63-76.73-48.86-108.64C429.09,61.34,389.52,32.66,345.9,15.3A257,257,0,0,0,266.12.19L264.62,0l0,.16c-2.87-.08-5.72-.06-8.59,0a287,287,0,0,0-87,14C125,31.46,84.63,59.72,55.15,97.27c-23,29.76-39.75,63.81-48,100.23C6,202,5,206.62,4.16,211.2A258.81,258.81,0,0,0,.58,248.75c-.08,2.84-.11,5.69-.11,8.5,0,.29,0,.57,0,.86,0,3.59.15,7.14.33,10.72C.84,269.38.88,269.94.9,270.51ZM357.5,442.45c8.42-20.41,19.2-39.81,27.76-60.51.57-1,1.16-2,1.75-3.07,13.06,1.58,26.11,3.56,39.15,6.32C407.31,408.75,384.86,429.59,357.5,442.45ZM465.82,295.89c-.32,1.71-.66,3.43-1,5.13-.26,1.24-.52,2.49-.82,3.73-.39,1.71-.83,3.38-1.27,5.08A278.35,278.35,0,0,1,447,352.88c-16.38-2.36-32.4-5.46-48.38-8.58,5.38-23.86,10.64-47.42,13-71.7h57A165.71,165.71,0,0,1,465.82,295.89ZM446.35,158.71C458.61,184.06,466.59,211,468.79,239c-19.17.36-38,.4-56.8.4a374.2,374.2,0,0,0-8.86-72.24C417.27,164.36,431.81,161.55,446.35,158.71Zm-21-31.84q-16.34,3.95-32.69,6.63c-9-20.1-19-39.88-27.9-60.4A197.32,197.32,0,0,1,425.36,126.87ZM273.91,43.62c6.16.91,13,1,19.59,2a14.42,14.42,0,0,1,5.56,5.18c20.18,27.46,37.15,56.95,49.26,88.85a466.78,466.78,0,0,1-74.41,4.9Zm0,136.09c28.81,0,57.59-2.83,86.38-6,6.53,21.17,11.51,43.42,12.67,65.69h-99Zm0,92.88c33.3,0,66.57-.31,99.87.28a221.28,221.28,0,0,1-8.9,65.49,742.77,742.77,0,0,0-91-6Zm0,95.3c26.69-.39,53.38,2.35,79.66,5.53-12.32,30.5-28.34,60.14-48.85,85.7-7.2,9.71-19.85,8.21-30.81,9.2ZM86.64,385.14q16.35-4,32.69-6.62c9,20.09,19,39.88,27.9,60.39A197.19,197.19,0,0,1,86.64,385.14Zm151.45,83.25c-6.15-.9-13-1-19.6-2a14.66,14.66,0,0,1-5.57-5.18c-20.17-27.46-37.15-57-49.26-88.85a466.9,466.9,0,0,1,74.42-4.92Zm0-136.08c-28.8,0-57.59,2.81-86.39,6-6.52-21.17-11.49-43.41-12.68-65.67h99.06Zm0-92.87c-33.3,0-66.57.3-99.87-.29a221.87,221.87,0,0,1,8.88-65.49,744.59,744.59,0,0,0,91,6ZM207.27,52.91c7.22-9.72,19.87-8.22,30.82-9.21V144.12c-26.69.4-53.37-2.35-79.66-5.52C170.75,108.08,186.78,78.45,207.27,52.91ZM154.49,69.57c-8.41,20.41-19.18,39.82-27.76,60.5-.57,1-1.16,2.05-1.74,3.09-13-1.6-26.09-3.58-39.16-6.33C104.68,103.27,127.13,82.42,154.49,69.57ZM46.16,216.13c.33-1.72.67-3.45,1-5.15.27-1.24.53-2.49.84-3.72.39-1.7.84-3.4,1.28-5.08a277.6,277.6,0,0,1,15.65-43c16.37,2.36,32.39,5.45,48.39,8.56-5.4,23.87-10.66,47.42-13,71.72H43.44A164.28,164.28,0,0,1,46.16,216.13ZM100,272.6a374.92,374.92,0,0,0,8.86,72.23c-14.13,2.83-28.67,5.65-43.21,8.48C53.38,328,45.41,301,43.2,273,62.36,272.63,81.2,272.6,100,272.6Z"
        fill="#434040"
      />
    </svg>
  ),
  book: (
    <svg
      xmlns="http://www.w3.org/2000/svg"
      width="100%"
      height="100%"
      className="pointer-events-none"
      viewBox="0 0 24 24">
      <path d="M15 12h-10v1h10v-1zm-4 2h-6v1h6v-1zm4-6h-10v1h10v-1zm0 2h-10v1h10v-1zm0-6h-10v1h10v-1zm0 2h-10v1h10v-1zm7.44 10.277c.183-2.314-.433-2.54-3.288-5.322.171 1.223.528 3.397.911 5.001.089.382-.416.621-.586.215-.204-.495-.535-2.602-.82-4.72-.154-1.134-1.661-.995-1.657.177.005 1.822.003 3.341 0 6.041-.003 2.303 1.046 2.348 1.819 4.931.132.444.246.927.339 1.399l3.842-1.339c-1.339-2.621-.693-4.689-.56-6.383zm-6.428 1.723h-13.012v-16h14v7.894c.646-.342 1.348-.274 1.877.101l.123-.018v-8.477c0-.828-.672-1.5-1.5-1.5h-15c-.828 0-1.5.671-1.5 1.5v17c0 .829.672 1.5 1.5 1.5h13.974c-.245-.515-.425-1.124-.462-2z" />
    </svg>
  ),
  calendar: (
    <svg
      xmlns="http://www.w3.org/2000/svg"
      width="100%"
      height="100%"
      className="pointer-events-none"
      viewBox="0 0 24 24">
      <path d="M17 1c0-.552-.447-1-1-1s-1 .448-1 1v2c0 .552.447 1 1 1s1-.448 1-1v-2zm-12 2c0 .552-.447 1-1 1s-1-.448-1-1v-2c0-.552.447-1 1-1s1 .448 1 1v2zm13 5v10h-16v-10h16zm2-6h-2v1c0 1.103-.897 2-2 2s-2-.897-2-2v-1h-8v1c0 1.103-.897 2-2 2s-2-.897-2-2v-1h-2v18h20v-18zm4 3v19h-22v-2h20v-17h2zm-17 7h-2v-2h2v2zm4 0h-2v-2h2v2zm4 0h-2v-2h2v2zm-8 4h-2v-2h2v2zm4 0h-2v-2h2v2zm4 0h-2v-2h2v2z" />
    </svg>
  ),
  chart: (
    <svg
      xmlns="http://www.w3.org/2000/svg"
      width="100%"
      height="100%"
      className="pointer-events-none"
      viewBox="0 0 24 24">
      <path d="M5 20v2h-2v-2h2zm2-2h-6v6h6v-6zm6-1v5h-2v-5h2zm2-2h-6v9h6v-9zm6-2v9h-2v-9h2zm2-2h-6v13h6v-13zm0-11l-6 1.221 1.716 1.708-6.85 6.733-3.001-3.002-7.841 7.797 1.41 1.418 6.427-6.39 2.991 2.993 8.28-8.137 1.667 1.66 1.201-6.001z" />
    </svg>
  ),
  checkboxChecked: (
    <svg
      xmlns="http://www.w3.org/2000/svg"
      width="100%"
      height="100%"
      className="pointer-events-none"
      fillRule="evenodd"
      clipRule="evenodd">
      <path d="M19 22h-19v-19h19v2h-1v-1h-17v17h17v-9.502h1v10.502zm5-19.315l-14.966 15.872-5.558-6.557.762-.648 4.833 5.707 14.201-15.059.728.685z" />
    </svg>
  ),
  clockThin: (
    <svg
      xmlns="http://www.w3.org/2000/svg"
      width="100%"
      height="100%"
      className="pointer-events-none"
      fillRule="evenodd"
      clipRule="evenodd">
      <path d="M12 0c6.623 0 12 5.377 12 12s-5.377 12-12 12-12-5.377-12-12 5.377-12 12-12zm0 1c6.071 0 11 4.929 11 11s-4.929 11-11 11-11-4.929-11-11 4.929-11 11-11zm0 11h6v1h-7v-9h1v8z" />
    </svg>
  ),
  cloudDownloadThin: (
    <svg
      xmlns="http://www.w3.org/2000/svg"
      width="100%"
      height="100%"
      className="pointer-events-none"
      fillRule="evenodd"
      clipRule="evenodd">
      <path d="M11.5 8h1v7.826l2.5-3.076.753.665-3.753 4.585-3.737-4.559.737-.677 2.5 3.064v-7.828zm7 12h-13c-2.481 0-4.5-2.019-4.5-4.5 0-2.178 1.555-4.038 3.698-4.424l.779-.14.043-.79c.185-3.447 3.031-6.146 6.48-6.146 3.449 0 6.295 2.699 6.479 6.146l.043.79.78.14c2.142.386 3.698 2.246 3.698 4.424 0 2.481-2.019 4.5-4.5 4.5m.979-9.908c-.212-3.951-3.473-7.092-7.479-7.092s-7.267 3.141-7.479 7.092c-2.57.463-4.521 2.706-4.521 5.408 0 3.037 2.463 5.5 5.5 5.5h13c3.037 0 5.5-2.463 5.5-5.5 0-2.702-1.951-4.945-4.521-5.408" />
    </svg>
  ),
  coffee: (
    <svg
      xmlns="http://www.w3.org/2000/svg"
      width="100%"
      height="100%"
      className="pointer-events-none"
      viewBox="0 0 24 24">
      <path d="M17.978 11.155c.038-.383.081-.758.11-1.155h3.912c-.083.915-.306 1.876-.638 2.837-.951-.824-2.107-1.419-3.384-1.682zm-7.604-4.156c4.737-4.27-.979-4.044.116-6.999-3.781 3.817 1.41 3.902-.116 6.999zm-1.415 11.501c0-4.201 3.49-7.675 7.832-7.483.098-.966.173-1.964.209-3.017h-15c.258 7.569 2.143 12.68 4 16h5.377c-1.482-1.371-2.418-3.326-2.418-5.5zm-1.365-11.5c3.154-2.825-.664-3.102.087-5.099-2.642 2.787.95 2.859-.087 5.099zm5.365 11.5c0 1.93 1.57 3.5 3.5 3.5s3.5-1.57 3.5-3.5-1.57-3.5-3.5-3.5-3.5 1.57-3.5 3.5zm9 0c0 3.038-2.462 5.5-5.5 5.5s-5.5-2.462-5.5-5.5 2.462-5.5 5.5-5.5 5.5 2.462 5.5 5.5zm-3-.5v1h-3v-3h1v2h2z" />
    </svg>
  ),
  computer: (
    <svg
      xmlns="http://www.w3.org/2000/svg"
      width="100%"
      height="100%"
      className="pointer-events-none"
      fillRule="evenodd"
      clipRule="evenodd">
      <path d="M24 8.2c0-.318-.126-.623-.351-.849-.226-.225-.531-.351-.849-.351h-6.6c-.318 0-.623.126-.849.351-.225.226-.351.531-.351.849v13.6c0 .318.126.623.351.849.226.225.531.351.849.351h6.6c.318 0 .623-.126.849-.351.225-.226.351-.531.351-.849v-13.6zm-11 14.8h-8l2.599-3h5.401v3zm6.5-1c-.553 0-1-.448-1-1s.447-1 1-1c.552 0 .999.448.999 1s-.447 1-.999 1zm3.5-3v-9.024h-7v9.024h7zm-2-14h-2v-2h-17v13h11v2h-13v-17h21v4zm-.5 4c.276 0 .5-.224.5-.5s-.224-.5-.5-.5h-2c-.276 0-.5.224-.5.5s.224.5.5.5h2z" />
    </svg>
  ),
  copy: (
    <svg
      xmlns="http://www.w3.org/2000/svg"
      width="100%"
      height="100%"
      className="pointer-events-none"
      viewBox="0 0 24 24">
      <path d="M10 8h-2v2h-2v-4h4v2zm8 16v-2h-6v2h6zm2-16h2v2h2v-4h-4v2zm2 12v2h-2v2h4v-4h-2zm-12 2h-2v-2h-2v4h4v-2zm14-10h-2v6h2v-6zm-16 6v-6h-2v4h-4v-14h14v4h-4v2h6v-8h-18v18h8z" />
    </svg>
  ),
  copyThin: (
    <svg
      xmlns="http://www.w3.org/2000/svg"
      width="100%"
      height="100%"
      className="pointer-events-none"
      fillRule="evenodd"
      clipRule="evenodd">
      <path d="M17 7h6v16h-16v-6h-6v-16h16v6zm5 1h-14v14h14v-14zm-6-1v-5h-14v14h5v-9h9z" />
    </svg>
  ),
  deliveryHead: (
    <svg
      xmlns="http://www.w3.org/2000/svg"
      width="100%"
      height="100%"
      className="pointer-events-none"
      fillRule="evenodd"
      clipRule="evenodd">
      <path d="M3.848 19h-.848c-.796 0-1.559-.316-2.121-.879-.563-.562-.879-1.325-.879-2.121v-3c0-7.175 5.377-13 12-13s12 5.825 12 13v3c0 .796-.316 1.559-.879 2.121-.562.563-1.325.879-2.121.879h-.848c-2.69 4.633-6.904 5-8.152 5-1.248 0-5.462-.367-8.152-5zm16.152-5.876c-.601.236-1.269-.18-1.269-.797 0-.304-.022-.61-.053-.915-1.761-.254-3.618-1.926-3.699-3.723-1.315 2.005-4.525 4.17-7.044 4.17 1.086-.699 1.839-2.773 1.903-3.508-.581 1.092-2.898 3.136-4.551 3.487l-.018.489c0 .619-.669 1.032-1.269.797v3.771c.287.256.632.464 1.041.594.225.072.412.224.521.424 2.206 4.046 5.426 4.087 6.438 4.087.929 0 3.719-.035 5.877-3.169-1.071.433-2.265.604-3.759.653-.37.6-1.18 1.016-2.118 1.016-1.288 0-2.333-.784-2.333-1.75s1.045-1.75 2.333-1.75c.933 0 1.738.411 2.112 1.005 1.9-.026 4.336-.334 5.888-2.645v-2.236zm-11-.624c.686 0 1.243.672 1.243 1.5s-.557 1.5-1.243 1.5-1.243-.672-1.243-1.5.557-1.5 1.243-1.5zm6 0c.686 0 1.243.672 1.243 1.5s-.557 1.5-1.243 1.5-1.243-.672-1.243-1.5.557-1.5 1.243-1.5zm5.478-1.5h1.357c-.856-5.118-4.937-9-9.835-9-4.898 0-8.979 3.882-9.835 9h1.357c.52-4.023 3.411-7.722 8.478-7.722s7.958 3.699 8.478 7.722z" />
    </svg>
  ),
  deliveryPhone: (
    <svg
      xmlns="http://www.w3.org/2000/svg"
      width="100%"
      height="100%"
      className="pointer-events-none"
      fillRule="evenodd"
      clipRule="evenodd">
      <path d="M12.666 22.908l-2.787-5.379-1.634.8c-1.773.86-5.383-6.191-3.649-7.12l1.648-.812-2.764-5.397-1.667.823c-5.702 2.972 3.351 20.569 9.183 17.903.096-.043 1.664-.815 1.67-.818zm4.902-2.603l1.041 1.71c-1.019.674-2.147 1.197-3.351 1.537l-.934-1.824c1.175-.28 2.27-.768 3.244-1.423zm2.922-3.022l1.882.752c-.678 1.162-1.546 2.199-2.56 3.071l-1.057-1.736c.668-.612 1.253-1.315 1.735-2.087zm.699-1.336c.522-1.211.811-2.546.811-3.947 0-5.519-4.481-10-10-10-2.497 0-4.781.917-6.534 2.432l-.933-1.824c2.05-1.632 4.645-2.608 7.467-2.608 6.623 0 12 5.377 12 12 0 1.664-.34 3.249-.953 4.69l-1.858-.743zm-3.511-.947h-1.438v-1.55h-2.88v-.989l2.46-3.96h1.858v3.81h.78v1.139h-.78v1.55zm-5.07 0h-4.608v-.919l.84-.76c1.42-1.27 2.11-2 2.13-2.761 0-.53-.32-.95-1.07-.95-.56 0-1.05.28-1.39.54l-.43-1.089c.49-.37 1.25-.67 2.13-.67 1.469 0 2.278.859 2.278 2.039 0 1.091-.789 1.961-1.728 2.801l-.6.5v.02h2.448v1.249zm3.632-2.689v-1.44c0-.391.02-.791.05-1.211h-.04c-.21.42-.38.8-.6 1.211l-.87 1.42v.02h1.46z" />
    </svg>
  ),
  door: (
    <svg
      xmlns="http://www.w3.org/2000/svg"
      width="100%"
      height="100%"
      className="pointer-events-none"
      fillRule="evenodd"
      clipRule="evenodd">
      <path d="M11 21h8.033v-2l1-1v4h-9.033v2l-10-3v-18l10-3v2h9.033v5l-1-1v-3h-8.033v18zm-1 1.656v-21.312l-8 2.4v16.512l8 2.4zm11.086-10.656l-3.293-3.293.707-.707 4.5 4.5-4.5 4.5-.707-.707 3.293-3.293h-9.053v-1h9.053z" />
    </svg>
  ),
  file: (
    <svg
      xmlns="http://www.w3.org/2000/svg"
      width="100%"
      height="100%"
      className="pointer-events-none"
      viewBox="0 0 24 24">
      <path d="M13.744 8s1.522-8-3.335-8h-8.409v24h20v-13c0-3.419-5.247-3.745-8.256-3zm4.256 11h-12v-1h12v1zm0-3h-12v-1h12v1zm0-3h-12v-1h12v1zm-3.432-12.925c2.202 1.174 5.938 4.883 7.432 6.881-1.286-.9-4.044-1.657-6.091-1.179.222-1.468-.185-4.534-1.341-5.702z" />
    </svg>
  ),
  flag: (
    <svg
      xmlns="http://www.w3.org/2000/svg"
      width="100%"
      height="100%"
      className="pointer-events-none"
      viewBox="0 0 24 24">
      <path d="M10 12h-1v-12h1v12zm5.11-10.233c-1.243 0-1.272-1.267-2.716-1.267-.527 0-1.028.196-1.395.42v5.08c.361-.344.943-.645 1.399-.645 1.363 0 1.556 1.205 2.771 1.205.785 0 1.83-.595 1.83-.595v-4.824c.001 0-1.099.626-1.889.626zm-3.937 9.684l-.1.069-.047.013-.047.058.005.032-.058.071c-.056.057.003.093.061.068.083-.037.195-.035.205-.146l.055-.066c.024-.036-.045-.093-.074-.099zm.072.471c.062.091.549-.13.471-.117.15-.075.02-.083-.064-.127-.029-.143-.053-.364-.141-.453l.057-.067c-.138-.199-.239.241-.239.241l.073-.021-.034.09c.058.104.013.166.005.221l-.1.062c-.035.044.172.05.174.057.006.023-.251.06-.202.114zm1.79 1.457c-.046 0-.296.023-.272.068.142.233.322-.062.272-.068zm-1.035-5.379c-.34 0-.672.028-1 .069v1.408c.443-.079.898-.126 1.367-.126.729 0 1.815.299 2.065.448.377.226-.164.209-.225.357-.044.114-.15.268-.197.33-.082.106-.319.061-.273-.066.048-.133.278-.184-.069-.216-.355-.032-.454-.272-.812.027-.106.09-.188.228-.255.347l-.435.317c-.097.154.055.41.242.296.049-.03.611.516.539.076-.047-.292.156-.49.161-.71.003-.146.224-.053.164.024-.077.097-.163.427.04.443.088.007.34-.184.369-.042-.042-.137-.284.281-.269.275-.086.039-.188-.016-.12.168.061.182-.328.16-.396.197-.03.016-.332-.09-.327-.022-.104-.087.03-.303-.058-.338-.087.135-.047.41-.235.41-.161 0-.384.183-.483.295-.067.076-.486.246-.531.24.24.025.229.201.209.35-.049.347-.797.025-.765.157.03.125-.087.469-.112.579-.021.1.322.164.303.214.002-.006.467-.16.512-.2l.105-.235c.087-.059.181-.106.279-.143l.119-.207c.04-.016.517-.089.549-.074.12.055.342.283.425.386.03.039.181.094.181.15l-.002.178c.082.155.104-.321.068-.231 0-.152.112.056.139.039l-.526-.523c-.163-.274.437.146.513.197s.229.503.429.401l.086-.183.359-.071c-.285.208.223.481.146.444.128.06.203-.046.283-.017.045.018.529.012.451-.065.123.061.066.598-.033.681-.163.135-.945.079-1.12-.046-.289-.209-.237.223-.378.282-.274.113-.686-.37-.974-.386.14.021.012-.356.012-.382-.11-.137-.816.015-1.001.04-.35.046-.713.042-.979.258-.188.152-.19.4-.382.521-.123.077-.259.052-.364.152-.188.178-.402.441-.508.676-.044.098.056.333.032.459-.244.773.061 1.846.999 1.964.228.028.465.152.694.083.185-.055.346-.18.543-.194.274-.019.16.385.535.275.184-.054.266.125.266.261-.061.285-.194.443.064.643.176.137.322.332.354.567.019.132.142.359-.011.438-.109.055-.188.368-.188.472.022.12.266.35.339.451.105.146.028.317.114.482.089.169.174.298.236.469.08.236.696-.005.84-.004.489.003.738-.686 1.083-.898.192-.12.14-.448.37-.617.216-.157.442-.25.462-.539.017-.25-.188-.772-.075-.983.137-.252 1.576-2.287 1.146-2.389l-.606.288c-.118.011-.573-.48-.69-.599-.221-.221-.318-.614-.5-.884-.104-.158-.424-.471-.424-.667.013.036.146.262.209.214l.012-.111c-.005.06.375.496.459.542.185.104.182.403.365.543.35.269.254 1.031.765.568.344-.31 1.013-.897.835-1.433-.094-.284-.527-.076-.662.025-.142-.075-.664-.643-.458-.717.101-.037.324.262.403.307l.382-.005c.109.229.829-.235 1-.169.113.043.2.136.239.252.12.368.238 1.064.238 1.754 0 3.678-2.981 6.66-6.66 6.66-1.893 0-3.6-.791-4.812-2.058-.145-.151-.252-.509-.014-.655l.24-.062c.188-.16-.177-.808-.031-.912.448-.321.234-.714-.041-1.039-.117-.138-.758-.8-.831-.682.055-.181-.116-.618-.219-.791-.175-.29-.401-.467-.493-.786-.037-.126-.037-.512-.111-.601-.031-.036-.262-.134-.252-.187.289-1.72 1.236-3.149 2.568-4.129v-1.676c-2.389 1.384-4 3.962-4 6.921 0 4.418 3.581 8 8 8 4.418 0 8-3.582 8-8s-3.582-8-8-8zm3.042 4.869c-.092-.025-.562-.168-.581.017 0 .11-.448.001-.378-.116.049-.078.033-.255.123-.371.127-.168.25-.077.255.021 0 .26.263-.246.409-.263.055-.006-.07.111-.07.111.021.169.146.262.383.348.287.102.024.299-.141.253z" />
    </svg>
  ),
  fullscreenThin: (
    <svg
      xmlns="http://www.w3.org/2000/svg"
      width="100%"
      height="100%"
      className="pointer-events-none"
      fillRule="evenodd"
      clipRule="evenodd">
      <path d="M24 22h-24v-20h24v20zm-1-19h-22v18h22v-18zm-4 7h-1v-3.241l-11.241 11.241h3.241v1h-5v-5h1v3.241l11.241-11.241h-3.241v-1h5v5z" />
    </svg>
  ),
  help: (
    <svg
      xmlns="http://www.w3.org/2000/svg"
      width="100%"
      height="100%"
      className="pointer-events-none"
      viewBox="0 0 24 24">
      <path d="M12 0c-6.627 0-12 5.373-12 12s5.373 12 12 12 12-5.373 12-12-5.373-12-12-12zm0 18.25c-.69 0-1.25-.56-1.25-1.25s.56-1.25 1.25-1.25c.691 0 1.25.56 1.25 1.25s-.559 1.25-1.25 1.25zm1.961-5.928c-.904.975-.947 1.514-.935 2.178h-2.005c-.007-1.475.02-2.125 1.431-3.468.573-.544 1.025-.975.962-1.821-.058-.805-.73-1.226-1.365-1.226-.709 0-1.538.527-1.538 2.013h-2.01c0-2.4 1.409-3.95 3.59-3.95 1.036 0 1.942.339 2.55.955.57.578.865 1.372.854 2.298-.016 1.383-.857 2.291-1.534 3.021z" />
    </svg>
  ),
  helpBubble: (
    <svg
      xmlns="http://www.w3.org/2000/svg"
      width="100%"
      height="100%"
      className="pointer-events-none"
      viewBox="0 0 24 24">
      <path d="M12 1c-6.338 0-12 4.226-12 10.007 0 2.05.738 4.063 2.047 5.625.055 1.83-1.023 4.456-1.993 6.368 2.602-.47 6.301-1.508 7.978-2.536 9.236 2.247 15.968-3.405 15.968-9.457 0-5.812-5.701-10.007-12-10.007zm0 15c-.565 0-1.024-.459-1.024-1.025 0-.565.459-1.024 1.024-1.024.566 0 1.024.459 1.024 1.024 0 .566-.458 1.025-1.024 1.025zm1.606-4.858c-.74.799-.775 1.241-.766 1.785h-1.643c-.006-1.208.016-1.742 1.173-2.842.469-.446.84-.799.788-1.493-.047-.66-.599-1.004-1.117-1.004-.581 0-1.261.432-1.261 1.649h-1.646c0-1.966 1.155-3.237 2.941-3.237.849 0 1.592.278 2.09.783.468.473.709 1.125.7 1.883-.013 1.134-.704 1.878-1.259 2.476z" />
    </svg>
  ),
  info: (
    <svg
      xmlns="http://www.w3.org/2000/svg"
      width="100%"
      height="100%"
      className="pointer-events-none"
      viewBox="0 0 24 24">
      <path d="M12 2c5.514 0 10 4.486 10 10s-4.486 10-10 10-10-4.486-10-10 4.486-10 10-10zm0-2c-6.627 0-12 5.373-12 12s5.373 12 12 12 12-5.373 12-12-5.373-12-12-12zm-2.033 16.01c.564-1.789 1.632-3.932 1.821-4.474.273-.787-.211-1.136-1.74.209l-.34-.64c1.744-1.897 5.335-2.326 4.113.613-.763 1.835-1.309 3.074-1.621 4.03-.455 1.393.694.828 1.819-.211.153.25.203.331.356.619-2.498 2.378-5.271 2.588-4.408-.146zm4.742-8.169c-.532.453-1.32.443-1.761-.022-.441-.465-.367-1.208.164-1.661.532-.453 1.32-.442 1.761.022.439.466.367 1.209-.164 1.661z" />
    </svg>
  ),
  infoThin: (
    <svg
      xmlns="http://www.w3.org/2000/svg"
      width="100%"
      height="100%"
      className="pointer-events-none"
      fillRule="evenodd"
      clipRule="evenodd">
      <path d="M12 0c6.623 0 12 5.377 12 12s-5.377 12-12 12-12-5.377-12-12 5.377-12 12-12zm0 1c6.071 0 11 4.929 11 11s-4.929 11-11 11-11-4.929-11-11 4.929-11 11-11zm.5 17h-1v-9h1v9zm-.5-12c.466 0 .845.378.845.845 0 .466-.379.844-.845.844-.466 0-.845-.378-.845-.844 0-.467.379-.845.845-.845z" />
    </svg>
  ),
  lightbulb: (
    <svg
      xmlns="http://www.w3.org/2000/svg"
      width="100%"
      height="100%"
      className="pointer-events-none"
      viewBox="0 0 24 24">
      <path d="M6 3.083c0-.421.297-.801.734-.897 4.408-.97 4.575-.844 5.001-1.678.166-.322.497-.508.842-.508 1.443 0 1.128 2.504-1.117 3.032-.639.15-4.314.949-4.314.949-.586.129-1.146-.307-1.146-.898zm1.146 4.059l10.119-2.226c.439-.096.735-.476.735-.896 0-.587-.559-1.028-1.146-.898l-10.12 2.225c-.507.112-.825.604-.711 1.1s.617.807 1.123.695zm2.012 6.361v.497h-2.158v2.639c0 1.779 1.631 2.58 2 4.361h6c.375-1.753 2-2.585 2-4.361v-2.639h-2.157v-.958c0-.734.52-1.372 1.252-1.535l1.062-.291c.438-.096.734-.476.734-.896 0-.587-.559-1.028-1.146-.898l-1.259.344c-1.456.333-2.486 1.602-2.486 3.065v1.169h-2v-.689c0-1.627-.865-2.291-2.077-3.394l8.343-1.835c.438-.097.734-.476.734-.897 0-.59-.559-1.028-1.146-.898l-10.12 2.226c-.437.096-.734.476-.734.896 0 .292.131.494.344.707.843.843 2.814 1.68 2.814 3.387zm4.141 10.156c-.19.216-.465.341-.753.341h-1.093c-.288 0-.562-.125-.752-.341l-1.451-1.659h5.5l-1.451 1.659z" />
    </svg>
  ),
  linkedin: (
    <svg
      xmlns="http://www.w3.org/2000/svg"
      width="100%"
      height="100%"
      className="pointer-events-none"
      viewBox="0 0 24 24">
      <path d="M4.98 3.5c0 1.381-1.11 2.5-2.48 2.5s-2.48-1.119-2.48-2.5c0-1.38 1.11-2.5 2.48-2.5s2.48 1.12 2.48 2.5zm.02 4.5h-5v16h5v-16zm7.982 0h-4.968v16h4.969v-8.399c0-4.67 6.029-5.052 6.029 0v8.399h4.988v-10.131c0-7.88-8.922-7.593-11.018-3.714v-2.155z" />
    </svg>
  ),
  linkedin2: (
    <svg
      xmlns="http://www.w3.org/2000/svg"
      width="100%"
      height="100%"
      className="pointer-events-none"
      viewBox="0 0 24 24">
      <path d="M0 0v24h24v-24h-24zm8 19h-3v-11h3v11zm-1.5-12.268c-.966 0-1.75-.79-1.75-1.764s.784-1.764 1.75-1.764 1.75.79 1.75 1.764-.783 1.764-1.75 1.764zm13.5 12.268h-3v-5.604c0-3.368-4-3.113-4 0v5.604h-3v-11h3v1.765c1.397-2.586 7-2.777 7 2.476v6.759z" />
    </svg>
  ),
  linkThin: (
    <svg
      xmlns="http://www.w3.org/2000/svg"
      width="100%"
      height="100%"
      className="pointer-events-none"
      fillRule="evenodd"
      clipRule="evenodd">
      <path d="M14.851 11.923c-.179-.641-.521-1.246-1.025-1.749-1.562-1.562-4.095-1.563-5.657 0l-4.998 4.998c-1.562 1.563-1.563 4.095 0 5.657 1.562 1.563 4.096 1.561 5.656 0l3.842-3.841.333.009c.404 0 .802-.04 1.189-.117l-4.657 4.656c-.975.976-2.255 1.464-3.535 1.464-1.28 0-2.56-.488-3.535-1.464-1.952-1.951-1.952-5.12 0-7.071l4.998-4.998c.975-.976 2.256-1.464 3.536-1.464 1.279 0 2.56.488 3.535 1.464.493.493.861 1.063 1.105 1.672l-.787.784zm-5.703.147c.178.643.521 1.25 1.026 1.756 1.562 1.563 4.096 1.561 5.656 0l4.999-4.998c1.563-1.562 1.563-4.095 0-5.657-1.562-1.562-4.095-1.563-5.657 0l-3.841 3.841-.333-.009c-.404 0-.802.04-1.189.117l4.656-4.656c.975-.976 2.256-1.464 3.536-1.464 1.279 0 2.56.488 3.535 1.464 1.951 1.951 1.951 5.119 0 7.071l-4.999 4.998c-.975.976-2.255 1.464-3.535 1.464-1.28 0-2.56-.488-3.535-1.464-.494-.495-.863-1.067-1.107-1.678l.788-.785z" />
    </svg>
  ),
  loading: (
    <svg
      xmlns="http://www.w3.org/2000/svg"
      width="100%"
      height="100%"
      className="pointer-events-none"
      viewBox="0 0 24 24">
      <path d="M8.175 7.377l-3.042-5.27 1.732-1 3.045 5.273c-.635.238-1.222.573-1.735.997zm-.799.8l-5.27-3.042-1 1.732 5.274 3.045c.237-.635.572-1.223.996-1.735zm-1.376 3.823c0-.341.035-.673.09-.999h-6.09v1.999h6.09c-.055-.326-.09-.659-.09-1zm11.351-2.705l5.208-3.007-.333-.577-5.206 3.007c.121.185.23.379.331.577zm-5.351-3.295c.341 0 .673.035.999.09v-6.09h-1.999v6.09c.326-.055.659-.09 1-.09zm3.14.894l3.004-5.204-.288-.166-3 5.197.284.173zm1.685 8.662l5.234 3.022.666-1.154-5.229-3.019c-.181.41-.408.794-.671 1.151zm-10.444-1.467l-5.274 3.046 1 1.732 5.27-3.042c-.424-.513-.759-1.1-.996-1.736zm11.594-2.589l.025.5-.025.5h6.025v-1h-6.025zm-3.727 6.061l3.03 5.249 1.442-.833-3.031-5.25c-.437.34-.92.623-1.441.834zm-2.248.439c-.341 0-.674-.035-1-.09v6.09h1.999v-6.09c-.326.055-.658.09-.999.09zm-3.824-1.376l-3.042 5.27 1.732 1 3.045-5.274c-.635-.237-1.222-.572-1.735-.996z" />
    </svg>
  ),
  magnifierPlus: (
    <svg
      xmlns="http://www.w3.org/2000/svg"
      width="100%"
      height="100%"
      className="pointer-events-none"
      fillRule="evenodd"
      clipRule="evenodd"
      strokeLinejoin="round"
      strokeMiterlimit="2"
      viewBox="0 0 24 24">
      <path
        d="m15.97 17.031c-1.479 1.238-3.384 1.985-5.461 1.985-4.697 0-8.509-3.812-8.509-8.508s3.812-8.508 8.509-8.508c4.695 0 8.508 3.812 8.508 8.508 0 2.078-.747 3.984-1.985 5.461l4.749 4.75c.146.146.219.338.219.531 0 .587-.537.75-.75.75-.192 0-.384-.073-.531-.22zm-5.461-13.53c-3.868 0-7.007 3.14-7.007 7.007s3.139 7.007 7.007 7.007c3.866 0 7.007-3.14 7.007-7.007s-3.141-7.007-7.007-7.007zm-.744 6.26h-2.5c-.414 0-.75.336-.75.75s.336.75.75.75h2.5v2.5c0 .414.336.75.75.75s.75-.336.75-.75v-2.5h2.5c.414 0 .75-.336.75-.75s-.336-.75-.75-.75h-2.5v-2.5c0-.414-.336-.75-.75-.75s-.75.336-.75.75z"
        fillRule="nonzero"
      />
    </svg>
  ),
  menuLined: (
    <svg
      xmlns="http://www.w3.org/2000/svg"
      width="100%"
      height="100%"
      className="pointer-events-none"
      fillRule="evenodd"
      clipRule="evenodd"
      strokeLinejoin="round"
      strokeMiterlimit="2"
      viewBox="0 0 24 24">
      <path
        d="m22 16.75c0-.414-.336-.75-.75-.75h-18.5c-.414 0-.75.336-.75.75s.336.75.75.75h18.5c.414 0 .75-.336.75-.75zm0-5c0-.414-.336-.75-.75-.75h-18.5c-.414 0-.75.336-.75.75s.336.75.75.75h18.5c.414 0 .75-.336.75-.75zm0-5c0-.414-.336-.75-.75-.75h-18.5c-.414 0-.75.336-.75.75s.336.75.75.75h18.5c.414 0 .75-.336.75-.75z"
        fillRule="nonzero"
      />
    </svg>
  ),
  menuListThin: (
    <svg
      xmlns="http://www.w3.org/2000/svg"
      width="100%"
      height="100%"
      className="pointer-events-none"
      fillRule="evenodd"
      clipRule="evenodd">
      <path d="M14 19h-14v-1h14v1zm9.247-8.609l-3.247 4.049-3.263-4.062-.737.622 4 5 4-5-.753-.609zm-9.247 2.609h-14v-1h14v1zm0-6h-14v-1h14v1z" />
    </svg>
  ),
  menuThin: (
    <svg
      xmlns="http://www.w3.org/2000/svg"
      width="100%"
      height="100%"
      className="pointer-events-none"
      fillRule="evenodd"
      clipRule="evenodd">
      <path
        d="M24 18v1h-24v-1h24zm0-6v1h-24v-1h24zm0-6v1h-24v-1h24z"
        fill="#1040e2"
      />
      <path d="M24 19h-24v-1h24v1zm0-6h-24v-1h24v1zm0-6h-24v-1h24v1z" />
    </svg>
  ),
  minusThin: (
    <svg
      xmlns="http://www.w3.org/2000/svg"
      width="100%"
      height="100%"
      className="pointer-events-none"
      fillRule="evenodd"
      clipRule="evenodd">
      <path d="M0 12v1h23v-1h-23z" />
    </svg>
  ),
  pen: (
    <svg
      xmlns="http://www.w3.org/2000/svg"
      width="100%"
      height="100%"
      className="pointer-events-none"
      fillRule="evenodd"
      clipRule="evenodd"
      viewBox="0 0 24 24">
      <path d="M13.473 7.196c-.425-.439-.401-1.127.035-1.552l4.461-4.326c.218-.211.498-.318.775-.318.282 0 .563.11.776.331l-6.047 5.865zm-7.334 11.021c-.092.089-.139.208-.139.327 0 .25.203.456.455.456.115 0 .229-.042.318-.128l.748-.729-.633-.654-.749.728zm8.212-6.482l-2.57 2.481c-.824.799-1.607 1.328-2.705 1.79.496-1.084 1.05-1.852 1.873-2.65l2.569-2.479-1.049-1.083-2.564 2.485c-1.378 1.336-2.08 2.63-2.73 4.437l1.133 1.169c1.824-.593 3.14-1.255 4.518-2.591l2.563-2.486-1.038-1.073zm7.878-7.243l-5.527 5.359-1.239-1.279 5.529-5.361c.824-.803 2.087.456 1.237 1.281zm-.643-3.036c-.572 0-1.156.209-1.64.678l-6.604 6.405 3.326 3.434 6.604-6.403c.485-.47.728-1.094.728-1.719 0-1.426-1.181-2.395-2.414-2.395zm-3.586 12.01v7.534h-16v-12h8.013l2.058-2h-12.071v16h20v-11.473l-2 1.939z" />
    </svg>
  ),
  penStriked: (
    <svg
      xmlns="http://www.w3.org/2000/svg"
      width="100%"
      height="100%"
      className="pointer-events-none"
      viewBox="0 0 24 24">
      <path d="M16.598 13.091l-5.69-5.688 7.402-7.403 5.69 5.689-7.402 7.402zm-16.598 10.909l7.126-1.436-5.688-5.689-1.438 7.125zm1.984-20.568l6.449 6.446-5.582 5.582 5.689 5.69 5.583-5.583 6.492 6.49 1.4-1.428-18.631-18.625-1.4 1.428z" />
    </svg>
  ),
  photocamera: (
    <svg
      xmlns="http://www.w3.org/2000/svg"
      width="100%"
      height="100%"
      className="pointer-events-none"
      viewBox="0 0 24 24">
      <path d="M5 4h-3v-1h3v1zm12 9c0 2.206-1.794 4-4 4s-4-1.794-4-4 1.794-4 4-4 4 1.794 4 4zm-1 0c0-1.657-1.342-3-3-3s-3 1.343-3 3 1.342 3 3 3 3-1.343 3-3zm8-8v17h-24v-17h5.93c.669 0 1.293-.334 1.664-.891l1.406-2.109h8l1.406 2.109c.371.557.995.891 1.664.891h3.93zm-19 4c0-.552-.447-1-1-1s-1 .448-1 1 .447 1 1 1 1-.448 1-1zm14 4c0-3.314-2.687-6-6-6s-6 2.686-6 6 2.687 6 6 6 6-2.686 6-6z" />
    </svg>
  ),
  product: (
    <svg
      xmlns="http://www.w3.org/2000/svg"
      width="100%"
      height="100%"
      className="pointer-events-none"
      fillRule="evenodd"
      clipRule="evenodd">
      <path d="M5.25 17.322l-2.25-1.221 2.234-3.067-2.234-1.96 4.713-2.562c.204.231.41.504.604.807l-3.584 1.948 1.181 1.037 3.058-1.686c.119.314.216.641.282.977l-3.261 1.801 6.018 3.109 5.989-3.105-3.152-1.745c.061-.347.144-.667.248-.968l2.933 1.615 1.234-1.095-3.5-1.855c.183-.275.388-.54.614-.803l4.623 2.449-2.261 2.008.011.006 2.25 3.081-2.25 1.224v3.087l-6.75 3.596-6.75-3.596v-3.082zm7.246-.094v5.377l5.255-2.799v-1.946l-3.501 1.905-1.754-2.537zm-6.247.636v1.942l5.248 2.796v-5.373l-1.747 2.536-3.501-1.901zm-1.772-2.096l4.96 2.692 1.099-1.594-4.983-2.575-1.076 1.477zm8.988 1.107l1.096 1.585 4.961-2.698-1.073-1.471-4.984 2.584zm-1.192-2.915h-.521c-.136 0-.268-.046-.358-.127l-.692-.455h2.621l-.692.455c-.089.081-.221.127-.358.127zm1.075-1.164h-2.655c-.161 0-.291-.129-.291-.29 0-.161.13-.291.291-.291h2.655c.161 0 .291.13.291.291 0 .161-.13.29-.291.29zm.287-1.163h-3.245c0-2.297-1.872-3.291-1.872-5.367 0-2.166 1.746-3.358 3.493-3.358 1.748 0 3.497 1.194 3.497 3.358 0 2.076-1.872 3.038-1.873 5.367zm-.901-.997c.188-.954.624-1.689 1.018-2.356.424-.714.757-1.279.757-2.014 0-1.55-1.257-2.361-2.498-2.361-1.239 0-2.495.811-2.495 2.361 0 .739.337 1.312.763 2.035.392.664.822 1.396 1.012 2.335h1.443zm-5.357-4.321h-1.772v-.997h1.818c-.039.219-.059.445-.059.674l.013.323zm11.043 0h-1.761l.014-.323c0-.229-.02-.455-.06-.674h1.807v.997zm-9.983-3.011c-.227.247-.424.518-.584.809l-1.439-1.021.578-.813 1.445 1.025zm7.159-.005l1.437-1.02.578.813-1.43 1.015c-.161-.29-.358-.561-.585-.808zm-5.3-1.22c-.318.115-.619.261-.899.433l-.772-1.575.897-.438.774 1.58zm3.435-.004l.773-1.576.896.438-.769 1.57c-.28-.172-.581-.318-.9-.432zm-1.219-.271c-.162-.016-.327-.024-.494-.024-.17 0-.339.009-.505.025v-1.805h.999v1.804z" />
    </svg>
  ),
  quote: (
    <svg
      xmlns="http://www.w3.org/2000/svg"
      width="100%"
      height="100%"
      className="pointer-events-none"
      viewBox="0 0 24 24">
      <path d="M11 9.275c0 5.141-3.892 10.519-10 11.725l-.984-2.126c2.215-.835 4.163-3.742 4.38-5.746-2.491-.392-4.396-2.547-4.396-5.149 0-3.182 2.584-4.979 5.199-4.979 3.015 0 5.801 2.305 5.801 6.275zm13 0c0 5.141-3.892 10.519-10 11.725l-.984-2.126c2.215-.835 4.163-3.742 4.38-5.746-2.491-.392-4.396-2.547-4.396-5.149 0-3.182 2.584-4.979 5.199-4.979 3.015 0 5.801 2.305 5.801 6.275z" />
    </svg>
  ),
  recycling: (
    <svg
      xmlns="http://www.w3.org/2000/svg"
      width="100%"
      height="100%"
      className="pointer-events-none"
      viewBox="0 0 24 24">
      <path d="M23.322 19.318l-4.072 1.192-1.193-4.072 1.763.964c.737-1.305 1.18-2.798 1.18-4.402 0-3.681-2.224-6.849-5.396-8.242l.623-1.914c3.975 1.657 6.772 5.579 6.772 10.156 0 1.953-.521 3.779-1.416 5.367l1.739.951zm-11.323 2.682c-3.332 0-6.24-1.825-7.796-4.523l1.769-1.026-4.102-1.089-1.089 4.1 1.694-.982c1.899 3.295 5.447 5.52 9.524 5.52 2.202 0 4.248-.654 5.969-1.768l-1.24-1.588c-1.376.854-2.994 1.356-4.729 1.356zm-8.994-8.876l-.006-.124c0-4.625 3.51-8.433 8.004-8.932l-.004 1.932 3.005-2.996-2.995-3.004-.003 2.05c-5.61.503-10.007 5.21-10.007 10.95l.021.402 1.985-.278zm6.126-.564c-.251.862-.146 1.768.415 2.571.904-1.333 2.588-2.767 3.76-3.039-2.395 1.731-3.735 4.16-3.909 6.908h1.011c-.023-1.038.125-2.345.497-2.934.911.302 1.924.125 2.797-.613 1.724-1.463 1.077-5.14 4.112-5.564-4.07-2.224-7.943.124-8.683 2.671z" />
    </svg>
  ),
  rocket: (
    <svg
      xmlns="http://www.w3.org/2000/svg"
      width="100%"
      height="100%"
      className="pointer-events-none"
      viewBox="0 0 24 24">
      <path d="M19.957 4.035c-.345-.024-.682-.035-1.012-.035-7.167 0-11.248 5.464-12.732 9.861l3.939 3.938c4.524-1.619 9.848-5.549 9.848-12.639 0-.367-.014-.741-.043-1.125zm-9.398 11.815l-2.402-2.402c1.018-2.383 3.91-7.455 10.166-7.767-.21 4.812-3.368 8.276-7.764 10.169zm4.559 1.282c-.456.311-.908.592-1.356.842-.156.742-.552 1.535-1.126 2.21-.001-.48-.135-.964-.369-1.449-.413.187-.805.348-1.179.49.551 1.424-.01 2.476-.763 3.462 1.08-.081 2.214-.61 3.106-1.504.965-.962 1.64-2.352 1.687-4.051zm-9.849-5.392c-.482-.232-.965-.364-1.443-.367.669-.567 1.453-.961 2.188-1.121.262-.461.556-.915.865-1.361-1.699.046-3.09.723-4.054 1.686-.893.893-1.421 2.027-1.503 3.106.986-.753 2.039-1.313 3.463-.762.145-.391.305-.785.484-1.181zm6.448.553c-.326-.325-.326-.853 0-1.178.325-.326.853-.326 1.178 0 .326.326.326.854 0 1.179-.326.325-.853.325-1.178-.001zm4.124-4.125c-.65-.65-1.706-.65-2.356 0-.651.651-.651 1.707 0 2.357.65.651 1.706.651 2.357 0 .65-.65.65-1.706-.001-2.357zm-1.591 1.592c-.228-.228-.228-.598 0-.825.227-.228.598-.228.826 0 .227.227.226.597 0 .825-.228.227-.598.227-.826 0zm-12.609 10.555l-.755-.755 4.341-4.323.755.755-4.341 4.323zm4.148 1.547l-.755-.755 3.03-3.054.756.755-3.031 3.054zm-5.034 2.138l-.755-.755 5.373-5.364.756.755-5.374 5.364zm21.083-14.291c-.188.618-.673 1.102-1.291 1.291.618.188 1.103.672 1.291 1.291.189-.619.673-1.103 1.291-1.291-.618-.188-1.102-.672-1.291-1.291zm-14.655-6.504c-.247.81-.881 1.443-1.69 1.69.81.247 1.443.881 1.69 1.69.248-.809.881-1.443 1.69-1.69-.81-.247-1.442-.88-1.69-1.69zm-1.827-3.205c-.199.649-.706 1.157-1.356 1.355.65.199 1.157.707 1.356 1.355.198-.649.706-1.157 1.354-1.355-.648-.198-1.155-.706-1.354-1.355zm5.387 0c-.316 1.035-1.127 1.846-2.163 2.163 1.036.316 1.847 1.126 2.163 2.163.316-1.036 1.127-1.846 2.162-2.163-1.035-.317-1.845-1.128-2.162-2.163zm11.095 13.64c-.316 1.036-1.127 1.846-2.163 2.163 1.036.316 1.847 1.162 2.163 2.197.316-1.036 1.127-1.881 2.162-2.197-1.035-.317-1.846-1.127-2.162-2.163z" />
    </svg>
  ),
  ruler: (
    <svg
      xmlns="http://www.w3.org/2000/svg"
      width="100%"
      height="100%"
      className="pointer-events-none"
      viewBox="0 0 24 24">
      <path d="M5.641 22.569l-5.641 1.431 1.397-5.674 4.244 4.243zm-2.829-5.657l4.243 4.243 16.945-16.913-4.242-4.242-16.946 16.912zm14.114-2.783l-1.414 1.414.708.708 1.414-1.414 1.414 1.414-2.122 2.122.707.707 2.122-2.122 1.417 1.385-2.829 2.829-4.232-4.233-1.415 1.413 5.648 5.648 5.656-5.657-5.643-5.643-1.431 1.429zm-9.887-4.261l-4.21-4.21 2.828-2.829 1.369 1.401-2.121 2.121.707.707 2.121-2.122 1.414 1.415-1.414 1.414.707.707 1.414-1.414 1.432-1.429-5.629-5.629-5.657 5.657 5.623 5.624 1.416-1.413z" />
    </svg>
  ),
  selection: (
    <svg
      xmlns="http://www.w3.org/2000/svg"
      width="100%"
      height="100%"
      className="pointer-events-none"
      viewBox="0 0 24 24">
      <path d="M11 24v-2h-4v2h4zm8-22h3v3h2v-5h-5v2zm-19 15h2v-4h-2v4zm0-6h2v-4h-2v4zm2-6v-3h3v-2h-5v5h2zm22 2h-2v4h2v-4zm0 6h-2v4h2v-4zm-2 6v3h-3v2h5v-5h-2zm-17 3h-3v-3h-2v5h5v-2zm12 2v-2h-4v2h4zm-6-22v-2h-4v2h4zm6 0v-2h-4v2h4zm0 9v6h-6v-6h6zm2-2h-10v10h10v-10zm-2-2v1h-9v9h-1v-10h10zm-2-2v1h-9v9h-1v-10h10z" />
    </svg>
  ),
  smartphone: (
    <svg
      xmlns="http://www.w3.org/2000/svg"
      width="100%"
      height="100%"
      className="pointer-events-none"
      viewBox="0 0 24 24">
      <path d="M6.02 7.389c.399-.285.85-.417 1.292-.417.944 0 1.852.6 2.15 1.599-.382-.294-.83-.437-1.281-.437-.458 0-.919.147-1.321.434-.799.57-1.153 1.541-.845 2.461-1.242-.89-1.247-2.747.005-3.64zm3.741 12.77c.994.334 4.071 1.186 7.635 3.841l6.604-4.71c-1.713-2.402-1.241-4.082-2.943-6.468-1.162-1.628-1.827-1.654-3.037-1.432l.599.84c.361.507-.405 1.05-.764.544l-.534-.75c-.435-.609-1.279-.229-2.053-.051l.727 1.019c.36.505-.403 1.051-.764.544l-.629-.882c-.446-.626-1.318-.208-2.095-.01l.769 1.078c.363.508-.405 1.049-.764.544l-3.118-4.366c-.968-1.358-3.088.083-2.086 1.489l4.605 6.458c-.494-.183-1.363-.349-1.93-.349-1.754 0-2.429 1.92-.222 2.661zm-3.286-2.159h-4.475v-14h10v6.688l2-.471v-8.217c0-1.104-.895-2-2-2h-10c-1.105 0-2 .896-2 2v18.678c-.001 2.213 3.503 3.322 7.005 3.322 1.812 0 3.619-.299 4.944-.894-2.121-.946-6.378-1.576-5.474-5.106z" />
    </svg>
  ),
  speechBubble: (
    <svg
      xmlns="http://www.w3.org/2000/svg"
      width="100%"
      height="100%"
      className="pointer-events-none"
      viewBox="0 0 24 24">
      <path d="M2.001 9.352c0 1.873.849 2.943 1.683 3.943.031 1 .085 1.668-.333 3.183 1.748-.558 2.038-.778 3.008-1.374 1 .244 1.474.381 2.611.491-.094.708-.081 1.275.055 2.023-.752-.06-1.528-.178-2.33-.374-1.397.857-4.481 1.725-6.649 2.115.811-1.595 1.708-3.785 1.661-5.312-1.09-1.305-1.705-2.984-1.705-4.695-.001-4.826 4.718-8.352 9.999-8.352 5.237 0 9.977 3.484 9.998 8.318-.644-.175-1.322-.277-2.021-.314-.229-3.34-3.713-6.004-7.977-6.004-4.411 0-8 2.85-8 6.352zm20.883 10.169c-.029 1.001.558 2.435 1.088 3.479-1.419-.258-3.438-.824-4.352-1.385-.772.188-1.514.274-2.213.274-3.865 0-6.498-2.643-6.498-5.442 0-3.174 3.11-5.467 6.546-5.467 3.457 0 6.546 2.309 6.546 5.467 0 1.12-.403 2.221-1.117 3.074zm-7.563-3.021c0-.453-.368-.82-.82-.82s-.82.367-.82.82.368.82.82.82.82-.367.82-.82zm3 0c0-.453-.368-.82-.82-.82s-.82.367-.82.82.368.82.82.82.82-.367.82-.82zm3 0c0-.453-.368-.82-.82-.82s-.82.367-.82.82.368.82.82.82.82-.367.82-.82z" />
    </svg>
  ),
  squareLined: (
    <svg
      xmlns="http://www.w3.org/2000/svg"
      width="100%"
      height="100%"
      className="pointer-events-none"
      clipRule="evenodd"
      fillRule="evenodd"
      strokeLinejoin="round"
      strokeMiterlimit="2"
      viewBox="0 0 24 24">
      <path
        d="m21 4c0-.478-.379-1-1-1h-16c-.62 0-1 .519-1 1v16c0 .621.52 1 1 1h16c.478 0 1-.379 1-1zm-16.5.5h15v15h-15z"
        fillRule="nonzero"
      />
    </svg>
  ),
  syncronization: (
    <svg
      xmlns="http://www.w3.org/2000/svg"
      width="100%"
      height="100%"
      className="pointer-events-none"
      viewBox="0 0 24 24">
      <path d="M23 12c0 1.042-.154 2.045-.425 3h-2.101c.335-.94.526-1.947.526-3 0-4.962-4.037-9-9-9-1.706 0-3.296.484-4.654 1.314l1.857 2.686h-6.994l2.152-7 1.85 2.673c1.683-1.049 3.658-1.673 5.789-1.673 6.074 0 11 4.925 11 11zm-6.354 7.692c-1.357.826-2.944 1.308-4.646 1.308-4.963 0-9-4.038-9-9 0-1.053.191-2.06.525-3h-2.1c-.271.955-.425 1.958-.425 3 0 6.075 4.925 11 11 11 2.127 0 4.099-.621 5.78-1.667l1.853 2.667 2.152-6.989h-6.994l1.855 2.681zm-3.646-7.692v-6h-2v8h7v-2h-5z" />
    </svg>
  ),
  text: (
    <svg
      xmlns="http://www.w3.org/2000/svg"
      width="100%"
      height="100%"
      className="pointer-events-none"
      viewBox="0 0 24 24">
      <path d="M24 20v1h-4v-1h.835c.258 0 .405-.178.321-.422l-.473-1.371h-2.231l-.575-1.59h2.295l-1.362-4.077-1.154 3.451-.879-2.498.921-2.493h2.222l3.033 8.516c.111.315.244.484.578.484h.469zm-6-1h1v2h-7v-2h.532c.459 0 .782-.453.633-.887l-.816-2.113h-6.232l-.815 2.113c-.149.434.174.887.633.887h1.065v2h-7v-2h.43c.593 0 1.123-.375 1.32-.935l5.507-15.065h3.952l5.507 15.065c.197.56.69.935 1.284.935zm-10.886-6h4.238l-2.259-6.199-1.979 6.199z" />
    </svg>
  ),
  time: (
    <svg
      xmlns="http://www.w3.org/2000/svg"
      width="100%"
      height="100%"
      className="pointer-events-none"
      viewBox="0 0 24 24">
      <path d="M15.91 13.34l2.636-4.026-.454-.406-3.673 3.099c-.675-.138-1.402.068-1.894.618-.736.823-.665 2.088.159 2.824.824.736 2.088.665 2.824-.159.492-.55.615-1.295.402-1.95zm-3.91-10.646v-2.694h4v2.694c-1.439-.243-2.592-.238-4 0zm8.851 2.064l1.407-1.407 1.414 1.414-1.321 1.321c-.462-.484-.964-.927-1.5-1.328zm-18.851 4.242h8v2h-8v-2zm-2 4h8v2h-8v-2zm3 4h7v2h-7v-2zm21-3c0 5.523-4.477 10-10 10-2.79 0-5.3-1.155-7.111-3h3.28c1.138.631 2.439 1 3.831 1 4.411 0 8-3.589 8-8s-3.589-8-8-8c-1.392 0-2.693.369-3.831 1h-3.28c1.811-1.845 4.321-3 7.111-3 5.523 0 10 4.477 10 10z" />
    </svg>
  ),
  userRounded: (
    <svg
      xmlns="http://www.w3.org/2000/svg"
      width="100%"
      height="100%"
      className="pointer-events-none"
      viewBox="0 0 24 24">
      <path d="M12 0c-6.627 0-12 5.373-12 12s5.373 12 12 12 12-5.373 12-12-5.373-12-12-12zm7.753 18.305c-.261-.586-.789-.991-1.871-1.241-2.293-.529-4.428-.993-3.393-2.945 3.145-5.942.833-9.119-2.489-9.119-3.388 0-5.644 3.299-2.489 9.119 1.066 1.964-1.148 2.427-3.393 2.945-1.084.25-1.608.658-1.867 1.246-1.405-1.723-2.251-3.919-2.251-6.31 0-5.514 4.486-10 10-10s10 4.486 10 10c0 2.389-.845 4.583-2.247 6.305z" />
    </svg>
  ),
  userRoundedThin: (
    <svg
      xmlns="http://www.w3.org/2000/svg"
      width="100%"
      height="100%"
      className="pointer-events-none"
      clipRule="evenodd"
      fillRule="evenodd">
      <path d="M12 0c6.623 0 12 5.377 12 12s-5.377 12-12 12-12-5.377-12-12 5.377-12 12-12zm8.127 19.41c-.282-.401-.772-.654-1.624-.85-3.848-.906-4.097-1.501-4.352-2.059-.259-.565-.19-1.23.205-1.977 1.726-3.257 2.09-6.024 1.027-7.79-.674-1.119-1.875-1.734-3.383-1.734-1.521 0-2.732.626-3.409 1.763-1.066 1.789-.693 4.544 1.049 7.757.402.742.476 1.406.22 1.974-.265.586-.611 1.19-4.365 2.066-.852.196-1.342.449-1.623.848 2.012 2.207 4.91 3.592 8.128 3.592s6.115-1.385 8.127-3.59zm.65-.782c1.395-1.844 2.223-4.14 2.223-6.628 0-6.071-4.929-11-11-11s-11 4.929-11 11c0 2.487.827 4.783 2.222 6.626.409-.452 1.049-.81 2.049-1.041 2.025-.462 3.376-.836 3.678-1.502.122-.272.061-.628-.188-1.087-1.917-3.535-2.282-6.641-1.03-8.745.853-1.431 2.408-2.251 4.269-2.251 1.845 0 3.391.808 4.24 2.218 1.251 2.079.896 5.195-1 8.774-.245.463-.304.821-.179 1.094.305.668 1.644 1.038 3.667 1.499 1 .23 1.64.59 2.049 1.043z" />
    </svg>
  ),
  users: (
    <svg
      xmlns="http://www.w3.org/2000/svg"
      width="100%"
      height="100%"
      className="pointer-events-none"
      viewBox="0 0 24 24">
      <path d="M10.644 17.08c2.866-.662 4.539-1.241 3.246-3.682-3.932-7.427-1.042-11.398 3.111-11.398 4.235 0 7.054 4.124 3.11 11.398-1.332 2.455.437 3.034 3.242 3.682 2.483.574 2.647 1.787 2.647 3.889v1.031h-18c0-2.745-.22-4.258 2.644-4.92zm-12.644 4.92h7.809c-.035-8.177 3.436-5.313 3.436-11.127 0-2.511-1.639-3.873-3.748-3.873-3.115 0-5.282 2.979-2.333 8.549.969 1.83-1.031 2.265-3.181 2.761-1.862.43-1.983 1.34-1.983 2.917v.773z" />
    </svg>
  ),
  videocamera: (
    <svg
      xmlns="http://www.w3.org/2000/svg"
      width="100%"
      height="100%"
      className="pointer-events-none"
      viewBox="0 0 24 24">
      <path d="M16 18c0 1.104-.896 2-2 2h-12c-1.105 0-2-.896-2-2v-12c0-1.104.895-2 2-2h12c1.104 0 2 .896 2 2v12zm8-14l-6 6.223v3.554l6 6.223v-16z" />
    </svg>
  ),
  sun: (
    <svg
      xmlns="http://www.w3.org/2000/svg"
      width="100%"
      height="100%"
      className="pointer-events-none"
      viewBox="0 0 24 24">
      <path d="M4.069 13h-4.069v-2h4.069c-.041.328-.069.661-.069 1s.028.672.069 1zm3.034-7.312l-2.881-2.881-1.414 1.414 2.881 2.881c.411-.529.885-1.003 1.414-1.414zm11.209 1.414l2.881-2.881-1.414-1.414-2.881 2.881c.528.411 1.002.886 1.414 1.414zm-6.312-3.102c.339 0 .672.028 1 .069v-4.069h-2v4.069c.328-.041.661-.069 1-.069zm0 16c-.339 0-.672-.028-1-.069v4.069h2v-4.069c-.328.041-.661.069-1 .069zm7.931-9c.041.328.069.661.069 1s-.028.672-.069 1h4.069v-2h-4.069zm-3.033 7.312l2.88 2.88 1.415-1.414-2.88-2.88c-.412.528-.886 1.002-1.415 1.414zm-11.21-1.415l-2.88 2.88 1.414 1.414 2.88-2.88c-.528-.411-1.003-.885-1.414-1.414zm2.312-4.897c0 2.206 1.794 4 4 4s4-1.794 4-4-1.794-4-4-4-4 1.794-4 4zm10 0c0 3.314-2.686 6-6 6s-6-2.686-6-6 2.686-6 6-6 6 2.686 6 6z" />
    </svg>
  ),
  lightanddark: (
    <svg
      xmlns="http://www.w3.org/2000/svg"
      width="100%"
      height="100%"
      className="pointer-events-none"
      viewBox="0 0 24 24">
      <path d="M0 12c0 6.627 5.373 12 12 12s12-5.373 12-12-5.373-12-12-12-12 5.373-12 12zm2 0c0-5.514 4.486-10 10-10v20c-5.514 0-10-4.486-10-10z" />
    </svg>
  ),
  moonWithStars: (
    <svg
      xmlns="http://www.w3.org/2000/svg"
      width="100%"
      height="100%"
      className="pointer-events-none"
      viewBox="0 0 24 24">
      <path d="M12 10.999c1.437.438 2.562 1.564 2.999 3.001.44-1.437 1.565-2.562 3.001-3-1.436-.439-2.561-1.563-3.001-3-.437 1.436-1.562 2.561-2.999 2.999zm8.001.001c.958.293 1.707 1.042 2 2.001.291-.959 1.042-1.709 1.999-2.001-.957-.292-1.707-1.042-2-2-.293.958-1.042 1.708-1.999 2zm-1-9c-.437 1.437-1.563 2.562-2.998 3.001 1.438.44 2.561 1.564 3.001 3.002.437-1.438 1.563-2.563 2.996-3.002-1.433-.437-2.559-1.564-2.999-3.001zm-7.001 22c-6.617 0-12-5.383-12-12s5.383-12 12-12c1.894 0 3.63.497 5.37 1.179-2.948.504-9.37 3.266-9.37 10.821 0 7.454 5.917 10.208 9.37 10.821-1.5.846-3.476 1.179-5.37 1.179z" />
    </svg>
  ),
  zoomInThin: (
    <svg
      xmlns="http://www.w3.org/2000/svg"
      width="100%"
      height="100%"
      className="pointer-events-none"
      clipRule="evenodd"
      fillRule="evenodd">
      <path d="M15.853 16.56c-1.683 1.517-3.911 2.44-6.353 2.44-5.243 0-9.5-4.257-9.5-9.5s4.257-9.5 9.5-9.5 9.5 4.257 9.5 9.5c0 2.442-.923 4.67-2.44 6.353l7.44 7.44-.707.707-7.44-7.44zm-6.353-15.56c4.691 0 8.5 3.809 8.5 8.5s-3.809 8.5-8.5 8.5-8.5-3.809-8.5-8.5 3.809-8.5 8.5-8.5zm-4.5 8h4v-4h1v4h4v1h-4v4h-1v-4h-4v-1z" />
    </svg>
  ),
  zoomOutThin: (
    <svg
      xmlns="http://www.w3.org/2000/svg"
      width="100%"
      height="100%"
      className="pointer-events-none"
      clipRule="evenodd"
      fillRule="evenodd">
      <path d="M15.853 16.56c-1.683 1.517-3.911 2.44-6.353 2.44-5.243 0-9.5-4.257-9.5-9.5s4.257-9.5 9.5-9.5 9.5 4.257 9.5 9.5c0 2.442-.923 4.67-2.44 6.353l7.44 7.44-.707.707-7.44-7.44zm-6.353-15.56c4.691 0 8.5 3.809 8.5 8.5s-3.809 8.5-8.5 8.5-8.5-3.809-8.5-8.5 3.809-8.5 8.5-8.5zm-4.5 8h9v1h-9v-1z" />
    </svg>
  ),
  publish: (
    <svg
      xmlns="http://www.w3.org/2000/svg"
      width="100%"
      height="100%"
      className="pointer-events-none"
      viewBox="0 0 24 24">
      <path d="M14.666 8.334v3.666l1.463-2.215-1.463-1.451zm-3.092 4.167c.66-.384 1.242-.864 1.758-1.447v1.369c-.445.393-.926.731-1.449 1.018l-.309-.94zm-3.255 2.041c-.652.083-1.57.125-2.319.125v-.97c.688 0 1.551-.037 2.152-.113l.167.958zm2.789-.725l-.036.015c-.586.246-1.22.437-1.91.573l-.167-.958c.655-.131 1.257-.315 1.809-.556l.304.926zm10.892-13.817l-3 11-4.064-3.62 3.9-4.117-5.229 3.614-3.607-.877 12-6zm-3.015 14.779c0 4.546-5.777 9.221-8.221 9.221h-8.764v-22h11.527l-4 2h-5.527v18h5.938c4.155 0 2.638-6 2.638-6 3.349.921 6.003.403 6.003-3.21.28.65.406 1.318.406 1.989z" />
    </svg>
  ),
  settings: (
    <svg
      xmlns="http://www.w3.org/2000/svg"
      width="100%"
      height="100%"
      className="pointer-events-none"
      viewBox="0 0 24 24">
      <path d="M24 13.616v-3.232c-1.651-.587-2.694-.752-3.219-2.019v-.001c-.527-1.271.1-2.134.847-3.707l-2.285-2.285c-1.561.742-2.433 1.375-3.707.847h-.001c-1.269-.526-1.435-1.576-2.019-3.219h-3.232c-.582 1.635-.749 2.692-2.019 3.219h-.001c-1.271.528-2.132-.098-3.707-.847l-2.285 2.285c.745 1.568 1.375 2.434.847 3.707-.527 1.271-1.584 1.438-3.219 2.02v3.232c1.632.58 2.692.749 3.219 2.019.53 1.282-.114 2.166-.847 3.707l2.285 2.286c1.562-.743 2.434-1.375 3.707-.847h.001c1.27.526 1.436 1.579 2.019 3.219h3.232c.582-1.636.75-2.69 2.027-3.222h.001c1.262-.524 2.12.101 3.698.851l2.285-2.286c-.744-1.563-1.375-2.433-.848-3.706.527-1.271 1.588-1.44 3.221-2.021zm-12 2.384c-2.209 0-4-1.791-4-4s1.791-4 4-4 4 1.791 4 4-1.791 4-4 4z" />
    </svg>
  ),
  accelerate: (
    <svg
      xmlns="http://www.w3.org/2000/svg"
      width="100%"
      height="100%"
      className="pointer-events-none"
      viewBox="0 0 1024 1024">
      <path
        d="M512 301.2m-10 0a10 10 0 1 0 20 0 10 10 0 1 0-20 0Z"
        fill="#E73B37"
      />
      <path
        d="M400.3 744.5c2.1-0.7 4.1-1.4 6.2-2-2 0.6-4.1 1.3-6.2 2z m0 0c2.1-0.7 4.1-1.4 6.2-2-2 0.6-4.1 1.3-6.2 2z"
        fill="#39393A"
      />
      <path
        d="M511.8 256.6c24.4 0 44.2 19.8 44.2 44.2S536.2 345 511.8 345s-44.2-19.8-44.2-44.2 19.9-44.2 44.2-44.2m0-20c-35.5 0-64.2 28.7-64.2 64.2s28.7 64.2 64.2 64.2 64.2-28.7 64.2-64.2-28.7-64.2-64.2-64.2z"
        fill="#E73B37"
      />
      <path
        d="M730.7 529.5c0.4-8.7 0.6-17.4 0.6-26.2 0-179.6-86.1-339.1-219.3-439.5-133.1 100.4-219.2 259.9-219.2 439.5 0 8.8 0.2 17.5 0.6 26.1-56 56-90.6 133.3-90.6 218.7 0 61.7 18 119.1 49.1 167.3 30.3-49.8 74.7-90.1 127.7-115.3 39-18.6 82.7-29 128.8-29 48.3 0 93.9 11.4 134.3 31.7 52.5 26.3 96.3 67.7 125.6 118.4 33.4-49.4 52.9-108.9 52.9-173.1 0-85.4-34.6-162.6-90.5-218.6zM351.1 383.4c9.2-37.9 22.9-74.7 40.6-109.5a502.1 502.1 0 0 1 63.6-95.9c17.4-20.6 36.4-39.9 56.8-57.5 20.4 17.6 39.4 36.9 56.8 57.5 24.8 29.5 46.2 61.8 63.6 95.9 17.7 34.8 31.4 71.6 40.6 109.5 8.7 35.8 13.5 72.7 14.2 109.9C637.4 459 577 438.9 512 438.9c-65 0-125.3 20.1-175.1 54.4 0.7-37.2 5.5-74.1 14.2-109.9z m-90.6 449.2c-9.1-27-13.7-55.5-13.7-84.4 0-35.8 7-70.6 20.8-103.2 8.4-19.8 19-38.4 31.9-55.5 9.7 61.5 29.5 119.7 57.8 172.6-36.4 17.8-69 41.6-96.8 70.5z m364.2-85.3c-0.7-0.3-1.5-0.5-2.2-0.8-0.4-0.2-0.9-0.3-1.3-0.5-0.6-0.2-1.3-0.5-1.9-0.7-0.8-0.3-1.5-0.5-2.3-0.8-0.8-0.3-1.5-0.5-2.3-0.7l-0.9-0.3c-1-0.3-2.1-0.7-3.1-1-1.2-0.4-2.4-0.7-3.5-1.1l-3-0.9c-0.2-0.1-0.4-0.1-0.7-0.2-1.1-0.3-2.3-0.7-3.4-1-1.2-0.3-2.4-0.6-3.5-0.9l-3.6-0.9-3.6-0.9c-1-0.3-2.1-0.5-3.1-0.7-1.2-0.3-2.4-0.5-3.6-0.8-1.3-0.3-2.5-0.6-3.8-0.8h-0.3c-0.9-0.2-1.9-0.4-2.8-0.6-0.4-0.1-0.7-0.1-1.1-0.2-1.1-0.2-2.2-0.4-3.4-0.6-1.2-0.2-2.4-0.4-3.6-0.7l-5.4-0.9c-0.9-0.1-1.9-0.3-2.8-0.4-0.8-0.1-1.6-0.3-2.5-0.4-2.6-0.4-5.1-0.7-7.7-1-1.2-0.1-2.3-0.3-3.5-0.4h-0.4c-0.9-0.1-1.8-0.2-2.8-0.3-1.1-0.1-2.1-0.2-3.2-0.3-1.7-0.2-3.4-0.3-5.1-0.4-0.8-0.1-1.5-0.1-2.3-0.2-0.9-0.1-1.9-0.1-2.8-0.2-0.4 0-0.8 0-1.2-0.1-1.1-0.1-2.1-0.1-3.2-0.2-0.5 0-1-0.1-1.5-0.1-1.3-0.1-2.6-0.1-3.9-0.1-0.8 0-1.5-0.1-2.3-0.1-1.2 0-2.4 0-3.5-0.1h-13.9c-2.3 0-4.6 0.1-6.9 0.2-0.9 0-1.9 0.1-2.8 0.1-0.8 0-1.5 0.1-2.3 0.1-1.4 0.1-2.8 0.2-4.1 0.3-1.4 0.1-2.7 0.2-4.1 0.3-1.4 0.1-2.7 0.2-4.1 0.4-0.6 0-1.2 0.1-1.8 0.2l-7.8 0.9c-1.1 0.1-2.1 0.3-3.2 0.4-1 0.1-2.1 0.3-3.1 0.4-3.2 0.5-6.4 0.9-9.5 1.5-0.7 0.1-1.4 0.2-2.1 0.4-0.9 0.1-1.7 0.3-2.6 0.5-1.1 0.2-2.3 0.4-3.4 0.6-0.9 0.2-1.7 0.3-2.6 0.5-0.4 0.1-0.8 0.1-1.1 0.2-0.7 0.1-1.4 0.3-2.1 0.4-1.2 0.3-2.4 0.5-3.6 0.8-1.2 0.3-2.4 0.5-3.6 0.8-0.2 0-0.4 0.1-0.6 0.1-0.5 0.1-1 0.2-1.5 0.4-1.1 0.3-2.3 0.6-3.5 0.9-1.3 0.3-2.5 0.6-3.8 1-0.4 0.1-0.9 0.2-1.4 0.4-1.3 0.4-2.7 0.7-4 1.1-1.5 0.4-3 0.9-4.6 1.3-1 0.3-2.1 0.6-3.1 1-2.1 0.6-4.1 1.3-6.2 2-0.7 0.2-1.4 0.5-2.1 0.7-15-27.5-27.4-56.4-37-86.2-11.7-36.1-19.2-73.6-22.5-111.6-0.6-6.7-1-13.3-1.3-20-0.1-1.2-0.1-2.4-0.1-3.6-0.1-1.2-0.1-2.4-0.1-3.6 0-1.2-0.1-2.4-0.1-3.6 0-1.2-0.1-2.4-0.1-3.7 18.8-14 39.2-25.8 61-35 36.1-15.3 74.5-23 114.1-23 39.6 0 78 7.8 114.1 23 21.8 9.2 42.2 20.9 61 35v0.1c0 1 0 1.9-0.1 2.9 0 1.4-0.1 2.8-0.1 4.3 0 0.7 0 1.3-0.1 2-0.1 1.8-0.1 3.5-0.2 5.3-0.3 6.7-0.8 13.3-1.3 20-3.3 38.5-11 76.5-23 113-9.7 30.3-22.3 59.4-37.6 87.1z m136.8 90.9a342.27 342.27 0 0 0-96.3-73.2c29.1-53.7 49.5-112.8 59.4-175.5 12.8 17.1 23.4 35.6 31.8 55.5 13.8 32.7 20.8 67.4 20.8 103.2 0 31-5.3 61.3-15.7 90z"
        fill="#39393A"
      />
      <path
        d="M512 819.3c8.7 0 24.7 22.9 24.7 60.4s-16 60.4-24.7 60.4-24.7-22.9-24.7-60.4 16-60.4 24.7-60.4m0-20c-24.7 0-44.7 36-44.7 80.4 0 44.4 20 80.4 44.7 80.4s44.7-36 44.7-80.4c0-44.4-20-80.4-44.7-80.4z"
        fill="#E73B37"
      />
    </svg>
  ),
  accessCard: (
    <svg
      xmlns="http://www.w3.org/2000/svg"
      width="100%"
      height="100%"
      className="pointer-events-none"
      viewBox="0 0 1024 1024"
      fill="#000000">
      <path
        d="M1015.918 959.942a7.994 7.994 0 0 1-7.998-8V504c0-4.42 3.576-7.998 7.998-7.998s8 3.578 8 7.998v447.942c0 4.422-3.578 8-8 8zM983.954 991.938H40.044a7.994 7.994 0 0 1-7.998-8 7.994 7.994 0 0 1 7.998-7.998h943.908c4.422 0 8 3.578 8 7.998a7.992 7.992 0 0 1-7.998 8zM8.048 959.942a7.994 7.994 0 0 1-7.998-8V440.008c0-4.42 3.578-8 7.998-8 4.422 0 8 3.578 8 8V951.94a7.996 7.996 0 0 1-8 8.002zM951.926 416.012a7.994 7.994 0 0 1-7.998-7.998V112.05H80.024v295.962c0 4.42-3.578 7.998-8 7.998s-8-3.578-8-7.998V104.052c0-4.422 3.578-8 8-8h879.9c4.422 0 8 3.578 8 8v303.96a7.992 7.992 0 0 1-7.998 8z"
        fill=""
      />
      <path
        d="M287.998 384.016c-61.742 0-111.986-50.236-111.986-111.984 0-61.75 50.244-111.986 111.986-111.986 61.742 0 111.984 50.236 111.984 111.986 0 61.748-50.242 111.984-111.984 111.984z m0-207.974c-52.932 0-95.988 43.056-95.988 95.988 0 52.93 43.056 95.986 95.988 95.986 52.93 0 95.986-43.056 95.986-95.986 0-52.93-43.056-95.988-95.986-95.988zM839.942 240.036H487.97a7.994 7.994 0 0 1-7.998-8 7.994 7.994 0 0 1 7.998-7.998H839.94c4.422 0 8 3.578 8 7.998a7.992 7.992 0 0 1-7.998 8zM839.942 288.03H487.97a7.994 7.994 0 0 1-7.998-8 7.994 7.994 0 0 1 7.998-7.998H839.94c4.422 0 8 3.578 8 7.998a7.992 7.992 0 0 1-7.998 8zM663.964 336.022h-175.994c-4.42 0-7.998-3.578-7.998-8s3.578-8 7.998-8h175.994c4.42 0 7.998 3.578 7.998 8s-3.578 8-7.998 8z"
        fill=""
      />
      <path
        d="M248.002 336.022a8 8 0 0 1-5.654-13.656l63.992-63.992a8 8 0 1 1 11.312 11.312l-63.992 63.992a7.976 7.976 0 0 1-5.658 2.344z"
        fill=""
      />
      <path
        d="M359.988 320.024a7.982 7.982 0 0 1-5.656-2.342l-47.994-47.994a8 8 0 1 1 11.312-11.312l47.994 47.994a8 8 0 0 1-5.656 13.654zM216.006 312.026a7.996 7.996 0 0 1-5.656-13.654l23.996-23.998a8 8 0 1 1 11.312 11.312l-23.998 23.996a7.968 7.968 0 0 1-5.654 2.344z"
        fill=""
      />
      <path
        d="M256.002 304.026a7.982 7.982 0 0 1-5.656-2.342l-15.998-15.998a8 8 0 1 1 11.312-11.312l15.998 15.998a8 8 0 0 1-5.656 13.654zM264 256.034c-13.232 0-23.996-10.764-23.996-23.998 0-13.232 10.764-23.996 23.996-23.996s23.998 10.764 23.998 23.996-10.766 23.998-23.998 23.998z m0-31.996a8.008 8.008 0 0 0-7.998 7.998c0 4.414 3.592 8 7.998 8 4.406 0 8-3.586 8-8a8.01 8.01 0 0 0-8-7.998zM40.044 480.004c-22.06 0-39.994-17.944-39.994-39.996 0-4.42 3.578-8 7.998-8 4.422 0 8 3.578 8 8 0 13.234 10.764 23.998 23.996 23.998 4.422 0 8 3.578 8 8s-3.578 7.998-8 7.998zM40.044 991.938c-22.06 0-39.994-17.936-39.994-39.996a7.994 7.994 0 0 1 7.998-7.998c4.422 0 8 3.578 8 7.998 0 13.234 10.764 23.998 23.996 23.998 4.422 0 8 3.578 8 7.998 0 4.422-3.578 8-8 8zM983.954 991.938a7.994 7.994 0 0 1-7.998-8 7.994 7.994 0 0 1 7.998-7.998c13.234 0 23.998-10.764 23.998-23.998 0-4.42 3.576-7.998 7.998-7.998s8 3.578 8 7.998c0 22.06-17.936 39.996-39.996 39.996zM1015.95 512a7.994 7.994 0 0 1-7.998-8c0-13.232-10.764-23.996-23.998-23.996-4.42 0-7.998-3.578-7.998-8s3.578-8 7.998-8c22.06 0 39.996 17.944 39.996 39.994a7.996 7.996 0 0 1-8 8.002zM1015.95 448.008a7.994 7.994 0 0 1-7.998-8c0-13.232-10.764-23.998-23.998-23.998a7.994 7.994 0 0 1-7.998-7.998c0-4.422 3.578-8 7.998-8 22.06 0 39.996 17.944 39.996 39.996 0 4.422-3.578 8-8 8z"
        fill=""
      />
      <path
        d="M8.048 448.008a7.994 7.994 0 0 1-7.998-8c0-22.052 17.934-39.996 39.994-39.996 4.422 0 8 3.578 8 8a7.994 7.994 0 0 1-8 7.998c-13.232 0-23.996 10.764-23.996 23.998 0 4.422-3.578 8-8 8z"
        fill=""
      />
      <path
        d="M983.954 480.004H40.044c-4.42 0-7.998-3.578-7.998-8s3.578-8 7.998-8h943.908c4.422 0 8 3.578 8 8s-3.576 8-7.998 8z"
        fill=""
      />
      <path
        d="M1015.95 464.006a7.994 7.994 0 0 1-7.998-8v-15.998c0-4.42 3.576-8 7.998-8s8 3.578 8 8v15.998c0 4.422-3.578 8-8 8z"
        fill=""
      />
      <path
        d="M967.926 448.008H56.028c-4.422 0-8-3.578-8-8s3.578-8 8-8h911.898c4.42 0 7.998 3.578 7.998 8s-3.578 8-7.998 8z"
        fill=""
      />
      <path
        d="M935.93 80.056H88.04c-4.422 0-8-3.578-8-8s3.578-8 8-8h847.89c4.42 0 7.998 3.578 7.998 8s-3.578 8-7.998 8z"
        fill=""
      />
      <path
        d="M919.932 48.06H104.038c-4.422 0-8-3.578-8-8a7.994 7.994 0 0 1 8-7.998h815.894a7.994 7.994 0 0 1 7.998 7.998c0 4.422-3.578 8-7.998 8z"
        fill=""
      />
      <path
        d="M967.926 527.998h-16.016a7.994 7.994 0 0 1-7.998-8 7.994 7.994 0 0 1 7.998-7.998h16.016a7.994 7.994 0 0 1 7.998 7.998c0 4.422-3.578 8-7.998 8z m-48.01 0H887.92c-4.422 0-8-3.578-8-8a7.994 7.994 0 0 1 8-7.998h31.996a7.994 7.994 0 0 1 7.998 7.998c0 4.422-3.578 8-7.998 8z m-63.992 0h-31.996a7.994 7.994 0 0 1-7.998-8 7.994 7.994 0 0 1 7.998-7.998h31.996a7.994 7.994 0 0 1 7.998 7.998c0 4.422-3.578 8-7.998 8z m-63.992 0h-31.996a7.994 7.994 0 0 1-7.998-8 7.994 7.994 0 0 1 7.998-7.998h31.996c4.422 0 8 3.578 8 7.998 0 4.422-3.578 8-8 8z m-63.99 0h-31.996c-4.422 0-8-3.578-8-8a7.994 7.994 0 0 1 8-7.998h31.996a7.994 7.994 0 0 1 7.998 7.998c0 4.422-3.578 8-7.998 8z m-63.992 0h-31.996c-4.422 0-8-3.578-8-8a7.994 7.994 0 0 1 8-7.998h31.996a7.994 7.994 0 0 1 7.998 7.998c0 4.422-3.578 8-7.998 8z m-63.992 0H567.96c-4.422 0-8-3.578-8-8a7.994 7.994 0 0 1 8-7.998h31.996c4.422 0 8 3.578 8 7.998a7.994 7.994 0 0 1-7.998 8z m-63.994 0h-31.996a7.994 7.994 0 0 1-7.998-8 7.994 7.994 0 0 1 7.998-7.998h31.996c4.422 0 8 3.578 8 7.998 0 4.422-3.578 8-8 8z m-63.99 0h-31.996c-4.42 0-8-3.578-8-8a7.994 7.994 0 0 1 8-7.998h31.996a7.998 7.998 0 1 1 0 15.998z m-63.992 0h-31.996c-4.422 0-8-3.578-8-8a7.994 7.994 0 0 1 8-7.998h31.996a7.994 7.994 0 0 1 7.998 7.998c0 4.422-3.578 8-7.998 8z m-63.992 0h-31.996c-4.422 0-8-3.578-8-8a7.994 7.994 0 0 1 8-7.998h31.996c4.42 0 8 3.578 8 7.998 0 4.422-3.578 8-8 8z m-63.992 0h-31.996a7.994 7.994 0 0 1-7.998-8 7.994 7.994 0 0 1 7.998-7.998h31.996c4.422 0 8 3.578 8 7.998 0 4.422-3.578 8-8 8z m-63.992 0H184.01c-4.42 0-8-3.578-8-8a7.994 7.994 0 0 1 8-7.998h31.996c4.42 0 8 3.578 8 7.998 0 4.422-3.578 8-8 8z m-63.99 0H120.02c-4.422 0-8-3.578-8-8a7.994 7.994 0 0 1 8-7.998h31.996a7.994 7.994 0 0 1 7.998 7.998c0 4.422-3.578 8-7.998 8z m-63.992 0H56.028c-4.422 0-8-3.578-8-8a7.994 7.994 0 0 1 8-7.998h31.996a7.998 7.998 0 1 1 0 15.998z"
        fill=""
      />
      <path
        d="M967.926 943.944h-16.016a7.994 7.994 0 0 1-7.998-7.998c0-4.422 3.578-8 7.998-8h16.016a7.994 7.994 0 0 1 7.998 8 7.994 7.994 0 0 1-7.998 7.998z m-48.01 0H887.92c-4.422 0-8-3.578-8-7.998 0-4.422 3.578-8 8-8h31.996a7.994 7.994 0 0 1 7.998 8 7.994 7.994 0 0 1-7.998 7.998z m-63.992 0h-31.996a7.994 7.994 0 0 1-7.998-7.998c0-4.422 3.576-8 7.998-8h31.996a7.994 7.994 0 0 1 7.998 8 7.994 7.994 0 0 1-7.998 7.998z m-63.992 0h-31.996a7.994 7.994 0 0 1-7.998-7.998c0-4.422 3.578-8 7.998-8h31.996c4.422 0 8 3.578 8 8a7.994 7.994 0 0 1-8 7.998z m-63.99 0h-31.996c-4.422 0-8-3.578-8-7.998 0-4.422 3.578-8 8-8h31.996a7.994 7.994 0 0 1 7.998 8 7.994 7.994 0 0 1-7.998 7.998z m-63.992 0h-31.996c-4.422 0-8-3.578-8-7.998 0-4.422 3.578-8 8-8h31.996a7.994 7.994 0 0 1 7.998 8 7.994 7.994 0 0 1-7.998 7.998z m-63.992 0H567.96c-4.422 0-8-3.578-8-7.998 0-4.422 3.578-8 8-8h31.996c4.422 0 8 3.578 8 8a7.994 7.994 0 0 1-7.998 7.998z m-63.994 0h-31.996a7.994 7.994 0 0 1-7.998-7.998c0-4.422 3.578-8 7.998-8h31.996c4.422 0 8 3.578 8 8a7.994 7.994 0 0 1-8 7.998z m-63.99 0h-31.996c-4.42 0-8-3.578-8-7.998 0-4.422 3.578-8 8-8h31.996c4.42 0 8 3.578 8 8a7.998 7.998 0 0 1-8 7.998z m-63.992 0h-31.996c-4.422 0-8-3.578-8-7.998 0-4.422 3.578-8 8-8h31.996a7.994 7.994 0 0 1 7.998 8 7.994 7.994 0 0 1-7.998 7.998z m-63.992 0h-31.996c-4.422 0-8-3.578-8-7.998 0-4.422 3.578-8 8-8h31.996c4.42 0 8 3.578 8 8a7.994 7.994 0 0 1-8 7.998z m-63.992 0h-31.996a7.994 7.994 0 0 1-7.998-7.998c0-4.422 3.578-8 7.998-8h31.996c4.422 0 8 3.578 8 8a7.994 7.994 0 0 1-8 7.998z m-63.992 0H184.01c-4.42 0-8-3.578-8-7.998 0-4.422 3.578-8 8-8h31.996c4.42 0 8 3.578 8 8a7.994 7.994 0 0 1-8 7.998z m-63.99 0H120.02c-4.422 0-8-3.578-8-7.998 0-4.422 3.578-8 8-8h31.996a7.994 7.994 0 0 1 7.998 8 7.994 7.994 0 0 1-7.998 7.998z m-63.992 0H56.028c-4.422 0-8-3.578-8-7.998 0-4.422 3.578-8 8-8h31.996c4.42 0 8 3.578 8 8a7.998 7.998 0 0 1-8 7.998z"
        fill=""
      />
      <path
        d="M511.984 783.964c-73.678 0-151.98-19.624-151.98-55.992 0-36.372 78.302-55.994 151.98-55.994s151.98 19.624 151.98 55.994c0 36.37-78.302 55.992-151.98 55.992z m0-95.988c-84.256 0-135.982 23.292-135.982 39.996 0 16.7 51.726 39.994 135.982 39.994 84.254 0 135.982-23.294 135.982-39.994 0-16.702-51.728-39.996-135.982-39.996z"
        fill=""
      />
      <path
        d="M575.976 735.97h-127.984c-4.422 0-8-3.578-8-7.998 0-4.422 3.578-8 8-8h127.984a7.994 7.994 0 0 1 7.998 8 7.994 7.994 0 0 1-7.998 7.998z"
        fill=""
      />
    </svg>
  ),
  address: (
    <svg
      xmlns="http://www.w3.org/2000/svg"
      width="100%"
      height="100%"
      className="pointer-events-none"
      viewBox="0 0 1024 1024">
      <path
        d="M607.7 64.2c-102.9 0-186.3 83.4-186.3 186.3 0 30 15.9 66.6 38.3 103.3 15.2 24.8 33.3 49.7 51.7 72.6C559 486 607.7 533 607.7 533s17.7-17.1 42.3-43.8c14-15.3 30.3-33.6 46.7-53.8 47.9-58.7 97.3-132 97.3-184.9 0-102.9-83.4-186.3-186.3-186.3z m77.8 353.2c-8 10-16.1 19.6-23.9 28.6-7.8 9-15.4 17.5-22.5 25.3-12.5 13.7-23.4 25.1-31.4 33.3-12.5-12.8-32.3-33.5-53.8-58.5-7.8-9-15.8-18.5-23.8-28.5-13.5-16.7-25.5-32.7-36.1-48-10.1-14.6-18.8-28.4-26.1-41.5-17.6-31.6-26.6-57.8-26.6-77.8 0-44.4 17.3-86.2 48.7-117.6C521.4 101.3 563.2 84 607.6 84c44.4 0 86.2 17.3 117.6 48.7 31.4 31.4 48.7 73.2 48.7 117.6 0 20-8.9 46.1-26.5 77.6-14.8 26.9-35.6 56.9-61.9 89.5z"
        fill="#E73B37"
      />
      <path
        d="M607.7 183.1c36.9 0 67 30.1 67 67s-30.1 67-67 67-67-30.1-67-67 30-67 67-67m0-20c-48 0-87 38.9-87 87 0 48 38.9 87 87 87 48 0 87-38.9 87-87s-39-87-87-87z"
        fill="#E73B37"
      />
      <path
        d="M927.9 352.4l-195.7 70.3-35.6 12.8c-16.4 20.1-32.7 38.5-46.7 53.8l1.9 0.9v416.6l-12.7-5.9-46.3-21.6-212.2-98.9-8.6-4v-415l139.4 65c-18.4-23-36.5-47.8-51.7-72.6l-77.6-36.2-3.7-1.7-8.6-4-7.8-3.7-2.2 0.8L64 415.3v511.8L362 820l230.8 107.6 46.3 21.6 22.7 10.6L960 852.7V340.9l-32.1 11.5zM352 776.9l-4.9 1.8L108 864.6V446.2l244-87.7v418.4z m564 44.9l-244.2 87.7V491.1l5.1-1.8L916 403.4v418.4z"
        fill="#39393A"
      />
    </svg>
  ),
  allCovered: (
    <svg
      xmlns="http://www.w3.org/2000/svg"
      width="100%"
      height="100%"
      className="pointer-events-none"
      viewBox="0 0 1024 1024">
      <path
        d="M512.5 136.6l-389.4 283 148.7 457.8h481.4l148.7-457.8z"
        fill="#FFFFFF"
      />
      <path
        d="M712.2 746.7c0-20.9-17-37.8-37.8-37.8-10.7 0-20.4 4.5-27.3 11.6l43.5 60.3c12.7-6.1 21.6-19.1 21.6-34.1zM636.5 746.7c0 18.8 13.8 34.4 31.7 37.3L637 740.7c-0.3 2-0.5 4-0.5 6z"
        fill="#E6E6E6"
      />
      <path
        d="M690.6 780.8l-43.5-60.3c-5.2 5.4-8.8 12.4-10.1 20.2l31.2 43.3c2 0.3 4 0.5 6.1 0.5 5.9 0 11.4-1.3 16.3-3.7z"
        fill="#E6E6E6"
      />
      <path
        d="M536.9 723c-2.3-5-8.3-7.2-13.3-4.9s-7.2 8.3-4.9 13.3c1.5 3.3 3.2 6.5 4.9 9.6 1.8 3.3 5.2 5.1 8.7 5.1 1.7 0 3.3-0.4 4.9-1.3 4.8-2.7 6.5-8.8 3.8-13.6-1.4-2.6-2.9-5.4-4.1-8.2zM526.7 687.7c-0.3-3-0.5-5.8-0.5-8.4v-0.3c0-5.5-4.4-10-9.9-10.1h-0.1c-5.5 0-10 4.4-10 9.9v0.5c0 3.4 0.2 7 0.6 10.7 0.6 5.1 4.9 8.9 9.9 8.9 0.4 0 0.8 0 1.1-0.1 5.6-0.6 9.5-5.6 8.9-11.1zM571.1 764.4c-2.5-1.6-4.9-3.4-7.2-5.3-4.3-3.5-10.6-2.9-14.1 1.4s-2.9 10.6 1.4 14.1c2.9 2.4 5.9 4.6 8.9 6.6 1.7 1.1 3.6 1.6 5.5 1.6 3.3 0 6.5-1.6 8.4-4.5 3-4.7 1.7-10.9-2.9-13.9zM613.1 777.1c-3-0.1-6.1-0.3-9-0.7-5.5-0.7-10.5 3.2-11.2 8.6-0.7 5.5 3.2 10.5 8.6 11.2 3.6 0.5 7.2 0.7 10.9 0.8h0.3c5.4 0 9.8-4.3 10-9.7 0.2-5.5-4.1-10.1-9.6-10.2zM542.7 626c-4.7-2.9-10.9-1.3-13.7 3.4-1.8 3-3.5 5.8-5.2 8.4-2.9 4.7-1.5 10.9 3.2 13.8 1.6 1 3.5 1.5 5.3 1.5 3.3 0 6.6-1.7 8.5-4.7 1.8-2.9 3.6-5.8 5.3-8.7 2.9-4.7 1.3-10.8-3.4-13.7zM573.1 541.6c-1.2 3-2.4 6.1-3.6 9.1-2.1 5.1 0.3 11 5.4 13.1 1.3 0.5 2.6 0.8 3.8 0.8 3.9 0 7.6-2.3 9.2-6.2 1.3-3.2 2.6-6.4 3.8-9.5 2-5.1-0.6-10.9-5.7-12.9-1.5-0.6-3-0.8-4.5-0.6l-4.2 1.4c-1.8 0.9-3.4 2.6-4.2 4.8z"
        fill="#005BFF"
      />
      <path
        d="M512.5 136.6l-389.4 283 148.7 457.8h481.3l148.7-457.8-389.3-283z m10 56.8L845 427.7l-43.2 14.2L522.5 239v-45.6z m0 70.3l255.8 185.9-173.1 56.8c0.6-2.3 1.1-4.7 1.6-7 1.1-5.4-2.3-10.7-7.7-11.8s-10.7 2.3-11.8 7.7c-0.6 3-1.4 6.2-2.2 9.4-0.7 2.8-0.1 5.7 1.3 7.9L536.6 529c-3.5-4.9-8.4-8.6-14.1-10.7V263.7zM173.9 446.5l72.8 23.4c1.3-6.7 3.4-13 6.4-19l-72.9-23.4 322.3-234.2v165.2c-0.6-0.1-1.1-0.2-1.7-0.2-3.6-0.2-7.2-0.2-10.8-0.1-5.5 0.2-9.9 4.8-9.7 10.3 0.2 5.5 4.7 9.9 10.3 9.7 3.1-0.1 6.2-0.1 9.2 0.1h0.5c0.8 0 1.5-0.1 2.2-0.3v140.2c-5 1.8-9.3 4.8-12.6 8.8l-98.7-31.7c-1.1 6.7-3.1 13.1-5.9 19.1l97.6 31.4v0.2c0 7.2 2.6 13.8 6.9 18.9l-192.6 261-123.3-379.4z m139.7 390.9l193.6-262.2c1.7 0.3 3.5 0.5 5.3 0.5 1.7 0 3.4-0.2 5.1-0.4l105.1 145.6c-3.9 7.8-6.1 16.6-6.1 25.9 0 31.9 25.9 57.8 57.8 57.8 2.8 0 5.6-0.2 8.3-0.6l24.1 33.5H313.6z m322.9-90.7c0-2 0.2-4 0.5-6 1.2-7.8 4.9-14.8 10.1-20.2 6.9-7.2 16.6-11.6 27.3-11.6 20.9 0 37.8 17 37.8 37.8 0 15-8.8 28-21.6 34.1-4.9 2.4-10.4 3.7-16.3 3.7-2.1 0-4.1-0.2-6.1-0.5-17.9-2.9-31.7-18.5-31.7-37.3z m89.9 83.7l-23.9-33.2c17.7-9.9 29.7-28.8 29.7-50.5 0-31.9-25.9-57.8-57.8-57.8-15.1 0-28.8 5.8-39.1 15.3l-70.5-97.7c0.5-0.6 1-1.3 1.4-2 1.6-3 3.2-6.1 4.7-9 2.5-4.9 0.5-10.9-4.4-13.4s-10.9-0.5-13.4 4.4c-0.4 0.7-0.8 1.5-1.1 2.2l-17-23.5c4-4.7 6.5-10.6 7-17l35.3-11.6c1.3-0.8 2.7-1.3 4.2-1.4L851 446.7 726.4 830.4z"
        fill="#005BFF"
      />
      <path
        d="M360.6 422l-0.8 0.8c5.6 3.8 10.6 8.3 14.9 13.4l0.3-0.3c3.8-4 3.7-10.3-0.3-14.1-3.9-3.9-10.2-3.8-14.1 0.2zM590.5 448.8c0.3 2.9 0.5 6 0.6 9.1 0.1 5.4 4.6 9.7 10 9.7h0.3c5.5-0.1 9.9-4.7 9.7-10.3-0.1-3.7-0.3-7.3-0.7-10.8-0.6-5.5-5.6-9.4-11-8.8-5.6 0.6-9.5 5.6-8.9 11.1zM398 412.7c2 0 4.1-0.6 5.9-1.9 2.6-1.9 5.2-3.7 7.9-5.5 4.6-3 5.9-9.2 2.8-13.9-3-4.6-9.3-5.9-13.9-2.8-2.9 1.9-5.8 3.9-8.6 6-4.5 3.3-5.5 9.5-2.2 14 2 2.7 5.1 4.1 8.1 4.1zM544.6 389.1c1.3 0.6 2.7 0.9 4 0.9 3.8 0 7.5-2.2 9.2-6 2.2-5.1 0-11-5.1-13.2-3.3-1.4-6.6-2.8-9.9-4-5.2-1.9-10.9 0.8-12.8 6-1.9 5.2 0.8 10.9 6 12.8 2.8 1.1 5.7 2.3 8.6 3.5zM579.2 415.8c1.9 2.9 5.1 4.5 8.3 4.5 1.9 0 3.8-0.5 5.5-1.7 4.6-3.1 5.8-9.3 2.8-13.9-2.1-3.1-4.4-6.2-7-9-3.7-4.1-10-4.5-14.1-0.8s-4.5 10-0.8 14.1c1.9 2.1 3.7 4.4 5.3 6.8zM441.6 388.5c1.2 0 2.4-0.2 3.6-0.7 2.9-1.1 5.9-2.2 8.8-3.2 5.3-1.7 8.1-7.3 6.5-12.6-1.7-5.3-7.3-8.2-12.6-6.5-3.3 1.1-6.7 2.3-10 3.6-5.1 2-7.7 7.8-5.7 13 1.7 4 5.4 6.4 9.4 6.4zM577.3 536.6l4.2-1.4c-1.5 0.2-2.9 0.6-4.2 1.4z"
        fill="#005BFF"
      />
      <path
        d="M372.2 483.6c0-29.4-24-53.4-53.4-53.4-19.8 0-37.1 10.9-46.4 27l99.5 32c0.2-1.9 0.3-3.7 0.3-5.6zM265.4 483.6c0 29.4 24 53.4 53.4 53.4 20.5 0 38.4-11.7 47.3-28.7l-100.2-32.2c-0.3 2.4-0.5 4.9-0.5 7.5z"
        fill="#FFFFFF"
      />
      <path
        d="M366.1 508.3c3.1-5.8 5.1-12.3 5.8-19.1l-99.5-32c-3.3 5.7-5.5 12.1-6.5 18.9l100.2 32.2z"
        fill="#FFFFFF"
      />
      <path
        d="M374.7 436.2c-4.3-5.1-9.3-9.6-14.9-13.4-11.7-8-25.9-12.6-41.1-12.6-28.7 0-53.7 16.6-65.7 40.7-3 5.9-5.1 12.3-6.4 19-0.8 4.4-1.3 9-1.3 13.7 0 40.5 32.9 73.4 73.4 73.4 29.4 0 54.9-17.4 66.6-42.5 2.8-6 4.8-12.4 5.9-19.1 0.6-3.8 1-7.8 1-11.8 0-18.1-6.6-34.6-17.5-47.4z m-2.8 52.9c-0.7 6.8-2.7 13.3-5.8 19.1-8.9 17-26.8 28.7-47.3 28.7-29.4 0-53.4-24-53.4-53.4 0-2.6 0.2-5.1 0.5-7.5 1-6.8 3.2-13.2 6.5-18.9 9.2-16.1 26.5-27 46.4-27 29.4 0 53.4 24 53.4 53.4 0 2-0.1 3.8-0.3 5.6z"
        fill="#06F3FF"
      />
    </svg>
  ),
  analisis: (
    <svg
      xmlns="http://www.w3.org/2000/svg"
      width="100%"
      height="100%"
      className="pointer-events-none"
      viewBox="0 0 1024 1024"
      fill="#000000">
      <path
        d="M40.622 184.1c-4.414 0-8.076-3.576-8.076-7.996 0-4.422 3.498-7.998 7.918-7.998h0.156a7.994 7.994 0 0 1 7.998 7.998 7.99 7.99 0 0 1-7.996 7.996zM72.612 184.1c-4.414 0-8.076-3.576-8.076-7.996 0-4.422 3.498-7.998 7.918-7.998h0.156a7.994 7.994 0 0 1 7.998 7.998 7.99 7.99 0 0 1-7.996 7.996zM104.602 184.1c-4.414 0-8.076-3.576-8.076-7.996 0-4.422 3.498-7.998 7.918-7.998h0.156a7.994 7.994 0 0 1 7.998 7.998 7.99 7.99 0 0 1-7.996 7.996z"
        fill=""
      />
      <path
        d="M1015.848 200.096H8.156a7.994 7.994 0 0 1-7.998-7.998v-15.994c0-13.23 10.762-23.994 23.992-23.994h975.702c13.23 0 23.992 10.764 23.992 23.994v15.994a7.994 7.994 0 0 1-7.996 7.998zM16.152 184.1h991.696v-7.996a8.008 8.008 0 0 0-7.996-7.998H24.15a8.004 8.004 0 0 0-7.998 7.998v7.996z"
        fill=""
      />
      <path
        d="M1015.848 871.89H8.156a7.994 7.994 0 0 1-7.998-7.998V192.098a7.994 7.994 0 0 1 7.998-7.998h1007.692a7.994 7.994 0 0 1 7.996 7.998v671.794a7.994 7.994 0 0 1-7.996 7.998zM16.152 855.894h991.696V200.096H16.152v655.798z"
        fill=""
      />
      <path
        d="M512 807.91a7.994 7.994 0 0 1-7.998-7.998V256.078A7.994 7.994 0 0 1 512 248.08a7.992 7.992 0 0 1 7.996 7.998v543.834a7.992 7.992 0 0 1-7.996 7.998zM440.022 663.954H72.136a7.992 7.992 0 0 1-7.998-7.996 7.992 7.992 0 0 1 7.998-7.998h367.886a7.994 7.994 0 0 1 7.998 7.998 7.994 7.994 0 0 1-7.998 7.996z"
        fill=""
      />
      <path
        d="M72.136 663.954a7.992 7.992 0 0 1-7.998-7.996V288.068a7.994 7.994 0 0 1 7.998-7.998 7.994 7.994 0 0 1 7.998 7.998v367.888a7.996 7.996 0 0 1-7.998 7.998zM184.1 663.954H104.124a7.992 7.992 0 0 1-7.998-7.996V432.024a7.992 7.992 0 0 1 7.998-7.996H184.1a7.992 7.992 0 0 1 7.998 7.996v223.934a7.994 7.994 0 0 1-7.998 7.996z m-71.978-15.996h63.98V440.022h-63.98v207.936zM296.066 663.954h-79.976a7.992 7.992 0 0 1-7.998-7.996V336.054a7.994 7.994 0 0 1 7.998-7.998h79.976a7.994 7.994 0 0 1 7.998 7.998v319.902a7.994 7.994 0 0 1-7.998 7.998z m-71.978-15.996h63.98V344.05h-63.98v303.908zM408.032 663.954h-79.976a7.992 7.992 0 0 1-7.998-7.996v-111.966a7.994 7.994 0 0 1 7.998-7.998h79.976a7.994 7.994 0 0 1 7.998 7.998v111.966a7.994 7.994 0 0 1-7.998 7.996z m-71.978-15.996h63.98v-95.97h-63.98v95.97zM416.03 743.93H96.128c-4.42 0-7.998-3.578-7.998-7.998s3.578-7.998 7.998-7.998h319.902c4.42 0 7.998 3.578 7.998 7.998s-3.578 7.998-7.998 7.998zM352.05 775.918H160.108a7.992 7.992 0 0 1-7.998-7.996 7.994 7.994 0 0 1 7.998-7.998h191.942a7.994 7.994 0 0 1 7.998 7.998 7.994 7.994 0 0 1-7.998 7.996zM927.872 743.93h-319.9c-4.422 0-8-3.578-8-7.998s3.578-7.998 8-7.998h319.898c4.422 0 8 3.578 8 7.998s-3.578 7.998-7.998 7.998zM863.89 775.918h-191.938c-4.422 0-8-3.576-8-7.996a7.994 7.994 0 0 1 8-7.998h191.938c4.422 0 8 3.576 8 7.998a7.994 7.994 0 0 1-8 7.996zM767.922 663.954c-105.844 0-191.942-86.098-191.942-191.942 0-105.834 86.098-191.942 191.942-191.942s191.942 86.108 191.942 191.942c0 105.844-86.098 191.942-191.942 191.942z m0-367.888c-97.016 0-175.946 78.928-175.946 175.946s78.93 175.948 175.946 175.948 175.946-78.93 175.946-175.948-78.93-175.946-175.946-175.946z"
        fill=""
      />
      <path
        d="M767.922 551.988c-44.098 0-79.976-35.878-79.976-79.976 0-44.096 35.878-79.974 79.976-79.974s79.976 35.878 79.976 79.974c0 44.098-35.878 79.976-79.976 79.976z m0-143.956c-35.286 0-63.98 28.704-63.98 63.98 0 35.28 28.696 63.98 63.98 63.98s63.98-28.702 63.98-63.98c0-35.278-28.694-63.98-63.98-63.98z"
        fill=""
      />
      <path
        d="M767.922 408.196a7.99 7.99 0 0 1-7.996-7.998v-112.128c0-4.42 3.574-7.998 7.996-7.998s7.996 3.578 7.996 7.998v112.128a7.99 7.99 0 0 1-7.996 7.998zM897.976 610.064a7.976 7.976 0 0 1-5.656-2.344l-79.164-79.162a8 8 0 0 1 11.312-11.31l79.16 79.164a7.994 7.994 0 0 1 0 11.308 7.956 7.956 0 0 1-5.652 2.344z"
        fill=""
      />
      <path
        d="M768.14 344.058a8 8 0 0 1-5.656-13.652l42.894-42.892a7.994 7.994 0 0 1 11.308 0 7.994 7.994 0 0 1 0 11.308l-42.89 42.894a7.97 7.97 0 0 1-5.656 2.342zM768.14 389.294a8 8 0 0 1-5.656-13.652l77.226-77.226a7.996 7.996 0 1 1 11.308 11.31l-77.222 77.226a7.97 7.97 0 0 1-5.656 2.342zM790.774 411.906a7.994 7.994 0 0 1-5.652-13.652l82.536-82.53a7.994 7.994 0 0 1 11.308 0 7.994 7.994 0 0 1 0 11.308l-82.536 82.53a7.976 7.976 0 0 1-5.656 2.344zM818.812 429.126a7.998 7.998 0 0 1-5.656-13.652l79.18-79.178a7.994 7.994 0 0 1 11.308 0 7.994 7.994 0 0 1 0 11.308l-79.176 79.178a7.964 7.964 0 0 1-5.656 2.344zM836.074 457.096a7.994 7.994 0 0 1-5.656-13.652l82.726-82.724a7.998 7.998 0 0 1 11.308 11.308l-82.726 82.724a7.97 7.97 0 0 1-5.652 2.344zM836.902 501.52a7.994 7.994 0 0 1-5.656-13.652l98.218-98.228a7.994 7.994 0 0 1 11.308 0 7.994 7.994 0 0 1 0 11.308l-98.218 98.228a7.97 7.97 0 0 1-5.652 2.344zM836.074 547.582a7.996 7.996 0 0 1-5.656-13.652l110.668-110.668a8 8 0 0 1 11.312 11.308l-110.672 110.67a7.978 7.978 0 0 1-5.652 2.342zM858.41 570.498a7.998 7.998 0 0 1-5.656-13.652l93.426-93.44a7.994 7.994 0 0 1 11.308 0 7.994 7.994 0 0 1 0 11.308l-93.426 93.44a7.958 7.958 0 0 1-5.652 2.344zM881.028 593.116a7.994 7.994 0 0 1-5.652-13.65l64.168-64.184a7.998 7.998 0 0 1 11.308 11.308l-64.168 64.184a7.974 7.974 0 0 1-5.656 2.342z"
        fill=""
      />
      <path
        d="M184.1 472.012H104.124a7.994 7.994 0 0 1-7.998-7.998 7.992 7.992 0 0 1 7.998-7.996H184.1a7.992 7.992 0 0 1 7.998 7.996 7.994 7.994 0 0 1-7.998 7.998z"
        fill=""
      />
      <path
        d="M184.1 583.978H104.124c-4.42 0-7.998-3.578-7.998-7.998s3.576-7.998 7.998-7.998H184.1c4.42 0 7.998 3.578 7.998 7.998s-3.578 7.998-7.998 7.998z"
        fill=""
      />
      <path
        d="M296.066 408.196h-79.976a7.994 7.994 0 0 1-7.998-7.998 7.992 7.992 0 0 1 7.998-7.996h79.976a7.992 7.992 0 0 1 7.998 7.996 7.992 7.992 0 0 1-7.998 7.998z"
        fill=""
      />
      <path
        d="M296.066 519.998h-79.976c-4.42 0-7.998-3.578-7.998-7.998s3.578-7.998 7.998-7.998h79.976c4.42 0 7.998 3.578 7.998 7.998s-3.576 7.998-7.998 7.998z"
        fill=""
      />
      <path
        d="M408.032 583.978h-79.976c-4.42 0-7.998-3.578-7.998-7.998s3.576-7.998 7.998-7.998h79.976c4.42 0 7.998 3.578 7.998 7.998s-3.578 7.998-7.998 7.998z"
        fill=""
      />
      <path
        d="M408.032 615.968h-79.976c-4.42 0-7.998-3.578-7.998-7.998s3.576-7.998 7.998-7.998h79.976c4.42 0 7.998 3.578 7.998 7.998s-3.578 7.998-7.998 7.998z"
        fill=""
      />
    </svg>
  ),
  analyze: (
    <svg
      xmlns="http://www.w3.org/2000/svg"
      width="100%"
      height="100%"
      className="pointer-events-none"
      viewBox="0 0 1024 1024">
      <path
        d="M503.8 817.7h16v128.9h-16zM503.7 62.7h16v127.7h-16z"
        fill="#0A0408"
      />
      <path d="M511.7 214h379.2v600.7H132.6V214h379.1" fill="#FFFFFF" />
      <path
        d="M511.7 206h8v16h-8zM867.1 222h-15.8v-16h15.8v16z m-31.6 0h-15.8v-16h15.8v16z m-31.6 0h-15.8v-16h15.8v16z m-31.6 0h-15.8v-16h15.8v16z m-31.5 0H725v-16h15.8v16z m-31.6 0h-15.8v-16h15.8v16z m-31.6 0h-15.8v-16h15.8v16z m-31.6 0h-15.8v-16H646v16z m-31.5 0h-15.8v-16h15.8v16z m-31.6 0h-15.8v-16h15.8v16z m-31.6 0h-15.8v-16h15.8v16zM882.9 206h16v16h-16zM898.9 790.9h-16v-15.8h16v15.8z m0-31.6h-16v-15.8h16v15.8z m0-31.6h-16v-15.8h16v15.8z m0-31.6h-16v-15.8h16v15.8z m0-31.6h-16v-15.8h16v15.8z m0-31.6h-16v-15.8h16v15.8z m0-31.6h-16v-15.8h16v15.8z m0-31.6h-16v-15.8h16v15.8z m0-31.6h-16v-15.8h16v15.8z m0-31.6h-16v-15.8h16v15.8z m0-31.7h-16V459h16v15.8z m0-31.6h-16v-15.8h16v15.8z m0-31.6h-16v-15.8h16v15.8z m0-31.6h-16v-15.8h16V380z m0-31.6h-16v-15.8h16v15.8z m0-31.6h-16V301h16v15.8z m0-31.6h-16v-15.8h16v15.8z m0-31.6h-16v-15.8h16v15.8zM882.9 806.7h16v16h-16zM867.1 822.7h-15.8v-16h15.8v16z m-31.6 0h-15.8v-16h15.8v16z m-31.6 0h-15.8v-16h15.8v16z m-31.6 0h-15.8v-16h15.8v16z m-31.6 0h-15.8v-16h15.8v16z m-31.6 0h-15.8v-16h15.8v16z m-31.5 0h-15.8v-16h15.8v16z m-31.6 0h-15.8v-16H646v16z m-31.6 0h-15.8v-16h15.8v16z m-31.6 0H567v-16h15.8v16z m-31.6 0h-15.8v-16h15.8v16z m-31.6 0h-15.8v-16h15.8v16z m-31.5 0h-15.8v-16h15.8v16z m-31.6 0h-15.8v-16h15.8v16z m-31.6 0h-15.8v-16h15.8v16z m-31.6 0h-15.8v-16h15.8v16z m-31.6 0h-15.8v-16h15.8v16z m-31.6 0h-15.8v-16h15.8v16z m-31.6 0h-15.8v-16h15.8v16z m-31.5 0h-15.8v-16H267v16z m-31.6 0h-15.8v-16h15.8v16z m-31.6 0H188v-16h15.8v16z m-31.6 0h-15.8v-16h15.8v16zM124.6 806.7h16v16h-16zM140.6 790.9h-16v-15.8h16v15.8z m0-31.6h-16v-15.8h16v15.8z m0-31.6h-16v-15.8h16v15.8z m0-31.6h-16v-15.8h16v15.8z m0-31.6h-16v-15.8h16v15.8z m0-31.6h-16v-15.8h16v15.8z m0-31.6h-16v-15.8h16v15.8z m0-31.6h-16v-15.8h16v15.8z m0-31.6h-16v-15.8h16v15.8z m0-31.6h-16v-15.8h16v15.8z m0-31.7h-16V459h16v15.8z m0-31.6h-16v-15.8h16v15.8z m0-31.6h-16v-15.8h16v15.8z m0-31.6h-16v-15.8h16V380z m0-31.6h-16v-15.8h16v15.8z m0-31.6h-16V301h16v15.8z m0-31.6h-16v-15.8h16v15.8z m0-31.6h-16v-15.8h16v15.8zM124.6 206h16v16h-16zM488 222h-15.8v-16H488v16z m-31.6 0h-15.8v-16h15.8v16z m-31.6 0H409v-16h15.8v16z m-31.6 0h-15.8v-16h15.8v16z m-31.5 0h-15.8v-16h15.8v16z m-31.6 0h-15.8v-16h15.8v16z m-31.6 0h-15.8v-16h15.8v16z m-31.6 0h-15.8v-16h15.8v16z m-31.6 0h-15.8v-16h15.8v16z m-31.5 0H188v-16h15.8v16z m-31.6 0h-15.8v-16h15.8v16zM503.7 206h8v16h-8zM333.7 957.6l-7.6-14.1 185.7-100.9 182 101-7.8 14-174.3-96.8z"
        fill="#0A0408"
      />
      <path
        d="M754.6 537.7c0 74.9-60.7 135.6-135.6 135.6s-135.6-60.7-135.6-135.6S544.1 402.1 619 402.1v135.6h135.6z"
        fill="#55B7A8"
      />
      <path
        d="M619 681.4c-79.2 0-143.6-64.4-143.6-143.6S539.8 394.1 619 394.1h8v135.6h135.6v8c0 79.2-64.4 143.7-143.6 143.7z m-8-271c-66.7 4.1-119.6 59.7-119.6 127.4 0 70.4 57.3 127.6 127.6 127.6 67.7 0 123.2-53 127.4-119.6H611V410.4z"
        fill="#0A0408"
      />
      <path
        d="M794.5 513.8H642.9V362.2h8c79.2 0 143.6 64.4 143.6 143.6v8z m-135.6-16h119.4c-4-64-55.4-115.4-119.4-119.4v119.4z"
        fill="#0A0408"
      />
      <path
        d="M750.4 477.8c0-39.5-32-71.5-71.5-71.5v71.5h71.5z"
        fill="#DC444A"
      />
      <path
        d="M229.1 583.2h16v90.2h-16zM288.7 411.5h16v261.9h-16zM348.3 512.5h16v160.9h-16zM407.9 613.5h16v59.9h-16z"
        fill="#0A0408"
      />
      <path d="M106.9 188.3h51.4v51.4h-51.4z" fill="#DC444A" />
      <path
        d="M166.3 247.7H98.9v-67.4h67.4v67.4z m-51.4-16h35.4v-35.4h-35.4v35.4z"
        fill="#0A0408"
      />
      <path d="M106.9 791h51.4v51.4h-51.4z" fill="#DC444A" />
      <path
        d="M166.3 850.4H98.9V783h67.4v67.4z m-51.4-16h35.4V799h-35.4v35.4z"
        fill="#0A0408"
      />
      <path d="M865.2 188.3h51.4v51.4h-51.4z" fill="#DC444A" />
      <path
        d="M924.6 247.7h-67.4v-67.4h67.4v67.4z m-51.4-16h35.4v-35.4h-35.4v35.4z"
        fill="#0A0408"
      />
      <path d="M865.2 791h51.4v51.4h-51.4z" fill="#DC444A" />
      <path
        d="M924.6 850.4h-67.4V783h67.4v67.4z m-51.4-16h35.4V799h-35.4v35.4z"
        fill="#0A0408"
      />
    </svg>
  ),
  apiInterface: (
    <svg
      xmlns="http://www.w3.org/2000/svg"
      width="100%"
      height="100%"
      className="pointer-events-none"
      viewBox="0 0 1024 1024">
      <path d="M432.4 453.5l-17 46.7h34.4z" fill="#FFFFFF" />
      <path
        d="M725.3 259.7H312.2c-16.5 0-30 13.5-30 30v413.1c0 16.5 13.5 30 30 30h413.1c16.5 0 30-13.5 30-30V289.7c0-16.6-13.5-30-30-30z m-98.8 164.5h25.4V550h-25.4V424.2z m-116.5 0h40.8c15.5 0 25.5 0.6 30.2 1.9 7.2 1.9 13.2 6 18.1 12.3 4.9 6.3 7.3 14.5 7.3 24.5 0 7.7-1.4 14.2-4.2 19.5s-6.4 9.4-10.7 12.4c-4.3 3-8.7 5-13.2 6-6.1 1.2-14.8 1.8-26.4 1.8h-16.6V550H510V424.2z m-90.7 0h26.9L496.5 550h-27.6l-11-28.6h-50.3L397.2 550h-27l49.1-125.8z m229.1 273.3H352.6c-19.4 0-35.1-15.7-35.1-35.1v-295c0-5.5 4.5-10 10-10s10 4.5 10 10v295c0 8.3 6.8 15.1 15.1 15.1h295.8c5.5 0 10 4.5 10 10s-4.4 10-10 10z"
        fill="#FFFFFF"
      />
      <path
        d="M569.4 479.2c3.4-1.3 6-3.4 7.9-6.2 1.9-2.8 2.9-6.1 2.9-9.8 0-4.6-1.3-8.4-4-11.3-2.7-3-6.1-4.8-10.2-5.6-3-0.6-9.1-0.9-18.3-0.9h-12.3v35.7h13.9c10 0.1 16.7-0.6 20.1-1.9z"
        fill="#FFFFFF"
      />
      <path
        d="M648.4 677.5H352.6c-8.3 0-15.1-6.8-15.1-15.1v-295c0-5.5-4.5-10-10-10s-10 4.5-10 10v295c0 19.4 15.7 35.1 35.1 35.1h295.8c5.5 0 10-4.5 10-10s-4.4-10-10-10z"
        fill="#06F3FF"
      />
      <path
        d="M865 386.5c11 0 20-9 20-20s-9-20-20-20h-69.7v-56.8c0-38.6-31.4-70-70-70h-27.8v-67.3c0-11-9-20-20-20s-20 9-20 20v67.3H611v-67.3c0-11-9-20-20-20s-20 9-20 20v67.3h-46.5v-67.3c0-11-9-20-20-20s-20 9-20 20v67.3H438v-67.3c0-11-9-20-20-20s-20 9-20 20v67.3h-85.8c-38.6 0-70 31.4-70 70v56.8h-69.7c-11 0-20 9-20 20s9 20 20 20h69.7V433h-69.7c-11 0-20 9-20 20s9 20 20 20h69.7v46.5h-69.7c-11 0-20 9-20 20s9 20 20 20h69.7V606h-69.7c-11 0-20 9-20 20s9 20 20 20h69.7v56.8c0 38.6 31.4 70 70 70H343v72.5c0 11 9 20 20 20s20-9 20-20v-72.5h46.5v72.5c0 11 9 20 20 20s20-9 20-20v-72.5H516v72.5c0 11 9 20 20 20s20-9 20-20v-72.5h46.5v72.5c0 11 9 20 20 20s20-9 20-20v-72.5h82.8c38.6 0 70-31.4 70-70V646H865c11 0 20-9 20-20s-9-20-20-20h-69.7v-46.5H865c11 0 20-9 20-20s-9-20-20-20h-69.7V473H865c11 0 20-9 20-20s-9-20-20-20h-69.7v-46.5H865zM755.3 702.7c0 16.5-13.5 30-30 30H312.2c-16.5 0-30-13.5-30-30v-413c0-16.5 13.5-30 30-30h413.1c16.5 0 30 13.5 30 30v413z"
        fill="#005BFF"
      />
      <path
        d="M407.6 521.4h50.3l11 28.6h27.6l-50.4-125.8h-26.9l-49 125.8h27l10.4-28.6z m24.8-67.9l17.3 46.7h-34.3l17-46.7zM535.4 502.6H552c11.5 0 20.3-0.6 26.4-1.8 4.5-1 8.9-3 13.2-6 4.3-3 7.9-7.1 10.7-12.4s4.2-11.8 4.2-19.5c0-10-2.4-18.2-7.3-24.5-4.9-6.3-10.9-10.4-18.1-12.3-4.7-1.3-14.8-1.9-30.2-1.9H510V550h25.4v-47.4z m0-57.1h12.3c9.2 0 15.2 0.3 18.3 0.9 4.1 0.7 7.5 2.6 10.2 5.6 2.7 3 4 6.8 4 11.3 0 3.7-1 7-2.9 9.8-1.9 2.8-4.6 4.9-7.9 6.2-3.4 1.3-10.1 2-20.1 2h-13.9v-35.8zM626.5 424.2h25.4V550h-25.4z"
        fill="#005BFF"
      />
    </svg>
  ),
  availability: (
    <svg
      xmlns="http://www.w3.org/2000/svg"
      width="100%"
      height="100%"
      className="pointer-events-none"
      viewBox="0 0 1024 1024">
      <path
        d="M854.7 828.1H169.9c-38.9 0-70.5-31.6-70.5-70.5v-499c0-38.9 31.6-70.5 70.5-70.5h684.7c38.9 0 70.5 31.6 70.5 70.5v499c0.1 38.9-31.5 70.5-70.4 70.5z"
        fill="#FFFFFF"
      />
      <path
        d="M885.2 258.1c0-16.5-13.5-30-30-30H169.4c-16.5 0-30 13.5-30 30v120.1h745.7V258.1z m-649.7 96.1c-28.2 0-51.2-23-51.2-51.2s23-51.2 51.2-51.2 51.2 23 51.2 51.2-22.9 51.2-51.2 51.2z m281.8-6.8H374.7c-24.1 0-43.7-19.6-43.7-43.7s19.6-43.7 43.7-43.7h142.6c24.1 0 43.7 19.6 43.7 43.7s-19.6 43.7-43.7 43.7z"
        fill="#E6E6E6"
      />
      <path
        d="M213.3 752.8h298.8c5.5 0 10-4.5 10-10s-4.5-10-10-10H213.3c-8.5 0-15.4-6.9-15.4-15.4V524.6c0-5.5-4.5-10-10-10s-10 4.5-10 10v192.9c0.1 19.4 15.9 35.3 35.4 35.3z"
        fill="#06F3FF"
      />
      <path
        d="M235.5 271.8c-17.2 0-31.2 14-31.2 31.2s14 31.2 31.2 31.2 31.2-14 31.2-31.2-14-31.2-31.2-31.2z"
        fill="#FFFFFF"
      />
      <path
        d="M235.5 251.8c-28.2 0-51.2 23-51.2 51.2s23 51.2 51.2 51.2 51.2-23 51.2-51.2-22.9-51.2-51.2-51.2z m0 82.4c-17.2 0-31.2-14-31.2-31.2s14-31.2 31.2-31.2 31.2 14 31.2 31.2-14 31.2-31.2 31.2z"
        fill="#005BFF"
      />
      <path
        d="M517.3 280.1H374.7c-13 0-23.7 10.6-23.7 23.7s10.6 23.7 23.7 23.7h142.6c13 0 23.7-10.6 23.7-23.7s-10.7-23.7-23.7-23.7z"
        fill="#FFFFFF"
      />
      <path
        d="M517.3 260.1H374.7c-24.1 0-43.7 19.6-43.7 43.7s19.6 43.7 43.7 43.7h142.6c24.1 0 43.7-19.6 43.7-43.7s-19.6-43.7-43.7-43.7z m0 67.3H374.7c-13 0-23.7-10.6-23.7-23.7s10.6-23.7 23.7-23.7h142.6c13 0 23.7 10.6 23.7 23.7s-10.7 23.7-23.7 23.7z"
        fill="#005BFF"
      />
      <path
        d="M855.2 188.1H169.4c-38.6 0-70 31.4-70 70v500c0 38.6 31.4 70 70 70h685.7c38.6 0 70-31.4 70-70v-500c0.1-38.6-31.3-70-69.9-70z m30 570c0 16.5-13.5 30-30 30H169.4c-16.5 0-30-13.5-30-30V398.2h745.7v359.9z m0-379.9H139.5V258.1c0-16.5 13.5-30 30-30h685.7c16.5 0 30 13.5 30 30v120.1z"
        fill="#005BFF"
      />
      <path
        d="M459.9 624.6l-114.3-45.3 114.3-43.7v-46.5L296.1 560v39.5l163.8 71.2zM568.7 454.8h-34.4L475.1 702h33.8zM747.9 560.3l-164-70.9v45.8l114.4 44.5-114.4 45v46.2l164-71.4z"
        fill="#005BFF"
      />
    </svg>
  ),
  discounted: (
    <svg
      xmlns="http://www.w3.org/2000/svg"
      width="100%"
      height="100%"
      className="pointer-events-none"
      viewBox="0 0 1024 1024"
      fill="#000000">
      <path
        d="M1015.882 951.784a8.014 8.014 0 0 1-7.968-7.404l-47.988-655.872a8.012 8.012 0 0 1 7.404-8.56c3.952-0.304 8.232 2.982 8.56 7.388l47.99 655.856a8.008 8.008 0 0 1-7.404 8.56c-0.186 0.032-0.39 0.032-0.594 0.032z"
        fill=""
      />
      <path
        d="M1015.898 951.784H376.022c-4.42 0-7.998-3.576-7.998-7.998s3.578-7.998 7.998-7.998h639.876c4.42 0 7.998 3.576 7.998 7.998s-3.578 7.998-7.998 7.998z"
        fill=""
      />
      <path
        d="M376.038 951.784c-0.204 0-0.406 0-0.592-0.032a8.008 8.008 0 0 1-7.406-8.56l47.99-655.856c0.328-4.406 4.532-7.716 8.562-7.388a8.014 8.014 0 0 1 7.406 8.56L384.008 944.38a8.022 8.022 0 0 1-7.97 7.404z"
        fill=""
      />
      <path
        d="M520.008 295.92h-95.996c-4.42 0-8-3.578-8-7.998a7.994 7.994 0 0 1 8-7.998h95.996a7.986 7.986 0 0 1 7.992 7.998 7.988 7.988 0 0 1-7.992 7.998zM967.908 295.92h-95.98a7.994 7.994 0 0 1-7.998-7.998 7.994 7.994 0 0 1 7.998-7.998h95.98a7.994 7.994 0 0 1 7.998 7.998 7.994 7.994 0 0 1-7.998 7.998zM791.946 295.92h-191.96a7.994 7.994 0 0 1-7.998-7.998 7.992 7.992 0 0 1 7.998-7.998h191.96a7.992 7.992 0 0 1 7.996 7.998 7.992 7.992 0 0 1-7.996 7.998zM967.908 919.79H424.012c-4.42 0-8-3.576-8-7.996 0-4.422 3.578-8 8-8h543.896a7.994 7.994 0 0 1 7.998 8 7.994 7.994 0 0 1-7.998 7.996z"
        fill=""
      />
      <path
        d="M552.01 375.902a7.99 7.99 0 0 1-7.982-8.662c1-12.042 26.056-295.024 151.938-295.024 125.878 0 150.938 282.98 151.938 295.024a7.988 7.988 0 0 1-7.296 8.63 7.926 7.926 0 0 1-8.638-7.302c-0.234-2.802-24.728-280.356-136.002-280.356-111.32 0-135.77 277.552-136.004 280.356a7.992 7.992 0 0 1-7.954 7.334zM344.028 903.792H8.098c-4.422 0-8-3.576-8-7.998a7.994 7.994 0 0 1 8-7.998h335.93a7.994 7.994 0 0 1 7.998 7.998 7.992 7.992 0 0 1-7.998 7.998z"
        fill=""
      />
      <path
        d="M8.114 903.792c-0.218 0-0.422 0-0.624-0.032a7.988 7.988 0 0 1-7.358-8.592l31.994-415.906c0.328-4.412 4.546-7.584 8.576-7.358a7.994 7.994 0 0 1 7.358 8.592L16.066 896.42a7.984 7.984 0 0 1-7.952 7.372z"
        fill=""
      />
      <path
        d="M376.022 487.88H40.09a7.994 7.994 0 0 1-7.998-8 7.994 7.994 0 0 1 7.998-7.998H376.02c4.42 0 8 3.578 8 7.998 0 4.422-3.578 8-7.998 8zM344.028 871.8H56.088a7.994 7.994 0 0 1-7.998-8 7.992 7.992 0 0 1 7.998-7.996h287.94a7.992 7.992 0 0 1 7.998 7.996c0 4.422-3.576 8-7.998 8zM320.034 711.834c-125.084 0-159.482-164.732-159.81-166.404a7.998 7.998 0 0 1 6.264-9.404c4.216-0.842 8.544 1.922 9.42 6.282 0.312 1.53 32.18 153.53 144.126 153.53 7.64 0 15.2-0.718 22.48-2.124 4.266-0.874 8.514 2 9.374 6.344a8.01 8.01 0 0 1-6.342 9.374 135.46 135.46 0 0 1-25.512 2.402zM376.022 455.902H56.088a7.994 7.994 0 0 1-7.998-7.998 7.994 7.994 0 0 1 7.998-7.998h319.934a7.998 7.998 0 1 1 0 15.996zM951.91 263.926h-95.978a7.992 7.992 0 0 1-7.998-7.998 7.994 7.994 0 0 1 7.998-7.998h95.978c4.422 0 8 3.578 8 7.998a7.994 7.994 0 0 1-8 7.998zM535.996 263.926h-95.988a7.992 7.992 0 0 1-7.998-7.998 7.994 7.994 0 0 1 7.998-7.998h95.988c4.422 0 8 3.578 8 7.998a7.994 7.994 0 0 1-8 7.998zM775.948 263.926H615.98a7.992 7.992 0 0 1-7.998-7.998 7.994 7.994 0 0 1 7.998-7.998h159.966a7.994 7.994 0 0 1 7.998 7.998 7.988 7.988 0 0 1-7.996 7.998z"
        fill=""
      />
      <path
        d="M551.962 791.942a7.994 7.994 0 0 1-5.654-13.652l287.94-287.942a7.996 7.996 0 1 1 11.31 11.31l-287.942 287.94a7.968 7.968 0 0 1-5.654 2.344z"
        fill=""
      />
      <path
        d="M783.946 791.942c-35.29 0-63.986-28.712-63.986-63.986s28.698-63.986 63.986-63.986 63.988 28.712 63.988 63.986-28.7 63.986-63.988 63.986z m0-111.978c-26.462 0-47.988 21.528-47.988 47.99s21.526 47.99 47.988 47.99c26.464 0 47.99-21.528 47.99-47.99s-21.526-47.99-47.99-47.99z"
        fill=""
      />
      <path
        d="M607.982 615.978c-35.29 0-63.986-28.712-63.986-63.986 0-35.282 28.698-63.986 63.986-63.986s63.986 28.706 63.986 63.986c0 35.274-28.696 63.986-63.986 63.986z m0-111.976c-26.462 0-47.99 21.526-47.99 47.99 0 26.462 21.528 47.988 47.99 47.988s47.99-21.526 47.99-47.988c0-26.464-21.526-47.99-47.99-47.99z"
        fill=""
      />
    </svg>
  ),
  balloonBusiness: (
    <svg
      xmlns="http://www.w3.org/2000/svg"
      width="100%"
      height="100%"
      className="pointer-events-none"
      viewBox="0 0 1024 1024"
      fill="#000000">
      <path
        d="M647.902 742.68a7.984 7.984 0 0 1-7.46-5.122c-1.594-4.108 0.468-8.744 4.59-10.338 142.586-55.084 234.708-189.754 234.708-343.05C879.738 181.392 714.762 16.416 512 16.416c-202.77 0-367.738 164.976-367.738 367.754 0 153.25 92.106 287.904 234.644 343.02a7.988 7.988 0 0 1 4.576 10.338 8.004 8.004 0 0 1-10.336 4.558c-148.752-57.506-244.872-198-244.872-357.916C128.274 172.57 300.416 0.428 512 0.428c211.582 0 383.726 172.142 383.726 383.742 0 159.962-96.148 300.472-244.95 357.978-0.936 0.36-1.904 0.532-2.874 0.532zM631.914 1023.572H392.084c-22.038 0-39.97-17.924-39.97-39.97v-127.91a7.99 7.99 0 0 1 7.994-7.994h303.782a7.99 7.99 0 0 1 7.996 7.994v127.91c0 22.046-17.926 39.97-39.972 39.97z m-263.812-159.884v119.914c0 13.224 10.758 23.982 23.982 23.982h239.83c13.226 0 23.984-10.758 23.984-23.982v-119.914H368.102z"
        fill=""
      />
      <path
        d="M456.04 863.688a7.99 7.99 0 0 1-7.994-7.996v-79.816a7.99 7.99 0 0 1 7.994-7.996 7.99 7.99 0 0 1 7.994 7.996v79.816a7.99 7.99 0 0 1-7.994 7.996zM567.96 863.688a7.992 7.992 0 0 1-7.996-7.996v-79.816c0-4.42 3.578-7.996 7.996-7.996s7.992 3.576 7.992 7.996v79.816a7.988 7.988 0 0 1-7.992 7.996zM647.902 863.688a7.988 7.988 0 0 1-7.992-7.996v-121.008a7.986 7.986 0 0 1 7.992-7.992 7.988 7.988 0 0 1 7.996 7.992v121.008a7.99 7.99 0 0 1-7.996 7.996z"
        fill=""
      />
      <path
        d="M647.902 783.868H376.096a7.988 7.988 0 0 1-7.994-7.992 7.99 7.99 0 0 1 7.994-7.996h271.806a7.99 7.99 0 0 1 7.996 7.996 7.988 7.988 0 0 1-7.996 7.992z"
        fill=""
      />
      <path
        d="M376.096 863.688a7.99 7.99 0 0 1-7.994-7.996v-121.054a7.988 7.988 0 0 1 7.994-7.992 7.988 7.988 0 0 1 7.996 7.992v121.054a7.99 7.99 0 0 1-7.996 7.996zM200.224 392.148a7.99 7.99 0 0 1-7.996-7.994c0-176.32 143.452-319.772 319.772-319.772a7.994 7.994 0 1 1 0 15.99c-167.506 0-303.784 136.278-303.784 303.784a7.986 7.986 0 0 1-7.992 7.992zM456.04 751.89a7.988 7.988 0 0 1-7.994-7.994v-127.908a7.99 7.99 0 0 1 7.994-7.994 7.988 7.988 0 0 1 7.994 7.994v127.908a7.988 7.988 0 0 1-7.994 7.994zM567.96 751.89a7.99 7.99 0 0 1-7.996-7.994v-127.908c0-4.418 3.578-7.994 7.996-7.994s7.992 3.576 7.992 7.994v127.908a7.986 7.986 0 0 1-7.992 7.994z"
        fill=""
      />
      <path
        d="M456.04 623.982a7.928 7.928 0 0 1-6.066-2.794 7.966 7.966 0 0 1 0.868-11.258l55.958-47.964c3.358-2.874 8.412-2.5 11.266 0.858a7.962 7.962 0 0 1-0.868 11.258l-55.96 47.966a7.87 7.87 0 0 1-5.198 1.934z"
        fill=""
      />
      <path
        d="M567.96 623.982a7.886 7.886 0 0 1-5.2-1.936L506.8 574.08c-3.356-2.874-3.746-7.9-0.866-11.258s7.932-3.73 11.264-0.858l55.96 47.964a7.96 7.96 0 0 1 0.86 11.258 7.878 7.878 0 0 1-6.058 2.796zM456.04 592.006a7.99 7.99 0 0 1-7.994-7.994v-167.88a7.99 7.99 0 0 1 7.994-7.994 7.988 7.988 0 0 1 7.994 7.994v167.88a7.988 7.988 0 0 1-7.994 7.994zM567.96 592.006a7.992 7.992 0 0 1-7.996-7.994v-167.88c0-4.418 3.578-7.994 7.996-7.994s7.992 3.576 7.992 7.994v167.88a7.988 7.988 0 0 1-7.992 7.994z"
        fill=""
      />
      <path
        d="M456.04 424.124a7.99 7.99 0 0 1-7.994-7.994c0-26.45-21.516-47.966-47.964-47.966-26.452 0-47.966 21.516-47.966 47.966a7.99 7.99 0 0 1-7.994 7.994 7.99 7.99 0 0 1-7.994-7.994c0-35.264 28.69-63.956 63.956-63.956 35.264 0 63.954 28.692 63.954 63.956a7.994 7.994 0 0 1-7.998 7.994zM679.878 424.124a7.988 7.988 0 0 1-7.992-7.994c0-26.45-21.516-47.966-47.964-47.966s-47.968 21.516-47.968 47.966c0 4.418-3.574 7.994-7.992 7.994s-7.996-3.576-7.996-7.994c0-35.264 28.7-63.956 63.958-63.956 35.254 0 63.954 28.692 63.954 63.956a7.994 7.994 0 0 1-8 7.994zM535.984 863.688h-47.966a7.99 7.99 0 0 1-7.996-7.996V823.84a7.99 7.99 0 0 1 7.996-7.994h47.966a7.988 7.988 0 0 1 7.992 7.994v31.852a7.988 7.988 0 0 1-7.992 7.996z m-39.974-15.99h31.978v-15.864h-31.978v15.864z"
        fill=""
      />
      <path
        d="M512 815.846c-19.22 0-31.978-24.06-31.978-39.97a7.99 7.99 0 0 1 7.996-7.996 7.988 7.988 0 0 1 7.992 7.996c0 9.898 8.27 23.982 15.99 23.982 7.722 0 15.988-14.084 15.988-23.982 0-4.42 3.578-7.996 7.996-7.996s7.992 3.576 7.992 7.996c0 15.91-12.754 39.97-31.976 39.97zM400.082 480.084c-35.264 0-63.956-28.69-63.956-63.954a7.99 7.99 0 0 1 7.994-7.994 7.99 7.99 0 0 1 7.994 7.994c0 26.45 21.516 47.966 47.966 47.966 4.418 0 7.994 3.576 7.994 7.994s-3.574 7.994-7.992 7.994zM623.922 480.084c-4.418 0-7.996-3.576-7.996-7.994s3.578-7.994 7.996-7.994c26.45 0 47.964-21.516 47.964-47.966a7.988 7.988 0 0 1 7.992-7.994 7.99 7.99 0 0 1 7.996 7.994c0.002 35.264-28.698 63.954-63.952 63.954z"
        fill=""
      />
      <path
        d="M424.064 480.084h-23.982c-4.42 0-7.996-3.576-7.996-7.994s3.576-7.994 7.996-7.994h23.982c4.418 0 7.994 3.576 7.994 7.994s-3.576 7.994-7.994 7.994zM623.922 480.084h-23.984c-4.418 0-7.992-3.576-7.992-7.994s3.574-7.994 7.992-7.994h23.984c4.418 0 7.992 3.576 7.992 7.994s-3.574 7.994-7.992 7.994zM535.984 480.084h-47.966c-4.42 0-7.996-3.576-7.996-7.994s3.576-7.994 7.996-7.994h47.966c4.418 0 7.992 3.576 7.992 7.994s-3.574 7.994-7.992 7.994zM631.914 927.766H392.084a7.99 7.99 0 0 1-7.994-7.994 7.988 7.988 0 0 1 7.994-7.994h239.83a7.99 7.99 0 0 1 7.996 7.994 7.992 7.992 0 0 1-7.996 7.994zM631.914 975.73H392.084a7.988 7.988 0 0 1-7.994-7.992 7.99 7.99 0 0 1 7.994-7.996h239.83a7.992 7.992 0 0 1 7.996 7.996 7.99 7.99 0 0 1-7.996 7.992z"
        fill=""
      />
      <path
        d="M392.084 991.718a7.988 7.988 0 0 1-7.994-7.992v-15.988a7.99 7.99 0 0 1 7.994-7.996 7.99 7.99 0 0 1 7.996 7.996v15.988a7.988 7.988 0 0 1-7.996 7.992zM440.052 991.718a7.988 7.988 0 0 1-7.994-7.992v-15.988c0-4.42 3.574-7.996 7.994-7.996s7.994 3.576 7.994 7.996v15.988a7.988 7.988 0 0 1-7.994 7.992zM488.018 991.718a7.988 7.988 0 0 1-7.996-7.992v-15.988a7.99 7.99 0 0 1 7.996-7.996 7.988 7.988 0 0 1 7.992 7.996v15.988a7.986 7.986 0 0 1-7.992 7.992zM535.984 991.718a7.99 7.99 0 0 1-7.996-7.992v-15.988c0-4.42 3.578-7.996 7.996-7.996s7.992 3.576 7.992 7.996v15.988a7.986 7.986 0 0 1-7.992 7.992zM583.95 991.718a7.99 7.99 0 0 1-7.996-7.992v-15.988c0-4.42 3.578-7.996 7.996-7.996s7.996 3.576 7.996 7.996v15.988a7.99 7.99 0 0 1-7.996 7.992zM631.914 991.718a7.986 7.986 0 0 1-7.992-7.992v-15.988c0-4.42 3.574-7.996 7.992-7.996s7.996 3.576 7.996 7.996v15.988a7.99 7.99 0 0 1-7.996 7.992zM392.084 943.754a7.988 7.988 0 0 1-7.994-7.994v-15.988a7.988 7.988 0 0 1 7.994-7.994 7.99 7.99 0 0 1 7.996 7.994v15.988a7.988 7.988 0 0 1-7.996 7.994zM440.052 943.754a7.988 7.988 0 0 1-7.994-7.994v-15.988c0-4.42 3.574-7.994 7.994-7.994s7.994 3.574 7.994 7.994v15.988a7.988 7.988 0 0 1-7.994 7.994zM488.018 943.754a7.99 7.99 0 0 1-7.996-7.994v-15.988a7.99 7.99 0 0 1 7.996-7.994 7.988 7.988 0 0 1 7.992 7.994v15.988a7.988 7.988 0 0 1-7.992 7.994zM535.984 943.754a7.99 7.99 0 0 1-7.996-7.994v-15.988c0-4.42 3.578-7.994 7.996-7.994s7.992 3.574 7.992 7.994v15.988a7.988 7.988 0 0 1-7.992 7.994zM583.95 943.754a7.99 7.99 0 0 1-7.996-7.994v-15.988c0-4.42 3.578-7.994 7.996-7.994s7.996 3.574 7.996 7.994v15.988a7.99 7.99 0 0 1-7.996 7.994zM631.914 943.754a7.988 7.988 0 0 1-7.992-7.994v-15.988c0-4.42 3.574-7.994 7.992-7.994s7.996 3.574 7.996 7.994v15.988a7.99 7.99 0 0 1-7.996 7.994zM376.096 895.79a7.99 7.99 0 0 1-7.994-7.996 7.988 7.988 0 0 1 7.994-7.992c43.172 0 58.256-13.618 58.396-13.742 3.186-2.98 8.22-2.902 11.258 0.25a7.922 7.922 0 0 1-0.046 11.148c-1.872 1.874-19.768 18.332-69.608 18.332zM647.902 895.79c-49.84 0-67.73-16.458-69.606-18.332a7.994 7.994 0 1 1 11.21-11.398c0.438 0.406 15.644 13.742 58.394 13.742a7.988 7.988 0 0 1 7.996 7.992 7.988 7.988 0 0 1-7.994 7.996z"
        fill=""
      />
      <path
        d="M512 895.79c-42.792 0-60.864-17.582-61.614-18.332a7.988 7.988 0 0 1 0-11.304 7.988 7.988 0 0 1 11.242-0.062c0.406 0.376 15.124 13.71 50.372 13.71 35.57 0 50.23-13.586 50.37-13.71 3.184-2.996 8.226-2.964 11.274 0.156 3.058 3.138 3.058 8.122-0.032 11.21-0.748 0.75-18.83 18.332-61.612 18.332zM695.872 943.754c-13.226 0-23.984-10.758-23.984-23.982 0-9.306 7.48-39.97 23.984-39.97s23.98 30.664 23.98 39.97c0 13.224-10.758 23.982-23.98 23.982z m0-47.294c-3.438 3.824-7.996 16.706-7.996 23.31a8.01 8.01 0 0 0 7.996 7.994 8.008 8.008 0 0 0 7.992-7.994c0-6.604-4.56-19.484-7.992-23.31zM328.132 943.754c-13.224 0-23.982-10.758-23.982-23.982 0-9.306 7.478-39.97 23.982-39.97s23.982 30.664 23.982 39.97c0 13.224-10.758 23.982-23.982 23.982z m0-47.294c-3.428 3.824-7.994 16.706-7.994 23.31a8.006 8.006 0 0 0 7.994 7.994 8.006 8.006 0 0 0 7.994-7.994c0-6.604-4.566-19.484-7.994-23.31zM328.14 879.8a7.984 7.984 0 0 1-7.144-4.404 7.976 7.976 0 0 1 3.536-10.726l31.978-16.114c3.926-2.014 8.744-0.422 10.734 3.544a7.978 7.978 0 0 1-3.536 10.726l-31.978 16.114c-1.154 0.58-2.38 0.86-3.59 0.86zM695.872 879.8a8 8 0 0 1-3.594-0.86l-31.976-16.114a7.98 7.98 0 0 1-3.542-10.726 7.936 7.936 0 0 1 10.726-3.544l31.976 16.114a7.978 7.978 0 0 1 3.542 10.726 7.97 7.97 0 0 1-7.132 4.404z"
        fill=""
      />
    </svg>
  ),
  bank: (
    <svg
      xmlns="http://www.w3.org/2000/svg"
      width="100%"
      height="100%"
      className="pointer-events-none"
      viewBox="0 0 1024 1024">
      <path
        d="M511.8 154.1L916 277v45.7H108V277l403.8-122.9m0-46L64 244.4v122.3h896V244.4L511.8 108.1zM113 831.4h798v16H113z"
        fill="#39393A"
      />
      <path d="M113 391.1h798v16H113z" fill="#E73B37" />
      <path
        d="M64.3 871.8h895.3v44H64.3zM204.2 475.6v287.3h52v44h-120v-44h52V475.6h-52v-44h120v44zM414.7 475.6v287.3h52v44h-120v-44h52V475.6h-52v-44h120v44zM625.2 475.6v287.3h52v44h-120v-44h52V475.6h-52v-44h120v44zM835.8 475.6v287.3h52v44h-120v-44h52V475.6h-52v-44h120v44z"
        fill="#39393A"
      />
    </svg>
  ),
  locked: (
    <svg
      xmlns="http://www.w3.org/2000/svg"
      width="100%"
      height="100%"
      className="pointer-events-none"
      viewBox="0 0 281.25 281.25">
      <defs id="defs4" />

      <g id="layer1" transform="translate(7276.1064,-5856.7805)">
        <path
          d="m -7177.6927,5895.4575 a 4.6879687,4.6879687 0 0 0 -4.6875,4.6875 v 60.1813 h -28.1012 a 4.6879687,4.6879687 0 0 0 -4.6875,4.6875 v 129.7394 a 4.6879687,4.6879687 0 0 0 4.6875,4.6875 h 150 a 4.6879687,4.6879687 0 0 0 4.6875,-4.6875 v -129.7394 a 4.6879687,4.6879687 0 0 0 -4.6875,-4.6875 h -28.1012 v -60.1813 a 4.6879687,4.6879687 0 0 0 -4.6875,-4.6875 z m 4.6875,9.375 h 75.0476 v 55.492 h -75.0476 z m -32.7887,64.8688 h 140.625 v 120.3644 h -140.625 z m 70.3125,23.0182 c -13.8132,0 -25.1129,11.2978 -25.1129,25.1111 0,12.2114 8.8337,22.4505 20.4254,24.6625 v 19.8687 a 4.6875,4.6875 0 0 0 4.6875,4.6875 4.6875,4.6875 0 0 0 4.6875,-4.6875 v -19.8687 c 11.5922,-2.2113 20.4254,-12.4505 20.4254,-24.6625 0,-13.8132 -11.2997,-25.111 -25.1129,-25.1111 z m 0,9.375 c 8.7466,1e-4 15.7379,6.9895 15.7379,15.7361 0,8.7466 -6.9913,15.7361 -15.7379,15.7361 -8.7466,0 -15.7379,-6.9895 -15.7379,-15.7361 0,-8.7466 6.9913,-15.7361 15.7379,-15.7361 z"
          id="rect6087"
          style={{
            color: "#000000",
            fill: "#3d3d3d",
            fillOpacity: "1",
            fillRule: "evenodd",
            strokeLinecap: "round",
            strokeLinejoin: "round",
          }}
        />
      </g>
    </svg>
  ),
  unlocked: (
    <svg
      xmlns="http://www.w3.org/2000/svg"
      width="100%"
      height="100%"
      className="pointer-events-none"
      viewBox="0 0 281.25 281.25">
      <defs id="defs4" />

      <g id="layer1" transform="translate(6984.8564,-5856.7805)">
        <path
          d="m -6886.4433,5895.4136 a 4.6879687,4.6879687 0 0 0 -4.6875,4.6875 v 60.1794 h -28.0994 a 4.6879687,4.6879687 0 0 0 -4.6875,4.6875 v 129.7412 a 4.6879687,4.6879687 0 0 0 4.6875,4.6875 h 150 a 4.6879687,4.6879687 0 0 0 4.6875,-4.6875 V 5964.968 a 4.6879687,4.6879687 0 0 0 -4.6875,-4.6875 h -112.5256 v -55.4919 h 75.0494 v 15.6702 a 4.6875,4.6875 0 0 0 4.6875,4.6875 4.6875,4.6875 0 0 0 4.6875,-4.6875 v -20.3577 a 4.6879687,4.6879687 0 0 0 -4.6875,-4.6875 z m -28.0994,74.2419 h 140.625 v 120.3662 h -140.625 z m 70.3125,23.0182 c -13.8133,0 -25.113,11.2977 -25.1129,25.1111 0,12.2116 8.8335,22.4507 20.4254,24.6625 v 19.8688 a 4.6875,4.6875 0 0 0 4.6875,4.6875 4.6875,4.6875 0 0 0 4.6875,-4.6875 v -19.8688 c 11.5914,-2.212 20.4236,-12.4511 20.4236,-24.6625 0,-13.8133 -11.2978,-25.1111 -25.1111,-25.1111 z m 0,9.375 c 8.7467,0 15.7361,6.9894 15.7361,15.7361 0,8.7466 -6.9895,15.7361 -15.7361,15.7361 -8.7466,0 -15.7379,-6.9895 -15.7379,-15.7361 -1e-4,-8.7467 6.9913,-15.7361 15.7379,-15.7361 z"
          id="rect6080"
          style={{
            color: "#000000",
            fill: "#3d3d3d",
            fillOpacity: "1",
            fillRule: "evenodd",
            strokeLinecap: "round",
            strokeLinejoin: "round",
          }}
        />
      </g>
    </svg>
  ),
  list: (
    <svg
      xmlns="http://www.w3.org/2000/svg"
      width="100%"
      height="100%"
      className="pointer-events-none"
      viewBox="0 0 281.25 281.25">
      <defs id="defs4" />

      <g id="layer1" transform="translate(7276.1064,-3697.2496)">
        <g id="g23642" style={{ fill: "#3d3d3d", fillOpacity: "1" }}>
          <path
            d="m -7211.4766,3736.0898 c -14.2755,10e-5 -25.9492,11.6738 -25.9492,25.9493 0,14.2755 11.6737,25.9491 25.9492,25.9492 14.2756,0 25.9493,-11.6737 25.9493,-25.9492 0,-14.2756 -11.6737,-25.9493 -25.9493,-25.9493 z m 0,9.375 c 9.209,0 16.5743,7.3653 16.5743,16.5743 0,9.2089 -7.3653,16.5742 -16.5743,16.5742 -9.2088,0 -16.5742,-7.3654 -16.5742,-16.5742 0,-9.2089 7.3654,-16.5742 16.5742,-16.5743 z"
            id="path3266"
            style={{
              color: "#000000",
              fill: "#3d3d3d",
              fillOpacity: "1",
              fillRule: "evenodd",
              strokeLinecap: "round",
              strokeLinejoin: "round",
            }}
          />

          <path
            d="m -7167.4922,3743.8574 a 4.6875,4.6875 0 0 0 -4.6875,4.6875 4.6875,4.6875 0 0 0 4.6875,4.6875 h 129.2676 a 4.6875,4.6875 0 0 0 4.6875,-4.6875 4.6875,4.6875 0 0 0 -4.6875,-4.6875 z"
            id="path3268"
            style={{
              color: "#000000",
              fill: "#3d3d3d",
              fillOpacity: "1",
              fillRule: "evenodd",
              strokeLinecap: "round",
              strokeLinejoin: "round",
            }}
          />

          <path
            d="m -7167.4922,3770.8477 a 4.6875,4.6875 0 0 0 -4.6875,4.6875 4.6875,4.6875 0 0 0 4.6875,4.6875 h 53.5059 a 4.6875,4.6875 0 0 0 4.6875,-4.6875 4.6875,4.6875 0 0 0 -4.6875,-4.6875 z"
            id="path3270"
            style={{
              color: "#000000",
              fill: "#3d3d3d",
              fillOpacity: "1",
              fillRule: "evenodd",
              strokeLinecap: "round",
              strokeLinejoin: "round",
            }}
          />

          <path
            d="m -7211.4766,3811.9258 c -14.2755,0 -25.9492,11.6737 -25.9492,25.9492 0,14.2755 11.6737,25.9472 25.9492,25.9473 14.2756,0 25.9493,-11.6718 25.9493,-25.9473 0,-14.2755 -11.6737,-25.9492 -25.9493,-25.9492 z m 0,9.375 c 9.209,0 16.5743,7.3653 16.5743,16.5742 0,9.2089 -7.3653,16.5723 -16.5743,16.5723 -9.2088,-10e-5 -16.5742,-7.3634 -16.5742,-16.5723 0,-9.2089 7.3654,-16.5742 16.5742,-16.5742 z"
            id="circle3282"
            style={{
              color: "#000000",
              fill: "#3d3d3d",
              fillOpacity: "1",
              fillRule: "evenodd",
              strokeLinecap: "round",
              strokeLinejoin: "round",
            }}
          />

          <path
            d="m -7167.4922,3819.6914 a 4.6875,4.6875 0 0 0 -4.6875,4.6875 4.6875,4.6875 0 0 0 4.6875,4.6875 h 129.2676 a 4.6875,4.6875 0 0 0 4.6875,-4.6875 4.6875,4.6875 0 0 0 -4.6875,-4.6875 z"
            id="path3284"
            style={{
              color: "#000000",
              fill: "#3d3d3d",
              fillOpacity: "1",
              fillRule: "evenodd",
              strokeLinecap: "round",
              strokeLinejoin: "round",
            }}
          />

          <path
            d="m -7167.4922,3846.6816 a 4.6875,4.6875 0 0 0 -4.6875,4.6875 4.6875,4.6875 0 0 0 4.6875,4.6875 h 53.5059 a 4.6875,4.6875 0 0 0 4.6875,-4.6875 4.6875,4.6875 0 0 0 -4.6875,-4.6875 z"
            id="path3286"
            style={{
              color: "#000000",
              fill: "#3d3d3d",
              fillOpacity: "1",
              fillRule: "evenodd",
              strokeLinecap: "round",
              strokeLinejoin: "round",
            }}
          />

          <path
            d="m -7211.4766,3887.7617 c -14.2754,1e-4 -25.9491,11.6718 -25.9492,25.9473 0,14.2755 11.6737,25.9492 25.9492,25.9492 14.2756,0 25.9493,-11.6737 25.9493,-25.9492 -1e-4,-14.2755 -11.6738,-25.9473 -25.9493,-25.9473 z m 0,9.375 c 9.2089,0 16.5742,7.3634 16.5743,16.5723 0,9.2089 -7.3653,16.5742 -16.5743,16.5742 -9.2088,0 -16.5742,-7.3653 -16.5742,-16.5742 0,-9.2089 7.3654,-16.5723 16.5742,-16.5723 z"
            id="circle3292"
            style={{
              color: "#000000",
              fill: "#3d3d3d",
              fillOpacity: "1",
              fillRule: "evenodd",
              strokeLinecap: "round",
              strokeLinejoin: "round",
            }}
          />

          <path
            d="m -7167.4922,3895.5273 a 4.6875,4.6875 0 0 0 -4.6875,4.6875 4.6875,4.6875 0 0 0 4.6875,4.6875 h 129.2676 a 4.6875,4.6875 0 0 0 4.6875,-4.6875 4.6875,4.6875 0 0 0 -4.6875,-4.6875 z"
            id="path3294"
            style={{
              color: "#000000",
              fill: "#3d3d3d",
              fillOpacity: "1",
              fillRule: "evenodd",
              strokeLinecap: "round",
              strokeLinejoin: "round",
            }}
          />

          <path
            d="m -7167.4922,3922.5176 a 4.6875,4.6875 0 0 0 -4.6875,4.6875 4.6875,4.6875 0 0 0 4.6875,4.6875 h 53.5059 a 4.6875,4.6875 0 0 0 4.6875,-4.6875 4.6875,4.6875 0 0 0 -4.6875,-4.6875 z"
            id="path3296"
            style={{
              color: "#000000",
              fill: "#3d3d3d",
              fillOpacity: "1",
              fillRule: "evenodd",
              strokeLinecap: "round",
              strokeLinejoin: "round",
            }}
          />
        </g>
      </g>
    </svg>
  ),
  intoBox: (
    <svg
      xmlns="http://www.w3.org/2000/svg"
      width="100%"
      height="100%"
      className="pointer-events-none"
      viewBox="0 0 281.25 281.25">
      <defs id="defs4" />

      <g id="layer1" transform="translate(7276.1064,-4899.0259)">
        <path
          d="m -7229.8997,4937.7097 a 4.6879687,4.6879687 0 0 0 -4.6875,4.6875 v 197.5122 a 4.6879687,4.6879687 0 0 0 4.6856,4.6875 l 191.5174,0.031 a 4.6879687,4.6879687 0 0 0 4.6875,-4.8212 l -2.6807,-92.4133 a 4.6875,4.6875 0 0 0 -4.8193,-4.5484 4.6875,4.6875 0 0 0 -4.552,4.8212 l 2.5396,87.5867 -182.0031,-0.028 V 4947.084 h 85.0415 a 4.6875,4.6875 0 0 0 4.6875,-4.6875 4.6875,4.6875 0 0 0 -4.6875,-4.6875 z m 191.5173,0 a 4.6875,4.6875 0 0 0 -3.3142,1.3696 l -96.0498,96.0516 -1.095,-49.3029 a 4.6875,4.6875 0 0 0 -4.79,-4.5813 4.6875,4.6875 0 0 0 -4.5832,4.79 l 1.3404,60.2673 a 4.6875,4.6875 0 0 0 0.1117,0.6171 4.6875,4.6875 0 0 0 0.13,0.7233 4.6875,4.6875 0 0 0 0.095,0.2453 4.6875,4.6875 0 0 0 0.2032,0.3809 4.6875,4.6875 0 0 0 0.029,0.053 4.6875,4.6875 0 0 0 0.3369,0.6225 4.6875,4.6875 0 0 0 0.3205,0.3534 4.6875,4.6875 0 0 0 0.1446,0.2161 4.6875,4.6875 0 0 0 0.2179,0.1465 4.6875,4.6875 0 0 0 0.3498,0.3186 4.6875,4.6875 0 0 0 0.6445,0.3461 4.6875,4.6875 0 0 0 0.011,0.01 4.6875,4.6875 0 0 0 0.01,0 4.6875,4.6875 0 0 0 0.4046,0.2179 4.6875,4.6875 0 0 0 0.2381,0.09 4.6875,4.6875 0 0 0 0.7196,0.1319 4.6875,4.6875 0 0 0 0.6189,0.1117 h 0.1062 l 60.1611,1.3385 a 4.6875,4.6875 0 0 0 4.7919,-4.5831 4.6875,4.6875 0 0 0 -4.5831,-4.7901 l -49.2975,-1.0968 96.0461,-96.0461 a 4.6875,4.6875 0 0 0 0,-6.6321 4.6875,4.6875 0 0 0 -3.3142,-1.3696 z"
          id="path1554"
          style={{
            color: "#000000",
            fill: "#3d3d3d",
            fillOpacity: "1",
            fillRule: "evenodd",
            strokeLinecap: "round",
            strokeLinejoin: "round",
          }}
        />
      </g>
    </svg>
  ),
  intoBox2: (
    <svg
      xmlns="http://www.w3.org/2000/svg"
      width="100%"
      height="100%"
      className="pointer-events-none"
      viewBox="0 0 281.25 281.25">
      <defs id="defs4" />

      <g id="layer1" transform="translate(6984.8564,-3399.5356)">
        <path
          d="m -6844.2302,3441.3444 a 4.6875,4.6875 0 0 0 -4.6875,4.6875 v 135.8349 l -35.6378,-34.0887 a 4.6875,4.6875 0 0 0 -3.3435,-1.3001 4.6875,4.6875 0 0 0 -3.2831,1.4484 4.6875,4.6875 0 0 0 0.1465,6.6266 l 43.4912,41.5961 0.073,0.071 a 4.6875,4.6875 0 0 0 0.4943,0.3424 4.6875,4.6875 0 0 0 0.6263,0.4339 4.6875,4.6875 0 0 0 0.2252,0.1008 4.6875,4.6875 0 0 0 0.4596,0.1391 4.6875,4.6875 0 0 0 0.6958,0.2088 4.6875,4.6875 0 0 0 0.4724,0.022 4.6875,4.6875 0 0 0 0.2618,0.053 4.6875,4.6875 0 0 0 0.2619,-0.051 4.6875,4.6875 0 0 0 0.4669,-0.024 4.6875,4.6875 0 0 0 0.6958,-0.2088 4.6875,4.6875 0 0 0 0.01,0 4.6875,4.6875 0 0 0 0.4633,-0.1391 4.6875,4.6875 0 0 0 0.2197,-0.099 4.6875,4.6875 0 0 0 0.6317,-0.4376 4.6875,4.6875 0 0 0 0.4907,-0.3406 l 0.07,-0.066 a 4.6875,4.6875 0 0 0 0.011,-0.011 l 43.4839,-41.5906 a 4.6875,4.6875 0 0 0 0.1465,-6.6266 4.6875,4.6875 0 0 0 -3.2831,-1.4484 4.6875,4.6875 0 0 0 -3.3435,1.3001 l -35.6342,34.0851 v -135.8313 a 4.6875,4.6875 0 0 0 -4.6875,-4.6875 z m -95.1764,116.2848 a 4.6875,4.6875 0 0 0 -4.6875,4.6875 v 71.9732 a 4.6875,4.6875 0 0 0 0.564,2.1057 4.6875,4.6875 0 0 0 0.1831,0.3571 4.6875,4.6875 0 0 0 1.4795,1.4795 4.6875,4.6875 0 0 0 0.357,0.1813 4.6875,4.6875 0 0 0 2.1039,0.5639 h 190.3492 a 4.6875,4.6875 0 0 0 2.1057,-0.5639 4.6875,4.6875 0 0 0 0.3552,-0.1813 4.6875,4.6875 0 0 0 1.4831,-1.4832 4.6875,4.6875 0 0 0 0.1777,-0.3497 4.6875,4.6875 0 0 0 0.5658,-2.1094 v -71.9732 a 4.6875,4.6875 0 0 0 -4.6875,-4.6875 4.6875,4.6875 0 0 0 -4.6875,4.6875 v 67.2857 h -180.9742 v -67.2857 a 4.6875,4.6875 0 0 0 -4.6875,-4.6875 z"
          id="path1274"
          style={{
            color: "#000000",
            fill: "#3d3d3d",
            fillOpacity: "1",
            fillRule: "evenodd",
            strokeLinecap: "round",
            strokeLinejoin: "round",
          }}
        />
      </g>
    </svg>
  ),
  checkboxChecked2: (
    <svg
      xmlns="http://www.w3.org/2000/svg"
      width="100%"
      height="100%"
      className="pointer-events-none"
      viewBox="0 0 281.25 281.25">
      <defs id="defs4" />

      <g id="layer1" transform="translate(6693.6064,-3399.5356)">
        <path
          d="m -6645.7731,3447.5224 a 4.6879687,4.6879687 0 0 0 -4.6857,4.7552 l 2.677,182.0819 a 4.6879687,4.6879687 0 0 0 4.6875,4.6179 h 190.1788 a 4.6879687,4.6879687 0 0 0 4.6857,-4.5135 l 2.677,-71.9733 a 4.6875,4.6875 0 0 0 -4.5099,-4.8578 4.6875,4.6875 0 0 0 -4.8596,4.5099 l -2.5086,67.4597 h -181.0437 l -2.5415,-172.705 h 87.6545 a 4.6875,4.6875 0 0 0 4.6875,-4.6875 4.6875,4.6875 0 0 0 -4.6875,-4.6875 z m 168.7481,30.119 a 4.6875,4.6875 0 0 0 -3.3142,1.3714 l -63.1055,63.1055 -28.1652,-26.0651 a 4.6875,4.6875 0 0 0 -6.623,0.2546 4.6875,4.6875 0 0 0 0.2564,6.6247 l 31.4722,29.1303 a 4.6879687,4.6879687 0 0 0 6.5002,-0.1282 l 66.2952,-66.2915 a 4.6875,4.6875 0 0 0 0,-6.6303 4.6875,4.6875 0 0 0 -3.3161,-1.3714 z"
          id="path1195-0"
          style={{
            color: "#000000",
            fill: "#3d3d3d",
            fillOpacity: "1",
            fillRule: "evenodd",
            strokeLinecap: "round",
            strokeLinejoin: "round",
          }}
        />
      </g>
    </svg>
  ),
  bike: (
    <svg
      xmlns="http://www.w3.org/2000/svg"
      width="100%"
      height="100%"
      className="pointer-events-none"
      viewBox="0 -200.5 1425 1425">
      <path
        d="M1081.781995 716.637717m-280.643908 0a280.643908 280.643908 0 1 0 561.287816 0 280.643908 280.643908 0 1 0-561.287816 0Z"
        fill="#178E3B"
      />
      <path
        d="M307.257915 716.637717m-280.643908 0a280.643908 280.643908 0 1 0 561.287817 0 280.643908 280.643908 0 1 0-561.287817 0Z"
        fill="#178E3B"
      />
      <path
        d="M307.257915 716.637717m-105.518063 0a105.518063 105.518063 0 1 0 211.036127 0 105.518063 105.518063 0 1 0-211.036127 0Z"
        fill="#2FA65B"
      />
      <path
        d="M1081.781995 716.637717m-105.518063 0a105.518063 105.518063 0 1 0 211.036126 0 105.518063 105.518063 0 1 0-211.036126 0Z"
        fill="#2FA65B"
      />
      <path
        d="M307.321138 1023.835002a307.260508 307.260508 0 1 1 217.21927-89.978015A305.186815 305.186815 0 0 1 307.321138 1023.835002z m0-561.287816c-140.100676 0-254.153753 113.989855-254.153753 254.153753s113.989855 254.153753 254.153753 254.153754 254.153753-113.989855 254.153753-254.153754-114.103655-254.153753-254.153753-254.153753z"
        fill="#203529"
      />
      <path
        d="M149.265321 820.448778a13.276689 13.276689 0 0 1-11.506463-6.638345c-53.878067-93.316154-21.786414-213.071885 71.52974-266.949952s213.071885-21.786414 266.949952 71.529741a13.276689 13.276689 0 1 1-23.000282 13.276688c-46.556921-80.633755-150.039226-108.363068-230.672981-61.806146S114.151641 719.899989 160.64534 800.533745a13.276689 13.276689 0 0 1-11.380019 19.915033zM1081.857862 1023.99938a307.867442 307.867442 0 1 1 122.575447-25.718842 306.982329 306.982329 0 0 1-122.575447 25.718842z m-93.07591-70.897517c130.389727 51.273307 278.178237-13.087022 329.464189-143.464103s-13.087022-278.178237-143.464104-329.464189a254.153753 254.153753 0 0 0-329.464188 143.476748c-51.285951 130.377082 13.074377 278.178237 143.464103 329.451544z"
        fill="#203529"
      />
      <path
        d="M1109.397507 909.946303a13.276689 13.276689 0 0 1-1.947247-26.414288C1199.527256 869.724259 1263.242717 783.577517 1249.333805 691.50052a13.276689 13.276689 0 1 1 26.262555-3.945073c16.045827 106.516976-57.646117 206.256518-164.213672 222.251767a13.377844 13.377844 0 0 1-1.985181 0.139089zM307.321138 763.03026a46.392543 46.392543 0 1 1 46.392543-46.392543A46.443121 46.443121 0 0 1 307.321138 763.03026z m0-66.231709a19.839166 19.839166 0 1 0 19.839166 19.839166A19.864455 19.864455 0 0 0 307.321138 696.798551zM1081.781995 763.03026a46.392543 46.392543 0 1 1 46.392543-46.392543 46.443121 46.443121 0 0 1-46.392543 46.392543z m0-66.231709a19.839166 19.839166 0 1 0 19.839166 19.839166 19.864455 19.864455 0 0 0-19.839166-19.839166z"
        fill="#203529"
      />
      <path
        d="M307.321138 743.203739a26.553377 26.553377 0 0 1-23.455483-14.07329c-72.465431-135.928002-90.471149-262.195633-53.549311-375.31302C252.734981 285.132693 296.421609 221.278143 356.634553 169.170302c45.380986-39.197843 84.288006-58.265696 85.919142-59.049653a26.553377 26.553377 0 0 1 23.152016 47.796079c-0.354045 0.164378-35.404503 17.449362-75.715059 52.626264-36.517216 31.864053-85.14783 85.539808-109.399914 160.319176-32.015786 98.715341-15.173358 210.859104 50.072083 333.295462A26.553377 26.553377 0 0 1 307.321138 743.203739z"
        fill="#203529"
      />
      <path
        d="M773.724886 519.877192q-19.39661 0-38.805864-1.264446c-78.952042-5.348609-158.055817-26.995933-234.959455-64.309751-130.364438-63.222327-209.076234-148.964446-212.363795-152.580763a26.553377 26.553377 0 0 1 28.905248-42.738293c1.264447 0.467845 128.139012 47.151211 282.363555 68.204246 139.17763 18.966698 330.020545 20.58519 448.473896-79.862443a26.553377 26.553377 0 1 1 34.342368 40.462289c-59.631299 50.577861-138.684496 82.821248-234.94681 95.933558-75.32308 10.267306-161.469822 8.851126-256.050423-4.109451a1521.761403 1521.761403 0 0 1-169.271458-33.533122A720.35519 720.35519 0 0 0 524.805942 407.265584c160.850243 77.459995 322.737333 79.660132 481.172483 6.726855a26.553377 26.553377 0 0 1 22.22897 48.238636c-83.200582 38.31273-168.62659 57.646117-254.482509 57.646117z"
        fill="#203529"
      />
      <path
        d="M1081.807284 743.203739A26.553377 26.553377 0 0 1 1055.873485 710.909774c17.702251-79.875088 5.462409-163.632026-36.289615-248.944233-31.788186-64.954618-69.65836-106.327309-70.037694-106.744576a26.553377 26.553377 0 0 1 38.944954-36.099949c1.732292 1.858736 42.750937 46.443121 78.016351 117.922284 20.787501 42.144003 35.328636 85.071963 43.218782 127.582655C1119.664813 618.314355 1118.994656 671.421109 1107.715793 722.378304a26.553377 26.553377 0 0 1-25.908509 20.825435zM827.640886 315.694366a203.664403 203.664403 0 0 1-22.760037-1.264447c-50.059438-5.639432-63.386705-29.613338-66.889222-43.408449s-3.173761-41.220957 38.160996-70.012405c23.480772-16.349294 56.078204-30.346717 91.798819-39.387509s71.049251-12.265131 99.486653-9.066082c50.059438 5.639432 63.386705 29.613338 66.889222 43.40845s3.173761 41.220957-38.160997 70.012404c-23.468128 16.349294-56.078204 30.346717-91.798818 39.38751-26.692466 6.815367-53.182621 10.330528-76.726616 10.330528z m-35.783837-58.253052c12.17662 5.196875 47.834012 9.584505 99.474009-3.502517s80.924578-33.912456 89.143481-44.255628c-12.17662-5.196875-47.834012-9.584505-99.474009 3.502516s-80.899289 33.887167-89.143481 44.255629z m192.423474-45.520075zM496.82374 236.767613h-1.631136C376.157607 229.497046 317.43671 176.137402 315.034262 173.861398l36.163171-38.894375-0.151734-0.139089c0.48049 0.429912 48.643258 42.890026 147.358599 48.883503a26.553377 26.553377 0 0 1-1.580558 53.106754z"
        fill="#203529"
      />
      <path
        d="M314.503194 197.34217a26.47751 26.47751 0 0 1-10.558128-2.200137L175.31292 139.304075A26.553377 26.553377 0 0 1 159.380893 112.636897c5.057786-57.064472 33.520478-84.819073 56.52076-98.045184A109.311403 109.311403 0 0 1 266.580671 0a26.553377 26.553377 0 0 1 22.633592 12.644465l68.520358 111.663274a26.553377 26.553377 0 0 1-0.189667 28.070713l-20.585189 32.572142a26.553377 26.553377 0 0 1-22.456571 12.391576z m-99.08203-98.513029l87.714656 38.072485-49.768616-81.126889a57.140339 57.140339 0 0 0-12.644465 5.803809c-12.353643 7.725768-20.850723 20.2185-25.301575 37.250595zM671.544962 296.146023a26.553377 26.553377 0 0 1-6.03141-0.695446l-178.286961-41.600291a26.553377 26.553377 0 0 1-20.016189-30.97894l9.192526-46.784522a26.553377 26.553377 0 0 1 21.369147-21.015101l169.043857-30.346717a26.553377 26.553377 0 0 1 25.28893 9.356904 144.690617 144.690617 0 0 1 24.441752 48.238636c11.038618 38.780575 1.909314 76.246126-25.706198 105.518063a26.553377 26.553377 0 0 1-19.295454 8.307414z m-147.232155-88.182502l136.686671 31.901986c7.371723-12.480087 8.952281-26.224621 4.868119-41.726735a88.764147 88.764147 0 0 0-7.118834-18.081586l-133.689932 24.024484zM750.863693 999.595562H524.034629a13.276689 13.276689 0 1 1 0-26.553377h226.829064a13.276689 13.276689 0 0 1 0 26.553377zM803.793425 937.334215h-161.849157a13.276689 13.276689 0 0 1 0-26.553377h161.849157a13.276689 13.276689 0 0 1 0 26.553377zM1331.080273 350.454001h-161.849156a13.276689 13.276689 0 0 1 0-26.553377h161.849156a13.276689 13.276689 0 0 1 0 26.553377zM1412.004852 426.750705h-161.849157a13.276689 13.276689 0 0 1 0-26.553377h161.849157a13.276689 13.276689 0 0 1 0 26.553377z"
        fill="#203529"
      />
    </svg>
  ),
  bookmarkChecked: (
    <svg
      xmlns="http://www.w3.org/2000/svg"
      width="100%"
      height="100%"
      className="pointer-events-none"
      viewBox="0 0 24 24"
      fill="none">
      <path
        d="M10.5 10.5L11.5 11.5L14 9M8.25 5H15.75C16.4404 5 17 5.58763 17 6.3125V19L12 15.5L7 19V6.3125C7 5.58763 7.55964 5 8.25 5Z"
        stroke="#464455"
        strokeLinecap="round"
        strokeLinejoin="round"
      />
    </svg>
  ),
  bookmarks: (
    <svg
      xmlns="http://www.w3.org/2000/svg"
      width="100%"
      height="100%"
      className="pointer-events-none"
      viewBox="0 0 24 24"
      fill="none">
      <path
        d="M14.6923 6.08088C14.6923 5.48393 14.2618 5 13.7308 5H7.96154C7.4305 5 7 5.48393 7 6.08088V16.5294L7.76923 15.9529M10.2692 7.47059H16.0385C16.5695 7.47059 17 7.95452 17 8.55147V19L13.1538 16.1176L9.30769 19V8.55147C9.30769 7.95452 9.73819 7.47059 10.2692 7.47059Z"
        stroke="#464455"
        strokeLinecap="round"
        strokeLinejoin="round"
      />
    </svg>
  ),
  bookmark: (
    <svg
      xmlns="http://www.w3.org/2000/svg"
      width="100%"
      height="100%"
      className="pointer-events-none"
      viewBox="0 0 24 24"
      fill="none">
      <path
        d="M15.75 5H8.25C7.55964 5 7 5.58763 7 6.3125V19L12 15.5L17 19V6.3125C17 5.58763 16.4404 5 15.75 5Z"
        stroke="#464455"
        strokeLinecap="round"
        strokeLinejoin="round"
      />
    </svg>
  ),
  bookmarkClear: (
    <svg
      xmlns="http://www.w3.org/2000/svg"
      width="100%"
      height="100%"
      className="pointer-events-none"
      viewBox="0 0 24 24"
      fill="none">
      <path
        d="M10.5 8.56L12 10.06M12 10.06L13.5 11.56M12 10.06L13.5 8.56M12 10.06L10.5 11.56M8.25 5H15.75C16.4404 5 17 5.58763 17 6.3125V19L12 15.5L7 19V6.3125C7 5.58763 7.55964 5 8.25 5Z"
        stroke="#464455"
        strokeLinecap="round"
        strokeLinejoin="round"
      />
    </svg>
  ),
  bookself: (
    <svg
      xmlns="http://www.w3.org/2000/svg"
      width="100%"
      height="100%"
      className="pointer-events-none"
      viewBox="0 0 1024 1024">
      <path d="M74 183.7h216V918H74z" fill="#55B7A8" />
      <path
        d="M298 926H66V175.7h232V926zM82 910h200V191.7H82V910z"
        fill="#0A0408"
      />
      <path d="M125.6 246.6h116.8v229.2H125.6z" fill="#FFFFFF" />
      <path
        d="M250.4 483.8H117.6V238.6h132.8v245.2z m-116.8-16h100.8V254.6H133.6v213.2z"
        fill="#0A0408"
      />
      <path
        d="M178.8 783.9m-55.2 0a55.2 55.2 0 1 0 110.4 0 55.2 55.2 0 1 0-110.4 0Z"
        fill="#FFFFFF"
      />
      <path
        d="M178.8 847.1c-34.8 0-63.2-28.3-63.2-63.2s28.3-63.2 63.2-63.2c34.8 0 63.2 28.3 63.2 63.2s-28.4 63.2-63.2 63.2z m0-110.4c-26 0-47.2 21.2-47.2 47.2s21.2 47.2 47.2 47.2 47.2-21.2 47.2-47.2-21.2-47.2-47.2-47.2z"
        fill="#0A0408"
      />
      <path d="M519.4 224.2L728 168.3l190.1 709.3-208.6 55.9" fill="#FFFFFF" />
      <path
        d="M517.346 216.397l7.727-2.07 4.14 15.454-7.727 2.07zM544.1 225.8l-4.1-15.5 14.9-4 4.1 15.5-14.9 4z m29.7-7.9l-4.1-15.5 14.9-4 4.1 15.5-14.9 4z m29.7-8l-4.1-15.5 14.9-4 4.1 15.5-14.9 4z m29.7-8l-4.1-15.5 14.9-4 4.1 15.5-14.9 4zM663 194l-4.1-15.5 14.9-4 4.1 15.5-14.9 4z m29.7-8l-4.1-15.5 14.9-4 4.1 15.5-14.9 4zM722.4 178.1l-4.2-15.5 15.5-4.1 4.1 15.4zM904.2 856.5l-4.1-15.4 15.5-4.1 4.1 15.4-15.5 4.1z m-8.3-30.8l-4.1-15.4 15.5-4.1 4.1 15.4-15.5 4.1z m-8.3-30.9l-4.1-15.4 15.5-4.1 4.1 15.4-15.5 4.1z m-8.2-30.8l-4.1-15.4 15.5-4.1 4.1 15.4-15.5 4.1z m-8.3-30.8l-4.1-15.4 15.5-4.1 4.1 15.4-15.5 4.1z m-8.2-30.9l-4.1-15.4 15.5-4.1 4.1 15.4-15.5 4.1z m-8.3-30.8l-4.1-15.4L866 652l4.1 15.4-15.5 4.1z m-8.3-30.9l-4.1-15.4 15.5-4.1 4.1 15.4-15.5 4.1z m-8.2-30.8l-4.1-15.4 15.5-4.1 4.1 15.4-15.5 4.1z m-8.3-30.8l-4.1-15.4 15.5-4.1 4.1 15.4-15.5 4.1z m-8.3-30.9l-4.1-15.4 15.5-4.1L837 544l-15.5 4.1z m-8.2-30.8l-4.1-15.4 15.5-4.1 4.1 15.4-15.5 4.1z m-8.3-30.9l-4.1-15.4 15.5-4.1 4.1 15.4-15.5 4.1z m-8.2-30.8l-4.1-15.4 15.5-4.1 4.1 15.4-15.5 4.1z m-8.3-30.8l-4.1-15.4 15.5-4.1 4.1 15.4-15.5 4.1z m-8.3-30.9l-4.1-15.4 15.5-4.1 4.1 15.4-15.5 4.1z m-8.2-30.8l-4.1-15.4 15.5-4.1 4.1 15.4-15.5 4.1z m-8.3-30.8l-4.1-15.4 15.5-4.1 4.1 15.4-15.5 4.1z m-8.3-30.9l-4.1-15.4 15.5-4.1 4.1 15.4-15.5 4.1z m-8.2-30.8l-4.1-15.4 15.5-4.1 4.1 15.4-15.5 4.1z m-8.3-30.9l-4.1-15.4 15.5-4.1 4.1 15.4-15.5 4.1z m-8.3-30.8l-4.1-15.4 15.5-4.1 4.1 15.4-15.5 4.1zM908.303 871.94l15.454-4.142 4.143 15.455-15.455 4.142zM734.2 935.1l-4.1-15.5 14.9-4 4.1 15.5-14.9 4z m29.7-7.9l-4.1-15.5 14.9-4 4.1 15.5-14.9 4z m29.7-8l-4.1-15.5 14.9-4 4.1 15.5-14.9 4z m29.7-7.9l-4.1-15.5 14.9-4 4.1 15.5-14.9 4z m29.7-8l-4.1-15.5 14.9-4 4.1 15.5-14.9 4z m29.7-8l-4.1-15.5 14.9-4 4.1 15.5-14.9 4zM707.443 925.66l7.727-2.07 4.141 15.454-7.727 2.07z"
        fill="#0A0408"
      />
      <path
        d="M583.619 272.12l112.817-30.229 59.317 221.385-112.817 30.228z"
        fill="#FFFFFF"
      />
      <path
        d="M637.3 503.3l-63.5-236.8L702.1 232l63.5 236.8-128.3 34.5z m-43.9-225.6l55.2 205.9 97.4-26.1-55.2-205.9-97.4 26.1z"
        fill="#0A0408"
      />
      <path
        d="M722.664239 791.097256a55.2 55.2 0 1 0 106.63871-28.571762 55.2 55.2 0 1 0-106.63871 28.571762Z"
        fill="#FFFFFF"
      />
      <path
        d="M776 840c-27.9 0-53.5-18.6-61-46.8-9-33.7 11-68.4 44.7-77.4s68.4 11 77.4 44.7c9 33.6-11 68.4-44.7 77.4-5.5 1.4-11 2.1-16.4 2.1z m0-110.4c-4 0-8.1 0.5-12.2 1.6-25.1 6.7-40.1 32.7-33.4 57.8 6.7 25.1 32.7 40.1 57.8 33.4 25.1-6.7 40.1-32.7 33.4-57.8-5.7-21-24.8-35-45.6-35z"
        fill="#0A0408"
      />
      <path
        d="M888.182 860.34l47.04-12.603 12.603 47.04-47.04 12.603z"
        fill="#DC444A"
      />
      <path
        d="M895.2 917.2l-16.8-62.5 62.5-16.8 16.8 62.5-62.5 16.8zM898 866l8.5 31.6 31.6-8.5-8.5-31.6L898 866z"
        fill="#0A0408"
      />
      <path
        d="M698.202 151.04l47.04-12.604 12.603 47.04-47.04 12.603z"
        fill="#DC444A"
      />
      <path
        d="M705.1 207.9l-16.8-62.5 62.5-16.8 16.8 62.5-62.5 16.8z m2.9-51.2l8.5 31.6 31.6-8.5-8.5-31.6-31.6 8.5z"
        fill="#0A0408"
      />
      <path d="M291.4 183.7h216V918h-216z" fill="#EBB866" />
      <path
        d="M515.4 926h-232V175.7h232V926z m-216-16h200V191.7h-200V910z"
        fill="#0A0408"
      />
      <path d="M343 246.6h116.8v229.2H343z" fill="#FFFFFF" />
      <path
        d="M467.8 483.8H335V238.6h132.8v245.2z m-116.8-16h100.8V254.6H351v213.2z"
        fill="#0A0408"
      />
      <path
        d="M396.2 783.9m-55.2 0a55.2 55.2 0 1 0 110.4 0 55.2 55.2 0 1 0-110.4 0Z"
        fill="#FFFFFF"
      />
      <path
        d="M396.2 847.1c-34.8 0-63.2-28.3-63.2-63.2s28.3-63.2 63.2-63.2c34.8 0 63.2 28.3 63.2 63.2s-28.4 63.2-63.2 63.2z m0-110.4c-26 0-47.2 21.2-47.2 47.2s21.2 47.2 47.2 47.2 47.2-21.2 47.2-47.2-21.2-47.2-47.2-47.2z"
        fill="#0A0408"
      />
      <path d="M712.5 941.5L518.4 217.2" fill="#FFFFFF" />
      <path
        d="M510.727 219.228l15.454-4.141 194.074 724.328-15.454 4.141z"
        fill="#0A0408"
      />
    </svg>
  ),
  boss: (
    <svg
      xmlns="http://www.w3.org/2000/svg"
      width="100%"
      height="100%"
      className="pointer-events-none"
      viewBox="0 0 1024 1024"
      fill="#000000">
      <path
        d="M312.026 543.906c-4.422 0-8-3.562-8-8v-53.296c0-31.184 16.576-43.48 45.198-54.182 9.578-3.578 35.026-13.092 55.336-22.792a7.974 7.974 0 0 1 10.67 3.764 8 8 0 0 1-3.764 10.67c-18.778 8.966-41.324 17.624-56.65 23.356-27.308 10.204-34.792 18.624-34.792 39.184v53.296c0 4.438-3.576 8-7.998 8zM695.976 543.906c-4.422 0-8-3.562-8-8v-53.296c0-20.56-7.484-28.98-34.792-39.184-15.324-5.732-37.884-14.404-56.68-23.402a8.004 8.004 0 0 1-3.766-10.67c1.906-4 6.734-5.67 10.672-3.764 18.23 8.732 40.338 17.216 55.368 22.84 28.622 10.702 45.198 22.998 45.198 54.182v53.296a7.988 7.988 0 0 1-8 7.998zM504.484 418.118c-45.198 0-119.984-71.944-119.984-153.934a7.994 7.994 0 0 1 8-7.998 7.994 7.994 0 0 1 7.998 7.998c0 71.132 64.868 137.936 103.986 137.936 39.122 0 103.986-66.804 103.986-137.936a7.994 7.994 0 0 1 8-7.998 7.994 7.994 0 0 1 7.998 7.998c0 81.99-74.786 153.934-119.984 153.934zM392.016 255.952c-0.656 0-1.312-0.078-1.954-0.25a7.972 7.972 0 0 1-6.016-7c-4.234-45.198 5.562-81.222 29.122-107.08 34.23-37.588 89.738-45.478 130.266-45.478 24.184 0 41.292 2.812 42.01 2.938a8.026 8.026 0 0 1 6.624 7 8.026 8.026 0 0 1-4.904 8.294c-6.828 2.796-11.202 6.782-13.388 12.186-2.516 6.234-1.624 13.186-0.516 17.732 8.17 0.328 24.606 2.954 37.12 17.56 15.216 17.794 19.764 47.166 13.514 87.332a8.014 8.014 0 0 1-6.186 6.578 7.992 7.992 0 0 1-8.376-3.376l-28.45-42.666c-12.732 4.608-43.244 14.232-76.396 14.232-33.26 0-64.46-9.686-77.348-14.28l-28.466 42.712a7.984 7.984 0 0 1-6.656 3.566z m191.974-63.992c2.61 0 5.14 1.282 6.654 3.562l19.732 29.606c1.234-23.966-2.888-42.026-12.154-52.87-8.954-10.436-20.684-11.998-26.886-11.998-1.562 0-2.562 0.11-2.766 0.124a8.036 8.036 0 0 1-8.406-4.702c-0.328-0.75-7.936-18.466-1.216-35.104a34.844 34.844 0 0 1 4.326-7.766 292.832 292.832 0 0 0-19.84-0.672c-37.308 0-88.146 6.984-118.438 40.246-16.108 17.684-24.732 41.276-25.794 70.366l18.154-27.23a7.988 7.988 0 0 1 9.686-2.968c0.374 0.156 38.058 15.404 77.442 15.404 39.356 0 76.038-15.216 76.396-15.374a8.106 8.106 0 0 1 3.11-0.624z"
        fill=""
      />
      <path
        d="M616.47 272.184c-4.422 0-8-3.578-8-8v-16.232a7.994 7.994 0 0 1 8-7.998 7.994 7.994 0 0 1 7.998 7.998v16.232c0 4.422-3.578 8-7.998 8zM392.5 272.184c-4.422 0-8-3.578-8-8v-16.232a7.994 7.994 0 0 1 8-7.998 7.994 7.994 0 0 1 7.998 7.998v16.232c0 4.422-3.578 8-7.998 8zM472.254 447.926a7.996 7.996 0 0 1-5.656-2.344l-47.994-47.994a7.996 7.996 0 1 1 11.31-11.31l43.932 43.932 27.076-13.452a8.042 8.042 0 0 1 10.734 3.61 8.02 8.02 0 0 1-3.61 10.732l-32.23 15.998a8.01 8.01 0 0 1-3.562 0.828z"
        fill=""
      />
      <path
        d="M536.23 447.926a8.038 8.038 0 0 1-3.562-0.828l-32.23-15.998a8.022 8.022 0 0 1-3.608-10.732 8.024 8.024 0 0 1 10.732-3.61l27.074 13.452 43.932-43.932a7.996 7.996 0 1 1 11.31 11.31l-47.992 47.994a7.992 7.992 0 0 1-5.656 2.344zM504.86 463.924a7.98 7.98 0 0 1-5.656-2.344l-15.998-15.998a7.996 7.996 0 1 1 11.31-11.31l15.998 15.998a7.996 7.996 0 0 1-5.654 13.654z"
        fill=""
      />
      <path
        d="M504.86 463.924a7.996 7.996 0 0 1-5.656-13.654l16-15.998a7.996 7.996 0 1 1 11.31 11.31l-15.998 15.998a7.968 7.968 0 0 1-5.656 2.344z"
        fill=""
      />
      <path
        d="M488.876 543.906c-0.25 0-0.5 0-0.734-0.032a7.994 7.994 0 0 1-7.248-8.688l7.998-87.98c0.39-4.406 4.656-7.468 8.688-7.25a8 8 0 0 1 7.248 8.686l-7.998 87.98a8.004 8.004 0 0 1-7.954 7.284z"
        fill=""
      />
      <path
        d="M520.842 543.906a8.006 8.006 0 0 1-7.952-7.282l-8-87.98c-0.406-4.39 2.844-8.28 7.25-8.686 4.094-0.25 8.28 2.842 8.686 7.25l8 87.98a7.996 7.996 0 0 1-7.25 8.688c-0.234 0.03-0.484 0.03-0.734 0.03zM1015.934 575.902H8.064a7.984 7.984 0 0 1-7.998-8c0-4.406 3.578-8 7.998-8h1007.87c4.422 0 8 3.594 8 8 0 4.438-3.578 8-8 8z"
        fill=""
      />
      <path
        d="M8.064 639.894a7.984 7.984 0 0 1-7.998-8v-63.992c0-4.406 3.578-8 7.998-8 4.422 0 8 3.594 8 8v63.992c0 4.438-3.578 8-8 8z"
        fill=""
      />
      <path
        d="M1015.934 639.894H8.064a7.984 7.984 0 0 1-7.998-8c0-4.406 3.578-8 7.998-8h1007.87c4.422 0 8 3.594 8 8 0 4.438-3.578 8-8 8z"
        fill=""
      />
      <path
        d="M1015.934 639.894a7.984 7.984 0 0 1-7.998-8v-63.992c0-4.406 3.576-8 7.998-8s8 3.594 8 8v63.992c0 4.438-3.578 8-8 8zM887.952 927.856c-4.422 0-8-3.562-8-7.996V631.894c0-4.406 3.578-8 8-8a8.006 8.006 0 0 1 7.998 8V919.86a7.986 7.986 0 0 1-7.998 7.996zM983.938 927.856a7.984 7.984 0 0 1-7.998-7.996V631.894c0-4.406 3.578-8 7.998-8 4.422 0 8 3.594 8 8V919.86a7.986 7.986 0 0 1-8 7.996zM40.06 927.856a7.984 7.984 0 0 1-7.998-7.996V631.894c0-4.406 3.578-8 7.998-8 4.422 0 8 3.594 8 8V919.86a7.986 7.986 0 0 1-8 7.996zM136.048 927.856c-4.422 0-8-3.562-8-7.996V631.894c0-4.406 3.578-8 8-8a8.006 8.006 0 0 1 7.998 8V919.86a7.984 7.984 0 0 1-7.998 7.996zM823.958 687.886H184.042c-4.42 0-8-3.562-8-8a8.004 8.004 0 0 1 8-7.996h639.916a8.002 8.002 0 0 1 7.998 7.996 7.982 7.982 0 0 1-7.998 8zM823.958 895.86H184.042c-4.42 0-8-3.562-8-7.996 0-4.406 3.578-8 8-8h639.916a8.004 8.004 0 0 1 7.998 8 7.982 7.982 0 0 1-7.998 7.996z"
        fill=""
      />
      <path
        d="M184.042 895.86c-4.42 0-8-3.562-8-7.996V679.886c0-4.402 3.578-7.996 8-7.996s8 3.594 8 7.996v207.976a7.988 7.988 0 0 1-8 7.998zM823.958 895.86a7.982 7.982 0 0 1-7.998-7.996V679.886c0-4.402 3.576-7.996 7.998-7.996s7.998 3.594 7.998 7.996v207.976a7.982 7.982 0 0 1-7.998 7.998zM72.056 927.856c-4.422 0-8-3.562-8-7.996v-111.988a8.002 8.002 0 0 1 16 0v111.988a7.986 7.986 0 0 1-8 7.996zM120.05 751.878c-9.64 0-23.998-6.376-23.998-23.996v-79.988c0-4.406 3.578-8 8-8a8.006 8.006 0 0 1 7.998 8v79.988c0 6.438 4.406 7.906 8.094 8 4.374 0.124 7.904 3.718 7.842 8.09a7.93 7.93 0 0 1-7.936 7.906zM951.942 927.856a7.984 7.984 0 0 1-7.998-7.996v-79.992c0-17.59 14.358-23.996 23.998-23.996a8.006 8.006 0 0 1 7.998 8 7.98 7.98 0 0 1-7.998 7.996c-3.594 0.094-8 1.562-8 8v79.992a7.986 7.986 0 0 1-8 7.996z"
        fill=""
      />
      <path
        d="M296.028 879.864a7.984 7.984 0 0 1-7.998-8c-0.094-3.594-1.562-8-8-8H200.04c-4.42 0-8-3.562-8-7.996 0-4.406 3.578-8 8-8h79.99c17.608 0 23.998 14.372 23.998 23.996a7.988 7.988 0 0 1-8 8zM807.96 719.882H567.992c-17.608 0-23.996-14.34-23.996-23.996 0-4.406 3.578-8 7.998-8a8.004 8.004 0 0 1 7.998 8c0.094 3.594 1.562 8 8 8H807.96c4.422 0 8 3.594 8 7.996 0 4.438-3.578 8-8 8zM919.948 783.876c-4.422 0-8-3.562-8-8v-111.984c0-4.406 3.578-8 8-8a8.006 8.006 0 0 1 7.998 8v111.984c0 4.436-3.578 8-7.998 8zM392.016 783.876H184.042c-4.42 0-8-3.562-8-8a8.002 8.002 0 0 1 8-7.996h207.974a8 8 0 0 1 7.998 7.996c0 4.436-3.578 8-7.998 8zM823.958 815.872h-143.982a7.984 7.984 0 0 1-7.998-8 8 8 0 0 1 7.998-7.996h143.982a8 8 0 0 1 0 15.996z"
        fill=""
      />
      <path
        d="M695.976 431.85c-4.422 0-8-3.578-8-8v-63.914c0-4.422 3.578-8 8-8a7.994 7.994 0 0 1 7.998 8v63.914c0 4.422-3.578 8-7.998 8z"
        fill=""
      />
      <path
        d="M695.976 367.936c-4.422 0-8-3.578-8-7.998 0-44.948-16.342-88.192-46.026-121.782a8.004 8.004 0 0 1 0.704-11.294c3.266-2.906 8.326-2.64 11.294 0.704 32.262 36.51 50.026 83.52 50.026 132.374a7.992 7.992 0 0 1-7.998 7.996z"
        fill=""
      />
      <path
        d="M312.026 431.85c-4.422 0-8-3.578-8-8v-63.914c0-4.422 3.578-8 8-8s8 3.578 8 8v63.914a7.996 7.996 0 0 1-8 8z"
        fill=""
      />
      <path
        d="M312.026 367.936c-4.422 0-8-3.578-8-7.998 0-48.854 17.764-95.864 50.024-132.374a7.996 7.996 0 0 1 11.296-0.704 8.008 8.008 0 0 1 0.704 11.294c-29.684 33.59-46.026 76.834-46.026 121.782 0 4.424-3.576 8-7.998 8z"
        fill=""
      />
      <path
        d="M232.036 543.906H8.064a7.984 7.984 0 0 1-7.998-8v-63.982c0-4.42 3.578-8 7.998-8h223.97c3.234 0 6.14 1.954 7.376 4.936a7.988 7.988 0 0 1-1.704 8.702c-3.812 3.844-13.67 16.03-13.67 26.356 0 10.328 9.858 22.514 13.67 26.362a7.964 7.964 0 0 1 1.704 8.688 7.958 7.958 0 0 1-7.374 4.938zM16.064 527.918h199.708c-4.062-6.672-7.734-15.14-7.734-24 0-8.858 3.672-17.326 7.734-23.996H16.064v47.996z"
        fill=""
      />
      <path
        d="M248.034 479.922h-15.998c-4.42 0-7.998-3.578-7.998-8s3.578-8 7.998-8h15.998c4.422 0 8 3.578 8 8s-3.578 8-8 8z"
        fill=""
      />
      <path
        d="M248.034 543.906h-15.998a7.994 7.994 0 0 1 0-15.988h15.998a7.996 7.996 0 1 1 0 15.988z"
        fill=""
      />
      <path
        d="M200.056 447.926h-159.98c-4.42 0-8-3.578-8-8s3.578-8 8-8c3.594-0.094 8-1.562 8-8s-4.39-7.906-8.078-8a8 8 0 1 1-0.092-15.998H200.062c4.42 0 8 3.578 8 8v31.996a8.008 8.008 0 0 1-8.006 8.002z m-137.124-15.998h129.124v-15.998H62.932c0.734 2.36 1.14 5.016 1.14 8 0.002 2.984-0.406 5.64-1.14 7.998z"
        fill=""
      />
      <path
        d="M999.936 543.906H775.964a7.984 7.984 0 0 1-7.998-8v-159.97c0-4.422 3.576-8 7.998-8h223.97c4.422 0 8 3.578 8 8v159.97a7.982 7.982 0 0 1-7.998 8z m-215.972-15.988h207.972v-143.984H783.964v143.984z"
        fill=""
      />
      <path
        d="M1015.934 543.906H759.966a7.994 7.994 0 0 1 0-15.988h255.966a7.996 7.996 0 1 1 0.002 15.988z"
        fill=""
      />
      <path
        d="M887.952 479.922c-6.422 0-12.452-2.5-16.966-7.032-4.532-4.53-7.032-10.56-7.032-16.966s2.5-12.436 7.032-16.966c9.06-9.062 24.872-9.062 33.934 0 9.342 9.374 9.342 24.59 0 33.932a23.856 23.856 0 0 1-16.968 7.032z m0-31.996c-2.14 0-4.14 0.828-5.656 2.344s-2.344 3.514-2.344 5.656c0 2.14 0.828 4.14 2.344 5.656 3.016 3 8.264 3.032 11.31 0a8.02 8.02 0 0 0 0-11.31 7.92 7.92 0 0 0-5.654-2.346z"
        fill=""
      />
      <path
        d="M899.262 452.614a8 8 0 0 1-5.656-13.656l5.656-5.656a7.996 7.996 0 1 1 11.31 11.31l-5.654 5.656a7.96 7.96 0 0 1-5.656 2.346z"
        fill=""
      />
      <path
        d="M791.962 607.898H248.034a7.984 7.984 0 0 1-7.998-8c0-4.406 3.578-8 7.998-8h543.93c4.422 0 8 3.594 8 8a7.988 7.988 0 0 1-8.002 8z"
        fill=""
      />
    </svg>
  ),
  brainstorming: (
    <svg
      xmlns="http://www.w3.org/2000/svg"
      width="100%"
      height="100%"
      className="pointer-events-none"
      viewBox="0 0 1024 1024"
      fill="#000000">
      <path
        d="M349.92 427.474c-24.466 0-48.942-9.314-67.57-27.942-18.096-18.08-28.058-42.086-28.058-67.584 0-25.498 9.96-49.496 28.058-67.57a95.214 95.214 0 0 1 24.186-17.628c3.934-1.984 8.75-0.446 10.758 3.482a8 8 0 0 1-3.482 10.758 79.3 79.3 0 0 0-20.15 14.684c-15.084 15.068-23.382 35.054-23.382 56.274 0 21.226 8.298 41.212 23.374 56.28 31.024 31.026 81.504 31.026 112.528 0a7.988 7.988 0 0 1 11.304 0 7.988 7.988 0 0 1 0 11.304c-18.624 18.628-43.098 27.942-67.566 27.942zM761.528 404.452a7.994 7.994 0 0 1-7.198-11.476c5.246-10.844 7.916-22.522 7.916-34.726 0-43.882-35.694-79.584-79.568-79.584a7.99 7.99 0 0 1-7.994-7.994 7.99 7.99 0 0 1 7.994-7.994c52.698 0 95.558 42.876 95.558 95.572 0 14.638-3.204 28.668-9.51 41.69a7.998 7.998 0 0 1-7.198 4.512z"
        fill=""
      />
      <path
        d="M731.954 293.782a8.004 8.004 0 0 1-7.698-10.18 79.114 79.114 0 0 0 2.982-21.704c0-41.704-31.29-75.796-72.776-79.302a7.984 7.984 0 0 1-7.292-8.634c0.376-4.404 4.42-7.652 8.634-7.292 49.84 4.2 87.422 45.14 87.422 95.228 0 8.932-1.202 17.7-3.574 26.076a8.016 8.016 0 0 1-7.698 5.808zM437.492 462.55c-34.046 0-65.938-13.28-89.81-37.394a7.99 7.99 0 0 1 0.062-11.304 7.99 7.99 0 0 1 11.304 0.062c20.844 21.054 48.7 32.648 78.444 32.648 15.676 0 63.384 0 83.512-15.792a7.966 7.966 0 0 1 11.232 1.35 7.988 7.988 0 0 1-1.358 11.218c-21.938 17.222-63.806 19.212-93.386 19.212z"
        fill=""
      />
      <path
        d="M665.19 230.482a7.988 7.988 0 0 1-7.994-7.994c0-60.77-49.45-110.204-110.234-110.204-60.786 0-110.236 49.434-110.236 110.204a7.99 7.99 0 0 1-7.994 7.994 7.99 7.99 0 0 1-7.994-7.994c0-69.584 56.616-126.192 126.224-126.192 69.606 0 126.222 56.608 126.222 126.192a7.99 7.99 0 0 1-7.994 7.994zM612.632 497.588c-40.268 0-77.148-18.47-101.21-50.674a7.99 7.99 0 0 1 1.616-11.188 8 8 0 0 1 11.196 1.616c21.008 28.128 53.236 44.258 88.398 44.258 17.222 0 33.71-3.84 49.012-11.414 3.902-1.944 8.76-0.352 10.71 3.624a7.99 7.99 0 0 1-3.622 10.71c-17.518 8.674-36.394 13.068-56.1 13.068z"
        fill=""
      />
      <path
        d="M319.13 322.448a7.988 7.988 0 0 1-7.346-4.824c-6.87-15.886-10.352-32.796-10.352-50.262 0-69.59 56.616-126.206 126.206-126.206 8.75 0 17.566 0.914 26.192 2.716a7.986 7.986 0 0 1 6.192 9.454c-0.898 4.31-5.168 7.104-9.456 6.192a112.382 112.382 0 0 0-22.928-2.374c-60.776 0-110.218 49.44-110.218 110.216 0 15.272 3.044 30.042 9.04 43.922a7.996 7.996 0 0 1-7.33 11.166zM817.486 418.894a7.99 7.99 0 0 1-6.384-12.794c10.398-13.874 15.91-30.416 15.91-47.85 0-35.052-22.406-65.578-55.742-75.96a7.998 7.998 0 0 1 4.746-15.27c40.066 12.476 66.984 49.136 66.984 91.232 0 20.916-6.606 40.784-19.126 57.452a7.972 7.972 0 0 1-6.388 3.19z"
        fill=""
      />
      <path
        d="M796.72 293.782a7.994 7.994 0 0 1-7.696-10.148 80.914 80.914 0 0 0 2.95-21.736c0-35.022-22.376-65.546-55.662-75.954a7.99 7.99 0 0 1-5.246-10.008c1.326-4.216 5.744-6.606 10.024-5.246 40.002 12.498 66.874 49.152 66.874 91.208 0 8.876-1.186 17.644-3.542 26.044a8.008 8.008 0 0 1-7.702 5.84zM738.964 562.854c-47.264 0-70.622-41.33-70.918-41.852a7.984 7.984 0 0 1 3.152-10.836 8.02 8.02 0 0 1 10.852 3.116c1.172 2.124 29.668 51.648 89.406 26.324 42.39-17.964 28.012-61.816 27.372-63.674a7.99 7.99 0 0 1 4.996-10.14 7.984 7.984 0 0 1 10.148 4.988c7.012 20.602 8.462 64.58-36.27 83.564-14.332 6.058-27.244 8.51-38.738 8.51zM751.862 687.876c-0.438 0-0.86-0.032-1.294-0.094a8 8 0 0 1-6.606-9.182c10.196-62.956 0.454-91.67 0.36-91.95-1.454-4.138 0.704-8.728 4.84-10.198 4.168-1.466 8.698 0.624 10.196 4.748 0.468 1.28 11.368 32.226 0.376 99.958a7.978 7.978 0 0 1-7.872 6.718zM783.822 687.876a8.01 8.01 0 0 1-7.806-9.73c15.162-68.216 0.532-106.862 0.376-107.252a7.998 7.998 0 0 1 4.496-10.352c4.076-1.638 8.712 0.36 10.354 4.45 0.702 1.718 16.72 43.112 0.388 116.622a8 8 0 0 1-7.808 6.262z"
        fill=""
      />
      <path
        d="M787.352 544.352c-20.016 0-29.9-15.864-32.446-25.076a8 8 0 0 1 5.59-9.828 7.98 7.98 0 0 1 9.82 5.528c0.766 2.624 5.402 15.48 20.784 13.108 4.34-0.546 8.448 2.342 9.086 6.714a7.978 7.978 0 0 1-6.712 9.086 40.646 40.646 0 0 1-6.122 0.468zM760.106 559.964c-0.516 0-1.016-0.046-1.532-0.14-31.852-6.134-38.47-30.914-38.736-31.96a7.984 7.984 0 0 1 5.778-9.718c4.308-1.04 8.588 1.49 9.696 5.708 0.218 0.772 4.808 16.128 26.294 20.266 4.34 0.828 7.166 5.028 6.338 9.37a7.992 7.992 0 0 1-7.838 6.474zM384.092 671.886a7.954 7.954 0 0 1-5.464-2.156 8 8 0 0 1-1.038-10.492l70.91-99.274h-48.42a7.976 7.976 0 0 1-7.386-4.934 7.976 7.976 0 0 1 1.734-8.71l63.954-63.956c3.124-3.124 8.182-3.124 11.304 0s3.124 8.182 0 11.304l-50.308 50.306h44.656a7.998 7.998 0 0 1 6.504 12.648l-45.054 63.078 112.108-91.714h-41.58a8 8 0 0 1-7.37-4.894 8 8 0 0 1 1.656-8.69l31.986-32.726c3.076-3.146 8.158-3.208 11.312-0.124s3.216 8.142 0.124 11.304L515.008 512h44.974a7.998 7.998 0 0 1 5.06 14.184l-175.89 143.888a7.92 7.92 0 0 1-5.06 1.814z"
        fill=""
      />
      <path
        d="M714.53 498.956c-21.346 0-41.252-7.48-53.432-14.732a7.992 7.992 0 0 1 8.166-13.74c2.388 1.398 59.1 34.172 94.948-11.936 26.78-34.414-1.358-84.276-1.638-84.776a8 8 0 0 1 2.92-10.914 7.98 7.98 0 0 1 10.914 2.912c1.406 2.412 33.852 59.628 0.422 102.598-17.896 23.006-40.816 30.588-62.3 30.588z"
        fill=""
      />
      <path
        d="M815.8 1023.634H368.102a7.99 7.99 0 0 1-7.994-7.994v-102.832c-126.666 15.786-197.328 6.12-224.2-31.182-20.258-28.106-12.436-67.31-1.014-102.912l-16.464-12.522a8.01 8.01 0 0 1-2.436-9.65l8.306-18.424-14.162-14.1a7.992 7.992 0 0 1-2.264-6.806l11.664-80.74-58.794-29.384a7.954 7.954 0 0 1-4.06-4.778 7.964 7.964 0 0 1 0.648-6.246l103.942-187.302c-22.484-100.29-3.576-192.004 54.758-265.42C286.106 55.146 411.362 0.366 542.918 0.366c72.276 0 142.258 16.356 202.372 47.31 117.104 60.284 188.8 141.304 213.098 240.796 41.484 169.902-66.61 347.174-115.012 415.5-64.018 90.358-20.19 307.858-19.752 310.042a8.042 8.042 0 0 1-1.624 6.684 8 8 0 0 1-6.2 2.936z m-439.704-15.988h430.038c-8.104-44.468-36.6-227.12 24.186-312.918 47.138-66.53 152.47-238.954 112.53-402.462-23.14-94.792-92.074-172.308-204.87-230.382-57.88-29.784-125.332-45.53-195.062-45.53-126.794 0-247.254 52.47-314.372 136.934-55.772 70.192-73.408 158.324-51.01 254.872a8.006 8.006 0 0 1-0.804 5.684l-101.374 182.674 56.492 28.246a7.98 7.98 0 0 1 4.332 8.292l-11.914 82.458 15.24 15.176a7.994 7.994 0 0 1 1.638 8.962l-7.97 17.674 15.934 12.118a8.014 8.014 0 0 1 2.732 8.898c-15.66 47-16.55 75.088-2.966 93.934 23.272 32.29 93.886 39.878 218.18 23.516a7.92 7.92 0 0 1 6.314 1.92 7.968 7.968 0 0 1 2.724 6.012v103.922z"
        fill=""
      />
    </svg>
  ),
  briefcase: (
    <svg
      xmlns="http://www.w3.org/2000/svg"
      width="100%"
      height="100%"
      className="pointer-events-none"
      viewBox="0 0 1024 1024"
      fill="#000000">
      <path
        d="M937.04 967.942H89.148c-39.698 0-71.992-32.292-71.992-71.992V543.996c0-4.422 3.578-8 8-8 4.422 0 8 3.578 8 8v351.954c0 30.872 25.122 55.992 55.994 55.992H937.04c30.872 0 55.992-25.122 55.992-55.992V543.996c0-4.422 3.578-8 7.998-8 4.422 0 8 3.578 8 8v351.954c0 39.698-32.294 71.992-71.99 71.992z"
        fill=""
      />
      <path
        d="M909.134 935.946H877.14c-4.406 0-8-3.578-8-8s3.594-7.998 8-7.998h31.994c4.438 0 8 3.576 8 7.998s-3.562 8-8 8z m-63.99 0h-31.996c-4.406 0-8-3.578-8-8s3.594-7.998 8-7.998h31.996c4.436 0 7.998 3.576 7.998 7.998s-3.562 8-7.998 8z m-63.992 0h-31.996c-4.406 0-8-3.578-8-8s3.594-7.998 8-7.998h31.996c4.438 0 7.998 3.576 7.998 7.998s-3.56 8-7.998 8z m-63.992 0h-31.996c-4.406 0-7.998-3.578-7.998-8s3.592-7.998 7.998-7.998h31.996c4.438 0 8 3.576 8 7.998s-3.562 8-8 8z m-63.992 0h-31.996c-4.404 0-7.998-3.578-7.998-8s3.594-7.998 7.998-7.998h31.996c4.438 0 8 3.576 8 7.998s-3.562 8-8 8z m-63.992 0h-31.994c-4.406 0-8-3.578-8-8s3.594-7.998 8-7.998h31.994c4.438 0 8 3.576 8 7.998s-3.562 8-8 8z m-63.982 0h-31.996c-4.422 0-8-3.578-8-8s3.578-7.998 8-7.998h31.996c4.428 0 7.99 3.576 7.99 7.998s-3.562 8-7.99 8z m-63.992 0h-31.996c-4.42 0-7.998-3.578-7.998-8s3.578-7.998 7.998-7.998h31.996c4.422 0 8 3.576 8 7.998s-3.578 8-8 8z m-63.994 0h-31.996c-4.42 0-8-3.578-8-8s3.578-7.998 8-7.998h31.996c4.422 0 8 3.576 8 7.998s-3.578 8-8 8z m-63.99 0h-31.996c-4.422 0-8-3.578-8-8s3.578-7.998 8-7.998h31.996c4.42 0 8 3.576 8 7.998s-3.58 8-8 8z m-63.992 0h-31.996c-4.422 0-8-3.578-8-8s3.578-7.998 8-7.998h31.996c4.42 0 7.998 3.576 7.998 7.998s-3.576 8-7.998 8z m-63.992 0H173.238c-4.42 0-7.998-3.578-7.998-8s3.578-7.998 7.998-7.998h31.996c4.422 0 8 3.576 8 7.998s-3.578 8-8 8z m-63.992 0H109.248c-4.42 0-8-3.578-8-8s3.578-7.998 8-7.998h31.996c4.422 0 8 3.576 8 7.998s-3.58 8-8.002 8z m799.31-4.156a7.968 7.968 0 0 1-7.294-4.734 7.996 7.996 0 0 1 4.016-10.576 40.638 40.638 0 0 0 19.136-17.92c2.062-3.922 6.906-5.376 10.812-3.328a8.004 8.004 0 0 1 3.31 10.828 56.48 56.48 0 0 1-26.714 25.012 7.892 7.892 0 0 1-3.266 0.718zM78.822 928.04a8.028 8.028 0 0 1-4.398-1.328 56.544 56.544 0 0 1-22.374-29.012 7.99 7.99 0 0 1 5.04-10.124c4.188-1.376 8.726 0.86 10.13 5.03 2.836 8.438 8.524 15.812 16.014 20.748a8.014 8.014 0 0 1 2.274 11.092 8.04 8.04 0 0 1-6.686 3.594z m890.214-48.808c-4.422 0-8-3.592-8-7.998v-31.996c0-4.438 3.578-8 8-8a7.984 7.984 0 0 1 7.998 8v31.996a8.004 8.004 0 0 1-7.998 7.998z m-911.884-7.794c-4.422 0-8-3.578-8-8v-31.996c0-4.42 3.578-7.998 8-7.998s8 3.578 8 7.998v31.996c0 4.422-3.578 8-8 8z m911.884-56.196c-4.422 0-8-3.594-8-8v-31.996a7.984 7.984 0 0 1 8-7.998c4.42 0 7.998 3.56 7.998 7.998v31.996c0 4.406-3.578 8-7.998 8z m-911.884-7.796c-4.422 0-8-3.578-8-7.998v-31.996c0-4.422 3.578-8 8-8s8 3.578 8 8v31.996a7.994 7.994 0 0 1-8 7.998z m911.884-56.196c-4.422 0-8-3.594-8-8v-31.996a7.984 7.984 0 0 1 8-7.998 7.984 7.984 0 0 1 7.998 7.998v31.996c0 4.406-3.578 8-7.998 8z m-911.884-7.796c-4.422 0-8-3.578-8-7.998V703.46c0-4.422 3.578-7.998 8-7.998s8 3.576 8 7.998v31.996a7.994 7.994 0 0 1-8 7.998z m911.884-56.196c-4.422 0-8-3.594-8-7.998v-31.996c0-4.438 3.578-8 8-8a7.984 7.984 0 0 1 7.998 8v31.996a8.004 8.004 0 0 1-7.998 7.998z m-911.884-7.796c-4.422 0-8-3.578-8-8v-31.996c0-4.42 3.578-7.998 8-7.998s8 3.578 8 7.998v31.996c0 4.422-3.578 8-8 8z m911.884-56.196c-4.422 0-8-3.594-8-7.998v-31.996a7.984 7.984 0 0 1 8-7.998c4.42 0 7.998 3.56 7.998 7.998v31.996a8.004 8.004 0 0 1-7.998 7.998z m-911.884-7.796c-4.422 0-8-3.578-8-7.998v-31.996c0-4.422 3.578-8 8-8s8 3.578 8 8v31.996a7.994 7.994 0 0 1-8 7.998zM567.992 711.972h-111.986c-4.42 0-8-3.576-8-7.998v-159.978c0-4.422 3.578-8 8-8h111.986c4.422 0 8 3.578 8 8v159.978a7.994 7.994 0 0 1-8 7.998z m-103.986-15.996h95.986v-143.982h-95.986v143.982z"
        fill=""
      />
      <path
        d="M512 663.98c-13.232 0-23.998-10.766-23.998-23.998s10.766-23.996 23.998-23.996 23.996 10.764 23.996 23.996S525.232 663.98 512 663.98z m0-31.996c-4.414 0-8 3.594-8 7.998 0 4.406 3.586 8 8 8s7.998-3.594 7.998-8a8.008 8.008 0 0 0-7.998-7.998z"
        fill=""
      />
      <path
        d="M512 679.976c-4.422 0-8-3.576-8-7.998v-15.998c0-4.422 3.578-7.998 8-7.998s7.998 3.576 7.998 7.998v15.998a7.992 7.992 0 0 1-7.998 7.998zM567.992 600.254h-111.986c-4.42 0-8-3.578-8-8a7.994 7.994 0 0 1 8-7.998h111.986c4.422 0 8 3.578 8 7.998 0 4.422-3.578 8-8 8z"
        fill=""
      />
      <path
        d="M408.014 597.192c-0.164 0-0.328-0.016-0.492-0.016C136.37 580.834 9.22 506.032 3.94 502.852a7.986 7.986 0 0 1-3.874-6.85V272.032c0-48.518 39.47-87.99 87.988-87.99h847.89c48.524 0 87.988 39.472 87.988 87.99v223.97a7.986 7.986 0 0 1-3.876 6.85c-5.282 3.18-132.42 77.982-403.588 94.324-4.204 0.188-8.204-3.094-8.468-7.5a8.002 8.002 0 0 1 7.5-8.466c241.172-14.53 369.154-77.412 392.434-89.91V272.032c0-39.7-32.292-71.992-71.99-71.992H88.054c-39.698 0-71.99 32.292-71.99 71.992V491.3c23.27 12.498 151.262 75.38 392.424 89.91a7.996 7.996 0 1 1-0.474 15.982z"
        fill=""
      />
      <path
        d="M535.996 559.992h-47.994a7.994 7.994 0 0 1-7.998-7.998 7.994 7.994 0 0 1 7.998-7.998h47.994c4.422 0 8 3.578 8 7.998a7.994 7.994 0 0 1-8 7.998zM567.992 527.998c-4.422 0-8-3.578-8-8 0-26.464-21.528-47.994-47.992-47.994-26.466 0-47.994 21.528-47.994 47.994 0 4.422-3.578 8-8 8s-8-3.578-8-8c0-35.284 28.708-63.992 63.992-63.992 35.278 0 63.992 28.708 63.992 63.992a7.992 7.992 0 0 1-7.998 8zM40.06 472.004a7.994 7.994 0 0 1-7.998-8v-15.998c0-4.422 3.578-8 7.998-8 4.422 0 8 3.578 8 8v15.998c0 4.424-3.578 8-8 8zM40.06 420.808a7.994 7.994 0 0 1-7.998-8v-35.198c0-4.422 3.578-8 7.998-8 4.422 0 8 3.578 8 8v35.198c0 4.422-3.578 8-8 8z m0-70.39a7.994 7.994 0 0 1-7.998-8v-35.2a7.994 7.994 0 0 1 7.998-7.998c4.422 0 8 3.578 8 7.998v35.2c0 4.424-3.578 8-8 8zM40.06 280.03a7.994 7.994 0 0 1-7.998-7.998v-15.998c0-4.422 3.578-8 7.998-8 4.422 0 8 3.578 8 8v15.998a7.994 7.994 0 0 1-8 7.998zM983.938 472.004a7.994 7.994 0 0 1-7.998-8v-31.996c0-4.422 3.578-8 7.998-8 4.422 0 8 3.578 8 8v31.996c0 4.424-3.578 8-8 8z m0-63.99a7.994 7.994 0 0 1-7.998-8v-31.996a7.994 7.994 0 0 1 7.998-7.998c4.422 0 8 3.578 8 7.998v31.996c0 4.422-3.578 8-8 8z m0-63.992a7.994 7.994 0 0 1-7.998-8v-31.996c0-4.42 3.578-8 7.998-8 4.422 0 8 3.578 8 8v31.996c0 4.422-3.578 8-8 8z m0-63.992a7.994 7.994 0 0 1-7.998-7.998v-15.998c0-4.422 3.578-8 7.998-8 4.422 0 8 3.578 8 8v15.998a7.994 7.994 0 0 1-8 7.998zM775.964 248.034H248.034a7.994 7.994 0 0 1-7.998-7.998c0-4.422 3.578-8 7.998-8h527.932a7.998 7.998 0 1 1-0.002 15.998zM663.98 136.048H360.02c-4.422 0-8-3.578-8-8V96.052c0-2.084 0.812-4.084 2.266-5.576 1.368-1.406 34.872-34.418 157.714-34.418s156.354 33.012 157.712 34.418a7.986 7.986 0 0 1 2.266 5.576v31.996c0 4.422-3.578 8-7.998 8z m-295.962-15.998H655.98v-20.2c-8.936-6.39-46.212-27.792-143.98-27.792-97.59 0-134.904 21.326-143.982 27.808v20.184z"
        fill=""
      />
      <path
        d="M360.02 168.044c-4.422 0-8-3.578-8-8V128.048a7.994 7.994 0 0 1 8-7.998 7.994 7.994 0 0 1 7.998 7.998v31.996c0 4.422-3.578 8-7.998 8zM392.016 168.044c-4.422 0-8-3.578-8-8V128.048a7.994 7.994 0 0 1 8-7.998 7.994 7.994 0 0 1 7.998 7.998v31.996c0 4.422-3.578 8-7.998 8z"
        fill=""
      />
      <path
        d="M631.984 168.044c-4.422 0-8-3.578-8-8V128.048c0-4.42 3.578-7.998 8-7.998s7.998 3.578 7.998 7.998v31.996c0 4.422-3.576 8-7.998 8z"
        fill=""
      />
      <path
        d="M663.98 168.044c-4.422 0-8-3.578-8-8V128.048a7.994 7.994 0 0 1 8-7.998 7.994 7.994 0 0 1 7.998 7.998v31.996c0 4.422-3.578 8-7.998 8z"
        fill=""
      />
      <path
        d="M551.994 903.95a7.994 7.994 0 0 1-7.998-8v-31.996a7.994 7.994 0 0 1 7.998-7.998 7.994 7.994 0 0 1 7.998 7.998v31.996c0 4.422-3.576 8-7.998 8z m0-63.992a7.994 7.994 0 0 1-7.998-8v-31.994c0-4.422 3.578-8 7.998-8a7.994 7.994 0 0 1 7.998 8v31.994c0 4.42-3.576 8-7.998 8z m0-63.994a7.994 7.994 0 0 1-7.998-7.998v-31.996a7.994 7.994 0 0 1 7.998-7.998 7.992 7.992 0 0 1 7.998 7.998v31.996a7.994 7.994 0 0 1-7.998 7.998z"
        fill=""
      />
      <path
        d="M472.004 903.95c-4.42 0-8-3.578-8-8v-31.996c0-4.42 3.578-7.998 8-7.998s8 3.578 8 7.998v31.996c0 4.422-3.578 8-8 8z m0-63.992c-4.42 0-8-3.578-8-8v-31.994c0-4.422 3.578-8 8-8s8 3.578 8 8v31.994c0 4.42-3.578 8-8 8z m0-63.994c-4.42 0-8-3.578-8-7.998v-31.996c0-4.422 3.578-7.998 8-7.998s8 3.576 8 7.998v31.996a7.994 7.994 0 0 1-8 7.998z"
        fill=""
      />
      <path
        d="M512 903.95c-4.422 0-8-3.578-8-8v-159.978c0-4.422 3.578-7.998 8-7.998s7.998 3.576 7.998 7.998v159.978c0 4.422-3.576 8-7.998 8z"
        fill=""
      />
    </svg>
  ),
  bulbidealight: (
    <svg
      xmlns="http://www.w3.org/2000/svg"
      width="100%"
      height="100%"
      className="pointer-events-none"
      viewBox="0 0 1024 1024"
      fill="#000000">
      <path
        d="M392.07 657.084a7.8 7.8 0 0 1-3.856-1c-81.426-44.952-132.016-130.796-132.016-224.028 0-141.054 114.762-255.816 255.818-255.816a7.988 7.988 0 0 1 7.994 7.994 7.99 7.99 0 0 1-7.994 7.994c-132.25 0-239.83 107.586-239.83 239.828 0 87.406 47.42 167.88 123.74 210.038a7.984 7.984 0 0 1 3.138 10.868 8 8 0 0 1-6.994 4.122z"
        fill=""
      />
      <path
        d="M631.946 657.084a7.996 7.996 0 0 1-6.994-4.124 7.988 7.988 0 0 1 3.136-10.868c76.32-42.156 123.74-122.63 123.74-210.038 0-132.242-107.58-239.828-239.812-239.828a7.99 7.99 0 0 1-7.996-7.994 7.99 7.99 0 0 1 7.996-7.994c141.054 0 255.8 114.762 255.8 255.816 0 93.23-50.588 179.076-132.014 224.028a7.786 7.786 0 0 1-3.856 1.002zM392.1 783.804a7.988 7.988 0 0 1-7.994-7.992v-126.722c0-4.418 3.576-7.994 7.994-7.994s7.994 3.576 7.994 7.994v126.722a7.988 7.988 0 0 1-7.994 7.992z"
        fill=""
      />
      <path
        d="M631.914 783.804a7.988 7.988 0 0 1-7.994-7.992v-126.536a7.988 7.988 0 0 1 7.994-7.994 7.99 7.99 0 0 1 7.994 7.994v126.536a7.988 7.988 0 0 1-7.994 7.992z"
        fill=""
      />
      <path
        d="M631.914 687.876H392.1a7.99 7.99 0 0 1-7.994-7.996 7.988 7.988 0 0 1 7.994-7.992h239.814a7.988 7.988 0 0 1 7.994 7.992 7.992 7.992 0 0 1-7.994 7.996zM599.936 815.784h-175.858a7.99 7.99 0 0 1-5.652-2.342l-31.978-31.976a7.992 7.992 0 1 1 11.304-11.304l29.634 29.634h169.24l29.634-29.634a7.988 7.988 0 0 1 11.304 0 7.988 7.988 0 0 1 0 11.304l-31.978 31.976a7.98 7.98 0 0 1-5.65 2.342zM376.112 735.84a7.992 7.992 0 0 1-0.468-15.974l271.79-15.988c4.358-0.14 8.182 3.108 8.448 7.51a7.998 7.998 0 0 1-7.51 8.448l-271.792 15.988c-0.156 0.016-0.312 0.016-0.468 0.016zM376.112 767.816a7.99 7.99 0 0 1-7.978-7.526 8 8 0 0 1 7.51-8.448l271.79-15.988c4.358-0.312 8.182 3.108 8.448 7.512 0.266 4.402-3.108 8.18-7.51 8.446L376.58 767.8c-0.156 0.016-0.312 0.016-0.468 0.016z"
        fill=""
      />
      <path
        d="M512.016 847.76c-44.406 0-62.362-34.912-63.112-36.396a7.996 7.996 0 0 1 14.286-7.182c0.624 1.218 14.598 27.59 48.826 27.59 34.272 0 48.23-26.464 48.808-27.59a8.016 8.016 0 0 1 10.742-3.514 7.99 7.99 0 0 1 3.544 10.696c-0.748 1.484-18.706 36.396-63.094 36.396zM472.042 655.896a7.988 7.988 0 0 1-7.994-7.994v-63.954a7.99 7.99 0 0 1 7.994-7.996 7.99 7.99 0 0 1 7.996 7.996v63.954a7.99 7.99 0 0 1-7.996 7.994zM551.97 655.896a7.988 7.988 0 0 1-7.994-7.994v-63.954c0-4.42 3.576-7.996 7.994-7.996s7.994 3.576 7.994 7.996v63.954a7.988 7.988 0 0 1-7.994 7.994z"
        fill=""
      />
      <path
        d="M472.042 591.944a8 8 0 0 1-6.246-2.998 8.006 8.006 0 0 1 1.25-11.242l39.972-31.976c3.482-2.75 8.496-2.188 11.242 1.248a8.004 8.004 0 0 1-1.248 11.242l-39.972 31.976a7.966 7.966 0 0 1-4.998 1.75z"
        fill=""
      />
      <path
        d="M551.97 591.944a7.916 7.916 0 0 1-4.996-1.75l-39.956-31.976a8.008 8.008 0 0 1-1.25-11.242 8.006 8.006 0 0 1 11.242-1.248l39.956 31.976a8.006 8.006 0 0 1 1.25 11.242 8 8 0 0 1-6.246 2.998zM472.042 559.964a7.988 7.988 0 0 1-7.994-7.994v-111.92a7.99 7.99 0 0 1 7.994-7.994 7.99 7.99 0 0 1 7.996 7.994v111.92a7.99 7.99 0 0 1-7.996 7.994z"
        fill=""
      />
      <path
        d="M472.042 448.044a7.988 7.988 0 0 1-7.994-7.994c0-13.224-10.758-23.982-23.982-23.982s-23.982 10.758-23.982 23.982a7.988 7.988 0 0 1-7.994 7.994 7.99 7.99 0 0 1-7.996-7.994c0-22.04 17.924-39.97 39.972-39.97s39.972 17.932 39.972 39.97a7.99 7.99 0 0 1-7.996 7.994z"
        fill=""
      />
      <path
        d="M440.066 480.024c-22.046 0-39.972-17.934-39.972-39.972a7.99 7.99 0 0 1 7.996-7.994 7.99 7.99 0 0 1 7.994 7.994c0 13.226 10.758 23.984 23.982 23.984 4.418 0 7.994 3.576 7.994 7.994s-3.576 7.994-7.994 7.994zM551.97 559.964a7.988 7.988 0 0 1-7.994-7.994v-111.92c0-4.418 3.576-7.994 7.994-7.994s7.994 3.576 7.994 7.994v111.92a7.988 7.988 0 0 1-7.994 7.994z"
        fill=""
      />
      <path
        d="M615.926 448.044a7.988 7.988 0 0 1-7.994-7.994c0-13.224-10.758-23.982-23.984-23.982-13.224 0-23.982 10.758-23.982 23.982 0 4.42-3.576 7.994-7.994 7.994s-7.994-3.574-7.994-7.994c0-22.04 17.924-39.97 39.97-39.97s39.972 17.932 39.972 39.97a7.988 7.988 0 0 1-7.994 7.994z"
        fill=""
      />
      <path
        d="M583.948 480.024c-4.418 0-7.994-3.576-7.994-7.996s3.576-7.994 7.994-7.994c13.226 0 23.984-10.758 23.984-23.984a7.988 7.988 0 0 1 7.994-7.994 7.99 7.99 0 0 1 7.994 7.994c0 22.04-17.926 39.974-39.972 39.974zM328.146 440.05a7.99 7.99 0 0 1-7.994-7.994c0-105.792 86.062-191.864 191.864-191.864a7.99 7.99 0 0 1 7.994 7.994 7.99 7.99 0 0 1-7.994 7.996c-96.978 0-175.876 78.896-175.876 175.874a7.988 7.988 0 0 1-7.994 7.994zM520.01 480.024h-15.99c-4.418 0-7.994-3.576-7.994-7.996s3.576-7.994 7.994-7.994h15.99c4.418 0 7.994 3.576 7.994 7.994s-3.576 7.996-7.994 7.996z"
        fill=""
      />
      <path
        d="M53.888 687.938c-3.264 0-6.324-2-7.51-5.246C26.456 628.168 16.354 570.738 16.354 512 16.354 238.704 238.694 16.354 512 16.354c70.856 0 139.198 14.538 203.12 43.204a7.99 7.99 0 0 1 4.03 10.564c-1.794 4.036-6.542 5.816-10.554 4.02-61.864-27.74-128.02-41.8-196.596-41.8C247.516 32.342 32.342 247.516 32.342 512c0 56.866 9.774 112.452 29.056 165.196a8.004 8.004 0 0 1-4.762 10.258 8.084 8.084 0 0 1-2.748 0.484z"
        fill=""
      />
      <path
        d="M663.876 80.308a8.012 8.012 0 0 1-7.932-7.09 7.992 7.992 0 0 1 7.042-8.844l47.964-5.464c4.262-0.57 8.338 2.638 8.854 7.034a7.996 7.996 0 0 1-7.042 8.846l-47.964 5.464a7.526 7.526 0 0 1-0.922 0.054z"
        fill=""
      />
      <path
        d="M711.858 74.844a7.97 7.97 0 0 1-6.386-3.186l-31.976-42.5a7.994 7.994 0 1 1 12.772-9.618l31.976 42.5a7.994 7.994 0 0 1-6.386 12.804z"
        fill=""
      />
      <path
        d="M512 1007.646c-70.888 0-139.23-14.552-203.136-43.236-4.028-1.794-5.824-6.542-4.012-10.57a8.012 8.012 0 0 1 10.57-4.012c61.832 27.746 127.972 41.83 196.58 41.83 264.482 0 479.658-215.176 479.658-479.658 0-56.85-9.76-112.412-29.012-165.14a7.998 7.998 0 0 1 4.762-10.25 8.006 8.006 0 0 1 10.258 4.77c19.892 54.494 29.98 111.898 29.98 170.622C1007.646 785.304 785.304 1007.646 512 1007.646z"
        fill=""
      />
      <path
        d="M312.126 965.114a7.996 7.996 0 0 1-7.932-7.088 7.968 7.968 0 0 1 7.042-8.838l47.966-5.434c4.31-0.562 8.338 2.624 8.852 7.028a7.968 7.968 0 0 1-7.042 8.836l-47.966 5.434a6.148 6.148 0 0 1-0.92 0.062z"
        fill=""
      />
      <path
        d="M344.12 1007.646a7.95 7.95 0 0 1-6.386-3.186l-31.978-42.532c-2.654-3.53-1.952-8.556 1.578-11.196 3.56-2.656 8.556-1.954 11.196 1.576l31.978 42.534c2.654 3.528 1.952 8.554-1.578 11.196a8.06 8.06 0 0 1-4.81 1.608z"
        fill=""
      />
      <path
        d="M743.834 192.228a7.99 7.99 0 0 1-7.994-7.994V144.262c0-4.418 3.576-7.994 7.994-7.994s7.994 3.576 7.994 7.994v39.972a7.99 7.99 0 0 1-7.994 7.994z"
        fill=""
      />
      <path
        d="M879.736 288.16c-79.35 0-143.896-64.556-143.896-143.898S800.386 0.366 879.736 0.366s143.898 64.554 143.898 143.896-64.548 143.898-143.898 143.898z m0-271.806c-70.528 0-127.908 57.38-127.908 127.908 0 70.528 57.38 127.91 127.908 127.91s127.91-57.38 127.91-127.91c0-70.528-57.382-127.908-127.91-127.908z"
        fill=""
      />
      <path
        d="M879.736 328.13c-79.35 0-143.896-64.554-143.896-143.896 0-4.42 3.576-7.994 7.994-7.994s7.994 3.574 7.994 7.994c0 70.528 57.38 127.908 127.908 127.908s127.91-57.38 127.91-127.908a7.988 7.988 0 0 1 7.994-7.994 7.988 7.988 0 0 1 7.994 7.994c0 79.342-64.548 143.896-143.898 143.896z"
        fill=""
      />
      <path
        d="M879.736 200.222a7.99 7.99 0 0 1-7.994-7.994V96.296a7.99 7.99 0 0 1 7.994-7.994 7.99 7.99 0 0 1 7.996 7.994v95.932a7.99 7.99 0 0 1-7.996 7.994zM1015.64 192.228a7.988 7.988 0 0 1-7.994-7.994V144.262a7.988 7.988 0 0 1 7.994-7.994 7.99 7.99 0 0 1 7.994 7.994v39.972a7.99 7.99 0 0 1-7.994 7.994zM823.778 316.092a7.988 7.988 0 0 1-7.994-7.994v-39.972a7.988 7.988 0 0 1 7.994-7.994 7.99 7.99 0 0 1 7.994 7.994v39.972a7.988 7.988 0 0 1-7.994 7.994zM951.686 307.522a7.99 7.99 0 0 1-7.994-7.996v-39.972c0-4.418 3.576-7.994 7.994-7.994s7.994 3.576 7.994 7.994v39.972a7.99 7.99 0 0 1-7.994 7.996z"
        fill=""
      />
      <path
        d="M8.36 887.732a7.988 7.988 0 0 1-7.994-7.994v-39.972a7.988 7.988 0 0 1 7.994-7.994 7.99 7.99 0 0 1 7.994 7.994v39.972a7.99 7.99 0 0 1-7.994 7.994z"
        fill=""
      />
      <path
        d="M144.262 983.664c-79.35 0-143.896-64.548-143.896-143.898s64.546-143.896 143.896-143.896 143.898 64.546 143.898 143.896-64.548 143.898-143.898 143.898z m0-271.806c-70.528 0-127.908 57.38-127.908 127.908s57.38 127.91 127.908 127.91 127.908-57.382 127.908-127.91-57.38-127.908-127.908-127.908z"
        fill=""
      />
      <path
        d="M144.262 1023.634c-79.35 0-143.896-64.548-143.896-143.896a7.99 7.99 0 0 1 7.994-7.996 7.99 7.99 0 0 1 7.994 7.996c0 70.528 57.38 127.908 127.908 127.908s127.908-57.38 127.908-127.908c0-4.42 3.576-7.996 7.996-7.996s7.994 3.576 7.994 7.996c0 79.348-64.548 143.896-143.898 143.896z"
        fill=""
      />
      <path
        d="M144.262 895.726a7.99 7.99 0 0 1-7.994-7.994V791.8a7.99 7.99 0 0 1 7.994-7.996 7.99 7.99 0 0 1 7.994 7.996v95.932a7.99 7.99 0 0 1-7.994 7.994zM280.166 887.732a7.992 7.992 0 0 1-7.996-7.994v-39.972c0-4.418 3.576-7.994 7.996-7.994s7.994 3.576 7.994 7.994v39.972a7.99 7.99 0 0 1-7.994 7.994zM88.302 1011.612a7.988 7.988 0 0 1-7.994-7.994v-39.97c0-4.42 3.576-7.994 7.994-7.994s7.994 3.574 7.994 7.994v39.97a7.988 7.988 0 0 1-7.994 7.994zM216.21 1003.024a7.988 7.988 0 0 1-7.994-7.992V955.06a7.99 7.99 0 0 1 7.994-7.994 7.99 7.99 0 0 1 7.994 7.994v39.972a7.988 7.988 0 0 1-7.994 7.992z"
        fill=""
      />
    </svg>
  ),
  bulblampon: (
    <svg
      xmlns="http://www.w3.org/2000/svg"
      width="100%"
      height="100%"
      className="pointer-events-none"
      viewBox="0 0 24 24"
      fill="none">
      <path
        d="M14.627 14.82L14.3833 14.3834L14.627 14.82ZM9.6556 16.5166L9.16239 16.5988L9.6556 16.5166ZM14.3443 16.5166L13.8511 16.4345V16.4345L14.3443 16.5166ZM18.1285 13.8312C17.9317 13.6375 17.6152 13.6399 17.4215 13.8367C17.2277 14.0335 17.2302 14.3501 17.427 14.5438L18.1285 13.8312ZM18.3159 15.4188C18.5127 15.6125 18.8293 15.6101 19.023 15.4133C19.2167 15.2165 19.2142 14.8999 19.0174 14.7062L18.3159 15.4188ZM19.1111 9.75C18.835 9.75 18.6111 9.97386 18.6111 10.25C18.6111 10.5261 18.835 10.75 19.1111 10.75V9.75ZM20 10.75C20.2761 10.75 20.5 10.5261 20.5 10.25C20.5 9.97386 20.2761 9.75 20 9.75V10.75ZM17.8715 5.51867C17.6747 5.71239 17.6722 6.02897 17.8659 6.22576C18.0596 6.42255 18.3762 6.42504 18.573 6.23133L17.8715 5.51867ZM19.4619 5.35633C19.6587 5.16261 19.6612 4.84603 19.4674 4.64924C19.2737 4.45245 18.9571 4.44996 18.7604 4.64367L19.4619 5.35633ZM5.42702 6.23133C5.62381 6.42504 5.94039 6.42255 6.1341 6.22576C6.32782 6.02897 6.32533 5.71239 6.12854 5.51867L5.42702 6.23133ZM5.23965 4.64367C5.04285 4.44996 4.72628 4.45245 4.53256 4.64924C4.33884 4.84603 4.34134 5.16261 4.53813 5.35633L5.23965 4.64367ZM4.88889 10.75C5.16503 10.75 5.38889 10.5261 5.38889 10.25C5.38889 9.97386 5.16503 9.75 4.88889 9.75V10.75ZM4 9.75C3.72386 9.75 3.5 9.97386 3.5 10.25C3.5 10.5261 3.72386 10.75 4 10.75V9.75ZM6.57298 14.5438C6.76977 14.3501 6.77227 14.0335 6.57855 13.8367C6.38483 13.6399 6.06826 13.6375 5.87146 13.8312L6.57298 14.5438ZM4.98257 14.7062C4.78578 14.8999 4.78329 15.2165 4.97701 15.4133C5.17073 15.6101 5.4873 15.6125 5.68409 15.4188L4.98257 14.7062ZM12.8261 7.94806C13.0045 7.7373 12.9783 7.42181 12.7675 7.24338C12.5567 7.06496 12.2413 7.09118 12.0628 7.30194L12.8261 7.94806ZM10.2222 10.25L9.84061 9.92694C9.7148 10.0755 9.68671 10.2837 9.76861 10.4603C9.85051 10.637 10.0275 10.75 10.2222 10.75V10.25ZM13.7778 10.25L14.1594 10.5731C14.2852 10.4245 14.3133 10.2163 14.2314 10.0397C14.1495 9.86303 13.9725 9.75 13.7778 9.75V10.25ZM11.1739 12.5519C10.9955 12.7627 11.0217 13.0782 11.2325 13.2566C11.4433 13.435 11.7587 13.4088 11.9372 13.1981L11.1739 12.5519ZM10.6667 18.5C10.3905 18.5 10.1667 18.7239 10.1667 19C10.1667 19.2761 10.3905 19.5 10.6667 19.5V18.5ZM13.3333 19.5C13.6095 19.5 13.8333 19.2761 13.8333 19C13.8333 18.7239 13.6095 18.5 13.3333 18.5V19.5ZM7.16667 10.25C7.16667 7.63404 9.32317 5.5 12 5.5V4.5C8.78579 4.5 6.16667 7.06697 6.16667 10.25H7.16667ZM12 5.5C14.6768 5.5 16.8333 7.63404 16.8333 10.25H17.8333C17.8333 7.06697 15.2142 4.5 12 4.5V5.5ZM16.8333 10.25C16.8333 12.0181 15.85 13.5647 14.3833 14.3834L14.8708 15.2566C16.6361 14.2711 17.8333 12.4005 17.8333 10.25H16.8333ZM14.3833 14.3834C13.6807 14.7756 12.8679 15 12 15V16C13.0423 16 14.0225 15.7301 14.8708 15.2566L14.3833 14.3834ZM12 15C11.1321 15 10.3193 14.7756 9.61665 14.3834L9.12923 15.2566C9.97752 15.7301 10.9577 16 12 16V15ZM9.61665 14.3834C8.15004 13.5647 7.16667 12.0181 7.16667 10.25H6.16667C6.16667 12.4005 7.36394 14.2711 9.12923 15.2566L9.61665 14.3834ZM10.1488 16.4344L9.86615 14.7378L8.87974 14.9021L9.16239 16.5988L10.1488 16.4344ZM14.1338 14.7378L13.8511 16.4345L14.8375 16.5988L15.1202 14.9022L14.1338 14.7378ZM17.427 14.5438L18.3159 15.4188L19.0174 14.7062L18.1285 13.8312L17.427 14.5438ZM19.1111 10.75H20V9.75H19.1111V10.75ZM18.573 6.23133L19.4619 5.35633L18.7604 4.64367L17.8715 5.51867L18.573 6.23133ZM6.12854 5.51867L5.23965 4.64367L4.53813 5.35633L5.42702 6.23133L6.12854 5.51867ZM4.88889 9.75H4V10.75H4.88889V9.75ZM5.87146 13.8312L4.98257 14.7062L5.68409 15.4188L6.57298 14.5438L5.87146 13.8312ZM12.0628 7.30194L9.84061 9.92694L10.6038 10.5731L12.8261 7.94806L12.0628 7.30194ZM10.2222 10.75H13.7778V9.75H10.2222V10.75ZM13.3962 9.92694L11.1739 12.5519L11.9372 13.1981L14.1594 10.5731L13.3962 9.92694ZM13.4672 16.75H10.5328V17.75H13.4672V16.75ZM10.6667 19.5H13.3333V18.5H10.6667V19.5ZM13.8511 16.4345C13.8218 16.6107 13.6638 16.75 13.4672 16.75V17.75C14.1413 17.75 14.7259 17.2684 14.8375 16.5988L13.8511 16.4345ZM9.16239 16.5988C9.27395 17.2684 9.85863 17.75 10.5328 17.75V16.75C10.3361 16.75 10.1782 16.6107 10.1488 16.4344L9.16239 16.5988Z"
        fill="#464455"
      />
    </svg>
  ),
  businesscard: (
    <svg
      xmlns="http://www.w3.org/2000/svg"
      width="100%"
      height="100%"
      className="pointer-events-none"
      viewBox="0 0 1024 1024">
      <path d="M96.4 364.2h830.3v529.5H96.4z" fill="#FFFFFF" />
      <path
        d="M926.7 901.7h-16v-16h16v16z m-32 0h-16v-16h16v16z m-32 0h-16v-16h16v16z m-32 0h-16v-16h16v16z m-32 0h-16v-16h16v16z m-32 0h-16v-16h16v16z m-32 0h-16v-16h16v16z m-32 0h-16v-16h16v16z m-32 0h-16v-16h16v16z m-32 0h-16v-16h16v16z m-32 0h-16v-16h16v16z m-32 0h-16v-16h16v16z m-32 0h-16v-16h16v16z m-32 0h-16v-16h16v16z m-32 0h-16v-16h16v16z m-32 0h-16v-16h16v16z m-32 0h-16v-16h16v16z m-32 0h-16v-16h16v16z m-32 0h-16v-16h16v16z m-32 0h-16v-16h16v16z m-32 0h-16v-16h16v16z m-32 0h-16v-16h16v16z m-32 0h-16v-16h16v16z m-32 0h-16v-16h16v16z m-32 0h-16v-16h16v16z m-32 0h-16v-16h16v16z m-22.3-9.7h-16v-16h16v16z m830.3-13.9h-16v-16h16v16zM104.4 860h-16v-16h16v16z m830.3-13.9h-16v-16h16v16zM104.4 828h-16v-16h16v16z m830.3-13.9h-16v-16h16v16zM104.4 796h-16v-16h16v16z m830.3-13.9h-16v-16h16v16zM104.4 764h-16v-16h16v16z m830.3-13.9h-16v-16h16v16zM104.4 732h-16v-16h16v16z m830.3-13.9h-16v-16h16v16zM104.4 700h-16v-16h16v16z m830.3-13.9h-16v-16h16v16zM104.4 668h-16v-16h16v16z m830.3-13.9h-16v-16h16v16zM104.4 636h-16v-16h16v16z m830.3-13.9h-16v-16h16v16zM104.4 604h-16v-16h16v16z m830.3-13.9h-16v-16h16v16zM104.4 572h-16v-16h16v16z m830.3-13.9h-16v-16h16v16zM104.4 540h-16v-16h16v16z m830.3-13.9h-16v-16h16v16zM104.4 508h-16v-16h16v16z m830.3-13.9h-16v-16h16v16zM104.4 476h-16v-16h16v16z m830.3-13.9h-16v-16h16v16zM104.4 444h-16v-16h16v16z m830.3-13.9h-16v-16h16v16zM104.4 412h-16v-16h16v16z m830.3-13.9h-16v-16h16v16zM104.4 380h-16v-23.8h8.2v8h7.8V380z m822.3-7.8h-14.1v-16h22.1v9.9h-8v6.1z m-30.1 0h-16v-16h16v16z m-32 0h-16v-16h16v16z m-32 0h-16v-16h16v16z m-32 0h-16v-16h16v16z m-32 0h-16v-16h16v16z m-32 0h-16v-16h16v16z m-32 0h-16v-16h16v16z m-32 0h-16v-16h16v16z m-32 0h-16v-16h16v16z m-32 0h-16v-16h16v16z m-32 0h-16v-16h16v16z m-32 0h-16v-16h16v16z m-32 0h-16v-16h16v16z m-32 0h-16v-16h16v16z m-32 0h-16v-16h16v16z m-32 0h-16v-16h16v16z m-32 0h-16v-16h16v16z m-32 0h-16v-16h16v16z m-32 0h-16v-16h16v16z m-32 0h-16v-16h16v16z m-32 0h-16v-16h16v16z m-32 0h-16v-16h16v16z m-32 0h-16v-16h16v16z m-32 0h-16v-16h16v16z m-32 0h-16v-16h16v16z"
        fill="#0A0408"
      />
      <path d="M172.6 438.3h677.8v381.4H172.6z" fill="#F4BE6F" />
      <path d="M96.4 258.8h830.3v105.9H96.4z" fill="#55B7A8" />
      <path
        d="M934.7 372.7H88.4V250.8h846.3v121.9z m-830.3-16h814.3v-89.9H104.4v89.9z"
        fill="#0A0408"
      />
      <path d="M457.3 107.2h108.5v203.7H457.3z" fill="#EBB866" />
      <path
        d="M573.8 318.9H449.3V99.2h124.5v219.7z m-108.5-16h92.5V115.2h-92.5v187.7z"
        fill="#0A0408"
      />
      <path
        d="M308.7 560.2m-65.9 0a65.9 65.9 0 1 0 131.8 0 65.9 65.9 0 1 0-131.8 0Z"
        fill="#FFFFFF"
      />
      <path
        d="M308.7 634.1c-40.8 0-73.9-33.2-73.9-73.9s33.2-73.9 73.9-73.9 73.9 33.2 73.9 73.9-33.1 73.9-73.9 73.9z m0-131.9c-32 0-57.9 26-57.9 57.9s26 57.9 57.9 57.9 57.9-26 57.9-57.9-25.9-57.9-57.9-57.9z"
        fill="#0A0408"
      />
      <path
        d="M418.7 767.9c0-60.7-49.2-109.9-109.9-109.9s-109.9 49.2-109.9 109.9h219.8z"
        fill="#FFFFFF"
      />
      <path
        d="M426.7 775.9H190.8v-8c0-65 52.9-117.9 117.9-117.9s117.9 52.9 117.9 117.9v8z m-219.6-16h203.3c-4.1-52.5-48.1-93.9-101.6-93.9s-97.6 41.4-101.7 93.9zM457.3 662.8h313.9v16H457.3zM457.3 751.2h261.8v16H457.3z"
        fill="#0A0408"
      />
      <path d="M457.3 512.7h313.9v65.9H457.3z" fill="#FFFFFF" />
      <path
        d="M779.2 586.7H449.3v-81.9h329.9v81.9z m-313.9-16h297.9v-49.9H465.3v49.9z"
        fill="#0A0408"
      />
      <path
        d="M512 258.6m-20.3 0a20.3 20.3 0 1 0 40.6 0 20.3 20.3 0 1 0-40.6 0Z"
        fill="#FFFFFF"
      />
      <path
        d="M512 287c-15.6 0-28.3-12.7-28.3-28.3s12.7-28.3 28.3-28.3 28.3 12.7 28.3 28.3S527.6 287 512 287z m0-40.7c-6.8 0-12.3 5.5-12.3 12.3S505.2 271 512 271s12.3-5.5 12.3-12.3-5.5-12.4-12.3-12.4z"
        fill="#0A0408"
      />
      <path d="M71.5 868.8h49.8v49.8H71.5z" fill="#DC504F" />
      <path
        d="M129.2 926.6H63.5v-65.8h65.8v65.8z m-49.7-16h33.8v-33.8H79.5v33.8z"
        fill="#0A0408"
      />
      <path d="M899.4 868.8h49.8v49.8h-49.8z" fill="#DC504F" />
      <path
        d="M957.1 926.6h-65.8v-65.8h65.8v65.8z m-49.7-16h33.8v-33.8h-33.8v33.8z"
        fill="#0A0408"
      />
    </svg>
  ),
  briefcaseBusiness: (
    <svg
      xmlns="http://www.w3.org/2000/svg"
      width="100%"
      height="100%"
      className="pointer-events-none"
      viewBox="0 0 1024 1024">
      <path
        d="M512 569.2m-10 0a10 10 0 1 0 20 0 10 10 0 1 0-20 0Z"
        fill="#E73B37"
      />
      <path
        d="M611.8 617.1H406.5L108 390.3v20.1l293 222.7h216l299-223.3v-20L611.8 617.1z"
        fill="#E73B37"
      />
      <path
        d="M704 256.8v-94.5H320v94.5H64v605h896v-605H704z m-340-50.5h296v50.4H364v-50.4z m552 611.5H108V769h808v48.8z m0-64.9H108V300.8h808v452.1z"
        fill="#39393A"
      />
    </svg>
  ),
  calendarColored: (
    <svg
      xmlns="http://www.w3.org/2000/svg"
      width="100%"
      height="100%"
      className="pointer-events-none"
      viewBox="0 0 1024 1024">
      <path
        d="M716 190.9v-67.8h-44v67.8H352v-67.8h-44v67.8H92v710h840v-710H716z m-580 44h172v69.2h44v-69.2h320v69.2h44v-69.2h172v151.3H136V234.9z m752 622H136V402.2h752v454.7z"
        fill="#39393A"
      />
      <path
        d="M319 565.7m-33 0a33 33 0 1 0 66 0 33 33 0 1 0-66 0Z"
        fill="#E73B37"
      />
      <path
        d="M510 565.7m-33 0a33 33 0 1 0 66 0 33 33 0 1 0-66 0Z"
        fill="#E73B37"
      />
      <path
        d="M701.1 565.7m-33 0a33 33 0 1 0 66 0 33 33 0 1 0-66 0Z"
        fill="#E73B37"
      />
      <path
        d="M319 693.4m-33 0a33 33 0 1 0 66 0 33 33 0 1 0-66 0Z"
        fill="#E73B37"
      />
      <path
        d="M510 693.4m-33 0a33 33 0 1 0 66 0 33 33 0 1 0-66 0Z"
        fill="#E73B37"
      />
      <path
        d="M701.1 693.4m-33 0a33 33 0 1 0 66 0 33 33 0 1 0-66 0Z"
        fill="#E73B37"
      />
    </svg>
  ),
  captionBox: (
    <svg
      xmlns="http://www.w3.org/2000/svg"
      width="100%"
      height="100%"
      className="pointer-events-none"
      viewBox="0 0 79.11 72.82">
      <g>
        <g>
          <g>
            <polygon
              points="71.16 28.38 78.46 44.12 71.16 47.06 48.65 56.11 39.77 40.38 39.69 40.24 71.16 28.38"
              style={{
                fill: "none",
                stroke: "#000",
                strokeLinecap: "round",
                strokeLinejoin: "round",
                strokeWidth: "1.3px",
              }}
            />
            <polygon
              points="71.16 47.06 71.16 59.85 40.05 72.17 39.69 40.85 39.49 40.74 39.69 40.42 39.77 40.38 48.65 56.11 71.16 47.06"
              style={{
                fill: "none",
                stroke: "#000",
                strokeLinecap: "round",
                strokeLinejoin: "round",
                strokeWidth: "1.3px",
              }}
            />
            <path
              d="m48.19,19.39v4.99s-1.49,0-1.49,0l-.03-15.15c0-.42.34-.75.75-.75h1.47l-3.64-2.92-3.63,2.92h1.48c.4,0,.74.33.74.75v11.27h-1.51v-10.52h-2.84c-.22,0-.44-.1-.59-.28-.11-.14-.17-.3-.17-.47,0-.22.1-.43.28-.58l5.74-4.63c.27-.22.67-.24.96,0l.13.1,5.58,4.5c.2.14.33.36.33.62,0,.42-.34.75-.75.75h-2.85l.02,9.42Z"
              style={{ fill: "none", strokeWidth: "0px" }}
            />
            <path
              d="m28.87,20.07l-.6-.48c-.32-.26-.38-.73-.12-1.06.15-.18.36-.28.58-.28h2.85V7.73h1.51v11.27c0,.41-.33.75-.75.75h-1.46l3.63,2.91,3.63-2.91h-1.47c-.41,0-.74-.34-.74-.75V3.85h1.51v14.4s2.83,0,2.83,0c.42,0,.75.34.75.75,0,.25-.13.49-.32.63l-5.72,4.59c-.28.22-.68.21-.94,0l-5.15-4.14Z"
              style={{ fill: "none", strokeWidth: "0px" }}
            />
            <polygon
              points="39.69 40.85 40.05 72.17 8.21 59.85 8.21 47.18 30.27 56.11 39.49 40.74 39.69 40.85"
              style={{
                fill: "none",
                stroke: "#000",
                strokeLinecap: "round",
                strokeLinejoin: "round",
                strokeWidth: "1.3px",
              }}
            />
            <polygon
              points="39.69 40.42 39.49 40.74 30.27 56.11 8.21 47.18 .65 44.12 8.21 28.38 39.69 40.42"
              style={{
                fill: "none",
                stroke: "#000",
                strokeLinecap: "round",
                strokeLinejoin: "round",
                strokeWidth: "1.3px",
              }}
            />
          </g>
          <g>
            <polyline
              points="8.21 47.18 8.21 59.85 40.05 72.17 71.16 59.85 71.16 47.06"
              style={{
                fill: "none",
                stroke: "#000",
                strokeLinecap: "round",
                strokeLinejoin: "round",
                strokeWidth: "1.3px",
              }}
            />
            <polygon
              points="8.21 28.38 39.69 40.42 39.49 40.74 30.27 56.11 8.21 47.18 .65 44.12 8.21 28.38"
              style={{
                fill: "none",
                stroke: "#000",
                strokeLinecap: "round",
                strokeLinejoin: "round",
                strokeWidth: "1.3px",
              }}
            />
            <polygon
              points="71.16 28.38 39.69 40.24 39.77 40.38 48.65 56.11 71.16 47.06 78.46 44.12 71.16 28.38"
              style={{
                fill: "none",
                stroke: "#000",
                strokeLinecap: "round",
                strokeLinejoin: "round",
                strokeWidth: "1.3px",
              }}
            />
            <line
              x1="39.69"
              y1="40.85"
              x2="40.05"
              y2="72.17"
              style={{
                fill: "none",
                stroke: "#000",
                strokeLinecap: "round",
                strokeLinejoin: "round",
                strokeWidth: "1.3px",
              }}
            />
            <polyline
              points="30.27 .65 .65 12.65 8.21 28.38 28.87 20.07"
              style={{
                fill: "none",
                stroke: "#000",
                strokeLinecap: "round",
                strokeLinejoin: "round",
                strokeWidth: "1.3px",
              }}
            />
            <polyline
              points="48.65 .65 78.46 12.65 71.16 28.38 48.19 19.39"
              style={{
                fill: "none",
                stroke: "#000",
                strokeLinecap: "round",
                strokeLinejoin: "round",
                strokeWidth: "1.3px",
              }}
            />
          </g>
        </g>
      </g>
    </svg>
  ),
  captionBox2: (
    <svg
      xmlns="http://www.w3.org/2000/svg"
      width="100%"
      height="100%"
      className="pointer-events-none"
      viewBox="0 0 79.11 75.06">
      <g>
        <g>
          <g>
            <polygon
              points="56.96 35.97 56.96 25.27 57.13 25.27 71.16 30.32 71.16 30.61 56.96 35.97"
              style={{
                fill: "none",
                stroke: "#000",
                strokeLinecap: "round",
                strokeLinejoin: "round",
                strokeWidth: "1.3px",
              }}
            />
            <polygon
              points="22.2 24.78 22.26 24.78 22.26 35.98 8.21 30.61 8.05 30.28 22.2 24.78"
              style={{
                fill: "none",
                stroke: "#000",
                strokeLinecap: "round",
                strokeLinejoin: "round",
                strokeWidth: "1.3px",
              }}
            />
            <polygon
              points="39.69 42.65 22.26 35.98 22.26 24.78 22.26 6.26 39.61 11.74 56.96 6.26 56.96 25.27 56.96 35.97 39.69 42.48 39.75 42.61 39.69 42.65"
              style={{
                fill: "none",
                stroke: "#000",
                strokeLinecap: "round",
                strokeLinejoin: "round",
                strokeWidth: "1.3px",
              }}
            />
            <polygon
              points="71.16 49.29 71.16 62.09 40.05 74.41 39.75 49.05 43.39 49.05 48.64 58.35 71.16 49.29"
              style={{
                fill: "none",
                stroke: "#000",
                strokeLinecap: "round",
                strokeLinejoin: "round",
                strokeWidth: "1.3px",
              }}
            />
            <polygon
              points="71.16 48.96 71.16 49.29 48.64 58.35 43.39 49.05 71.16 48.96"
              style={{
                fill: "none",
                stroke: "#000",
                strokeLinecap: "round",
                strokeLinejoin: "round",
                strokeWidth: "1.3px",
              }}
            />
            <polygon
              points="22.26 6.26 22.04 6.19 39.61 .65 57.17 6.19 56.96 6.26 39.61 11.74 22.26 6.26"
              style={{
                fill: "none",
                stroke: "#000",
                strokeLinecap: "round",
                strokeLinejoin: "round",
                strokeWidth: "1.3px",
              }}
            />
            <polygon
              points="71.16 48.96 43.39 49.05 39.75 42.61 39.69 42.48 56.96 35.97 71.16 30.61 78.46 46.36 71.16 49.29 71.16 48.96"
              style={{
                fill: "none",
                stroke: "#000",
                strokeLinecap: "round",
                strokeLinejoin: "round",
                strokeWidth: "1.3px",
              }}
            />
            <polygon
              points="39.75 49.05 40.05 74.41 8.21 62.09 8.21 49.42 30.28 58.35 35.84 49.06 39.75 49.05"
              style={{
                fill: "none",
                stroke: "#000",
                strokeLinecap: "round",
                strokeLinejoin: "round",
                strokeWidth: "1.3px",
              }}
            />
            <polygon
              points="35.84 49.06 30.28 58.35 8.21 49.42 8.21 49.15 35.84 49.06"
              style={{
                fill: "none",
                stroke: "#000",
                strokeLinecap: "round",
                strokeLinejoin: "round",
                strokeWidth: "1.3px",
              }}
            />
            <polygon
              points=".65 46.36 8.21 30.61 22.26 35.98 39.69 42.65 35.84 49.06 8.21 49.15 8.21 49.42 .65 46.36"
              style={{
                fill: "none",
                stroke: "#000",
                strokeLinecap: "round",
                strokeLinejoin: "round",
                strokeWidth: "1.3px",
              }}
            />
          </g>
          <g>
            <polyline
              points="8.21 49.42 8.21 62.09 40.05 74.41 71.16 62.09 71.16 49.29"
              style={{
                fill: "none",
                stroke: "#000",
                strokeLinecap: "round",
                strokeLinejoin: "round",
                strokeWidth: "1.3px",
              }}
            />
            <polygon
              points="8.21 30.61 22.26 35.98 39.69 42.65 35.84 49.06 30.28 58.35 8.21 49.42 .65 46.36 8.21 30.61"
              style={{
                fill: "none",
                stroke: "#000",
                strokeLinecap: "round",
                strokeLinejoin: "round",
                strokeWidth: "1.3px",
              }}
            />
            <polygon
              points="71.16 30.61 56.96 35.97 39.69 42.48 39.75 42.61 43.39 49.05 48.64 58.35 71.16 49.29 78.46 46.36 71.16 30.61"
              style={{
                fill: "none",
                stroke: "#000",
                strokeLinecap: "round",
                strokeLinejoin: "round",
                strokeWidth: "1.3px",
              }}
            />
            <line
              x1="8.05"
              y1="30.28"
              x2="22.2"
              y2="24.78"
              style={{
                fill: "none",
                stroke: "#000",
                strokeLinecap: "round",
                strokeLinejoin: "round",
                strokeWidth: "1.3px",
              }}
            />
            <line
              x1="57.13"
              y1="25.27"
              x2="71.16"
              y2="30.32"
              style={{
                fill: "none",
                stroke: "#000",
                strokeLinecap: "round",
                strokeLinejoin: "round",
                strokeWidth: "1.3px",
              }}
            />
            <polyline
              points="39.69 43.09 39.75 49.05 40.05 74.41"
              style={{
                fill: "none",
                stroke: "#000",
                strokeLinecap: "round",
                strokeLinejoin: "round",
                strokeWidth: "1.3px",
              }}
            />
            <polyline
              points="56.96 6.26 56.96 25.27 56.96 35.97 56.96 35.98"
              style={{
                fill: "none",
                stroke: "#000",
                strokeLinecap: "round",
                strokeLinejoin: "round",
                strokeWidth: "1.3px",
              }}
            />
            <polyline
              points="22.26 35.98 22.26 24.78 22.26 6.26"
              style={{
                fill: "none",
                stroke: "#000",
                strokeLinecap: "round",
                strokeLinejoin: "round",
                strokeWidth: "1.3px",
              }}
            />
            <polygon
              points="22.26 6.26 22.04 6.19 39.61 .65 57.17 6.19 56.96 6.26 39.61 11.74 22.26 6.26"
              style={{
                fill: "none",
                stroke: "#000",
                strokeLinecap: "round",
                strokeLinejoin: "round",
                strokeWidth: "1.3px",
              }}
            />
            <line
              x1="28.67"
              y1="17.87"
              x2="28.67"
              y2="31.41"
              style={{
                fill: "none",
                stroke: "#000",
                strokeLinecap: "round",
                strokeLinejoin: "round",
                strokeWidth: "1.3px",
              }}
            />
            <line
              x1="50.42"
              y1="12.74"
              x2="50.42"
              y2="26.28"
              style={{
                fill: "none",
                stroke: "#000",
                strokeLinecap: "round",
                strokeLinejoin: "round",
                strokeWidth: "1.3px",
              }}
            />
          </g>
        </g>
      </g>
    </svg>
  ),
  casePPT: (
    <svg
      xmlns="http://www.w3.org/2000/svg"
      width="100%"
      height="100%"
      className="pointer-events-none"
      viewBox="0 0 1024 1024"
      fill="#000000">
      <path
        d="M336.150126 671.57242c-79.30497 0-143.830841-64.517874-143.830841-143.83084s64.525871-143.828841 143.830841-143.828842 143.830841 64.515875 143.83084 143.828842-64.525871 143.830841-143.83084 143.83084z m0-271.679144c-70.495083 0-127.848303 57.35322-127.848304 127.848304s57.35322 127.848303 127.848304 127.848303 127.848303-57.35322 127.848303-127.848303-57.35322-127.848303-127.848303-127.848304z"
        fill=""
      />
      <path
        d="M336.150126 703.535496c-79.30497 0-143.830841-64.515875-143.830841-143.830841a7.986271 7.986271 0 0 1 7.992268-7.990269 7.986271 7.986271 0 0 1 7.990269 7.990269c0 70.497083 57.35322 127.850302 127.848304 127.850302s127.848303-57.35322 127.848303-127.850302a7.986271 7.986271 0 0 1 7.990269-7.990269 7.986271 7.986271 0 0 1 7.992268 7.990269c0 79.312966-64.525871 143.830841-143.83084 143.830841z"
        fill=""
      />
      <path
        d="M200.311553 567.694924a7.986271 7.986271 0 0 1-7.992268-7.992268v-31.961076a7.986271 7.986271 0 0 1 7.992268-7.990269 7.986271 7.986271 0 0 1 7.990269 7.990269v31.961076a7.986271 7.986271 0 0 1-7.990269 7.992268zM471.990697 567.694924a7.986271 7.986271 0 0 1-7.990269-7.992268v-31.961076a7.986271 7.986271 0 0 1 7.990269-7.990269 7.986271 7.986271 0 0 1 7.992268 7.990269v31.961076a7.98827 7.98827 0 0 1-7.992268 7.992268zM336.150126 591.66773c-35.247542 0-63.926151-28.670613-63.926151-63.92615s28.678609-63.924152 63.926151-63.924152 63.924152 28.668614 63.924151 63.924152-28.67661 63.926151-63.924151 63.92615z m0-111.867765c-26.437655 0-47.943614 21.505958-47.943614 47.941615s21.505958 47.941614 47.943614 47.941614 47.943614-21.505958 47.943613-47.941614-21.505958-47.941614-47.943613-47.941615z"
        fill=""
      />
      <path
        d="M389.775086 551.712387a8.01026 8.01026 0 0 1-7.662422-5.709334C376.119463 525.838468 357.220287 511.761042 336.150126 511.761042s-39.969337 14.077427-45.96054 34.242011c-1.257413 4.228026-5.649362 6.61691-9.941358 5.383486a8.002263 8.002263 0 0 1-5.383486-9.943357c7.998265-26.889444 33.1945-45.664678 61.287383-45.664678s53.289118 18.775233 61.287383 45.664678a8.006262 8.006262 0 0 1-5.383487 9.943357c-0.765642 0.219897-1.531285 0.325848-2.280935 0.325848zM296.120817 495.70254a7.970278 7.970278 0 0 1-5.649362-2.340907l-56.013846-56.013845a7.98827 7.98827 0 1 1 11.298725-11.298725l56.011846 56.013846a7.984272 7.984272 0 0 1 0 11.298724 7.962282 7.962282 0 0 1-5.647363 2.340907zM336.150126 671.57242a7.986271 7.986271 0 0 1-7.990269-7.992268v-79.90469a7.986271 7.986271 0 0 1 7.990269-7.992268 7.986271 7.986271 0 0 1 7.990269 7.992268v79.90469a7.986271 7.986271 0 0 1-7.990269 7.992268zM424.031091 144.194671c-39.657483 0-71.91642-32.258937-71.91642-71.914421 0-39.657483 32.258937-71.91642 71.91642-71.91642 23.806884 0 46.186434 12.14233 59.484225 31.961076H487.955243a7.986271 7.986271 0 0 1 7.990269 7.990269v63.926151A7.986271 7.986271 0 0 1 487.955243 112.231595h-4.439927c-13.303788 19.822744-35.683338 31.963075-59.484225 31.963076z m0-127.848304c-30.8396 0-55.933883 25.096282-55.933883 55.933883s25.096282 55.931884 55.933883 55.931883c19.672814 0 38.126198-10.720994 48.153516-27.982933a7.976276 7.976276 0 0 1 6.906775-3.980142h0.873592V48.309443h-0.873592a7.998265 7.998265 0 0 1-6.914772-3.980142c-10.167253-17.527816-28.160851-27.982934-48.145519-27.982934z"
        fill=""
      />
      <path
        d="M535.914849 112.233594H487.955243a7.986271 7.986271 0 0 1-7.990269-7.990269V40.317175A7.986271 7.986271 0 0 1 487.955243 32.326905h47.959606c2.123009 0 4.150062 0.843606 5.649362 2.340907l15.980538 15.980539a7.980274 7.980274 0 0 1 2.340907 5.649362v31.963075a7.980274 7.980274 0 0 1-2.340907 5.649362l-15.980538 15.980538a7.982273 7.982273 0 0 1-5.649362 2.342906z m-39.967338-15.982537h36.658883l11.298724-11.298724V59.606168l-11.298724-11.298724h-36.658883v47.943613z"
        fill=""
      />
      <path
        d="M519.934311 112.233594A7.986271 7.986271 0 0 1 511.944042 104.243325V40.317175c0-4.415938 3.574331-7.990269 7.990269-7.99027s7.990269 3.574331 7.990269 7.99027v63.92615a7.98827 7.98827 0 0 1-7.990269 7.990269zM471.974705 96.251057a7.974277 7.974277 0 0 1-5.649363-2.340907l-15.980538-15.982537a7.984272 7.984272 0 0 1 0-11.298724l15.980538-15.982537a7.98827 7.98827 0 1 1 11.298725 11.298724l-10.331176 10.331176 10.331176 10.331176a7.984272 7.984272 0 0 1 0 11.298724 7.94629 7.94629 0 0 1-5.649362 2.344905z"
        fill=""
      />
      <path
        d="M471.974705 96.251057h-47.941615a7.986271 7.986271 0 0 1-7.990269-7.990269 7.986271 7.986271 0 0 1 7.990269-7.990269h47.941615a7.986271 7.986271 0 0 1 7.992268 7.990269 7.98827 7.98827 0 0 1-7.992268 7.990269zM471.974705 64.289981h-47.941615c-4.415938 0-7.990269-3.574331-7.990269-7.990269s3.574331-7.990269 7.990269-7.990269h47.941615c4.417937 0 7.992268 3.574331 7.992268 7.990269s-3.574331 7.990269-7.992268 7.990269zM631.802076 128.214133a7.984272 7.984272 0 0 1-7.990269-7.99027c0-22.035711-17.917634-39.951345-39.953345-39.951345a7.986271 7.986271 0 0 1-7.990269-7.990269 7.986271 7.986271 0 0 1 7.990269-7.992268c30.8396 0 55.933883 25.096282 55.933883 55.933882a7.986271 7.986271 0 0 1-7.990269 7.99027z"
        fill=""
      />
      <path
        d="M631.802076 224.10136a7.984272 7.984272 0 0 1-7.990269-7.99027V120.223863a7.984272 7.984272 0 0 1 7.990269-7.990269 7.986271 7.986271 0 0 1 7.990269 7.990269v95.887227a7.986271 7.986271 0 0 1-7.990269 7.99027zM519.934311 224.10136h-31.963076a7.986271 7.986271 0 0 1-7.990269-7.99027V184.148015a7.984272 7.984272 0 0 1 7.990269-7.990269h31.963076a7.984272 7.984272 0 0 1 7.990269 7.990269v31.961076a7.986271 7.986271 0 0 1-7.990269 7.992269z m-23.972807-15.982538H511.944042v-15.980538h-15.982538v15.980538zM935.444295 815.403261H88.443788a7.986271 7.986271 0 0 1-7.990269-7.990269V280.035242a7.986271 7.986271 0 0 1 7.990269-7.992268h847.000507a7.986271 7.986271 0 0 1 7.990269 7.992268v527.37775a7.986271 7.986271 0 0 1-7.990269 7.990269z m-839.010238-15.982537h831.019969V288.025511H96.434057v511.395213z"
        fill=""
      />
      <path
        d="M967.405371 288.025511H56.480713a7.986271 7.986271 0 0 1-7.990269-7.990269v-63.926151a7.986271 7.986271 0 0 1 7.990269-7.990269h910.924658a7.986271 7.986271 0 0 1 7.990269 7.990269v63.926151a7.986271 7.986271 0 0 1-7.990269 7.990269z m-902.934389-15.982537H959.415102v-47.943614H64.470982v47.943614z"
        fill=""
      />
      <path
        d="M919.461758 256.062436H104.426325a7.986271 7.986271 0 0 1-7.992268-7.992268 7.986271 7.986271 0 0 1 7.992268-7.990269h815.037432a7.986271 7.986271 0 0 1 7.990269 7.990269 7.986271 7.986271 0 0 1-7.992268 7.992268zM727.689303 1023.156254a7.856332 7.856332 0 0 1-3.574331-0.843606l-215.745261-107.871631a7.994267 7.994267 0 0 1-3.574331-10.720994c1.975078-3.950156 6.782833-5.571399 10.722993-3.574331l215.743262 107.871631a7.998265 7.998265 0 0 1 3.574331 10.720994 7.986271 7.986271 0 0 1-7.146663 4.417937zM791.611455 1023.156254a7.848335 7.848335 0 0 1-3.572331-0.843606l-279.669413-139.834707a7.992268 7.992268 0 0 1-3.574331-10.720994c1.975078-3.932164 6.782833-5.571399 10.722993-3.572332l279.667413 139.832708a7.990269 7.990269 0 1 1-3.574331 15.138931z"
        fill=""
      />
      <path
        d="M791.611455 1023.156254h-63.924151c-4.415938 0-7.990269-3.574331-7.990269-7.990269s3.574331-7.990269 7.990269-7.990269h63.924151c4.417937 0 7.992268 3.574331 7.992269 7.990269s-3.574331 7.990269-7.992269 7.990269zM296.206777 1023.156254a7.992268 7.992268 0 0 1-3.582328-15.138931l215.745262-107.871631c3.956153-1.997068 8.739919-0.375825 10.720994 3.574331a7.992268 7.992268 0 0 1-3.572332 10.720994l-215.747261 107.871631a7.856332 7.856332 0 0 1-3.564335 0.843606zM232.282625 1023.156254a7.992268 7.992268 0 0 1-3.582327-15.138931l279.669413-139.832708c3.956153-1.999067 8.739919-0.359832 10.720994 3.572332a7.992268 7.992268 0 0 1-3.572332 10.720994l-279.669413 139.834707a7.876322 7.876322 0 0 1-3.566335 0.843606z"
        fill=""
      />
      <path
        d="M296.19878 1023.156254H232.274629c-4.415938 0-7.990269-3.574331-7.990269-7.990269s3.574331-7.990269 7.990269-7.990269h63.924151c4.415938 0 7.992268 3.574331 7.992268 7.990269s-3.57633 7.990269-7.992268 7.990269zM495.961504 891.311817a7.986271 7.986271 0 0 1-7.990269-7.99027v-75.910554c0-4.415938 3.574331-7.990269 7.990269-7.990269s7.990269 3.574331 7.990269 7.990269v75.910554a7.984272 7.984272 0 0 1-7.990269 7.99027z"
        fill=""
      />
      <path
        d="M527.92458 891.311817a7.984272 7.984272 0 0 1-7.990269-7.99027v-75.910554a7.984272 7.984272 0 0 1 7.990269-7.990269 7.986271 7.986271 0 0 1 7.990269 7.990269v75.910554a7.986271 7.986271 0 0 1-7.990269 7.99027z"
        fill=""
      />
      <path
        d="M527.92458 1023.156254a7.984272 7.984272 0 0 1-7.990269-7.990269v-99.883361a7.984272 7.984272 0 0 1 7.990269-7.990269 7.986271 7.986271 0 0 1 7.990269 7.990269v99.883361a7.986271 7.986271 0 0 1-7.990269 7.990269z"
        fill=""
      />
      <path
        d="M527.92458 1023.156254h-31.963076c-4.415938 0-7.990269-3.574331-7.990269-7.990269s3.574331-7.990269 7.990269-7.990269h31.963076c4.415938 0 7.990269 3.574331 7.990269 7.990269s-3.574331 7.990269-7.990269 7.990269z"
        fill=""
      />
      <path
        d="M495.961504 1023.156254a7.986271 7.986271 0 0 1-7.990269-7.990269v-99.883361c0-4.415938 3.574331-7.990269 7.990269-7.990269s7.990269 3.574331 7.990269 7.990269v99.883361a7.984272 7.984272 0 0 1-7.990269 7.990269z"
        fill=""
      />
      <path
        d="M8.569084 479.799965a7.986271 7.986271 0 0 1-7.990269-7.992268c0-30.837601 25.094283-55.933883 55.931884-55.933882a7.986271 7.986271 0 0 1 7.990269 7.990269 7.986271 7.986271 0 0 1-7.990269 7.990269c-22.029714 0-39.951345 17.915635-39.951346 39.953344a7.986271 7.986271 0 0 1-7.990269 7.992268z"
        fill=""
      />
      <path
        d="M56.480713 527.74158c-30.837601 0-55.931884-25.096282-55.931884-55.933883a7.984272 7.984272 0 0 1 7.990269-7.990269 7.986271 7.986271 0 0 1 7.990269 7.990269c0 22.035711 17.923631 39.953344 39.951346 39.953345a7.986271 7.986271 0 0 1 7.990269 7.990269 7.984272 7.984272 0 0 1-7.990269 7.990269zM168.348478 431.854353H56.512698a7.986271 7.986271 0 0 1-7.990269-7.990269 7.986271 7.986271 0 0 1 7.990269-7.990269h111.83578a7.986271 7.986271 0 0 1 7.992268 7.990269 7.986271 7.986271 0 0 1-7.992268 7.990269z"
        fill=""
      />
      <path
        d="M967.373386 431.854353a7.986271 7.986271 0 0 1-7.990269-7.990269 7.986271 7.986271 0 0 1 7.990269-7.990269c22.035711 0 39.953344-17.915635 39.953345-39.953345a7.984272 7.984272 0 0 1 7.990269-7.990269 7.986271 7.986271 0 0 1 7.990269 7.990269c0.001999 30.8396-25.094283 55.933883-55.933883 55.933883z"
        fill=""
      />
      <path
        d="M1015.348985 383.912738a7.986271 7.986271 0 0 1-7.990269-7.992268c0-22.035711-17.917634-39.953344-39.953345-39.953344a7.986271 7.986271 0 0 1-7.990269-7.990269 7.986271 7.986271 0 0 1 7.990269-7.990269c30.8396 0 55.933883 25.096282 55.933883 55.933882a7.986271 7.986271 0 0 1-7.990269 7.992268zM967.373386 431.854353h-79.872704a7.986271 7.986271 0 0 1-7.992269-7.990269 7.986271 7.986271 0 0 1 7.992269-7.990269h79.872704a7.986271 7.986271 0 0 1 7.990269 7.990269 7.984272 7.984272 0 0 1-7.990269 7.990269z"
        fill=""
      />
      <path
        d="M8.569084 719.516034a7.984272 7.984272 0 0 1-7.990269-7.990269c0-30.8396 25.094283-55.933883 55.931884-55.933883a7.986271 7.986271 0 0 1 7.990269 7.990269 7.986271 7.986271 0 0 1-7.990269 7.992268c-22.029714 0-39.951345 17.915635-39.951346 39.951346a7.986271 7.986271 0 0 1-7.990269 7.990269z"
        fill=""
      />
      <path
        d="M168.348478 671.57242H56.512698a7.986271 7.986271 0 0 1-7.990269-7.992268 7.986271 7.986271 0 0 1 7.990269-7.990269h111.83578a7.986271 7.986271 0 0 1 7.992268 7.990269 7.986271 7.986271 0 0 1-7.992268 7.992268z"
        fill=""
      />
      <path
        d="M967.373386 671.57242a7.986271 7.986271 0 0 1-7.990269-7.992268 7.986271 7.986271 0 0 1 7.990269-7.990269c22.035711 0 39.953344-17.915635 39.953345-39.951345a7.984272 7.984272 0 0 1 7.990269-7.990269 7.986271 7.986271 0 0 1 7.990269 7.990269c0.001999 30.8396-25.094283 55.933883-55.933883 55.933882z"
        fill=""
      />
      <path
        d="M1015.348985 623.628807a7.984272 7.984272 0 0 1-7.990269-7.990269c0-22.035711-17.917634-39.953344-39.953345-39.953345a7.984272 7.984272 0 0 1-7.990269-7.98827 7.986271 7.986271 0 0 1 7.990269-7.992268c30.8396 0 55.933883 25.096282 55.933883 55.933883a7.986271 7.986271 0 0 1-7.990269 7.990269zM967.373386 671.57242h-207.723007a7.986271 7.986271 0 0 1-7.990269-7.992268 7.986271 7.986271 0 0 1 7.990269-7.990269h207.723007a7.986271 7.986271 0 0 1 7.990269 7.990269 7.986271 7.986271 0 0 1-7.990269 7.992268z"
        fill=""
      />
      <path
        d="M823.57653 431.854353H535.914849a7.986271 7.986271 0 0 1-7.990269-7.990269 7.986271 7.986271 0 0 1 7.990269-7.990269h287.659682a7.986271 7.986271 0 0 1 7.990269 7.990269 7.982273 7.982273 0 0 1-7.98827 7.990269z"
        fill=""
      />
      <path
        d="M823.57653 479.799965H535.914849c-4.415938 0-7.990269-3.574331-7.990269-7.992268s3.574331-7.990269 7.990269-7.990269h287.659682c4.415938 0 7.990269 3.574331 7.990269 7.990269s-3.572332 7.992268-7.98827 7.992268z"
        fill=""
      />
      <path
        d="M823.57653 527.74158H535.914849a7.984272 7.984272 0 0 1-7.990269-7.990269 7.986271 7.986271 0 0 1 7.990269-7.990269h287.659682a7.986271 7.986271 0 0 1 7.990269 7.990269 7.982273 7.982273 0 0 1-7.98827 7.990269z"
        fill=""
      />
      <path
        d="M823.57653 575.699187H535.914849a7.984272 7.984272 0 0 1-7.990269-7.98827 7.986271 7.986271 0 0 1 7.990269-7.992268h287.659682a7.986271 7.986271 0 0 1 7.990269 7.992268 7.982273 7.982273 0 0 1-7.98827 7.98827z"
        fill=""
      />
      <path
        d="M823.57653 623.628807H535.914849c-4.415938 0-7.990269-3.574331-7.990269-7.990269s3.574331-7.990269 7.990269-7.990269h287.659682c4.415938 0 7.990269 3.574331 7.990269 7.990269s-3.572332 7.990269-7.98827 7.990269z"
        fill=""
      />
      <path
        d="M695.728227 671.57242h-159.811379a7.986271 7.986271 0 0 1-7.990269-7.992268 7.986271 7.986271 0 0 1 7.990269-7.990269h159.811379a7.984272 7.984272 0 0 1 7.98827 7.990269 7.984272 7.984272 0 0 1-7.98827 7.992268z"
        fill=""
      />
      <path
        d="M8.569084 1023.156254a7.984272 7.984272 0 0 1-7.990269-7.990269V711.525765a7.984272 7.984272 0 0 1 7.990269-7.990269 7.984272 7.984272 0 0 1 7.990269 7.990269V1015.165985a7.986271 7.986271 0 0 1-7.990269 7.990269z"
        fill=""
      />
    </svg>
  ),
  cast: (
    <svg
      xmlns="http://www.w3.org/2000/svg"
      width="100%"
      height="100%"
      className="pointer-events-none"
      viewBox="0 0 24 24"
      fill="none">
      <path
        d="M4 10V7C4 6.44772 4.44772 6 5 6H19C19.5523 6 20 6.44772 20 7V17C20 17.5523 19.5523 18 19 18H12M6 18C6 16.8954 5.10457 16 4 16M8 18C8 15.7909 6.20914 14 4 14M4 12C7.31371 12 10 14.6863 10 18"
        stroke="#464455"
        strokeLinecap="round"
        strokeLinejoin="round"
      />
    </svg>
  ),
  cellphone: (
    <svg
      xmlns="http://www.w3.org/2000/svg"
      width="100%"
      height="100%"
      className="pointer-events-none"
      viewBox="0 0 1024 1024">
      <path
        d="M517.8 811c17.1 0 31 13.9 31 30.9 0 17.1-13.9 30.9-31 30.9s-31-13.9-31-30.9 13.9-30.9 31-30.9m0-20c-28.1 0-51 22.8-51 50.9 0 28.1 22.8 50.9 51 50.9s51-22.8 51-50.9c-0.1-28.1-22.9-50.9-51-50.9zM334.218 304.477l65.69-65.69 14.142 14.143-65.69 65.69zM352.086 387.799L483.253 256.63l14.142 14.142-131.167 131.168z"
        fill="#E73B37"
      />
      <path
        d="M808 108.4v807.2H216V108.4h592m44-44H172v895.2h680V64.4z"
        fill="#39393A"
      />
      <path
        d="M747.1 173.4v572.9H279.9V173.4h467.2m22-22H257.9v616.9h511.2V151.4z"
        fill="#39393A"
      />
    </svg>
  ),
  chartboard: (
    <svg
      xmlns="http://www.w3.org/2000/svg"
      width="100%"
      height="100%"
      className="pointer-events-none"
      viewBox="0 0 79.11 72.36">
      <g>
        <g>
          <path
            d="m72.77,52.29H6.34c-.36,0-.65-.29-.65-.65V12.74c0-.36.29-.65.65-.65h66.43c.36,0,.65.29.65.65v38.9c0,.36-.29.65-.65.65Zm-65.78-1.3h65.13V13.39H6.99v37.6Z"
            style={{ strokeWidth: "0px" }}
          />
          <path
            d="m78.46,13.39H.65c-.36,0-.65-.29-.65-.65v-5.6c0-.36.29-.65.65-.65h77.81c.36,0,.65.29.65.65v5.6c0,.36-.29.65-.65.65ZM1.3,12.09h76.51v-4.3H1.3v4.3Z"
            style={{ strokeWidth: "0px" }}
          />
          <path
            d="m54.3,72.36c-.17,0-.33-.06-.46-.19l-10.62-10.61h-7.02l-10.62,10.61c-.25.25-.66.25-.92,0l-2.08-2.07c-.12-.12-.19-.29-.19-.46,0-.17.07-.34.19-.46l10.36-10.36v-7.18c0-.36.29-.65.65-.65h11.93c.36,0,.65.29.65.65v6.87l10.67,10.67c.12.12.19.29.19.46s-.07.34-.19.46l-2.07,2.07c-.13.13-.29.19-.46.19Zm-30.35-2.72l1.16,1.15,10.36-10.35c.12-.12.29-.19.46-.19h7.56c.17,0,.34.07.46.19l10.35,10.34,1.15-1.15-10.4-10.4c-.12-.12-.19-.29-.19-.46v-6.49h-10.63v6.8c0,.17-.07.34-.19.46l-10.09,10.09Z"
            style={{ strokeWidth: "0px" }}
          />
          <path
            d="m57.15,46.31h-4.67c-.36,0-.65-.29-.65-.65v-23.69c0-.36.29-.65.65-.65h4.67c.36,0,.65.29.65.65v23.69c0,.36-.29.65-.65.65Zm-4.02-1.3h3.37v-22.39h-3.37v22.39Z"
            style={{ strokeWidth: "0px" }}
          />
          <path
            d="m49.52,46.31h-4.66c-.36,0-.65-.29-.65-.65v-20.75c0-.36.29-.65.65-.65h4.66c.36,0,.65.29.65.65v20.75c0,.36-.29.65-.65.65Zm-4.01-1.3h3.36v-19.45h-3.36v19.45Z"
            style={{ strokeWidth: "0px" }}
          />
          <path
            d="m41.89,46.31h-4.66c-.36,0-.65-.29-.65-.65v-17.9c0-.36.29-.65.65-.65h4.66c.36,0,.65.29.65.65v17.9c0,.36-.29.65-.65.65Zm-4.01-1.3h3.36v-16.59h-3.36v16.59Z"
            style={{ strokeWidth: "0px" }}
          />
          <path
            d="m34.25,46.31h-4.66c-.36,0-.65-.29-.65-.65v-13.92c0-.36.29-.65.65-.65h4.66c.36,0,.65.29.65.65v13.92c0,.36-.29.65-.65.65Zm-4.01-1.3h3.36v-12.62h-3.36v12.62Z"
            style={{ strokeWidth: "0px" }}
          />
          <path
            d="m26.62,46.31h-4.67c-.36,0-.65-.29-.65-.65v-9.77c0-.36.29-.65.65-.65h4.67c.36,0,.65.29.65.65v9.77c0,.36-.29.65-.65.65Zm-4.02-1.3h3.37v-8.47h-3.37v8.47Z"
            style={{ strokeWidth: "0px" }}
          />
          <path
            d="m60.32,49.21H18.78c-.36,0-.65-.29-.65-.65s.29-.65.65-.65h41.55c.36,0,.65.29.65.65s-.29.65-.65.65Z"
            style={{ strokeWidth: "0px" }}
          />
          <path
            d="m21.97,32.41c-.27,0-.52-.16-.61-.43-.12-.34.05-.71.39-.83.17-.06,17.55-6.39,25.17-15.26.23-.27.64-.3.92-.07.27.23.3.64.07.92-7.85,9.13-24.99,15.38-25.72,15.64-.07.03-.15.04-.22.04Z"
            style={{ strokeWidth: "0px" }}
          />
          <path
            d="m47.32,20.94c-.36,0-.65-.29-.65-.65v-3.22l-3.02.02h0c-.36,0-.65-.29-.65-.65,0-.36.29-.65.65-.65l3.67-.02h0c.17,0,.34.07.46.19.12.12.19.29.19.46v3.88c0,.36-.29.65-.65.65Z"
            style={{ strokeWidth: "0px" }}
          />
          <path
            d="m42.08,7.79h-5.06c-.36,0-.65-.29-.65-.65v-3.96c0-1.75,1.43-3.18,3.18-3.18s3.18,1.43,3.18,3.18v3.96c0,.36-.29.65-.65.65Zm-4.41-1.3h3.76v-3.31c0-1.04-.84-1.88-1.88-1.88s-1.88.84-1.88,1.88v3.31Z"
            style={{ strokeWidth: "0px" }}
          />
        </g>
      </g>
    </svg>
  ),
  chat: (
    <svg
      xmlns="http://www.w3.org/2000/svg"
      width="100%"
      height="100%"
      className="pointer-events-none"
      viewBox="0 0 66.96 79.11">
      <g>
        <g>
          <path
            d="m10.85,12.58c-3.47,0-6.3-2.82-6.3-6.29S7.38,0,10.85,0s6.3,2.82,6.3,6.3-2.83,6.29-6.3,6.29Zm0-11.28c-2.75,0-5,2.24-5,5s2.24,4.99,5,4.99,5-2.24,5-4.99S13.61,1.3,10.85,1.3Z"
            style={{ strokeWidth: "0px" }}
          />
          <path
            d="m19.49,32c-1.4,0-2.53-1.13-2.53-2.52v-2.27c0-.36.29-.65.65-.65s.65.29.65.65v2.27c0,.66.56,1.22,1.23,1.22.73,0,1.17-.64,1.23-1.28v-8.83c0-2.96-2.41-5.36-5.37-5.36H6.67c-2.96,0-5.37,2.41-5.37,5.36v8.89c0,.67.55,1.22,1.23,1.22s1.23-.56,1.23-1.22v-2.27c0-.36.29-.65.65-.65s.65.29.65.65v2.27c0,1.39-1.14,2.52-2.53,2.52s-2.53-1.13-2.53-2.52v-8.89c0-3.67,2.99-6.66,6.67-6.66h8.68c3.68,0,6.67,2.99,6.67,6.66v8.89c-.14,1.48-1.2,2.52-2.53,2.52Z"
            style={{ strokeWidth: "0px" }}
          />
          <path
            d="m17.6,35.54H4.41c-.36,0-.65-.29-.65-.65v-10.1c0-.36.29-.65.65-.65s.65.29.65.65v9.45h11.89v-9.45c0-.36.29-.65.65-.65s.65.29.65.65v10.1c0,.36-.29.65-.65.65Z"
            style={{ strokeWidth: "0px" }}
          />
          <path
            d="m11.01,26.49c-.36,0-.65-.29-.65-.65v-7.75h-1.49c-.36,0-.65-.29-.65-.65s.29-.65.65-.65h4.28c.36,0,.65.29.65.65s-.29.65-.65.65h-1.49v7.75c0,.36-.29.65-.65.65Z"
            style={{ strokeWidth: "0px" }}
          />
          <path
            d="m47.72,56.15c-3.47,0-6.29-2.82-6.29-6.29s2.82-6.3,6.29-6.3,6.3,2.82,6.3,6.3-2.83,6.29-6.3,6.29Zm0-11.28c-2.75,0-4.99,2.24-4.99,5s2.24,4.99,4.99,4.99,5-2.24,5-4.99-2.24-5-5-5Z"
            style={{ strokeWidth: "0px" }}
          />
          <path
            d="m43.93,50.21c-.7,0-1.38-.11-2.03-.34-.34-.12-.52-.49-.41-.83.12-.34.49-.52.83-.41.51.18,1.06.26,1.61.26,1.6,0,3.05-.73,4-2,.1-.14.26-.23.44-.26.17-.02.35.03.49.14,1.17.94,2.75,1.3,4.2,1,.35-.07.7.15.77.5.07.35-.15.7-.5.77-1.62.34-3.36.02-4.76-.88-1.18,1.28-2.87,2.03-4.63,2.03Z"
            style={{ strokeWidth: "0px" }}
          />
          <path
            d="m56.34,75.56c-1.39,0-2.52-1.14-2.52-2.53v-2.26c0-.36.29-.65.65-.65s.65.29.65.65v2.26c0,.68.55,1.23,1.22,1.23.76,0,1.18-.66,1.24-1.28v-8.83c0-2.96-2.41-5.36-5.37-5.36h-8.69c-2.96,0-5.36,2.41-5.36,5.36v8.89c0,.67.55,1.21,1.22,1.21s1.23-.55,1.23-1.23v-2.26c0-.36.29-.65.65-.65s.65.29.65.65v2.26c0,1.4-1.14,2.53-2.53,2.53s-2.52-1.13-2.52-2.52v-8.89c0-3.67,2.99-6.66,6.66-6.66h8.69c3.67,0,6.66,2.99,6.66,6.66v8.89c-.14,1.48-1.2,2.52-2.53,2.52Z"
            style={{ strokeWidth: "0px" }}
          />
          <path
            d="m54.47,79.11h-13.2c-.36,0-.65-.29-.65-.65v-10.1c0-.36.29-.65.65-.65s.65.29.65.65v9.45h11.9v-9.45c0-.36.29-.65.65-.65s.65.29.65.65v10.1c0,.36-.29.65-.65.65Z"
            style={{ strokeWidth: "0px" }}
          />
          <path
            d="m47.87,70.06c-.36,0-.65-.29-.65-.65v-7.75h-1.48c-.36,0-.65-.29-.65-.65s.29-.65.65-.65h4.27c.36,0,.65.29.65.65s-.29.65-.65.65h-1.49v7.75c0,.36-.29.65-.65.65Z"
            style={{ strokeWidth: "0px" }}
          />
          <path
            d="m34.56,41.55c-.11,0-.22-.03-.32-.08-.24-.13-.37-.39-.33-.66l1.31-8.97h-5.8c-.36,0-.65-.29-.65-.65V7.42c0-.36.29-.65.65-.65h36.87c.36,0,.65.29.65.65v23.78c0,.36-.29.65-.65.65h-19.95l-11.38,9.56c-.12.1-.27.15-.42.15Zm-4.48-11.01h5.9c.19,0,.37.08.49.23.12.14.18.33.15.52l-1.17,8.02,10.25-8.61c.12-.1.26-.15.42-.15h19.53V8.07H30.09v22.47Z"
            style={{ strokeWidth: "0px" }}
          />
          <path
            d="m52.29,12.07h-16.25c-.36,0-.65-.29-.65-.65s.29-.65.65-.65h16.25c.36,0,.65.29.65.65s-.29.65-.65.65Z"
            style={{ strokeWidth: "0px" }}
          />
          <path
            d="m59.71,12.07h-4.09c-.36,0-.65-.29-.65-.65s.29-.65.65-.65h4.09c.36,0,.65.29.65.65s-.29.65-.65.65Z"
            style={{ strokeWidth: "0px" }}
          />
          <path
            d="m7.14,6.64c-.7,0-1.38-.11-2.03-.34-.34-.12-.52-.49-.4-.83.12-.34.49-.52.83-.4.51.18,1.05.27,1.6.27,1.59,0,3.05-.73,4-2,.11-.14.26-.23.44-.25.18-.02.35.03.49.14.91.72,1.99,1.1,3.14,1.1.37,0,.72-.04,1.05-.11.34-.08.7.15.77.5.08.35-.15.7-.5.77-.42.09-.86.14-1.32.14-1.21,0-2.41-.36-3.43-1.02-1.19,1.3-2.84,2.03-4.63,2.03Z"
            style={{ strokeWidth: "0px" }}
          />
          <path
            d="m30.9,70.68H10.18c-.36,0-.65-.29-.65-.65v-32.46c0-.36.29-.65.65-.65s.65.29.65.65v31.81h20.07c.36,0,.65.29.65.65s-.29.65-.65.65Z"
            style={{ strokeWidth: "0px" }}
          />
          <path
            d="m59.71,15.79h-16.25c-.36,0-.65-.29-.65-.65s.29-.65.65-.65h16.25c.36,0,.65.29.65.65s-.29.65-.65.65Z"
            style={{ strokeWidth: "0px" }}
          />
          <path
            d="m40.13,15.79h-4.09c-.36,0-.65-.29-.65-.65s.29-.65.65-.65h4.09c.36,0,.65.29.65.65s-.29.65-.65.65Z"
            style={{ strokeWidth: "0px" }}
          />
          <path
            d="m52.29,19.52h-16.25c-.36,0-.65-.29-.65-.65s.29-.65.65-.65h16.25c.36,0,.65.29.65.65s-.29.65-.65.65Z"
            style={{ strokeWidth: "0px" }}
          />
          <path
            d="m59.71,19.52h-4.09c-.36,0-.65-.29-.65-.65s.29-.65.65-.65h4.09c.36,0,.65.29.65.65s-.29.65-.65.65Z"
            style={{ strokeWidth: "0px" }}
          />
          <path
            d="m59.71,23.24h-16.25c-.36,0-.65-.29-.65-.65s.29-.65.65-.65h16.25c.36,0,.65.29.65.65s-.29.65-.65.65Z"
            style={{ strokeWidth: "0px" }}
          />
          <path
            d="m40.13,23.24h-4.09c-.36,0-.65-.29-.65-.65s.29-.65.65-.65h4.09c.36,0,.65.29.65.65s-.29.65-.65.65Z"
            style={{ strokeWidth: "0px" }}
          />
          <path
            d="m52.29,26.97h-16.25c-.36,0-.65-.29-.65-.65s.29-.65.65-.65h16.25c.36,0,.65.29.65.65s-.29.65-.65.65Z"
            style={{ strokeWidth: "0px" }}
          />
          <path
            d="m59.71,26.97h-4.09c-.36,0-.65-.29-.65-.65s.29-.65.65-.65h4.09c.36,0,.65.29.65.65s-.29.65-.65.65Z"
            style={{ strokeWidth: "0px" }}
          />
        </g>
      </g>
    </svg>
  ),
  gift: (
    <svg
      xmlns="http://www.w3.org/2000/svg"
      width="100%"
      height="100%"
      className="pointer-events-none"
      viewBox="0 0 1024 1024"
      fill="#000000">
      <path
        d="M72.668 767.89c-4.42 0-8.074-3.574-8.074-7.996 0-4.418 3.498-7.996 7.902-7.996h0.172a8.002 8.002 0 0 1 7.996 7.996 8 8 0 0 1-7.996 7.996zM72.668 639.946c-4.42 0-8.074-3.574-8.074-7.996 0-4.418 3.498-7.996 7.902-7.996h0.172a8.002 8.002 0 0 1 7.996 7.996 8 8 0 0 1-7.996 7.996zM72.668 703.918c-4.42 0-8.074-3.574-8.074-7.996 0-4.418 3.498-7.996 7.902-7.996h0.172a8.002 8.002 0 0 1 7.996 7.996 8 8 0 0 1-7.996 7.996zM104.654 735.906c-4.42 0-8.074-3.578-8.074-7.996 0-4.422 3.498-7.996 7.902-7.996h0.172a8 8 0 0 1 7.998 7.996 8.004 8.004 0 0 1-7.998 7.996zM104.654 799.878c-4.42 0-8.074-3.578-8.074-7.996 0-4.422 3.498-7.996 7.902-7.996h0.172a8 8 0 0 1 7.998 7.996 8.004 8.004 0 0 1-7.998 7.996zM104.654 671.934c-4.42 0-8.074-3.578-8.074-7.996 0-4.422 3.498-8 7.902-8h0.172a8.006 8.006 0 0 1 7.998 8 8.004 8.004 0 0 1-7.998 7.996zM232.602 735.906c-4.42 0-8.076-3.578-8.076-7.996 0-4.422 3.5-7.996 7.904-7.996h0.172a8 8 0 0 1 7.996 7.996 8.002 8.002 0 0 1-7.996 7.996zM264.588 767.89c-4.42 0-8.074-3.574-8.074-7.996 0-4.418 3.498-7.996 7.902-7.996h0.172a8.002 8.002 0 0 1 7.996 7.996 8 8 0 0 1-7.996 7.996zM232.602 799.878c-4.42 0-8.076-3.578-8.076-7.996 0-4.422 3.5-7.996 7.904-7.996h0.172a8 8 0 0 1 7.996 7.996 8.002 8.002 0 0 1-7.996 7.996zM264.588 639.946c-4.42 0-8.074-3.574-8.074-7.996 0-4.418 3.498-7.996 7.902-7.996h0.172a8.002 8.002 0 0 1 7.996 7.996 8 8 0 0 1-7.996 7.996zM232.602 671.934c-4.42 0-8.076-3.578-8.076-7.996 0-4.422 3.5-8 7.904-8h0.172a8.004 8.004 0 0 1 7.996 8 8.002 8.002 0 0 1-7.996 7.996zM264.588 703.918c-4.42 0-8.074-3.574-8.074-7.996 0-4.418 3.498-7.996 7.902-7.996h0.172a8.002 8.002 0 0 1 7.996 7.996 8 8 0 0 1-7.996 7.996zM472.016 831.868h-111.954a7.994 7.994 0 0 1-7.996-8V200.13a7.99 7.99 0 0 1 7.996-7.996h111.954a7.992 7.992 0 0 1 7.998 7.996v623.738c0 4.422-3.578 8-7.998 8z m-103.956-15.996h95.958V208.128H368.06v607.744zM1015.788 831.868H504.002a7.994 7.994 0 0 1-7.996-8V312.084a7.99 7.99 0 0 1 7.996-7.996h511.786a7.992 7.992 0 0 1 7.998 7.996v511.784c0 4.422-3.578 8-7.998 8zM512 815.872h495.792V320.08H512v495.792z"
        fill=""
      />
      <path
        d="M312.084 831.868H24.206a7.994 7.994 0 0 1-7.998-8V599.96a7.994 7.994 0 0 1 7.998-7.996h287.878a7.992 7.992 0 0 1 7.996 7.996v223.906a7.994 7.994 0 0 1-7.996 8.002z m-279.882-15.996h271.884V607.96H32.202v207.912z"
        fill=""
      />
      <path
        d="M328.076 607.96H8.21a7.994 7.994 0 0 1-7.996-8v-63.972a7.992 7.992 0 0 1 7.996-7.996h319.866a7.992 7.992 0 0 1 7.996 7.996v63.972c0 4.422-3.576 8-7.996 8zM16.208 591.964H320.08v-47.976H16.208v47.976zM384.052 807.876a7.976 7.976 0 0 1-5.654-2.344 7.988 7.988 0 0 1 0-11.304l63.974-63.992a7.994 7.994 0 1 1 11.306 11.308l-63.972 63.988a7.968 7.968 0 0 1-5.654 2.344zM384.052 743.902a7.994 7.994 0 0 1-5.654-13.652l63.974-63.988a7.994 7.994 0 1 1 11.306 11.308l-63.972 63.988a7.96 7.96 0 0 1-5.654 2.344zM384.052 679.93a7.994 7.994 0 0 1-5.654-13.652l63.974-63.988a7.994 7.994 0 1 1 11.306 11.308l-63.972 63.988a7.968 7.968 0 0 1-5.654 2.344zM384.052 615.958a7.994 7.994 0 0 1-5.654-13.652l63.974-63.988a7.992 7.992 0 0 1 11.306 0 7.994 7.994 0 0 1 0 11.308l-63.972 63.988a7.968 7.968 0 0 1-5.654 2.344zM384.052 551.984a7.994 7.994 0 0 1-5.654-13.652l63.974-63.99a7.992 7.992 0 0 1 11.306 0 7.994 7.994 0 0 1 0 11.308l-63.972 63.99a7.96 7.96 0 0 1-5.654 2.344zM384.052 488.01a7.994 7.994 0 0 1-5.654-13.65l63.974-63.988a7.992 7.992 0 0 1 11.306 0 7.994 7.994 0 0 1 0 11.308l-63.972 63.988a7.974 7.974 0 0 1-5.654 2.342zM384.052 424.036a7.994 7.994 0 0 1-5.654-13.65l63.974-63.988a7.992 7.992 0 0 1 11.306 0 7.994 7.994 0 0 1 0 11.308l-63.972 63.99a7.98 7.98 0 0 1-5.654 2.34zM384.052 360.064a7.994 7.994 0 0 1-5.654-13.65l63.974-63.988a7.992 7.992 0 0 1 11.306 0 7.992 7.992 0 0 1 0 11.306l-63.972 63.99a7.974 7.974 0 0 1-5.654 2.342zM384.052 296.09a7.976 7.976 0 0 1-5.654-2.344 7.992 7.992 0 0 1 0-11.306l63.974-63.99a7.992 7.992 0 0 1 11.306 0 7.994 7.994 0 0 1 0 11.308l-63.972 63.988a7.96 7.96 0 0 1-5.654 2.344zM711.914 831.868a7.994 7.994 0 0 1-7.996-8v-175.926a7.994 7.994 0 0 1 7.996-7.996 7.992 7.992 0 0 1 7.998 7.996v175.926c0 4.422-3.576 8-7.998 8zM807.876 831.868a7.994 7.994 0 0 1-7.996-8v-175.926c0-4.418 3.576-7.996 7.996-7.996s7.996 3.578 7.996 7.996v175.926c0 4.422-3.578 8-7.996 8zM711.914 480.012a7.992 7.992 0 0 1-7.996-7.996v-159.934a7.992 7.992 0 0 1 7.996-7.996 7.992 7.992 0 0 1 7.998 7.996v159.934a7.992 7.992 0 0 1-7.998 7.996zM807.876 480.012a7.99 7.99 0 0 1-7.996-7.996v-159.934c0-4.42 3.576-7.996 7.996-7.996s7.996 3.576 7.996 7.996v159.934a7.992 7.992 0 0 1-7.996 7.996zM535.988 527.992h-31.986a7.99 7.99 0 0 1-7.996-7.996 7.994 7.994 0 0 1 7.996-7.998h31.986a7.994 7.994 0 0 1 7.998 7.998 7.99 7.99 0 0 1-7.998 7.996zM551.982 623.954h-47.98a7.992 7.992 0 0 1-7.996-7.996 7.99 7.99 0 0 1 7.996-7.996h47.98a7.99 7.99 0 0 1 7.996 7.996 7.992 7.992 0 0 1-7.996 7.996zM1015.788 527.992H983.8a7.99 7.99 0 0 1-7.996-7.996 7.994 7.994 0 0 1 7.996-7.998h31.986c4.42 0 7.998 3.58 7.998 7.998a7.988 7.988 0 0 1-7.996 7.996zM1015.788 623.954h-47.978a7.992 7.992 0 0 1-7.998-7.996 7.99 7.99 0 0 1 7.998-7.996h47.978a7.992 7.992 0 0 1 7.998 7.996 7.994 7.994 0 0 1-7.998 7.996zM759.894 608.18c-23.162 0-39.982-16.808-39.982-39.984 0-23.18 16.82-39.984 39.998-39.984 23.162 0 39.968 16.804 39.968 39.984 0 23.176-16.822 39.984-39.984 39.984z m0.016-63.976c-11.948 0-24.006 7.422-24.006 23.992s12.042 23.988 23.99 23.988c11.95 0 23.99-7.418 23.99-23.988s-12.04-23.992-23.974-23.992z"
        fill=""
      />
      <path
        d="M896.15 655.688c-51.26 0-121.762-50.54-124.948-52.836a7.998 7.998 0 0 1-1.796-11.168c2.578-3.59 7.59-4.372 11.168-1.792 0.782 0.578 79.092 56.614 123.962 49.164 8.996-1.516 15.682-5.512 20.414-12.242 12.026-17.074 28.314-80.376 11.9-112.024-6.48-12.49-17.274-18.556-33.002-18.556h-0.016c-83.558 0.016-121.214 48.158-121.588 48.626-2.688 3.532-7.732 4.188-11.2 1.516a7.978 7.978 0 0 1-1.516-11.2c1.704-2.246 42.92-54.92 134.302-54.936h0.016c21.646 0 37.968 9.402 47.2 27.184 20.476 39.468 1.016 108.69-13.01 128.604-7.23 10.262-17.618 16.586-30.878 18.804-3.542 0.594-7.228 0.856-11.008 0.856zM623.656 655.688c-3.782 0-7.466-0.262-11.012-0.856-13.26-2.218-23.646-8.542-30.878-18.804-14.024-19.914-33.468-89.136-13.01-128.604 9.23-17.774 25.552-27.176 47.2-27.176h0.016c91.384 0.016 132.602 52.682 134.302 54.928 2.672 3.5 2 8.5-1.5 11.184-3.498 2.64-8.512 2.016-11.198-1.468-0.376-0.5-38.516-48.634-121.606-48.65h-0.016c-15.728 0-26.52 6.066-33.002 18.556-16.414 31.656-0.124 94.942 11.902 112.016 4.732 6.73 11.416 10.726 20.412 12.242 44.92 7.418 123.168-48.586 123.95-49.164a7.984 7.984 0 0 1 11.166 1.792 7.998 7.998 0 0 1-1.794 11.168c-3.188 2.296-73.69 52.836-124.932 52.836z"
        fill=""
      />
      <path
        d="M839.862 576.192h-47.98a7.992 7.992 0 0 1-7.996-7.996 7.99 7.99 0 0 1 7.996-7.996h47.98a7.99 7.99 0 0 1 7.996 7.996 7.992 7.992 0 0 1-7.996 7.996zM727.908 576.192h-47.978a7.992 7.992 0 0 1-7.998-7.996 7.99 7.99 0 0 1 7.998-7.996h47.978a7.99 7.99 0 0 1 7.996 7.996 7.992 7.992 0 0 1-7.996 7.996z"
        fill=""
      />
      <path
        d="M330.936 394.47c-4.374 0-8.702-0.834-12.636-2.944-9.434-5.044-14.212-15.634-14.212-31.462 0-15.838 4.78-26.426 14.212-31.47 17.742-9.512 43.342 6.91 46.2 8.816a7.992 7.992 0 0 1 2.218 11.074 8.01 8.01 0 0 1-11.074 2.242c-6.528-4.326-22.428-11.972-29.798-8.028-4.764 2.552-5.764 10.854-5.764 17.368 0 6.512 1 14.814 5.764 17.368 7.418 3.898 23.538-3.88 29.784-8.036 3.638-2.444 8.622-1.468 11.09 2.218a7.996 7.996 0 0 1-2.218 11.088c-2.22 1.482-18.214 11.766-33.566 11.766z"
        fill=""
      />
      <path
        d="M328.06 341.806a7.992 7.992 0 0 1-7.808-6.302c-0.906-4.24-4.81-25.84 7.934-35.054 12.526-9.02 30.144 1.334 35.922 4.74a7.986 7.986 0 0 1 2.844 10.948c-2.25 3.81-7.17 5.068-10.934 2.842-11.4-6.686-16.946-6.654-18.46-5.576-2.794 2.006-3.17 11.558-1.654 18.742 0.904 4.318-1.844 8.566-6.154 9.48-0.564 0.124-1.126 0.18-1.69 0.18zM339.932 423.474c-4.076 0-8.124-0.992-11.746-3.608-12.744-9.214-8.84-30.814-7.934-35.054 0.938-4.32 5.248-7.06 9.496-6.124 4.31 0.914 7.058 5.162 6.154 9.48-1.516 7.184-1.14 16.726 1.654 18.742 1.516 1.078 7.092 1.11 18.46-5.568 3.748-2.226 8.684-0.984 10.95 2.85a7.994 7.994 0 0 1-2.86 10.94c-4.106 2.422-14.194 8.342-24.174 8.342z"
        fill=""
      />
      <path
        d="M72.184 543.988a7.994 7.994 0 0 1-7.152-4.422c-2.046-4.078-19.554-40.476-6.452-61.678 3.92-6.326 12.23-13.87 29.598-13.87 52.322 0 85.728 65.598 87.12 68.394a8.006 8.006 0 0 1-3.576 10.73c-3.904 1.964-8.746 0.376-10.73-3.562-0.296-0.61-30.392-59.57-72.812-59.57-12.106 0-15.026 4.724-15.978 6.28-6.386 10.316 0.984 33.766 7.138 46.138a7.994 7.994 0 0 1-3.594 10.714c-1.14 0.566-2.36 0.846-3.562 0.846z"
        fill=""
      />
      <path
        d="M168.144 543.988a8.176 8.176 0 0 1-3.578-0.844c-3.952-1.968-5.542-6.782-3.576-10.73 1.39-2.796 34.798-68.394 87.12-68.394 17.37 0 25.678 7.544 29.598 13.87 13.104 21.202-4.404 57.6-6.452 61.678a7.994 7.994 0 0 1-14.304-7.136c6.152-12.372 13.526-35.822 7.136-46.138-0.954-1.554-3.874-6.28-15.978-6.28-42.542 0-72.516 58.96-72.812 59.554a8.02 8.02 0 0 1-7.154 4.42z"
        fill=""
      />
      <path
        d="M743.902 831.868a7.994 7.994 0 0 1-7.998-8v-95.958a7.99 7.99 0 0 1 7.998-7.996 7.99 7.99 0 0 1 7.996 7.996v95.958c0 4.422-3.576 8-7.996 8z"
        fill=""
      />
      <path
        d="M775.888 416.04a7.992 7.992 0 0 1-7.998-7.996v-95.96c0-4.42 3.578-7.996 7.998-7.996s7.996 3.576 7.996 7.996v95.96a7.99 7.99 0 0 1-7.996 7.996z"
        fill=""
      />
      <path
        d="M519.996 336.074a7.98 7.98 0 0 1-5.654-2.342l-15.992-15.994a7.994 7.994 0 0 1 0-11.308 7.992 7.992 0 0 1 11.306 0l15.992 15.994a7.994 7.994 0 0 1-5.652 13.65z"
        fill=""
      />
      <path
        d="M999.792 336.074a7.994 7.994 0 0 1-5.652-13.65l15.992-15.994a7.994 7.994 0 0 1 11.308 0 7.994 7.994 0 0 1 0 11.308l-15.992 15.994a7.98 7.98 0 0 1-5.656 2.342z"
        fill=""
      />
      <path
        d="M1015.788 831.868a7.976 7.976 0 0 1-5.654-2.344l-15.992-15.992a7.994 7.994 0 0 1 0-11.308 7.994 7.994 0 0 1 11.308 0l15.992 15.992a7.994 7.994 0 0 1-5.654 13.652z"
        fill=""
      />
      <path
        d="M504.002 831.868a7.994 7.994 0 0 1-5.652-13.652l15.992-15.992a7.992 7.992 0 0 1 11.306 0 7.994 7.994 0 0 1 0 11.308l-15.992 15.992a7.972 7.972 0 0 1-5.654 2.344z"
        fill=""
      />
      <path
        d="M136.156 831.868a7.994 7.994 0 0 1-7.996-8V599.96a7.992 7.992 0 0 1 7.996-7.996 7.992 7.992 0 0 1 7.998 7.996v223.906a7.994 7.994 0 0 1-7.998 8.002z"
        fill=""
      />
      <path
        d="M200.13 831.868a7.994 7.994 0 0 1-7.998-8V599.96c0-4.418 3.578-7.996 7.998-7.996s7.996 3.578 7.996 7.996v223.906a7.994 7.994 0 0 1-7.996 8.002z"
        fill=""
      />
      <path
        d="M128.16 607.96a7.994 7.994 0 0 1-7.996-8v-63.754c0-4.418 3.576-7.996 7.996-7.996s7.996 3.578 7.996 7.996v63.754c0 4.422-3.576 8-7.996 8z"
        fill=""
      />
      <path
        d="M208.126 607.96a7.994 7.994 0 0 1-7.996-8v-61.472c0-4.418 3.576-7.996 7.996-7.996s7.996 3.578 7.996 7.996v61.472a7.992 7.992 0 0 1-7.996 8z"
        fill=""
      />
    </svg>
  ),
  cloudAcceleration: (
    <svg
      xmlns="http://www.w3.org/2000/svg"
      width="100%"
      height="100%"
      className="pointer-events-none"
      viewBox="0 0 1024 1024">
      <path
        d="M822.8 466.5c0.1 0.3 0.2 0.5 0.3 0.8-0.1-0.2-0.2-0.5-0.3-0.8zM593.4 665.2c0-0.1-0.1-0.2-0.1-0.3 0 0.1 0.1 0.2 0.1 0.3zM834.7 508c0.1 0.4 0.2 0.9 0.3 1.3-0.1-0.4-0.2-0.8-0.3-1.3zM820 459.5c0.1 0.3 0.2 0.6 0.4 0.8-0.2-0.2-0.3-0.5-0.4-0.8zM831.5 493.9c0.1 0.3 0.2 0.7 0.3 1-0.1-0.3-0.2-0.6-0.3-1zM817.1 453c0.2 0.4 0.4 0.9 0.6 1.3-0.2-0.4-0.4-0.9-0.6-1.3zM825.2 472.8c0.1 0.4 0.3 0.8 0.4 1.2-0.1-0.3-0.3-0.7-0.4-1.2zM594.7 668c0-0.1-0.1-0.1-0.1-0.2 0 0.1 0 0.2 0.1 0.2zM630.4 656.5c-0.3 0.2-0.5 0.5-0.8 0.7 0.2-0.3 0.5-0.5 0.8-0.7zM829.7 487c0.1 0.4 0.2 0.7 0.3 1.1-0.1-0.3-0.2-0.7-0.3-1.1zM791.6 410.8l0.9 1.2-0.9-1.2zM623.7 663.4c-0.8 1-1.6 2.2-2.4 3.3 0.8-1.2 1.6-2.3 2.4-3.3zM803.8 428.3c0.1 0.2 0.3 0.4 0.4 0.6-0.1-0.1-0.2-0.3-0.4-0.6zM621.3 666.8l-1.2 1.8 1.2-1.8zM799.9 422.2c0.3 0.5 0.6 1 1 1.4-0.4-0.4-0.7-0.9-1-1.4zM626.4 660.2c-0.3 0.4-0.7 0.7-1 1.1 0.3-0.3 0.7-0.7 1-1.1zM592.2 662.2c-0.1-0.2-0.1-0.3-0.2-0.5 0.1 0.2 0.2 0.3 0.2 0.5zM807.5 434.4c0.2 0.4 0.5 0.8 0.7 1.2-0.2-0.4-0.5-0.8-0.7-1.2zM613.5 682.3c-0.2 0.4-0.3 0.8-0.5 1.3 0.2-0.4 0.3-0.8 0.5-1.3zM814.4 447.2zM810.7 440.2c0.2 0.4 0.5 0.9 0.7 1.3-0.2-0.5-0.5-0.9-0.7-1.3zM624.9 662c-0.4 0.4-0.7 0.9-1.1 1.3 0.4-0.5 0.7-0.9 1.1-1.3zM607.9 687.7l-0.2-0.2 0.2 0.2zM699.6 702.5c-0.1-0.1-0.2-0.2-0.2-0.3 0 0.2 0.1 0.2 0.2 0.3zM632.2 655c-0.2 0.2-0.4 0.3-0.6 0.5 0.2-0.1 0.4-0.3 0.6-0.5zM627.2 659.4l1.4-1.4-1.4 1.4zM610.7 690.4c-0.5-0.4-1-0.9-1.5-1.4 0.5 0.5 1 0.9 1.5 1.4zM846 571.5l-5.4-3.8 8.2 5.7zM615.1 678.5c-0.3 0.6-0.5 1.2-0.8 1.8 0.3-0.6 0.5-1.2 0.8-1.8zM698.2 701.1zM590 655.7c-0.1-0.3-0.2-0.5-0.2-0.8 0.1 0.2 0.2 0.5 0.2 0.8zM616.7 674.9c1.1-2.2 2.2-4.2 3.3-6.2-1.7 2.9-3.4 6-4.9 9.5 0.5-1.1 1.1-2.2 1.6-3.3zM787.4 405.7c0.4 0.5 0.7 0.9 1.1 1.4-0.3-0.5-0.7-1-1.1-1.4zM591.1 659c-0.1-0.2-0.2-0.4-0.2-0.7 0.1 0.3 0.1 0.5 0.2 0.7zM838.1 529zM839.9 548.9c0 0.7 0.1 1.3 0.1 2 0-0.6-0.1-1.3-0.1-2zM634.6 653.5c-0.2 0.1-0.4 0.2-0.6 0.4 0.2-0.2 0.4-0.3 0.6-0.4zM835.9 514.4l0.3 1.5-0.3-1.5zM612 686.3c-0.1 0.2-0.2 0.5-0.2 0.7 0.1-0.2 0.2-0.5 0.2-0.7zM837 521.2c0.1 0.4 0.1 0.7 0.2 1.1-0.1-0.3-0.1-0.7-0.2-1.1zM839.4 542c0.1 0.7 0.1 1.5 0.2 2.2-0.1-0.7-0.2-1.4-0.2-2.2zM796.2 417c0.2 0.3 0.4 0.6 0.7 0.9-0.2-0.2-0.4-0.6-0.7-0.9zM595.9 670.7zM636.6 652.3l-0.6 0.3 0.6-0.3zM838.8 535.4c0.1 0.6 0.1 1.2 0.2 1.9-0.1-0.6-0.1-1.3-0.2-1.9z"
        fill="#FFFFFF"
      />
      <path
        d="M822.6 644.9l14.4 6.4c12.4 5.5 21.5 18.3 27.9 39.1 8-7.1 16.9-19.1 21.9-39.2 10.7-42.6-37.6-77.4-38.1-77.8l-8.2-5.7-0.3-10c-0.1-2.3-0.2-4.5-0.3-6.7 0-0.7-0.1-1.4-0.1-2-0.1-1.6-0.2-3.1-0.3-4.7-0.1-0.7-0.1-1.5-0.2-2.2-0.1-1.6-0.3-3.2-0.4-4.7-0.1-0.6-0.1-1.2-0.2-1.9-0.2-2.2-0.5-4.3-0.7-6.4l-0.9-6.6c-0.1-0.4-0.1-0.7-0.2-1.1-0.3-1.8-0.5-3.6-0.8-5.3l-0.3-1.5-0.9-5.1c-0.1-0.4-0.2-0.9-0.3-1.3-0.4-2.1-0.8-4.1-1.3-6.2-0.5-2.3-1.1-4.6-1.6-6.9-0.1-0.3-0.2-0.7-0.3-1-0.5-2-1-3.9-1.6-5.8-0.1-0.4-0.2-0.7-0.3-1.1-1.3-4.4-2.6-8.7-4.1-12.9-0.1-0.4-0.3-0.8-0.4-1.2-0.7-1.9-1.3-3.7-2-5.5-0.1-0.3-0.2-0.5-0.3-0.8-0.8-2.1-1.6-4.1-2.5-6.2-0.1-0.3-0.2-0.6-0.4-0.8-0.7-1.7-1.5-3.5-2.3-5.2-0.2-0.4-0.4-0.9-0.6-1.3-0.9-1.9-1.8-3.9-2.7-5.8-1-1.9-2-3.9-3-5.8-0.2-0.4-0.5-0.9-0.7-1.3-0.8-1.5-1.7-3-2.5-4.5-0.2-0.4-0.5-0.8-0.7-1.2-1.1-1.8-2.1-3.6-3.3-5.4-0.1-0.2-0.3-0.4-0.4-0.6-1-1.6-2-3.1-3-4.7-0.3-0.5-0.6-1-1-1.4-1-1.4-2-2.9-3-4.3-0.2-0.3-0.4-0.6-0.7-0.9-1.2-1.7-2.4-3.3-3.7-5l-0.9-1.2c-1-1.3-2-2.6-3-3.8-0.4-0.5-0.7-0.9-1.1-1.4-1.3-1.6-2.7-3.2-4-4.8-17.8-20.3-35.6-32.4-45.6-38.2-9.9 5.8-27.7 17.9-45.6 38.2-35.6 40.6-54.8 93.3-56.9 156.8l-0.3 10-8.2 5.7c-0.4 0.3-48.8 35.1-38 77.7 0.3 1.3 0.7 2.5 1 3.7 0.1 0.3 0.2 0.5 0.2 0.8 0.3 0.9 0.5 1.8 0.8 2.7 0.1 0.2 0.2 0.4 0.2 0.7l0.9 2.7c0.1 0.2 0.1 0.3 0.2 0.5 0.3 0.9 0.7 1.8 1 2.7 0 0.1 0.1 0.2 0.1 0.3l1.2 2.7c0 0.1 0.1 0.1 0.1 0.2 0.4 0.9 0.8 1.8 1.3 2.7 0.9 1.8 1.9 3.5 2.8 5.1 2.9 4.7 5.9 8.5 8.9 11.6l0.2 0.2 1.3 1.3c0.5 0.5 1 0.9 1.5 1.4 0.4-1.1 0.7-2.3 1.1-3.4 0.1-0.2 0.2-0.5 0.2-0.7 0.3-0.9 0.6-1.8 1-2.7 0.2-0.4 0.3-0.9 0.5-1.3 0.3-0.7 0.5-1.4 0.8-2.1 0.2-0.6 0.5-1.2 0.8-1.8 0-0.1 0.1-0.1 0.1-0.2 1.5-3.5 3.2-6.7 4.9-9.5l0.1-0.1 1.2-1.8 0.1-0.1c0.8-1.2 1.6-2.3 2.4-3.3l0.1-0.1c0.3-0.4 0.7-0.9 1.1-1.3 0.2-0.2 0.4-0.4 0.5-0.6 0.3-0.4 0.7-0.8 1-1.1l0.8-0.8c0.5-0.5 0.9-1 1.4-1.4 0.3-0.3 0.6-0.6 1-0.9 0.3-0.2 0.5-0.5 0.8-0.7l1.2-0.9c0.2-0.2 0.4-0.3 0.6-0.5l1.8-1.2c0.2-0.1 0.4-0.2 0.6-0.4l1.5-0.9 0.6-0.3c0.7-0.4 1.3-0.7 2-1l14.4-6.4 9.6 12.5c1.9 2.4 3.8 4.9 5.8 7.4 9.5 12.1 19.7 24.7 27.1 33.2 1 1.1 1.9 2.1 2.7 3.1 0.4 0.4 0.7 0.8 1.1 1.2 0.1 0.1 0.2 0.2 0.2 0.3 0.4 0.4 0.7 0.8 1 1.1H775c8.3-8.8 24.7-29 38-46.3l9.6-12.8z m-87.1-87.6c-31.2 0-56.5-25.4-56.5-56.5 0-31.2 25.4-56.5 56.5-56.5s56.5 25.4 56.5 56.5-25.3 56.5-56.5 56.5z"
        fill="#E6E6E6"
      />
      <path
        d="M663.8 372.7c32.5-36.3 64.8-50.4 66.1-51l7.9-3.4 7.9 3.4c1.4 0.6 33.7 14.7 66.1 51 11 12.3 22.9 28.1 33.6 47.9C843.2 284.3 731.5 174 594.6 174c-100.8 0-191 60-230.4 151.3 8.5 3 16.7 6.6 24.7 10.7 27.4 14.2 51.5 34.8 69.8 59.7 6.5 8.9 4.6 21.4-4.3 28-8.9 6.5-21.4 4.6-28-4.3-30.3-41.2-78.9-65.8-129.9-65.8-88.9 0-161.1 72.3-161.1 161.1 0 88.9 72.3 161.1 161.1 161.1h258.1c-1.7-4.7-3.3-9.6-4.6-15-14.1-55.9 27.5-98.4 45.8-113.9 5.1-86.6 39.5-142.4 68-174.2z m-151-109.2c-33 18.9-49.4 44.6-49.6 44.9-1.9 3-5.2 4.7-8.5 4.7-1.8 0-3.7-0.5-5.3-1.5-4.7-2.9-6.1-9.1-3.1-13.8 0.8-1.2 19.3-30.2 56.6-51.6 34.4-19.7 91.8-36.4 170-4.1 5.1 2.1 7.5 8 5.4 13.1-2.1 5.1-8 7.5-13.1 5.4-56.7-23.5-108-22.5-152.4 2.9z"
        fill="#FFFFFF"
      />
      <path
        d="M646.5 711.3c2.3-0.4 4.6-0.8 6.8-1.3-1.7-2-3.3-4-4.9-6-0.7 2.3-1.4 4.8-1.9 7.3z"
        fill="#005BFF"
      />
      <path
        d="M827.3 704c1.7 5.8 3.1 12.4 4 18.5l2.7 20.6 20.5-3.5c2.2-0.4 53.9-9.9 71.2-78.7 14.1-55.9-27.5-98.4-45.8-113.9-0.9-15.2-2.7-29.4-5.2-42.8 7.2-25.5 10.9-52.1 10.9-79.3 0-77.7-30.3-150.8-85.2-205.7-55-55-128-85.2-205.7-85.2-119.1 0-225.5 72.3-269.7 181.6-9.4-1.3-18.9-2-28.3-2-110.9 0-201.1 90.2-201.1 201.1s90.2 201.1 201.1 201.1h283c19.6 19.6 40.3 23.5 41.7 23.7l20.4 3.4 2.7-20.5c0.5-3.7 1.2-7.5 2.1-11.2 0.6-2.5 1.2-5 1.9-7.3 1.6 2 3.3 4 4.9 6 10.5 12.8 21.4 25.2 27.6 29.8l5.3 3.9h103.3l5.3-3.9c7-5.2 20.5-21.1 32.4-35.7zM550 660.9c1.3 5.3 2.9 10.3 4.6 15H296.5c-88.9 0-161.1-72.3-161.1-161.1 0-88.9 72.3-161.1 161.1-161.1 51.1 0 99.6 24.6 129.9 65.8 6.5 8.9 19.1 10.8 28 4.3 8.9-6.5 10.8-19.1 4.3-28-18.3-24.9-42.4-45.5-69.8-59.7-8-4.1-16.2-7.7-24.7-10.7C403.6 234 493.8 174 594.6 174c136.9 0 248.6 110.3 250.9 246.7-10.7-19.8-22.6-35.7-33.6-47.9-32.5-36.3-64.8-50.4-66.1-51l-7.9-3.4-7.9 3.4c-1.4 0.6-33.7 14.7-66.1 51-28.5 31.8-62.9 87.6-68 174.3-18.4 15.4-60 57.9-45.9 113.8z m225 42.8h-74.4c-0.3-0.4-0.7-0.7-1-1.1-0.1-0.1-0.2-0.2-0.2-0.3-0.4-0.4-0.7-0.8-1.1-1.2-8.8-9.8-23.5-27.9-35.6-43.7l-9.6-12.5-14.4 6.4c-0.7 0.3-1.4 0.6-2 1l-0.6 0.3-1.5 0.9c-0.2 0.1-0.4 0.2-0.6 0.4l-1.8 1.2c-0.2 0.2-0.4 0.3-0.6 0.5l-1.2 0.9c-0.3 0.2-0.5 0.5-0.8 0.7-0.3 0.3-0.6 0.6-1 0.9-0.5 0.5-1 0.9-1.4 1.4l-0.8 0.8c-0.3 0.4-0.7 0.7-1 1.1-0.2 0.2-0.4 0.4-0.5 0.6-0.4 0.4-0.7 0.9-1.1 1.3l-0.1 0.1-2.4 3.3-0.1 0.1-1.2 1.8-0.1 0.1c-1.2 1.9-2.3 4-3.3 6.2-0.5 1.1-1 2.2-1.6 3.4 0 0.1-0.1 0.1-0.1 0.2-0.3 0.6-0.5 1.2-0.8 1.8-0.3 0.7-0.6 1.4-0.8 2.1-0.2 0.4-0.3 0.8-0.5 1.3-0.3 0.9-0.7 1.8-1 2.7-0.1 0.2-0.2 0.5-0.2 0.7-0.4 1.1-0.7 2.2-1.1 3.4-0.5-0.4-1-0.9-1.5-1.4l-1.3-1.3-0.2-0.2c-4-4.1-8.2-9.6-11.8-16.8-0.4-0.9-0.9-1.8-1.3-2.7 0-0.1-0.1-0.1-0.1-0.2l-1.2-2.7c0-0.1-0.1-0.2-0.1-0.3-0.4-0.9-0.7-1.8-1-2.7-0.1-0.2-0.1-0.3-0.2-0.5l-0.9-2.7c-0.1-0.2-0.2-0.4-0.2-0.7-0.3-0.9-0.6-1.8-0.8-2.7-0.1-0.3-0.2-0.5-0.2-0.8-0.3-1.2-0.7-2.4-1-3.7-10.7-42.6 37.6-77.4 38-77.7l8.2-5.7 0.3-10c2.1-63.5 21.2-116.2 56.9-156.8 17.9-20.3 35.7-32.4 45.6-38.2 9.9 5.8 27.7 17.9 45.6 38.2 1.4 1.6 2.7 3.2 4 4.8 0.4 0.5 0.7 0.9 1.1 1.4 1 1.3 2 2.5 3 3.8l0.9 1.2c1.3 1.6 2.5 3.3 3.7 5 0.2 0.3 0.4 0.6 0.7 0.9 1 1.4 2 2.8 3 4.3 0.3 0.5 0.6 1 1 1.4 1 1.5 2 3.1 3 4.7 0.1 0.2 0.3 0.4 0.4 0.6l3.3 5.4c0.2 0.4 0.5 0.8 0.7 1.2 0.9 1.5 1.7 3 2.5 4.5 0.2 0.4 0.5 0.9 0.7 1.3 1 1.9 2 3.8 3 5.8 0.9 1.9 1.9 3.8 2.7 5.8 0.2 0.4 0.4 0.9 0.6 1.3 0.8 1.7 1.5 3.4 2.3 5.2 0.1 0.3 0.2 0.6 0.4 0.8 0.9 2 1.7 4.1 2.5 6.2 0.1 0.3 0.2 0.5 0.3 0.8 0.7 1.8 1.4 3.7 2 5.5 0.1 0.4 0.3 0.8 0.4 1.2 1.5 4.2 2.8 8.6 4.1 12.9 0.1 0.4 0.2 0.7 0.3 1.1 0.5 1.9 1.1 3.9 1.6 5.8 0.1 0.3 0.2 0.7 0.3 1 1.1 4.3 2.1 8.7 2.9 13.1 0.1 0.4 0.2 0.9 0.3 1.3l0.9 5.1 0.3 1.5c0.3 1.8 0.6 3.5 0.8 5.3 0.1 0.4 0.1 0.7 0.2 1.1l0.9 6.6c0.3 2.1 0.5 4.3 0.7 6.4 0.1 0.6 0.1 1.2 0.2 1.9 0.1 1.6 0.3 3.1 0.4 4.7 0.1 0.7 0.1 1.5 0.2 2.2 0.1 1.6 0.2 3.1 0.3 4.7 0 0.7 0.1 1.3 0.1 2 0.1 2.2 0.2 4.5 0.3 6.7l0.3 10 5.5 3.8 2.7 1.9c0.5 0.3 48.8 35.1 38.1 77.8C881.8 671 873 683 865 690.1c-6.4-20.8-15.6-33.6-27.9-39.1l-14.4-6.4-9.6 12.5c-13.3 17.6-29.8 37.8-38.1 46.6z"
        fill="#005BFF"
      />
      <path
        d="M613 683.6c-0.3 0.9-0.7 1.8-1 2.7 0.4-0.9 0.7-1.8 1-2.7zM614.3 680.3c-0.3 0.7-0.6 1.4-0.8 2.1 0.3-0.8 0.5-1.5 0.8-2.1zM611.8 687c-0.4 1.1-0.7 2.2-1.1 3.4 0.4-1.2 0.7-2.3 1.1-3.4zM699.3 702.3c-0.4-0.4-0.7-0.8-1.1-1.2 0.4 0.4 0.8 0.8 1.1 1.2zM634 653.8l-1.8 1.2 1.8-1.2zM631.5 655.5l-1.2 0.9c0.5-0.3 0.9-0.6 1.2-0.9zM629.6 657.1c-0.3 0.3-0.6 0.6-1 0.9 0.3-0.3 0.7-0.6 1-0.9zM636 652.6l-1.5 0.9 1.5-0.9zM638.6 651.3c-0.7 0.3-1.4 0.6-2 1 0.7-0.4 1.4-0.7 2-1zM700.6 703.7c-0.3-0.4-0.7-0.7-1-1.1 0.3 0.3 0.7 0.7 1 1.1zM615.1 678.3c0 0.1-0.1 0.1-0.1 0.2 0.1-0.1 0.1-0.1 0.1-0.2zM627.2 659.4l-0.8 0.8 0.8-0.8zM621.4 666.7l-0.1 0.1s0-0.1 0.1-0.1zM620.1 668.6l-0.1 0.1c0.1 0 0.1 0 0.1-0.1zM623.8 663.3l-0.1 0.1 0.1-0.1zM625.4 661.3c-0.2 0.2-0.4 0.4-0.5 0.6 0.2-0.1 0.3-0.4 0.5-0.6zM817.7 454.3c0.8 1.7 1.5 3.4 2.3 5.2-0.7-1.7-1.5-3.5-2.3-5.2zM814.4 447.2c0.9 1.9 1.9 3.8 2.7 5.8-0.9-1.9-1.8-3.9-2.7-5.8zM830 488.1c0.5 1.9 1.1 3.9 1.6 5.8-0.6-1.9-1.1-3.8-1.6-5.8zM836.2 515.9c0.3 1.8 0.6 3.5 0.8 5.3-0.2-1.7-0.5-3.5-0.8-5.3zM823.1 467.3zM825.6 474.1c1.5 4.2 2.8 8.6 4.1 12.9-1.3-4.4-2.6-8.7-4.1-12.9zM820.4 460.3c0.9 2 1.7 4.1 2.5 6.2-0.9-2-1.7-4.1-2.5-6.2zM837.2 522.4l0.9 6.6-0.9-6.6zM835 509.3l0.9 5.1-0.9-5.1zM595.9 670.7c3.6 7.1 7.7 12.6 11.8 16.8-3-3.1-6.1-6.9-8.9-11.6-1-1.6-1.9-3.3-2.9-5.2z"
        fill="#005BFF"
      />
      <path
        d="M668.4 664.8c-2-2.5-3.9-5-5.8-7.4 12.1 15.7 26.8 33.9 35.6 43.7-0.9-0.9-1.8-2-2.7-3.1-7.4-8.5-17.6-21-27.1-33.2zM834.7 508c-0.9-4.4-1.9-8.8-2.9-13.1 0.6 2.3 1.1 4.6 1.6 6.9 0.5 2.1 0.9 4.2 1.3 6.2zM839 537.3c0.1 1.6 0.3 3.1 0.4 4.7-0.1-1.6-0.3-3.1-0.4-4.7zM838.1 529c0.3 2.1 0.5 4.3 0.7 6.4-0.2-2.1-0.5-4.3-0.7-6.4zM839.6 544.2c0.1 1.6 0.2 3.1 0.3 4.7-0.1-1.5-0.2-3.1-0.3-4.7zM840 551c0.1 2.2 0.2 4.5 0.3 6.7-0.1-2.3-0.2-4.5-0.3-6.7zM590.9 658.4c-0.3-0.9-0.6-1.8-0.8-2.7 0.2 0.9 0.5 1.8 0.8 2.7zM592 661.7l-0.9-2.7c0.3 1 0.6 1.9 0.9 2.7zM609.2 689l-1.3-1.3 1.3 1.3zM589.8 654.9c-0.3-1.2-0.7-2.4-1-3.7 0.3 1.2 0.6 2.5 1 3.7zM595.9 670.7c-0.4-0.9-0.9-1.8-1.3-2.7 0.5 1 0.9 1.8 1.3 2.7zM783.4 400.9c1.4 1.6 2.7 3.2 4 4.8-1.3-1.6-2.6-3.2-4-4.8zM593.3 664.9c-0.4-0.9-0.7-1.8-1-2.7 0.3 0.9 0.6 1.8 1 2.7zM594.6 667.9l-1.2-2.7 1.2 2.7zM788.6 407c1 1.3 2 2.5 3 3.8-1-1.2-2-2.5-3-3.8zM804.2 429l3.3 5.4-3.3-5.4zM800.8 423.7c1 1.5 2 3.1 3 4.7-1-1.6-2-3.2-3-4.7zM808.2 435.7c0.9 1.5 1.7 3 2.5 4.5-0.8-1.6-1.6-3.1-2.5-4.5zM811.4 441.5zM792.5 412c1.3 1.6 2.5 3.3 3.7 5-1.2-1.6-2.4-3.3-3.7-5zM796.9 418c1 1.4 2 2.8 3 4.3-1-1.5-2-2.9-3-4.3z"
        fill="#005BFF"
      />
      <path
        d="M735.5 464.2c-20.1 0-36.5 16.4-36.5 36.5s16.4 36.5 36.5 36.5 36.5-16.4 36.5-36.5-16.4-36.5-36.5-36.5z"
        fill="#FFFFFF"
      />
      <path
        d="M735.5 444.2c-31.2 0-56.5 25.4-56.5 56.5 0 31.2 25.4 56.5 56.5 56.5s56.5-25.4 56.5-56.5-25.3-56.5-56.5-56.5z m0 93.1c-20.1 0-36.5-16.4-36.5-36.5s16.4-36.5 36.5-36.5 36.5 16.4 36.5 36.5-16.4 36.5-36.5 36.5zM709 762.9c-5.5 0-10 4.5-10 10v99.4c0 5.5 4.5 10 10 10s10-4.5 10-10v-99.4c0-5.5-4.5-10-10-10z"
        fill="#06F3FF"
      />
      <path
        d="M770.6 752.9c-11 0-20 9-20 20v28.8c0 11 9 20 20 20s20-9 20-20v-28.8c0-11.1-9-20-20-20zM678.3 255.1c2.1-5.1-0.3-11-5.4-13.1-78.2-32.3-135.6-15.6-170 4.1-37.3 21.4-55.8 50.4-56.6 51.6-2.9 4.7-1.5 10.8 3.1 13.8 1.7 1 3.5 1.5 5.3 1.5 3.3 0 6.6-1.7 8.5-4.7 0.2-0.3 16.6-26 49.6-44.9 44.3-25.4 95.6-26.4 152.4-3 5.1 2.3 11-0.2 13.1-5.3z"
        fill="#005BFF"
      />
    </svg>
  ),
  cloudBackup: (
    <svg
      xmlns="http://www.w3.org/2000/svg"
      width="100%"
      height="100%"
      className="pointer-events-none"
      viewBox="0 0 1024 1024">
      <path
        d="M464.8 409.7C431.9 365 378.9 336 319.2 336c-99.8 0-180.7 80.9-180.7 180.7s80.9 180.7 180.7 180.7h297.3c149.3 0 270.3-121 270.3-270.3s-121-270.3-270.3-270.3c-118.7 0-219.6 76.5-255.9 183"
        fill="#FFFFFF"
      />
      <path
        d="M823.5 766.5c0-3.2 0.5-6.3 1.5-9.2H631V417.4c0-5.5-4.5-10-10-10s-10 4.5-10 10v359.9h214.6c-1.3-3.3-2.1-7-2.1-10.8z"
        fill="#06F3FF"
      />
      <path
        d="M230.2 791.7c-3.5-8.7-12-14.9-22-14.9-13.1 0-23.7 10.6-23.7 23.7s10.6 23.7 23.7 23.7c9.5 0 17.7-5.6 21.5-13.7 1.4-3 2.2-6.4 2.2-10 0-3.1-0.6-6.1-1.7-8.8z"
        fill="#E6E6E6"
      />
      <path
        d="M852.2 737.9c-12.6 0-23.3 8.1-27.1 19.4-1 2.9-1.5 6-1.5 9.2 0 3.8 0.7 7.4 2.1 10.8 4.3 10.5 14.5 17.9 26.6 17.9 15.8 0 28.7-12.8 28.7-28.7-0.1-15.8-13-28.6-28.8-28.6zM700 257.7c2.1-5.1-0.3-11-5.4-13.1-78-32.3-135.3-15.6-169.6 4.1-37.2 21.3-55.7 50.2-56.4 51.5-2.9 4.7-1.5 10.8 3.1 13.8 1.7 1 3.5 1.5 5.3 1.5 3.3 0 6.6-1.6 8.5-4.6 0.2-0.3 17.1-26.4 50.2-45.2 44.1-24.9 94.9-25.8 151.2-2.5 5.1 2 11-0.4 13.1-5.5z"
        fill="#005BFF"
      />
      <path
        d="M852.2 819.8c-12.4 0-22.9 7.8-26.9 18.8H534.5V717.3H611v-40h-76.5V537.9c0-5.5-4.5-10-10-10s-10 4.5-10 10v139.4h-66.9V537.9c0-5.5-4.5-10-10-10s-10 4.5-10 10v139.4H319.2c-88.6 0-160.7-72.1-160.7-160.7s72.1-160.7 160.7-160.7c50.9 0 99.3 24.5 129.5 65.6 6.5 8.9 19.1 10.8 28 4.3 8.9-6.5 10.8-19.1 4.3-28-18.3-24.8-42.4-45.4-69.7-59.5-7.9-4.1-16.1-7.7-24.5-10.7 39.3-91 129.3-150.8 229.8-150.8 138 0 250.3 112.3 250.3 250.3 0 133.1-104.4 242.2-235.7 249.8V717c72.1-3.5 139.3-33.3 190.7-84.7 54.8-54.8 85-127.7 85-205.2s-30.2-150.4-85-205.2c-54.8-54.8-127.7-85-205.2-85-118.8 0-224.9 72.1-269.1 181.2-9.3-1.3-18.8-2-28.2-2-110.7 0-200.7 90-200.7 200.7s90 200.7 200.7 200.7h108.4v73.9H250.9c-4.3-19.6-21.8-34.4-42.7-34.4-24.1 0-43.7 19.6-43.7 43.7s19.6 43.7 43.7 43.7c20.4 0 37.6-14.1 42.4-33h197v-93.9h66.9v141.3h310.9c4.1 10.8 14.6 18.5 26.8 18.5 15.8 0 28.7-12.8 28.7-28.7 0-16-12.9-28.8-28.7-28.8z m-622.5-9.3c-3.8 8.1-12 13.7-21.5 13.7-13.1 0-23.7-10.6-23.7-23.7s10.6-23.7 23.7-23.7c9.9 0 18.5 6.2 22 14.9 1.1 2.7 1.7 5.7 1.7 8.8 0 3.6-0.8 7-2.2 10z"
        fill="#005BFF"
      />
    </svg>
  ),
  columnChart: (
    <svg
      xmlns="http://www.w3.org/2000/svg"
      width="100%"
      height="100%"
      className="pointer-events-none"
      viewBox="0 0 1024 1024">
      <path d="M928.1 881v44H95.9V99h44v782z" fill="#39393A" />
      <path
        d="M352 435.7v403.4H204V435.7h148m22-22H182v447.4h192V413.7zM608 307.9v531.2H460V307.9h148m22-22H438v575.2h192V285.9z"
        fill="#39393A"
      />
      <path
        d="M866.1 177.3v663.9H714V177.3h152.1m20-20H694v703.9h192V157.3h0.1z"
        fill="#E73B37"
      />
    </svg>
  ),
  commentChat: (
    <svg
      xmlns="http://www.w3.org/2000/svg"
      width="100%"
      height="100%"
      className="pointer-events-none"
      viewBox="0 0 1024 1024"
      fill="#000000">
      <path
        d="M40.628 184.1c-4.42 0-8.076-3.576-8.076-7.996 0-4.422 3.498-7.998 7.904-7.998h0.172a8.002 8.002 0 0 1 7.998 7.998 8 8 0 0 1-7.998 7.996zM72.62 184.1c-4.42 0-8.076-3.576-8.076-7.996 0-4.422 3.498-7.998 7.904-7.998h0.172a8.002 8.002 0 0 1 7.998 7.998 8.004 8.004 0 0 1-7.998 7.996zM104.61 184.1c-4.42 0-8.076-3.576-8.076-7.996 0-4.422 3.498-7.998 7.904-7.998h0.172a8.002 8.002 0 0 1 7.998 7.998 8.004 8.004 0 0 1-7.998 7.996z"
        fill=""
      />
      <path
        d="M1015.848 200.096H8.156a7.994 7.994 0 0 1-7.998-7.998v-15.994c0-13.23 10.762-23.994 23.992-23.994h975.702c13.23 0 23.992 10.764 23.992 23.994v15.994a7.994 7.994 0 0 1-7.996 7.998zM16.152 184.1h991.696v-7.996a8.008 8.008 0 0 0-7.996-7.998H24.15c-4.342 0-7.998 3.662-7.998 7.998v7.996z"
        fill=""
      />
      <path
        d="M1015.848 871.89H8.156a7.994 7.994 0 0 1-7.998-7.998V192.098a7.994 7.994 0 0 1 7.998-7.998h1007.692a7.994 7.994 0 0 1 7.996 7.998v671.794a7.994 7.994 0 0 1-7.996 7.998zM16.152 855.894h991.696V200.096H16.152v655.798z"
        fill=""
      />
      <path
        d="M967.86 823.904H56.14a7.994 7.994 0 0 1-7.998-7.998v-95.968a7.994 7.994 0 0 1 7.998-7.998h911.72c4.422 0 8 3.576 8 7.998v95.968a7.994 7.994 0 0 1-8 7.998z m-903.722-15.994h895.726v-79.976H64.138v79.976zM967.86 695.944H56.14a7.994 7.994 0 0 1-7.998-7.998v-95.968a7.994 7.994 0 0 1 7.998-7.998h911.72c4.422 0 8 3.576 8 7.998v95.968a7.994 7.994 0 0 1-8 7.998z m-903.722-15.994h895.726v-79.976H64.138v79.976zM967.86 567.982H56.14a7.982 7.982 0 0 1-7.998-7.998V240.092a7.994 7.994 0 0 1 7.998-7.998h911.72c4.422 0 8 3.576 8 7.998v319.892a7.984 7.984 0 0 1-8 7.998z m-903.722-15.994h895.726v-303.9H64.138v303.9z"
        fill=""
      />
      <path
        d="M184.1 392.038a8.036 8.036 0 0 1-3.578-0.844l-30.304-15.152H104.124a7.992 7.992 0 0 1-7.998-7.996v-79.976a7.994 7.994 0 0 1 7.998-7.998h95.97a7.994 7.994 0 0 1 7.998 7.998v79.976a7.992 7.992 0 0 1-7.998 7.996h-7.998v7.998a8 8 0 0 1-7.996 7.998z m-71.978-31.992h39.988c1.234 0 2.468 0.29 3.578 0.844l20.416 10.208v-3.052a7.994 7.994 0 0 1 7.998-7.998h7.998v-63.98H112.122v63.978zM919.876 312.06h-655.8a7.992 7.992 0 0 1-7.998-7.996 7.992 7.992 0 0 1 7.998-7.998h655.798a7.99 7.99 0 0 1 7.996 7.998 7.988 7.988 0 0 1-7.994 7.996zM919.876 360.046h-655.8c-4.42 0-7.998-3.578-7.998-7.998s3.576-7.998 7.998-7.998h655.798c4.422 0 7.996 3.578 7.996 7.998s-3.574 7.998-7.994 7.998zM919.876 408.032h-655.8a7.992 7.992 0 0 1-7.998-7.996 7.992 7.992 0 0 1 7.998-7.998h655.798a7.99 7.99 0 0 1 7.996 7.998 7.988 7.988 0 0 1-7.994 7.996zM583.976 456.018h-319.9c-4.42 0-7.998-3.578-7.998-7.998s3.576-7.998 7.998-7.998h319.9c4.422 0 8 3.578 8 7.998s-3.578 7.998-8 7.998zM919.876 647.958h-655.8c-4.42 0-7.998-3.578-7.998-7.998s3.576-7.998 7.998-7.998h655.798c4.422 0 7.996 3.578 7.996 7.998s-3.574 7.998-7.994 7.998zM919.876 775.918h-655.8a7.992 7.992 0 0 1-7.998-7.996 7.992 7.992 0 0 1 7.998-7.998h655.798a7.99 7.99 0 0 1 7.996 7.998 7.988 7.988 0 0 1-7.994 7.996zM360.046 519.998h-95.97c-4.42 0-7.998-3.578-7.998-7.998s3.576-7.998 7.998-7.998h95.97c4.42 0 7.998 3.578 7.998 7.998s-3.576 7.998-7.998 7.998zM919.876 519.998h-95.968c-4.422 0-8-3.578-8-7.998s3.578-7.998 8-7.998h95.968c4.422 0 7.996 3.578 7.996 7.998s-3.576 7.998-7.996 7.998z"
        fill=""
      />
      <path
        d="M120.12 663.954a7.972 7.972 0 0 1-5.654-2.344l-31.99-31.988a7.996 7.996 0 1 1 11.308-11.31l31.99 31.99a7.994 7.994 0 0 1-5.654 13.652z"
        fill=""
      />
      <path
        d="M120.12 663.954a7.994 7.994 0 0 1-5.654-13.652l31.99-31.99a7.996 7.996 0 1 1 11.308 11.31l-31.99 31.988a7.972 7.972 0 0 1-5.654 2.344z"
        fill=""
      />
      <path
        d="M120.12 791.914a7.972 7.972 0 0 1-5.654-2.344l-31.99-31.988a7.996 7.996 0 1 1 11.308-11.31l31.99 31.99a7.994 7.994 0 0 1-5.654 13.652z"
        fill=""
      />
      <path
        d="M120.12 791.914a7.994 7.994 0 0 1-5.654-13.652l31.99-31.99a7.996 7.996 0 1 1 11.308 11.31l-31.99 31.988a7.972 7.972 0 0 1-5.654 2.344z"
        fill=""
      />
    </svg>
  ),
  computerColored: (
    <svg
      xmlns="http://www.w3.org/2000/svg"
      width="100%"
      height="100%"
      className="pointer-events-none"
      viewBox="0 0 1024 1024">
      <path
        d="M511.3 676.9m-10 0a10 10 0 1 0 20 0 10 10 0 1 0-20 0Z"
        fill="#E73B37"
      />
      <path
        d="M960 756V138.5H64V756h320.1v85.5H256.2v44h511.9v-44h-128V756H960zM108 182.5h808v427.1H108V182.5z m488.1 659h-168V756h168v85.5zM108 712v-82.5h808V712H108z"
        fill="#39393A"
      />
      <path
        d="M167.536 327.703l90.72-90.721 14.143 14.142-90.721 90.72zM172.959 423.469l181.159-181.16 14.142 14.143L187.1 437.61z"
        fill="#E73B37"
      />
    </svg>
  ),
  cartColored: (
    <svg
      xmlns="http://www.w3.org/2000/svg"
      width="100%"
      height="100%"
      className="pointer-events-none"
      viewBox="0 0 1024 1024">
      <path
        d="M960.1 258.4H245.8l-36.1-169H63.9v44h110.2l26.7 125 100.3 469.9 530 0.4v-44l-494.4-0.3-22.6-105.9H832l128.1-320.1z m-65 44L855.6 401H276.3l-21.1-98.6h639.9zM304.8 534.5L279.7 417h569.5l-47 117.5H304.8z"
        fill="#39393A"
      />
      <path
        d="M375.6 810.6c28.7 0 52 23.3 52 52s-23.3 52-52 52-52-23.3-52-52 23.3-52 52-52m0-20c-39.7 0-72 32.2-72 72s32.2 72 72 72 72-32.2 72-72-32.3-72-72-72zM732 810.6c28.7 0 52 23.3 52 52s-23.3 52-52 52-52-23.3-52-52 23.3-52 52-52m0-20c-39.7 0-72 32.2-72 72s32.2 72 72 72c39.7 0 72-32.2 72-72s-32.3-72-72-72zM447.5 302.4h16v232.1h-16zM652 302.4h16v232.1h-16z"
        fill="#E73B37"
      />
      <path d="M276.3 401l3.4 16-3.4-16z" fill="#343535" />
    </svg>
  ),
  copyClipboard: (
    <svg
      xmlns="http://www.w3.org/2000/svg"
      width="100%"
      height="100%"
      className="pointer-events-none"
      viewBox="0 0 1024 1024">
      <path
        d="M589.3 260.9v30H371.4v-30H268.9v513h117.2v-304l109.7-99.1h202.1V260.9z"
        fill="#E1F0FF"
      />
      <path d="M516.1 371.1l-122.9 99.8v346.8h370.4V371.1z" fill="#E1F0FF" />
      <path d="M752.7 370.8h21.8v435.8h-21.8z" fill="#446EB1" />
      <path d="M495.8 370.8h277.3v21.8H495.8z" fill="#446EB1" />
      <path d="M495.8 370.8h21.8v124.3h-21.8z" fill="#446EB1" />
      <path d="M397.7 488.7l-15.4-15.4 113.5-102.5 15.4 15.4z" fill="#446EB1" />
      <path d="M382.3 473.3h135.3v21.8H382.3z" fill="#446EB1" />
      <path
        d="M382.3 479.7h21.8v348.6h-21.8zM404.1 806.6h370.4v21.8H404.1z"
        fill="#446EB1"
      />
      <path
        d="M447.7 545.1h261.5v21.8H447.7zM447.7 610.5h261.5v21.8H447.7zM447.7 675.8h261.5v21.8H447.7z"
        fill="#6D9EE8"
      />
      <path d="M251.6 763h130.7v21.8H251.6z" fill="#446EB1" />
      <path
        d="M251.6 240.1h21.8v544.7h-21.8zM687.3 240.1h21.8v130.7h-21.8zM273.4 240.1h108.9v21.8H273.4z"
        fill="#446EB1"
      />
      <path
        d="M578.4 240.1h130.7v21.8H578.4zM360.5 196.5h21.8v108.9h-21.8zM382.3 283.7h196.1v21.8H382.3zM534.8 196.5h65.4v21.8h-65.4z"
        fill="#446EB1"
      />
      <path
        d="M360.5 196.5h65.4v21.8h-65.4zM404.1 174.7h152.5v21.8H404.1zM578.4 196.5h21.8v108.9h-21.8z"
        fill="#446EB1"
      />
    </svg>
  ),
  creativity: (
    <svg
      xmlns="http://www.w3.org/2000/svg"
      width="100%"
      height="100%"
      className="pointer-events-none"
      viewBox="0 0 1024 1024">
      <path d="M393.3 768H392h1.3z" fill="#202020" />
      <path
        d="M511.9 199.6C355.7 199.6 229 326.2 229 482.5c0 103.8 55.9 194.6 139.3 243.8v89.8c0 1.3 0 2.5 0.1 3.8 0.1 3.2 0.3 6.4 0.6 9.6 6.8 72.8 68.6 130.3 143.1 130.3 39.5 0 75.4-16.2 101.5-42.2 23-23 38.3-53.8 41.6-87.9 0.3-3.2 0.5-6.4 0.6-9.6 0-1.3 0.1-2.7 0.1-4v-90l0.6-0.3C739.4 676.5 795 586 795 482.5c-0.2-156.3-126.8-282.9-283.1-282.9zM391.9 768h1.3-1.3z m219.8 48.1c0 5.8-0.5 11.5-1.5 17-1.1 6.5-2.9 12.8-5.3 18.9-5 12.7-12.6 24.5-22.6 34.5-18.9 18.9-43.9 29.3-70.4 29.3-26.5 0-51.5-10.4-70.4-29.3-10-10-17.7-21.8-22.7-34.6-2.4-6.1-4.1-12.4-5.2-18.9-1-5.5-1.4-11.2-1.4-16.9v-8.8h199.4v8.8z m0-24.8H412.3v-47.7h199.4v47.7z m69.1-139.9c-7.8 7.8-15.9 14.9-24.5 21.4-13.7 10.4-28.4 19.3-44 26.5l-0.6 0.3v0.1H412.3c-15.4-7.1-29.9-15.7-43.4-25.8-9.1-6.8-17.7-14.3-25.9-22.5-22-22-39.2-47.5-51.2-75.9-12.5-29.4-18.8-60.7-18.8-93s6.3-63.5 18.8-93c12-28.4 29.3-54 51.2-76 22-22 47.5-39.2 76-51.2 29.4-12.4 60.7-18.7 93-18.7s63.6 6.3 93 18.7c28.4 12 54 29.3 76 51.2 22 22 39.2 47.5 51.2 76 12.4 29.4 18.8 60.7 18.8 93s-6.3 63.5-18.8 93c-12.2 28.4-29.4 53.9-51.4 75.9z"
        fill="#39393A"
      />
      <path d="M391.9 768h1.3-1.3z" fill="#343535" />
      <path
        d="M511.9 432.3c-39.7 0-72 32.3-72 72 0 37.3 28.6 68.1 65 71.7v123.7h14V576c36.4-3.5 65-34.3 65-71.7 0-39.7-32.3-72-72-72z m0 128c-30.9 0-56-25.1-56-56s25.1-56 56-56 56 25.1 56 56-25.1 56-56 56z"
        fill="#E73B37"
      />
      <path
        d="M512 103.6m-39.4 0a39.4 39.4 0 1 0 78.8 0 39.4 39.4 0 1 0-78.8 0Z"
        fill="#E73B37"
      />
      <path
        d="M244.2 214.5m-39.4 0a39.4 39.4 0 1 0 78.8 0 39.4 39.4 0 1 0-78.8 0Z"
        fill="#E73B37"
      />
      <path
        d="M133.3 482.2m-39.4 0a39.4 39.4 0 1 0 78.8 0 39.4 39.4 0 1 0-78.8 0Z"
        fill="#E73B37"
      />
      <path
        d="M890.7 482.2m-39.4 0a39.4 39.4 0 1 0 78.8 0 39.4 39.4 0 1 0-78.8 0Z"
        fill="#E73B37"
      />
      <path
        d="M779.8 214.5m-39.4 0a39.4 39.4 0 1 0 78.8 0 39.4 39.4 0 1 0-78.8 0Z"
        fill="#E73B37"
      />
    </svg>
  ),
  deadline: (
    <svg
      xmlns="http://www.w3.org/2000/svg"
      width="100%"
      height="100%"
      className="pointer-events-none"
      viewBox="0 0 1024 1024"
      fill="#000000">
      <path
        d="M552.0285 863.954H136.0825c-4.422 0-8-3.578-8-7.996 0-4.422 3.578-8 8-8h415.946a7.994 7.994 0 0 1 7.998 8 7.992 7.992 0 0 1-7.998 7.996zM8.0985 735.972a7.994 7.994 0 0 1-7.998-8V168.044c0-4.42 3.578-8 7.998-8 4.422 0 8 3.578 8 8v559.928c0 4.422-3.578 8-8 8z"
        fill=""
      />
      <path
        d="M88.0885 176.044H8.0985c-4.42 0-7.998-3.578-7.998-8s3.578-8 7.998-8h79.99c4.42 0 7.998 3.578 7.998 8s-3.576 8-7.998 8zM744.0025 176.044H664.0145c-4.422 0-8-3.578-8-8s3.578-8 8-8h79.988c4.422 0 8 3.578 8 8s-3.578 8-8 8z"
        fill=""
      />
      <path
        d="M744.0025 240.036a7.994 7.994 0 0 1-7.998-8V168.044c0-4.42 3.578-8 7.998-8 4.422 0 8 3.578 8 8v63.992c0 4.422-3.578 8-8 8zM648.0165 320.026H8.0985c-4.42 0-7.998-3.578-7.998-8s3.578-8 7.998-8h639.918c4.42 0 7.998 3.578 7.998 8s-3.578 8-7.998 8zM408.0485 432.01h-63.992c-4.422 0-8-3.578-8-8V360.02c0-4.422 3.578-8 8-8h63.992a7.994 7.994 0 0 1 7.998 8v63.992a7.994 7.994 0 0 1-7.998 7.998z m-55.994-15.998h47.994v-47.994H352.0545v47.994zM504.0425 432.01h-64c-4.42 0-8-3.578-8-8V360.02c0-4.422 3.578-8 8-8h64c4.422 0 8 3.578 8 8v63.992a7.994 7.994 0 0 1-8 7.998z m-56-15.998h48.002v-47.994h-48.002v47.994zM536.0305 432.01a7.994 7.994 0 0 1-7.998-8V360.02c0-4.422 3.576-8 7.998-8h63.992a7.994 7.994 0 0 1 7.998 8 7.994 7.994 0 0 1-7.998 7.998h-55.992v55.994a7.994 7.994 0 0 1-8 7.998zM120.0845 528H56.0925c-4.422 0-8-3.578-8-8v-63.992c0-4.42 3.578-8 8-8h63.992a7.994 7.994 0 0 1 7.998 8V520c0 4.422-3.576 8-7.998 8z m-55.992-16h47.994v-47.994H64.0925V512zM216.0725 528H152.0805c-4.422 0-8-3.578-8-8v-63.992c0-4.42 3.578-8 8-8h63.992c4.42 0 8 3.578 8 8V520c0 4.422-3.58 8-8 8z m-55.994-16h47.994v-47.994H160.0785V512zM312.0605 528h-63.992a7.994 7.994 0 0 1-7.998-8v-63.992c0-4.42 3.578-8 7.998-8h63.992c4.422 0 8 3.578 8 8V520a7.996 7.996 0 0 1-8 8z m-55.992-16h47.994v-47.994h-47.994V512zM408.0485 528h-63.992c-4.422 0-8-3.578-8-8v-63.992c0-4.42 3.578-8 8-8h63.992a7.994 7.994 0 0 1 7.998 8V520c0 4.422-3.578 8-7.998 8z m-55.994-16h47.994v-47.994H352.0545V512zM504.0425 528h-64c-4.42 0-8-3.578-8-8v-63.992c0-4.42 3.578-8 8-8h64c4.422 0 8 3.578 8 8V520c0 4.422-3.578 8-8 8z m-56-16h48.002v-47.994h-48.002V512zM536.0305 480.004a7.994 7.994 0 0 1-7.998-8v-15.998c0-4.42 3.576-8 7.998-8s8 3.578 8 8v15.998c0 4.422-3.578 8-8 8zM120.0845 623.984H56.0925c-4.422 0-8-3.578-8-7.996v-63.992c0-4.422 3.578-8 8-8h63.992a7.994 7.994 0 0 1 7.998 8v63.992a7.992 7.992 0 0 1-7.998 7.996z m-55.992-15.996h47.994v-47.996H64.0925v47.996zM216.0725 623.984H152.0805c-4.422 0-8-3.578-8-7.996v-63.992c0-4.422 3.578-8 8-8h63.992c4.42 0 8 3.578 8 8v63.992a7.996 7.996 0 0 1-8 7.996z m-55.994-15.996h47.994v-47.996H160.0785v47.996zM312.0605 623.984h-63.992a7.994 7.994 0 0 1-7.998-7.996v-63.992c0-4.422 3.578-8 7.998-8h63.992c4.422 0 8 3.578 8 8v63.992a7.996 7.996 0 0 1-8 7.996z m-55.992-15.996h47.994v-47.996h-47.994v47.996zM408.0485 623.984h-63.992c-4.422 0-8-3.578-8-7.996v-63.992c0-4.422 3.578-8 8-8h63.992a7.994 7.994 0 0 1 7.998 8v63.992a7.994 7.994 0 0 1-7.998 7.996z m-55.994-15.996h47.994v-47.996H352.0545v47.996zM440.0425 623.984c-4.42 0-8-3.578-8-7.996v-63.992c0-4.422 3.578-8 8-8h64c4.422 0 8 3.578 8 8s-3.578 7.996-8 7.996h-56v55.996a7.994 7.994 0 0 1-8 7.996zM312.0605 719.972h-63.992a7.994 7.994 0 0 1-7.998-8v-63.988c0-4.422 3.578-8 7.998-8h63.992c4.422 0 8 3.578 8 8v63.988a7.996 7.996 0 0 1-8 8z m-55.992-15.996h47.994V655.98h-47.994v47.996zM408.0485 719.972h-63.992c-4.422 0-8-3.578-8-8v-63.988c0-4.422 3.578-8 8-8h63.992a7.994 7.994 0 0 1 7.998 8v63.988c0 4.422-3.578 8-7.998 8z m-55.994-15.996h47.994V655.98H352.0545v47.996zM488.0445 719.972h-48c-4.42 0-8-3.578-8-8v-63.988c0-4.422 3.578-8 8-8h48c4.422 0 8 3.578 8 8a7.994 7.994 0 0 1-8 7.996h-40.002v47.996h40.002c4.422 0 8 3.578 8 7.996 0 4.422-3.578 8-8 8zM312.0605 815.96h-63.992a7.994 7.994 0 0 1-7.998-8v-63.992a7.994 7.994 0 0 1 7.998-7.996h63.992c4.422 0 8 3.578 8 7.996v63.992a7.996 7.996 0 0 1-8 8z m-55.992-15.996h47.994v-47.996h-47.994v47.996zM408.0485 815.96h-63.992c-4.422 0-8-3.578-8-8v-63.992a7.994 7.994 0 0 1 8-7.996h63.992a7.994 7.994 0 0 1 7.998 7.996v63.992c0 4.422-3.578 8-7.998 8z m-55.994-15.996h47.994v-47.996H352.0545v47.996zM504.0425 815.96h-64c-4.42 0-8-3.578-8-8v-63.992c0-4.418 3.578-7.996 8-7.996s8 3.578 8 7.996v55.996h56c4.422 0 8 3.574 8 7.996s-3.578 8-8 8zM584.0245 895.95H8.0985a7.994 7.994 0 0 1-7.998-7.996c0-4.422 3.578-8 7.998-8h575.926a7.994 7.994 0 0 1 7.998 8 7.992 7.992 0 0 1-7.998 7.996zM632.0185 927.946H8.0985a7.994 7.994 0 0 1-7.998-7.996c0-4.422 3.578-8 7.998-8h623.92a7.994 7.994 0 0 1 7.998 8 7.992 7.992 0 0 1-7.998 7.996zM136.0825 863.954a7.976 7.976 0 0 1-5.656-2.344l-127.984-127.98a8 8 0 1 1 11.312-11.312l127.982 127.984a7.994 7.994 0 0 1-5.654 13.652z"
        fill=""
      />
      <path
        d="M136.0825 863.954c-4.422 0-8-3.578-8-7.996v-127.984c0-4.422 3.578-8 8-8a7.994 7.994 0 0 1 7.998 8v127.984a7.992 7.992 0 0 1-7.998 7.996z"
        fill=""
      />
      <path
        d="M136.0825 735.972H8.0985c-4.42 0-7.998-3.578-7.998-8s3.578-8 7.998-8h127.984c4.42 0 7.998 3.578 7.998 8s-3.576 8-7.998 8zM8.0985 895.95a7.994 7.994 0 0 1-7.998-7.996v-115.316a7.994 7.994 0 0 1 7.998-7.996c4.422 0 8 3.578 8 7.996v115.316a7.994 7.994 0 0 1-8 7.996zM120.0845 655.98H56.0925c-4.422 0-8-3.578-8-7.996 0-4.422 3.578-8 8-8h63.992a7.994 7.994 0 0 1 7.998 8 7.992 7.992 0 0 1-7.998 7.996z"
        fill=""
      />
      <path
        d="M120.0845 703.976c-4.422 0-8-3.578-8-8v-47.992c0-4.422 3.578-8 8-8a7.994 7.994 0 0 1 7.998 8v47.992c0 4.422-3.576 8-7.998 8zM56.0925 703.976c-4.422 0-8-3.578-8-8v-47.992c0-4.422 3.578-8 8-8s8 3.578 8 8v47.992c0 4.422-3.578 8-8 8zM152.0805 703.976c-4.422 0-8-3.578-8-8v-47.992c0-4.422 3.578-8 8-8a7.994 7.994 0 0 1 7.998 8v47.992c0 4.422-3.578 8-7.998 8z"
        fill=""
      />
      <path
        d="M216.0725 655.98H152.0805c-4.422 0-8-3.578-8-7.996 0-4.422 3.578-8 8-8h63.992a7.996 7.996 0 1 1 0 15.996z"
        fill=""
      />
      <path
        d="M216.0725 719.972c-4.42 0-8-3.578-8-8v-63.988c0-4.422 3.578-8 8-8s8 3.578 8 8v63.988c0 4.422-3.58 8-8 8z"
        fill=""
      />
      <path
        d="M216.0725 719.972H168.0785a7.996 7.996 0 1 1 0-15.996h47.994a7.996 7.996 0 1 1 0 15.996zM216.0725 815.96c-4.42 0-8-3.578-8-8v-63.992c0-4.418 3.578-7.996 8-7.996s8 3.578 8 7.996v63.992c0 4.422-3.58 8-8 8z"
        fill=""
      />
      <path
        d="M216.0725 815.96H168.0785c-4.42 0-8-3.578-8-8s3.578-7.996 8-7.996h47.994c4.42 0 8 3.574 8 7.996s-3.58 8-8 8zM216.0725 751.968H168.0785a7.996 7.996 0 1 1 0-15.996h47.994a7.996 7.996 0 1 1 0 15.996zM112.0845 288.03H64.0925c-4.42 0-8-3.578-8-8a7.994 7.994 0 0 1 8-7.998h47.994a8 8 0 1 1-0.002 15.998zM208.0745 288.03H160.0785a7.994 7.994 0 0 1-7.998-8 7.994 7.994 0 0 1 7.998-7.998h47.994c4.422 0 8 3.578 8 7.998 0 4.422-3.578 8-7.998 8zM304.0605 288.03h-47.994c-4.422 0-8-3.578-8-8a7.994 7.994 0 0 1 8-7.998h47.994c4.42 0 8 3.578 8 7.998 0 4.422-3.578 8-8 8zM400.0485 288.03H352.0545a7.994 7.994 0 0 1-7.998-8 7.994 7.994 0 0 1 7.998-7.998h47.994c4.422 0 8 3.578 8 7.998 0 4.422-3.578 8-8 8zM496.0445 288.03h-47.994c-4.422 0-8-3.578-8-8a7.994 7.994 0 0 1 8-7.998h47.994a7.994 7.994 0 0 1 7.998 7.998c0 4.422-3.578 8-7.998 8zM592.0225 288.03h-47.992c-4.422 0-8-3.578-8-8a7.994 7.994 0 0 1 8-7.998h47.992c4.422 0 8 3.578 8 7.998 0 4.422-3.578 8-8 8zM688.0105 288.03h-47.994a7.994 7.994 0 0 1-7.998-8 7.994 7.994 0 0 1 7.998-7.998h47.994c4.422 0 8 3.578 8 7.998 0 4.422-3.578 8-8 8zM136.0825 240.036c-13.234 0-23.998-10.764-23.998-23.998V120.052c0-13.232 10.764-23.998 23.998-23.998 13.232 0 23.996 10.766 23.996 23.998v95.988c0 13.232-10.762 23.996-23.996 23.996z m0-127.984c-4.414 0-8 3.586-8 8v95.988c0 4.414 3.586 8 8 8a8.004 8.004 0 0 0 7.998-8V120.052c0-4.414-3.584-8-7.998-8zM296.0625 240.036c-13.232 0-23.996-10.764-23.996-23.998V120.052c0-13.232 10.764-23.998 23.996-23.998s23.998 10.766 23.998 23.998v95.988c-0.002 13.232-10.766 23.996-23.998 23.996z m0-127.984a8.004 8.004 0 0 0-7.998 8v95.988c0 4.414 3.584 8 7.998 8s8-3.586 8-8V120.052a8.006 8.006 0 0 0-8-8zM456.0485 240.036c-13.234 0-24.004-10.764-24.004-23.998V120.052c0-13.232 10.772-23.998 24.004-23.998 13.232 0 23.998 10.766 23.998 23.998v95.988c0 13.232-10.764 23.996-23.998 23.996z m0-127.984a8.01 8.01 0 0 0-8.006 8v95.988c0 4.414 3.594 8 8.006 8s8-3.586 8-8V120.052c0-4.414-3.586-8-8-8zM616.0205 240.036c-13.232 0-23.998-10.764-23.998-23.998V120.052c0-13.232 10.766-23.998 23.998-23.998s23.996 10.766 23.996 23.998v95.988c0 13.232-10.764 23.996-23.996 23.996z m0-127.984c-4.406 0-8 3.586-8 8v95.988c0 4.414 3.594 8 8 8a8.01 8.01 0 0 0 7.998-8V120.052c0-4.414-3.594-8-7.998-8zM248.0685 176.044H184.0765c-4.42 0-8-3.578-8-8s3.578-8 8-8h63.992c4.422 0 8 3.578 8 8s-3.578 8-8 8zM408.0485 176.044h-63.992c-4.422 0-8-3.578-8-8s3.578-8 8-8h63.992c4.42 0 7.998 3.578 7.998 8s-3.578 8-7.998 8zM568.0265 176.044h-63.984c-4.42 0-7.998-3.578-7.998-8s3.578-8 7.998-8h63.984c4.422 0 8 3.578 8 8s-3.578 8-8 8zM768.0005 927.946c-4.422 0-8-3.578-8-7.996 0-4.422 3.578-8 8-8 132.326 0 239.968-107.644 239.968-239.968 0-4.422 3.576-8 7.998-8s8 3.578 8 8c0.002 141.136-114.826 255.964-255.966 255.964z"
        fill=""
      />
      <path
        d="M768.0005 927.946c-141.138 0-255.958-114.828-255.958-255.964 0-4.422 3.578-8 7.998-8a8.002 8.002 0 0 1 8.008 8c0 132.324 107.642 239.968 239.954 239.968a7.996 7.996 0 1 1-0.002 15.996z"
        fill=""
      />
      <path
        d="M1015.9685 679.976a7.99 7.99 0 0 1-7.998-7.996c0-150.754-97.644-273.762-120.906-300.916-17.264 13.208-66.304 44.962-100.706 10.616-28.558-28.662-17.936-84.334-9.032-115.072-60.696 40.082-249.28 182.578-249.28 405.37a8 8 0 0 1-8.008 7.996 7.992 7.992 0 0 1-7.998-7.996c0-273.684 273.3-429.39 276.05-430.928a8.052 8.052 0 0 1 9.186 0.976 7.988 7.988 0 0 1 2.14 8.982c-0.344 0.86-34.2 86.8-1.75 119.36 30.934 30.824 84.458-15.858 85.004-16.334a7.994 7.994 0 0 1 11.154 0.516c5.312 5.672 130.14 140.896 130.14 317.428a7.986 7.986 0 0 1-7.996 7.998z"
        fill=""
      />
      <path
        d="M768.4865 496.002c-4.422 0-8.078-3.578-8.078-8 0-4.42 3.5-7.998 7.906-7.998h0.172a8.004 8.004 0 0 1 7.998 7.998c0 4.422-3.594 8-7.998 8zM768.4865 863.954c-4.422 0-8.078-3.578-8.078-7.996 0-4.422 3.5-8 7.906-8h0.172a8.006 8.006 0 0 1 7.998 8 8.004 8.004 0 0 1-7.998 7.996zM676.4965 520.656c-4.422 0-8.078-3.578-8.078-8 0-4.422 3.5-8 7.906-8h0.172a8.006 8.006 0 0 1 7.998 8c0 4.422-3.592 8-7.998 8zM860.4725 839.3c-4.42 0-8.076-3.578-8.076-8 0-4.418 3.5-7.996 7.904-7.996h0.172c4.406 0 8 3.578 8 7.996 0 4.422-3.594 8-8 8zM609.1305 587.992c-4.42 0-8.076-3.578-8.076-8s3.5-8 7.904-8h0.172c4.406 0 8 3.578 8 8s-3.594 8-8 8zM927.8085 771.964c-4.422 0-8.076-3.574-8.076-7.996s3.498-8 7.904-8h0.172c4.406 0 8 3.578 8 8s-3.594 7.996-8 7.996zM584.4785 679.976c-4.422 0-8.076-3.574-8.076-7.996s3.498-8 7.904-8h0.172a8 8 0 0 1 0 15.996zM952.4285 679.976c-4.42 0-8.076-3.574-8.076-7.996s3.5-8 7.904-8h0.172c4.406 0 8 3.578 8 8s-3.594 7.996-8 7.996zM609.0985 771.98c-4.42 0-8.076-3.574-8.076-7.996s3.5-8 7.904-8h0.172c4.406 0 8 3.578 8 8s-3.594 7.996-8 7.996zM927.7765 587.992c-4.422 0-8.076-3.578-8.076-8s3.498-8 7.904-8h0.172c4.406 0 8 3.578 8 8s-3.594 8-8 8zM676.4665 839.332c-4.422 0-8.078-3.578-8.078-8 0-4.418 3.5-7.996 7.906-7.996h0.172a8.004 8.004 0 0 1 7.998 7.996c0 4.422-3.594 8-7.998 8zM860.4405 520.672c-4.42 0-8.076-3.578-8.076-8 0-4.422 3.5-8 7.904-8h0.172c4.406 0 8 3.578 8 8 0 4.422-3.594 8-8 8z"
        fill=""
      />
      <path
        d="M768.0005 895.95c-123.5 0-223.97-100.468-223.97-223.968s100.47-223.972 223.97-223.972c123.498 0 223.97 100.472 223.97 223.972s-100.472 223.968-223.97 223.968z m0-431.944c-114.674 0-207.974 93.302-207.974 207.974s93.3 207.972 207.974 207.972c114.672 0 207.972-93.3 207.972-207.972s-93.3-207.974-207.972-207.974z"
        fill=""
      />
      <path
        d="M768.0005 679.976c-4.422 0-8-3.574-8-7.996v-135.984a7.992 7.992 0 0 1 8-7.996 7.992 7.992 0 0 1 7.998 7.996v135.984a7.992 7.992 0 0 1-7.998 7.996z"
        fill=""
      />
      <path
        d="M855.9905 767.968a7.976 7.976 0 0 1-5.656-2.344l-87.988-87.988a8 8 0 0 1 11.31-11.312l87.988 87.988a8 8 0 0 1-5.654 13.656z"
        fill=""
      />
      <path
        d="M488.0445 623.984h-48c-4.42 0-8-3.578-8-7.996 0-4.422 3.578-8 8-8h48c4.422 0 8 3.578 8 8a7.994 7.994 0 0 1-8 7.996z"
        fill=""
      />
      <path
        d="M600.0225 384.016c-4.422 0-8-3.578-8-7.998v-15.998c0-4.422 3.578-8 8-8s7.998 3.578 7.998 8v15.998a7.992 7.992 0 0 1-7.998 7.998z"
        fill=""
      />
      <path
        d="M552.0285 432.01h-15.998c-4.422 0-7.998-3.578-7.998-8s3.576-8 7.998-8h15.998c4.422 0 7.998 3.578 7.998 8s-3.576 8-7.998 8z"
        fill=""
      />
      <path
        d="M504.0425 815.96a7.994 7.994 0 0 1-7.998-8v-31.996a7.992 7.992 0 0 1 7.998-7.996c4.422 0 8 3.574 8 7.996v31.996c0 4.422-3.578 8-8 8z"
        fill=""
      />
      <path
        d="M488.0445 751.968h-48a7.996 7.996 0 1 1 0-15.996h48c4.422 0 8 3.578 8 7.996 0 4.422-3.578 8-8 8z"
        fill=""
      />
    </svg>
  ),
  speach: (
    <svg
      xmlns="http://www.w3.org/2000/svg"
      width="100%"
      height="100%"
      className="pointer-events-none"
      viewBox="0 0 1024 1024"
      fill="#000000">
      <path
        d="M319.902 431.932c-4.42 0-8-3.578-8-8v-37.308c0-31.184 16.576-43.478 45.198-54.18 9.578-3.578 35.028-13.092 55.336-22.794 4.016-1.938 8.75-0.234 10.672 3.766a8.004 8.004 0 0 1-3.766 10.67c-18.78 8.968-41.322 17.624-56.648 23.342-27.31 10.216-34.792 18.638-34.792 39.198v37.308a7.998 7.998 0 0 1-8 7.998zM703.852 431.932a7.994 7.994 0 0 1-7.998-8v-37.308c0-20.56-7.484-28.98-34.792-39.198-15.326-5.734-37.886-14.388-56.68-23.404a7.986 7.986 0 0 1-3.766-10.654 8 8 0 0 1 10.67-3.766c18.232 8.734 40.338 17.216 55.37 22.842 28.622 10.702 45.196 22.996 45.196 54.18v37.308a7.996 7.996 0 0 1-8 8zM512.362 322.132c-45.198 0-119.984-71.944-119.984-153.932 0-4.42 3.578-8 7.998-8 4.422 0 8 3.578 8 8 0 71.116 64.866 137.936 103.986 137.936 39.12 0 103.986-66.82 103.986-137.936 0-4.42 3.576-8 7.998-8s8 3.578 8 8c0 81.99-74.788 153.932-119.984 153.932zM399.89 159.966c-0.656 0-1.312-0.078-1.954-0.25a7.99 7.99 0 0 1-6.014-7.014c-4.234-45.182 5.56-81.208 29.122-107.064C455.274 8.032 510.782 0.144 551.308 0.144c24.186 0 41.292 2.828 42.01 2.952a8.006 8.006 0 0 1 6.624 7 8.008 8.008 0 0 1-4.906 8.28c-6.826 2.812-11.202 6.796-13.388 12.202-2.516 6.232-1.624 13.186-0.516 17.732 8.17 0.328 24.608 2.952 37.122 17.56 15.216 17.778 19.764 47.166 13.514 87.332a8.036 8.036 0 0 1-6.188 6.578c-3.282 0.734-6.544-0.64-8.374-3.376l-28.45-42.666c-12.732 4.61-43.244 14.232-76.396 14.232-33.262 0-64.46-9.702-77.35-14.28l-28.464 42.712a8.02 8.02 0 0 1-6.656 3.564z m191.976-63.99c2.61 0 5.14 1.28 6.656 3.562l19.732 29.606c1.232-23.98-2.89-42.042-12.154-52.868-8.954-10.436-20.686-12-26.888-12-1.56 0-2.56 0.094-2.764 0.124-3.532 0.406-6.968-1.468-8.406-4.702-0.328-0.75-7.938-18.466-1.218-35.106a34.906 34.906 0 0 1 4.328-7.78 302.354 302.354 0 0 0-19.842-0.672c-37.306 0-88.144 6.982-118.438 40.26-16.108 17.67-24.73 41.276-25.792 70.35l18.154-27.214a7.97 7.97 0 0 1 9.686-2.968c0.376 0.156 38.056 15.404 77.444 15.404 39.354 0 76.038-15.216 76.396-15.374a8.062 8.062 0 0 1 3.106-0.622z"
        fill=""
      />
      <path
        d="M624.346 176.2a7.994 7.994 0 0 1-7.998-8v-16.232c0-4.422 3.576-8 7.998-8s8 3.578 8 8V168.2c0 4.422-3.578 8-8 8zM400.376 176.2a7.994 7.994 0 0 1-7.998-8v-16.232c0-4.422 3.578-8 7.998-8 4.422 0 8 3.578 8 8V168.2c0 4.422-3.58 8-8 8zM480.13 351.942a7.996 7.996 0 0 1-5.656-2.344l-47.994-47.994a8 8 0 1 1 11.312-11.312l43.932 43.932 27.074-13.452a8.02 8.02 0 0 1 10.732 3.608c1.954 3.954 0.344 8.766-3.608 10.718l-32.23 15.998a8.006 8.006 0 0 1-3.562 0.846z"
        fill=""
      />
      <path
        d="M544.108 351.942a8.058 8.058 0 0 1-3.562-0.844l-32.23-15.998c-3.954-1.952-5.562-6.764-3.61-10.718a8.01 8.01 0 0 1 10.734-3.608l27.074 13.452 43.932-43.932a8 8 0 0 1 11.31 11.312L549.762 349.6a7.998 7.998 0 0 1-5.654 2.342zM512.736 367.94a7.982 7.982 0 0 1-5.656-2.342l-15.998-15.998a8 8 0 1 1 11.312-11.312l15.998 15.998a8 8 0 0 1-5.656 13.654z"
        fill=""
      />
      <path
        d="M512.736 367.94a8 8 0 0 1-5.656-13.654l15.998-15.998a8 8 0 0 1 11.31 11.312l-15.998 15.998a7.972 7.972 0 0 1-5.654 2.342z"
        fill=""
      />
      <path
        d="M496.754 431.932c-0.296 0-0.594-0.016-0.906-0.046a8.016 8.016 0 0 1-7.062-8.842l8-71.992c0.484-4.406 4.296-7.53 8.842-7.062a7.99 7.99 0 0 1 7.062 8.826l-8 71.992a8.008 8.008 0 0 1-7.936 7.124z"
        fill=""
      />
      <path
        d="M528.718 431.932a8.008 8.008 0 0 1-7.938-7.124l-7.998-71.992a7.99 7.99 0 0 1 7.06-8.826c4.516-0.468 8.36 2.672 8.844 7.062l7.998 71.992a8.016 8.016 0 0 1-7.062 8.842 9.374 9.374 0 0 1-0.904 0.046zM753.314 607.91a7.94 7.94 0 0 1-3.188-0.672 7.988 7.988 0 0 1-4.14-10.532l57.774-132.78H220.46l60.196 132.67a8.002 8.002 0 0 1-3.968 10.594c-4 1.842-8.78 0.046-10.592-3.984l-65.334-143.982a7.97 7.97 0 0 1 0.562-7.638 7.982 7.982 0 0 1 6.718-3.656h607.922a7.98 7.98 0 0 1 6.686 3.61 7.976 7.976 0 0 1 0.64 7.576l-62.648 143.982a7.98 7.98 0 0 1-7.328 4.812z"
        fill=""
      />
      <path
        d="M703.976 991.86H319.902c-4.42 0-8-3.578-8-8V535.918a7.994 7.994 0 0 1 8-7.998h384.076a7.992 7.992 0 0 1 7.998 7.998V983.86a7.996 7.996 0 0 1-8 8z m-376.076-15.998h368.078V543.918H327.9v431.944z"
        fill=""
      />
      <path
        d="M735.972 1023.856h-447.94c-4.422 0-8-3.578-8-8V983.86a7.994 7.994 0 0 1 8-7.998h447.942a7.994 7.994 0 0 1 7.998 7.998v31.996a7.998 7.998 0 0 1-8 8z m-439.942-15.998h431.946v-15.998H296.03v15.998zM288.032 607.91h-14.656c-4.42 0-8-3.578-8-8s3.578-8 8-8h14.656c4.42 0 7.998 3.578 7.998 8s-3.578 8-7.998 8zM753.314 607.91h-17.342c-4.422 0-7.998-3.578-7.998-8s3.576-8 7.998-8h17.342c4.422 0 7.998 3.578 7.998 8s-3.576 8-7.998 8zM511.94 607.91c-4.422 0-8-3.578-8-8v-31.996c0-4.422 3.578-8 8-8s7.998 3.578 7.998 8v31.996c0 4.422-3.576 8-7.998 8zM511.94 959.864c-4.422 0-8-3.578-8-8v-95.986c0-4.422 3.578-7.998 8-7.998s7.998 3.576 7.998 7.998v95.986c0 4.422-3.576 8-7.998 8zM511.94 831.878c-57.336 0-103.986-46.648-103.986-103.984 0-57.338 46.65-103.988 103.986-103.988 57.336 0 103.986 46.65 103.986 103.988 0 57.336-46.65 103.984-103.986 103.984z m0-191.974c-48.51 0-87.99 39.464-87.99 87.99 0 48.508 39.48 87.988 87.99 87.988 48.508 0 87.988-39.48 87.988-87.988 0-48.524-39.48-87.99-87.988-87.99z"
        fill=""
      />
      <path
        d="M477.396 784.372a7.98 7.98 0 0 1-4.704-1.532 8.002 8.002 0 0 1-3.186-7.828l5.92-34.372-24.996-24.372a7.976 7.976 0 0 1-2.032-8.186 8.004 8.004 0 0 1 6.452-5.454l34.542-5.014 15.436-31.292c2.688-5.468 11.656-5.468 14.342 0l15.436 31.292 34.542 5.014a8.008 8.008 0 0 1 6.454 5.438 8.02 8.02 0 0 1-2.016 8.202l-24.998 24.372 5.906 34.372a8 8 0 0 1-11.608 8.438L512 767.202l-30.886 16.248a8.04 8.04 0 0 1-3.718 0.922z m34.606-34.2c1.282 0 2.562 0.296 3.718 0.922l20.262 10.654-3.876-22.542a8.05 8.05 0 0 1 2.296-7.078l16.404-15.998-22.668-3.296a7.99 7.99 0 0 1-6.016-4.374l-10.124-20.514-10.124 20.514a7.986 7.986 0 0 1-6.014 4.374l-22.67 3.296 16.404 15.998a8.032 8.032 0 0 1 2.312 7.094l-3.876 22.512 20.248-10.638a7.806 7.806 0 0 1 3.724-0.924z"
        fill=""
      />
      <path
        d="M320.026 1023.856c-4.42 0-8-3.578-8-8v-7.998c0-4.422 3.578-8 8-8s8 3.578 8 8v7.998c0 4.422-3.578 8-8 8z"
        fill=""
      />
      <path
        d="M352.022 1023.856a7.994 7.994 0 0 1-7.998-8v-7.998c0-4.422 3.578-8 7.998-8 4.422 0 8 3.578 8 8v7.998c0 4.422-3.578 8-8 8z"
        fill=""
      />
      <path
        d="M384.018 1023.856a7.994 7.994 0 0 1-7.998-8v-7.998c0-4.422 3.578-8 7.998-8 4.422 0 8 3.578 8 8v7.998c0 4.422-3.578 8-8 8z"
        fill=""
      />
      <path
        d="M416.014 1023.856a7.994 7.994 0 0 1-7.998-8v-7.998c0-4.422 3.578-8 7.998-8 4.422 0 8 3.578 8 8v7.998a7.996 7.996 0 0 1-8 8z"
        fill=""
      />
      <path
        d="M448.01 1023.856c-4.422 0-8-3.578-8-8v-7.998c0-4.422 3.578-8 8-8s8 3.578 8 8v7.998a7.996 7.996 0 0 1-8 8z"
        fill=""
      />
      <path
        d="M480.006 1023.856c-4.422 0-8-3.578-8-8v-7.998c0-4.422 3.578-8 8-8a7.994 7.994 0 0 1 7.998 8v7.998c0 4.422-3.578 8-7.998 8z"
        fill=""
      />
      <path
        d="M512.002 1023.856c-4.422 0-8-3.578-8-8v-7.998c0-4.422 3.578-8 8-8s7.998 3.578 7.998 8v7.998c0 4.422-3.576 8-7.998 8z"
        fill=""
      />
      <path
        d="M543.998 1023.856c-4.422 0-8-3.578-8-8v-7.998c0-4.422 3.578-8 8-8a7.994 7.994 0 0 1 7.998 8v7.998c0 4.422-3.578 8-7.998 8z"
        fill=""
      />
      <path
        d="M575.994 1023.856c-4.422 0-8-3.578-8-8v-7.998c0-4.422 3.578-8 8-8a7.994 7.994 0 0 1 7.998 8v7.998c0 4.422-3.578 8-7.998 8z"
        fill=""
      />
      <path
        d="M607.988 1023.856a7.994 7.994 0 0 1-7.998-8v-7.998c0-4.422 3.578-8 7.998-8 4.422 0 8 3.578 8 8v7.998c0 4.422-3.578 8-8 8z"
        fill=""
      />
      <path
        d="M639.984 1023.856a7.994 7.994 0 0 1-7.998-8v-7.998c0-4.422 3.578-8 7.998-8 4.422 0 8 3.578 8 8v7.998c0 4.422-3.578 8-8 8z"
        fill=""
      />
      <path
        d="M671.98 1023.856a7.994 7.994 0 0 1-7.998-8v-7.998c0-4.422 3.578-8 7.998-8a7.994 7.994 0 0 1 7.998 8v7.998c0 4.422-3.576 8-7.998 8z"
        fill=""
      />
      <path
        d="M703.976 1023.856a7.994 7.994 0 0 1-7.998-8v-7.998c0-4.422 3.576-8 7.998-8s7.998 3.578 7.998 8v7.998c0 4.422-3.576 8-7.998 8z"
        fill=""
      />
    </svg>
  ),
  distributed: (
    <svg
      xmlns="http://www.w3.org/2000/svg"
      width="100%"
      height="100%"
      className="pointer-events-none"
      viewBox="0 0 1024 1024">
      <path d="M71.2 737.7h180.9v180.9H71.2z" fill="#FFFFFF" />
      <path
        d="M260.1 926.6H63.2V729.7h196.9v196.9z m-180.9-16h164.9V745.7H79.2v164.9z"
        fill="#0A0408"
      />
      <path d="M422.1 737.7H603v180.9H422.1z" fill="#FFFFFF" />
      <path
        d="M611 926.6H414.1V729.7H611v196.9z m-180.9-16H595V745.7H430.1v164.9z"
        fill="#0A0408"
      />
      <path d="M771.9 737.7h180.9v180.9H771.9z" fill="#FFFFFF" />
      <path
        d="M960.8 926.6H763.9V729.7h196.9v196.9z m-180.9-16h164.9V745.7H779.9v164.9z"
        fill="#0A0408"
      />
      <path
        d="M504.5 397.1h16v333.5h-16zM153.6 732.6h16v8h-16zM169.6 716.2h-16v-16.3h16v16.3z m0-32.7h-16v-16.3h16v16.3z m0-32.7h-16v-16.3h16v16.3z m0-32.7h-16v-16.3h16v16.3z m0-32.6h-16v-16.3h16v16.3z m0-32.7h-16v-16.3h16v16.3zM153.6 504.1h16v16h-16z"
        fill="#0A0408"
      />
      <path
        d="M840 520.1h-16v-16h16v16z m-31.9 0h-16v-16h16v16z m-32 0h-16v-16h16v16z m-31.9 0h-16v-16h16v16z m-31.9 0h-16v-16h16v16z m-31.9 0h-16v-16h16v16z m-31.9 0h-16v-16h16v16z m-32 0h-16v-16h16v16z m-31.9 0h-16v-16h16v16z m-31.9 0h-16v-16h16v16z m-31.9 0h-16v-16h16v16z m-32 0h-16v-16h16v16z m-31.9 0h-16v-16h16v16z m-31.9 0h-16v-16h16v16z m-31.9 0h-16v-16h16v16z m-31.9 0h-16v-16h16v16z m-32 0h-16v-16h16v16z m-31.9 0h-16v-16h16v16z m-31.9 0h-16v-16h16v16z m-31.9 0h-16v-16h16v16z m-31.9 0h-16v-16h16v16zM855.9 504.1h16v16h-16zM871.9 716.2h-16v-16.3h16v16.3z m0-32.7h-16v-16.3h16v16.3z m0-32.7h-16v-16.3h16v16.3z m0-32.7h-16v-16.3h16v16.3z m0-32.6h-16v-16.3h16v16.3z m0-32.7h-16v-16.3h16v16.3zM855.9 732.6h16v8h-16z"
        fill="#0A0408"
      />
      <path
        d="M655.6 216.7c0 79-143 184.8-143 184.8s-143-105.8-143-184.8 64-143 143-143 143 64 143 143z"
        fill="#EBB866"
      />
      <path
        d="M512.5 411.5l-4.8-3.5c-6-4.4-146.3-109.2-146.3-191.3 0-83.3 67.8-151 151-151 83.3 0 151 67.8 151 151 0 82.1-140.3 186.8-146.3 191.3l-4.6 3.5z m0-329.8c-74.5 0-135 60.6-135 135 0 30.2 23.9 70.4 69.2 116.4 27.4 27.8 55 50 65.8 58.3 10.8-8.4 38.6-30.6 66-58.5 45.2-45.9 69.1-86.2 69.1-116.3 0-74.3-60.6-134.9-135.1-134.9z"
        fill="#0A0408"
      />
      <path d="M116.7 783.2h89.9v89.9h-89.9z" fill="#55B7A8" />
      <path
        d="M467.6 783.2h89.9v89.9h-89.9zM819 783.2h89.9v89.9H819z"
        fill="#4EB3A6"
      />
      <path d="M836.7 486.6h50.9v50.9h-50.9z" fill="#DC444A" />
      <path
        d="M895.6 545.5h-66.9v-66.9h66.9v66.9z m-50.9-16h34.9v-34.9h-34.9v34.9z"
        fill="#0A0408"
      />
      <path d="M130 486.6h50.9v50.9H130z" fill="#DC444A" />
      <path
        d="M188.9 545.5H122v-66.9h66.9v66.9z m-50.9-16h34.9v-34.9H138v34.9z"
        fill="#0A0408"
      />
    </svg>
  ),
  documentColored: (
    <svg
      xmlns="http://www.w3.org/2000/svg"
      width="100%"
      height="100%"
      className="pointer-events-none"
      viewBox="0 0 1024 1024">
      <path
        d="M719.8 651.8m-10 0a10 10 0 1 0 20 0 10 10 0 1 0-20 0Z"
        fill="#E73B37"
      />
      <path
        d="M512.1 64H172v896h680V385.6L512.1 64z m278.8 324.3h-280v-265l280 265zM808 916H216V108h278.6l0.2 0.2v296.2h312.9l0.2 0.2V916z"
        fill="#39393A"
      />
      <path d="M280.5 530h325.9v16H280.5z" fill="#39393A" />
      <path d="M639.5 530h90.2v16h-90.2z" fill="#E73B37" />
      <path d="M403.5 641.8h277v16h-277z" fill="#39393A" />
      <path d="M280.6 641.8h91.2v16h-91.2z" fill="#E73B37" />
      <path d="M279.9 753.7h326.5v16H279.9z" fill="#39393A" />
      <path d="M655.8 753.7h73.9v16h-73.9z" fill="#E73B37" />
    </svg>
  ),
  cloudDownload: (
    <svg
      xmlns="http://www.w3.org/2000/svg"
      width="100%"
      height="100%"
      className="pointer-events-none"
      viewBox="0 0 24 24"
      fill="none">
      <path
        d="M12 12V19M12 19L9.75 16.6667M12 19L14.25 16.6667M6.6 17.8333C4.61178 17.8333 3 16.1917 3 14.1667C3 12.498 4.09438 11.0897 5.59198 10.6457C5.65562 10.6268 5.7 10.5675 5.7 10.5C5.7 7.46243 8.11766 5 11.1 5C14.0823 5 16.5 7.46243 16.5 10.5C16.5 10.5582 16.5536 10.6014 16.6094 10.5887C16.8638 10.5306 17.1284 10.5 17.4 10.5C19.3882 10.5 21 12.1416 21 14.1667C21 16.1917 19.3882 17.8333 17.4 17.8333"
        stroke="#464455"
        strokeLinecap="round"
        strokeLinejoin="round"
      />
    </svg>
  ),
  globeColored: (
    <svg
      xmlns="http://www.w3.org/2000/svg"
      width="100%"
      height="100%"
      className="pointer-events-none"
      viewBox="0 0 1024 1024">
      <path
        d="M800.3741 715.205382l-26.369787 44.840142a25.935191 25.935191 0 0 0-3.579031 13.140156v14.520639a45.364215 45.364215 0 0 0 5.611409 21.84487l13.485277 24.529143 31.175914-66.467714 5.867054-64.588723a1.712822 1.712822 0 0 0-1.70004-1.866209 28.402165 28.402165 0 0 0-24.490796 14.047696zM183.962749 302.798783h-7.043021l-14.060478 16.335719 10.570923 31.482688 0.677459 2.096289a12.386003 12.386003 0 0 0 17.153783 7.362578 19.927532 19.927532 0 0 0 11.043866-21.090717l-3.195563-20.068137zM169.352634 731.247109h24.452449a16.616928 16.616928 0 0 1 15.965034 11.900277l3.553466 11.887495A20.643338 20.643338 0 0 0 229.454786 769.491609c7.413707 1.278225 15.696606 2.735402 17.42221 2.735402s12.501043 7.963343 21.72983 15.134187a17.217694 17.217694 0 0 1 2.466975 24.938175l-2.083508 2.403064q-0.268427 0.306774-0.562419 0.600765l-22.113297 22.35616L193.012584 801.447241l-29.309706-61.226991a6.263304 6.263304 0 0 1 5.649756-8.973141zM315.862814 146.484615l-30.089423 37.375307a11.248382 11.248382 0 0 1-0.805282 0.894758L265.193964 204.516042a11.248382 11.248382 0 0 0-1.112056 1.278226l-18.930516 25.807368a11.248382 11.248382 0 0 0-2.070725 8.244553l3.834676 26.676561a11.248382 11.248382 0 0 1 0 3.323386l-0.102258 0.62633a11.248382 11.248382 0 0 0 18.010194 10.634834l72.526502-56.114089a11.248382 11.248382 0 0 0 4.37153-9.062617c-0.153387-10.507012-0.421814-32.28797 0.089476-34.320348s25.82015-21.576442 36.250468-29.527004a11.2356 11.2356 0 0 0 4.42266-8.947577v-15.006365a11.248382 11.248382 0 0 0-16.616929-9.880681l-46.565746 25.411118a11.248382 11.248382 0 0 0-3.438426 2.824878z"
        fill="#2FA65B"
      />
      <path
        d="M509.194385 93.374356a5.483586 5.483586 0 0 0-0.703024 4.831691c3.208345 9.791206 13.804833 44.520586 5.176812 50.553809-10.072415 7.043021-27.187851 21.359144-16.105638 31.214261s-45.300303-27.622448-60.408926 9.855117-34.21809 46.425142-33.233857 64.537594 15.09584 0 21.141846 0 6.966328 32.262406-17.115436 42.33482-73.497953-23.161442-66.467714 14.060478 26.178053 56.587032 6.046006 64.435336-20.132048 58.38933 2.019596 51.346309 34.307566-3.016612 34.307566-13.089027 11.00552-58.38933 24.081764-51.346309 29.194665 1.278225 32.211276 11.069431-18.125234 23.161442 3.016612 25.168255c14.418381 1.367701 19.467371-18.32975 21.231322-30.996962a5.483586 5.483586 0 0 1 8.947576-3.425644c9.100964 7.669352 25.359989 7.669352 26.676562 7.4904 10.826568-1.546653 31.712769-29.399181 32.722566-32.466922 0.383468-1.150403 2.671491-6.109917 5.355764-11.798019 6.135481-13.012333 12.015317-20.886201 25.564506-25.564505l9.714512-1.81508a15.172534 15.172534 0 0 0 2.876006-0.140605 5.496369 5.496369 0 0 1 2.901572 0.447379l28.721721 15.236445a5.496369 5.496369 0 0 1 1.086492 9.369391c-9.484431 7.26032-25.564505 19.556847-31.840591 24.375756-9.177657 7.043021-26.293094 0.217298-29.309706 17.115436s-2.019596 19.173379 9.062617 26.178054c7.988908 5.112901 25.423901-1.994031 34.512083-6.391127a5.483586 5.483586 0 0 1 7.669351 3.425644l6.570078 22.458418a5.496369 5.496369 0 0 1-4.077539 6.902417l-37.822685 8.449069-43.843127 8.321246a68.257229 68.257229 0 0 1-32.224059-1.648911l-21.934345-6.544513a5.496369 5.496369 0 0 0-0.830847-0.178951l-27.699141-3.834676a82.995166 82.995166 0 0 0-52.931308 10.455882l-37.324178 21.72983a5.509151 5.509151 0 0 0-0.805282 0.562419l-1.431612 1.278225a198.124916 198.124916 0 0 0-56.587033 79.697345l-0.306774 0.805282a71.209929 71.209929 0 0 0-1.955684 45.786029l7.388142 25.181038a99.062458 99.062458 0 0 0 29.143536 46.01611l0.715806 0.639112a100.979796 100.979796 0 0 0 56.996064 25.065998l25.845715 2.55645a36.173775 36.173775 0 0 0 31.508253-12.93564 5.496369 5.496369 0 0 1 4.333184-1.994031l14.201082 0.268427a46.75748 46.75748 0 0 1 44.367199 35.061719l6.889634 26.702126a5.496369 5.496369 0 0 0 1.278226 2.364717l21.44862 23.174224a32.224059 32.224059 0 0 1 7.004674 31.840591l-1.393266 4.665522a40.583652 40.583652 0 0 0 10.302496 41.619015L600.613056 887.088333a5.496369 5.496369 0 0 0 1.482741 1.022581l37.899379 17.895153a5.496369 5.496369 0 0 0 3.476773 0.409032l35.176759-7.375359a5.496369 5.496369 0 0 0 4.115886-3.745201l23.340393-75.082952 17.294388-48.649253a172.113032 172.113032 0 0 0 9.177657-73.868638l-1.201532-12.782253a116.535797 116.535797 0 0 1 5.04899-46.540182L754.153475 583.139148a5.496369 5.496369 0 0 1 0.383467-0.894758l28.721722-54.068929a5.496369 5.496369 0 0 0-5.803143-7.988908L740.617069 526.628809a42.462643 42.462643 0 0 1-18.764347-0.933105L674.750121 512.568331a5.496369 5.496369 0 0 1-3.131652-2.313588L641.771909 463.995771l-0.217298-0.357903a5.496369 5.496369 0 0 1 8.385158-6.800159l37.96329 32.364664a5.496369 5.496369 0 0 0 2.121854 1.124838l37.196355 10.085198a5.496369 5.496369 0 0 0 5.112901-1.278226L759.266376 474.860686a5.496369 5.496369 0 0 0 1.469959-2.185766l16.847009-45.84994a5.496369 5.496369 0 0 0-0.230081-4.320401l-5.534715-11.286729a5.496369 5.496369 0 0 0-4.320402-3.042176L718.056393 402.640958a5.496369 5.496369 0 0 1-3.400079-1.700039l-10.813786-11.504028a5.496369 5.496369 0 0 1 2.313588-8.947577l12.322092-3.988062a5.496369 5.496369 0 0 1 1.188749-0.242863l72.718235-6.697901a5.496369 5.496369 0 0 1 5.023426 2.339153L821.899414 407.280916a5.496369 5.496369 0 0 0 2.198547 1.853427L867.711007 429.483689a5.406893 5.406893 0 0 1 0.651895 0.357903c3.272257 2.109072 31.073656 20.170395 31.073656 23.953941V425.265545a5.44524 5.44524 0 0 0-0.153387-1.278225l-11.2356-46.016109a122.581803 122.581803 0 0 1-3.400079-23.902813L883.254226 320.834541a5.496369 5.496369 0 0 0-1.13762-3.118869L752.325613 149.130542a5.496369 5.496369 0 0 0-2.697056-1.891774L525.594015 76.489a5.496369 5.496369 0 0 0-6.173828 2.109071z"
        fill="#178E3B"
      />
      <path
        d="M511.993698 965.558582a453.233114 453.233114 0 0 1-176.395086-870.637574 453.233114 453.233114 0 0 1 352.790173 835.013436 450.318761 450.318761 0 0 1-176.395087 35.624138z m0-852.576251c-220.250995 0-399.445395 179.1944-399.445395 399.445395s179.1944 399.445395 399.445395 399.445395 399.445395-179.1944 399.445395-399.445395-179.181618-399.445395-399.445395-399.445395z"
        fill="#203529"
      />
      <path
        d="M642.359893 920.002634a19.019992 19.019992 0 0 1-8.11673-1.81508l-37.899379-17.895154a18.866605 18.866605 0 0 1-5.112902-3.540684l-54.733605-53.238082A53.685461 53.685461 0 0 1 522.794702 788.077004l1.469959-4.512135a18.828258 18.828258 0 0 0-4.090321-18.585395l-21.44862-23.174224a18.968863 18.968863 0 0 1-4.435442-8.103948l-6.889634-26.702126a33.438373 33.438373 0 0 0-31.636075-24.989304l-10.583705-0.204516a49.505664 49.505664 0 0 1-40.558088 14.827413l-25.845715-2.556451a113.65979 113.65979 0 0 1-64.57594-28.402165l-0.715806-0.639113a112.381565 112.381565 0 0 1-33.093252-52.304977l-7.388142-25.181038a84.107222 84.107222 0 0 1 2.313587-54.52909l0.306775-0.805282a212.1087 212.1087 0 0 1 60.43449-85.104238l1.431612-1.278225a18.956081 18.956081 0 0 1 2.748185-1.942903l5.598626-3.246692c-10.622052 0.140605-19.735798-6.672336-23.928377-18.534266-6.391126-17.895154-1.278225-50.809454 20.783943-59.41191l0.332339-0.140605c-0.447379-3.23391-2.812096-9.778423-4.614394-14.75072a215.866683 215.866683 0 0 1-10.085197-34.512082c-2.249676-11.913059-0.242863-21.065152 5.982094-27.200633 10.225802-10.110762 25.98632-6.915199 41.184418-3.834676 9.637818 1.968467 21.627571 4.409877 27.277328 2.04516a18.917734 18.917734 0 0 0 9.497213-8.845319 16.847009 16.847009 0 0 1-11.35064-1.380483c-6.391126-3.182781-9.867899-9.573907-10.391971-18.994427-0.7925-14.201083 6.391126-24.28628 13.958219-34.882768 6.058788-8.500198 13.613099-19.083903 20.221524-35.483533 6.902416-17.115436 21.461402-26.139707 41.005467-25.411118a79.249966 79.249966 0 0 1 17.166565 2.735402c3.310603-7.439271 10.149109-14.916889 20.681685-22.63737 0.319556-5.112901-1.70004-18.406444-7.822739-37.068532a19.019992 19.019992 0 0 1 2.415846-16.616929l10.225802-14.776284a18.828258 18.828258 0 0 1 21.244104-7.273102l224.034542 70.749769a18.828258 18.828258 0 0 1 9.292697 6.493384l129.778212 168.649041a18.815476 18.815476 0 0 1 3.911369 10.72431l1.41883 33.233857a109.4033 109.4033 0 0 0 3.016611 21.244104l11.235601 46.01611a18.892169 18.892169 0 0 1 0.536854 4.48657v28.887891a13.421365 13.421365 0 0 1-25.628416 5.573062c-3.706853-3.374515-14.277776-10.928826-25.679546-18.304185l-43.114538-20.119266a18.943298 18.943298 0 0 1-7.554311-6.391126l-21.870435-31.597729L722.197843 389.475238l0.191734 0.204516 46.591311 5.112901a18.828258 18.828258 0 0 1 14.891324 10.468665l5.534715 11.286729a19.00721 19.00721 0 0 1 0.779718 14.852978l-16.847009 45.84994a18.981645 18.981645 0 0 1-5.112901 7.503182L741.371222 509.193816a18.866605 18.866605 0 0 1-9.561125 4.627176 29.105189 29.105189 0 0 0 6.506167-0.39625l36.825669-6.455038A18.917734 18.917734 0 0 1 795.056683 534.46433l-28.389383 53.442598-17.511686 54.631348a102.539231 102.539231 0 0 0-4.461006 41.184418l1.201531 12.782252a186.787058 186.787058 0 0 1-9.893463 79.620652L718.836111 824.455295l-23.2637 74.827307a18.930516 18.930516 0 0 1-14.175518 12.897293l-35.17676 7.37536a18.815476 18.815476 0 0 1-3.86024 0.447379z m-33.336115-43.459659l34.294784 16.246243 28.005916-5.867054 21.95991-70.634728 0.166169-0.51129L710.693816 767.126892a159.778158 159.778158 0 0 0 8.461851-68.103842l-1.201532-12.782252a129.241356 129.241356 0 0 1 5.624191-51.908728L741.371222 579.036045a18.968863 18.968863 0 0 1 1.278225-3.093305l21.116282-39.740024-20.835072 3.655724a56.241912 56.241912 0 0 1-24.695312-1.278225l-47.115384-13.16572a18.892169 18.892169 0 0 1-10.801003-7.950561l-29.84656-46.195061c-0.255645-0.39625-0.498508-0.805282-0.728588-1.278226a18.917734 18.917734 0 0 1 28.887891-23.429869l36.608371 31.214261 31.303737 8.487416 22.305031-20.157612 15.006364-40.839298-2.134636-4.345966-45.172481-5.010643a18.930516 18.930516 0 0 1-11.721325-5.867054l-10.813786-11.504027a18.917734 18.917734 0 0 1 7.988908-30.933051l12.322091-3.988063a18.930516 18.930516 0 0 1 4.077539-0.843629l72.718235-6.6979a18.943298 18.943298 0 0 1 17.30717 8.218988l23.289265 33.642889 41.670143 19.441806a18.956081 18.956081 0 0 1 2.262459 1.278226c1.060927 0.677459 5.189595 3.361732 10.149109 6.736247l-10.788222-44.137118a136.335507 136.335507 0 0 1-3.757982-26.472046l-1.278225-30.7541-126.7616-164.750454-216.020069-68.231664-4.665522 6.749029c13.919873 44.367199 6.800158 56.446428-1.086492 61.955579s-11.580721 9.612254-13.152938 11.887494c6.97911 7.669352 3.527902 14.840195 2.21133 16.974832-0.945887 1.559435-6.237739 9.113746-17.064307 5.509151-1.124838-0.370685-2.377499-0.869193-3.962499-1.482741-29.552568-11.504027-36.582807-5.752014-39.791152 2.185765-7.797174 19.35233-16.731969 31.878938-23.2637 41.031031-1.41883 1.994031-2.658709 3.7452-3.732418 5.317417a16.962049 16.962049 0 0 1 2.466975-0.178952c6.391126 0 14.060478 4.090321 16.335719 15.556002 3.131652 15.619913-3.566248 42.258127-28.274343 52.586187-13.267978 5.547498-29.05406 2.32637-42.986716-0.51129a124.575834 124.575834 0 0 0-15.786082-2.556451c0.063911 0.62633 0.178952 1.380483 0.345121 2.288024a190.596169 190.596169 0 0 0 8.947577 30.408979c3.489555 9.650601 6.237739 17.281606 6.276086 24.848699 0 6.46782-2.224112 18.21471-17.498904 24.17124-1.278225 0.485726-3.757982 3.438426-5.253506 9.30548-1.751169 6.889634-1.073709 13.191285 0 16.220678a148.031268 148.031268 0 0 1 20.720032-4.499353l2.978265-0.485725c1.776733-14.060478 9.049835-48.201875 24.51636-57.430661a18.764347 18.764347 0 0 1 18.904952-0.511291c3.34895 1.802298 7.797174 2.236894 12.501043 2.709838 7.26032 0.715806 18.853823 1.853427 24.40132 11.964188a18.904952 18.904952 0 0 1 30.843576-11.273946c3.655724 3.093305 11.887495 4.269272 15.88834 4.37153 5.534715-2.927136 19.032774-18.674871 22.535111-24.490796 0.549637-1.380483 1.840644-4.307619 5.521934-12.130358 7.298666-15.49209 15.415397-26.344223 33.336114-32.56918a13.459712 13.459712 0 0 1 1.942903-0.51129l9.714512-1.81508a13.408583 13.408583 0 0 1 3.157216-0.204516l0.613548-0.063911a18.904952 18.904952 0 0 1 9.970157 1.53387l0.7925 0.383468 28.440512 15.09584a18.917734 18.917734 0 0 1 3.23391 32.032326c-9.471649 7.247537-25.564505 19.544064-31.815027 24.362973-6.07157 4.665522-12.871728 5.752014-18.316968 6.621207a36.493331 36.493331 0 0 0-5.700884 1.188749 7.298666 7.298666 0 0 0-0.242863 1.009798 68.346705 68.346705 0 0 0-1.278225 9.522779 44.622844 44.622844 0 0 0 3.834675 2.55645c1.955685 0.217298 9.088182-0.562419 22.074951-6.774594a18.904952 18.904952 0 0 1 26.293093 11.772455l6.570078 22.458418a18.917734 18.917734 0 0 1-14.060478 23.762207l-37.822685 8.449069-0.421815 0.089476-43.843126 8.321247a82.023715 82.023715 0 0 1-38.564056-1.981249l-21.359145-6.391127-27.085593-3.706853a69.90614 69.90614 0 0 0-44.367199 8.768625l-36.838452 21.384709-0.894758 0.754153a185.189276 185.189276 0 0 0-52.752356 74.290452l-0.306774 0.805282a57.520137 57.520137 0 0 0-1.610564 37.183573l7.388142 25.181038a85.564399 85.564399 0 0 0 25.19382 39.829499l0.715806 0.639113a86.919318 86.919318 0 0 0 49.416189 21.729829l25.845714 2.556451a22.714063 22.714063 0 0 0 19.825274-8.129513 18.815476 18.815476 0 0 1 14.942454-6.851287l14.201082 0.268427a60.357797 60.357797 0 0 1 57.111105 45.121352l6.391126 24.759223 20.093702 21.72983a45.683771 45.683771 0 0 1 9.919028 45.108569L548.359207 796.33434a26.983335 26.983335 0 0 0 6.889634 27.852528zM449.13058 411.588535l17.626726 2.415846a18.994427 18.994427 0 0 1 2.83766 0.613548l21.934346 6.544513a55.065944 55.065944 0 0 0 25.884061 1.278226l43.638611-8.295682 29.399181-6.557296-1.661693-5.67532c-17.243259 6.902416-30.051076 7.4904-38.98587 1.802297-17.038743-10.852132-18.713218-19.467371-15.070276-39.855063a33.233857 33.233857 0 0 1 1.981249-6.915199c-3.285039 4.154232-6.263304 7.515965-6.518949 7.797174-14.610115 16.450759-23.071966 19.326766-28.120956 20.055355A61.661587 61.661587 0 0 1 475.500367 380.655484c-5.803143 22.790756-17.562815 29.360834-26.369787 30.933051z m-41.567886-34.908332c-4.76778 8.819754-10.225802 30.677406-10.225802 36.915146v0.102258a97.068427 97.068427 0 0 1 34.333131-4.218144 18.470355 18.470355 0 0 1-9.394956-8.346811c-4.358748-8.270117-0.600766-16.143985 2.198548-21.256886h-0.242863a69.561019 69.561019 0 0 1-16.668058-3.246692z m153.923887-9.356609z m-217.374989-5.176812z m201.346044-18.559831a23.37874 23.37874 0 0 1-1.968467 3.834676c6.391126-5.470804 14.46951-6.774594 19.339548-7.554312 2.134636-0.345121 5.368546-0.856411 6.237739-1.41883l22.011039-16.859791-15.760517-8.423504h-0.703024l-7.337013 1.367701c-7.912214 2.939918-11.670197 7.068586-16.987614 18.342532-3.86024 8.308464-4.691087 10.276931-4.831691 10.660399z m0.089476-0.242863l-0.076694 0.217298z m-24.810353-10.034068z m53.685461-46.821392zM520.238251 100.979796zM259.352475 296.944511A24.733659 24.733659 0 0 1 234.951155 268.427305v-0.306774l-3.770765-26.357005a24.541925 24.541925 0 0 1 4.576047-18.074105l18.930516-25.807368a24.759223 24.759223 0 0 1 2.454192-2.850442l19.684669-19.684669L306.838543 138.048329a24.554707 24.554707 0 0 1 7.400925-6.186611l46.565746-25.411118a24.669748 24.669748 0 0 1 36.493331 21.653136V143.16123a24.810352 24.810352 0 0 1-9.714512 19.620757c-17.652291 13.44693-27.021682 21.026806-31.239825 24.644183 0 4.780562 0 13.830397 0.178951 28.325472a24.784788 24.784788 0 0 1-9.573907 19.876403l-72.526501 56.114089a24.605836 24.605836 0 0 1-15.070276 5.202377z m-1.41883-58.082556l3.681289 25.807368a24.68253 24.68253 0 0 1 0.242862 2.876007l67.822633-52.407236c-0.472943-32.748131 0-34.665469 0.51129-36.685065 1.278225-5.112901 1.725604-6.889634 40.276878-36.288815v-10.379189l-42.986716 23.455433-29.820995 37.068533a24.861481 24.861481 0 0 1-1.776733 1.968467l-19.646322 19.646322z m69.816664-83.966617zM246.378488 851.055163a13.383019 13.383019 0 0 1-7.541529-2.313588l-53.353122-36.237686a13.421365 13.421365 0 0 1-4.563264-5.304635l-29.322488-61.175861a19.684669 19.684669 0 0 1 17.754549-28.184867h24.452449a30.268374 30.268374 0 0 1 28.82398 21.486967l3.553466 11.887495a7.183626 7.183626 0 0 0 5.636974 5.04899c11.504027 2.057943 14.699591 2.454193 15.440961 2.55645 4.93395 0.076694 8.730279 1.802298 29.616479 17.895154a30.677406 30.677406 0 0 1 4.333184 44.367199l-2.083507 2.403063c-0.370685 0.421814-0.754153 0.830846-1.150403 1.278225l-22.113297 22.35616a13.408583 13.408583 0 0 1-9.484432 3.936934z m-42.820546-58.734451l41.133289 27.929222 14.264994-14.418381 2.070725-2.377499a3.834676 3.834676 0 0 0-0.549637-5.509151c-10.519794-8.129513-15.249227-11.376205-17.204912-12.628865-2.556451-0.332339-7.26032-1.060927-16.182332-2.658709a33.898534 33.898534 0 0 1-26.638214-23.787772l-3.553467-11.887495a3.259474 3.259474 0 0 0-3.106087-2.313588h-13.063462z m43.319054-6.710682z m0-26.842731z"
        fill="#203529"
      />
      <path
        d="M789.637008 839.793999a13.421365 13.421365 0 0 1-11.759672-6.953546L764.379277 808.324093a58.938967 58.938967 0 0 1-7.273102-28.31269v-14.520639a39.38212 39.38212 0 0 1 5.432457-19.953096l26.369788-44.840143A41.9897 41.9897 0 0 1 824.979937 680.015841a15.134187 15.134187 0 0 1 15.070275 16.616928l-5.867054 64.57594a13.421365 13.421365 0 0 1-1.278225 4.486571l-31.175914 66.467714a13.421365 13.421365 0 0 1-11.721326 7.669351z m21.729829-124.332972l-25.679545 43.676957a12.526608 12.526608 0 0 0-1.725604 6.391127v14.520639a32.032325 32.032325 0 0 0 3.949716 15.338703l0.779717 1.406048 18.968863-40.430265zM185.854522 374.711736a25.807368 25.807368 0 0 1-24.554707-17.895154l-0.651895-2.019595-10.545358-31.405995a13.421365 13.421365 0 0 1 2.55645-13.037898l14.060478-16.335719a13.421365 13.421365 0 0 1 10.161891-4.65274h7.043021a13.421365 13.421365 0 0 1 9.791206 4.243708l15.09584 16.105638a13.421365 13.421365 0 0 1 3.46399 7.068586l3.195564 20.068137a33.553413 33.553413 0 0 1-18.483138 35.304582 25.794586 25.794586 0 0 1-11.133342 2.55645zM177.980655 322.112767l8.142295 24.28628v0.153387l0.281209 0.856411a6.557296 6.557296 0 0 0 2.556451-6.263304l-2.556451-16.003381-5.752014-6.135481z"
        fill="#203529"
      />
      <path
        d="M511.993698 1023.999041A511.584097 511.584097 0 0 1 0.000569 511.99313a13.421365 13.421365 0 0 1 26.84273 0C26.843299 779.512895 244.486715 997.143529 511.993698 997.143529s485.163181-217.630633 485.163182-485.150399S779.513464 26.842731 511.993698 26.842731a13.421365 13.421365 0 0 1 0-26.842731 512.133734 512.133734 0 0 1 199.300884 983.76051 508.797566 508.797566 0 0 1-199.300884 40.238531z"
        fill="#203529"
      />
    </svg>
  ),
  energySaving: (
    <svg
      xmlns="http://www.w3.org/2000/svg"
      width="100%"
      height="100%"
      className="pointer-events-none"
      viewBox="0 0 1024 1024">
      <path
        d="M433.662833 721.064256l308.434483-152.439036 64.873762 131.26128-308.435623 152.437895z"
        fill="#178E3B"
      />
      <path
        d="M448.410548 727.854497l293.996815-145.302272 12.165896 24.616762-293.996814 145.302272z"
        fill="#2FA65B"
      />
      <path
        d="M542.730727 866.377926a122.924226 122.924226 0 0 1-110.009432-68.392559l-31.996319-64.744956a23.937396 23.937396 0 0 1 10.863019-32.019117l328.124701-162.147359a23.937396 23.937396 0 0 1 32.064711 10.85162l31.996319 64.744956A122.719049 122.719049 0 0 1 748.136379 778.881045l-10.600846-21.463865 10.600846 21.463865-151.261543 74.741669a122.092117 122.092117 0 0 1-54.144109 12.755212z m-88.477174-132.829749l21.395472 43.315288a74.707472 74.707472 0 0 0 100.069713 33.877114l151.261543-74.741668a74.787263 74.787263 0 0 0 33.877114-100.069713l-21.395472-43.315288z"
        fill="#203529"
      />
      <path
        d="M647.086373 1023.999977a58.646619 58.646619 0 0 1-52.605277-32.623251L528.812841 858.52418a23.937396 23.937396 0 0 1 10.851619-32.064711l221.694481-109.599076a23.937396 23.937396 0 0 1 32.064711 10.851619l65.668256 132.898141A58.578227 58.578227 0 0 1 832.487202 939.079216l-10.600846-21.463865 10.600846 21.463865-159.582638 78.856621a58.224865 58.224865 0 0 1-25.818191 6.06414z m-64.756355-165.282018l55.067409 111.434277a10.714834 10.714834 0 0 0 14.328241 4.855871l159.582638-78.85662a10.703436 10.703436 0 0 0 4.855872-14.328241l-55.067409-111.434277z"
        fill="#203529"
      />
      <path
        d="M575.559155 902.888154a11.968698 11.968698 0 0 1-5.311822-22.70633L778.913031 777.068642a11.968698 11.968698 0 1 1 10.600847 21.463865l-208.6543 103.113182a11.923103 11.923103 0 0 1-5.300423 1.242465zM458.243119 773.033481a11.968698 11.968698 0 0 1-5.33462-22.660734l299.297238-147.88751a11.968698 11.968698 0 0 1 10.600846 21.463864L463.532143 771.836612a11.923103 11.923103 0 0 1-5.289024 1.196869zM594.013747 940.230491a11.968698 11.968698 0 0 1-5.311822-22.70633L797.379022 814.41098a11.968698 11.968698 0 0 1 10.600846 21.463865l-208.665697 103.113181a11.923103 11.923103 0 0 1-5.300424 1.242465zM612.491137 977.572828a11.968698 11.968698 0 0 1-5.311822-22.706329l208.665698-103.113182a11.968698 11.968698 0 0 1 10.600846 21.463865l-208.677096 103.113181a11.923103 11.923103 0 0 1-5.277626 1.242465zM511.042174 703.501046a23.937396 23.937396 0 0 1-21.475263-13.336549l-198.338422-401.430125a108.18563 108.18563 0 0 1 193.984095-95.863571l198.338422 401.430126a23.937396 23.937396 0 0 1-10.851619 32.064711l-151.044967 74.684675A23.846206 23.846206 0 0 1 511.042174 703.501046zM388.106549 180.525944a60.29944 60.29944 0 0 0-53.973128 87.029532l187.771771 379.966261L630.045227 594.072952 442.273456 214.11809a60.413427 60.413427 0 0 0-54.166907-33.592146z"
        fill="#203529"
      />
      <path
        d="M422.508006 747.283683a23.937396 23.937396 0 0 1-21.463864-13.336549L224.30637 376.276847a110.191812 110.191812 0 0 1 49.972163-147.602541l7.751157-3.829983a110.317198 110.317198 0 0 1 147.602541 49.972163L606.370003 632.486772a23.937396 23.937396 0 0 1-10.851619 32.064712l-162.398132 80.247269a23.937396 23.937396 0 0 1-10.612246 2.48493z m-91.771415-485.963329a61.929462 61.929462 0 0 0-27.505208 6.440299l-7.751156 3.829984a62.31702 62.31702 0 0 0-28.257526 83.473118l166.136925 336.263416 119.481801-59.045576-166.136925-336.263416a62.396811 62.396811 0 0 0-55.967911-34.697825z"
        fill="#203529"
      />
      <path
        d="M584.928936 667.025015A23.937396 23.937396 0 0 1 563.47647 653.688466L386.704502 296.018179A110.191812 110.191812 0 0 1 436.676665 148.381441l11.39876-5.69938a110.191812 110.191812 0 0 1 147.602541 49.972164l176.794766 357.750078a23.937396 23.937396 0 0 1-10.85162 32.064711l-166.09133 82.071071a23.846206 23.846206 0 0 1-10.600846 2.48493z m-88.044021-487.866922a62.054849 62.054849 0 0 0-27.550803 6.485894l-11.39876 5.69938a62.31702 62.31702 0 0 0-28.257526 83.473119l166.136925 336.263415 123.174999-60.869377-166.136925-336.263416a62.488002 62.488002 0 0 0-55.96791-34.789015z"
        fill="#203529"
      />
      <path
        d="M703.818001 732.864252a11.968698 11.968698 0 0 1-5.266227-22.729127c1.504636-0.740919 35.723713-18.010041 26.160154-45.526647a11.968698 11.968698 0 0 1 22.615139-7.865145c13.256758 38.128852-19.252505 65.679654-38.288434 74.91265a11.923103 11.923103 0 0 1-5.220632 1.208269z"
        fill="#2FA65B"
      />
      <path
        d="M179.623231 296.690706a11.934502 11.934502 0 0 1-4.559503-0.900502L93.300423 262.220856a11.968698 11.968698 0 1 1 9.119008-22.14779l81.751906 33.580746a11.968698 11.968698 0 0 1-4.559504 23.048293zM575.1488 109.363486h-0.900502a11.968698 11.968698 0 0 1-11.045399-12.823604l6.314913-85.262724a11.968698 11.968698 0 1 1 23.869003 1.766808L587.071903 98.226898a11.968698 11.968698 0 0 1-11.923103 11.136588zM252.780472 203.44885a11.934502 11.934502 0 0 1-8.697254-3.772989l-56.378266-59.672508a11.968698 11.968698 0 0 1 17.405907-16.437012l56.378266 59.695306a11.968698 11.968698 0 0 1-8.697254 20.187203zM443.071369 109.409081a11.968698 11.968698 0 0 1-11.923103-11.045398l-5.97295-77.146807a11.968698 11.968698 0 0 1 23.869003-1.846599l5.972951 77.146807a11.968698 11.968698 0 0 1-11.011202 12.857801q-0.467349 0.034196-0.934699 0.034196zM223.645242 731.997946q-12.379053 0-23.470046-0.968895c-43.132907-3.77299-71.162458-18.135427-83.290739-42.688355-12.265066-24.735309-6.406103-56.104696 17.394508-93.127868 21.121902-32.828428 56.583444-69.874398 102.66863-107.148343a11.968698 11.968698 0 0 1 15.057762 18.614175C164.645261 577.339572 121.101998 642.905239 138.302727 677.796843c17.00695 34.412856 94.142358 39.98685 201.313498 14.544817a11.968698 11.968698 0 0 1 5.528398 23.287667C299.469793 726.480946 257.989705 731.997946 223.645242 731.997946zM802.690844 489.911084a11.968698 11.968698 0 0 1-7.511783-21.292883c44.591949-35.894695 78.719836-71.219452 98.713261-102.132889 13.199764-20.426578 26.764288-49.17425 16.391416-70.147968-18.420396-37.273945-107.615692-40.385806-227.257075-7.979132a11.968698 11.968698 0 0 1-6.269318-23.105286c63.114933-17.09814 119.253826-25.077272 162.363935-22.88871 48.444729 2.405138 79.608939 16.984152 92.614924 43.315288 12.322059 24.929088 6.349109 56.480855-17.747869 93.7548-21.349877 33.056404-57.244572 70.296152-103.797107 107.775274a11.923103 11.923103 0 0 1-7.500384 2.701506z"
        fill="#203529"
      />
    </svg>
  ),
  engine: (
    <svg
      xmlns="http://www.w3.org/2000/svg"
      width="100%"
      height="100%"
      className="pointer-events-none"
      viewBox="0 0 73.27 79.11">
      <g>
        <g>
          <path
            d="m28.49,79.11h-3.73c-.32,0-.59-.24-.64-.55l-1.01-6.72c-1.06-.19-2.11-.47-3.12-.83l-4.23,5.31c-.2.25-.55.32-.83.16l-3.23-1.86c-.28-.16-.4-.5-.28-.8l2.49-6.33c-.82-.7-1.59-1.46-2.28-2.28l-6.33,2.48c-.3.12-.64,0-.8-.28l-1.87-3.23c-.16-.28-.09-.63.16-.83l5.31-4.23c-.36-1-.64-2.05-.84-3.12l-6.72-1.01c-.32-.05-.55-.32-.55-.64v-3.74c0-.32.24-.6.55-.64l6.72-1c.19-1.07.47-2.11.84-3.12l-5.32-4.23c-.25-.2-.32-.56-.16-.83l1.87-3.23c.16-.28.5-.4.8-.28l6.33,2.49c.7-.83,1.46-1.59,2.28-2.28l-2.49-6.33c-.12-.3,0-.64.28-.8l3.23-1.87c.28-.16.63-.09.83.16l4.23,5.32c1.01-.36,2.05-.64,3.12-.84l1.01-6.72c.05-.32.32-.55.64-.55h3.73c.32,0,.59.24.64.55l1.01,6.72c1.07.19,2.11.47,3.12.84l4.23-5.31c.2-.25.56-.32.83-.16l3.23,1.87c.28.16.4.5.28.8l-2.48,6.33c.83.7,1.6,1.47,2.28,2.28l6.32-2.49c.3-.12.64,0,.8.28l1.86,3.23c.16.28.09.63-.16.83l-5.31,4.24c.37,1.03.65,2.08.84,3.12l6.71,1.01c.32.05.55.32.55.64v3.73c0,.32-.24.59-.55.64l-6.71,1.01c-.19,1.05-.47,2.09-.84,3.12l5.31,4.23c.25.2.32.55.16.83l-1.86,3.23c-.16.28-.5.4-.8.28l-6.33-2.48c-.68.8-1.45,1.57-2.28,2.28l2.48,6.33c.12.3,0,.64-.28.8l-3.23,1.86c-.28.16-.63.09-.83-.16l-4.23-5.31c-1.01.36-2.06.64-3.12.83l-1.01,6.72c-.05.32-.32.55-.64.55Zm-3.17-1.3h2.61l1-6.63c.04-.28.26-.5.55-.55,1.29-.19,2.55-.53,3.77-1,.27-.1.57-.02.74.2l4.17,5.24,2.26-1.3-2.45-6.24c-.1-.26-.02-.56.2-.74,1.04-.84,1.97-1.77,2.76-2.76.18-.22.48-.3.74-.2l6.24,2.45,1.3-2.26-5.24-4.17c-.22-.18-.3-.48-.2-.74.47-1.24.81-2.51,1.01-3.78.04-.28.26-.5.54-.54l6.62-1v-2.61l-6.62-1c-.28-.04-.5-.26-.55-.54-.2-1.26-.54-2.53-1.01-3.78-.1-.26-.02-.56.2-.74l5.24-4.18-1.3-2.26-6.24,2.46c-.27.11-.57.02-.75-.2-.8-1-1.73-1.93-2.76-2.76-.22-.18-.3-.48-.2-.74l2.45-6.25-2.26-1.3-4.17,5.25c-.18.22-.48.31-.74.2-1.21-.47-2.48-.81-3.77-1.01-.28-.04-.5-.26-.54-.55l-1-6.63h-2.61l-1,6.63c-.04.28-.26.5-.54.55-1.3.2-2.57.55-3.77,1.01-.26.11-.57.02-.74-.2l-4.18-5.25-2.26,1.31,2.46,6.25c.1.27.02.57-.2.75-1.01.8-1.94,1.73-2.75,2.75-.18.22-.48.31-.75.2l-6.25-2.46-1.31,2.26,5.25,4.18c.22.18.3.48.2.74-.47,1.2-.81,2.47-1.01,3.77-.04.28-.26.5-.55.54l-6.63.99v2.62l6.63,1c.28.04.5.26.54.54.21,1.31.55,2.58,1.01,3.77.1.27.02.57-.2.74l-5.25,4.17,1.31,2.26,6.25-2.45c.26-.1.57-.02.74.2.81,1.01,1.74,1.94,2.76,2.76.22.18.3.48.2.74l-2.46,6.24,2.26,1.3,4.18-5.24c.18-.22.48-.3.74-.2,1.21.47,2.48.81,3.77,1,.28.04.5.26.55.55l1,6.63Zm1.3-15.14c-5.61,0-10.18-4.57-10.18-10.19s4.57-10.18,10.18-10.18,10.19,4.57,10.19,10.18-4.57,10.19-10.19,10.19Zm0-19.08c-4.9,0-8.88,3.99-8.88,8.88s3.98,8.89,8.88,8.89,8.89-3.99,8.89-8.89-3.99-8.88-8.89-8.88Z"
            style={{ strokeWidth: "0px" }}
          />
          <path
            d="m26.63,39.72c-.9,0-1.63-.73-1.63-1.63s.73-1.62,1.63-1.62,1.62.73,1.62,1.62-.73,1.63-1.62,1.63Zm0-1.95c-.17,0-.33.15-.33.32s.15.33.33.33.32-.14.32-.33-.15-.32-.32-.32Z"
            style={{ strokeWidth: "0px" }}
          />
          <path
            d="m33.82,41.65c-.28,0-.56-.08-.81-.22-.38-.22-.64-.57-.75-.99-.11-.42-.05-.86.17-1.23.43-.74,1.46-1.02,2.22-.59.37.21.64.55.76.98.12.42.06.86-.16,1.24-.29.5-.83.81-1.41.81Zm0-1.95c-.11,0-.22.06-.27.16-.04.08-.06.17-.03.25.01.05.05.14.15.2.15.09.36.03.45-.12.06-.1.04-.2.03-.24-.01-.05-.05-.13-.15-.19-.06-.04-.12-.05-.17-.05Z"
            style={{ strokeWidth: "0px" }}
          />
          <path
            d="m39.09,46.92c-.58,0-1.12-.32-1.41-.82-.21-.37-.27-.81-.16-1.23.11-.42.38-.77.75-.98.75-.43,1.79-.15,2.22.59.22.37.27.81.16,1.23-.11.42-.38.78-.76,1-.25.14-.53.22-.81.22Zm0-1.95c-.06,0-.11.02-.17.05-.1.06-.13.14-.15.19-.01.05-.03.15.03.25.11.2.31.2.44.12.08-.05.13-.12.16-.2.01-.05.03-.14-.03-.24-.06-.1-.16-.16-.28-.16Z"
            style={{ strokeWidth: "0px" }}
          />
          <path
            d="m41.02,54.11c-.9,0-1.63-.73-1.63-1.63s.73-1.62,1.63-1.62,1.62.73,1.62,1.62-.73,1.63-1.62,1.63Zm0-1.95c-.18,0-.33.14-.33.32s.15.33.33.33.32-.14.32-.33-.14-.32-.32-.32Z"
            style={{ strokeWidth: "0px" }}
          />
          <path
            d="m39.09,61.3c-.28,0-.57-.08-.81-.22-.77-.45-1.04-1.45-.59-2.22.42-.74,1.46-1.03,2.21-.59.37.21.64.56.76.98.12.42.06.86-.16,1.24-.29.5-.83.81-1.41.81Zm0-1.95c-.11,0-.21.06-.27.15-.09.16-.04.37.11.45.15.09.36.03.44-.12.06-.1.05-.2.03-.25-.01-.05-.05-.13-.15-.19-.06-.04-.12-.05-.17-.05Z"
            style={{ strokeWidth: "0px" }}
          />
          <path
            d="m33.83,66.57c-.58,0-1.12-.31-1.41-.82-.45-.77-.19-1.76.59-2.21.76-.44,1.79-.16,2.23.59.22.37.28.81.16,1.23-.11.42-.38.78-.76,1-.25.14-.52.22-.81.22Zm0-1.95c-.06,0-.11.02-.17.05-.15.09-.21.28-.12.44.09.15.29.21.44.13.08-.05.13-.12.16-.2.01-.05.03-.14-.03-.24-.06-.1-.16-.16-.28-.16Z"
            style={{ strokeWidth: "0px" }}
          />
          <path
            d="m26.63,68.5c-.9,0-1.63-.73-1.63-1.63s.73-1.62,1.63-1.62,1.62.73,1.62,1.62-.73,1.63-1.62,1.63Zm0-1.95c-.17,0-.33.15-.33.32s.15.33.33.33.32-.14.32-.33-.15-.32-.32-.32Z"
            style={{ strokeWidth: "0px" }}
          />
          <path
            d="m19.43,66.57c-.28,0-.57-.08-.81-.22-.38-.22-.64-.57-.75-.99-.11-.42-.05-.86.17-1.24.43-.75,1.47-1.03,2.21-.59.38.22.65.57.76.99.11.42.05.85-.16,1.22-.29.5-.83.81-1.41.81Zm0-1.95c-.11,0-.22.06-.28.16-.04.08-.06.17-.04.25.01.05.05.14.15.2.15.09.36.03.45-.12.05-.09.05-.18.03-.24-.02-.08-.08-.16-.16-.2-.05-.03-.11-.05-.16-.05Z"
            style={{ strokeWidth: "0px" }}
          />
          <path
            d="m14.17,61.3c-.58,0-1.12-.31-1.41-.82-.22-.38-.28-.82-.16-1.24.11-.42.38-.76.76-.98.73-.42,1.79-.15,2.21.59.45.78.18,1.77-.6,2.22-.25.14-.53.22-.81.22Zm0-1.95c-.06,0-.11.01-.16.04-.1.06-.14.14-.15.19-.01.05-.03.15.03.25.09.16.28.22.44.13.16-.09.21-.29.12-.45-.06-.1-.16-.16-.28-.16Z"
            style={{ strokeWidth: "0px" }}
          />
          <path
            d="m12.24,54.11c-.9,0-1.62-.73-1.62-1.63s.73-1.62,1.62-1.62,1.63.73,1.63,1.62-.73,1.63-1.63,1.63Zm0-1.95c-.18,0-.32.15-.32.32s.15.33.32.33.33-.14.33-.33-.14-.32-.33-.32Z"
            style={{ strokeWidth: "0px" }}
          />
          <path
            d="m14.16,46.92c-.28,0-.57-.08-.81-.22-.37-.22-.64-.57-.75-.99-.11-.42-.05-.86.17-1.24.43-.75,1.46-1.02,2.21-.59.37.21.64.56.76.98.12.42.06.86-.16,1.24-.29.5-.83.82-1.41.82Zm0-1.95c-.11,0-.22.06-.28.16-.04.08-.06.16-.03.25.01.05.05.14.15.2.16.09.36.03.44-.12.06-.1.04-.2.03-.25-.01-.05-.05-.13-.15-.19-.06-.03-.11-.05-.17-.05Z"
            style={{ strokeWidth: "0px" }}
          />
          <path
            d="m19.44,41.65c-.58,0-1.12-.31-1.41-.82-.22-.38-.28-.82-.16-1.24.11-.42.38-.76.76-.97.72-.42,1.78-.15,2.22.59.22.38.28.81.16,1.23-.11.42-.38.77-.76.99-.24.14-.52.22-.81.22Zm0-1.95c-.06,0-.12.01-.17.04-.1.06-.14.14-.15.19-.01.05-.03.15.03.25.09.16.29.21.44.13.08-.05.13-.12.16-.2.01-.05.03-.14-.03-.24-.06-.1-.16-.16-.28-.16Z"
            style={{ strokeWidth: "0px" }}
          />
          <path
            d="m56.87,35.25h-2.44c-.32,0-.59-.24-.64-.55l-.63-4.23c-.6-.12-1.19-.27-1.76-.47l-2.66,3.35c-.2.25-.56.32-.83.16l-2.12-1.22c-.28-.16-.4-.5-.28-.8l1.57-3.98c-.45-.39-.88-.82-1.29-1.29l-3.99,1.57c-.3.12-.64,0-.8-.28l-1.21-2.11c-.16-.28-.09-.63.16-.83l3.34-2.66c-.2-.57-.35-1.16-.47-1.77l-4.22-.64c-.32-.05-.55-.32-.55-.64v-2.43c0-.32.24-.59.55-.64l4.22-.64c.12-.61.28-1.2.47-1.77l-3.34-2.66c-.25-.2-.32-.55-.16-.83l1.21-2.11c.16-.28.5-.4.8-.28l3.99,1.56c.4-.47.84-.9,1.29-1.3l-1.57-3.98c-.12-.3,0-.64.28-.8l2.12-1.22c.28-.16.63-.09.83.16l2.66,3.34c.57-.2,1.16-.35,1.76-.47l.63-4.23c.05-.32.32-.55.64-.55h2.44c.32,0,.59.24.64.55l.63,4.23c.6.12,1.19.27,1.76.47l2.67-3.35c.2-.25.55-.32.83-.16l2.1,1.22c.28.16.4.5.28.8l-1.57,3.98c.45.4.88.83,1.29,1.3l3.98-1.56c.3-.12.64,0,.8.28l1.22,2.11c.16.28.09.63-.16.83l-3.34,2.66c.2.57.36,1.16.47,1.77l4.22.64c.32.05.55.32.55.64v2.43c0,.32-.24.59-.55.64l-4.22.64c-.12.61-.28,1.2-.47,1.77l3.34,2.66c.25.2.32.56.16.83l-1.22,2.1c-.16.28-.5.4-.8.28l-3.98-1.56c-.41.47-.84.9-1.29,1.29l1.57,3.98c.12.3,0,.64-.28.8l-2.1,1.22c-.28.16-.63.09-.83-.16l-2.67-3.35c-.58.2-1.17.35-1.76.47l-.63,4.23c-.05.32-.32.55-.64.55Zm-1.88-1.3h1.32l.62-4.14c.04-.28.26-.5.54-.54.82-.13,1.64-.35,2.42-.65.26-.1.56-.02.74.2l2.61,3.27,1.14-.66-1.53-3.89c-.1-.26-.03-.56.2-.74.63-.51,1.23-1.11,1.77-1.78.18-.22.48-.3.74-.19l3.89,1.52.66-1.14-3.27-2.61c-.22-.18-.3-.48-.2-.75.3-.75.52-1.57.65-2.42.04-.28.26-.5.54-.54l4.13-.62v-1.31l-4.13-.62c-.28-.04-.5-.26-.54-.54-.13-.85-.35-1.67-.65-2.42-.11-.27-.02-.57.2-.75l3.27-2.61-.66-1.14-3.9,1.53c-.26.1-.56.02-.74-.2-.54-.67-1.14-1.26-1.77-1.78-.22-.18-.3-.48-.2-.74l1.53-3.89-1.14-.66-2.61,3.27c-.18.22-.48.3-.74.2-.78-.3-1.59-.51-2.42-.65-.28-.04-.5-.26-.54-.54l-.62-4.14h-1.32l-.62,4.14c-.04.28-.26.5-.54.54-.83.13-1.65.35-2.42.65-.27.1-.56.02-.74-.2l-2.6-3.27-1.15.66,1.53,3.89c.1.26.03.56-.2.74-.64.51-1.23,1.11-1.77,1.78-.18.22-.48.3-.74.2l-3.9-1.53-.65,1.14,3.27,2.61c.22.18.3.48.2.75-.3.76-.51,1.57-.65,2.42-.04.28-.26.5-.54.54l-4.13.62v1.31l4.13.62c.28.04.5.26.54.54.13.85.35,1.66.65,2.42.1.27.02.57-.2.74l-3.27,2.61.66,1.14,3.9-1.53c.26-.1.56-.03.74.19.54.67,1.14,1.26,1.77,1.77.22.18.3.48.2.74l-1.53,3.89,1.15.66,2.6-3.27c.18-.22.48-.3.74-.2.78.3,1.6.52,2.42.65.28.04.5.26.54.54l.62,4.14Zm.66-9.44c-3.79,0-6.88-3.08-6.88-6.88s3.09-6.88,6.88-6.88,6.88,3.09,6.88,6.88-3.09,6.88-6.88,6.88Zm0-12.46c-3.08,0-5.58,2.5-5.58,5.58s2.5,5.58,5.58,5.58,5.58-2.5,5.58-5.58-2.5-5.58-5.58-5.58Z"
            style={{ strokeWidth: "0px" }}
          />
        </g>
      </g>
    </svg>
  ),
  financialReport: (
    <svg
      xmlns="http://www.w3.org/2000/svg"
      width="100%"
      height="100%"
      className="pointer-events-none"
      viewBox="0 0 1024 1024"
      fill="#000000">
      <path
        d="M272.016 512c-79.394 0-143.992-64.598-143.992-143.992 0-79.392 64.598-143.99 143.992-143.99 79.392 0 143.99 64.598 143.99 143.99 0 79.394-64.598 143.992-143.99 143.992z m0-271.984c-70.574 0-127.992 57.42-127.992 127.992 0 70.574 57.418 127.992 127.992 127.992s127.992-57.418 127.992-127.992c0-70.572-57.418-127.992-127.992-127.992z"
        fill=""
      />
      <path
        d="M272.016 543.998c-79.394 0-143.992-64.598-143.992-143.992 0-4.42 3.578-7.998 8-7.998s8 3.578 8 7.998c0 70.574 57.418 127.994 127.992 127.994s127.992-57.42 127.992-127.994a7.994 7.994 0 0 1 8-7.998 7.994 7.994 0 0 1 7.998 7.998c0 79.394-64.598 143.992-143.99 143.992z"
        fill=""
      />
      <path
        d="M136.024 408.006c-4.422 0-8-3.578-8-8v-31.998c0-4.42 3.578-7.998 8-7.998s8 3.578 8 7.998v31.998c0 4.422-3.578 8-8 8zM408.008 408.006c-4.422 0-8-3.578-8-8v-31.998a7.994 7.994 0 0 1 8-7.998 7.994 7.994 0 0 1 7.998 7.998v31.998c0 4.422-3.578 8-7.998 8zM272.016 432.004c-35.288 0-63.996-28.708-63.996-63.996s28.708-63.996 63.996-63.996 63.996 28.708 63.996 63.996-28.71 63.996-63.996 63.996z m0-111.992c-26.466 0-47.998 21.53-47.998 47.996 0 26.468 21.532 47.998 47.998 47.998s47.996-21.53 47.996-47.998c0-26.466-21.53-47.996-47.996-47.996z"
        fill=""
      />
      <path
        d="M325.7 392.008a8.008 8.008 0 0 1-7.672-5.718c-5.998-20.188-24.92-34.28-46.012-34.28s-40.014 14.092-46.014 34.28a7.994 7.994 0 0 1-9.952 5.39 8.012 8.012 0 0 1-5.39-9.954c8.008-26.912 33.232-45.716 61.356-45.716s53.348 18.804 61.356 45.716a8.012 8.012 0 0 1-5.39 9.954 8.348 8.348 0 0 1-2.282 0.328zM231.94 335.932a7.976 7.976 0 0 1-5.656-2.344l-56.074-56.074a8 8 0 0 1 11.312-11.31l56.074 56.074a7.996 7.996 0 0 1-5.656 13.654zM272.016 512c-4.422 0-8-3.578-8-8v-79.994c0-4.422 3.578-8 8-8s8 3.578 8 8V504c0 4.422-3.578 8-8 8zM528 96.026h-31.998c-4.422 0-8-3.578-8-8V56.028c0-4.422 3.578-8 8-8H528c4.422 0 8 3.578 8 8v31.998c0 4.422-3.578 8-8 8z m-23.998-16H520v-15.998h-15.998v15.998z"
        fill=""
      />
      <path
        d="M983.972 767.984H40.03c-4.422 0-8-3.578-8-8V152.022c0-4.422 3.578-8 8-8h943.944c4.422 0 8 3.578 8 8v607.962a8 8 0 0 1-8.002 8z m-935.942-16h927.944V160.022H48.03v591.962z"
        fill=""
      />
      <path
        d="M1015.97 160.022H8.032c-4.422 0-8-3.578-8-8V88.026c0-4.422 3.578-8 8-8h1007.94a7.994 7.994 0 0 1 7.998 8v63.996a7.998 7.998 0 0 1-8 8z m-999.938-16h991.94V96.026H16.032v47.996z"
        fill=""
      />
      <path
        d="M967.972 128.024H56.03c-4.422 0-8-3.578-8-8s3.578-8 8-8h911.944c4.422 0 8 3.578 8 8s-3.58 8-8.002 8zM727.988 975.972a8.08 8.08 0 0 1-3.578-0.844l-215.988-107.994c-3.952-1.968-5.552-6.782-3.576-10.734s6.788-5.53 10.732-3.578l215.988 107.994a8 8 0 1 1-3.578 15.156zM791.984 975.972a8.08 8.08 0 0 1-3.578-0.844l-279.984-139.992c-3.952-1.968-5.552-6.782-3.576-10.734s6.788-5.546 10.732-3.578l279.984 139.992a8 8 0 1 1-3.578 15.156z"
        fill=""
      />
      <path
        d="M791.984 975.972h-63.996c-4.422 0-8-3.578-8-8s3.578-8 8-8h63.996c4.422 0 8 3.578 8 8s-3.578 8-8 8zM296.022 975.972a8.012 8.012 0 0 1-7.164-4.422 7.996 7.996 0 0 1 3.578-10.734l215.986-107.994a8.02 8.02 0 0 1 10.734 3.578 7.996 7.996 0 0 1-3.578 10.734l-215.986 107.994a8.096 8.096 0 0 1-3.57 0.844zM232.026 975.972a8.012 8.012 0 0 1-7.164-4.422 7.996 7.996 0 0 1 3.578-10.734l279.982-139.992a8.006 8.006 0 0 1 10.734 3.578 7.996 7.996 0 0 1-3.578 10.734l-279.982 139.992a8.096 8.096 0 0 1-3.57 0.844z"
        fill=""
      />
      <path
        d="M296.014 975.972h-63.996c-4.422 0-8-3.578-8-8s3.578-8 8-8h63.996c4.422 0 8 3.578 8 8s-3.578 8-8 8zM496.002 843.98c-4.422 0-8-3.578-8-8v-75.996c0-4.422 3.578-8 8-8s8 3.578 8 8v75.996c0 4.422-3.578 8-8 8zM528 843.98c-4.422 0-8-3.578-8-8v-75.996c0-4.422 3.578-8 8-8s8 3.578 8 8v75.996c0 4.422-3.578 8-8 8zM528 975.972c-4.422 0-8-3.578-8-8v-99.994c0-4.422 3.578-8 8-8s8 3.578 8 8v99.994c0 4.422-3.578 8-8 8z"
        fill=""
      />
      <path
        d="M528 975.972h-31.998c-4.422 0-8-3.578-8-8s3.578-8 8-8H528c4.422 0 8 3.578 8 8s-3.578 8-8 8z"
        fill=""
      />
      <path
        d="M496.002 975.972c-4.422 0-8-3.578-8-8v-99.994c0-4.422 3.578-8 8-8s8 3.578 8 8v99.994c0 4.422-3.578 8-8 8zM512 719.988a7.994 7.994 0 0 1-7.998-8V200.02c0-4.422 3.578-8 7.998-8 4.422 0 8 3.578 8 8v511.968c0 4.422-3.578 8-8 8zM599.996 528c-4.422 0-8-3.578-8-8V248.016c0-4.422 3.578-8 8-8s8 3.578 8 8V520c0 4.422-3.578 8-8 8z"
        fill=""
      />
      <path
        d="M903.976 528h-303.98c-4.422 0-8-3.578-8-8s3.578-8 8-8h303.98c4.422 0 8 3.578 8 8s-3.578 8-8 8z"
        fill=""
      />
      <path
        d="M903.976 607.994h-303.98c-4.422 0-8-3.578-8-8a7.994 7.994 0 0 1 8-7.998h303.98c4.422 0 8 3.578 8 7.998 0 4.422-3.578 8-8 8z"
        fill=""
      />
      <path
        d="M871.978 639.992H631.994c-4.422 0-8-3.578-8-8s3.578-8 8-8h239.984c4.422 0 8 3.578 8 8s-3.578 8-8 8z"
        fill=""
      />
      <path
        d="M823.982 671.99h-143.992a7.994 7.994 0 0 1-7.998-8 7.994 7.994 0 0 1 7.998-7.998h143.992a7.994 7.994 0 0 1 7.998 7.998c0 4.422-3.578 8-7.998 8z"
        fill=""
      />
      <path
        d="M424.006 607.994H120.026c-4.422 0-8-3.578-8-8a7.994 7.994 0 0 1 8-7.998h303.98c4.422 0 8 3.578 8 7.998 0 4.422-3.578 8-8 8z"
        fill=""
      />
      <path
        d="M392.008 639.992H152.024c-4.422 0-8-3.578-8-8s3.578-8 8-8h239.984c4.422 0 8 3.578 8 8s-3.578 8-8 8z"
        fill=""
      />
      <path
        d="M344.012 671.99H200.02c-4.422 0-8-3.578-8-8a7.994 7.994 0 0 1 8-7.998h143.992a7.994 7.994 0 0 1 7.998 7.998c0 4.422-3.578 8-7.998 8z"
        fill=""
      />
      <path
        d="M631.994 464.002a7.996 7.996 0 0 1-5.656-13.654l95.994-95.994a8 8 0 0 1 11.312 11.31l-95.996 95.994a7.968 7.968 0 0 1-5.654 2.344z"
        fill=""
      />
      <path
        d="M775.984 416.006a7.976 7.976 0 0 1-5.656-2.344l-47.996-47.998a8 8 0 0 1 11.312-11.31l47.996 47.996a8 8 0 0 1-5.656 13.656z"
        fill=""
      />
      <path
        d="M775.984 416.006a8 8 0 0 1-5.656-13.656l127.992-127.992a8 8 0 1 1 11.312 11.312l-127.992 127.992a7.974 7.974 0 0 1-5.656 2.344z"
        fill=""
      />
      <path
        d="M903.976 320.012c-4.422 0-8-3.578-8-8v-31.998c0-4.422 3.578-8 8-8s8 3.578 8 8v31.998c0 4.422-3.578 8-8 8z"
        fill=""
      />
      <path
        d="M903.976 288.014h-31.998c-4.42 0-7.998-3.578-7.998-8s3.578-8 7.998-8h31.998c4.422 0 8 3.578 8 8s-3.578 8-8 8z"
        fill=""
      />
    </svg>
  ),
  folderSettings: (
    <svg
      xmlns="http://www.w3.org/2000/svg"
      width="100%"
      height="100%"
      className="pointer-events-none"
      viewBox="0 0 79.11 72.46">
      <g>
        <g>
          <path
            d="m78.46,59.42h-18.23c-.36,0-.65-.29-.65-.65s.29-.65.65-.65h17.58V1.3H1.3v56.82h17.57c.36,0,.65.29.65.65s-.29.65-.65.65H.65c-.36,0-.65-.29-.65-.65V.65c0-.36.29-.65.65-.65h77.81c.36,0,.65.29.65.65v58.12c0,.36-.29.65-.65.65Z"
            style={{ strokeWidth: "0px" }}
          />
          <path
            d="m77.92,14.15H31.14c-.12,0-.25-.04-.35-.1l-5.67-3.65H1.31c-.36,0-.65-.29-.65-.65s.29-.65.65-.65h24c.12,0,.25.04.35.1l5.67,3.65h46.59c.36,0,.65.29.65.65s-.29.65-.65.65Z"
            style={{ strokeWidth: "0px" }}
          />
          <path
            d="m66.38,8.11h-2.58c-.36,0-.65-.29-.65-.65s.29-.65.65-.65h2.58c.36,0,.65.29.65.65s-.29.65-.65.65Z"
            style={{ strokeWidth: "0px" }}
          />
          <path
            d="m70.69,8.11h-2.57c-.36,0-.65-.29-.65-.65s.29-.65.65-.65h2.57c.36,0,.65.29.65.65s-.29.65-.65.65Z"
            style={{ strokeWidth: "0px" }}
          />
          <path
            d="m75,8.11h-2.57c-.36,0-.65-.29-.65-.65s.29-.65.65-.65h2.57c.36,0,.65.29.65.65s-.29.65-.65.65Z"
            style={{ strokeWidth: "0px" }}
          />
          <path
            d="m41.2,72.46h-3.28c-.32,0-.59-.24-.64-.55l-.89-5.87c-.9-.16-1.79-.4-2.66-.71l-3.69,4.64c-.2.25-.56.32-.83.16l-2.85-1.64c-.28-.16-.4-.5-.28-.8l2.17-5.52c-.68-.58-1.34-1.24-1.95-1.95l-5.53,2.18c-.3.12-.64,0-.8-.28l-1.64-2.85c-.16-.28-.09-.63.16-.83l4.64-3.69c-.31-.88-.55-1.77-.71-2.66l-5.87-.89c-.32-.05-.55-.32-.55-.64v-1.64c0-.36.29-.65.65-.65s.65.29.65.65v1.08l5.78.88c.28.04.5.26.55.54.17,1.11.47,2.23.88,3.32.1.26.02.56-.2.74l-4.57,3.63,1.08,1.88,5.44-2.14c.26-.11.56-.03.74.19.75.92,1.56,1.74,2.43,2.43.22.18.3.48.2.75l-2.14,5.44,1.88,1.08,3.64-4.57c.18-.22.48-.3.74-.2,1.08.42,2.19.71,3.31.88.28.04.5.26.54.55l.87,5.78h2.16l.87-5.78c.04-.28.26-.5.54-.55,1.12-.17,2.24-.47,3.31-.88.26-.1.57-.02.74.2l3.64,4.57,1.88-1.08-2.14-5.44c-.1-.26-.02-.57.2-.75.86-.69,1.68-1.51,2.43-2.43.18-.22.48-.3.74-.19l5.44,2.14,1.08-1.88-4.58-3.64c-.22-.18-.31-.48-.2-.75.42-1.06.72-2.17.89-3.3.04-.28.26-.5.54-.55l5.78-.88v-1.08c0-.36.29-.65.65-.65s.65.29.65.65v1.64c0,.32-.24.59-.55.64l-5.87.89c-.16.9-.4,1.79-.71,2.66l4.64,3.69c.25.2.32.55.16.83l-1.64,2.85c-.16.28-.5.4-.8.28l-5.53-2.18c-.61.71-1.27,1.37-1.95,1.95l2.17,5.52c.12.3,0,.64-.28.8l-2.85,1.64c-.28.16-.63.09-.83-.16l-3.7-4.64c-.87.31-1.76.54-2.66.71l-.89,5.87c-.05.32-.32.55-.64.55Zm-1.64-14.5c-5,0-9.06-4.07-9.06-9.06,0-.36.29-.65.65-.65s.65.29.65.65c0,4.28,3.48,7.76,7.76,7.76s7.76-3.48,7.76-7.76c0-.36.29-.65.65-.65s.65.29.65.65c0,5-4.06,9.06-9.06,9.06Z"
            style={{ strokeWidth: "0px" }}
          />
          <path
            d="m69.6,49.55H9.51c-.36,0-.65-.29-.65-.65s.29-.65.65-.65h60.08c.36,0,.65.29.65.65s-.29.65-.65.65Z"
            style={{ strokeWidth: "0px" }}
          />
          <path
            d="m50.89,22h-31.78c-.36,0-.65-.29-.65-.65s.29-.65.65-.65h31.78c.36,0,.65.29.65.65s-.29.65-.65.65Z"
            style={{ strokeWidth: "0px" }}
          />
          <path
            d="m59.99,22h-5.17c-.36,0-.65-.29-.65-.65s.29-.65.65-.65h5.17c.36,0,.65.29.65.65s-.29.65-.65.65Z"
            style={{ strokeWidth: "0px" }}
          />
          <path
            d="m44.15,27.1h-25.04c-.36,0-.65-.29-.65-.65s.29-.65.65-.65h25.04c.36,0,.65.29.65.65s-.29.65-.65.65Z"
            style={{ strokeWidth: "0px" }}
          />
          <path
            d="m59.99,27.1h-5.17c-.36,0-.65-.29-.65-.65s.29-.65.65-.65h5.17c.36,0,.65.29.65.65s-.29.65-.65.65Z"
            style={{ strokeWidth: "0px" }}
          />
          <path
            d="m51.02,27.1h-3.61c-.36,0-.65-.29-.65-.65s.29-.65.65-.65h3.61c.36,0,.65.29.65.65s-.29.65-.65.65Z"
            style={{ strokeWidth: "0px" }}
          />
          <path
            d="m59.99,31.74h-25.04c-.36,0-.65-.29-.65-.65s.29-.65.65-.65h25.04c.36,0,.65.29.65.65s-.29.65-.65.65Z"
            style={{ strokeWidth: "0px" }}
          />
          <path
            d="m24.28,31.74h-5.17c-.36,0-.65-.29-.65-.65s.29-.65.65-.65h5.17c.36,0,.65.29.65.65s-.29.65-.65.65Z"
            style={{ strokeWidth: "0px" }}
          />
          <path
            d="m31.69,31.74h-3.6c-.36,0-.65-.29-.65-.65s.29-.65.65-.65h3.6c.36,0,.65.29.65.65s-.29.65-.65.65Z"
            style={{ strokeWidth: "0px" }}
          />
          <path
            d="m59.99,36.76h-31.33c-.36,0-.65-.29-.65-.65s.29-.65.65-.65h31.33c.36,0,.65.29.65.65s-.29.65-.65.65Z"
            style={{ strokeWidth: "0px" }}
          />
          <path
            d="m24.28,36.76h-5.17c-.36,0-.65-.29-.65-.65s.29-.65.65-.65h5.17c.36,0,.65.29.65.65s-.29.65-.65.65Z"
            style={{ strokeWidth: "0px" }}
          />
          <path
            d="m44.15,41.69h-25.03c-.36,0-.65-.29-.65-.65s.29-.65.65-.65h25.03c.36,0,.65.29.65.65s-.29.65-.65.65Z"
            style={{ strokeWidth: "0px" }}
          />
          <path
            d="m59.99,41.69h-5.17c-.36,0-.65-.29-.65-.65s.29-.65.65-.65h5.17c.36,0,.65.29.65.65s-.29.65-.65.65Z"
            style={{ strokeWidth: "0px" }}
          />
          <path
            d="m51.02,41.69h-3.61c-.36,0-.65-.29-.65-.65s.29-.65.65-.65h3.61c.36,0,.65.29.65.65s-.29.65-.65.65Z"
            style={{ strokeWidth: "0px" }}
          />
        </g>
      </g>
    </svg>
  ),
  gear: (
    <svg
      xmlns="http://www.w3.org/2000/svg"
      width="100%"
      height="100%"
      className="pointer-events-none"
      viewBox="0 0 76.1 79.11">
      <g>
        <g>
          <path
            d="m40.74,79.11h-5.37c-.32,0-.6-.24-.64-.55l-1.48-9.87c-1.65-.28-3.27-.72-4.85-1.29l-6.21,7.8c-.2.25-.56.32-.83.16l-4.65-2.69c-.28-.16-.4-.5-.28-.8l3.65-9.3c-1.26-1.05-2.45-2.24-3.54-3.54l-9.3,3.66c-.3.12-.64,0-.8-.28l-2.68-4.65c-.16-.28-.09-.63.16-.83l7.81-6.22c-.58-1.58-1.01-3.2-1.3-4.84l-9.87-1.49c-.32-.05-.55-.32-.55-.64v-5.37c0-.32.23-.59.55-.64l9.87-1.49c.28-1.62.72-3.24,1.3-4.83l-7.81-6.21c-.25-.2-.32-.55-.16-.83l2.68-4.65c.16-.28.5-.39.8-.28l9.3,3.65c1.07-1.28,2.26-2.46,3.54-3.54l-3.65-9.3c-.12-.3,0-.64.28-.8l4.65-2.69c.28-.16.63-.09.83.16l6.21,7.81c1.59-.58,3.22-1.02,4.85-1.3l.86-5.76c.05-.36.39-.6.74-.55.35.05.6.38.55.74l-.93,6.22c-.04.28-.26.5-.54.55-1.84.28-3.69.78-5.5,1.47-.27.1-.56.02-.74-.2l-6.16-7.74-3.68,2.13,3.62,9.21c.1.26.02.56-.19.74-1.47,1.2-2.82,2.55-4.02,4.02-.18.22-.48.3-.74.2l-9.22-3.62-2.13,3.68,7.74,6.16c.22.18.3.48.2.74-.69,1.8-1.19,3.65-1.47,5.49-.04.28-.26.5-.55.54l-9.79,1.47v4.25l9.79,1.47c.28.04.5.26.55.54.29,1.85.78,3.7,1.47,5.49.1.27.02.57-.2.74l-7.74,6.17,2.12,3.68,9.22-3.63c.26-.11.56-.03.74.19,1.22,1.5,2.57,2.85,4.02,4.02.22.18.3.48.2.74l-3.62,9.22,3.68,2.13,6.16-7.73c.18-.22.48-.3.74-.2,1.77.68,3.62,1.17,5.5,1.46.28.04.5.26.54.55l1.46,9.79h4.25l1.47-9.79c.04-.28.26-.5.54-.55,1.89-.29,3.73-.78,5.49-1.46.26-.1.57-.02.74.2l6.17,7.73,3.68-2.13-3.63-9.21c-.1-.27-.02-.57.2-.75,1.47-1.18,2.82-2.53,4.03-4.02.18-.22.48-.3.74-.2l9.21,3.62,2.12-3.67-7.73-6.17c-.22-.18-.3-.48-.2-.74.68-1.76,1.17-3.61,1.46-5.49.04-.28.26-.5.55-.54l9.79-1.47v-4.25l-9.79-1.47c-.28-.04-.5-.26-.55-.54-.29-1.86-.78-3.71-1.46-5.49-.1-.26-.02-.56.2-.74l4.72-3.77c.28-.22.69-.18.91.1.22.28.18.69-.1.91l-4.35,3.47c.57,1.57,1.01,3.2,1.29,4.84l9.87,1.49c.32.05.55.32.55.64v5.37c0,.32-.24.59-.55.64l-9.87,1.49c-.28,1.65-.72,3.27-1.29,4.84l7.8,6.22c.25.2.32.55.16.83l-2.69,4.64c-.16.28-.5.4-.8.28l-9.29-3.65c-1.08,1.29-2.27,2.48-3.55,3.54l3.66,9.29c.12.3,0,.64-.28.8l-4.65,2.69c-.28.16-.63.09-.83-.16l-6.22-7.8c-1.56.57-3.18,1-4.84,1.29l-1.49,9.87c-.05.32-.32.55-.64.55Zm-2.69-23.67c-7.93,0-14.37-6.45-14.37-14.38,0-7.25,5.42-13.39,12.61-14.27.36-.04.68.21.72.57.04.36-.21.68-.57.72-6.54.8-11.47,6.39-11.47,12.98,0,7.21,5.87,13.08,13.08,13.08s13.08-5.87,13.08-13.08c0-2.93-.96-5.71-2.76-8.05-.22-.28-.17-.69.12-.91.28-.22.69-.17.91.12,1.99,2.56,3.03,5.62,3.03,8.84,0,7.93-6.45,14.38-14.38,14.38Z"
            style={{ strokeWidth: "0px" }}
          />
          <path
            d="m40.91,38.79c-.1,0-.21-.03-.3-.07-.21-.11-.35-.33-.35-.58v-10.06h-5.51c-.36,0-.65-.29-.65-.65V.65c0-.36.29-.65.65-.65h39.88c.36,0,.65.29.65.65v26.78c0,.36-.29.65-.65.65h-18.07l-15.29,10.59c-.11.08-.24.12-.37.12Zm-5.51-12.01h5.51c.36,0,.65.29.65.65v9.47l14.44-10c.11-.08.24-.12.37-.12h17.62V1.3h-38.58v25.48Z"
            style={{ strokeWidth: "0px" }}
          />
          <path
            d="m62.55,7.31h-21.86c-.36,0-.65-.29-.65-.65s.29-.65.65-.65h21.86c.36,0,.65.29.65.65s-.29.65-.65.65Z"
            style={{ strokeWidth: "0px" }}
          />
          <path
            d="m68.7,7.31h-3.34c-.36,0-.65-.29-.65-.65s.29-.65.65-.65h3.34c.36,0,.65.29.65.65s-.29.65-.65.65Z"
            style={{ strokeWidth: "0px" }}
          />
          <path
            d="m68.7,10.98h-22.4c-.36,0-.65-.29-.65-.65s.29-.65.65-.65h22.4c.36,0,.65.29.65.65s-.29.65-.65.65Z"
            style={{ strokeWidth: "0px" }}
          />
          <path
            d="m44.02,10.98h-3.34c-.36,0-.65-.29-.65-.65s.29-.65.65-.65h3.34c.36,0,.65.29.65.65s-.29.65-.65.65Z"
            style={{ strokeWidth: "0px" }}
          />
          <path
            d="m60.63,14.64h-19.94c-.36,0-.65-.29-.65-.65s.29-.65.65-.65h19.94c.36,0,.65.29.65.65s-.29.65-.65.65Z"
            style={{ strokeWidth: "0px" }}
          />
          <path
            d="m68.7,14.64h-3.34c-.36,0-.65-.29-.65-.65s.29-.65.65-.65h3.34c.36,0,.65.29.65.65s-.29.65-.65.65Z"
            style={{ strokeWidth: "0px" }}
          />
          <path
            d="m68.7,18.29h-22.78c-.36,0-.65-.29-.65-.65s.29-.65.65-.65h22.78c.36,0,.65.29.65.65s-.29.65-.65.65Z"
            style={{ strokeWidth: "0px" }}
          />
          <path
            d="m44.02,18.29h-3.34c-.36,0-.65-.29-.65-.65s.29-.65.65-.65h3.34c.36,0,.65.29.65.65s-.29.65-.65.65Z"
            style={{ strokeWidth: "0px" }}
          />
          <path
            d="m62.24,21.96h-21.55c-.36,0-.65-.29-.65-.65s.29-.65.65-.65h21.55c.36,0,.65.29.65.65s-.29.65-.65.65Z"
            style={{ strokeWidth: "0px" }}
          />
          <path
            d="m68.7,21.96h-3.34c-.36,0-.65-.29-.65-.65s.29-.65.65-.65h3.34c.36,0,.65.29.65.65s-.29.65-.65.65Z"
            style={{ strokeWidth: "0px" }}
          />
        </g>
      </g>
    </svg>
  ),
  globeNetwork: (
    <svg
      xmlns="http://www.w3.org/2000/svg"
      width="100%"
      height="100%"
      className="pointer-events-none"
      viewBox="0 0 62.68 79.11">
      <g>
        <g>
          <path
            d="m30.28,53.74c-14.82,0-26.87-12.05-26.87-26.87S15.47,0,30.28,0s26.87,12.05,26.87,26.87-12.06,26.87-26.87,26.87Zm0-52.44C16.19,1.3,4.72,12.77,4.72,26.87s11.47,25.57,25.57,25.57,25.58-11.47,25.58-25.57S44.39,1.3,30.28,1.3Z"
            style={{ strokeWidth: "0px" }}
          />
          <path
            d="m30.28,53.74c-4.68,0-9.03-4.37-11.64-11.7-.06-.17-.05-.35.03-.51.08-.16.22-.28.39-.33.76-.24,1.3-.87,1.43-1.64.1-.6-.07-1.21-.46-1.68-.5-.59-1.28-.86-2.07-.68-.17.04-.35,0-.5-.09-.15-.09-.25-.24-.29-.42-.64-3.11-.97-6.42-.97-9.83,0-3.58.36-7.07,1.08-10.37.04-.17.14-.32.29-.41.15-.09.33-.12.5-.08,1.16.29,2.35-.48,2.56-1.66.01-.11.02-.23.02-.35,0-.89-.57-1.69-1.43-1.97-.17-.06-.3-.18-.38-.34-.08-.16-.08-.34-.02-.51C21.5,4.07,25.68,0,30.28,0s9.26,4.6,11.85,12.31c.17.49.32,1,.47,1.52,0,0,0,0,0,.01,1.14,3.94,1.74,8.44,1.74,13.03,0,3.41-.32,6.72-.95,9.81-.03.17-.14.32-.28.41-.14.09-.32.13-.49.09-.19-.04-.35-.06-.5-.06-1.14,0-2.07.93-2.07,2.07,0,.9.6,1.71,1.46,1.98.17.05.31.17.39.33s.09.34.03.51c-2.61,7.34-6.96,11.72-11.65,11.72Zm-10.21-11.56c2.43,6.44,6.22,10.26,10.21,10.26s7.79-3.83,10.22-10.28c-1.06-.58-1.74-1.7-1.74-2.95,0-1.9,1.55-3.45,3.49-3.37.54-2.84.81-5.85.81-8.96,0-4.25-.53-8.42-1.53-12.11-3.7.65-7.45.98-11.15.98h0s-.01,0-.02,0h0c-2.85,0-5.73-.19-8.59-.58-.5,1.36-1.85,2.27-3.33,2.21-.61,3.03-.92,6.22-.92,9.5s.28,6.13.82,8.98c1.03-.03,2.02.41,2.68,1.19.64.76.92,1.75.75,2.73-.16,1.03-.79,1.91-1.69,2.41Zm10.27-27.73c3.59,0,7.22-.32,10.81-.94-.08-.26-.16-.53-.25-.78-2.41-7.15-6.38-11.42-10.62-11.42-3.86,0-7.58,3.64-10.02,9.77,1,.58,1.65,1.63,1.69,2.81,2.79.37,5.61.56,8.39.56h0Z"
            style={{ strokeWidth: "0px" }}
          />
          <path
            d="m56.51,27.52H4.07c-.36,0-.65-.29-.65-.65s.29-.65.65-.65h52.44c.36,0,.65.29.65.65s-.29.65-.65.65Z"
            style={{ strokeWidth: "0px" }}
          />
          <path
            d="m30.28,53.74c-.36,0-.65-.29-.65-.65V.65c0-.36.29-.65.65-.65s.65.29.65.65v52.44c0,.36-.29.65-.65.65Z"
            style={{ strokeWidth: "0px" }}
          />
          <path
            d="m18.59,17.37c-1.86,0-3.38-1.51-3.38-3.38,0-.02,0-.03,0-.05-2.14-.5-4.29-1.12-6.39-1.82-.34-.11-.52-.48-.41-.82.11-.34.48-.52.82-.41,2.05.69,4.15,1.29,6.24,1.78.52-1.22,1.74-2.05,3.11-2.05,1.82,0,3.3,1.45,3.36,3.26,9.79,1.31,19.67.31,29.37-2.99.34-.12.71.07.82.41.12.34-.07.71-.41.82-9.9,3.36-19.98,4.39-29.99,3.04-.49,1.32-1.73,2.21-3.16,2.21Zm0-5.45c-.98,0-1.84.69-2.04,1.65-.03.13-.04.28-.04.42,0,1.14.93,2.08,2.08,2.08,1.02,0,1.88-.73,2.05-1.74h0c.01-.09.02-.21.02-.34,0-1.14-.93-2.08-2.07-2.08Z"
            style={{ strokeWidth: "0px" }}
          />
          <path
            d="m51.53,42.34c-.07,0-.14-.01-.21-.04-2.16-.74-4.41-1.38-6.67-1.91-.35-.08-.57-.43-.48-.78.08-.35.43-.57.78-.48,2.3.54,4.59,1.19,6.79,1.94.34.12.52.48.41.82-.09.27-.34.44-.62.44Zm-42.5,0c-.27,0-.52-.17-.62-.44-.11-.34.07-.71.41-.82,2.28-.77,4.57-1.41,6.8-1.92.35-.08.7.14.78.49.08.35-.14.7-.49.78-2.19.5-4.44,1.14-6.68,1.89-.07.02-.14.03-.21.03Zm12.09-2.92c-.32,0-.6-.23-.64-.56-.05-.36.19-.69.55-.74,6.17-.9,12.39-.9,18.5,0,.36.05.6.38.55.74-.05.36-.38.6-.74.55-5.99-.87-12.09-.87-18.13,0-.03,0-.06,0-.09,0Z"
            style={{ strokeWidth: "0px" }}
          />
          <path
            d="m42.13,42.58c-1.86,0-3.37-1.51-3.37-3.38s1.51-3.37,3.37-3.37c.99,0,1.93.43,2.58,1.19.64.76.92,1.75.75,2.72-.26,1.64-1.66,2.83-3.33,2.83Zm0-5.45c-1.14,0-2.07.93-2.07,2.07s.93,2.08,2.07,2.08c1.02,0,1.89-.73,2.05-1.74.1-.6-.07-1.21-.46-1.67-.39-.47-.97-.73-1.58-.73Z"
            style={{ strokeWidth: "0px" }}
          />
          <path
            d="m18.44,42.6c-1.86,0-3.38-1.51-3.38-3.37s1.51-3.38,3.38-3.38c.99,0,1.93.43,2.58,1.19.64.76.92,1.75.75,2.73-.26,1.64-1.66,2.83-3.33,2.83Zm0-5.45c-1.14,0-2.08.93-2.08,2.08s.93,2.07,2.08,2.07c1.02,0,1.88-.73,2.05-1.74.1-.6-.07-1.21-.46-1.68-.39-.47-.97-.73-1.58-.73Z"
            style={{ strokeWidth: "0px" }}
          />
          <path
            d="m30.28,79.11c-2.98,0-5.41-2.42-5.41-5.4s2.43-5.41,5.41-5.41,5.41,2.43,5.41,5.41-2.43,5.4-5.41,5.4Zm0-9.51c-2.27,0-4.11,1.84-4.11,4.11s1.84,4.1,4.11,4.1,4.11-1.84,4.11-4.1-1.84-4.11-4.11-4.11Z"
            style={{ strokeWidth: "0px" }}
          />
          <path
            d="m62.03,74.36h-25.73c-.36,0-.65-.29-.65-.65s.29-.65.65-.65h25.73c.36,0,.65.29.65.65s-.29.65-.65.65Zm-35.65,0H.65c-.36,0-.65-.29-.65-.65s.29-.65.65-.65h25.73c.36,0,.65.29.65.65s-.29.65-.65.65Z"
            style={{ strokeWidth: "0px" }}
          />
          <path
            d="m30.28,69.6c-.36,0-.65-.29-.65-.65v-20.12c0-.36.29-.65.65-.65s.65.29.65.65v20.12c0,.36-.29.65-.65.65Z"
            style={{ strokeWidth: "0px" }}
          />
        </g>
      </g>
    </svg>
  ),
  man: (
    <svg
      xmlns="http://www.w3.org/2000/svg"
      width="100%"
      height="100%"
      className="pointer-events-none"
      viewBox="0 0 1024 1024"
      fill="#000000">
      <path
        d="M999.97 1023.984H24.03c-4.422 0-8-3.578-8-8v-95.992c0-68.668 35.568-94.98 101.198-119.494 197.098-73.682 202.786-101.556 202.786-104.494 0-4.422 3.578-8 8-8s7.998 3.578 7.998 8c0 10.876 0 39.794-213.182 119.478-61.52 22.982-90.798 44.48-90.798 104.51v87.994h959.942v-87.994c0-60.03-29.28-81.528-90.792-104.51-213.192-79.684-213.192-108.604-213.192-119.478 0-4.422 3.578-8 8-8s8 3.578 8 8c0 2.938 5.688 30.812 202.8 104.494 65.622 24.514 101.182 50.826 101.182 119.494v95.992a8 8 0 0 1-8.002 8z"
        fill=""
      />
      <path
        d="M512 752c-108.494 0-287.982-168.254-287.982-359.976 0-4.422 3.578-8 8-8a7.994 7.994 0 0 1 7.998 8c0 177.364 169.678 343.978 271.984 343.978s271.984-166.616 271.984-343.978c0-4.422 3.578-8 8-8a7.994 7.994 0 0 1 7.998 8C799.982 583.746 620.494 752 512 752z"
        fill=""
      />
      <path
        d="M328.012 704.004c-4.422 0-8-3.578-8-8v-63.996c0-4.422 3.578-8 8-8s7.998 3.578 7.998 8v63.996c0 4.422-3.576 8-7.998 8zM695.988 704.004c-4.422 0-8-3.578-8-8v-63.996c0-4.422 3.578-8 8-8s8 3.578 8 8v63.996c0 4.422-3.578 8-8 8z"
        fill=""
      />
      <path
        d="M184.02 397.928a8.006 8.006 0 0 1-8-7.998c-0.024-201.192 110.048-284.576 148.444-307.544l-32.56-19.484a8.01 8.01 0 0 1-2.828-10.86C292.436 46.214 411.928 0.014 527.624 0.014c87.15 0 154.802 25.28 201.08 75.136 56.03 60.372 79.558 156.414 69.934 285.468a7.968 7.968 0 0 1-6.062 7.17 7.962 7.962 0 0 1-8.716-3.562l-76.48-123.946c-239.126-11.812-516.516 154.85-519.204 156.476a7.946 7.946 0 0 1-4.156 1.172z m130.148-340.354l30.576 18.296a8.028 8.028 0 0 1 3.868 7.39 8 8 0 0 1-4.812 6.828c-0.376 0.156-38.436 16.968-75.932 62.09-33.256 39.998-72.644 110.87-75.66 223.752 57.426-32.544 304.2-164.224 520.25-151.38a7.996 7.996 0 0 1 6.344 3.782l65.372 105.916c4.61-111.728-17.938-195.144-67.2-248.204-43.124-46.464-106.822-70.026-189.348-70.026-90.576-0.004-179.108 28.932-213.458 41.556z"
        fill=""
      />
      <path
        d="M512 895.992c-105.956 0-169.694-39.542-204.504-72.73-37.982-36.184-50.536-72.198-51.05-73.712a7.982 7.982 0 0 1 4.984-10.14c4.156-1.406 8.716 0.796 10.154 4.968 1.906 5.532 48.912 135.618 240.416 135.618 192.036 0 239.954-134.242 240.422-135.602 1.406-4.188 5.968-6.454 10.14-5a7.994 7.994 0 0 1 4.984 10.156c-0.5 1.516-13.062 37.53-51.042 73.712-34.81 33.188-98.542 72.73-204.504 72.73z"
        fill=""
      />
      <path
        d="M512 863.994c-176.248 0-228.682-127.57-229.134-128.868a8.006 8.006 0 0 1 4.922-10.186c4.148-1.422 8.726 0.75 10.188 4.92 0.422 1.14 48.48 118.134 214.026 118.134 163.038 0 213.614-117.088 214.082-118.276 1.592-4.092 6.216-6.186 10.31-4.592a7.96 7.96 0 0 1 4.672 10.202c-0.486 1.284-55.466 128.666-229.066 128.666z"
        fill=""
      />
      <path
        d="M456.004 432.004h-111.994c-13.232 0-23.998-10.764-23.998-24v-31.998c0-13.232 10.766-23.998 23.998-23.998h111.994c13.232 0 23.998 10.766 23.998 23.998v31.998c0 13.236-10.766 24-23.998 24z m-111.994-63.996a8 8 0 0 0-8 8v31.998c0 4.406 3.586 8 8 8h111.994a8.008 8.008 0 0 0 7.998-8v-31.998a8 8 0 0 0-7.998-8h-111.994z"
        fill=""
      />
      <path
        d="M679.99 432.004h-111.994c-13.232 0-23.998-10.764-23.998-24v-31.998c0-13.232 10.766-23.998 23.998-23.998h111.994c13.232 0 23.998 10.766 23.998 23.998v31.998c0 13.236-10.766 24-23.998 24z m-111.994-63.996c-4.406 0-8 3.578-8 8v31.998c0 4.406 3.594 8 8 8h111.994a8.014 8.014 0 0 0 7.998-8v-31.998c0-4.42-3.592-8-7.998-8h-111.994z"
        fill=""
      />
      <path
        d="M551.998 400.492h-80.012c-4.422 0-8-3.578-8-8s3.578-8 8-8h80.012c4.422 0 7.998 3.578 7.998 8s-3.576 8-7.998 8z"
        fill=""
      />
    </svg>
  ),
  woman: (
    <svg
      xmlns="http://www.w3.org/2000/svg"
      width="100%"
      height="100%"
      className="pointer-events-none"
      viewBox="0 0 1024 1024"
      fill="#000000">
      <path
        d="M512 720.004c-109.594 0-268.062-158.632-286.202-327.122a7.992 7.992 0 0 1 7.094-8.812c4.632-0.406 8.342 2.704 8.812 7.094 8.148 75.66 46.88 155.584 106.282 219.298 53.802 57.7 116.65 93.542 164.014 93.542 102.306 0 271.984-166.6 271.984-343.978 0-4.422 3.578-8 8-8a7.994 7.994 0 0 1 7.998 8c0 191.722-179.488 359.978-287.982 359.978z"
        fill=""
      />
      <path
        d="M951.972 1023.968H72.028c-4.422 0-8-3.578-8-8v-95.992c0-68.652 35.568-94.964 101.19-119.494 10.288-3.844 22.662-7.782 36.13-12.044 63.582-20.204 150.662-47.888 150.662-108.448 0-4.422 3.578-8 8-8s8 3.578 8 8c0 72.276-93.526 101.994-161.818 123.68-13.186 4.204-25.304 8.046-35.372 11.812-61.512 22.998-90.792 44.496-90.792 104.494v87.994h863.948v-87.994c0-59.998-29.28-81.496-90.792-104.494-10.062-3.766-22.188-7.624-35.39-11.812-68.276-21.686-161.8-51.404-161.8-123.68 0-4.422 3.578-8 7.998-8 4.422 0 8 3.578 8 8 0 60.558 87.072 88.244 150.646 108.432 13.484 4.28 25.86 8.216 36.138 12.06 65.636 24.53 101.198 50.842 101.198 119.494v95.992a8 8 0 0 1-8.002 8z"
        fill=""
      />
      <path
        d="M360.01 687.988c-4.422 0-8-3.576-8-7.998v-46.014c0-4.422 3.578-8 8-8s8 3.578 8 8v46.014a7.994 7.994 0 0 1-8 7.998zM663.99 687.988a7.994 7.994 0 0 1-7.998-7.998V633.96c0-4.422 3.578-8 7.998-8 4.422 0 8 3.578 8 8v46.03a7.994 7.994 0 0 1-8 7.998zM823.98 328.012a7.994 7.994 0 0 1-7.998-8C815.982 152.396 679.616 16.03 512 16.03S208.018 152.396 208.018 320.012c0 4.422-3.578 8-8 8-4.422 0-8-3.578-8-8 0-176.434 143.546-319.98 319.98-319.98 176.442 0 319.98 143.546 319.98 319.98a7.992 7.992 0 0 1-7.998 8z"
        fill=""
      />
      <path
        d="M903.976 639.992a7.986 7.986 0 0 1-4.438-1.344c-98.698-65.808-84.212-308.84-83.542-319.152 0.296-4.422 4.452-7.602 8.498-7.468a8.006 8.006 0 0 1 7.468 8.5c-0.156 2.43-14.594 244.11 76.45 304.808a8 8 0 0 1-4.436 14.656z"
        fill=""
      />
      <path
        d="M695.988 703.988c-4.422 0-8-3.578-8-8s3.578-8 8-8c123.446 0 202.222-61.622 203.004-62.246a7.976 7.976 0 0 1 11.234 1.25c2.75 3.468 2.188 8.5-1.25 11.25-3.358 2.688-83.684 65.746-212.988 65.746zM120.032 639.992a7.99 7.99 0 0 1-6.664-3.562 7.994 7.994 0 0 1 2.218-11.094c91.096-60.73 76.606-302.378 76.45-304.808a8.01 8.01 0 0 1 7.468-8.5c4.35-0.188 8.218 3.062 8.5 7.468 0.664 10.312 15.164 253.344-83.542 319.152a8.004 8.004 0 0 1-4.43 1.344z"
        fill=""
      />
      <path
        d="M328.012 703.988c-129.312 0-209.628-63.058-212.988-65.746-3.444-2.75-4-7.782-1.25-11.25a8.016 8.016 0 0 1 11.242-1.25c0.782 0.624 79.558 62.246 202.996 62.246 4.422 0 8 3.578 8 8s-3.578 8-8 8zM201.012 367.352a8 8 0 0 1-0.538-15.984c210.346-14.312 347.15-77.674 424.864-128.304 84.136-54.808 119.072-106.916 119.416-107.44 2.438-3.694 7.42-4.702 11.076-2.28a8 8 0 0 1 2.296 11.07c-1.406 2.148-145.708 214.964-556.558 242.922-0.19 0.008-0.376 0.016-0.556 0.016z"
        fill=""
      />
      <path
        d="M823.574 336.496c-0.218 0-0.422-0.008-0.64-0.024-109.82-8.584-207.908-88.448-212.034-91.846a7.994 7.994 0 0 1-1.078-11.256c2.812-3.438 7.86-3.868 11.25-1.094 0.984 0.804 98.4 80.064 203.112 88.244a7.994 7.994 0 0 1 7.344 8.602 7.998 7.998 0 0 1-7.954 7.374zM512.876 895.976c-105.76 0-161.146-35.966-188.98-66.136-30.67-33.232-35.608-66.48-35.802-67.886-0.61-4.344 2.43-8.376 6.796-9 4.25-0.688 8.398 2.406 9.046 6.782 0.71 4.906 19.726 120.244 208.94 120.244 189.098 0 206.536-115.244 207.176-120.15 0.578-4.376 4.61-7.532 8.952-6.906a7.994 7.994 0 0 1 6.922 8.922c-0.172 1.39-4.656 34.67-34.904 67.95-27.454 30.182-82.372 66.18-188.146 66.18zM807.982 1023.968c-4.422 0-8-3.578-8-8V792.14c0-4.422 3.578-8 8-8s8 3.578 8 8v223.828c0 4.422-3.578 8-8 8zM216.018 1023.968h-0.008c-4.42 0-8-3.594-7.992-8l0.282-223.922a8 8 0 0 1 8-7.984h0.008c4.422 0.016 8 3.594 7.992 8.016l-0.282 223.89a8.006 8.006 0 0 1-8 8z"
        fill=""
      />
    </svg>
  ),
  deal: (
    <svg
      xmlns="http://www.w3.org/2000/svg"
      width="100%"
      height="100%"
      className="pointer-events-none"
      viewBox="0 0 1024 1024"
      fill="#000000">
      <path
        d="M545.5395 1023.356c-12.29 0-24.57-4.678-33.922-14.022a7.988 7.988 0 0 1 0-11.304 7.992 7.992 0 0 1 11.306 0c12.49 12.474 32.79 12.458 45.25-0.016 12.454-12.468 12.446-32.752-0.032-45.218a7.988 7.988 0 0 1 0-11.304 7.988 7.988 0 0 1 11.304 0c18.706 18.69 18.72 49.114 0.032 67.828-9.354 9.35-21.652 14.036-33.938 14.036zM624.7095 944.236c-12.828 0-24.882-4.996-33.946-14.068a7.988 7.988 0 0 1 0-11.304 7.988 7.988 0 0 1 11.304 0c12.07 12.078 33.14 12.11 45.218 0.032 12.468-12.466 12.46-32.76-0.016-45.234l-62.176-62.208a7.992 7.992 0 1 1 11.304-11.304l62.176 62.208c18.714 18.706 18.714 49.146 0.016 67.844-9.038 9.046-21.074 14.034-33.88 14.034zM703.8195 865.08c-12.29 0-24.568-4.676-33.922-14.03l-62.176-62.178a7.992 7.992 0 1 1 11.304-11.304l62.176 62.178c12.476 12.474 32.76 12.474 45.234 0 12.476-12.476 12.476-32.776 0-45.252l-62.192-62.16c-3.124-3.122-3.124-8.182 0-11.304s8.184-3.124 11.304 0l62.192 62.16c18.714 18.708 18.714 49.156 0 67.862-9.35 9.352-21.63 14.028-33.92 14.028zM782.9675 785.932c-12.28 0-24.558-4.67-33.914-14.008l-62.2-62.214a7.992 7.992 0 0 1 0-11.304 7.988 7.988 0 0 1 11.304 0l62.192 62.208c12.476 12.446 32.76 12.46 45.22 0 12.474-12.476 12.474-32.774 0-45.25L596.4175 506.222a7.988 7.988 0 0 1 0-11.304 7.988 7.988 0 0 1 11.304 0l209.154 209.138c18.712 18.708 18.712 49.154 0 67.86-9.336 9.346-21.618 14.016-33.908 14.016zM195.5575 666.348a7.988 7.988 0 0 1-7.128-4.366c-34.624-67.914-46.016-134.68-46.484-137.492a7.996 7.996 0 0 1 6.566-9.196c4.396-0.656 8.47 2.224 9.204 6.566 0.11 0.672 11.5 67.234 44.954 132.864a7.988 7.988 0 0 1-7.112 11.624zM434.9495 381.682a7.964 7.964 0 0 1-3.084-0.618c-55.508-23.242-93.164-42.814-93.538-43.01a8.004 8.004 0 0 1-3.388-10.79 7.974 7.974 0 0 1 10.79-3.388c0.368 0.196 37.466 19.48 92.304 42.432a8 8 0 0 1-3.084 15.374zM814.9335 676.154a7.992 7.992 0 0 1-6.504-12.64c47.724-66.914 56.922-162.708 57.008-163.668 0.406-4.388 4.176-7.682 8.69-7.238a8 8 0 0 1 7.236 8.69c-0.376 4.09-9.704 101.104-59.91 171.508a8.002 8.002 0 0 1-6.52 3.348zM477.7015 1000.76h-0.008c-12.804 0-24.85-4.996-33.906-14.05-18.69-18.684-18.69-49.118-0.008-67.838l33.922-33.922c18.144-18.126 49.732-18.112 67.83 0.016 18.698 18.698 18.698 49.13 0 67.83l-33.9 33.898c-9.072 9.07-21.12 14.066-33.93 14.066z m33.922-113.86a31.83 31.83 0 0 0-22.626 9.362l-33.906 33.906c-12.452 12.484-12.46 32.776 0 45.236a31.756 31.756 0 0 0 22.602 9.368h0.008c8.542 0 16.576-3.332 22.624-9.382l33.9-33.898c12.466-12.468 12.466-32.754 0-45.22a31.72 31.72 0 0 0-22.602-9.372zM398.5515 921.62c-12.804 0-24.842-4.988-33.898-14.044-18.69-18.712-18.69-49.146 0-67.86l45.22-45.22c18.128-18.104 49.748-18.12 67.828 0 18.706 18.708 18.706 49.14 0 67.846l-45.218 45.218c-9.066 9.064-21.12 14.06-33.932 14.06z m45.25-125.172a31.792 31.792 0 0 0-22.624 9.352l-45.22 45.22c-12.46 12.474-12.46 32.776 0 45.25a31.746 31.746 0 0 0 22.594 9.362 31.82 31.82 0 0 0 22.626-9.376l45.218-45.218c12.468-12.468 12.468-32.768 0-45.236a31.7 31.7 0 0 0-22.594-9.354zM319.4175 842.462c-12.82 0-24.858-4.98-33.9-14.04-9.064-9.046-14.06-21.094-14.068-33.906a47.664 47.664 0 0 1 14.038-33.938l33.93-33.914c18.12-18.136 49.74-18.122 67.844 0.016 9.064 9.042 14.054 21.08 14.054 33.898 0 12.804-4.99 24.852-14.054 33.914l-33.93 33.93c-9.064 9.06-21.11 14.04-33.914 14.04z m33.916-113.858a31.756 31.756 0 0 0-22.61 9.368l-33.93 33.914a31.77 31.77 0 0 0-9.352 22.624 31.808 31.808 0 0 0 9.384 22.61c12.054 12.07 33.118 12.07 45.204 0l33.93-33.93a31.772 31.772 0 0 0 9.37-22.61c0-8.54-3.326-16.558-9.362-22.586a31.778 31.778 0 0 0-22.634-9.39zM240.2775 763.33h-0.008c-12.812 0-24.85-4.982-33.898-14.04-18.7-18.712-18.7-49.144 0-67.844l22.61-22.61c18.12-18.128 49.692-18.098 67.812 0.016 9.064 9.062 14.054 21.102 14.062 33.906s-4.982 24.844-14.046 33.906l-22.61 22.61c-9.066 9.066-21.112 14.056-33.922 14.056z m22.594-102.548a31.74 31.74 0 0 0-22.586 9.362l-22.61 22.61c-12.46 12.468-12.46 32.758 0 45.234a31.734 31.734 0 0 0 22.594 9.354h0.008c8.542 0 16.574-3.326 22.618-9.37l22.61-22.61c6.042-6.042 9.362-14.068 9.362-22.602s-3.334-16.558-9.376-22.602c-6.054-6.042-14.08-9.376-22.62-9.376zM409.8875 548.506c-12.29 0-24.578-4.684-33.93-14.038-18.698-18.698-18.698-49.114 0-67.812l73.482-73.512c68.922-68.922 224.082-91.758 230.646-92.702 4.326-0.696 8.418 2.404 9.05 6.784a7.998 7.998 0 0 1-6.786 9.048c-1.562 0.218-156.464 23.03-221.608 88.174l-73.48 73.512c-12.46 12.46-12.46 32.744 0 45.204 12.468 12.476 32.75 12.476 45.22 0.016 4.154-4.154 102.328-101.134 152.63-50.886a7.992 7.992 0 0 1 0 11.304 7.988 7.988 0 0 1-11.304 0c-32.432-32.384-104.852 25.732-130.022 50.886-9.344 9.346-21.624 14.022-33.898 14.022zM907.3315 497.26a7.96 7.96 0 0 1-5.652-2.342L686.8715 280.096a7.992 7.992 0 0 1 0-11.304 7.988 7.988 0 0 1 11.304 0l214.808 214.822a7.992 7.992 0 0 1-5.652 13.646zM986.4795 463.33a7.96 7.96 0 0 1-5.652-2.342L720.7855 200.962a7.992 7.992 0 0 1 0-11.304 7.988 7.988 0 0 1 11.304 0l260.042 260.026a7.992 7.992 0 0 1-5.652 13.646z"
        fill=""
      />
      <path
        d="M692.5235 282.438a7.992 7.992 0 0 1-5.652-13.646l33.914-33.916a7.992 7.992 0 1 1 11.304 11.304l-33.914 33.916a7.96 7.96 0 0 1-5.652 2.342zM907.3315 497.26a7.96 7.96 0 0 1-5.652-2.342 7.988 7.988 0 0 1 0-11.304l33.914-33.916a7.992 7.992 0 1 1 11.304 11.306l-33.914 33.914a7.968 7.968 0 0 1-5.652 2.342zM726.4375 203.304a7.992 7.992 0 0 1-5.652-13.646l186.672-186.67a7.992 7.992 0 1 1 11.304 11.304l-186.672 186.67a7.96 7.96 0 0 1-5.652 2.342zM986.4795 463.33a7.96 7.96 0 0 1-5.652-2.342 7.988 7.988 0 0 1 0-11.304l29.528-29.496a7.992 7.992 0 1 1 11.304 11.304l-29.528 29.496a7.966 7.966 0 0 1-5.652 2.342zM115.9175 519.838a7.992 7.992 0 0 1-5.654-13.646L325.0855 291.4c3.122-3.124 8.182-3.124 11.304 0s3.124 8.182 0 11.304L121.5695 517.496a7.978 7.978 0 0 1-5.652 2.342zM36.7835 485.94a7.966 7.966 0 0 1-5.652-2.342 7.988 7.988 0 0 1 0-11.304l260.042-260.026a7.988 7.988 0 0 1 11.304 0 7.988 7.988 0 0 1 0 11.304L42.4355 483.598a7.968 7.968 0 0 1-5.652 2.342z"
        fill=""
      />
      <path
        d="M115.9175 519.838a7.98 7.98 0 0 1-5.654-2.342l-33.914-33.898c-3.124-3.124-3.124-8.182 0-11.304s8.182-3.124 11.304 0l33.916 33.898a7.992 7.992 0 0 1-5.652 13.646zM330.7395 305.046a7.966 7.966 0 0 1-5.652-2.342l-33.916-33.914a7.988 7.988 0 0 1 0-11.304 7.988 7.988 0 0 1 11.304 0l33.916 33.914a7.988 7.988 0 0 1 0 11.304 7.968 7.968 0 0 1-5.652 2.342zM36.7835 485.94a7.966 7.966 0 0 1-5.652-2.342l-28.2-28.2a7.994 7.994 0 0 1 11.304-11.306l28.2 28.2a7.988 7.988 0 0 1 0 11.304 7.962 7.962 0 0 1-5.652 2.344zM296.8235 225.914a7.978 7.978 0 0 1-5.652-2.342L81.9555 14.354c-3.124-3.124-3.124-8.182 0-11.304s8.182-3.124 11.304 0l209.216 209.216a7.988 7.988 0 0 1 0 11.304 7.964 7.964 0 0 1-5.652 2.344zM23.9635 415.784a23.848 23.848 0 0 1-16.974-7.026c-9.33-9.376-9.314-24.584 0.016-33.914 9.026-9.056 24.882-9.064 33.922 0.008a23.778 23.778 0 0 1 7.01 16.942 23.796 23.796 0 0 1-7.018 16.964 23.78 23.78 0 0 1-16.956 7.026z m0-31.978c-2.14 0-4.146 0.828-5.644 2.334a8.024 8.024 0 0 0-0.008 11.328c2.982 2.974 8.284 2.998 11.296-0.008a7.944 7.944 0 0 0 2.342-5.66c0-2.14-0.828-4.146-2.334-5.652a7.912 7.912 0 0 0-5.652-2.342z"
        fill=""
      />
    </svg>
  ),
  helpColored: (
    <svg
      xmlns="http://www.w3.org/2000/svg"
      width="100%"
      height="100%"
      className="pointer-events-none"
      viewBox="0 0 1024 1024">
      <path d="M217.1 235.2h582.2v24.4H217.1z" fill="#446EB1" />
      <path d="M217.1 259.6h558.1v531.6H217.1z" fill="#E1F0FF" />
      <path
        d="M775.2 235.2h24.1v556h-24.1zM217.1 242h24.1v549.2h-24.1z"
        fill="#446EB1"
      />
      <path d="M217.1 767.1h579.3v24.1H217.1z" fill="#446EB1" />
      <path
        d="M444.1 379.5c15.1-9.7 33.6-14.6 55.5-14.6 28.8 0 52.8 6.9 71.9 20.7 19.1 13.8 28.6 34.2 28.6 61.3 0 16.6-4.1 30.6-12.4 41.9-4.8 6.9-14.1 15.7-27.9 26.4l-13.6 10.5c-7.4 5.7-12.3 12.4-14.7 20.1-1.5 4.9-2.4 12.4-2.5 22.6h-51.9c0.8-21.6 2.8-36.5 6.1-44.7 3.3-8.2 11.8-17.7 25.6-28.4l13.9-10.9c4.6-3.4 8.3-7.2 11.1-11.3 5.1-7 7.6-14.7 7.6-23.2 0-9.7-2.8-18.5-8.5-26.5s-16-12-31-12c-14.8 0-25.2 4.9-31.4 14.7-6.2 9.8-9.3 20-9.3 30.6H406c1.5-36.2 14.2-62 38.1-77.2z m31.8 215.2h57.2V650h-57.2v-55.3z"
        fill="#6D9EE8"
      />
    </svg>
  ),
  checkMarkHistory: (
    <svg
      xmlns="http://www.w3.org/2000/svg"
      width="100%"
      height="100%"
      className="pointer-events-none"
      viewBox="0 0 24 24"
      fill="none">
      <path
        d="M19.6873 14.2222C19.8909 13.5167 20 12.7711 20 12C20 7.58172 16.4183 4 12 4C7.58172 4 4 7.58172 4 12C4 16.4183 7.58172 20 12 20C14.3413 20 16.4476 18.9943 17.9106 17.3912M19.6873 14.2222L19 13M19.6873 14.2222L20.75 13.25M9 12L11 14L15 10"
        stroke="#464455"
        strokeLinecap="round"
        strokeLinejoin="round"
      />
    </svg>
  ),
  horn: (
    <svg
      xmlns="http://www.w3.org/2000/svg"
      width="100%"
      height="100%"
      className="pointer-events-none"
      viewBox="0 0 1024 1024"
      fill="#000000">
      <path
        d="M653.92 690.726a7.968 7.968 0 0 1-7.858-6.59l-66.656-377.992a7.97 7.97 0 0 1 6.482-9.26c4.294-0.834 8.496 2.132 9.26 6.482l66.658 377.99a7.976 7.976 0 0 1-6.482 9.246 7.09 7.09 0 0 1-1.404 0.124zM662.26 737.986a7.964 7.964 0 0 1-7.856-6.592c-7.28-41.2-205.986-61.034-329.53-63.876a7.982 7.982 0 0 1-7.816-8.168c0.102-4.422 3.662-7.732 8.176-7.826 55.552 1.282 333.248 10.964 344.914 77.09a7.976 7.976 0 0 1-6.482 9.246 6.978 6.978 0 0 1-1.406 0.126z"
        fill=""
      />
      <path
        d="M286.158 447.034a7.996 7.996 0 0 1-2.156-15.696c84.134-23.668 299.714-100.798 287.096-172.454a7.97 7.97 0 0 1 6.482-9.26 7.98 7.98 0 0 1 9.26 6.482c7.624 43.278-41.09 88.662-144.77 134.9-74.95 33.43-152.962 55.514-153.742 55.732a8.026 8.026 0 0 1-2.17 0.296z"
        fill=""
      />
      <path
        d="M578.954 265.492a7.974 7.974 0 0 1-7.856-6.608 7.97 7.97 0 0 1 6.482-9.26l31.484-5.56c4.358-0.796 8.496 2.124 9.262 6.48a7.996 7.996 0 0 1-6.48 9.262l-31.486 5.56a7.61 7.61 0 0 1-1.406 0.126z"
        fill=""
      />
      <path
        d="M693.746 732.426a7.966 7.966 0 0 1-7.858-6.59l-83.304-472.51a7.974 7.974 0 0 1 6.48-9.262c4.358-0.796 8.496 2.124 9.262 6.48l83.306 472.51a7.976 7.976 0 0 1-6.482 9.246 7.106 7.106 0 0 1-1.404 0.126z"
        fill=""
      />
      <path
        d="M662.26 737.986a7.964 7.964 0 0 1-7.856-6.592 7.992 7.992 0 0 1 6.48-9.276l31.486-5.56c4.294-0.812 8.496 2.14 9.262 6.496a7.976 7.976 0 0 1-6.482 9.246l-31.486 5.56a6.946 6.946 0 0 1-1.404 0.126zM151.796 698.066a7.98 7.98 0 0 1-7.864-6.59L105.044 470.992a7.986 7.986 0 0 1 6.482-9.262l173.248-30.564c4.302-0.82 8.496 2.124 9.262 6.482a7.982 7.982 0 0 1-6.48 9.26l-165.378 29.182 36.116 204.734 165.37-29.174a7.966 7.966 0 0 1 9.262 6.498 7.966 7.966 0 0 1-6.482 9.246L153.194 697.94a6.94 6.94 0 0 1-1.398 0.126z"
        fill=""
      />
      <path
        d="M151.804 698.066c-0.274 0-0.554 0-0.828-0.032l-115.806-12.056a8.006 8.006 0 0 1-7.044-6.558L0.358 521.922a7.992 7.992 0 0 1 4.374-8.582l104.686-50.93a7.904 7.904 0 0 1 7.13 0.07 7.966 7.966 0 0 1 4.24 5.73l38.888 220.484a8.004 8.004 0 0 1-2.022 6.842 7.99 7.99 0 0 1-5.85 2.53z m-108.98-27.376l99.268 10.338-35.212-199.596-89.724 43.652 25.668 145.606zM319.486 636.034a7.98 7.98 0 0 1-7.864-6.592l-27.768-157.512a7.986 7.986 0 0 1 6.482-9.262c4.318-0.828 8.504 2.132 9.262 6.482l27.768 157.514a7.964 7.964 0 0 1-6.48 9.246c-0.47 0.092-0.94 0.124-1.4 0.124z"
        fill=""
      />
      <path
        d="M45.284 554.476a8.02 8.02 0 0 1-7.036-4.186 7.982 7.982 0 0 1 3.216-10.838l44.48-24.092a8.008 8.008 0 0 1 10.838 3.216 8 8 0 0 1-3.216 10.848l-44.48 24.082a7.934 7.934 0 0 1-3.802 0.97zM111.972 656.368c-0.39 0-0.782-0.032-1.18-0.078l-50.024-7.402a7.986 7.986 0 0 1-6.74-9.074c0.648-4.374 4.724-7.34 9.082-6.746l50.024 7.402a7.99 7.99 0 1 1-1.162 15.898zM53.608 601.706a7.98 7.98 0 0 1-7.864-6.592 8.004 8.004 0 0 1 6.482-9.276l47.244-8.308c4.342-0.796 8.496 2.124 9.26 6.464a8.006 8.006 0 0 1-6.482 9.278l-47.244 8.308a7.066 7.066 0 0 1-1.396 0.126zM127.276 466.93a7.988 7.988 0 0 1-7.864-6.606 7.986 7.986 0 0 1 6.482-9.262l31.5-5.56c4.334-0.828 8.496 2.132 9.262 6.482a7.986 7.986 0 0 1-6.482 9.262l-31.5 5.56a7.728 7.728 0 0 1-1.398 0.124zM388.016 932.492a7.976 7.976 0 0 1-7.308-4.734l-80.572-180.666a7.984 7.984 0 0 1 4.044-10.556c4.038-1.828 8.77 0.016 10.556 4.042l80.574 180.668a7.986 7.986 0 0 1-7.294 11.246zM293.512 949.172a8.02 8.02 0 0 1-7.308-4.748l-80.572-180.668a7.996 7.996 0 0 1 14.602-6.514l80.572 180.668a7.986 7.986 0 0 1-4.044 10.558 7.74 7.74 0 0 1-3.25 0.704z"
        fill=""
      />
      <path
        d="M277.74 951.952a7.994 7.994 0 0 1-7.864-6.624 7.962 7.962 0 0 1 6.48-9.244l126.006-22.24c4.358-0.812 8.496 2.138 9.26 6.496a7.966 7.966 0 0 1-6.482 9.246l-126.004 22.24a8.522 8.522 0 0 1-1.396 0.126zM175.88 742.546a7.98 7.98 0 0 1-7.864-6.59l-3.124-17.71a8.006 8.006 0 0 1 6.482-9.278c4.326-0.844 8.496 2.138 9.262 6.496l3.124 17.71a7.966 7.966 0 0 1-6.482 9.246 6.952 6.952 0 0 1-1.398 0.126z"
        fill=""
      />
      <path
        d="M175.88 742.546a7.994 7.994 0 0 1-1.36-15.868l157.584-27.27a7.982 7.982 0 0 1 9.246 6.512 7.996 7.996 0 0 1-6.512 9.246l-157.584 27.27a8.02 8.02 0 0 1-1.374 0.11z"
        fill=""
      />
      <path
        d="M333.464 715.278a7.98 7.98 0 0 1-7.864-6.59l-2.782-15.774a7.966 7.966 0 0 1 6.482-9.246c4.294-0.796 8.504 2.124 9.262 6.464l2.78 15.774a7.964 7.964 0 0 1-6.482 9.246 7.052 7.052 0 0 1-1.396 0.126z"
        fill=""
      />
      <path
        d="M727.872 184.294c-4.406 0-8.076-3.576-8.076-7.996s3.498-7.998 7.92-7.998h0.156c4.418 0 7.996 3.578 7.996 7.998s-3.578 7.996-7.996 7.996z"
        fill=""
      />
      <path
        d="M775.848 184.294c-4.404 0-8.074-3.576-8.074-7.996s3.498-7.998 7.918-7.998h0.156c4.42 0 7.996 3.578 7.996 7.998s-3.576 7.996-7.996 7.996z"
        fill=""
      />
      <path
        d="M855.344 855.996c-57.318 0-103.954-46.636-103.954-103.954 0-57.318 46.634-103.954 103.954-103.954 57.316 0 103.952 46.634 103.952 103.954-0.002 57.318-46.636 103.954-103.952 103.954z m0-191.914c-48.51 0-87.96 39.452-87.96 87.96 0 48.492 39.452 87.958 87.96 87.958 48.492 0 87.958-39.466 87.958-87.958 0-48.508-39.466-87.96-87.958-87.96z"
        fill=""
      />
      <path
        d="M751.39 280.25c-44.09 0-79.962-35.874-79.962-79.962s35.874-79.962 79.962-79.962 79.962 35.874 79.962 79.962c0.002 44.088-35.872 79.962-79.962 79.962z m0-143.934c-35.282 0-63.97 28.698-63.97 63.97s28.69 63.97 63.97 63.97c35.266 0 63.97-28.698 63.97-63.97s-28.704-63.97-63.97-63.97z"
        fill=""
      />
      <path
        d="M879.832 600.114c-79.372 0-143.934-64.582-143.934-143.944s64.562-143.934 143.934-143.934c79.354 0 143.934 64.572 143.934 143.934s-64.58 143.944-143.934 143.944z m0-271.886c-70.546 0-127.942 57.396-127.942 127.942s57.394 127.95 127.942 127.95c70.544 0 127.942-57.404 127.942-127.95s-57.398-127.942-127.942-127.942z"
        fill=""
      />
      <path
        d="M855.344 810.672a7.818 7.818 0 0 1-3.25-0.688c-2.154-0.954-52.724-23.926-52.724-65.938 0-19.118 15.54-34.672 34.638-34.672 7.874 0 15.292 2.638 21.32 7.402a34.138 34.138 0 0 1 21.316-7.402c19.118 0 34.672 15.554 34.672 34.672 0 42.012-50.57 64.984-52.724 65.938a7.816 7.816 0 0 1-3.248 0.688z m-21.336-85.304c-10.292 0-18.646 8.386-18.646 18.68 0 26.536 29.892 44.448 39.966 49.71 10.056-5.294 39.996-23.286 39.996-49.71 0-10.292-8.386-18.68-18.68-18.68-5.886 0-11.306 2.78-14.882 7.59a7.972 7.972 0 0 1-6.402 3.25h-0.016a8.044 8.044 0 0 1-6.42-3.218c-3.592-4.844-9.028-7.622-14.916-7.622z"
        fill=""
      />
      <path
        d="M935.806 520.14h-63.97a7.998 7.998 0 0 1-5.654-2.342l-13.65-13.65h-12.682a7.99 7.99 0 0 1-7.996-7.996v-47.978a7.99 7.99 0 0 1 7.996-7.996c-0.062 0 10.762-0.602 26.832-14.12 17.226-14.494 29.612-44.566 29.736-44.87a7.996 7.996 0 0 1 7.402-4.982h15.992a7.99 7.99 0 0 1 7.996 7.996v39.982h7.998c2.124 0 4.154 0.844 5.654 2.342 19.194 19.194 19.194 72.076 0 91.272a7.998 7.998 0 0 1-5.654 2.342z m-60.66-15.992h56.974c10.198-14.198 10.198-49.774 0-63.97h-12.308a7.992 7.992 0 0 1-7.996-7.996V392.2h-2.78c-4.638 10.058-16.258 32.798-32.048 46.096-12.292 10.332-22.536 14.698-29.142 16.54v33.32h7.998c2.124 0 4.152 0.844 5.652 2.342l13.65 13.65z"
        fill=""
      />
      <path
        d="M839.85 520.14h-47.978a7.992 7.992 0 0 1-7.996-7.996v-79.962a7.994 7.994 0 0 1 7.996-7.998h47.978a7.992 7.992 0 0 1 7.996 7.998v79.962a7.99 7.99 0 0 1-7.996 7.996z m-39.982-15.992h31.986v-63.97h-31.986v63.97z"
        fill=""
      />
      <path
        d="M751.39 248.266c-25.3 0-31.984-15.688-31.984-23.99a7.992 7.992 0 0 1 7.996-7.998 8.01 8.01 0 0 1 7.996 7.802c0.094 1.444 1.388 8.192 15.992 8.192 14.71 0 15.898-6.856 15.992-8.222 0.282-4.302 4.514-7.504 8.246-7.622 4.31 0.14 7.746 3.53 7.746 7.848 0.002 8.302-6.682 23.99-31.984 23.99z"
        fill=""
      />
      <path
        d="M959.794 199.99c-35.282 0-63.97-28.698-63.97-63.97s28.69-63.97 63.97-63.97c35.266 0 63.97 28.698 63.97 63.97 0.002 35.272-28.704 63.97-63.97 63.97z m0-111.948c-26.458 0-47.978 21.52-47.978 47.978s21.522 47.978 47.978 47.978 47.978-21.522 47.978-47.978-21.52-47.978-47.978-47.978z"
        fill=""
      />
      <path
        d="M959.794 231.976c-35.282 0-63.97-28.698-63.97-63.97 0-4.42 3.576-7.998 7.996-7.998s7.996 3.578 7.996 7.998c0 26.456 21.522 47.978 47.978 47.978s47.978-21.522 47.978-47.978c0-4.42 3.576-7.998 7.996-7.998s7.996 3.578 7.996 7.998c0.002 35.272-28.704 63.97-63.97 63.97z"
        fill=""
      />
      <path
        d="M959.794 168.006a7.992 7.992 0 0 1-7.996-7.998V112.032c0-4.42 3.576-7.996 7.996-7.996s7.996 3.576 7.996 7.996v47.978a7.99 7.99 0 0 1-7.996 7.996z"
        fill=""
      />
      <path
        d="M983.786 144.016L935.806 144a7.998 7.998 0 1 1 0-15.992l47.978 0.016a7.998 7.998 0 0 1 0.002 15.992zM903.82 176.002a7.992 7.992 0 0 1-7.996-7.996V136.02c0-4.42 3.576-7.996 7.996-7.996s7.996 3.576 7.996 7.996v31.986a7.992 7.992 0 0 1-7.996 7.996zM1015.77 176.002a7.992 7.992 0 0 1-7.996-7.996V136.02c0-4.42 3.576-7.996 7.996-7.996s7.996 3.576 7.996 7.996v31.986a7.992 7.992 0 0 1-7.996 7.996z"
        fill=""
      />
    </svg>
  ),
  idea: (
    <svg
      xmlns="http://www.w3.org/2000/svg"
      width="100%"
      height="100%"
      className="pointer-events-none"
      viewBox="0 0 73.2 79.11">
      <g>
        <g>
          <g>
            <path
              d="m70.48,65.9c2.01,3.26,2.63,6.07,1.51,8.01-3.11,5.36-18.28,2.52-35.4-6.17,2.07-1.04,4.17-2.17,6.28-3.39,6.02-3.48,11.42-7.21,15.91-10.89l.14.17c3.79,3.12,6.94,6.2,9.24,9.04-.48.36-.78.93-.78,1.57,0,1.1.89,1.99,1.99,1.99.41,0,.78-.13,1.1-.33Z"
              style={{
                fill: "none",
                stroke: "#000",
                strokeLinecap: "round",
                strokeLinejoin: "round",
                strokeWidth: "1.3px",
              }}
            />
            <path
              d="m69.38,62.26c1.09,0,1.99.89,1.99,1.98,0,.69-.35,1.3-.89,1.66-.32.21-.69.33-1.1.33-1.1,0-1.99-.89-1.99-1.99,0-.64.3-1.21.78-1.57.33-.25.75-.41,1.21-.41Z"
              style={{
                fill: "none",
                stroke: "#000",
                strokeLinecap: "round",
                strokeLinejoin: "round",
                strokeWidth: "1.3px",
              }}
            />
            <path
              d="m68.08,30.36c0,.09,0,.17-.02.25-.12.97-.96,1.72-1.96,1.72-1.1,0-1.99-.89-1.99-1.98v-.02c0-1.09.9-1.96,1.99-1.96s1.98.88,1.98,1.98Z"
              style={{
                fill: "none",
                stroke: "#000",
                strokeLinecap: "round",
                strokeLinejoin: "round",
                strokeWidth: "1.3px",
              }}
            />
            <path
              d="m51.7,22.34c0,4.93-2.48,9.28-6.25,11.89v2.6h-16.44v-2.6c-3.76-2.61-6.24-6.96-6.24-11.89,0-7.98,6.48-14.46,14.46-14.46s14.46,6.48,14.46,14.46Zm-13.34-.73l1.47-.19c-.11-.58-.34-1.03-.7-1.38-.37-.33-.85-.56-1.47-.62v-.57h-.84v.57c-.65.07-1.18.31-1.57.74-.4.43-.59.96-.59,1.59s.16,1.14.52,1.59c.35.44.91.76,1.64.97v2.41c-.2-.1-.39-.26-.55-.48-.17-.22-.29-.49-.35-.8l-1.5.19c.12.75.39,1.32.8,1.73.42.41.94.66,1.61.74v1.05h.84v-1.07c.76-.12,1.35-.41,1.76-.89.43-.47.65-1.05.65-1.75,0-.61-.18-1.12-.51-1.53-.34-.39-.96-.71-1.9-.96v-2.25c.38.16.62.47.7.93Z"
              style={{
                fill: "none",
                stroke: "#000",
                strokeLinecap: "round",
                strokeLinejoin: "round",
                strokeWidth: "1.3px",
              }}
            />
            <polygon
              points="45.46 42.61 45.46 45.27 42.6 45.27 31.88 45.27 29.02 45.27 29.02 43.43 29.02 42.61 45.46 42.61"
              style={{
                fill: "none",
                stroke: "#000",
                strokeLinecap: "round",
                strokeLinejoin: "round",
                strokeWidth: "1.3px",
              }}
            />
            <rect
              x="29.02"
              y="39.85"
              width="16.44"
              height="2.77"
              style={{
                fill: "none",
                stroke: "#000",
                strokeLinecap: "round",
                strokeLinejoin: "round",
                strokeWidth: "1.3px",
              }}
            />
            <rect
              x="29.02"
              y="36.84"
              width="16.44"
              height="3.01"
              style={{
                fill: "none",
                stroke: "#000",
                strokeLinecap: "round",
                strokeLinejoin: "round",
                strokeWidth: "1.3px",
              }}
            />
            <polygon
              points="42.6 45.27 42.6 50.13 38.97 50.13 35.52 50.13 31.88 50.13 31.88 45.27 42.6 45.27"
              style={{
                fill: "none",
                stroke: "#000",
                strokeLinecap: "round",
                strokeLinejoin: "round",
                strokeWidth: "1.3px",
              }}
            />
            <path
              d="m39.83,21.42l-1.47.19c-.09-.46-.32-.77-.7-.93v2.25c.94.25,1.56.57,1.9.96.33.41.51.92.51,1.53,0,.7-.22,1.29-.65,1.75-.42.48-1,.77-1.76.89v1.07h-.84v-1.05c-.66-.08-1.19-.33-1.61-.74-.41-.41-.68-.99-.8-1.73l1.5-.19c.07.31.19.58.35.8.17.21.35.38.55.48v-2.41c-.74-.21-1.29-.54-1.64-.97-.35-.45-.52-.97-.52-1.59s.2-1.16.59-1.59c.39-.43.92-.67,1.57-.74v-.57h.84v.57c.62.07,1.1.29,1.47.62.36.35.59.81.7,1.38Zm-1.19,4.22c0-.25-.08-.48-.22-.65-.16-.19-.41-.33-.76-.44v2.26c.29-.07.54-.2.71-.41.17-.21.27-.47.27-.76Zm-1.82-2.97v-2c-.22.08-.4.21-.53.39-.14.19-.2.4-.2.61s.05.39.17.57c.12.18.3.31.55.43Z"
              style={{ fill: "none", strokeWidth: "0px" }}
            />
            <rect
              x="35.52"
              y="50.13"
              width="3.45"
              height="4.22"
              style={{
                fill: "none",
                stroke: "#000",
                strokeLinecap: "round",
                strokeLinejoin: "round",
                strokeWidth: "1.3px",
              }}
            />
            <path
              d="m38.42,24.98c.15.18.22.4.22.65,0,.29-.1.55-.27.76-.17.2-.42.34-.71.41v-2.26c.35.11.6.24.76.44Z"
              style={{
                fill: "none",
                stroke: "#000",
                strokeLinecap: "round",
                strokeLinejoin: "round",
                strokeWidth: "1.3px",
              }}
            />
            <path
              d="m36.82,20.67v2c-.24-.12-.43-.25-.55-.43-.12-.17-.17-.36-.17-.57s.06-.43.2-.61c.13-.17.3-.31.53-.39Z"
              style={{
                fill: "none",
                stroke: "#000",
                strokeLinecap: "round",
                strokeLinejoin: "round",
                strokeWidth: "1.3px",
              }}
            />
            <path
              d="m29.02,36.84v6.6h-.1c-5.44,3.24-10.34,6.66-14.47,10.04h0C4.32,45.21-1.2,37.21,1.21,33.04c1.48-2.58,5.77-3.26,11.73-2.3-.02.12-.03.23-.03.36,0,1.1.89,1.99,1.99,1.99.94,0,1.73-.66,1.94-1.55,3.61.89,7.64,2.24,11.92,4.03h.26v1.26Z"
              style={{
                fill: "none",
                stroke: "#000",
                strokeLinecap: "round",
                strokeLinejoin: "round",
                strokeWidth: "1.3px",
              }}
            />
            <path
              d="m12.94,30.74c.18-.93.98-1.63,1.96-1.63,1.09,0,1.99.9,1.99,1.99,0,.16-.02.3-.05.44-.21.89-1,1.55-1.94,1.55-1.1,0-1.99-.89-1.99-1.99,0-.13,0-.24.03-.36Z"
              style={{
                fill: "none",
                stroke: "#000",
                strokeLinecap: "round",
                strokeLinejoin: "round",
                strokeWidth: "1.3px",
              }}
            />
            <path
              d="m7.91,76.47s0,.1-.01.15c-.07,1.03-.92,1.84-1.97,1.84s-1.98-.89-1.98-1.99c0-.16.02-.3.05-.45.2-.88.99-1.53,1.93-1.53,1.1,0,1.98.89,1.98,1.98Z"
              style={{
                fill: "none",
                stroke: "#000",
                strokeLinecap: "round",
                strokeLinejoin: "round",
                strokeWidth: "1.3px",
              }}
            />
          </g>
          <g>
            <path
              d="m31.88,45.27h-2.86v-11.04c-3.76-2.61-6.24-6.96-6.24-11.89,0-7.98,6.48-14.46,14.46-14.46s14.46,6.48,14.46,14.46c0,4.93-2.48,9.28-6.25,11.89v11.04h-2.86"
              style={{
                fill: "none",
                stroke: "#000",
                strokeLinecap: "round",
                strokeLinejoin: "round",
                strokeWidth: "1.3px",
              }}
            />
            <path
              d="m3.99,76.02c-1.28-.45-2.23-1.15-2.78-2.12-2.41-4.15,3.12-12.14,13.23-20.43h0c4.13-3.39,9.03-6.81,14.47-10.05"
              style={{
                fill: "none",
                stroke: "#000",
                strokeLinecap: "round",
                strokeLinejoin: "round",
                strokeWidth: "1.3px",
              }}
            />
            <path
              d="m68.07,30.62c1.86.39,3.21,1.19,3.93,2.43,2.4,4.15-3.11,12.14-13.21,20.41-4.49,3.68-9.89,7.42-15.91,10.89-2.11,1.22-4.21,2.35-6.28,3.39-11.44,5.81-22.01,9-28.69,8.88"
              style={{
                fill: "none",
                stroke: "#000",
                strokeLinecap: "round",
                strokeLinejoin: "round",
                strokeWidth: "1.3px",
              }}
            />
            <path
              d="m45.61,35.09c7.23-2.91,13.7-4.57,18.5-4.75"
              style={{
                fill: "none",
                stroke: "#000",
                strokeLinecap: "round",
                strokeLinejoin: "round",
                strokeWidth: "1.3px",
              }}
            />
            <path
              d="m68.17,62.67c-2.3-2.85-5.45-5.93-9.24-9.04"
              style={{
                fill: "none",
                stroke: "#000",
                strokeLinecap: "round",
                strokeLinejoin: "round",
                strokeWidth: "1.3px",
              }}
            />
            <path
              d="m12.94,30.74c-5.96-.96-10.24-.28-11.73,2.3-2.41,4.16,3.11,12.16,13.23,20.44,4.48,3.67,9.88,7.4,15.88,10.87,2.11,1.22,4.21,2.35,6.28,3.39,17.11,8.69,32.29,11.53,35.4,6.17,1.12-1.94.5-4.75-1.51-8.01"
              style={{
                fill: "none",
                stroke: "#000",
                strokeLinecap: "round",
                strokeLinejoin: "round",
                strokeWidth: "1.3px",
              }}
            />
            <path
              d="m28.75,35.58c-4.28-1.79-8.31-3.15-11.92-4.03"
              style={{
                fill: "none",
                stroke: "#000",
                strokeLinecap: "round",
                strokeLinejoin: "round",
                strokeWidth: "1.3px",
              }}
            />
            <line
              x1="36.35"
              y1=".65"
              x2="36.35"
              y2="5.54"
              style={{
                fill: "none",
                stroke: "#000",
                strokeLinecap: "round",
                strokeLinejoin: "round",
                strokeWidth: "1.3px",
              }}
            />
            <line
              x1="43.49"
              y1="1.37"
              x2="42.23"
              y2="6.11"
              style={{
                fill: "none",
                stroke: "#000",
                strokeLinecap: "round",
                strokeLinejoin: "round",
                strokeWidth: "1.3px",
              }}
            />
            <line
              x1="50.19"
              y1="3.92"
              x2="47.76"
              y2="8.17"
              style={{
                fill: "none",
                stroke: "#000",
                strokeLinecap: "round",
                strokeLinejoin: "round",
                strokeWidth: "1.3px",
              }}
            />
            <line
              x1="22.74"
              y1="4.73"
              x2="25.19"
              y2="8.97"
              style={{
                fill: "none",
                stroke: "#000",
                strokeLinecap: "round",
                strokeLinejoin: "round",
                strokeWidth: "1.3px",
              }}
            />
            <line
              x1="29.29"
              y1="1.8"
              x2="30.54"
              y2="6.53"
              style={{
                fill: "none",
                stroke: "#000",
                strokeLinecap: "round",
                strokeLinejoin: "round",
                strokeWidth: "1.3px",
              }}
            />
            <path
              d="m30.76,28.21l-2.96,1.16-.81-1.41,2.48-1.98c-.21-.55-.37-1.12-.46-1.71l-3.15-.47v-1.64l3.15-.48c.09-.59.24-1.16.46-1.71l-2.48-1.98.81-1.42,2.96,1.16c.37-.46.79-.88,1.25-1.24l-1.16-2.96,1.41-.82,1.98,2.47c.55-.2,1.12-.35,1.72-.46l.47-3.14h1.64l.47,3.14c.59.1,1.17.25,1.71.46l1.98-2.47,1.41.82-1.16,2.96c.46.36.88.78,1.24,1.24l2.96-1.16.82,1.42-2.49,1.98c.22.55.36,1.12.45,1.71l3.16.48v1.63l-3.16.48c-.09.58-.23,1.16-.45,1.71l2.49,1.98-.82,1.41-2.96-1.16"
              style={{
                fill: "none",
                stroke: "#000",
                strokeLinecap: "round",
                strokeLinejoin: "round",
                strokeWidth: "1.3px",
              }}
            />
            <polyline
              points="26.9 36.84 29.02 36.84 45.46 36.84 47.58 36.84"
              style={{
                fill: "none",
                stroke: "#000",
                strokeLinecap: "round",
                strokeLinejoin: "round",
                strokeWidth: "1.3px",
              }}
            />
            <polyline
              points="26.9 39.85 29.02 39.85 45.46 39.85 47.58 39.85"
              style={{
                fill: "none",
                stroke: "#000",
                strokeLinecap: "round",
                strokeLinejoin: "round",
                strokeWidth: "1.3px",
              }}
            />
            <polyline
              points="26.9 42.61 29.02 42.61 45.46 42.61 47.58 42.61"
              style={{
                fill: "none",
                stroke: "#000",
                strokeLinecap: "round",
                strokeLinejoin: "round",
                strokeWidth: "1.3px",
              }}
            />
            <polyline
              points="35.52 50.13 31.88 50.13 31.88 45.27 42.6 45.27 42.6 50.13 38.97 50.13"
              style={{
                fill: "none",
                stroke: "#000",
                strokeLinecap: "round",
                strokeLinejoin: "round",
                strokeWidth: "1.3px",
              }}
            />
            <rect
              x="35.52"
              y="50.13"
              width="3.45"
              height="4.22"
              style={{
                fill: "none",
                stroke: "#000",
                strokeLinecap: "round",
                strokeLinejoin: "round",
                strokeWidth: "1.3px",
              }}
            />
            <path
              d="m12.94,30.74c.18-.93.98-1.63,1.96-1.63,1.09,0,1.99.9,1.99,1.99,0,.16-.02.3-.05.44-.21.89-1,1.55-1.94,1.55-1.1,0-1.99-.89-1.99-1.99,0-.13,0-.24.03-.36Z"
              style={{
                fill: "none",
                stroke: "#000",
                strokeLinecap: "round",
                strokeLinejoin: "round",
                strokeWidth: "1.3px",
              }}
            />
            <path
              d="m68.17,62.67c.33-.25.75-.41,1.21-.41,1.09,0,1.99.89,1.99,1.98,0,.69-.35,1.3-.89,1.66-.32.21-.69.33-1.1.33-1.1,0-1.99-.89-1.99-1.99,0-.64.3-1.21.78-1.57Z"
              style={{
                fill: "none",
                stroke: "#000",
                strokeLinecap: "round",
                strokeLinejoin: "round",
                strokeWidth: "1.3px",
              }}
            />
            <path
              d="m4,76.02c.2-.88.99-1.53,1.93-1.53,1.1,0,1.98.89,1.98,1.98,0,.05,0,.1-.01.15-.07,1.03-.92,1.84-1.97,1.84s-1.98-.89-1.98-1.99c0-.16.02-.3.05-.45Z"
              style={{
                fill: "none",
                stroke: "#000",
                strokeLinecap: "round",
                strokeLinejoin: "round",
                strokeWidth: "1.3px",
              }}
            />
            <path
              d="m64.11,30.34c0-1.09.9-1.96,1.99-1.96s1.98.88,1.98,1.98c0,.09,0,.17-.02.25-.12.97-.96,1.72-1.96,1.72-1.1,0-1.99-.89-1.99-1.98v-.02Z"
              style={{
                fill: "none",
                stroke: "#000",
                strokeLinecap: "round",
                strokeLinejoin: "round",
                strokeWidth: "1.3px",
              }}
            />
          </g>
        </g>
      </g>
    </svg>
  ),
  indicator: (
    <svg
      xmlns="http://www.w3.org/2000/svg"
      width="100%"
      height="100%"
      className="pointer-events-none"
      viewBox="0 0 1024 1024">
      <path
        d="M886.6 657.2h-16.8v-7.6l-0.7-7.6 0.7-0.1v-0.7h7.7l7.6-0.7zM853.8 657.2h-16v-16h16v16z m-32.1 0h-16v-16h16v16z m-32.1 0h-16v-16h16v16z m-32 0h-16v-16h16v16z m-32.1 0h-16v-16h16v16z m-32.1 0h-16v-16h16v16z m-32.1 0h-16v-16h16v16z m-32.1 0h-16v-16h16v16z m-32 0h-16v-16h16v16z m-32.1 0h-16v-16h16v16z m-32.1 0h-16v-16h16v16z m-32.1 0h-16v-16h16v16z m-32 0h-16v-16h16v16zM436.8 657.2h-18.2l4.3-17.7 6.9 1.7h7v1.8l1.7 0.4-1.7 6.8zM442.3 627.7l-15.5-3.8 3.9-15.7 15.5 3.8-3.9 15.7z m7.8-31.4l-15.5-3.8 3.9-15.7 15.5 3.8-3.9 15.7z m7.7-31.4l-15.5-3.8 3.9-15.7 15.5 3.8-3.9 15.7z m7.7-31.4l-15.5-3.8 3.9-15.7 15.5 3.8-3.9 15.7z m7.8-31.4l-15.5-3.8 3.9-15.7 15.5 3.8-3.9 15.7z m7.7-31.4l-15.5-3.8 3.9-15.7 15.5 3.8-3.9 15.7z m7.7-31.4l-15.5-3.8 3.9-15.7 15.5 3.8-3.9 15.7z m7.7-31.5l-15.5-3.8 3.9-15.7 15.5 3.8-3.9 15.7zM504.2 376.4l-15.6-3.8 3.4-13.8h14.3v16h-1.7zM923.3 374.8h-16v-16h16v16z m-32.1 0h-16v-16h16v16z m-32 0h-16v-16h16v16z m-32.1 0h-16v-16h16v16z m-32.1 0h-16v-16h16v16z m-32.1 0h-16v-16h16v16z m-32 0h-16v-16h16v16z m-32.1 0h-16v-16h16v16z m-32.1 0h-16v-16h16v16z m-32.1 0h-16v-16h16v16z m-32.1 0h-16v-16h16v16z m-32 0h-16v-16h16v16z m-32.1 0h-16v-16h16v16zM950.2 377.7l-5-2.9h-5.8v-3.4l-3-1.8 3-5v-5.8h21.9zM867.8 626.8l-1.4-15.2 15.9-1.4 1.4 15.2-15.9 1.4z m-2.8-30.3l-1.4-15.2 15.9-1.4 1.4 15.2-15.9 1.4z m-2.8-30.3l-1.4-15.2 15.9-1.4 1.4 15.2-15.9 1.4z m-2.7-30.4l-1.4-15.2 15.9-1.4 1.4 15.2-15.9 1.4z m14-26.6l-13.8-8.1 7.7-13.2 13.8 8.1-7.7 13.2z m15.4-26.3l-13.8-8.1 7.7-13.2 13.8 8.1-7.7 13.2z m15.3-26.3l-13.8-8.1 7.7-13.2 13.8 8.1-7.7 13.2z m15.3-26.3l-13.8-8.1 7.7-13.2 13.8 8.1-7.7 13.2z m15.4-26.3l-13.8-8.1 7.7-13.2 13.8 8.1-7.7 13.2z"
        fill="#0A0408"
      />
      <path d="M795.3 649.2h-413l69.5-282.4h413.1L778.5 508z" fill="#EBB866" />
      <path
        d="M804.3 657.2H372.1l73.5-298.5h433.6l-92.4 151 17.5 147.5z m-411.8-16h393.8l-16.1-135 80.4-131.4H458.1l-65.6 266.4z"
        fill="#0A0408"
      />
      <path d="M238.4 855.7h-66.1l202.5-750.5H441z" fill="#55B7A8" />
      <path
        d="M244.5 863.7h-82.7L368.7 97.2h82.7L244.5 863.7z m-61.8-16h49.6l198.2-734.5H381L182.7 847.7z"
        fill="#0A0408"
      />
      <path d="M693.7 508h-453l69.5-282.5h453z" fill="#EBB866" />
      <path
        d="M700 516H230.5L304 217.5h469.5L700 516z m-449.1-16h436.6L753 233.5H316.5L250.9 500z"
        fill="#0A0408"
      />
      <path d="M115.6 850.1h189.8v68.8H115.6z" fill="#68A4D9" />
      <path
        d="M313.4 926.9H107.6v-84.8h205.8v84.8z m-189.8-16h173.8v-52.8H123.6v52.8z"
        fill="#0A0408"
      />
      <path
        d="M65.6 910.9h289.8v16H65.6zM278.6 358.8h232.7v16H278.6z"
        fill="#0A0408"
      />
    </svg>
  ),
  interfaceControl: (
    <svg
      xmlns="http://www.w3.org/2000/svg"
      width="100%"
      height="100%"
      className="pointer-events-none"
      viewBox="0 0 1024 1024">
      <path
        d="M594.7 800.4H272.4c-10.7 0-19.4 8.7-19.4 19.4s8.7 19.4 19.4 19.4h322.3c10.7 0 19.4-8.7 19.4-19.4 0-10.8-8.7-19.4-19.4-19.4z"
        fill="#005BFF"
      />
      <path d="M912.9 771.4v39H968c-8.1-22.7-29.7-39-55.1-39z" fill="#E6E6E6" />
      <path
        d="M815.6 675.9V235.2c0-16.1-13.1-29.1-29.1-29.1H80.6c-16.1 0-29.1 13.1-29.1 29.1v440.7c0 16.1 13.1 29.1 29.1 29.1h705.9c16.1 0.1 29.1-13 29.1-29.1z m-43.9-42c0 16-13.1 29.1-29.1 29.1h-618c-16 0-29.1-13.1-29.1-29.1V277.3c0-16 13.1-29.1 29.1-29.1h618c16 0 29.1 13.1 29.1 29.1v356.6z"
        fill="#FFFFFF"
      />
      <path
        d="M742.6 248.2h-618c-16 0-29.1 13.1-29.1 29.1v356.6c0 16 13.1 29.1 29.1 29.1h618c16 0 29.1-13.1 29.1-29.1V277.3c0-16-13.1-29.1-29.1-29.1z m-523.3 32.2c0-1.6 1.3-2.8 2.8-2.8h61.3c1.6 0 2.8 1.3 2.8 2.8v17.5c0 1.6-1.3 2.8-2.8 2.8h-61.3c-1.6 0-2.8-1.3-2.8-2.8v-17.5z m-30.3-3.5c6.6 0 11.9 5.3 11.9 11.9s-5.3 11.9-11.9 11.9c-6.6 0-11.9-5.3-11.9-11.9s5.4-11.9 11.9-11.9z m-39 0c6.6 0 11.9 5.3 11.9 11.9s-5.3 11.9-11.9 11.9c-6.6 0-11.9-5.3-11.9-11.9s5.3-11.9 11.9-11.9z m237.3 181.7c0 67.8-55.2 123-123 123s-123-55.2-123-123 55.2-123 123-123h9.7v113.3h113.3v9.7z m-90.1-38.7v-94.7c52.3 0 94.7 42.4 94.7 94.7h-94.7z m373.6 148.9H530.1c-5.4 0-9.7-4.3-9.7-9.7 0-5.4 4.3-9.7 9.7-9.7h140.7c5.4 0 9.7 4.3 9.7 9.7 0 5.3-4.3 9.7-9.7 9.7z m0-73.3H525.2c-5.4 0-9.7-4.3-9.7-9.7s4.3-9.7 9.7-9.7h145.6c5.4 0 9.7 4.3 9.7 9.7s-4.3 9.7-9.7 9.7z m0-73.4H461.2c-5.4 0-9.7-4.3-9.7-9.7s4.3-9.7 9.7-9.7h209.7c5.4 0 9.7 4.3 9.7 9.7s-4.4 9.7-9.8 9.7z m0-73.3H461.2c-5.4 0-9.7-4.3-9.7-9.7s4.3-9.7 9.7-9.7h209.7c5.4 0 9.7 4.3 9.7 9.7s-4.4 9.7-9.8 9.7z"
        fill="#E6E6E6"
      />
      <path
        d="M254.6 355.5c-52.6 4.9-93.9 49.3-93.9 103.1 0 57.1 46.5 103.6 103.6 103.6 53.8 0 98.2-41.3 103.1-93.9H254.6V355.5z"
        fill="#FFFFFF"
      />
      <path
        d="M274 335.6h-9.7c-67.8 0-123 55.2-123 123s55.2 123 123 123 123-55.2 123-123v-9.7H274V335.6z m93.4 132.8c-4.9 52.6-49.3 93.9-103.1 93.9-57.1 0-103.6-46.5-103.6-103.6 0-53.8 41.3-98.2 93.9-103.1v112.8h112.8z"
        fill="#005BFF"
      />
      <path
        d="M297.2 325.2v94.7h94.7c0-52.3-42.4-94.7-94.7-94.7z"
        fill="#005BFF"
      />
      <path
        d="M150 288.8m-11.9 0a11.9 11.9 0 1 0 23.8 0 11.9 11.9 0 1 0-23.8 0Z"
        fill="#FFFFFF"
      />
      <path
        d="M189 288.8m-11.9 0a11.9 11.9 0 1 0 23.8 0 11.9 11.9 0 1 0-23.8 0Z"
        fill="#FFFFFF"
      />
      <path
        d="M222.1 300.7h61.3c1.6 0 2.8-1.3 2.8-2.8v-17.5c0-1.6-1.3-2.8-2.8-2.8h-61.3c-1.6 0-2.8 1.3-2.8 2.8v17.5c0 1.6 1.3 2.8 2.8 2.8z"
        fill="#FFFFFF"
      />
      <path
        d="M912.9 732.5c-47 0-86.3 33.5-95.3 77.8H701.9c-11.7 0-20.2-2.3-23.2-6.3-2-2.7-2-7-2-9v-51.1h109.9c37.5 0 67.9-30.5 67.9-67.9V235.2c0-37.5-30.5-67.9-67.9-67.9h-706c-37.5 0-67.9 30.5-67.9 67.9v440.7c0 37.5 30.5 67.9 67.9 67.9h557.2V795c0 4.8 0 19.3 9.9 32.4 10.9 14.4 29.1 21.7 54.2 21.7h308.2v-19.4c0-53.6-43.6-97.2-97.2-97.2zM80.6 705.1c-16.1 0-29.1-13.1-29.1-29.1V235.2c0-16.1 13.1-29.1 29.1-29.1h705.9c16.1 0 29.1 13.1 29.1 29.1v440.7c0 16.1-13.1 29.1-29.1 29.1H80.6z m832.3 105.2h-55.1c8-22.7 29.7-39 55.1-39s47.1 16.3 55.1 39h-55.1z"
        fill="#005BFF"
      />
      <path
        d="M670.8 329.4H461.2c-5.4 0-9.7 4.3-9.7 9.7s4.3 9.7 9.7 9.7h209.7c5.4 0 9.7-4.3 9.7-9.7s-4.4-9.7-9.8-9.7z"
        fill="#005BFF"
      />
      <path
        d="M670.8 402.7H461.2c-5.4 0-9.7 4.3-9.7 9.7s4.3 9.7 9.7 9.7h209.7c5.4 0 9.7-4.3 9.7-9.7s-4.4-9.7-9.8-9.7zM670.8 476.1H525.2c-5.4 0-9.7 4.3-9.7 9.7s4.3 9.7 9.7 9.7h145.6c5.4 0 9.7-4.3 9.7-9.7s-4.3-9.7-9.7-9.7z"
        fill="#06F3FF"
      />
      <path
        d="M670.8 549.4H530.1c-5.4 0-9.7 4.3-9.7 9.7 0 5.4 4.3 9.7 9.7 9.7h140.7c5.4 0 9.7-4.3 9.7-9.7 0-5.4-4.3-9.7-9.7-9.7z"
        fill="#005BFF"
      />
    </svg>
  ),
  people: (
    <svg
      xmlns="http://www.w3.org/2000/svg"
      width="100%"
      height="100%"
      className="pointer-events-none"
      viewBox="0 0 1024 1024"
      fill="#000000">
      <path
        d="M512.308 751.564c-4.422 0-8.078-3.578-8.078-8 0-4.42 3.5-7.998 7.906-7.998h0.172a8.004 8.004 0 0 1 7.998 7.998c0 4.422-3.592 8-7.998 8zM512.308 799.558c-4.422 0-8.078-3.578-8.078-8 0-4.42 3.5-7.998 7.906-7.998h0.172a8.004 8.004 0 0 1 7.998 7.998c0 4.422-3.592 8-7.998 8zM512.308 847.552c-4.422 0-8.078-3.578-8.078-8s3.5-8 7.906-8h0.172c4.406 0 7.998 3.578 7.998 8s-3.592 8-7.998 8z"
        fill=""
      />
      <path
        d="M839.774 879.546H183.866c-4.42 0-8-3.576-8-7.998v-79.74c0-48.338 24.856-66.788 70.71-83.942 24.528-9.156 79.02-30.512 109.72-45.712a8.012 8.012 0 0 1 10.718 3.624 8.004 8.004 0 0 1-3.624 10.716c-31.276 15.482-86.426 37.104-111.22 46.37-40.854 15.264-60.304 29.48-60.304 68.944v71.74h639.908v-71.74c0-39.462-19.434-53.68-60.304-68.944-24.746-9.25-79.832-30.84-111.204-46.37a7.988 7.988 0 0 1-3.624-10.716c1.938-3.984 6.782-5.562 10.718-3.624 30.778 15.248 85.208 36.572 109.704 45.712 45.87 17.154 70.71 35.604 70.71 83.942v79.74a7.984 7.984 0 0 1-8 7.998z"
        fill=""
      />
      <path
        d="M511.824 687.572c-75.334 0-199.974-116.062-199.974-248.334 0-4.42 3.578-8 8-8s8 3.578 8 8c0 119.806 114.766 232.336 183.976 232.336 69.202 0 183.968-112.532 183.968-232.336 0-4.42 3.592-8 7.998-8a7.984 7.984 0 0 1 7.998 8c0 132.272-124.64 248.334-199.966 248.334z"
        fill=""
      />
      <path
        d="M319.848 431.614a8.016 8.016 0 0 1-7.968-7.25c-6.968-74.436 9.186-133.81 48.042-176.47 57.68-63.334 152.324-76.63 221.542-76.63 39.15 0 66.46 4.296 67.618 4.484a8.032 8.032 0 0 1 6.686 6.976 8.012 8.012 0 0 1-4.906 8.32c-36.306 14.928-32.306 50.22-29.09 64.196 14.624-0.438 45.278 2.804 67.93 29.278 24.622 28.762 32.028 75.974 21.996 140.334a7.968 7.968 0 0 1-6.092 6.554 7.904 7.904 0 0 1-8.342-3.204l-52.212-74.544c-18.342 7.992-74.208 29.964-133.646 29.964-59.352 0-114.58-21.91-132.828-29.942l-52.18 74.522a8.008 8.008 0 0 1-6.55 3.412z m327.95-95.988c2.53 0 5.03 1.21 6.56 3.414l44.15 63.086c5-49.088-2.03-85.09-20.934-107.206-17.686-20.622-41.462-23.7-54.088-23.7-3.876 0-6.31 0.304-6.56 0.336-3.718 0.492-7.406-1.696-8.688-5.296-6.466-18.638-9.31-54.368 15.874-77.224a513.33 513.33 0 0 0-42.65-1.774c-65.998 0-155.956 12.39-209.714 71.406-31.746 34.862-46.948 82.418-45.322 141.598l42.87-61.226c2.234-3.242 6.516-4.328 10.062-2.6 0.64 0.312 64.71 31.182 132.046 31.182 67.498 0 132.272-30.886 132.928-31.198a8.002 8.002 0 0 1 3.466-0.798zM824.026 543.608c-4.438 0-8.092-3.578-8.092-8s3.498-7.99 7.904-7.99h0.188a7.996 7.996 0 1 1 0 15.99zM823.526 479.608c-26.308 0-60.93-21.842-86.114-54.344a8.016 8.016 0 0 1 1.438-11.226 7.982 7.982 0 0 1 11.216 1.43c21.964 28.348 52.18 48.142 73.458 48.142 39.12 0 103.986-62.656 103.986-129.358 0-4.42 3.594-8 8-8a7.984 7.984 0 0 1 7.998 8c0.002 77.418-74.77 145.356-119.982 145.356z"
        fill=""
      />
      <path
        d="M1016 591.584H695.792c-4.406 0-8-3.576-8-7.998s3.594-7.998 8-7.998H1008v-32.45c0-20.81-7.562-29.34-35.246-39.684-3.716-1.39-8.248-2.898-13.28-4.584l-10.842-3.67a8.01 8.01 0 0 1-4.968-10.178c1.468-4.17 6.094-6.358 10.186-4.944l10.718 3.624c5.216 1.75 9.936 3.328 13.78 4.772C1007.284 499.276 1024 511.682 1024 543.138v40.448a7.984 7.984 0 0 1-8 7.998zM199.974 591.584H7.998A7.994 7.994 0 0 1 0 583.586V530.28c0-31.174 16.576-43.47 45.198-54.164 16.374-6.132 37.462-14.272 55.336-22.8a7.996 7.996 0 0 1 10.67 3.772 8 8 0 0 1-3.764 10.664c-18.434 8.802-39.948 17.098-56.632 23.348C23.482 501.31 16 509.738 16 530.282v45.308h183.976c4.42 0 8 3.576 8 7.998s-3.582 7.996-8.002 7.996z"
        fill=""
      />
      <path
        d="M327.832 591.584H199.974c-4.42 0-8-3.576-8-7.998s3.578-7.998 8-7.998h127.858c4.422 0 8 3.576 8 7.998s-3.578 7.998-8 7.998zM200.458 465.796c-45.198 0-119.968-71.944-119.968-153.934 0-4.422 3.578-8 8-8a7.994 7.994 0 0 1 7.998 8c0 71.124 64.868 137.936 103.972 137.936 21.044 0 51.04-20.826 72.944-50.65 2.656-3.57 7.67-4.304 11.186-1.71a8 8 0 0 1 1.718 11.178c-25.53 34.738-59.228 57.18-85.85 57.18z"
        fill=""
      />
      <path
        d="M168.228 495.606a7.962 7.962 0 0 1-5.656-2.344l-47.994-47.994a8 8 0 0 1 11.312-11.31l43.932 43.932 27.09-13.444a7.988 7.988 0 0 1 10.732 3.61 8.002 8.002 0 0 1-3.61 10.716l-32.246 15.998a8.04 8.04 0 0 1-3.56 0.836z"
        fill=""
      />
      <path
        d="M232.218 495.606a8.06 8.06 0 0 1-3.562-0.836l-32.246-15.998a8.004 8.004 0 0 1-3.61-10.716 7.99 7.99 0 0 1 10.732-3.61l27.09 13.444 43.932-43.932a8 8 0 0 1 11.312 11.31l-47.994 47.994a7.96 7.96 0 0 1-5.654 2.344zM55.992 319.628c-1.376 0-2.75-0.36-3.984-1.07a7.984 7.984 0 0 1-4.014-6.928c-0.016-80.52 40.246-116.718 59.79-129.552l-9.234-8.562a8.012 8.012 0 0 1-2.406-7.474 7.998 7.998 0 0 1 5.156-5.922c4.344-1.546 107.22-37.534 171.322 5.086 29.574 19.662 45.806 52.632 48.274 97.994a7.986 7.986 0 0 1-7.546 8.422c-4.672 0.648-8.186-3.14-8.42-7.546-2.186-40.056-16.03-68.834-41.166-85.55-45.042-29.942-115.344-15.216-144.136-7.288l7.06 6.546a8.034 8.034 0 0 1 2.454 7.226 8.04 8.04 0 0 1-4.734 5.992c-2.312 1.016-54.65 24.934-59.976 106.908 33.776-17.764 129.374-63.312 214.768-58.25a7.986 7.986 0 0 1 6.578 4.21l17.124 31.996a7.996 7.996 0 0 1-3.266 10.828 8.012 8.012 0 0 1-10.828-3.282l-14.982-27.996c-98.018-3.5-212.644 62.46-213.816 63.14a8.06 8.06 0 0 1-4.018 1.072zM199.974 511.604a7.98 7.98 0 0 1-5.656-2.344l-15.998-15.998a7.996 7.996 0 1 1 11.31-11.31l15.998 15.998a7.996 7.996 0 0 1-5.654 13.654z"
        fill=""
      />
      <path
        d="M199.974 511.604a7.996 7.996 0 0 1-5.656-13.654l15.998-15.998a7.996 7.996 0 1 1 11.31 11.31l-15.998 15.998a7.972 7.972 0 0 1-5.654 2.344z"
        fill=""
      />
      <path
        d="M183.992 575.588a7.998 7.998 0 0 1-7.968-8.89l8-71.974c0.484-4.398 4.25-7.57 8.842-7.07a8.004 8.004 0 0 1 7.062 8.836l-8 71.99a8.006 8.006 0 0 1-7.936 7.108z"
        fill=""
      />
      <path
        d="M215.956 575.588a8.004 8.004 0 0 1-7.936-7.11l-8-71.99a8.002 8.002 0 0 1 7.062-8.836 7.96 7.96 0 0 1 8.842 7.07l8 71.974a7.998 7.998 0 0 1-7.968 8.892zM967.758 469.342c-4.406 0-8-3.578-8-8v-149.714c0-4.422 3.594-8 8-8a7.984 7.984 0 0 1 7.998 8v149.714c0 4.424-3.562 8-7.998 8zM694.73 255.636a8.04 8.04 0 0 1-3.562-0.836 8.01 8.01 0 0 1-3.594-10.726c25.872-52.072 78.052-84.426 136.202-84.426 4.438 0 7.998 3.578 7.998 8s-3.56 8-7.998 8c-52.026 0-98.736 28.95-121.86 75.552a8.032 8.032 0 0 1-7.186 4.436z"
        fill=""
      />
      <path
        d="M967.758 319.628c-4.406 0-8-3.578-8-8 0-74.982-60.992-135.982-135.982-135.982-4.406 0-7.998-3.578-7.998-8s3.592-8 7.998-8c83.802 0 151.98 68.178 151.98 151.98a7.986 7.986 0 0 1-7.998 8.002z"
        fill=""
      />
      <path
        d="M743.786 323.064a7.97 7.97 0 0 1-7.686-5.842 7.994 7.994 0 0 1 5.53-9.86c107.33-30.012 183.414-97.018 184.164-97.69a7.968 7.968 0 0 1 11.282 0.648 8.012 8.012 0 0 1-0.624 11.288c-3.188 2.852-79.458 70.116-190.508 101.158-0.722 0.204-1.44 0.298-2.158 0.298z"
        fill=""
      />
      <path
        d="M967.758 335.626a8.06 8.06 0 0 1-2.032-0.266c-77.396-20.372-114.362-60.618-115.892-62.328a8 8 0 0 1 0.594-11.28 7.976 7.976 0 0 1 11.28 0.562c0.344 0.382 35.622 38.504 108.08 57.58a8 8 0 0 1 5.718 9.772 8.006 8.006 0 0 1-7.748 5.96z"
        fill=""
      />
      <path
        d="M935.512 342.25c-4.406 0-8-3.578-8-8v-16.966c0-4.422 3.594-8 8-8a7.984 7.984 0 0 1 7.998 8v16.966c0 4.422-3.562 8-7.998 8z"
        fill=""
      />
      <path
        d="M856.084 575.588a8 8 0 0 1-5.656-13.64l42.056-42.33-10.374-10.358a8.088 8.088 0 0 1-2.312-6.446 8.034 8.034 0 0 1 3.532-5.866l38.276-25.52-22.464-15.788a8.03 8.03 0 0 1-1.938-11.148 8 8 0 0 1 11.156-1.946l32.026 22.514a8.008 8.008 0 0 1 3.376 6.648 7.934 7.934 0 0 1-3.562 6.554l-39.87 26.582 9.092 9.102a8.006 8.006 0 0 1 0.032 11.294l-47.682 47.986a7.97 7.97 0 0 1-5.688 2.362z"
        fill=""
      />
      <path
        d="M791.466 575.588a7.896 7.896 0 0 1-5.654-2.36l-47.682-47.986a7.976 7.976 0 0 1 0-11.294l9.092-9.102-7.874-5.256a8.028 8.028 0 0 1-2.218-11.092 8.014 8.014 0 0 1 11.092-2.218l15.998 10.67a8.034 8.034 0 0 1 3.532 5.866 7.99 7.99 0 0 1-2.312 6.446l-10.342 10.358 42.056 42.33a8 8 0 0 1-0.032 11.312 8.058 8.058 0 0 1-5.656 2.326z"
        fill=""
      />
      <path
        d="M823.776 511.604c-34.902 0-52.9-17.592-53.65-18.342a7.996 7.996 0 0 1 0-11.31c3.124-3.11 8.188-3.118 11.282-0.046 0.562 0.562 14.466 13.702 42.37 13.702s42.212-13.49 42.338-13.63a7.996 7.996 0 0 1 11.312 0.016 7.996 7.996 0 0 1 0 11.31c-0.752 0.738-18.75 18.3-53.652 18.3z"
        fill=""
      />
      <path
        d="M375.842 655.576c-4.422 0-8-3.578-8-7.998v-15.998c0-4.422 3.578-8 8-8a7.994 7.994 0 0 1 7.998 8v15.998a7.994 7.994 0 0 1-7.998 7.998z"
        fill=""
      />
      <path
        d="M439.834 735.566a8.006 8.006 0 0 1-6.25-3l-63.992-79.99a8.01 8.01 0 0 1 1.25-11.248c3.484-2.734 8.5-2.188 11.25 1.25l63.992 79.99a8.01 8.01 0 0 1-1.25 11.248 8.06 8.06 0 0 1-5 1.75z"
        fill=""
      />
      <path
        d="M439.834 735.566a8.02 8.02 0 0 1-7.156-4.422 8.006 8.006 0 0 1 3.578-10.732l63.992-31.996a8.004 8.004 0 0 1 10.734 3.578 8.006 8.006 0 0 1-3.578 10.732l-63.992 31.996a7.972 7.972 0 0 1-3.578 0.844z"
        fill=""
      />
      <path
        d="M647.798 655.576c-4.406 0-8-3.578-8-7.998v-15.998c0-4.422 3.594-8 8-8a7.984 7.984 0 0 1 7.998 8v15.998a7.984 7.984 0 0 1-7.998 7.998z"
        fill=""
      />
      <path
        d="M583.806 735.566c-1.75 0-3.5-0.578-5-1.75a8.026 8.026 0 0 1-1.248-11.248l63.99-79.99a8.042 8.042 0 0 1 11.248-1.25 7.998 7.998 0 0 1 1.25 11.248l-63.992 79.99a7.964 7.964 0 0 1-6.248 3z"
        fill=""
      />
      <path
        d="M583.806 735.566a7.942 7.942 0 0 1-3.562-0.844l-63.998-31.996a8.006 8.006 0 0 1-3.578-10.732 8.02 8.02 0 0 1 10.732-3.578l64 31.996a8.014 8.014 0 0 1 3.56 10.732 7.998 7.998 0 0 1-7.154 4.422z"
        fill=""
      />
    </svg>
  ),
  leaves: (
    <svg
      xmlns="http://www.w3.org/2000/svg"
      width="100%"
      height="100%"
      className="pointer-events-none"
      viewBox="0 0 1024 1024">
      <path
        d="M621.05316 292.412052S350.590068 467.760703 511.112597 698.020115s79.346807 290.895004 79.346807 290.895004 585.599347-335.113642 30.593756-696.503067z"
        fill="#178E3B"
      />
      <path
        d="M592.537225 1023.523833a22.639596 22.639596 0 0 1-19.631084-10.681301c-6.255108-10.497327-3.874271-23.494533 6.287575-30.117589 4.447837-4.729208 52.735541-63.849722-83.956973-259.976588-47.248794-67.723993-64.152737-137.828823-50.343883-208.366533 11.211578-57.226666 43.623429-115.048541 93.729227-167.221339 37.379142-38.959152 71.425113-61.133403 72.821149-62.064094a22.726172 22.726172 0 0 1 24.760706 0c169.006967 110.070427 252.844898 230.205302 249.197889 357.093096C883.930041 693.583101 867.881034 745.636857 837.644403 797.062938c-23.656863 40.236147-56.036247 80.082702-96.229106 118.576509-67.843035 64.931921-134.116882 103.133534-136.908954 104.735187a24.122208 24.122208 0 0 1-11.969118 3.149199z m-12.91063-41.12355z m44.683984-650.693597c-31.524447 23.808371-116.109096 95.320059-134.852777 191.603275-11.27651 57.897629 3.246596 116.23896 43.071507 173.400694 69.260715 99.41077 104.269842 181.809377 103.945183 244.90156v2.759606a755.710157 755.710157 0 0 0 74.325405-62.334643c57.35653-55.083913 126.411627-141.670629 129.214521-241.330305C842.990465 533.92633 770.483154 430.002791 624.310579 331.749973z"
        fill="#203529"
      />
      <path
        d="M468.106022 607.981185a11.373908 11.373908 0 0 1-11.211579-13.267755c16.23298-95.406635 145.728874-173.00028 151.237265-176.257699a11.363086 11.363086 0 1 1 11.568704 19.55533c-1.450146 0.865759-125.93546 75.569933-140.404456 160.52253a11.363086 11.363086 0 0 1-11.189934 9.447594zM528.07065 736.654608a11.373908 11.373908 0 0 1-11.200756-13.365154c14.198447-79.606535 103.360795-144.873937 107.137669-147.611899A11.363086 11.363086 0 0 1 637.372717 594.129042c-0.854937 0.616853-85.493695 62.680947-98.090488 133.186191A11.363086 11.363086 0 0 1 528.07065 736.654608zM588.42487 850.220537a11.363086 11.363086 0 0 1-7.055935-20.280403c65.74357-51.999646 81.500382-137.882933 81.65189-138.737871a11.363086 11.363086 0 0 1 22.390691 3.885094c-0.670963 3.863449-17.185315 95.179373-89.952354 152.698233a11.308976 11.308976 0 0 1-7.034292 2.434947z"
        fill="#203529"
      />
      <path
        d="M528.655038 608.197625a11.363086 11.363086 0 0 1-11.103359-9.014715c-8.938961-42.335612 15.334755-91.467432 16.373666-93.534431a11.363086 11.363086 0 0 1 20.323691 10.172667c-0.21644 0.432879-21.741371 44.17535-14.458174 78.675844A11.373908 11.373908 0 0 1 528.655038 608.197625zM589.07419 727.737291A11.373908 11.373908 0 0 1 577.851789 714.556111l11.135825-68.74126a11.363086 11.363086 0 0 1 22.412334 3.636188l-11.135824 68.741259a11.363086 11.363086 0 0 1-11.189934 9.544993zM704.642186 849.949987a11.373908 11.373908 0 0 1-11.200756-13.332688c6.568946-37.325032-7.575391-60.808744-7.726899-61.046827a11.363086 11.363086 0 1 1 19.338891-11.904185c0.768361 1.25535 18.830257 31.178144 10.821986 76.922682a11.363086 11.363086 0 0 1-11.233222 9.361018zM753.925514 663.617019h-0.205618a11.363086 11.363086 0 0 1-11.157468-11.568704c0.703429-39.240524-21.925345-82.138879-22.152607-82.560937a11.363086 11.363086 0 0 1 20.053141-10.692122c1.082199 1.95878 25.626465 48.590721 24.825638 93.664295a11.363086 11.363086 0 0 1-11.363086 11.157468zM659.114088 489.772624a11.363086 11.363086 0 0 1-6.179355-20.908078c2.445769-1.58001 60.603126-38.363943 114.594018-1.536723a11.363086 11.363086 0 1 1-12.80241 18.776148c-41.707937-28.418537-88.978375 1.5259-89.454543 1.839737a11.308976 11.308976 0 0 1-6.15771 1.828916z"
        fill="#2FA65B"
      />
      <path
        d="M706.059866 373.587774s79.087079 104.129157 71.587443 220.259897c-14.393242 222.846351-106.466706 290.743496-146.85436 299.530949-2.434947-11.319798-5.410993-20.377801-5.410994-20.377801z"
        fill="#2FA65B"
      />
      <path
        d="M618.975339 983.720565a11.363086 11.363086 0 0 1-10.086092-16.590105c0.259728-0.497811 26.156742-51.058133 42.833424-119.518022 15.150781-62.36711 25.626465-152.882207-10.821987-229.945575-31.513625-66.566041-36.686535-144.495167-35.46365-198.150577 1.30946-57.832697 9.880474-99.562278 10.248421-101.358728a11.363086 11.363086 0 0 1 22.250005 4.620988c-0.086576 0.411235-8.560192 41.848623-9.739788 97.711719-1.082199 51.068955 3.744407 125.037235 33.288431 187.447632 17.488331 36.924619 26.600443 79.465849 27.054967 126.444094 0.389592 37.216812-4.588522 77.290629-14.8153 119.12843-17.315179 70.970589-43.493565 121.920503-44.597407 124.052434A11.363086 11.363086 0 0 1 618.975339 983.720565z"
        fill="#203529"
      />
      <path
        d="M751.403991 871.258479a11.373908 11.373908 0 0 1-10.821987-14.804478c15.453797-48.69894 6.233464-97.473635-27.412092-144.852293-25.550711-35.972284-55.906384-57.280776-56.209399-57.497215a11.363086 11.363086 0 1 1 12.986384-18.657105c1.374392 0.952335 33.93775 23.808371 61.761078 62.994785 37.465718 52.746363 48.027977 109.767412 30.550469 164.88379a11.363086 11.363086 0 0 1-10.854453 7.932516zM847.21104 711.839792a11.373908 11.373908 0 0 1-10.692123-7.521281c-36.578315-101.618456-94.064709-149.981914-135.859222-172.664798-44.716449-24.273716-80.623801-24.998789-80.980927-24.99879a11.363086 11.363086 0 0 1 0.281372-22.726172c1.68823 0 41.935199 0.833293 91.543186 27.747574 28.916349 15.691881 55.138022 37.086949 77.918304 63.579172 28.277851 32.866374 51.317861 73.69773 68.470711 121.368582a11.373908 11.373908 0 0 1-10.692123 15.215713z"
        fill="#203529"
      />
      <path
        d="M635.208319 211.182219S217.566206 242.468583 257.001526 605.037605s-90.904689 381.117907-90.904689 381.117907S1042.645298 969.219103 635.208319 211.182219z"
        fill="#178E3B"
      />
      <path
        d="M161.908729 1024c-12.109803 0-22.812748-9.415128-23.397136-21.535754s7.802652-22.531376 19.87999-23.656863c3.246596-0.833293 26.47058-8.051558 47.17304-49.359081 21.752193-43.417811 43.699183-131.865909 24.663308-306.835791-11.395552-104.74601 12.488573-193.518767 70.981411-263.850859 26.719485-32.119657 60.743812-60.289288 101.131466-83.697245 31.892395-18.494775 67.832213-34.10008 106.802187-46.372213 66.133161-20.821503 117.959656-24.89057 120.188985-25.0529a22.726172 22.726172 0 0 1 21.719728 11.904186c122.862016 228.592826 143.58612 415.564291 61.598748 555.784773-33.147745 56.674745-83.145324 105.254643-148.629166 144.386948-51.523479 30.799374-112.721814 55.852274-181.917597 74.46609C265.096372 1021.673273 166.497251 1023.913424 162.363252 1023.989178z m456.298249-773.382461a584.322353 584.322353 0 0 0-96.564588 21.795481c-55.527614 17.618194-132.796599 51.945536-185.640361 115.600463-50.203197 60.46244-70.59182 137.742247-60.603125 229.685846 16.871477 155.111536 5.649077 269.46747-33.364186 339.983536q-4.512768 8.148956-9.187866 14.988452a998.025262 998.025262 0 0 0 138.456498-26.654554c101.109822-27.336339 235.605474-83.837931 302.160692-197.750163 71.825526-122.916126 53.222531-290.299795-55.257064-497.649061z"
        fill="#203529"
      />
      <path
        d="M624.159071 243.496672a22.726172 22.726172 0 0 1-20.713283-32.043903l89.010841-198.042358A22.726172 22.726172 0 0 1 714.923074 0.066902a169.169297 169.169297 0 0 1 23.494533 3.744407c20.128895 4.718386 33.548159 12.315421 40.853 23.234805a34.944195 34.944195 0 0 1 4.263863 30.701977c-1.95878 6.15771-6.038669 18.970943-72.864437 101.31544-31.859929 39.251346-63.211225 76.067745-63.51424 76.435692a22.726172 22.726172 0 0 1-20.139718 7.813475 22.66124 22.66124 0 0 1-2.857004 0.183974z m102.67901-195.715631l-18.527241 41.23177c15.951608-20.626707 24.024811-32.184589 28.137165-38.537095a86.900554 86.900554 0 0 0-9.609924-2.694675z"
        fill="#203529"
      />
      <path
        d="M208.886973 996.447222a11.363086 11.363086 0 0 1-6.363328-20.789037c0.606031-0.411235 61.901764-42.043419 123.846816-109.962207 56.609813-62.064094 125.459292-159.483619 131.963307-271.144878 5.530035-94.876358 48.006333-186.419544 82.658335-246.514036 37.400786-64.845345 73.015945-106.899585 74.5202-108.663569a11.363086 11.363086 0 1 1 17.315179 14.739546c-0.465345 0.541099-36.037216 42.616984-72.366625 105.6767-33.331719 57.865163-74.173897 145.793806-79.433383 236.081641-3.062622 52.497458-19.057519 106.2178-47.55181 159.656771-22.617952 42.422188-53.125133 84.779444-90.677427 125.88135C279.045913 951.254605 217.80429 992.778568 215.228657 994.542552a11.308976 11.308976 0 0 1-6.341684 1.90467z"
        fill="#203529"
      />
      <path
        d="M271.167507 474.004989a11.363086 11.363086 0 0 1-8.906495-18.397377c32.606646-41.23177 89.82249-71.500866 169.980946-89.963176a636.008161 636.008161 0 0 1 109.778233-15.442975 11.363086 11.363086 0 1 1 0.768361 22.726172c-2.099465 0.075754-192.230951 7.651145-262.703728 96.759384a11.341442 11.341442 0 0 1-8.917317 4.317972zM259.306609 658.076162a11.363086 11.363086 0 0 1-8.852385-18.494775c27.45538-34.165012 71.57662-61.436419 131.130014-81.035037a475.36659 475.36659 0 0 1 80.829419-19.198205 11.363086 11.363086 0 0 1 2.88947 22.542199c-1.374392 0.173152-137.926221 18.29998-197.100845 91.932777a11.341442 11.341442 0 0 1-8.895673 4.253041zM257.29372 825.189281a11.363086 11.363086 0 0 1-1.937136-22.563842c56.620635-9.631568 102.884628-38.472163 131.714401-60.971073 31.567735-24.641664 49.781139-47.313726 49.975935-47.530166a11.363086 11.363086 0 0 1 17.780524 14.155159c-0.790005 0.995623-19.728482 24.641664-53.244175 50.863337-30.99417 24.273716-80.861885 55.419394-142.417345 65.884256a11.43884 11.43884 0 0 1-1.872204 0.162329z"
        fill="#203529"
      />
      <path
        d="M430.012628 950.78926a11.363086 11.363086 0 0 1-7.856762-19.576974c48.817982-46.707695 69.033453-108.988229 60.08367-185.055974-6.763742-57.51886-28.353605-101.272152-28.570045-101.726675a11.363086 11.363086 0 1 1 20.291226-10.172668c0.963157 1.926314 23.581109 47.779072 30.799374 109.204668 4.328795 36.361875 2.218507 70.624286-6.114423 101.845718-10.497327 39.316278-30.961704 73.75184-60.830387 102.332706a11.319798 11.319798 0 0 1-7.802653 3.149199zM638.649711 828.760537a11.373908 11.373908 0 0 1-11.244044-13.116248c21.871235-139.722671-13.917075-231.525585-47.735784-283.925644-36.296944-56.274331-77.517891-79.877084-77.918304-80.082702A11.363086 11.363086 0 0 1 512.919869 431.799241c1.883026 1.082199 46.534543 26.676197 85.872465 87.593161 22.953434 35.57187 39.348744 75.916237 48.69894 119.940079 11.65528 54.683499 12.456107 115.189227 2.359193 179.818132a11.363086 11.363086 0 0 1-11.200756 9.609924z"
        fill="#203529"
      />
      <path
        d="M340.09274 512.011807a11.373908 11.373908 0 0 1-10.886918-14.642148c15.875855-52.713897 73.232384-92.9284 75.667331-94.61663a11.363086 11.363086 0 0 1 12.986384 18.678749c-0.530277 0.367948-53.287463 37.454896-66.858234 82.496005a11.363086 11.363086 0 0 1-10.908563 8.084024zM334.357087 685.931956a11.363086 11.363086 0 0 1-8.960605-18.343268l55.549258-71.425112a11.363086 11.363086 0 1 1 17.942854 13.949541l-55.549258 71.425112a11.341442 11.341442 0 0 1-8.982249 4.393727zM389.960455 897.328645a11.363086 11.363086 0 0 1-8.863207-18.462309c31.178144-39.078194 29.998547-76.403226 29.987726-76.771174a11.363086 11.363086 0 0 1 22.726172-1.136309c0.097398 1.85056 1.969602 45.9718-34.944195 92.105929a11.341442 11.341442 0 0 1-8.906496 4.263863zM562.33306 715.627488a11.363086 11.363086 0 0 1-9.85883-16.99052c25.702219-45.062753 26.665375-108.955763 26.665376-109.59426a11.363086 11.363086 0 1 1 22.726172 0.238084c0 2.857005-1.082199 70.4836-29.652244 120.611043a11.363086 11.363086 0 0 1-9.880474 5.735653zM680.000522 519.998433a11.363086 11.363086 0 0 1-10.129379-6.200998c-12.7483-24.977145-34.251588-41.902733-63.849722-50.300595a139.00842 139.00842 0 0 0-42.519586-5.216197 11.363086 11.363086 0 0 1-1.655764-22.661241 159.332111 159.332111 0 0 1 49.553877 5.789763c35.874886 9.956228 63.103005 31.383762 78.751598 62.053272a11.363086 11.363086 0 0 1-10.107736 16.535996z"
        fill="#2FA65B"
      />
    </svg>
  ),
  bulbSuccess: (
    <svg
      xmlns="http://www.w3.org/2000/svg"
      width="100%"
      height="100%"
      className="pointer-events-none"
      viewBox="0 0 1024 1024"
      fill="#000000">
      <path
        d="M296.022 64.46a7.994 7.994 0 0 1-3.428-15.224C361.302 16.712 435.07 0.224 511.86 0.224c76.524 0 150.064 16.378 218.594 48.7a7.98 7.98 0 0 1 3.826 10.632c-1.876 4.014-6.714 5.684-10.634 3.826C657.256 32.076 586.01 16.212 511.86 16.212c-74.4 0-145.874 15.972-212.426 47.482a8.066 8.066 0 0 1-3.412 0.766zM967.846 735.372a7.944 7.944 0 0 1-3.404-0.766 7.984 7.984 0 0 1-3.824-10.632c31.304-66.358 47.17-137.604 47.17-211.786 0-74.4-15.974-145.88-47.482-212.426a7.992 7.992 0 0 1 3.81-10.648c3.964-1.842 8.742-0.204 10.648 3.81 32.524 68.702 49.012 142.476 49.012 219.266 0 76.554-16.378 150.096-48.7 218.594a7.966 7.966 0 0 1-7.23 4.588zM56.472 735.372a7.99 7.99 0 0 1-7.236-4.574C16.712 662.096 0.224 588.32 0.224 511.532c0-76.554 16.386-150.096 48.7-218.594 1.88-4.012 6.636-5.684 10.64-3.826a7.994 7.994 0 0 1 3.818 10.632c-31.298 66.36-47.17 137.606-47.17 211.788 0 74.4 15.972 145.88 47.482 212.426a7.996 7.996 0 0 1-7.222 11.414zM511.188 1023.776c-76.554 0-150.104-16.378-218.602-48.7a7.994 7.994 0 0 1-3.818-10.634 7.986 7.986 0 0 1 10.642-3.824c66.35 31.304 137.604 47.17 211.778 47.17 74.4 0 145.88-15.974 212.426-47.482 3.952-1.874 8.728-0.204 10.65 3.81a7.992 7.992 0 0 1-3.81 10.648c-68.702 32.524-142.478 49.012-219.266 49.012zM840.11 847.62c-4.42 0-8.072-3.576-8.072-7.994s3.496-7.994 7.9-7.994h0.172a8 8 0 0 1 7.994 7.994 8 8 0 0 1-7.994 7.994zM920.052 847.62c-4.42 0-8.074-3.576-8.074-7.994s3.498-7.994 7.902-7.994h0.172a8 8 0 0 1 7.994 7.994 8 8 0 0 1-7.994 7.994zM391.92 672.932a7.86 7.86 0 0 1-3.856-0.998c-81.426-44.954-132.008-130.798-132.008-224.03 0-141.054 114.762-255.816 255.818-255.816a7.99 7.99 0 0 1 7.994 7.994 7.99 7.99 0 0 1-7.994 7.994c-132.242 0-239.83 107.58-239.83 239.828 0 87.408 47.418 167.896 123.748 210.038a7.976 7.976 0 0 1 3.13 10.854 7.95 7.95 0 0 1-7.002 4.136z"
        fill=""
      />
      <path
        d="M631.804 672.932a7.952 7.952 0 0 1-6.994-4.136 7.976 7.976 0 0 1 3.136-10.854c76.32-42.14 123.74-122.628 123.74-210.038 0-132.248-107.58-239.828-239.812-239.828a7.988 7.988 0 0 1-7.994-7.994 7.988 7.988 0 0 1 7.994-7.994c141.054 0 255.8 114.762 255.8 255.816 0 93.23-50.588 179.076-132.014 224.03a7.812 7.812 0 0 1-3.856 0.998zM391.96 799.654a7.99 7.99 0 0 1-7.994-7.994v-126.722c0-4.418 3.576-7.994 7.994-7.994s7.996 3.576 7.996 7.994v126.722a7.992 7.992 0 0 1-7.996 7.994z"
        fill=""
      />
      <path
        d="M631.774 799.654a7.988 7.988 0 0 1-7.994-7.994v-126.536a7.988 7.988 0 0 1 7.994-7.994 7.99 7.99 0 0 1 7.994 7.994v126.536a7.99 7.99 0 0 1-7.994 7.994z"
        fill=""
      />
      <path
        d="M631.774 703.722H391.96a7.99 7.99 0 0 1-7.994-7.994 7.988 7.988 0 0 1 7.994-7.994h239.814a7.988 7.988 0 0 1 7.994 7.994 7.99 7.99 0 0 1-7.994 7.994zM599.794 831.63h-175.858a7.98 7.98 0 0 1-5.652-2.342l-31.976-31.976a7.988 7.988 0 0 1 0-11.304 7.988 7.988 0 0 1 11.304 0l29.636 29.634h169.238l29.634-29.634c3.124-3.124 8.182-3.124 11.304 0s3.124 8.182 0 11.304l-31.978 31.976a7.966 7.966 0 0 1-5.652 2.342zM375.964 751.688a7.994 7.994 0 0 1-0.462-15.974l271.79-15.988c4.28-0.344 8.182 3.108 8.448 7.51a7.988 7.988 0 0 1-7.51 8.448l-271.792 15.988c-0.154 0.016-0.318 0.016-0.474 0.016zM375.964 783.666a7.996 7.996 0 0 1-0.462-15.976l271.79-15.988c4.28-0.516 8.182 3.108 8.448 7.512a7.986 7.986 0 0 1-7.51 8.446l-271.792 15.99c-0.154 0.016-0.318 0.016-0.474 0.016z"
        fill=""
      />
      <path
        d="M511.876 863.61c-44.398 0-62.37-34.914-63.112-36.396-1.976-3.952-0.376-8.744 3.576-10.726s8.736-0.376 10.71 3.542c0.624 1.218 14.59 27.59 48.826 27.59 34.272 0 48.23-26.464 48.808-27.59a8.046 8.046 0 0 1 10.742-3.512 7.99 7.99 0 0 1 3.544 10.696c-0.75 1.482-18.706 36.396-63.094 36.396zM471.902 671.746a7.99 7.99 0 0 1-7.994-7.996v-63.954a7.99 7.99 0 0 1 7.994-7.994 7.99 7.99 0 0 1 7.996 7.994v63.954a7.99 7.99 0 0 1-7.996 7.996zM551.83 671.746a7.99 7.99 0 0 1-7.994-7.996v-63.954c0-4.418 3.576-7.994 7.994-7.994s7.994 3.576 7.994 7.994v63.954a7.99 7.99 0 0 1-7.994 7.996z"
        fill=""
      />
      <path
        d="M471.91 607.792a8.01 8.01 0 0 1-6.252-2.998 8.008 8.008 0 0 1 1.248-11.242l39.972-31.976a8.034 8.034 0 0 1 11.242 1.248 8.004 8.004 0 0 1-1.248 11.242l-39.972 31.978a8.032 8.032 0 0 1-4.99 1.748z"
        fill=""
      />
      <path
        d="M551.83 607.792a8.024 8.024 0 0 1-4.996-1.748l-39.956-31.978a8.002 8.002 0 0 1-1.242-11.242 8.024 8.024 0 0 1 11.234-1.248l39.956 31.976a8.006 8.006 0 0 1 1.25 11.242 8 8 0 0 1-6.246 2.998zM471.902 575.812a7.988 7.988 0 0 1-7.994-7.992v-111.92a7.992 7.992 0 0 1 7.994-7.996 7.99 7.99 0 0 1 7.996 7.996v111.92a7.988 7.988 0 0 1-7.996 7.992z"
        fill=""
      />
      <path
        d="M471.902 463.894a7.99 7.99 0 0 1-7.994-7.994c0-13.226-10.758-23.984-23.982-23.984s-23.982 10.758-23.982 23.984a7.99 7.99 0 0 1-7.994 7.994 7.988 7.988 0 0 1-7.994-7.994c0-22.046 17.932-39.972 39.97-39.972s39.972 17.924 39.972 39.972a7.99 7.99 0 0 1-7.996 7.994z"
        fill=""
      />
      <path
        d="M439.926 495.872c-22.04 0-39.97-17.924-39.97-39.972a7.99 7.99 0 0 1 7.994-7.996 7.99 7.99 0 0 1 7.994 7.996c0 13.224 10.758 23.984 23.982 23.984a7.99 7.99 0 0 1 7.994 7.994 7.992 7.992 0 0 1-7.994 7.994zM551.83 575.812a7.988 7.988 0 0 1-7.994-7.992v-111.92c0-4.418 3.576-7.996 7.994-7.996s7.994 3.576 7.994 7.996v111.92a7.988 7.988 0 0 1-7.994 7.992z"
        fill=""
      />
      <path
        d="M615.786 463.894a7.988 7.988 0 0 1-7.994-7.994c0-13.226-10.758-23.984-23.984-23.984-13.224 0-23.982 10.758-23.982 23.984 0 4.418-3.576 7.994-7.994 7.994s-7.994-3.576-7.994-7.994c0-22.046 17.924-39.972 39.97-39.972s39.972 17.924 39.972 39.972a7.99 7.99 0 0 1-7.994 7.994z"
        fill=""
      />
      <path
        d="M583.806 495.872a7.99 7.99 0 0 1-7.994-7.994 7.99 7.99 0 0 1 7.994-7.994c13.226 0 23.984-10.758 23.984-23.984a7.99 7.99 0 0 1 7.994-7.996 7.99 7.99 0 0 1 7.994 7.996c0.002 22.046-17.924 39.972-39.972 39.972zM328.006 455.9a7.99 7.99 0 0 1-7.994-7.996c0-105.798 86.072-191.862 191.864-191.862 4.418 0 7.994 3.576 7.994 7.994s-3.576 7.996-7.994 7.996c-96.978 0-175.876 78.896-175.876 175.874a7.99 7.99 0 0 1-7.994 7.994zM519.87 495.872h-15.988a7.99 7.99 0 0 1-7.996-7.994 7.99 7.99 0 0 1 7.996-7.994h15.988a7.99 7.99 0 0 1 7.994 7.994 7.992 7.992 0 0 1-7.994 7.994z"
        fill=""
      />
      <path
        d="M879.596 288.02c-79.35 0-143.896-64.548-143.896-143.898S800.246 0.224 879.596 0.224s143.898 64.548 143.898 143.898-64.548 143.898-143.898 143.898z m0-271.808c-70.528 0-127.908 57.38-127.908 127.91 0 70.528 57.38 127.91 127.908 127.91s127.91-57.382 127.91-127.91c0-70.528-57.382-127.91-127.91-127.91z"
        fill=""
      />
      <path
        d="M879.596 1023.494c-79.35 0-143.896-64.548-143.896-143.896 0-79.352 64.546-143.898 143.896-143.898s143.898 64.546 143.898 143.898c0 79.348-64.548 143.896-143.898 143.896z m0-271.806c-70.528 0-127.908 57.382-127.908 127.91s57.38 127.908 127.908 127.908 127.91-57.38 127.91-127.908-57.382-127.91-127.91-127.91z"
        fill=""
      />
      <path
        d="M144.122 288.02C64.78 288.02 0.226 223.472 0.226 144.122S64.78 0.224 144.122 0.224s143.898 64.548 143.898 143.898-64.558 143.898-143.898 143.898z m0-271.808c-70.528 0-127.908 57.38-127.908 127.91 0 70.528 57.38 127.91 127.908 127.91s127.91-57.382 127.91-127.91c-0.002-70.528-57.384-127.91-127.91-127.91z"
        fill=""
      />
      <path
        d="M144.122 1023.494c-79.342 0-143.896-64.548-143.896-143.896 0-79.352 64.554-143.898 143.896-143.898s143.898 64.546 143.898 143.898c-0.002 79.348-64.558 143.896-143.898 143.896z m0-271.806c-70.528 0-127.908 57.382-127.908 127.91s57.38 127.908 127.908 127.908 127.91-57.38 127.91-127.908-57.384-127.91-127.91-127.91z"
        fill=""
      />
      <path
        d="M879.596 224.064a8.09 8.09 0 0 1-3.246-0.686c-3.138-1.39-76.696-34.788-76.696-95.246 0-26.45 21.516-47.964 47.964-47.964a47.248 47.248 0 0 1 31.976 12.35 47.256 47.256 0 0 1 31.978-12.35c26.45 0 47.964 21.516 47.964 47.964 0 60.458-73.556 93.856-76.696 95.246a8.06 8.06 0 0 1-3.244 0.686zM847.62 96.156c-17.628 0-31.976 14.35-31.976 31.976 0 43.718 50.494 72.23 63.954 79.052 13.43-6.838 63.956-35.444 63.956-79.052 0-17.626-14.35-31.976-31.976-31.976-10.104 0-19.424 4.73-25.56 12.99-3.03 4.06-9.804 4.06-12.834 0-6.142-8.26-15.464-12.99-25.564-12.99z"
        fill=""
      />
      <path
        d="M200.082 943.55H136.126a7.99 7.99 0 0 1-5.652-2.342l-13.646-13.646h-12.678a7.988 7.988 0 0 1-7.994-7.994v-47.966a7.988 7.988 0 0 1 7.994-7.992c-0.054 0 10.774-0.61 26.832-14.118 17.222-14.488 29.596-44.544 29.712-44.858a8 8 0 0 1 7.41-4.98h15.988a7.99 7.99 0 0 1 7.994 7.994v39.97h7.996c2.124 0 4.152 0.844 5.652 2.342 19.19 19.192 19.19 72.058 0 91.248a7.984 7.984 0 0 1-5.652 2.342z m-60.644-15.988h56.966c10.196-14.194 10.196-49.762 0-63.954h-12.312a7.99 7.99 0 0 1-7.994-7.996v-39.97h-2.772c-4.63 10.054-16.254 32.79-32.056 46.092-12.28 10.32-22.506 14.694-29.126 16.536v33.304h7.994c2.124 0 4.154 0.844 5.652 2.342l13.648 13.646z"
        fill=""
      />
      <path
        d="M104.15 943.55H56.184a7.988 7.988 0 0 1-7.994-7.994v-79.944a7.99 7.99 0 0 1 7.994-7.994h47.966a7.99 7.99 0 0 1 7.994 7.994v79.944a7.988 7.988 0 0 1-7.994 7.994z m-39.972-15.988h31.978v-63.954H64.178v63.954z"
        fill=""
      />
      <path
        d="M879.596 959.54c-44.406 0-62.362-34.912-63.11-36.394a8 8 0 0 1 3.574-10.726 7.98 7.98 0 0 1 10.71 3.542c0.624 1.218 14.584 27.59 48.824 27.59 34.632 0 48.668-27.278 48.808-27.558 1.984-3.934 6.792-5.542 10.726-3.574a8 8 0 0 1 3.576 10.726c-0.746 1.48-18.702 36.394-63.108 36.394z"
        fill=""
      />
      <path
        d="M144.122 192.088c-35.264 0-63.954-28.684-63.954-63.956s28.69-63.954 63.954-63.954 63.956 28.682 63.956 63.954-28.694 63.956-63.956 63.956z m0-111.92c-26.45 0-47.964 21.516-47.964 47.964 0 26.45 21.516 47.966 47.964 47.966 26.45 0 47.966-21.516 47.966-47.966-0.002-26.448-21.516-47.964-47.966-47.964z"
        fill=""
      />
      <path
        d="M144.122 224.064c-35.264 0-63.954-28.682-63.954-63.954 0-4.418 3.576-7.994 7.994-7.994s7.996 3.576 7.996 7.994c0 26.45 21.516 47.966 47.964 47.966 26.45 0 47.966-21.516 47.966-47.966a7.99 7.99 0 0 1 7.996-7.994 7.99 7.99 0 0 1 7.994 7.994c-0.002 35.272-28.694 63.954-63.956 63.954z"
        fill=""
      />
      <path
        d="M144.122 160.11a7.99 7.99 0 0 1-7.994-7.994V104.15a7.99 7.99 0 0 1 7.994-7.994 7.99 7.99 0 0 1 7.994 7.994v47.966a7.988 7.988 0 0 1-7.994 7.994z"
        fill=""
      />
      <path
        d="M168.104 136.126l-47.966-0.016a7.996 7.996 0 0 1 0-15.988l47.966 0.016a7.992 7.992 0 1 1 0 15.988z"
        fill=""
      />
      <path
        d="M88.162 168.106a7.99 7.99 0 0 1-7.994-7.996V128.132c0-4.418 3.576-7.994 7.994-7.994s7.996 3.576 7.996 7.994v31.978a7.994 7.994 0 0 1-7.996 7.996z"
        fill=""
      />
      <path
        d="M200.082 168.106a7.99 7.99 0 0 1-7.996-7.996V128.132a7.99 7.99 0 0 1 7.996-7.994 7.99 7.99 0 0 1 7.994 7.994v31.978a7.99 7.99 0 0 1-7.994 7.996z"
        fill=""
      />
    </svg>
  ),
  checklist: (
    <svg
      xmlns="http://www.w3.org/2000/svg"
      width="100%"
      height="100%"
      className="pointer-events-none"
      viewBox="0 0 1024 1024"
      fill="#000000">
      <path
        d="M775.942 959.906H56.09a7.994 7.994 0 0 1-7.998-7.998V72.09a7.994 7.994 0 0 1 7.998-7.998H104.08c4.42 0 7.998 3.578 7.998 7.998s-3.578 8-7.998 8H64.09v863.82h703.854V80.09h-39.992c-4.42 0-7.998-3.578-7.998-8s3.578-7.998 7.998-7.998h47.99a7.994 7.994 0 0 1 7.998 7.998v879.818a7.992 7.992 0 0 1-7.998 7.998z"
        fill=""
      />
      <path
        d="M663.964 80.09h-47.99c-4.422 0-7.998-3.578-7.998-8s3.576-7.998 7.998-7.998h47.99c4.42 0 7.998 3.578 7.998 7.998s-3.578 8-7.998 8zM551.988 80.09h-47.99c-4.42 0-7.998-3.578-7.998-8s3.578-7.998 7.998-7.998h47.99c4.42 0 7.998 3.578 7.998 7.998s-3.578 8-7.998 8zM440.012 80.09h-47.99c-4.422 0-7.998-3.578-7.998-8s3.576-7.998 7.998-7.998h47.99c4.42 0 7.998 3.578 7.998 7.998s-3.578 8-7.998 8zM328.036 80.09h-47.99c-4.422 0-8-3.578-8-8s3.578-7.998 8-7.998h47.99c4.42 0 7.998 3.578 7.998 7.998s-3.578 8-7.998 8zM216.058 80.09H168.068c-4.422 0-8-3.578-8-8s3.578-7.998 8-7.998h47.99a7.998 7.998 0 1 1 0 15.998zM767.944 991.9H56.09a7.994 7.994 0 0 1-7.998-7.998 7.994 7.994 0 0 1 7.998-7.998h711.852a7.992 7.992 0 0 1 7.998 7.998 7.99 7.99 0 0 1-7.996 7.998zM767.944 1023.894H56.09a7.994 7.994 0 0 1-7.998-8 7.994 7.994 0 0 1 7.998-7.998h711.852a7.994 7.994 0 0 1 7.998 7.998 7.99 7.99 0 0 1-7.996 8z"
        fill=""
      />
      <path
        d="M136.074 144.076c-13.232 0-23.996-10.764-23.996-23.996V24.1c0-13.232 10.764-23.996 23.996-23.996S160.07 10.868 160.07 24.1v95.98c0 13.232-10.764 23.996-23.996 23.996z m0-127.974a8.008 8.008 0 0 0-7.998 8v95.98c0 4.414 3.592 8 7.998 8a8 8 0 0 0 7.998-8v-95.98a8 8 0 0 0-7.998-8zM248.05 144.076c-13.232 0-23.994-10.764-23.994-23.996V24.1c0-13.232 10.762-23.996 23.994-23.996s23.996 10.764 23.996 23.996v95.98c0 13.232-10.762 23.996-23.996 23.996z m0-127.974a8.008 8.008 0 0 0-7.998 8v95.98c0 4.414 3.594 8 7.998 8a8 8 0 0 0 7.998-8v-95.98a8 8 0 0 0-7.998-8zM360.028 144.076c-13.23 0-23.994-10.764-23.994-23.996V24.1c0-13.232 10.764-23.996 23.994-23.996 13.232 0 23.996 10.764 23.996 23.996v95.98c0 13.232-10.764 23.996-23.996 23.996z m0-127.974a8.008 8.008 0 0 0-7.998 8v95.98c0 4.414 3.594 8 7.998 8a8 8 0 0 0 8-8v-95.98a8 8 0 0 0-8-8zM472.004 144.076c-13.232 0-23.996-10.764-23.996-23.996V24.1c0-13.232 10.764-23.996 23.996-23.996S496 10.87 496 24.102v95.98c0 13.23-10.764 23.994-23.996 23.994z m0-127.974c-4.406 0-8 3.584-8 8v95.98c0 4.414 3.594 8 8 8a8 8 0 0 0 7.998-8v-95.98a8 8 0 0 0-7.998-8zM583.982 144.076c-13.232 0-23.996-10.764-23.996-23.996V24.1c0-13.232 10.764-23.996 23.996-23.996 13.23 0 23.994 10.764 23.994 23.996v95.98c0 13.232-10.764 23.996-23.994 23.996z m0-127.974c-4.406 0-8 3.584-8 8v95.98c0 4.414 3.594 8 8 8a8 8 0 0 0 7.998-8v-95.98a8 8 0 0 0-7.998-8zM695.958 144.076c-13.232 0-23.996-10.764-23.996-23.996V24.1c0-13.232 10.764-23.996 23.996-23.996 13.23 0 23.994 10.764 23.994 23.996v95.98c0.002 13.232-10.762 23.996-23.994 23.996z m0-127.974c-4.406 0-8 3.584-8 8v95.98c0 4.414 3.594 8 8 8a8 8 0 0 0 7.998-8v-95.98a8 8 0 0 0-7.998-8zM919.928 911.918a8.004 8.004 0 0 1-6.672-3.562l-31.992-47.99a8.024 8.024 0 0 1-0.922-6.966l15.574-46.756v-14.702a7.994 7.994 0 0 1 8-7.998 7.994 7.994 0 0 1 7.998 7.998v15.996c0 0.86-0.14 1.718-0.406 2.532l-14.764 44.274 29.822 44.74a7.986 7.986 0 0 1-2.216 11.092 7.988 7.988 0 0 1-4.422 1.342z"
        fill=""
      />
      <path
        d="M919.912 911.918a8 8 0 0 1-6.656-12.436l29.824-44.74-14.748-44.274a7.732 7.732 0 0 1-0.422-2.532v-15.996a7.994 7.994 0 0 1 7.998-7.998 7.994 7.994 0 0 1 7.998 7.998v14.702l15.592 46.756a7.976 7.976 0 0 1-0.938 6.966l-31.994 47.99a7.966 7.966 0 0 1-6.654 3.564zM951.904 671.966h-63.986a7.994 7.994 0 0 1-7.998-7.998c0-4.422 3.578-8 7.998-8h63.986c4.422 0 8 3.578 8 8a7.994 7.994 0 0 1-8 7.998z"
        fill=""
      />
      <path
        d="M887.918 671.966a8 8 0 0 1-7.982-7.686l-15.996-399.926a7.98 7.98 0 0 1 7.67-8.31c4.374-0.554 8.124 3.258 8.31 7.67l15.996 399.942a8.016 8.016 0 0 1-7.67 8.31h-0.328zM951.92 671.966h-0.328c-4.42-0.188-7.858-3.906-7.67-8.31l15.998-399.942c0.172-4.412 3.874-8.216 8.31-7.67a8.002 8.002 0 0 1 7.67 8.31l-15.996 399.926a8 8 0 0 1-7.984 7.686z"
        fill=""
      />
      <path
        d="M967.902 272.034a7.992 7.992 0 0 1-7.998-7.998c0-37.148-13.452-55.988-39.992-55.988-26.526 0-39.992 18.84-39.992 55.988 0 4.422-3.578 7.998-7.998 7.998s-7.998-3.576-7.998-7.998c0-45.748 20.418-71.984 55.988-71.984 35.586 0 55.988 26.236 55.988 71.984a7.994 7.994 0 0 1-7.998 7.998z"
        fill=""
      />
      <path
        d="M935.908 208.046h-31.992c-4.422 0-8-3.578-8-7.998s3.578-7.998 8-7.998h31.992c4.422 0 7.998 3.578 7.998 7.998s-3.576 7.998-7.998 7.998zM919.912 479.99a7.992 7.992 0 0 1-7.998-7.998V232.042c0-4.42 3.576-7.998 7.998-7.998s7.998 3.578 7.998 7.998v239.95a7.992 7.992 0 0 1-7.998 7.998zM951.904 703.96h-63.986a7.994 7.994 0 0 1-7.998-8 7.994 7.994 0 0 1 7.998-7.998h63.986c4.422 0 8 3.578 8 7.998 0 4.422-3.578 8-8 8z"
        fill=""
      />
      <path
        d="M951.904 703.96a7.994 7.994 0 0 1-7.998-8v-31.992c0-4.422 3.578-8 7.998-8 4.422 0 8 3.578 8 8v31.992c0 4.422-3.578 8-8 8zM887.918 703.96a7.994 7.994 0 0 1-7.998-8v-31.992c0-4.422 3.578-8 7.998-8a7.994 7.994 0 0 1 7.998 8v31.992c0 4.422-3.576 8-7.998 8zM951.904 799.94h-63.986a7.994 7.994 0 0 1-7.998-7.998 7.994 7.994 0 0 1 7.998-7.998h63.986c4.422 0 8 3.578 8 7.998a7.994 7.994 0 0 1-8 7.998z"
        fill=""
      />
      <path
        d="M951.904 799.94a7.994 7.994 0 0 1-7.998-7.998v-95.98a7.994 7.994 0 0 1 7.998-7.998c4.422 0 8 3.578 8 7.998v95.98a7.994 7.994 0 0 1-8 7.998zM887.918 799.94a7.994 7.994 0 0 1-7.998-7.998v-95.98a7.994 7.994 0 0 1 7.998-7.998 7.994 7.994 0 0 1 7.998 7.998v95.98a7.992 7.992 0 0 1-7.998 7.998zM200.06 368.03a7.98 7.98 0 0 1-5.654-2.342l-31.994-31.994a7.996 7.996 0 1 1 11.31-11.31l31.994 31.994a7.996 7.996 0 0 1-5.656 13.652z"
        fill=""
      />
      <path
        d="M200.06 368.03a7.996 7.996 0 0 1-5.654-13.652l63.986-63.988a7.996 7.996 0 1 1 11.31 11.31l-63.986 63.988a7.98 7.98 0 0 1-5.656 2.342z"
        fill=""
      />
      <path
        d="M200.06 575.986a7.972 7.972 0 0 1-5.654-2.344l-31.994-31.992a7.996 7.996 0 1 1 11.31-11.31l31.994 31.992a7.996 7.996 0 0 1-5.656 13.654z"
        fill=""
      />
      <path
        d="M200.06 575.986a7.996 7.996 0 0 1-5.654-13.654l63.986-63.97a7.996 7.996 0 1 1 11.31 11.31l-63.986 63.97a7.964 7.964 0 0 1-5.656 2.344z"
        fill=""
      />
      <path
        d="M663.964 288.046H344.032c-4.42 0-7.998-3.578-7.998-8s3.578-8 7.998-8h319.934c4.42 0 7.998 3.578 7.998 8s-3.58 8-8 8z"
        fill=""
      />
      <path
        d="M663.964 336.036H344.032c-4.42 0-7.998-3.578-7.998-7.998s3.578-8 7.998-8h319.934c4.42 0 7.998 3.578 7.998 8s-3.58 7.998-8 7.998z"
        fill=""
      />
      <path
        d="M503.998 384.026h-159.966a7.994 7.994 0 0 1-7.998-8 7.994 7.994 0 0 1 7.998-7.998h159.966a7.994 7.994 0 0 1 7.998 7.998c0 4.424-3.578 8-7.998 8z"
        fill=""
      />
      <path
        d="M663.964 496.002H344.032c-4.42 0-7.998-3.578-7.998-7.998s3.578-8 7.998-8h319.934c4.42 0 7.998 3.578 7.998 8s-3.58 7.998-8 7.998z"
        fill=""
      />
      <path
        d="M663.964 543.992H344.032a7.994 7.994 0 0 1-7.998-7.998 7.994 7.994 0 0 1 7.998-7.998h319.934a7.994 7.994 0 0 1 7.998 7.998 7.996 7.996 0 0 1-8 7.998z"
        fill=""
      />
      <path
        d="M503.998 591.984h-159.966a7.994 7.994 0 0 1-7.998-8 7.994 7.994 0 0 1 7.998-7.998h159.966a7.994 7.994 0 0 1 7.998 7.998c0 4.422-3.578 8-7.998 8z"
        fill=""
      />
      <path
        d="M200.06 783.944a7.972 7.972 0 0 1-5.654-2.344l-31.994-31.992a7.996 7.996 0 1 1 11.31-11.31l31.994 31.992a7.996 7.996 0 0 1-5.656 13.654z"
        fill=""
      />
      <path
        d="M200.06 783.944a7.996 7.996 0 0 1-5.654-13.654l63.986-63.986a7.996 7.996 0 1 1 11.31 11.31L205.716 781.6a7.974 7.974 0 0 1-5.656 2.344z"
        fill=""
      />
      <path
        d="M663.964 703.96H344.032a7.994 7.994 0 0 1-7.998-8 7.994 7.994 0 0 1 7.998-7.998h319.934a7.994 7.994 0 0 1 7.998 7.998 7.998 7.998 0 0 1-8 8z"
        fill=""
      />
      <path
        d="M663.964 751.95H344.032a7.994 7.994 0 0 1-7.998-7.998 7.994 7.994 0 0 1 7.998-7.998h319.934a7.994 7.994 0 0 1 7.998 7.998 7.996 7.996 0 0 1-8 7.998z"
        fill=""
      />
      <path
        d="M503.998 799.94h-159.966a7.994 7.994 0 0 1-7.998-7.998 7.994 7.994 0 0 1 7.998-7.998h159.966a7.994 7.994 0 0 1 7.998 7.998 7.994 7.994 0 0 1-7.998 7.998z"
        fill=""
      />
    </svg>
  ),
  mailReception: (
    <svg
      xmlns="http://www.w3.org/2000/svg"
      width="100%"
      height="100%"
      className="pointer-events-none"
      viewBox="0 0 1024 1024">
      <path
        d="M262.8 139.5l497.4-2.5v219.2s59.7 25.8 66.9 30.5c21.6 14.3 53.6 20 53.6 92.3v323.7c0 41.2-33.4 74.5-74.5 74.5H216.4c-41.2 0-74.5-33.4-74.5-74.5V497c0-5.4 0.6-15.2 0-27-1.3-25.8 3.7-51.1 29.7-70.2 15.1-11.1 34.5-18.5 51-25.9 22.4-10.1 40.2-17.9 40.2-17.9V139.5z"
        fill="#FFFFFF"
      />
      <path
        d="M262.8 399.8l-38.7 17.3-0.4 0.2c-16.2 6.4-26.4 12.4-32.6 18.5l71.8 38.8v-74.8zM797.8 416.7L760.2 400v74.4l70.6-38.2c-6.5-5.6-16.9-11.5-33-19.5z"
        fill="#E6E6E6"
      />
      <path
        d="M252.6 753.6V560.7c0-5.5-4.5-10-10-10s-10 4.5-10 10v192.9c0 19.5 15.9 35.4 35.4 35.4h298.8c5.5 0 10-4.5 10-10s-4.5-10-10-10H267.9c-8.4-0.1-15.3-7-15.3-15.4z"
        fill="#06F3FF"
      />
      <path
        d="M302.8 368.6zM878 437.7c0 0.2 0.1 0.3 0.1 0.4 0-0.1-0.1-0.3-0.1-0.4zM607.2 475.5c15.4-8.5 27.6-20.2 35.1-33.4 2.4-2.2 3.8-5.1 4-8.3 0.3-0.8 0.7-1.7 1-2.5h-1c-0.2-6.8-5.9-12.2-12.8-12.2-6.6 0-12.1 5-12.7 11.6h-0.2c-9.9 12.4-23 21.1-39.2 27.3-16.2 6.2-35.6 10.2-58.2 10.2-23.4 0-42.8-4.6-61-12-17.9-7.2-33-19.9-43.2-36.2-10-16.1-15-33.3-15-53 0-20.2 5.1-39.6 14.1-58.3 8.7-18.3 22.8-33.4 40.4-43.4 17.8-10.3 38.2-15.6 63.7-15.6 30.1 0 53.6 7.9 70.4 23.3 16.8 15.4 21.8 34.6 21.8 57.5 0 12.8-1.6 25.1-7.5 37-5.9 11.9-11.7 18.4-21.3 25.5-7.1 5.4-23.1 11.7-27.7 11.7-1.5 0-2.8-0.6-3.9-1.8-1.1-1.1-1.6-2.9-1.6-5.2 0.3-4.3 1-8.6 2-12.9l21-80.3c1-1.8 1.8-3.7 1.8-5.9l-0.1-0.6 0.1-0.4h-0.1v-0.1c0-6.7-5.6-12.2-12.4-12.2-3.3 0-6.4 1.2-8.8 3.5-2.3 2.3-3.7 5.4-3.7 8.7l0.1 1.1c0 0.8 0.3 1.5 0.5 2.2l-1.3 4.7c-8-12.7-26.8-20.5-43.7-20.5-14.3 0-35.7 9.9-50.3 32.2-10.8 17.1-17 36.7-17.8 56.8-0.6 17.7 4.7 33.4 15 44 10.3 10.6 23 13.7 30.9 13.7 14.5 0 27.4-5.3 38.5-15.9 1.1 4.8 3.9 9 7.9 11.8 3.9 2.7 9.8 4.1 17.7 4.1 29.1 0 55.9-15.2 70.7-35.6 12.7-17.3 19.8-40.6 19.8-64.3 0-19.9-3.2-38.3-13-55.1-9.8-16.8-22.4-29.8-40.9-38.9-18.5-9.1-39.6-13.7-63.4-13.7-28 0-53 5.7-74.8 17-21.8 11.3-39 28.3-51.5 50.8-12.6 22.6-18.9 46.9-18.9 73.1-0.2 23.1 5.5 45.8 16.6 66.1 11.2 20.9 29 37.4 50.6 47.2 22.7 10.4 49.5 15.6 80.7 15.6 32 0 59.3-6.1 81.6-18.4zM530 368.6c-3.7 10.9-8 19.2-13 24.9-3.5 4-7.1 6.9-10.6 8.8-4.7 2.6-8.2 4.6-13.6 4.6-7.2 0-16.3-2.8-21.1-8.4-4.9-5.6-7.3-14.3-7.3-26.1 0-8.8 4.6-19 8.1-30.4 3.5-11.4 8.7-17.2 15.6-23.4 6.9-6.2 13.2-7.9 21.3-7.9 7.6 0 15.6 2.2 20.5 7.8 5 5.6 8.1 10 8.1 20.5 0.1 9.3-4.4 18.7-8 29.6z"
        fill="#005BFF"
      />
      <path
        d="M878.1 438.1c0-0.2-0.1-0.3-0.1-0.4-8.7-30.2-37.2-44.3-62.8-57l-0.4-0.2-54.6-24.4V137l-497.4 2.5V356l-54.2 24.2c-31.1 12.3-66.7 32.3-66.7 77.5v345.1c0 41 33.4 74.4 74.4 74.4h590c41 0 74.4-33.4 74.4-74.4V457.7c0-7.2-0.9-13.7-2.6-19.6zM760.2 400l37.6 16.8c16.2 8 26.5 13.9 33 19.4l-70.6 38.2V400z m-457.4-31.4V179.3l417.4-2.1V496l-199 107.7c-6.1 3.3-13.5 3.3-19.6 0L302.8 496.2V368.6z m-40 31.2v74.8L191 435.7c6.2-6.1 71.8-35.9 71.8-35.9z m577.9 403c0 19-15.4 34.4-34.4 34.4h-590c-19 0-34.4-15.4-34.4-34.4V476.3L482.4 639c9 4.9 18.9 7.3 28.9 7.3 9.9 0 19.8-2.4 28.9-7.3l300.5-162.7v326.5z"
        fill="#005BFF"
      />
    </svg>
  ),
  medal: (
    <svg
      xmlns="http://www.w3.org/2000/svg"
      width="100%"
      height="100%"
      className="pointer-events-none"
      viewBox="0 0 1024 1024">
      <path
        d="M841.7 915.2L518.5 797.3 183.1 915.2V107.1h658.6z"
        fill="#FFFFFF"
      />
      <path
        d="M849.7 926.7L518.4 805.8 175.1 926.5V99.1h674.5v827.6zM191.1 115.1v788.8l327.4-115.1 315.1 115V115.1H191.1z"
        fill="#0A0408"
      />
      <path
        d="M801.6 868.3l-18.2-6.6 2.2-6.2v-6.6h2.5l0.8-2.3 6.2 2.3h6.5zM256.2 856.6l-5.3-15.1 14.8-5.2 5.3 15.1-14.8 5.2z m512.4-0.3l-14.8-5.4 5.5-15 14.8 5.4-5.5 15z m-482.8-10.2l-5.3-15.1 14.8-5.2 5.3 15.1-14.8 5.2z m453.3-0.6l-14.8-5.4 5.5-15 14.8 5.4-5.5 15z m-423.6-9.8l-5.3-15.1 14.8-5.2 5.3 15.1-14.8 5.2z m394.1-1l-14.8-5.4 5.5-15 14.8 5.4-5.5 15z m-364.5-9.4l-5.3-15.1 14.8-5.2 5.3 15.1-14.8 5.2z m334.9-1.4l-14.8-5.4 5.5-15 14.8 5.4-5.5 15z m-305.2-9.1l-5.3-15.1 14.8-5.2 5.3 15.1-14.8 5.2z m275.7-1.6l-14.8-5.4 5.5-15 14.8 5.4-5.5 15z m-246.1-8.8l-5.3-15.1 14.8-5.2 5.3 15.1-14.8 5.2z m216.6-2l-14.8-5.4 5.5-15 14.8 5.4-5.5 15zM434.1 794l-5.3-15.1 14.8-5.2 5.3 15.1-14.8 5.2z m157.4-2.4l-14.8-5.4 5.5-15 14.8 5.4-5.5 15z m-127.8-8l-5.3-15.1 14.8-5.2 5.3 15.1-14.8 5.2z m98.2-2.8l-14.8-5.4 5.5-15 14.8 5.4-5.5 15z m-68.5-7.7l-5.3-15.1 14.8-5.2 5.3 15.1-14.8 5.2z m39-3l-14.8-5.4 5.5-15 14.8 5.4-5.5 15zM223.2 868.2v-19.3h6.6l6.2-2.2 0.8 2.2h2.4v6.6l2.2 6.3zM239.2 833.2h-16v-15.7h16v15.7z m0-31.4h-16V786h16v15.8z m0-31.5h-16v-15.7h16v15.7z m0-31.4h-16v-15.7h16v15.7z m0-31.4h-16v-15.7h16v15.7z m0-31.4h-16v-15.7h16v15.7z m0-31.4h-16V629h16v15.7z m0-31.4h-16v-15.7h16v15.7z m0-31.4h-16v-15.7h16v15.7z m0-31.5h-16v-15.7h16v15.7z m0-31.4h-16v-15.7h16V519z m0-31.4h-16v-15.7h16v15.7z m0-31.4h-16v-15.7h16v15.7z m0-31.4h-16v-15.7h16v15.7z m0-31.4h-16v-15.7h16v15.7z m0-31.4h-16v-15.7h16V362z m0-31.5h-16v-15.7h16v15.7z m0-31.4h-16v-15.7h16v15.7z m0-31.4h-16V252h16v15.7z m0-31.4h-16v-15.7h16v15.7z m0-31.4h-16v-15.7h16v15.7zM223.2 157.5h16v16h-16zM770 173.5h-15.6v-16H770v16z m-31.2 0h-15.6v-16h15.6v16z m-31.2 0H692v-16h15.6v16z m-31.3 0h-15.6v-16h15.6v16z m-31.2 0h-15.6v-16h15.6v16z m-31.2 0h-15.6v-16h15.6v16z m-31.2 0H567v-16h15.6v16z m-31.3 0h-15.6v-16h15.6v16z m-31.2 0h-15.6v-16h15.6v16z m-31.2 0h-15.6v-16H489v16z m-31.3 0h-15.6v-16h15.6v16z m-31.2 0h-15.6v-16h15.6v16z m-31.2 0h-15.6v-16h15.6v16z m-31.2 0h-15.6v-16h15.6v16z m-31.3 0h-15.6v-16h15.6v16z m-31.2 0H286v-16h15.6v16z m-31.2 0h-15.6v-16h15.6v16zM785.6 157.5h16v16h-16zM801.6 833.2h-16v-15.7h16v15.7z m0-31.4h-16V786h16v15.8z m0-31.5h-16v-15.7h16v15.7z m0-31.4h-16v-15.7h16v15.7z m0-31.4h-16v-15.7h16v15.7z m0-31.4h-16v-15.7h16v15.7z m0-31.4h-16V629h16v15.7z m0-31.4h-16v-15.7h16v15.7z m0-31.4h-16v-15.7h16v15.7z m0-31.5h-16v-15.7h16v15.7z m0-31.4h-16v-15.7h16V519z m0-31.4h-16v-15.7h16v15.7z m0-31.4h-16v-15.7h16v15.7z m0-31.4h-16v-15.7h16v15.7z m0-31.4h-16v-15.7h16v15.7z m0-31.4h-16v-15.7h16V362z m0-31.5h-16v-15.7h16v15.7z m0-31.4h-16v-15.7h16v15.7z m0-31.4h-16V252h16v15.7z m0-31.4h-16v-15.7h16v15.7z m0-31.4h-16v-15.7h16v15.7z"
        fill="#0A0408"
      />
      <path
        d="M752.2 791.2l-235.4-85.9-244.2 85.9V196.6h479.6z"
        fill="#55B7A8"
      />
      <path
        d="M512.4 305.7l42.9 86.8 95.8 13.9-69.4 67.6 16.4 95.5-85.7-45.1-85.7 45.1 16.4-95.5-69.4-67.6 95.8-13.9z"
        fill="#EBB866"
      />
      <path
        d="M608.7 584.1l-96.3-50.6-96.3 50.6 18.4-107.3-77.9-76 107.7-15.7 48.2-97.6 48.2 97.6 107.7 15.7-77.9 76 18.2 107.3z m-96.3-68.7l75.1 39.5-14.3-83.6 60.7-59.2-83.9-12.2-37.5-76.1-37.5 76.1-84.1 12.1 60.7 59.2-14.3 83.6 75.1-39.4z"
        fill="#0A0408"
      />
      <path d="M205.7 140h50.9v50.9h-50.9z" fill="#DC444A" />
      <path
        d="M264.6 198.9h-66.9V132h66.9v66.9z m-50.9-16h34.9V148h-34.9v34.9z"
        fill="#0A0408"
      />
      <path d="M768.2 140h50.9v50.9h-50.9z" fill="#DC444A" />
      <path
        d="M827.1 198.9h-66.9V132h66.9v66.9z m-50.9-16h34.9V148h-34.9v34.9z"
        fill="#0A0408"
      />
    </svg>
  ),
  networkPeople: (
    <svg
      xmlns="http://www.w3.org/2000/svg"
      width="100%"
      height="100%"
      className="pointer-events-none"
      viewBox="0 0 63.59 79.11">
      <g>
        <g>
          <path
            d="m48.22,36.93H15.37c-.36,0-.65-.29-.65-.65v-12.08c0-.27.16-.51.41-.61l11.29-4.44c.24-.09.5-.04.69.14l4.52,4.34,4.87-4.36c.18-.16.44-.21.67-.12l11.3,4.44c.25.1.41.34.41.61v12.08c0,.36-.29.65-.65.65Zm-32.21-1.3h31.56v-10.99l-10.51-4.13-5.02,4.49c-.25.23-.64.22-.88-.02l-4.65-4.47-10.49,4.12v10.99Z"
            style={{ strokeWidth: "0px" }}
          />
          <path
            d="m42.69,36.91h-21.79c-.36,0-.65-.29-.65-.65v-7.58c0-.36.29-.65.65-.65s.65.29.65.65v6.93h20.49v-6.93c0-.36.29-.65.65-.65s.65.29.65.65v7.58c0,.36-.29.65-.65.65Z"
            style={{ strokeWidth: "0px" }}
          />
          <path
            d="m37.23,26.21h-10.87c-.36,0-.65-.29-.65-.65v-5.8c0-.36.29-.65.65-.65s.65.29.65.65v5.15h9.57v-5.15c0-.36.29-.65.65-.65s.65.29.65.65v5.8c0,.36-.29.65-.65.65Z"
            style={{ strokeWidth: "0px" }}
          />
          <path
            d="m33.43,29.99h-3.27c-.36,0-.65-.29-.65-.65v-3.78c0-.36.29-.65.65-.65h3.27c.36,0,.65.29.65.65v3.78c0,.36-.29.65-.65.65Zm-2.62-1.3h1.97v-2.48h-1.97v2.48Z"
            style={{ strokeWidth: "0px" }}
          />
          <path
            d="m34.76,36.93h-6.28c-.2,0-.39-.09-.51-.25-.12-.16-.17-.36-.12-.55l1.68-6.94c.07-.29.33-.5.63-.5h3.27c.31,0,.58.22.64.53l1.33,6.94c.04.19-.01.39-.14.54-.12.15-.31.24-.5.24Zm-5.45-1.3h4.66l-1.08-5.64h-2.22l-1.36,5.64Z"
            style={{ strokeWidth: "0px" }}
          />
          <path
            d="m31.94,17.59c-4.85,0-8.79-3.94-8.79-8.79S27.09,0,31.94,0s8.8,3.94,8.8,8.79-3.95,8.79-8.8,8.79Zm0-16.29c-4.13,0-7.49,3.36-7.49,7.49s3.36,7.49,7.49,7.49,7.5-3.36,7.5-7.49-3.37-7.49-7.5-7.49Z"
            style={{ strokeWidth: "0px" }}
          />
          <path
            d="m38.12,7.58c-2.19,0-4.23-.64-5.74-1.81-.28-.22-.34-.63-.12-.91.22-.28.63-.34.91-.12,1.63,1.26,4.2,1.81,6.55,1.4.36-.06.69.18.75.53.06.35-.18.69-.53.75-.6.1-1.22.16-1.83.16Z"
            style={{ strokeWidth: "0px" }}
          />
          <path
            d="m27.65,7.42c-1.3,0-2.53-.22-3.65-.65-.33-.13-.5-.51-.37-.84.13-.34.5-.5.84-.37.97.38,2.04.57,3.18.57,3.65,0,6.62-2.04,6.62-4.55,0-.36.29-.65.65-.65s.65.29.65.65c0,3.22-3.55,5.85-7.92,5.85Z"
            style={{ strokeWidth: "0px" }}
          />
          <path
            d="m62.94,79.11c-.36,0-.65-.29-.65-.65v-3.04c0-2.37-1.93-4.3-4.31-4.3h-7.16c-2.38,0-4.31,1.93-4.31,4.3v3.04c0,.36-.29.65-.65.65s-.65-.29-.65-.65v-3.04c0-3.09,2.52-5.6,5.61-5.6h7.16c3.09,0,5.61,2.51,5.61,5.6v3.04c0,.36-.29.65-.65.65Zm-23.48,0c-.36,0-.65-.29-.65-.65v-3.04c0-2.37-1.93-4.3-4.31-4.3h-7.16c-2.38,0-4.31,1.93-4.31,4.3v3.04c0,.36-.29.65-.65.65s-.65-.29-.65-.65v-3.04c0-3.09,2.52-5.6,5.61-5.6h7.16c3.09,0,5.61,2.51,5.61,5.6v3.04c0,.36-.29.65-.65.65Zm-21.73,0c-.36,0-.65-.29-.65-.65v-3.04c0-2.37-1.93-4.3-4.31-4.3h-7.16c-2.38,0-4.31,1.93-4.31,4.3v3.04c0,.36-.29.65-.65.65s-.65-.29-.65-.65v-3.04c0-3.09,2.52-5.6,5.61-5.6h7.16c3.09,0,5.61,2.51,5.61,5.6v3.04c0,.36-.29.65-.65.65Zm36.55-10.17c-2.93,0-5.31-2.38-5.31-5.31s2.38-5.29,5.31-5.29,5.3,2.38,5.3,5.29-2.38,5.31-5.3,5.31Zm-3.99-4.97c.17,2.05,1.9,3.67,3.99,3.67,2.21,0,4-1.8,4-4.01,0-.15,0-.3-.02-.45-1.13.1-2.31-.18-3.27-.78-1.2,1.26-3,1.86-4.7,1.57Zm.1-1.3c.25.05.5.07.76.07,1.27,0,2.44-.59,3.21-1.61.11-.14.27-.23.44-.25.17-.02.35.03.49.14.72.59,1.68.89,2.6.88-.65-1.34-2.02-2.26-3.61-2.26-1.88,0-3.45,1.29-3.89,3.03Zm-19.59,6.27c-2.93,0-5.31-2.38-5.31-5.31s2.38-5.29,5.31-5.29,5.31,2.38,5.31,5.29-2.38,5.31-5.31,5.31Zm-3.99-4.97c.17,2.05,1.9,3.67,3.99,3.67,2.21,0,4.01-1.8,4.01-4.01,0-.15,0-.3-.02-.45-1.11.09-2.31-.18-3.27-.78-1.19,1.25-3.03,1.84-4.7,1.57Zm.1-1.3c.25.05.5.07.77.07,1.25,0,2.45-.6,3.2-1.6.11-.14.26-.23.44-.26.18-.02.35.03.49.14.72.59,1.68.9,2.6.88-.65-1.34-2.02-2.26-3.61-2.26-1.87,0-3.45,1.29-3.89,3.03Zm-17.85,6.27c-2.93,0-5.31-2.38-5.31-5.31s2.38-5.29,5.31-5.29,5.31,2.38,5.31,5.29-2.38,5.31-5.31,5.31Zm-3.99-4.97c.17,2.05,1.9,3.67,3.99,3.67,2.21,0,4.01-1.8,4.01-4.01,0-.15,0-.3-.03-.45-1.11.1-2.3-.17-3.27-.78-.99,1.05-2.36,1.64-3.83,1.64-.3,0-.59-.02-.87-.07Zm.1-1.3c.25.05.5.07.77.07,1.27,0,2.44-.59,3.2-1.6.11-.14.26-.23.44-.26.18-.02.35.03.49.14.74.6,1.67.9,2.6.88-.65-1.34-2.02-2.26-3.61-2.26-1.87,0-3.45,1.29-3.89,3.03Z"
            style={{ strokeWidth: "0px" }}
          />
          <path
            d="m54.56,57.09c-.36,0-.65-.29-.65-.65v-8.94l-44.23-.49v9.22c0,.36-.29.65-.65.65s-.65-.29-.65-.65v-9.88c0-.17.07-.34.19-.46.12-.12.3-.17.46-.19l45.53.51c.36,0,.64.29.64.65v9.58c0,.36-.29.65-.65.65Z"
            style={{ strokeWidth: "0px" }}
          />
          <path
            d="m31.62,52.04c-.36,0-.65-.29-.65-.65v-15.11c0-.36.29-.65.65-.65s.65.29.65.65v15.11c0,.36-.29.65-.65.65Z"
            style={{ strokeWidth: "0px" }}
          />
        </g>
      </g>
    </svg>
  ),
  notepad: (
    <svg
      xmlns="http://www.w3.org/2000/svg"
      width="100%"
      height="100%"
      className="pointer-events-none"
      viewBox="0 0 70.88 79.11">
      <g>
        <g>
          <path
            d="m53.59,79.11H.65c-.36,0-.65-.29-.65-.65V3.91c0-.36.29-.65.65-.65h52.94c.36,0,.65.29.65.65v74.55c0,.36-.29.65-.65.65Zm-52.29-1.3h51.64V4.56H1.3v73.25Z"
            style={{ strokeWidth: "0px" }}
          />
          <path
            d="m64.17,78c-.25,0-.48-.14-.58-.37l-5.92-12.19c-.04-.09-.07-.19-.07-.28V23.07c0-.36.29-.65.65-.65h11.84c.36,0,.65.29.65.65v42.08c0,.1-.02.2-.07.28l-5.92,12.19c-.11.22-.34.37-.58.37Zm-5.27-12.99l5.27,10.85,5.27-10.85V23.72h-10.54v41.28Z"
            style={{ strokeWidth: "0px" }}
          />
          <path
            d="m64.17,78c-.25,0-.48-.14-.58-.37l-1.69-3.47c-.09-.18-.09-.39,0-.57.09-.18.25-.31.44-.35,1.13-.26,2.53-.26,3.66,0,.19.04.36.17.44.35.09.18.08.39,0,.56l-1.68,3.47c-.11.22-.34.37-.58.37h0Zm-.72-3.62l.72,1.48.72-1.48c-.46-.04-.97-.04-1.43,0Z"
            style={{ strokeWidth: "0px" }}
          />
          <path
            d="m70.23,65.83c-.11,0-.23-.03-.33-.09l-1.91-1.13-1.21,1.04c-.23.2-.56.21-.8.04l-1.91-1.37-1.31,1.31c-.12.12-.29.19-.46.19h0c-.17,0-.34-.07-.46-.19l-1.3-1.31-1.91,1.37c-.29.21-.7.14-.91-.15-.21-.29-.14-.7.15-.91l2.36-1.7c.26-.19.62-.16.84.07l1.23,1.24,1.24-1.24c.23-.23.58-.25.84-.07l1.94,1.4,1.18-1.02c.21-.18.52-.21.76-.07l2.31,1.37c.31.18.41.58.23.89-.12.2-.34.32-.56.32Z"
            style={{ strokeWidth: "0px" }}
          />
          <path
            d="m60.9,64.29c-.36,0-.65-.29-.65-.65V23.07c0-.36.29-.65.65-.65s.65.29.65.65v40.57c0,.36-.29.65-.65.65Z"
            style={{ strokeWidth: "0px" }}
          />
          <path
            d="m63.96,64.49c-.36,0-.65-.29-.65-.65l-.19-40.76c0-.36.29-.65.65-.65h0c.36,0,.65.29.65.65l.19,40.76c0,.36-.29.65-.65.65h0Z"
            style={{ strokeWidth: "0px" }}
          />
          <path
            d="m67.05,64.96c-.36,0-.65-.29-.65-.65V23.07c0-.36.29-.65.65-.65s.65.29.65.65v41.24c0,.36-.29.65-.65.65Z"
            style={{ strokeWidth: "0px" }}
          />
          <path
            d="m70.09,23.72h-11.84c-.36,0-.65-.29-.65-.65v-3.07c0-2.05,1.67-3.72,3.72-3.72h5.69c2.05,0,3.72,1.67,3.72,3.72v3.07c0,.36-.29.65-.65.65Zm-11.19-1.3h10.54v-2.42c0-1.34-1.09-2.42-2.42-2.42h-5.69c-1.34,0-2.42,1.09-2.42,2.42v2.42Z"
            style={{ strokeWidth: "0px" }}
          />
          <path
            d="m44.69,24.28H9.55c-.36,0-.65-.29-.65-.65v-8.48c0-.36.29-.65.65-.65h35.14c.36,0,.65.29.65.65v8.48c0,.36-.29.65-.65.65Zm-34.49-1.3h33.84v-7.18H10.2v7.18Z"
            style={{ strokeWidth: "0px" }}
          />
          <path
            d="m44.04,29.87H10.2c-.36,0-.65-.29-.65-.65s.29-.65.65-.65h33.84c.36,0,.65.29.65.65s-.29.65-.65.65Z"
            style={{ strokeWidth: "0px" }}
          />
          <path
            d="m44.04,35.18H10.2c-.36,0-.65-.29-.65-.65s.29-.65.65-.65h33.84c.36,0,.65.29.65.65s-.29.65-.65.65Z"
            style={{ strokeWidth: "0px" }}
          />
          <path
            d="m44.04,40.5h-23.29c-.36,0-.65-.29-.65-.65s.29-.65.65-.65h23.29c.36,0,.65.29.65.65s-.29.65-.65.65Z"
            style={{ strokeWidth: "0px" }}
          />
          <path
            d="m35.57,45.8H10.2c-.36,0-.65-.29-.65-.65s.29-.65.65-.65h25.37c.36,0,.65.29.65.65s-.29.65-.65.65Z"
            style={{ strokeWidth: "0px" }}
          />
          <path
            d="m44.04,51.12H10.2c-.36,0-.65-.29-.65-.65s.29-.65.65-.65h33.84c.36,0,.65.29.65.65s-.29.65-.65.65Z"
            style={{ strokeWidth: "0px" }}
          />
          <path
            d="m44.04,56.43h-26.73c-.36,0-.65-.29-.65-.65s.29-.65.65-.65h26.73c.36,0,.65.29.65.65s-.29.65-.65.65Z"
            style={{ strokeWidth: "0px" }}
          />
          <path
            d="m44.04,61.74H10.2c-.36,0-.65-.29-.65-.65s.29-.65.65-.65h33.84c.36,0,.65.29.65.65s-.29.65-.65.65Z"
            style={{ strokeWidth: "0px" }}
          />
          <path
            d="m48.09,7.82c-.36,0-.65-.29-.65-.65V.65c0-.36.29-.65.65-.65s.65.29.65.65v6.52c0,.36-.29.65-.65.65Zm-6.99,0c-.36,0-.65-.29-.65-.65V.65c0-.36.29-.65.65-.65s.65.29.65.65v6.52c0,.36-.29.65-.65.65Zm-6.99,0c-.36,0-.65-.29-.65-.65V.65c0-.36.29-.65.65-.65s.65.29.65.65v6.52c0,.36-.29.65-.65.65Zm-6.99,0c-.36,0-.65-.29-.65-.65V.65c0-.36.29-.65.65-.65s.65.29.65.65v6.52c0,.36-.29.65-.65.65Zm-6.99,0c-.36,0-.65-.29-.65-.65V.65c0-.36.29-.65.65-.65s.65.29.65.65v6.52c0,.36-.29.65-.65.65Zm-6.99,0c-.36,0-.65-.29-.65-.65V.65c0-.36.29-.65.65-.65s.65.29.65.65v6.52c0,.36-.29.65-.65.65Zm-6.99,0c-.36,0-.65-.29-.65-.65V.65c0-.36.29-.65.65-.65s.65.29.65.65v6.52c0,.36-.29.65-.65.65Z"
            style={{ strokeWidth: "0px" }}
          />
        </g>
      </g>
    </svg>
  ),
  notify: (
    <svg
      xmlns="http://www.w3.org/2000/svg"
      width="100%"
      height="100%"
      className="pointer-events-none"
      viewBox="0 0 1024 1024">
      <path
        d="M639.9 327v16.2c35.5 5.5 68.1 22.1 94 48C766.2 423.5 784 466.4 784 512c0 45.6-17.8 88.5-50.1 120.8-25.9 25.9-58.5 42.4-94 48V697c90.5-13 160-90.9 160-185s-69.5-172-160-185z"
        fill="#E73B37"
      />
      <path
        d="M723.8 215.2v16.4c15 3.6 29.7 8.5 44 14.5 34.4 14.5 65.2 35.3 91.7 61.8s47.3 57.3 61.8 91.7C936.4 435.2 944 473 944 512c0 38.9-7.6 76.7-22.7 112.3-14.5 34.4-35.3 65.2-61.8 91.7s-57.3 47.3-91.7 61.8c-14.3 6.1-29 10.9-44 14.5v16.4C859.1 777.7 960 656.6 960 512S859.1 246.2 723.8 215.2zM277.5 386.8h16v250h-16z"
        fill="#E73B37"
      />
      <path
        d="M277.5 386.8v9.2h16v-9.2h-16z m0 241.2v8.8h16V628h-16z"
        fill="#39393A"
      />
      <path
        d="M616.4 458.4c-11-11.1-25.5-18.7-41.5-21.3V112l-297 240H64v320h214l296.9 240V586.9c36.1-5.8 63.8-37.3 63.8-74.9 0-20.9-8.5-39.9-22.3-53.6z m-85.6 361.4L305.6 637.7l-12.1-9.8v8.8h-16V628H108V396h169.5v-9.2h16v9.2l12.1-9.8 225.2-182.1v615.7z m74.3-265.6c-8.4 8.4-18.9 14.1-30.2 16.4V453.3c11.3 2.3 21.8 7.9 30.2 16.4 11.4 11.3 17.6 26.4 17.6 42.3 0 15.9-6.3 30.9-17.6 42.2z"
        fill="#39393A"
      />
    </svg>
  ),
  piggyBank: (
    <svg
      xmlns="http://www.w3.org/2000/svg"
      width="100%"
      height="100%"
      className="pointer-events-none"
      viewBox="0 0 1024 1024"
      fill="#000000">
      <path
        d="M233.79 240.016c-30.874 0-55.996-25.124-55.996-55.998s25.124-55.996 55.996-55.996 55.998 25.124 55.998 55.996-25.126 55.998-55.998 55.998z m0-95.994c-22.052 0-39.998 17.944-39.998 39.998s17.944 39.998 39.998 39.998 39.998-17.944 39.998-39.998-17.946-39.998-39.998-39.998z"
        fill=""
      />
      <path
        d="M233.79 272.014c-30.874 0-55.996-25.124-55.996-55.998 0-4.42 3.578-8 8-8 4.42 0 8 3.578 8 8 0 22.054 17.944 39.998 39.998 39.998s39.998-17.944 39.998-39.998c0-4.42 3.578-8 8-8 4.42 0 8 3.578 8 8-0.004 30.874-25.128 55.998-56 55.998z"
        fill=""
      />
      <path
        d="M233.79 208.018c-4.422 0-8-3.578-8-8V168.022c0-4.422 3.578-8 8-8s8 3.578 8 8v31.998c0 4.42-3.58 7.998-8 7.998zM185.792 224.018c-4.422 0-8-3.578-8-8V184.02c0-4.42 3.578-8 8-8 4.42 0 8 3.578 8 8v31.998c0 4.422-3.578 8-8 8zM281.788 224.018c-4.422 0-8-3.578-8-8V184.02c0-4.42 3.578-8 8-8 4.42 0 8 3.578 8 8v31.998a7.998 7.998 0 0 1-8 8zM753.766 96.026c-26.466 0-47.998-21.53-47.998-47.998S727.3 0.03 753.766 0.03s47.998 21.53 47.998 47.998-21.532 47.998-47.998 47.998z m0-79.996c-17.654 0-31.998 14.35-31.998 31.998s14.344 31.998 31.998 31.998c17.624 0 31.998-14.35 31.998-31.998s-14.376-31.998-31.998-31.998z"
        fill=""
      />
      <path
        d="M753.766 128.024c-26.466 0-47.998-21.53-47.998-47.998 0-4.42 3.562-8 8-8 4.406 0 8 3.578 8 8 0 17.648 14.344 31.998 31.998 31.998 17.624 0 31.998-14.35 31.998-31.998 0-4.42 3.562-8 8-8 4.406 0 8 3.578 8 8 0 26.468-21.532 47.998-47.998 47.998z"
        fill=""
      />
      <path
        d="M713.768 86.026c-4.438 0-8-3.578-8-8V48.028c0-4.42 3.562-8 8-8 4.406 0 8 3.578 8 8v29.998c0 4.422-3.594 8-8 8zM793.764 87.276c-4.438 0-8-3.578-8-8V48.028c0-4.42 3.562-8 8-8 4.406 0 8 3.578 8 8v31.248c0 4.422-3.594 8-8 8zM753.766 64.028c-4.438 0-8-3.578-8-8v-15.998c0-4.422 3.562-8 8-8 4.406 0 8 3.578 8 8v15.998c0 4.422-3.594 8-8 8zM105.796 623.992c-4.422 0-8-3.578-8-7.998 0-197.372 175.692-351.978 399.976-351.978 4.422 0 8 3.578 8 8s-3.578 8-8 8c-215.314 0-383.976 147.578-383.976 335.98a7.994 7.994 0 0 1-8 7.996zM857.728 751.984a7.976 7.976 0 0 1-7.812-6.436c-0.876-4.328 1.938-8.532 6.282-9.406 74.684-14.936 91.87-29.81 92.056-29.966 3.218-2.876 8.216-2.782 11.216 0.376s3 8.032-0.062 11.094c-1.812 1.812-20.03 18.17-100.086 34.184a7.958 7.958 0 0 1-1.594 0.154zM953.754 559.996a7.942 7.942 0 0 1-5.376-2.078c-0.062-0.032-17.966-14.452-92.276-30.09-4.312-0.906-7.094-5.156-6.188-9.476s5.218-7.094 9.468-6.18c78.994 16.624 97.836 32.186 99.742 33.904a7.984 7.984 0 0 1 0.532 11.294 7.89 7.89 0 0 1-5.902 2.626z"
        fill=""
      />
      <path
        d="M953.754 719.988c-4.438 0-8-3.578-8-8v-159.99c0-4.422 3.562-8 8-8a8.006 8.006 0 0 1 7.998 8v159.99c0 4.422-3.594 8-7.998 8zM713.736 914.976a8.016 8.016 0 0 1-7.844-6.532 7.98 7.98 0 0 1 6.376-9.328c135.554-25.482 137.46-149.852 137.492-155.13 0-4.422 3.594-8 8-8 4.406 0.016 8 3.594 8 8 0 1.422-1.718 142.866-150.524 170.85-0.5 0.094-1 0.14-1.5 0.14zM857.728 528a7.99 7.99 0 0 1-7.844-6.594c-11.656-65.136-40.654-116.612-75.746-134.32-3.938-1.992-5.5-6.804-3.532-10.75 2-3.946 6.844-5.538 10.75-3.532 40.06 20.234 71.558 74.738 84.278 145.79a7.996 7.996 0 0 1-7.906 9.406zM569.808 286.06a8.7 8.7 0 0 1-1.344-0.11 422.88 422.88 0 0 0-70.692-5.938c-4.422 0-8-3.578-8-8s3.578-8 8-8a439.46 439.46 0 0 1 73.378 6.156 7.998 7.998 0 0 1 6.53 9.234 7.98 7.98 0 0 1-7.872 6.658z"
        fill=""
      />
      <path
        d="M760.734 416.006a7.972 7.972 0 0 1-7.906-7.04c-9.718-80.26 16.404-145.374 28.404-170.24-38.06-2.944-159.896-3.1-204.02 108.228a8.032 8.032 0 0 1-10.404 4.492 8 8 0 0 1-4.468-10.382c56.184-141.732 230.892-117.172 232.612-116.96a8.044 8.044 0 0 1 6.032 4.46 8.16 8.16 0 0 1-0.312 7.5c-0.438 0.742-43.498 75.69-31.968 170.982a8 8 0 0 1-7.97 8.96zM537.748 1023.968a8.008 8.008 0 0 1-7.906-6.844l-15.984-108.992a7.974 7.974 0 0 1 6.75-9.062c4.438-0.718 8.438 2.376 9.078 6.75l16 108.992a7.96 7.96 0 0 1-6.75 9.062 7.432 7.432 0 0 1-1.188 0.094z"
        fill=""
      />
      <path
        d="M713.768 1023.968H537.78c-4.438 0-8-3.578-8-8s3.562-8 8-8h175.988c4.406 0 8 3.578 8 8s-3.594 8-8 8z"
        fill=""
      />
      <path
        d="M713.768 1023.968c-0.376 0-0.782-0.032-1.156-0.094a8.004 8.004 0 0 1-6.782-9.062l16-108.992c0.656-4.376 4.812-7.39 9.094-6.75a7.96 7.96 0 0 1 6.75 9.062l-16 108.992a8.006 8.006 0 0 1-7.906 6.844zM281.78 1023.968a8 8 0 0 1-7.914-6.876l-16-111.992a7.994 7.994 0 0 1 6.788-9.046c4.336-0.64 8.422 2.422 9.054 6.796l16 111.992a7.994 7.994 0 0 1-7.928 9.126z"
        fill=""
      />
      <path
        d="M457.776 1023.968h-175.988c-4.422 0-8-3.578-8-8s3.578-8 8-8h175.988c4.422 0 8 3.578 8 8s-3.578 8-8 8z"
        fill=""
      />
      <path
        d="M457.784 1023.968c-0.382 0-0.774-0.032-1.172-0.094a7.976 7.976 0 0 1-6.75-9.062l16-108.992c0.64-4.376 4.632-7.5 9.078-6.75a7.978 7.978 0 0 1 6.75 9.062l-16 108.992a8 8 0 0 1-7.906 6.844z"
        fill=""
      />
      <path
        d="M281.788 911.976c-0.922 0-1.86-0.156-2.774-0.5-189.136-69.934-181.31-293.592-181.208-295.842 0.204-4.422 4.374-7.532 8.342-7.64a8.01 8.01 0 0 1 7.64 8.344c-0.094 2.156-7.296 214.284 170.77 280.138a7.988 7.988 0 0 1 4.726 10.282 7.996 7.996 0 0 1-7.496 5.218z"
        fill=""
      />
      <path
        d="M105.812 496a8.014 8.014 0 0 1-5.632-2.312c-73.65-72.948-17.466-153.53-16.888-154.334a8.03 8.03 0 0 1 9.664-2.688 8.01 8.01 0 0 1 4.696 8.874c-0.46 2.382-10.584 58.652 43.88 87.386a8.006 8.006 0 0 1 3.344 10.812 8.008 8.008 0 0 1-10.812 3.344c-34.748-18.334-47.292-46.668-51.418-69.23-7.976 26.14-9.93 66.106 28.802 104.462A7.996 7.996 0 1 1 105.812 496z"
        fill=""
      />
      <path
        d="M361.782 272.014c-4.422 0-8-3.578-8-8V56.028c0-4.42 3.578-8 8-8s8 3.578 8 8v207.988a7.994 7.994 0 0 1-8 7.998z"
        fill=""
      />
      <path
        d="M633.774 64.028H361.782c-4.422 0-8-3.578-8-8 0-4.42 3.578-8 8-8h271.992a8.006 8.006 0 0 1 7.998 8c0 4.422-3.594 8-7.998 8z"
        fill=""
      />
      <path
        d="M633.774 224.018c-4.438 0-8-3.578-8-8V56.028c0-4.42 3.562-8 8-8a8.006 8.006 0 0 1 7.998 8v159.99c0 4.422-3.594 8-7.998 8z"
        fill=""
      />
      <path
        d="M601.776 256.016c-4.438 0-8-3.578-8-8V110.658a24.082 24.082 0 0 1-14.624-14.632h-162.74a24.114 24.114 0 0 1-14.632 14.632v137.358c0 4.422-3.578 8-8 8s-8-3.578-8-8V104.026c0-4.422 3.578-8 8-8 4.414 0 8-3.586 8-8 0-4.42 3.578-8 8-8h175.996c4.406 0 8 3.578 8 8 0 4.414 3.594 8 8 8s8 3.578 8 8v143.99c0 4.422-3.594 8-8 8z"
        fill=""
      />
      <path
        d="M553.778 256.016a7.984 7.984 0 0 1-7.998-8c0-22.052-17.954-39.998-40.006-39.998-22.054 0-39.998 17.944-39.998 39.998 0 4.422-3.578 8-8 8s-8-3.578-8-8c0-30.874 25.124-55.996 55.998-55.996 30.88 0 56.004 25.124 56.004 55.996 0 4.422-3.594 8-8 8z"
        fill=""
      />
      <path
        d="M497.774 783.984c-4.422 0-8-3.578-8-8v-335.98c0-4.42 3.578-8 8-8s8 3.578 8 8v335.98c0 4.422-3.578 8-8 8z"
        fill=""
      />
      <path
        d="M553.778 735.986H409.78c-4.422 0-8-3.578-8-8a7.994 7.994 0 0 1 8-7.998h143.998c13 0 22.374-3.204 24.53-8.344 2.124-5.156-2.25-14.062-11.436-23.25l-149.156-133.178c-19.858-19.828-18.046-34.17-15.226-40.982 2.82-6.804 11.67-18.234 39.288-18.234h143.998c4.406 0 8 3.578 8 8 0 4.422-3.594 8-8 8h-143.998c-12.984 0-22.366 3.204-24.506 8.36-2.132 5.156 2.25 14.044 11.428 23.232l149.138 133.18c19.876 19.842 18.062 34.17 15.25 40.982-2.812 6.81-11.688 18.232-39.31 18.232z"
        fill=""
      />
      <path
        d="M537.78 914.976h-80.004c-4.422 0-8-3.578-8-8s3.578-8 8-8h80.004c4.406 0 8 3.578 8 8s-3.594 8-8 8z"
        fill=""
      />
    </svg>
  ),
  pin: (
    <svg
      xmlns="http://www.w3.org/2000/svg"
      width="100%"
      height="100%"
      className="pointer-events-none"
      viewBox="0 0 24 24"
      fill="none">
      <path
        d="M17 10C17 11.7279 15.0424 14.9907 13.577 17.3543C12.8967 18.4514 12.5566 19 12 19C11.4434 19 11.1033 18.4514 10.423 17.3543C8.95763 14.9907 7 11.7279 7 10C7 7.23858 9.23858 5 12 5C14.7614 5 17 7.23858 17 10Z"
        stroke="#464455"
        strokeLinecap="round"
        strokeLinejoin="round"
      />
      <path
        d="M14.5 10C14.5 11.3807 13.3807 12.5 12 12.5C10.6193 12.5 9.5 11.3807 9.5 10C9.5 8.61929 10.6193 7.5 12 7.5C13.3807 7.5 14.5 8.61929 14.5 10Z"
        stroke="#464455"
        strokeLinecap="round"
        strokeLinejoin="round"
      />
    </svg>
  ),
  programmingWindow: (
    <svg
      xmlns="http://www.w3.org/2000/svg"
      width="100%"
      height="100%"
      className="pointer-events-none"
      viewBox="0 0 1024 1024"
      fill="#000000">
      <path
        d="M1015.848 687.82H8.156a7.992 7.992 0 0 1-7.998-7.996 7.994 7.994 0 0 1 7.998-7.998h1007.692a7.992 7.992 0 0 1 7.996 7.998 7.992 7.992 0 0 1-7.996 7.996zM512 767.766c-17.636 0-31.99-14.34-31.99-31.99s14.354-31.99 31.99-31.99 31.992 14.34 31.992 31.99-14.356 31.99-31.992 31.99z m0-47.984c-8.81 0-15.996 7.184-15.996 15.994s7.186 15.994 15.996 15.994c8.824 0 15.996-7.184 15.996-15.994s-7.172-15.994-15.996-15.994zM376.152 975.732a8.01 8.01 0 0 1-7.826-9.73l31.99-143.956c0.968-4.296 5.294-6.954 9.544-6.078a8.014 8.014 0 0 1 6.078 9.544l-31.99 143.956a8 8 0 0 1-7.796 6.264zM647.864 975.732a8 8 0 0 1-7.808-6.264l-31.988-143.956a8.01 8.01 0 0 1 6.074-9.544 7.99 7.99 0 0 1 9.542 6.078l31.992 143.956a8.008 8.008 0 0 1-7.812 9.73z"
        fill=""
      />
      <path
        d="M671.954 975.732H352.05a7.992 7.992 0 0 1-7.998-7.998 7.992 7.992 0 0 1 7.998-7.996h319.904a7.992 7.992 0 0 1 7.996 7.996 7.992 7.992 0 0 1-7.996 7.998zM967.86 640.086H56.14a7.994 7.994 0 0 1-7.998-7.998V104.25a7.994 7.994 0 0 1 7.998-7.998h911.72c4.422 0 8 3.578 8 7.998v527.838a7.994 7.994 0 0 1-8 7.998z m-903.722-15.996h895.726V112.248H64.138v511.842z"
        fill=""
      />
      <path
        d="M967.86 800.038H56.14c-30.866 0-55.982-25.118-55.982-55.982V104.25c0-30.866 25.118-55.982 55.982-55.982h911.72c30.868 0 55.984 25.118 55.984 55.982v639.804c0 30.866-25.118 55.984-55.984 55.984zM56.14 64.262c-22.04 0-39.988 17.94-39.988 39.988v639.804c0 22.054 17.948 39.986 39.988 39.986h911.72c22.058 0 39.988-17.932 39.988-39.986V104.25c0-22.048-17.93-39.988-39.988-39.988H56.14z"
        fill=""
      />
      <path
        d="M967.86 831.778H56.14c-31.38 0-55.982-24.586-55.982-55.982v-31.99a7.994 7.994 0 0 1 7.998-7.998 7.994 7.994 0 0 1 7.998 7.998v31.99c0 22.43 17.574 39.986 39.988 39.986h911.72c22.434 0 39.988-17.556 39.988-39.986v-31.74a7.994 7.994 0 0 1 8-7.998 7.992 7.992 0 0 1 7.996 7.998v31.74c-0.002 31.396-24.588 55.982-55.986 55.982zM88.13 640.086a7.994 7.994 0 0 1-7.998-7.998V104.25a7.994 7.994 0 0 1 7.998-7.998 7.994 7.994 0 0 1 7.998 7.998v527.838a7.994 7.994 0 0 1-7.998 7.998z"
        fill=""
      />
      <path
        d="M72.136 160.232H56.14c-4.42 0-7.998-3.576-7.998-7.998s3.578-7.998 7.998-7.998h15.996c4.42 0 7.998 3.576 7.998 7.998s-3.578 7.998-7.998 7.998zM72.136 208.218H56.14c-4.42 0-7.998-3.578-7.998-7.998s3.578-7.998 7.998-7.998h15.996c4.42 0 7.998 3.578 7.998 7.998s-3.578 7.998-7.998 7.998zM72.136 256.204H56.14c-4.42 0-7.998-3.576-7.998-7.998s3.578-7.998 7.998-7.998h15.996c4.42 0 7.998 3.576 7.998 7.998s-3.578 7.998-7.998 7.998zM72.136 304.19H56.14c-4.42 0-7.998-3.578-7.998-7.998s3.578-7.998 7.998-7.998h15.996c4.42 0 7.998 3.578 7.998 7.998s-3.578 7.998-7.998 7.998z"
        fill=""
      />
      <path
        d="M72.136 352.174H56.14c-4.42 0-7.998-3.576-7.998-7.998s3.578-7.998 7.998-7.998h15.996c4.42 0 7.998 3.576 7.998 7.998s-3.578 7.998-7.998 7.998z"
        fill=""
      />
      <path
        d="M72.136 400.16H56.14a7.994 7.994 0 0 1-7.998-7.998 7.994 7.994 0 0 1 7.998-7.998h15.996a7.994 7.994 0 0 1 7.998 7.998 7.996 7.996 0 0 1-7.998 7.998z"
        fill=""
      />
      <path
        d="M72.136 448.144H56.14a7.994 7.994 0 0 1-7.998-7.998 7.994 7.994 0 0 1 7.998-7.998h15.996a7.994 7.994 0 0 1 7.998 7.998 7.994 7.994 0 0 1-7.998 7.998z"
        fill=""
      />
      <path
        d="M72.136 496.13H56.14a7.994 7.994 0 0 1-7.998-7.998 7.994 7.994 0 0 1 7.998-7.998h15.996a7.994 7.994 0 0 1 7.998 7.998 7.996 7.996 0 0 1-7.998 7.998z"
        fill=""
      />
      <path
        d="M72.136 544.116H56.14a7.994 7.994 0 0 1-7.998-7.998 7.992 7.992 0 0 1 7.998-7.996h15.996a7.992 7.992 0 0 1 7.998 7.996 7.994 7.994 0 0 1-7.998 7.998z"
        fill=""
      />
      <path
        d="M72.136 592.102H56.14c-4.42 0-7.998-3.578-7.998-7.998s3.578-7.998 7.998-7.998h15.996c4.42 0 7.998 3.578 7.998 7.998s-3.578 7.998-7.998 7.998z"
        fill=""
      />
      <path
        d="M200.096 160.232h-63.98c-4.42 0-7.998-3.576-7.998-7.998s3.576-7.998 7.998-7.998h63.98c4.42 0 7.998 3.576 7.998 7.998s-3.578 7.998-7.998 7.998zM488.006 208.218H264.076c-4.42 0-7.998-3.578-7.998-7.998s3.576-7.998 7.998-7.998h223.93c4.422 0 7.998 3.578 7.998 7.998s-3.576 7.998-7.998 7.998zM232.086 208.218H152.11c-4.42 0-7.998-3.578-7.998-7.998s3.578-7.998 7.998-7.998h79.976c4.42 0 7.998 3.578 7.998 7.998s-3.578 7.998-7.998 7.998zM679.95 256.204H472.012c-4.42 0-7.998-3.576-7.998-7.998s3.578-7.998 7.998-7.998h207.936c4.422 0 7.996 3.576 7.996 7.998s-3.572 7.998-7.994 7.998zM775.918 256.204h-63.98c-4.418 0-7.996-3.576-7.996-7.998s3.578-7.998 7.996-7.998h63.98c4.422 0 8 3.576 8 7.998s-3.578 7.998-8 7.998zM440.022 256.204H168.106c-4.42 0-7.998-3.576-7.998-7.998s3.576-7.998 7.998-7.998h271.916c4.42 0 7.998 3.576 7.998 7.998s-3.578 7.998-7.998 7.998zM216.09 352.174H168.106c-4.42 0-7.998-3.576-7.998-7.998s3.576-7.998 7.998-7.998h47.986c4.42 0 7.998 3.576 7.998 7.998s-3.58 7.998-8 7.998zM485.508 352.174H248.082c-4.42 0-7.998-3.576-7.998-7.998s3.578-7.998 7.998-7.998h237.428c4.42 0 7.998 3.576 7.998 7.998s-3.58 7.998-8 7.998zM551.988 304.19H184.1c-4.42 0-7.998-3.578-7.998-7.998s3.578-7.998 7.998-7.998h367.888c4.422 0 7.996 3.578 7.996 7.998s-3.574 7.998-7.996 7.998zM535.992 400.16h-143.956a7.994 7.994 0 0 1-7.998-7.998 7.994 7.994 0 0 1 7.998-7.998h143.956c4.422 0 8 3.578 8 7.998a7.994 7.994 0 0 1-8 7.998zM424.028 448.144H152.11a7.994 7.994 0 0 1-7.998-7.998 7.994 7.994 0 0 1 7.998-7.998h271.916a7.994 7.994 0 0 1 7.998 7.998 7.992 7.992 0 0 1-7.996 7.998zM280.072 544.116h-127.96a7.994 7.994 0 0 1-7.998-7.998 7.992 7.992 0 0 1 7.998-7.996h127.96a7.992 7.992 0 0 1 7.998 7.996 7.994 7.994 0 0 1-7.998 7.998zM599.972 496.13H376.042a7.994 7.994 0 0 1-7.998-7.998 7.994 7.994 0 0 1 7.998-7.998h223.93c4.422 0 8 3.578 8 7.998a7.994 7.994 0 0 1-8 7.998zM647.958 496.13h-15.992c-4.422 0-8-3.578-8-7.998a7.994 7.994 0 0 1 8-7.998h15.992c4.422 0 8 3.578 8 7.998s-3.58 7.998-8 7.998zM344.052 496.13H168.106a7.994 7.994 0 0 1-7.998-7.998 7.994 7.994 0 0 1 7.998-7.998h175.946a7.994 7.994 0 0 1 7.998 7.998 7.994 7.994 0 0 1-7.998 7.998zM200.096 592.102h-63.98c-4.42 0-7.998-3.578-7.998-7.998s3.576-7.998 7.998-7.998h63.98c4.42 0 7.998 3.578 7.998 7.998s-3.578 7.998-7.998 7.998zM551.988 448.144h-95.972a7.994 7.994 0 0 1-7.998-7.998 7.994 7.994 0 0 1 7.998-7.998h95.972a7.992 7.992 0 0 1 7.996 7.998 7.99 7.99 0 0 1-7.996 7.998zM679.95 400.16h-111.964c-4.422 0-8-3.578-8-7.998a7.994 7.994 0 0 1 8-7.998h111.964a7.992 7.992 0 0 1 7.996 7.998 7.992 7.992 0 0 1-7.996 7.998zM360.046 400.16h-191.94a7.994 7.994 0 0 1-7.998-7.998 7.994 7.994 0 0 1 7.998-7.998h191.942a7.994 7.994 0 0 1 7.998 7.998 7.996 7.996 0 0 1-8 7.998z"
        fill=""
      />
    </svg>
  ),
  responsive: (
    <svg
      xmlns="http://www.w3.org/2000/svg"
      width="100%"
      height="100%"
      className="pointer-events-none"
      viewBox="0 0 1024 1024"
      fill="#000000">
      <path
        d="M88.606 128.118c-4.412 0-8.076-3.576-8.076-7.998s3.5-7.998 7.92-7.998h0.156c4.42 0 7.998 3.576 7.998 7.998s-3.578 7.998-7.998 7.998zM120.596 128.118c-4.412 0-8.076-3.576-8.076-7.998s3.5-7.998 7.92-7.998h0.156c4.42 0 7.998 3.576 7.998 7.998s-3.578 7.998-7.998 7.998zM152.586 128.118c-4.412 0-8.076-3.576-8.076-7.998s3.5-7.998 7.92-7.998h0.156c4.42 0 7.998 3.576 7.998 7.998s-3.578 7.998-7.998 7.998zM679.95 687.696H8.156a7.992 7.992 0 0 1-7.998-7.996 7.994 7.994 0 0 1 7.998-7.998h671.794a7.99 7.99 0 0 1 7.996 7.998 7.99 7.99 0 0 1-7.996 7.996zM512 767.64c-17.644 0-31.99-14.34-31.99-31.99S494.356 703.66 512 703.66c17.652 0 31.992 14.34 31.992 31.99S529.652 767.64 512 767.64z m0-47.984c-8.818 0-15.996 7.184-15.996 15.994s7.178 15.994 15.996 15.994c8.816 0 15.996-7.184 15.996-15.994s-7.18-15.994-15.996-15.994zM376.144 975.608a8.01 8.01 0 0 1-7.818-9.73l31.99-143.956c0.96-4.296 5.294-6.954 9.544-6.078a8.014 8.014 0 0 1 6.078 9.544l-31.99 143.956a8.004 8.004 0 0 1-7.804 6.264zM647.864 975.608a8 8 0 0 1-7.808-6.264l-31.988-143.956a8.01 8.01 0 0 1 6.074-9.544c4.296-0.89 8.59 1.782 9.542 6.078l31.992 143.956a8.008 8.008 0 0 1-7.812 9.73z"
        fill=""
      />
      <path
        d="M671.954 975.608H352.05a7.992 7.992 0 0 1-7.998-7.998 7.992 7.992 0 0 1 7.998-7.996h319.904a7.992 7.992 0 0 1 7.996 7.996 7.992 7.992 0 0 1-7.996 7.998zM967.86 943.618h-175.946c-30.864 0-55.98-25.118-55.98-55.982V535.742c0-30.866 25.118-55.982 55.98-55.982h175.946c30.868 0 55.984 25.118 55.984 55.982v351.892c0 30.866-25.118 55.984-55.984 55.984z m-175.946-447.864c-22.054 0-39.988 17.94-39.988 39.988v351.892c0 22.056 17.934 39.988 39.988 39.988h175.946c22.058 0 39.988-17.932 39.988-39.988V535.742c0-22.046-17.93-39.988-39.988-39.988h-175.946z"
        fill=""
      />
      <path
        d="M983.856 655.958H775.918a7.994 7.994 0 0 1-7.996-7.998v-95.97a7.992 7.992 0 0 1 7.996-7.998h207.938a7.99 7.99 0 0 1 7.996 7.998v95.97a7.992 7.992 0 0 1-7.996 7.998z m-199.938-15.998h191.942v-79.976h-191.942v79.976zM983.856 799.912H775.918a7.992 7.992 0 0 1-7.996-7.998v-111.964a7.992 7.992 0 0 1 7.996-7.998h207.938a7.99 7.99 0 0 1 7.996 7.998v111.964a7.99 7.99 0 0 1-7.996 7.998z m-199.938-15.996h191.942v-95.97h-191.942v95.97zM903.878 527.996h-47.984c-4.422 0-7.996-3.578-7.996-7.998s3.574-7.998 7.996-7.998h47.984c4.422 0 8 3.578 8 7.998s-3.578 7.998-8 7.998z"
        fill=""
      />
      <path
        d="M952.368 591.976h-143.958c-4.422 0-8-3.578-8-7.998s3.578-7.998 8-7.998h143.958c4.418 0 7.996 3.578 7.996 7.998s-3.578 7.998-7.996 7.998zM919.876 623.964H840.9a7.992 7.992 0 0 1-7.996-7.996 7.992 7.992 0 0 1 7.996-7.998h78.976a7.99 7.99 0 0 1 7.996 7.998 7.99 7.99 0 0 1-7.996 7.996zM880.386 927.874c-13.23 0-23.992-10.764-23.992-23.994s10.762-23.992 23.992-23.992 23.992 10.762 23.992 23.992-10.76 23.994-23.992 23.994z m0-31.992a8.012 8.012 0 0 0-7.996 7.996 8.014 8.014 0 0 0 7.996 7.998c4.406 0 8-3.592 8-7.998a8.014 8.014 0 0 0-8-7.996zM983.856 831.902H775.918c-4.418 0-7.996-3.578-7.996-7.998s3.578-7.998 7.996-7.998h207.938c4.422 0 7.996 3.578 7.996 7.998s-3.574 7.998-7.996 7.998zM983.856 863.892H775.918c-4.418 0-7.996-3.578-7.996-7.998s3.578-7.998 7.996-7.998h207.938c4.422 0 7.996 3.578 7.996 7.998s-3.574 7.998-7.996 7.998zM983.856 799.912a7.986 7.986 0 0 1-6.872-3.904l-41.114-68.762-41.114 68.762a8 8 0 0 1-13.746-8.184l47.984-80.258c2.906-4.842 10.844-4.842 13.746 0l47.988 80.258a8.006 8.006 0 0 1-2.782 10.964 8.06 8.06 0 0 1-4.09 1.124z"
        fill=""
      />
      <path
        d="M839.898 799.912a7.924 7.924 0 0 1-4.418-1.344 7.98 7.98 0 0 1-2.234-11.074l31.988-48.236c2.938-4.466 10.376-4.466 13.308 0l23.586 35.552a7.982 7.982 0 0 1-2.23 11.074c-3.704 2.468-8.672 1.438-11.074-2.232l-16.934-25.508-25.336 38.192a7.932 7.932 0 0 1-6.656 3.576zM472.02 591.976a8 8 0 0 1-6.716-3.64l-97.26-149.634-97.258 149.634a8.01 8.01 0 0 1-11.068 2.36 8.016 8.016 0 0 1-2.35-11.074l103.968-159.952c2.954-4.546 10.466-4.546 13.418 0l103.968 159.952a8.016 8.016 0 0 1-2.352 11.074 7.948 7.948 0 0 1-4.35 1.28z"
        fill=""
      />
      <path
        d="M200.088 591.976a7.994 7.994 0 0 1-6.646-12.434l63.98-95.87a8 8 0 0 1 13.308 0l31.522 47.244a7.994 7.994 0 0 1-2.218 11.09c-3.67 2.422-8.646 1.454-11.09-2.216l-24.868-37.27-57.326 85.896a8 8 0 0 1-6.662 3.56zM824.406 751.926c-13.23 0-23.996-10.762-23.996-23.992s10.766-23.992 23.996-23.992 23.992 10.762 23.992 23.992-10.762 23.992-23.992 23.992z m0-31.988c-4.406 0-8 3.592-8 7.996a8.014 8.014 0 0 0 8 7.998 8.014 8.014 0 0 0 7.996-7.998 8.012 8.012 0 0 0-7.996-7.996zM184.1 480.01c-22.048 0-39.988-17.94-39.988-39.988 0-22.046 17.94-39.986 39.988-39.986s39.988 17.94 39.988 39.986c0 22.048-17.94 39.988-39.988 39.988z m0-63.98c-13.23 0-23.992 10.762-23.992 23.992s10.762 23.994 23.992 23.994 23.992-10.762 23.992-23.994c0-13.23-10.76-23.992-23.992-23.992zM967.86 144.114H56.14a7.994 7.994 0 0 1-7.998-7.998 7.994 7.994 0 0 1 7.998-7.998h911.72c4.422 0 8 3.578 8 7.998a7.994 7.994 0 0 1-8 7.998zM919.876 320.058H104.124a7.994 7.994 0 0 1-7.998-7.998V184.1a7.994 7.994 0 0 1 7.998-7.998h815.75a7.99 7.99 0 0 1 7.996 7.998v127.96a7.988 7.988 0 0 1-7.994 7.998z m-807.754-15.994h799.756V192.098H112.122v111.966z"
        fill=""
      />
      <path
        d="M488.006 591.976H104.124a7.994 7.994 0 0 1-7.998-7.998V360.046a7.994 7.994 0 0 1 7.998-7.998h383.882a7.994 7.994 0 0 1 7.998 7.998v223.932a7.994 7.994 0 0 1-7.998 7.998zM112.122 575.98h367.888V368.044H112.122V575.98zM919.876 432.024H535.992a7.994 7.994 0 0 1-7.996-7.998 7.994 7.994 0 0 1 7.996-7.998h383.882a7.992 7.992 0 0 1 7.996 7.998 7.988 7.988 0 0 1-7.994 7.998zM919.876 384.04H535.992c-4.418 0-7.996-3.576-7.996-7.998s3.578-7.998 7.996-7.998h383.882c4.422 0 7.996 3.576 7.996 7.998s-3.574 7.998-7.994 7.998zM695.946 480.01h-159.954a7.992 7.992 0 0 1-7.996-7.998 7.994 7.994 0 0 1 7.996-7.998h159.954a7.994 7.994 0 0 1 7.996 7.998 7.992 7.992 0 0 1-7.996 7.998zM679.95 527.996h-143.958c-4.418 0-7.996-3.578-7.996-7.998s3.578-7.998 7.996-7.998h143.958c4.422 0 7.996 3.578 7.996 7.998s-3.574 7.998-7.996 7.998zM679.95 575.98h-143.958c-4.418 0-7.996-3.578-7.996-7.998s3.578-7.998 7.996-7.998h143.958c4.422 0 7.996 3.578 7.996 7.998s-3.574 7.998-7.996 7.998zM1015.848 112.124c-4.422 0-8-3.578-8-7.998 0-22.422-17.554-39.988-39.988-39.988H56.14c-22.422 0-39.988 17.566-39.988 39.988a7.994 7.994 0 0 1-7.998 7.998 7.994 7.994 0 0 1-7.998-7.998c0-31.388 24.594-55.982 55.982-55.982h911.72c31.398 0 55.984 24.594 55.984 55.982a7.99 7.99 0 0 1-7.994 7.998zM679.95 831.902H56.14c-31.388 0-55.982-24.586-55.982-55.984v-31.988a7.994 7.994 0 0 1 7.998-7.998 7.994 7.994 0 0 1 7.998 7.998v31.988c0 22.432 17.566 39.988 39.988 39.988h623.81c4.422 0 7.996 3.578 7.996 7.998s-3.576 7.998-7.998 7.998z"
        fill=""
      />
      <path
        d="M679.95 799.772H56.14c-31.388 0-55.982-24.602-55.982-55.982V711.8a7.994 7.994 0 0 1 7.998-7.998 7.994 7.994 0 0 1 7.998 7.998v31.99c0 22.414 17.566 39.988 39.988 39.988h623.81a7.99 7.99 0 0 1 7.996 7.996 7.994 7.994 0 0 1-7.998 7.998z"
        fill=""
      />
      <path
        d="M8.156 719.796a7.994 7.994 0 0 1-7.998-7.998V104.124a7.994 7.994 0 0 1 7.998-7.998 7.994 7.994 0 0 1 7.998 7.998v607.674a7.996 7.996 0 0 1-7.998 7.998zM1015.848 448.02c-4.422 0-8-3.576-8-7.998V104.124a7.994 7.994 0 0 1 8-7.998 7.994 7.994 0 0 1 7.996 7.998V440.02c0 4.424-3.578 8-7.996 8zM967.86 112.124H56.14a7.994 7.994 0 0 1-7.998-7.998 7.994 7.994 0 0 1 7.998-7.998h911.72c4.422 0 8 3.578 8 7.998a7.994 7.994 0 0 1-8 7.998zM679.95 639.96H56.14c-4.42 0-7.998-3.578-7.998-7.998s3.578-7.998 7.998-7.998h623.81c4.422 0 7.996 3.578 7.996 7.998s-3.574 7.998-7.996 7.998z"
        fill=""
      />
      <path
        d="M56.14 639.96a7.994 7.994 0 0 1-7.998-7.998V104.124a7.994 7.994 0 0 1 7.998-7.998 7.994 7.994 0 0 1 7.998 7.998v527.838a7.994 7.994 0 0 1-7.998 7.998zM967.86 432.024a7.994 7.994 0 0 1-7.996-7.998V104.124a7.994 7.994 0 0 1 7.996-7.998c4.422 0 8 3.578 8 7.998v319.902a7.994 7.994 0 0 1-8 7.998zM967.86 975.858h-175.946c-31.394 0-55.98-24.586-55.98-55.982v-31.99c0-4.42 3.574-7.998 7.996-7.998s7.996 3.578 7.996 7.998v31.99c0 22.43 17.558 39.988 39.988 39.988h175.946c22.434 0 39.988-17.558 39.988-39.988v-31.74a7.994 7.994 0 0 1 8-7.998 7.994 7.994 0 0 1 7.996 7.998v31.74c0 31.396-24.586 55.982-55.984 55.982z"
        fill=""
      />
      <path
        d="M855.894 256.078H168.106c-4.42 0-7.998-3.576-7.998-7.998s3.576-7.998 7.998-7.998h687.79c4.422 0 7.996 3.576 7.996 7.998s-3.576 7.998-7.998 7.998z"
        fill=""
      />
    </svg>
  ),
  structure: (
    <svg
      xmlns="http://www.w3.org/2000/svg"
      width="100%"
      height="100%"
      className="pointer-events-none"
      viewBox="0 0 1024 1024"
      fill="#000000">
      <path
        d="M288.554 32.146c-4.422 0-8.076-3.576-8.076-7.996 0-4.422 3.498-7.998 7.904-7.998h0.172a8.004 8.004 0 0 1 7.998 7.998 8.004 8.004 0 0 1-7.998 7.996zM320.544 32.146c-4.422 0-8.076-3.576-8.076-7.996 0-4.422 3.498-7.998 7.904-7.998h0.172a8 8 0 0 1 7.996 7.998 8 8 0 0 1-7.996 7.996zM352.534 32.146c-4.42 0-8.076-3.576-8.076-7.996 0-4.422 3.498-7.998 7.904-7.998h0.17a8.002 8.002 0 0 1 7.998 7.998 8 8 0 0 1-7.996 7.996z"
        fill=""
      />
      <path
        d="M767.922 48.142H256.08a7.994 7.994 0 0 1-7.998-7.998v-15.994c0-13.23 10.762-23.994 23.992-23.994h479.852c13.23 0 23.992 10.764 23.992 23.994v15.994a7.992 7.992 0 0 1-7.996 7.998z m-503.846-15.996h495.85v-7.996a8.014 8.014 0 0 0-8-7.998H272.074a8.014 8.014 0 0 0-7.998 7.998v7.996z"
        fill=""
      />
      <path
        d="M767.922 384.04H256.08a7.994 7.994 0 0 1-7.998-7.998V40.144a7.994 7.994 0 0 1 7.998-7.998h511.842a7.992 7.992 0 0 1 7.996 7.998V376.04c0 4.422-3.574 8-7.996 8z m-503.846-15.996h495.85V48.142H264.076v319.902z"
        fill=""
      />
      <path
        d="M735.934 176.104H288.07a7.994 7.994 0 0 1-7.998-7.998V72.134a7.994 7.994 0 0 1 7.998-7.998h447.864a7.994 7.994 0 0 1 7.996 7.998v95.97c0 4.422-3.578 8-7.996 8z m-439.868-15.996h431.868V80.132H296.066v79.976z"
        fill=""
      />
      <path
        d="M687.946 128.118H336.054a7.994 7.994 0 0 1-7.998-7.998 7.992 7.992 0 0 1 7.998-7.996h351.892c4.422 0 8 3.576 8 7.996a7.994 7.994 0 0 1-8 7.998zM735.934 224.088H527.996c-4.422 0-8-3.576-8-7.998a7.994 7.994 0 0 1 8-7.996h207.938a7.992 7.992 0 0 1 7.996 7.996 7.992 7.992 0 0 1-7.996 7.998zM735.934 256.078H527.996c-4.422 0-8-3.576-8-7.998a7.994 7.994 0 0 1 8-7.996h207.938a7.992 7.992 0 0 1 7.996 7.996 7.992 7.992 0 0 1-7.996 7.998zM735.934 288.068H527.996c-4.422 0-8-3.576-8-7.998a7.994 7.994 0 0 1 8-7.996h207.938a7.992 7.992 0 0 1 7.996 7.996 7.992 7.992 0 0 1-7.996 7.998zM631.964 320.058h-103.968c-4.422 0-8-3.576-8-7.998a7.994 7.994 0 0 1 8-7.996h103.968a7.992 7.992 0 0 1 7.996 7.996 7.992 7.992 0 0 1-7.996 7.998zM496.004 352.048H288.07a7.994 7.994 0 0 1-7.998-7.998v-143.956a7.994 7.994 0 0 1 7.998-7.998h207.936a7.994 7.994 0 0 1 7.998 7.998v143.956a7.994 7.994 0 0 1-8 7.998z m-199.938-15.994h191.94v-127.96h-191.94v127.96z"
        fill=""
      />
      <path
        d="M480.01 352.048a8 8 0 0 1-6.856-3.888l-41.128-68.542-41.128 68.542c-2.28 3.81-7.2 5.044-10.966 2.748a7.976 7.976 0 0 1-2.748-10.964l47.984-79.974c2.876-4.844 10.84-4.844 13.714 0l47.986 79.974a7.974 7.974 0 0 1-2.75 10.964 7.846 7.846 0 0 1-4.108 1.14z"
        fill=""
      />
      <path
        d="M336.054 352.048a8 8 0 0 1-6.654-12.434l31.99-47.984c2.968-4.438 10.34-4.438 13.308 0l24.242 36.364a8 8 0 0 1-2.216 11.09 8.03 8.03 0 0 1-11.09-2.218l-17.588-26.38-25.336 38.004a8.002 8.002 0 0 1-6.656 3.558zM336.054 272.074c-13.23 0-23.992-10.764-23.992-23.994s10.762-23.992 23.992-23.992 23.994 10.762 23.994 23.992-10.764 23.994-23.994 23.994z m0-31.99a8.014 8.014 0 0 0-7.998 7.996 8.012 8.012 0 0 0 7.998 7.998 8.012 8.012 0 0 0 7.998-7.998 8.014 8.014 0 0 0-7.998-7.996zM512 622.966a7.994 7.994 0 0 1-7.998-7.998v-191.942a7.994 7.994 0 0 1 7.998-7.998 7.992 7.992 0 0 1 7.996 7.998v191.942a7.992 7.992 0 0 1-7.996 7.998z"
        fill=""
      />
      <path
        d="M512 622.966a7.994 7.994 0 0 1-5.654-13.652l15.994-15.996a7.996 7.996 0 1 1 11.308 11.31l-15.992 15.994a7.968 7.968 0 0 1-5.656 2.344z"
        fill=""
      />
      <path
        d="M512 622.966a7.972 7.972 0 0 1-5.654-2.344l-15.996-15.994a7.996 7.996 0 1 1 11.308-11.31l15.998 15.996a7.998 7.998 0 0 1-5.656 13.652z"
        fill=""
      />
      <path
        d="M144.112 622.966a7.994 7.994 0 0 1-7.998-7.998v-110.966a7.994 7.994 0 0 1 7.998-7.998 7.994 7.994 0 0 1 7.998 7.998v110.966a7.994 7.994 0 0 1-7.998 7.998z"
        fill=""
      />
      <path
        d="M144.112 622.966a7.994 7.994 0 0 1-5.654-13.652l15.996-15.996a7.996 7.996 0 1 1 11.308 11.31l-15.996 15.994a7.956 7.956 0 0 1-5.654 2.344z"
        fill=""
      />
      <path
        d="M144.112 622.966a7.976 7.976 0 0 1-5.654-2.344l-15.994-15.994a7.996 7.996 0 1 1 11.308-11.31l15.996 15.996a7.994 7.994 0 0 1-5.656 13.652z"
        fill=""
      />
      <path
        d="M416.514 687.946c-4.42 0-8.076-3.576-8.076-7.996 0-4.422 3.498-7.998 7.904-7.998h0.172a8.002 8.002 0 0 1 7.998 7.998 8.004 8.004 0 0 1-7.998 7.996zM448.504 687.946c-4.42 0-8.076-3.576-8.076-7.996 0-4.422 3.498-7.998 7.904-7.998h0.172a8.002 8.002 0 0 1 7.998 7.998 8.002 8.002 0 0 1-7.998 7.996zM480.494 687.946c-4.42 0-8.076-3.576-8.076-7.996 0-4.422 3.498-7.998 7.904-7.998h0.172a8.002 8.002 0 0 1 7.998 7.998 8 8 0 0 1-7.998 7.996z"
        fill=""
      />
      <path
        d="M647.958 703.942H376.042a7.994 7.994 0 0 1-7.998-7.998v-15.994c0-13.23 10.762-23.992 23.994-23.992h239.928c13.23 0 23.992 10.762 23.992 23.992v15.994c0 4.42-3.58 7.998-8 7.998z m-263.918-15.996h255.92v-7.996a8.014 8.014 0 0 0-7.996-7.998H392.038a8.012 8.012 0 0 0-7.998 7.998v7.996z"
        fill=""
      />
      <path
        d="M647.958 1023.844H376.042a7.994 7.994 0 0 1-7.998-7.998V695.944a7.994 7.994 0 0 1 7.998-7.998h271.916c4.422 0 8 3.578 8 7.998v319.902c0 4.42-3.58 7.998-8 7.998z m-263.918-15.996h255.92V703.942H384.04v303.906z"
        fill=""
      />
      <path
        d="M496.004 799.912h-87.972a7.994 7.994 0 0 1-7.998-7.998v-63.98a7.992 7.992 0 0 1 7.998-7.996h87.972a7.992 7.992 0 0 1 7.998 7.996v63.98a7.992 7.992 0 0 1-7.998 7.998z m-79.974-15.996h71.976v-47.984h-71.976v47.984zM615.968 735.932h-87.972c-4.422 0-8-3.576-8-7.998a7.994 7.994 0 0 1 8-7.996h87.972a7.99 7.99 0 0 1 7.996 7.996 7.99 7.99 0 0 1-7.996 7.998zM615.968 767.922h-87.972c-4.422 0-8-3.578-8-7.998s3.578-7.998 8-7.998h87.972c4.422 0 7.996 3.578 7.996 7.998s-3.574 7.998-7.996 7.998zM615.968 799.912h-87.972c-4.422 0-8-3.576-8-7.998a7.994 7.994 0 0 1 8-7.998h87.972a7.992 7.992 0 0 1 7.996 7.998 7.99 7.99 0 0 1-7.996 7.998z"
        fill=""
      />
      <path
        d="M615.968 895.882h-87.972c-4.422 0-8-3.578-8-7.998v-63.98a7.994 7.994 0 0 1 8-7.998h87.972a7.992 7.992 0 0 1 7.996 7.998v63.98a7.992 7.992 0 0 1-7.996 7.998z m-79.976-15.996h71.98v-47.984h-71.98v47.984zM496.004 831.902h-87.972c-4.42 0-7.998-3.578-7.998-7.998s3.578-7.998 7.998-7.998h87.972c4.42 0 7.998 3.578 7.998 7.998s-3.576 7.998-7.998 7.998zM496.004 863.892h-87.972c-4.42 0-7.998-3.578-7.998-7.998s3.578-7.998 7.998-7.998h87.972c4.42 0 7.998 3.578 7.998 7.998s-3.576 7.998-7.998 7.998zM496.004 895.882h-87.972c-4.42 0-7.998-3.578-7.998-7.998s3.578-7.998 7.998-7.998h87.972c4.42 0 7.998 3.578 7.998 7.998s-3.576 7.998-7.998 7.998z"
        fill=""
      />
      <path
        d="M496.004 991.854h-87.972a7.994 7.994 0 0 1-7.998-7.998v-63.98a7.994 7.994 0 0 1 7.998-7.998h87.972a7.994 7.994 0 0 1 7.998 7.998v63.98a7.994 7.994 0 0 1-7.998 7.998z m-79.974-15.996h71.976v-47.984h-71.976v47.984zM615.968 927.874h-87.972c-4.422 0-8-3.578-8-7.998s3.578-7.998 8-7.998h87.972c4.422 0 7.996 3.578 7.996 7.998s-3.574 7.998-7.996 7.998zM615.968 959.864h-87.972c-4.422 0-8-3.578-8-7.998s3.578-7.998 8-7.998h87.972c4.422 0 7.996 3.578 7.996 7.998s-3.574 7.998-7.996 7.998zM615.968 991.854h-87.972c-4.422 0-8-3.578-8-7.998s3.578-7.998 8-7.998h87.972c4.422 0 7.996 3.578 7.996 7.998s-3.574 7.998-7.996 7.998z"
        fill=""
      />
      <path
        d="M48.626 687.946c-4.42 0-8.076-3.576-8.076-7.996 0-4.422 3.5-7.998 7.904-7.998h0.172a8.002 8.002 0 0 1 7.998 7.998 8 8 0 0 1-7.998 7.996z"
        fill=""
      />
      <path
        d="M80.616 687.946c-4.42 0-8.076-3.576-8.076-7.996 0-4.422 3.5-7.998 7.904-7.998h0.172a8.002 8.002 0 0 1 7.998 7.998 8 8 0 0 1-7.998 7.996z"
        fill=""
      />
      <path
        d="M112.606 687.946c-4.42 0-8.076-3.576-8.076-7.996 0-4.422 3.5-7.998 7.904-7.998h0.172a8.002 8.002 0 0 1 7.998 7.998 8 8 0 0 1-7.998 7.996z"
        fill=""
      />
      <path
        d="M280.072 703.942H8.156a7.994 7.994 0 0 1-7.998-7.998v-15.994c0-13.23 10.762-23.992 23.992-23.992h239.926c13.23 0 23.994 10.762 23.994 23.992v15.994a7.994 7.994 0 0 1-7.998 7.998z m-263.92-15.996h255.92v-7.996a8.012 8.012 0 0 0-7.998-7.998H24.15a8.014 8.014 0 0 0-7.998 7.998v7.996z"
        fill=""
      />
      <path
        d="M280.072 1023.844H8.156a7.994 7.994 0 0 1-7.998-7.998V695.944a7.994 7.994 0 0 1 7.998-7.998h271.916a7.994 7.994 0 0 1 7.998 7.998v319.902a7.994 7.994 0 0 1-7.998 7.998z m-263.92-15.996h255.92V703.942H16.152v303.906z"
        fill=""
      />
      <path
        d="M248.082 815.906H40.146a7.992 7.992 0 0 1-7.998-7.996v-79.976a7.992 7.992 0 0 1 7.998-7.996h207.936a7.992 7.992 0 0 1 7.998 7.996v79.976c0 4.42-3.58 7.996-7.998 7.996z m-199.94-15.994h191.94v-63.98h-191.94v63.98z"
        fill=""
      />
      <path
        d="M88.13 927.874H40.146a7.994 7.994 0 0 1-7.998-7.998V839.9a7.992 7.992 0 0 1 7.998-7.996h47.984a7.992 7.992 0 0 1 7.998 7.996v79.976a7.996 7.996 0 0 1-7.998 7.998z m-39.988-15.998h31.99v-63.98H48.142v63.98z"
        fill=""
      />
      <path
        d="M168.106 927.874H120.12a7.994 7.994 0 0 1-7.998-7.998V839.9a7.992 7.992 0 0 1 7.998-7.996h47.986a7.992 7.992 0 0 1 7.998 7.996v79.976a7.996 7.996 0 0 1-7.998 7.998z m-39.988-15.998h31.99v-63.98H128.118v63.98z"
        fill=""
      />
      <path
        d="M248.082 927.874h-47.986a7.994 7.994 0 0 1-7.998-7.998V839.9a7.992 7.992 0 0 1 7.998-7.996h47.986a7.992 7.992 0 0 1 7.998 7.996v79.976a7.996 7.996 0 0 1-7.998 7.998z m-39.99-15.998h31.99v-63.98h-31.99v63.98z"
        fill=""
      />
      <path
        d="M248.082 959.864H40.146c-4.422 0-7.998-3.578-7.998-7.998s3.576-7.998 7.998-7.998h207.936c4.42 0 7.998 3.578 7.998 7.998s-3.58 7.998-7.998 7.998z"
        fill=""
      />
      <path
        d="M216.09 991.854H72.136c-4.422 0-7.998-3.578-7.998-7.998s3.576-7.998 7.998-7.998h143.956c4.42 0 7.998 3.578 7.998 7.998s-3.58 7.998-8 7.998z"
        fill=""
      />
      <path
        d="M776.402 991.854c-4.418 0-8.074-3.578-8.074-7.998s3.5-7.998 7.902-7.998h0.172c4.406 0 8 3.578 8 7.998s-3.594 7.998-8 7.998zM808.394 991.854c-4.422 0-8.078-3.578-8.078-7.998s3.5-7.998 7.906-7.998h0.172c4.402 0 7.996 3.578 7.996 7.998s-3.594 7.998-7.996 7.998zM840.382 991.854c-4.418 0-8.074-3.578-8.074-7.998s3.5-7.998 7.902-7.998h0.172c4.406 0 8 3.578 8 7.998s-3.592 7.998-8 7.998zM784.402 687.946c-4.422 0-8.078-3.576-8.078-7.996 0-4.422 3.5-7.998 7.906-7.998h0.172a8.002 8.002 0 0 1 7.996 7.998 8.002 8.002 0 0 1-7.996 7.996zM816.39 687.946c-4.418 0-8.074-3.576-8.074-7.996 0-4.422 3.5-7.998 7.902-7.998h0.172c4.406 0 8 3.576 8 7.998a8.004 8.004 0 0 1-8 7.996zM848.382 687.946c-4.422 0-8.078-3.576-8.078-7.996 0-4.422 3.5-7.998 7.906-7.998h0.172a8.002 8.002 0 0 1 7.996 7.998 8 8 0 0 1-7.996 7.996z"
        fill=""
      />
      <path
        d="M1015.848 703.942H743.93a7.992 7.992 0 0 1-7.996-7.998v-15.994c0-13.23 10.762-23.992 23.992-23.992h239.926c13.23 0 23.992 10.762 23.992 23.992v15.994a7.994 7.994 0 0 1-7.996 7.998z m-263.922-15.996h255.922v-7.996a8.014 8.014 0 0 0-7.996-7.998H759.926c-4.344 0-8 3.654-8 7.998v7.996z"
        fill=""
      />
      <path
        d="M1015.848 1023.844H743.93a7.992 7.992 0 0 1-7.996-7.998V695.944a7.992 7.992 0 0 1 7.996-7.998h271.918a7.994 7.994 0 0 1 7.996 7.998v319.902a7.994 7.994 0 0 1-7.996 7.998z m-263.922-15.996h255.922V703.942H751.926v303.906z"
        fill=""
      />
      <path
        d="M983.856 863.892H775.918a7.994 7.994 0 0 1-7.996-7.998v-95.97a7.994 7.994 0 0 1 7.996-7.998h207.938a7.992 7.992 0 0 1 7.996 7.998v95.97a7.992 7.992 0 0 1-7.996 7.998z m-199.938-15.996h191.942v-79.974h-191.942v79.974zM951.868 735.932h-143.958c-4.422 0-8-3.576-8-7.998a7.994 7.994 0 0 1 8-7.996h143.958a7.992 7.992 0 0 1 7.996 7.996 7.992 7.992 0 0 1-7.996 7.998zM983.856 895.882H775.918c-4.418 0-7.996-3.578-7.996-7.998s3.578-7.998 7.996-7.998h207.938c4.422 0 7.996 3.578 7.996 7.998s-3.574 7.998-7.996 7.998zM983.856 927.874H775.918c-4.418 0-7.996-3.578-7.996-7.998s3.578-7.998 7.996-7.998h207.938c4.422 0 7.996 3.578 7.996 7.998s-3.574 7.998-7.996 7.998z"
        fill=""
      />
      <path
        d="M887.886 959.864h-111.968c-4.418 0-7.996-3.578-7.996-7.998s3.578-7.998 7.996-7.998h111.968c4.418 0 7.996 3.578 7.996 7.998s-3.578 7.998-7.996 7.998z"
        fill=""
      />
      <path
        d="M472.012 512H144.112c-4.42 0-7.998-3.578-7.998-7.998s3.578-7.998 7.998-7.998h327.9c4.42 0 7.998 3.578 7.998 7.998S476.432 512 472.012 512z"
        fill=""
      />
      <path
        d="M879.886 622.966a7.994 7.994 0 0 1-7.996-7.998v-110.966a7.994 7.994 0 0 1 7.996-7.998c4.422 0 8 3.578 8 7.998v110.966a7.994 7.994 0 0 1-8 7.998z"
        fill=""
      />
      <path
        d="M879.886 622.966a7.968 7.968 0 0 1-5.652-2.344l-15.996-15.994a7.996 7.996 0 1 1 11.308-11.31l15.996 15.996a7.994 7.994 0 0 1-5.656 13.652z"
        fill=""
      />
      <path
        d="M879.886 622.966a7.994 7.994 0 0 1-5.652-13.652l15.992-15.996a8 8 0 0 1 11.312 11.31l-15.996 15.994a7.964 7.964 0 0 1-5.656 2.344z"
        fill=""
      />
      <path
        d="M879.886 512H551.988c-4.422 0-7.996-3.578-7.996-7.998s3.574-7.998 7.996-7.998h327.898c4.422 0 8 3.578 8 7.998s-3.578 7.998-8 7.998z"
        fill=""
      />
    </svg>
  ),
  sliderHorizontal: (
    <svg
      xmlns="http://www.w3.org/2000/svg"
      width="100%"
      height="100%"
      className="pointer-events-none"
      viewBox="0 0 24 24"
      fill="none">
      <path
        d="M5 6.75H12M5 17.25H12M5 12H6.75M17.25 6.75H19M17.25 6.75C17.25 7.7165 16.4665 8.5 15.5 8.5C14.5335 8.5 13.75 7.7165 13.75 6.75C13.75 5.7835 14.5335 5 15.5 5C16.4665 5 17.25 5.7835 17.25 6.75ZM17.25 17.25H19M17.25 17.25C17.25 18.2165 16.4665 19 15.5 19C14.5335 19 13.75 18.2165 13.75 17.25C13.75 16.2835 14.5335 15.5 15.5 15.5C16.4665 15.5 17.25 16.2835 17.25 17.25ZM12 12H19M12 12C12 12.9665 11.2165 13.75 10.25 13.75C9.2835 13.75 8.5 12.9665 8.5 12C8.5 11.0335 9.2835 10.25 10.25 10.25C11.2165 10.25 12 11.0335 12 12Z"
        stroke="#464455"
        strokeLinecap="round"
        strokeLinejoin="round"
      />
    </svg>
  ),
  star: (
    <svg
      xmlns="http://www.w3.org/2000/svg"
      width="100%"
      height="100%"
      className="pointer-events-none"
      viewBox="0 0 24 24"
      fill="none">
      <path
        d="M14.65 8.93274L12.4852 4.30901C12.2923 3.89699 11.7077 3.897 11.5148 4.30902L9.35002 8.93274L4.45559 9.68243C4.02435 9.74848 3.84827 10.2758 4.15292 10.5888L7.71225 14.2461L6.87774 19.3749C6.80571 19.8176 7.27445 20.1487 7.66601 19.9317L12 17.5299L16.334 19.9317C16.7256 20.1487 17.1943 19.8176 17.1223 19.3749L16.2878 14.2461L19.8471 10.5888C20.1517 10.2758 19.9756 9.74848 19.5444 9.68243L14.65 8.93274Z"
        stroke="#464455"
        strokeLinecap="round"
        strokeLinejoin="round"
      />
    </svg>
  ),
  planning: (
    <svg
      xmlns="http://www.w3.org/2000/svg"
      width="100%"
      height="100%"
      className="pointer-events-none"
      viewBox="0 0 1024 1024"
      fill="#000000">
      <path
        d="M208.508 583.99c-4.406 0-8.078-3.578-8.078-7.998 0-4.422 3.5-8 7.92-8h0.156c4.42 0 8 3.578 8 8a7.994 7.994 0 0 1-7.998 7.998z"
        fill=""
      />
      <path
        d="M999.936 767.966H56.058c-4.422 0-8-3.578-8-8V152.046c0-4.422 3.578-8 8-8h943.876c4.422 0 8 3.578 8 8v607.92a7.992 7.992 0 0 1-7.998 8z m-935.878-15.998h927.88V160.044H64.058v591.924z"
        fill=""
      />
      <path
        d="M775.964 416.012c-22.058 0-39.994-17.944-39.994-39.994 0-7.016 1.844-13.936 5.342-20.006a8.004 8.004 0 0 1 13.876 7.984 24.02 24.02 0 0 0-3.218 12.022c0 13.232 10.764 23.996 23.996 23.996s23.998-10.764 23.998-23.996a24.12 24.12 0 0 0-3.204-11.966 8 8 0 0 1 2.984-10.914c3.78-2.202 8.702-0.882 10.92 2.976a40.19 40.19 0 0 1 5.296 19.904c0 22.05-17.934 39.994-39.996 39.994z"
        fill=""
      />
      <path
        d="M775.964 384.016a7.992 7.992 0 0 1-7.998-7.998V216.04c0-4.422 3.576-8 7.998-8s8 3.578 8 8v159.978a7.994 7.994 0 0 1-8 7.998z"
        fill=""
      />
      <path
        d="M855.956 272.032h-63.992a7.994 7.994 0 0 1-7.998-8 7.994 7.994 0 0 1 7.998-7.998h55.994v-15.998h-55.994a7.994 7.994 0 0 1-7.998-8 7.994 7.994 0 0 1 7.998-7.998h63.992a7.994 7.994 0 0 1 7.998 7.998v31.996c0 4.422-3.578 8-7.998 8zM919.948 304.028h-79.99c-4.422 0-8-3.578-8-8a7.994 7.994 0 0 1 8-7.998h79.99a7.994 7.994 0 0 1 7.998 7.998c0 4.422-3.578 8-7.998 8zM919.948 272.032h-31.996c-4.422 0-8-3.578-8-8a7.994 7.994 0 0 1 8-7.998h31.996a7.994 7.994 0 0 1 7.998 7.998c0 4.422-3.578 8-7.998 8z"
        fill=""
      />
      <path
        d="M919.948 304.028a7.976 7.976 0 0 1-5.656-2.344l-15.998-15.998a7.996 7.996 0 0 1 0-11.31l15.998-15.998a7.996 7.996 0 1 1 11.31 11.31l-10.342 10.342 10.342 10.344a7.996 7.996 0 0 1-5.654 13.654zM208.04 623.984c-26.464 0-47.994-21.528-47.994-47.992 0-26.466 21.53-47.994 47.994-47.994s47.994 21.528 47.994 47.994-21.53 47.992-47.994 47.992z m0-79.988c-17.654 0-31.996 14.342-31.996 31.996 0 17.652 14.342 31.994 31.996 31.994 17.638 0 31.996-14.342 31.996-31.994 0-17.654-14.358-31.996-31.996-31.996zM256.034 535.996a7.95 7.95 0 0 1-5.906-2.61 7.982 7.982 0 0 1 0.516-11.294c184.524-168.486 459.518-138.326 462.268-138.022a7.99 7.99 0 0 1 7 8.876c-0.516 4.366-4.156 7.498-8.876 7.014-2.624-0.32-270.542-29.536-449.612 133.944a7.958 7.958 0 0 1-5.39 2.092z"
        fill=""
      />
      <path
        d="M679.976 416.012a8.008 8.008 0 0 1-7.154-4.42 8.006 8.006 0 0 1 3.578-10.734l31.996-15.998a8.004 8.004 0 0 1 10.732 3.578 8.004 8.004 0 0 1-3.578 10.732l-31.996 15.998a8.066 8.066 0 0 1-3.578 0.844z"
        fill=""
      />
      <path
        d="M711.972 400.014c-1.204 0-2.42-0.274-3.576-0.844l-31.996-15.998a8.004 8.004 0 0 1-3.578-10.732c1.984-3.954 6.78-5.514 10.732-3.578l31.996 15.998a8.006 8.006 0 0 1 3.578 10.734 8.008 8.008 0 0 1-7.156 4.42zM496.002 296.028a7.976 7.976 0 0 1-5.656-2.344l-31.996-31.996a8 8 0 0 1 11.312-11.31l31.996 31.996a7.996 7.996 0 0 1-5.656 13.654z"
        fill=""
      />
      <path
        d="M464.006 296.028a7.996 7.996 0 0 1-5.656-13.654l31.996-31.996a8 8 0 0 1 11.312 11.31l-31.996 31.996a7.976 7.976 0 0 1-5.656 2.344z"
        fill=""
      />
      <path
        d="M480.004 320.026c-26.464 0-47.994-21.53-47.994-47.994s21.53-47.994 47.994-47.994 47.994 21.53 47.994 47.994-21.53 47.994-47.994 47.994z m0-79.99c-17.638 0-31.996 14.35-31.996 31.996s14.358 31.996 31.996 31.996c17.654 0 31.996-14.35 31.996-31.996s-14.342-31.996-31.996-31.996zM264.016 368.018a7.986 7.986 0 0 1-5.656-2.342l-47.994-47.994a7.996 7.996 0 1 1 11.31-11.31l47.994 47.992a8 8 0 0 1-5.654 13.654z"
        fill=""
      />
      <path
        d="M216.022 368.018a8 8 0 0 1-5.656-13.654l47.994-47.992a8 8 0 0 1 11.312 11.31l-47.994 47.994a7.982 7.982 0 0 1-5.656 2.342zM447.992 647.982a7.976 7.976 0 0 1-5.656-2.344l-31.996-31.996a8 8 0 0 1 11.312-11.31l31.996 31.996a7.996 7.996 0 0 1-5.656 13.654z"
        fill=""
      />
      <path
        d="M415.996 647.982a7.996 7.996 0 0 1-5.656-13.654l31.996-31.996a8 8 0 0 1 11.312 11.31l-31.996 31.996a7.968 7.968 0 0 1-5.656 2.344z"
        fill=""
      />
      <path
        d="M432.01 671.978c-26.464 0-47.994-21.53-47.994-47.994s21.53-47.992 47.994-47.992 47.994 21.528 47.994 47.992-21.53 47.994-47.994 47.994z m0-79.99c-17.654 0-31.996 14.344-31.996 31.996 0 17.654 14.342 31.996 31.996 31.996 17.638 0 31.996-14.342 31.996-31.996 0-17.652-14.358-31.996-31.996-31.996zM647.982 591.988a7.976 7.976 0 0 1-5.656-2.344l-47.994-47.992a8 8 0 1 1 11.312-11.312l47.992 47.994a7.996 7.996 0 0 1-5.654 13.654z"
        fill=""
      />
      <path
        d="M599.988 591.988a7.996 7.996 0 0 1-5.656-13.654l47.994-47.994a8 8 0 0 1 11.31 11.312l-47.992 47.992a7.964 7.964 0 0 1-5.656 2.344zM831.958 663.98a7.976 7.976 0 0 1-5.654-2.344l-31.996-31.996a7.996 7.996 0 1 1 11.31-11.31l31.996 31.994a8 8 0 0 1-5.656 13.656z"
        fill=""
      />
      <path
        d="M799.962 663.98a8 8 0 0 1-5.656-13.656l31.996-31.994a7.996 7.996 0 1 1 11.31 11.31l-31.996 31.996a7.964 7.964 0 0 1-5.654 2.344z"
        fill=""
      />
      <path
        d="M815.96 687.976c-26.466 0-47.994-21.528-47.994-47.994 0-26.464 21.528-47.994 47.994-47.994 26.464 0 47.992 21.53 47.992 47.994 0.002 26.468-21.526 47.994-47.992 47.994z m0-79.99c-17.638 0-31.996 14.342-31.996 31.996s14.358 31.996 31.996 31.996c17.636 0 31.996-14.342 31.996-31.996s-14.358-31.996-31.996-31.996z"
        fill=""
      />
      <path
        d="M527.998 96.052h-31.996c-4.422 0-8-3.576-8-7.998V56.058a7.994 7.994 0 0 1 8-7.998h31.996a7.994 7.994 0 0 1 7.998 7.998v31.996a7.994 7.994 0 0 1-7.998 7.998zM504 80.056h15.998v-15.998H504v15.998z"
        fill=""
      />
      <path
        d="M1015.934 160.044H8.064a7.994 7.994 0 0 1-7.998-7.998V88.054a7.994 7.994 0 0 1 7.998-7.998h1007.87c4.422 0 8 3.576 8 7.998v63.992a7.994 7.994 0 0 1-8 7.998zM16.064 144.046h991.872V96.052H16.064v47.994z"
        fill=""
      />
      <path
        d="M967.942 128.048H56.058c-4.422 0-8-3.576-8-7.998s3.578-8 8-8H967.94c4.42 0 7.998 3.578 7.998 8s-3.576 7.998-7.996 7.998z"
        fill=""
      />
      <path
        d="M727.972 975.94a8.176 8.176 0 0 1-3.578-0.844l-215.972-107.986a8.002 8.002 0 0 1-3.578-10.732 8.008 8.008 0 0 1 10.734-3.578l215.97 107.986a8.002 8.002 0 0 1 3.578 10.732 8.02 8.02 0 0 1-7.154 4.422zM791.962 975.94a8.16 8.16 0 0 1-3.576-0.844l-279.964-139.982a8 8 0 0 1-3.578-10.732 8.008 8.008 0 0 1 10.734-3.578l279.962 139.982c3.954 1.968 5.544 6.782 3.578 10.732a8.02 8.02 0 0 1-7.156 4.422z"
        fill=""
      />
      <path
        d="M791.962 975.94h-63.99c-4.422 0-8-3.578-8-7.998 0-4.422 3.578-8 8-8h63.99c4.422 0 8 3.578 8 8a7.994 7.994 0 0 1-8 7.998z"
        fill=""
      />
      <path
        d="M296.042 975.94a8.02 8.02 0 0 1-7.17-4.422 8 8 0 0 1 3.578-10.732L508.422 852.8a8.004 8.004 0 0 1 10.732 3.578 7.988 7.988 0 0 1-3.576 10.732l-215.972 107.986a8.072 8.072 0 0 1-3.564 0.844zM232.05 975.94a8.024 8.024 0 0 1-7.17-4.422 8 8 0 0 1 3.578-10.732l279.964-139.982a8.004 8.004 0 0 1 10.732 3.578 7.988 7.988 0 0 1-3.576 10.732l-279.964 139.982a8.072 8.072 0 0 1-3.564 0.844z"
        fill=""
      />
      <path
        d="M296.028 975.94h-63.992a7.994 7.994 0 0 1-7.998-7.998c0-4.422 3.578-8 7.998-8h63.992c4.422 0 8 3.578 8 8a7.996 7.996 0 0 1-8 7.998z"
        fill=""
      />
      <path
        d="M496.002 843.958c-4.422 0-8-3.578-8-8v-75.99a7.994 7.994 0 0 1 8-7.998 7.994 7.994 0 0 1 7.998 7.998v75.99c0 4.42-3.578 8-7.998 8z"
        fill=""
      />
      <path
        d="M527.998 843.958c-4.422 0-8-3.578-8-8v-75.99a7.994 7.994 0 0 1 8-7.998 7.994 7.994 0 0 1 7.998 7.998v75.99c0 4.42-3.578 8-7.998 8z"
        fill=""
      />
      <path
        d="M527.998 975.94c-4.422 0-8-3.578-8-7.998v-99.988a7.994 7.994 0 0 1 8-7.998 7.994 7.994 0 0 1 7.998 7.998v99.988a7.994 7.994 0 0 1-7.998 7.998z"
        fill=""
      />
      <path
        d="M527.998 975.94h-31.996c-4.422 0-8-3.578-8-7.998 0-4.422 3.578-8 8-8h31.996a7.994 7.994 0 0 1 7.998 8 7.994 7.994 0 0 1-7.998 7.998z"
        fill=""
      />
      <path
        d="M496.002 975.94c-4.422 0-8-3.578-8-7.998v-99.988a7.994 7.994 0 0 1 8-7.998 7.994 7.994 0 0 1 7.998 7.998v99.988a7.994 7.994 0 0 1-7.998 7.998z"
        fill=""
      />
    </svg>
  ),
  seoTag: (
    <svg
      xmlns="http://www.w3.org/2000/svg"
      width="100%"
      height="100%"
      className="pointer-events-none"
      viewBox="0 0 1024 1024"
      fill="#000000">
      <path
        d="M361.478 1023.792c-14.336 0-28.666-5.466-39.576-16.368L16.574 702.098c-10.534-10.542-16.336-24.6-16.344-39.592 0-14.978 5.802-29.034 16.336-39.56L457.608 181.89c20.794-20.812 59.496-31.666 88.068-24.598l206.468 50.624c24.582 6.038 49.352 27.824 60.192 52.968a8.006 8.006 0 0 1-4.156 10.51c-4.058 1.742-8.776-0.102-10.526-4.17-8.714-20.194-29.924-39.014-49.32-43.776L541.866 172.824c-22.858-5.646-56.288 3.702-72.952 20.374L27.874 634.254c-7.512 7.496-11.652 17.538-11.652 28.252 0 10.728 4.146 20.756 11.66 28.284l305.33 305.328c15.586 15.588 40.958 15.588 56.544 0l441.008-441.046c16.682-16.68 26.02-50.078 20.396-72.952l-37.326-152.234a7.992 7.992 0 0 1 5.842-9.676 8.008 8.008 0 0 1 9.684 5.864l37.326 152.228c7.028 28.564-3.78 67.258-24.614 88.076L401.062 1007.426c-10.908 10.9-25.254 16.366-39.584 16.366z"
        fill=""
      />
      <path
        d="M663.902 423.99c-16.368 0-32.766-6.232-45.228-18.704-24.958-24.95-24.958-65.54-0.032-90.474 21.99-21.942 56.38-25.012 81.776-7.278a66.824 66.824 0 0 1 8.714 7.222 8.022 8.022 0 0 1 0.094 11.308 7.98 7.98 0 0 1-11.308 0.11 50.418 50.418 0 0 0-6.622-5.504c-19.086-13.322-44.856-11.002-61.348 5.458-18.678 18.694-18.678 49.134 0.032 67.852 18.71 18.708 49.166 18.708 67.876 0 5.654-5.678 9.84-12.69 12.09-20.264 1.248-4.224 5.746-6.654 9.932-5.396a8.02 8.02 0 0 1 5.404 9.94c-2.998 10.106-8.558 19.446-16.086 27.012-12.494 12.478-28.896 18.718-45.294 18.718z"
        fill=""
      />
      <path
        d="M663.84 392.042a31.68 31.68 0 0 1-22.55-9.356 31.796 31.796 0 0 1-9.372-22.644c0-17.624 14.368-31.97 31.984-31.97 4.438 0 7.996 3.576 7.996 7.996s-3.558 7.998-7.996 7.998c-8.808 0-15.992 7.176-15.992 15.994 0 4.28 1.656 8.292 4.686 11.314a15.734 15.734 0 0 0 11.244 4.678c4.842 0.376 8.902-1.93 11.934-5.318 2.998-3.288 8.058-3.552 11.306-0.624a8.016 8.016 0 0 1 0.624 11.292 31.97 31.97 0 0 1-23.802 10.642l-0.062-0.002zM372.794 964.54a7.972 7.972 0 0 1-5.654-2.344 7.992 7.992 0 0 1 0-11.306l373.164-373.204a7.994 7.994 0 0 1 11.308 0 7.992 7.992 0 0 1 0 11.306L378.448 962.196a7.972 7.972 0 0 1-5.654 2.344zM67.458 659.18a7.976 7.976 0 0 1-5.654-2.344 7.992 7.992 0 0 1 0-11.306l373.188-373.166a7.994 7.994 0 0 1 11.308 0 7.994 7.994 0 0 1 0 11.308L73.112 656.836a7.976 7.976 0 0 1-5.654 2.344zM333.398 812.046a8.004 8.004 0 0 1-6.786-3.766 7.988 7.988 0 0 1 2.538-11.01c10.69-6.714 38.92-28.33 41.122-47.666 0.71-6.324-1.522-11.994-6.848-17.304-14.322-14.32-37.63-12.15-62.338-9.884-27.284 2.544-55.498 5.138-75.122-14.51-5.856-5.84-8.442-13.056-7.488-20.818 2.896-23.568 38.866-45.776 42.958-48.244a8 8 0 0 1 10.962 2.75 7.978 7.978 0 0 1-2.732 10.962c-12.87 7.746-33.844 24.52-35.312 36.482-0.234 1.938-0.118 4.532 2.92 7.56 14.306 14.338 37.646 12.182 62.346 9.9 27.268-2.56 55.498-5.122 75.114 14.494 8.746 8.746 12.698 19.272 11.424 30.424-3.476 30.456-43.924 56.538-48.532 59.41a8.034 8.034 0 0 1-4.226 1.22zM494.184 588.336a7.98 7.98 0 0 1-5.654-2.342l-50.54-50.542c-3.124-3.124-3.124-8.176 0-11.298s8.184-3.124 11.308 0l50.54 50.532a7.994 7.994 0 0 1-5.654 13.65zM562.012 520.484a7.992 7.992 0 0 1-5.652-2.344l-50.508-50.538c-3.124-3.124-3.124-8.184 0-11.308s8.184-3.124 11.308 0l50.508 50.54a7.992 7.992 0 0 1 0 11.306 7.944 7.944 0 0 1-5.656 2.344z"
        fill=""
      />
      <path
        d="M443.644 537.796a7.972 7.972 0 0 1-5.654-2.344c-21.826-21.816-21.826-57.332 0-79.158 21.834-21.818 57.348-21.818 79.166 0 3.124 3.124 3.124 8.184 0 11.308s-8.184 3.124-11.308 0c-15.594-15.594-40.958-15.58-56.552 0-15.594 15.594-15.594 40.958 0 56.552a7.98 7.98 0 0 1 0 11.298 7.956 7.956 0 0 1-5.652 2.344zM528.122 602.362c-14.344 0-28.674-5.452-39.59-16.368-3.124-3.108-3.124-8.186 0-11.308s8.184-3.124 11.308 0c15.554 15.556 40.934 15.588 56.522 0 15.586-15.586 15.586-40.964 0-56.544a7.992 7.992 0 0 1 0-11.306 7.992 7.992 0 0 1 11.306 0c21.802 21.81 21.834 57.326 0 79.16-10.902 10.898-25.24 16.366-39.546 16.366zM322.084 597.176a7.972 7.972 0 0 1-5.654-2.344 7.992 7.992 0 0 1 0-11.306l56.544-56.544a7.994 7.994 0 0 1 11.308 0 8.004 8.004 0 0 1 0 11.316l-56.544 56.536a7.986 7.986 0 0 1-5.654 2.342zM435.18 710.25a7.972 7.972 0 0 1-5.654-2.344 7.992 7.992 0 0 1 0-11.306l56.538-56.538c3.124-3.124 8.184-3.124 11.308 0s3.124 8.184 0 11.306l-56.536 56.538a7.98 7.98 0 0 1-5.656 2.344z"
        fill=""
      />
      <path
        d="M435.18 710.25a7.972 7.972 0 0 1-5.654-2.344l-113.096-113.074a7.992 7.992 0 0 1 0-11.306 7.992 7.992 0 0 1 11.306 0l113.098 113.074a7.992 7.992 0 0 1 0 11.306 7.972 7.972 0 0 1-5.654 2.344z"
        fill=""
      />
      <path
        d="M378.62 653.712a7.976 7.976 0 0 1-5.654-2.344 7.992 7.992 0 0 1 0-11.306l45.238-45.23a7.992 7.992 0 0 1 11.306 0 7.994 7.994 0 0 1 0 11.308l-45.236 45.228a7.966 7.966 0 0 1-5.654 2.344z"
        fill=""
      />
      <path
        d="M663.902 368.054a8 8 0 0 1-7.808-6.31 7.988 7.988 0 0 1 6.124-9.502C944.026 291.558 1007.746 50.106 1007.746 8.204a8 8 0 0 1 7.996-7.996 7.98 7.98 0 0 1 7.996 7.996c0 43.91-66.032 296.77-358.148 359.672a7.81 7.81 0 0 1-1.688 0.178z"
        fill=""
      />
      <path
        d="M738.776 192.12a7.992 7.992 0 0 1-4.592-1.446c-3.592-2.53-4.498-7.52-1.938-11.134C835.918 31.38 989.786 0.208 1015.774 0.208c4.436 0 7.996 3.576 7.996 7.996s-3.56 7.996-7.996 7.996c-23.27 0-171.984 31.814-270.44 172.508a7.98 7.98 0 0 1-6.558 3.412z"
        fill=""
      />
    </svg>
  ),
  trophy: (
    <svg
      xmlns="http://www.w3.org/2000/svg"
      width="100%"
      height="100%"
      className="pointer-events-none"
      viewBox="0 0 60.35 79.11">
      <g>
        <g>
          <path
            d="m38.4,68.13h-16.45c-.68,0-1.24-.55-1.24-1.23,0-.23.07-.46.19-.66,1.34-2.65,2.26-5.05,2.77-7.29.51-2.29.58-4.39.2-6.42-4.04-1.24-7.61-3.63-10.34-6.93-2.7-3.26-4.36-7.17-4.83-11.33-2.37-.82-4.51-2.37-6.05-4.37-1.73-2.27-2.65-4.97-2.65-7.82V7.87c0-.68.55-1.23,1.23-1.23h7.33V1.23c0-.68.55-1.23,1.23-1.23h40.75c.68,0,1.24.55,1.24,1.23v5.4h7.33c.68,0,1.23.55,1.23,1.23v14.21c0,2.84-.92,5.55-2.66,7.82-1.53,2.01-3.67,3.55-6.04,4.37-.47,4.16-2.13,8.07-4.83,11.33-2.73,3.29-6.3,5.68-10.33,6.92-.39,2.1-.33,4.25.19,6.57.49,2.19,1.38,4.48,2.81,7.24.15.29.18.62.08.94-.1.31-.31.57-.6.72-.19.09-.39.14-.57.14ZM1.26,7.94l.04,14.15c0,2.56.82,4.99,2.38,7.03,1.46,1.91,3.53,3.35,5.81,4.06.25.08.43.3.46.56.37,4.06,1.96,7.88,4.58,11.05,2.65,3.2,6.13,5.49,10.08,6.62.23.07.41.25.46.49.49,2.33.45,4.74-.13,7.36-.53,2.34-1.48,4.84-2.91,7.64l16.26-.05c-1.45-2.81-2.36-5.18-2.87-7.45-.59-2.63-.62-5.09-.12-7.49.05-.24.22-.42.46-.49,3.94-1.13,7.42-3.42,10.07-6.62,2.62-3.17,4.2-6.99,4.58-11.05.02-.26.2-.48.46-.56,2.28-.71,4.34-2.15,5.8-4.06,1.56-2.04,2.39-4.47,2.39-7.03V7.9l-7.91.04c-.36,0-.65-.29-.65-.65V1.26l-40.67.04.04,5.99c0,.36-.29.65-.65.65H1.26Zm49.88,21.53c-.12,0-.23-.03-.34-.09-.19-.12-.31-.33-.31-.56V11.89c0-.36.29-.65.65-.65h4.29c.36,0,.65.29.65.65v9.85c0,1.75-.52,3.43-1.5,4.86-.8,1.17-1.88,2.14-3.13,2.79-.09.05-.2.07-.3.07Zm.65-16.92v15.1c.66-.49,1.24-1.09,1.71-1.78.83-1.21,1.28-2.64,1.28-4.12v-9.2h-2.99ZM9.22,29.47c-.1,0-.21-.02-.3-.07-1.26-.65-2.35-1.62-3.15-2.8-.98-1.43-1.5-3.1-1.5-4.85v-9.85c0-.36.29-.65.65-.65h4.3c.36,0,.65.29.65.65v16.92c0,.23-.12.44-.31.56-.1.06-.22.09-.34.09Zm-3.65-16.92v9.2c0,1.48.44,2.91,1.28,4.12.47.69,1.05,1.3,1.72,1.79v-15.11h-3Z"
            style={{ strokeWidth: "0px" }}
          />
          <path
            d="m46.55,75.99H13.81c-.36,0-.65-.29-.65-.65v-7.86c0-.36.29-.65.65-.65h32.74c.36,0,.65.29.65.65v7.86c0,.36-.29.65-.65.65Zm-32.09-1.3h31.44v-6.56H14.46v6.56Z"
            style={{ strokeWidth: "0px" }}
          />
          <path
            d="m42.88,79.11h-25.4c-.36,0-.65-.29-.65-.65v-3.12c0-.36.29-.65.65-.65h25.4c.36,0,.65.29.65.65v3.12c0,.36-.29.65-.65.65Zm-24.75-1.3h24.1v-1.82h-24.1v1.82Z"
            style={{ strokeWidth: "0px" }}
          />
          <path
            d="m35.97,37.14c-.29,0-.56-.1-.78-.29l-5-3.65-5.08,3.7c-.54.39-1.34.25-1.73-.28-.23-.32-.29-.72-.16-1.1l1.94-5.97-5.08-3.67c-.43-.32-.61-.87-.45-1.39.17-.52.63-.85,1.17-.85l6.28.02,1.93-5.97c.16-.52.62-.85,1.16-.85s1.01.34,1.18.85l1.93,5.98,6.27-.02c.54,0,1.01.34,1.17.86.17.52,0,1.06-.45,1.37l-5.09,3.68,1.96,5.97c.12.37.07.77-.16,1.09-.23.33-.61.52-1.01.52Zm-5.79-5.39c.13,0,.27.04.38.12l5.33,3.89-2.09-6.25c-.09-.27,0-.56.24-.73l5.3-3.83-6.53.02h0c-.28,0-.53-.18-.62-.45l-2.01-6.23-2.01,6.23c-.09.27-.34.49-.62.45l-6.55-.02,5.31,3.83c.23.17.32.46.24.73l-2.03,6.24,5.29-3.88c.11-.08.25-.12.38-.12Z"
            style={{ strokeWidth: "0px" }}
          />
        </g>
      </g>
    </svg>
  ),
  contract: (
    <svg
      fill="#000000"
      width="100%"
      height="100%"
      className="pointer-events-none"
      xmlns="http://www.w3.org/2000/svg"
      viewBox="0 0 237.783 237.783"
      enableBackground="new 0 0 237.783 237.783">
      <g strokeWidth="0"></g>
      <g
        id="SVGRepo_tracerCarrier"
        strokeLinecap="round"
        strokeLinejoin="round"></g>
      <g id="SVGRepo_iconCarrier">
        {" "}
        <g>
          {" "}
          <path d="m42.735,50.071h96.959c3.313,0 6,2.687 6,6s-2.687,6-6,6h-96.959c-3.313,0-6-2.687-6-6s2.686-6 6-6zm0,25.934h96.959c3.313,0 6,2.687 6,6s-2.687,6-6,6h-96.959c-3.313,0-6-2.687-6-6s2.686-6 6-6zm0,25.935h96.959c3.313,0 6,2.687 6,6s-2.687,6-6,6h-96.959c-3.313,0-6-2.687-6-6s2.686-6 6-6zm0,25.935h96.959c3.313,0 6,2.687 6,6s-2.687,6-6,6h-96.959c-3.313,0-6-2.687-6-6s2.686-6 6-6z"></path>{" "}
          <path d="m42.735,62.071h96.959c3.313,0 6-2.687 6-6s-2.687-6-6-6h-96.959c-3.313,0-6,2.687-6,6s2.686,6 6,6z"></path>{" "}
          <path d="m42.735,88.005h96.959c3.313,0 6-2.687 6-6s-2.687-6-6-6h-96.959c-3.313,0-6,2.687-6,6s2.686,6 6,6z"></path>{" "}
          <path d="m42.735,113.94h96.959c3.313,0 6-2.687 6-6s-2.687-6-6-6h-96.959c-3.313,0-6,2.687-6,6s2.686,6 6,6z"></path>{" "}
          <path d="m42.735,139.875h96.959c3.313,0 6-2.687 6-6s-2.687-6-6-6h-96.959c-3.313,0-6,2.687-6,6s2.686,6 6,6z"></path>{" "}
          <path d="m237.783,98.361c0-1.591-0.632-3.117-1.757-4.243l-16.356-16.355c-1.125-1.125-2.651-1.757-4.243-1.757s-3.117,0.632-4.243,1.757l-28.756,28.756v-88.117c0-3.313-2.686-6-6-6h-170.428c-3.314,0-6,2.687-6,6v200.979c0,3.313 2.686,6 6,6h170.429c3.314,0 6-2.687 6-6v-63.18l53.597-53.597c1.125-1.125 1.757-2.651 1.757-4.243zm-225.783,115.02v-188.979h158.429v94.117l-35.291,35.291h-92.403c-3.313,0-6,2.687-6,6s2.687,6 6,6h80.403l-1.033,1.033c-0.777,0.777-1.326,1.753-1.586,2.821l-4.157,17.05h-25.148c-3.313,0-6,2.687-6,6s2.687,6 6,6c0,0 29.714,0 29.86,0 0.473,0 0.95-0.056 1.421-0.171l21.629-5.273c1.068-0.26 2.044-0.809 2.821-1.586l23.482-23.482v45.181h-158.427zm127.649-31.374l-10.408,2.538 2.538-10.408 83.648-83.648 7.871,7.871-83.649,83.647z"></path>{" "}
        </g>{" "}
      </g>
    </svg>
  ),
  contract2: (
    <svg
      xmlns="http://www.w3.org/2000/svg"
      width="100%"
      height="100%"
      className="pointer-events-none"
      viewBox="0 0 60 60">
      <g strokeWidth="0"></g>
      <g strokeLinecap="round" strokeLinejoin="round"></g>
      <g id="SVGRepo_iconCarrier">
        {" "}
        <g>
          {" "}
          <g>
            {" "}
            <path d="M60,47L60,47V1c0-0.6-0.4-1-1-1H15c-0.6,0-1,0.4-1,1v33h2V2h42v44H47c-0.6,0-1,0.4-1,1v11H16v-8h-2v9c0,0.6,0.4,1,1,1h32 c0.3,0,0.5-0.1,0.7-0.3l12-12c0.1-0.1,0.1-0.2,0.2-0.3v-0.1C60,47.2,60,47.1,60,47z M56.6,48l-4.3,4.3L48,56.6V48H56.6z"></path>{" "}
            <rect x="19" y="5" width="8" height="2"></rect>{" "}
            <rect x="19" y="9" width="16" height="2"></rect>{" "}
            <rect x="19" y="18" width="21" height="2"></rect>{" "}
            <rect x="19" y="23" width="36" height="2"></rect>{" "}
            <rect x="19" y="28" width="36" height="2"></rect>{" "}
            <rect x="19" y="33" width="36" height="2"></rect>{" "}
            <rect x="19" y="49" width="18" height="2"></rect>{" "}
            <rect x="19" y="53" width="4" height="2"></rect>{" "}
            <path d="M30.3,45.9l6-2c0.4-0.1,0.7-0.5,0.7-0.9s-0.3-0.8-0.7-0.9l-6-2C30.2,40,30.1,40,30,40H4v-1h15v-2H3c-0.6,0-1,0.4-1,1v2H1 c-0.6,0-1,0.4-1,1v4c0,0.6,0.4,1,1,1h29C30.1,46,30.2,46,30.3,45.9z M2,42h6v2H2V42z M10,44v-2h19.8l3,1l-3,1H10z"></path>{" "}
            <rect x="42" y="18" width="9" height="2"></rect>{" "}
          </g>{" "}
        </g>{" "}
      </g>
    </svg>
  ),
  support: (
    <svg
      xmlns="http://www.w3.org/2000/svg"
      width="100%"
      height="100%"
      className="pointer-events-none"
      viewBox="0 0 24 24">
      <g id="SVGRepo_bgCarrier" strokeWidth="0"></g>
      <g
        id="SVGRepo_tracerCarrier"
        strokeLinecap="round"
        strokeLinejoin="round"></g>
      <g id="SVGRepo_iconCarrier">
        {" "}
        <rect id="view-box" width="24" height="24" fill="none"></rect>{" "}
        <path
          id="Shape"
          d="M8,17.751a2.749,2.749,0,0,1,5.127-1.382C15.217,15.447,16,14,16,11.25v-3c0-3.992-2.251-6.75-5.75-6.75S4.5,4.259,4.5,8.25v3.5a.751.751,0,0,1-.75.75h-1A2.753,2.753,0,0,1,0,9.751v-1A2.754,2.754,0,0,1,2.75,6h.478c.757-3.571,3.348-6,7.022-6s6.264,2.429,7.021,6h.478a2.754,2.754,0,0,1,2.75,2.75v1a2.753,2.753,0,0,1-2.75,2.75H17.44A5.85,5.85,0,0,1,13.5,17.84,2.75,2.75,0,0,1,8,17.751Zm1.5,0a1.25,1.25,0,1,0,1.25-1.25A1.251,1.251,0,0,0,9.5,17.751Zm8-6.75h.249A1.251,1.251,0,0,0,19,9.751v-1A1.251,1.251,0,0,0,17.75,7.5H17.5Zm-16-2.25v1A1.251,1.251,0,0,0,2.75,11H3V7.5H2.75A1.251,1.251,0,0,0,1.5,8.751Z"
          transform="translate(1.75 2.25)"
          fill="#141124"></path>{" "}
      </g>
    </svg>
  ),
};

export default icons;
