import { useEffect, useContext } from "react";
import { SocketContext } from "@/context/SocketProvider";
import useDynamicManager from "@/store/managers/useDynamicManager";

const SocketMessageHandler = () => {
  const socket = useContext(SocketContext);
  const { addLog } = useDynamicManager("uploadLog");

  useEffect(() => {
    if (!socket || !socket.connected) {
      // Optionally: log status or wait for connection
      return;
    }

    const handleGenericMessage = (msg) => {
      console.log("📩 Message:", msg);
    };

    const handleUploadProgress = (progress) => {
      let logEntry;
      if (typeof progress === "string") {
        logEntry = { text: progress, timestamp: new Date().toISOString() };
      } else if (typeof progress === "object" && progress !== null) {
        logEntry = {
          text: progress.text || JSON.stringify(progress),
          timestamp: progress.timestamp || new Date().toISOString(),
          ...progress,
        };
      }
      addLog(logEntry);
    };

    // Subscribe to events
    socket.on("message", handleGenericMessage);
    socket.on("upload-products-progress", handleUploadProgress);

    // Cleanup
    return () => {
      socket.off("message", handleGenericMessage);
      socket.off("upload-products-progress", handleUploadProgress);
    };
  }, [socket && socket.connected]); // Listen for connection status change

  return null;
};

export default SocketMessageHandler;
