// components/SocketStatusNotifier.jsx
"use client";
import { useEffect, useContext } from "react";
import { toast } from "react-hot-toast";
import { SocketStatusContext } from "@/context/SocketProvider";

const SocketStatusNotifier = () => {
  const socketStatus = useContext(SocketStatusContext);

  useEffect(() => {
    if (!socketStatus) return;

    if (socketStatus === "connected") {
      toast.dismiss("socket-status");
      toast.success("🟢 Socket connected", {
        id: "socket-status",
        duration: 2000,
      });
    }

    if (socketStatus === "disconnected") {
      toast.error("🔌 Socket disconnected", {
        id: "socket-status",
        duration: 4000,
      });
    }

    if (socketStatus === "error") {
      toast.error("❌ Socket connection error", {
        id: "socket-status",
        duration: 5000,
      });
    }
  }, [socketStatus]);

  return null; // no visible DOM element needed
};

export default SocketStatusNotifier;
