"use client";

import { useContext } from "react";
import {
  AdminUsersListContext,
  SocketStatusContext,
} from "@/context/SocketProvider";

export default function ConnectedAdminsPanel() {
  const adminUsersList = useContext(AdminUsersListContext);
  const socketStatus = useContext(SocketStatusContext);

  if (socketStatus !== "connected") {
    return (
      <div className="p-2 text-xs text-gray-500 border rounded">
        Socket status: {socketStatus}. Live user list unavailable.
      </div>
    );
  }

  return (
    <div className="border rounded p-3 text-sm space-y-2 bg-white">
      <div className="flex items-center justify-between">
        <span className="font-semibold">Connected admins</span>
        <span className="text-xs text-gray-500">
          {adminUsersList?.length || 0}
        </span>
      </div>

      <ul className="space-y-1 max-h-64 overflow-auto">
        {adminUsersList?.map((user) => (
          <li
            key={user.name}
            className="flex items-center justify-between border-b last:border-none pb-1">
            <div>
              <div className="font-medium">{user.name}</div>
              <div className="text-xs text-gray-500">{user.email}</div>
            </div>
            <div className="text-right text-xs">
              <div>{user.role}</div>
              <div className="text-gray-400">tabs: {user.socketCount ?? 1}</div>
            </div>
          </li>
        ))}
      </ul>
    </div>
  );
}
