import React, { useEffect, useState, useCallback, useRef } from "react";
import { useSelector, useDispatch } from "react-redux";
import {
  selectedElement,
  updateContainerContent,
} from "@/store/slices/pageEditorSlice";
import Select from "react-select";
import { initialData } from "@/data/data";
import Button from "@/components/shared/button/Button";
import dynamic from "next/dynamic";
import { useModalManager } from "@/hooks/useModalManager";

const ColorPicker = dynamic(() => import("react-best-gradient-color-picker"), {
  ssr: false,
});

const EditorArtForm = ({ toggleModal, modalName }) => {
  const [isValid, setIsValid] = useState(false);
  // const { toggleModal, isModalOpen } = useModalManager();

  const editableContent = useSelector(
    (state) => state.pageEditor.current.content
  );
  const inputRefs = useRef([]);

  let index = 0;
  const [color, setColor] = useState(
    editableContent?.[0]?.content?.[0]?.backgroundColor ??
      "rgba(255, 255, 255, 1)"
  );
  const dispatch = useDispatch();

  useEffect(() => {
    // If there is data, the form is valid
    setIsValid(
      editableContent && editableContent?.[0]?.selectedColumn !== ""
        ? true
        : false
    );
  }, [editableContent]);

  const submitArtForm = useCallback(() => {
    const content = {
      type: "artform",
      title: "Művészeti ág",
      backgroundColor: color,
      displayedProperties: [],
    };
    inputRefs.current.map((c, i) => {
      if (c) {
        if (c.props) {
          if (Array.isArray(c.props.value)) {
            if (c.props.name === "displayedProperties") {
              c.props.value.map((x, i) => {
                content.displayedProperties.push(x);
              });
            } else {
              content[c.props.name] = c.props.value?.[0].value;
            }
          } else {
            content[c.props.name] = c.props.value.value;
          }
        } else {
          content[c.name] = c.value;
        }
      }
    });

    dispatch(
      selectedElement({
        content: content,
      })
    );
    dispatch(updateContainerContent());
    toggleModal(modalName);
    toggleModal("showSelectElementModal");
  }, [color, inputRefs]);

  return (
    <div className="relative">
      <div className="product-wrapper flex flex-col w-auto p-4">
        {/* Layout select */}
        <div className="flex flex-row w-full mb-4 pb-4 border-b">
          <label
            htmlFor={"artFormSelect"}
            className="w-sm-12 text-normal text-gray-400 whitespace-pre flex-flex-col flex-wrap pr-2">
            <p className="w-full font-bold">Művészeti ág layout: </p>
            <span className="w-full text-sm text-gray-600 whitespace-pre-line">
              Válassza ki, hogy milyen formátumban jelenjen(ek) meg a művészeti
              ág(ak) - (alapértelmezett érték: Alap)
            </span>
          </label>

          <Select
            options={initialData.editor.artform.layoutTypes}
            className="w-sm-36"
            menuPosition={"fixed"}
            placeholder={"Válasszon művészeti ág megjelenítést"}
            backspaceRemovesValue={false}
            name={"artFormSelect"}
            ref={(r) => (inputRefs.current[index++] = r)}
            defaultValue={
              editableContent?.[0]?.content?.[0]?.artFormSelect
                ? initialData.editor.artform.layoutTypes.filter(
                    (x) =>
                      x.value === editableContent?.[0].content[0].artFormSelect
                  )
                : initialData.editor.artform.layoutTypes[0]
            }
            onChange={(val, e) => {}}
            required
          />
        </div>
        {/* people background color */}
        <div className="flex flex-row w-full mb-4 pb-4 border-b">
          <label
            htmlFor={"backgroundColor"}
            className="w-sm-12 text-normal text-gray-400 whitespace-pre flex-flex-col flex-wrap pr-2">
            <p className="w-full font-bold">Háttér szín: </p>
            <span className="w-full text-sm text-gray-600 whitespace-pre-line">
              Válassza ki, hogy milyen háttér színűek legyenek az egyes elemek -
              (alapértelmezett érték: rgba(255, 255, 255, 1) - Fehér).
            </span>
          </label>
          <ColorPicker value={color} onChange={setColor} />
        </div>
      </div>
      <div className="flex flex-row w-auto justify-end sticky bottom-0 bg-white p-2 border border-t">
        <Button
          onClick={submitArtForm}
          className="px-4 py-2 uppercase border bg-green-500/75 text-white hover:border-green-500 hover:bg-green-500 disabled:bg-gray-500 disabled:pointer-events-none"
          btntext="Mentés"
        />
      </div>
    </div>
  );
};

export default EditorArtForm;
