import React, { useState, useCallback, useRef } from "react";
import { useDispatch } from "react-redux";
import Select from "react-select";
import { initialData } from "@/data/data";
import Button from "@/components/shared/button/Button";
import { findLastIndexOfChar } from "@/utils/findLastIndexOfChar";
import dynamic from "next/dynamic";
const ColorPicker = dynamic(() => import("react-best-gradient-color-picker"), {
  ssr: false,
});
import icons from "@/assets/icons/icons";
import Image from "next/image";
// import MediaStore from "@/components/media-store/MediaStore/MediaStore";
import Modal from "@/components/shared/modal/Modal";
import IconList from "@/components/shared/icon/IconList";
// import MediaObject from "@/components/media-store/MediaObject/MediaObject";
import "react-quill/dist/quill.snow.css";
import ModalButton from "@/components/shared/modal/ModalButton";
const SunEditor = dynamic(() => import("suneditor-react"), {
  ssr: false,
});
import { useEditorContentBox } from "@/hooks/useEditorContentBox";
import TabSwitcher from "@/components/shared/tabswitcher/TabSwitcher";
import ContentBoxSettings from "./TabData/ContentBoxSettings";
import IconSettings from "./TabData/IconSettings";
import LinkSettings from "./TabData/LinkSettings";
import ImageSettings from "./TabData/ImageSettings";
import TextContent from "./TabData/TextContent";
import MediaObject from "@/components/shared/mediaobject/MediaObject";

const EditorContentBox = ({ toggleModal, modalName }) => {
  const {
    editableContent,
    selectedBoxImage,
    handleSubmitContentBox,
    handleImageRemove,
  } = useEditorContentBox({
    toggleModal,
    modalName,
  });
  const [activeTab, setActiveTab] = useState(1);
  const [selectImageModal, showSelectImageModal] = useState(false);
  const [selectedIcon, setSelectedIcon] = useState(
    editableContent?.[0]?.content?.[0]?.selectedIcon ?? null
  );
  const [boxBorderColor, setBoxBorderColor] = useState(
    editableContent?.[0]?.content?.[0]?.boxBorderColor ?? "transparent"
  );
  const [imageBorderColor, setImageBorderColor] = useState(
    editableContent?.[0]?.content?.[0]?.imageBorderColor ?? "transparent"
  );
  const [boxBackgroundColor, setBoxBackgroundColor] = useState(
    editableContent?.[0]?.content?.[0]?.boxBackgroundColor ?? "transparent"
  );
  const [iconBackgroundColor, setIconBackgroundColor] = useState(
    editableContent?.[0]?.content?.[0]?.iconBackgroundColor ?? "transparent"
  );
  const [imageBackgroundColor, setImageBackgroundColor] = useState(
    editableContent?.[0]?.content?.[0]?.imageBackgroundColor ?? "transparent"
  );
  const [imageOverlayColor, setImageOverlayColor] = useState(
    editableContent?.[0]?.content?.[0]?.imageOverlayColor ??
      "rgba(33, 33, 33, 0.5)"
  );
  const [iconFillColor, setIconFillColor] = useState(
    editableContent?.[0]?.content?.[0]?.iconFillColor ?? "#eeeeee"
  );
  const [titleText, setTitleText] = useState(
    editableContent?.[0]?.content?.[0]?.titleText ?? ""
  );
  const [titleBackgroundColor, setTitleBackgroundColor] = useState(
    editableContent?.[0]?.content?.[0]?.titleBackgroundColor ?? "transparent"
  );
  const [titleTextColor, setTitleTextColor] = useState(
    editableContent?.[0]?.content?.[0]?.titleTextColor ?? "rgba(33, 33, 33, 1)"
  );
  const [iconBorderColor, setIconBorderColor] = useState(
    editableContent?.[0]?.content?.[0]?.iconBorderColor ??
      "rgba(255, 255, 255, 1)"
  );
  const [iconSeparatorColor, setIconSeparatorColor] = useState(
    editableContent?.[0]?.content?.[0]?.iconSeparatorColor ??
      "rgba(255, 255, 255, 1)"
  );
  const [iconSeparatorBackgroundColor, setIconSeparatorBackgroundColor] =
    useState(
      editableContent?.[0]?.content?.[0]?.iconSeparatorBackgroundColor ??
        "transparent"
    );
  const [subText, setSubText] = useState(
    editableContent?.[0]?.content?.[0]?.subText ?? ""
  );

  const handleIconSelect = (iconKey) => {
    setSelectedIcon(iconKey);
    // You can do additional actions here when an icon is selected
  };

  const handleTabClick = (tabNumber) => {
    setActiveTab(tabNumber);
  };

  const inputRefs = useRef([]);

  const addRef = (key, ref) => {
    if (ref) {
      inputRefs.current[key] = ref; // Add or update the ref
    }
  };

  const tabData = [
    { id: 1, tabTitle: "Content box beállítások" },
    { id: 2, tabTitle: "Kép beállítások" },
    { id: 3, tabTitle: "Ikon beállítások" },
    { id: 4, tabTitle: "Szöveges tartalom" },
    { id: 5, tabTitle: "Link beállítások" },
  ];

  const handleEditorContentChange = (value) => {
    setTitleText(value);
  };
  const handleTextEditorContentChange = (value) => {
    setSubText(value);
  };
  const generateSelectedImage = useCallback(() => {
    const i = 0;

    if (selectedBoxImage && selectedBoxImage?._id) {
      return selectedBoxImage.props.mimetype === "application/pdf" ? (
        <div
          className={`flex flex-col mr-2 mb-2 items-center border-1 w-full`}
          key={selectedBoxImage?._id}>
          <MediaObject
            data={selectedBoxImage}
            index={i}
            data-index={i}
            className={"w-full"}
            id={selectedBoxImage?._id}
          />
          <p className="break-all p-1">
            {" "}
            {selectedBoxImage?.props?.basename ??
              selectedBoxImage?.originalname}
          </p>
          <input
            type="hidden"
            name="selectedFile"
            defaultValue={selectedBoxImage}
          />

          <button onClick={handleImageRemove} className="text-red-500 my-4">
            Eltávolítás
          </button>
        </div>
      ) : (
        <div
          className={`flex flex-col mr-2 mb-2 items-center border-1 w-full`}
          key={i}>
          <Image
            src={
              `${process.env.NEXT_PUBLIC_PATH}/api/admin/i/2/2/0/` +
              findLastIndexOfChar.before(selectedBoxImage?.originalname, ".") +
              ".webp"
            }
            width={150}
            height={100}
            alt={selectedBoxImage?.originalname ?? ""}
            effect="blur"
            loading="lazy"
          />
          <p className="break-all p-1">{selectedBoxImage?.props?.filename}</p>
          <input
            type="hidden"
            name="selectedFile"
            defaultValue={selectedBoxImage}
          />
          <button onClick={handleImageRemove}>Eltávolítás</button>
        </div>
      );
    }
  }, [selectedBoxImage, handleImageRemove]);

  const submitContentBox = () => {
    handleSubmitContentBox(
      {
        type: "content-box",
        title: "Content-box",
        image: selectedBoxImage,
        boxBorderColor: boxBorderColor,
        imageBorderColor: imageBorderColor,
        boxBackgroundColor: boxBackgroundColor,
        imageBackgroundColor: imageBackgroundColor,
        imageOverlayColor: imageOverlayColor,
        titleText: titleText,
        titleTextColor: titleTextColor,
        titleBackgroundColor: titleBackgroundColor,
        subText: subText,
        selectedIcon: selectedIcon,
        iconBorderColor: iconBorderColor,
        iconFillColor: iconFillColor,
        iconBackgroundColor: iconBackgroundColor,
        iconSeparatorColor: iconSeparatorColor,
        iconSeparatorBackgroundColor: iconSeparatorBackgroundColor,
      },
      inputRefs
    );
  };

  return (
    <div className="relative">
      {editableContent && (
        <div className="image-wrapper flex flex-col w-full p-4">
          <div className="w-full flex flex-row flex-nowrap border-b mb-4">
            <TabSwitcher
              data={tabData}
              activeTab={activeTab}
              onTabClick={handleTabClick}
            />
          </div>
          {/* box options */}
          <ContentBoxSettings
            editableContent={editableContent}
            addRef={addRef}
            boxBorderColor={boxBorderColor}
            setBoxBorderColor={setBoxBorderColor}
            boxBackgroundColor={boxBackgroundColor}
            setBoxBackgroundColor={setBoxBackgroundColor}
          />
          {/* image options */}
          {/* select image */}
          <div className="flex flex-row w-full mb-4 pb-4 border-b">
            <label
              htmlFor={"imageSelect"}
              className="w-1/4 text-normal text-gray-400 whitespace-pre-line flex-flex-col flex-wrap pr-2">
              <p className="w-full font-bold">Kép kiválasztása: </p>
              <span className="w-full text-sm text-gray-600 whitespace-pre-line">
                Töltsön fel képet, vagy válasszon a médiatárból!
              </span>
            </label>
            <div className="flex flex-row w-3/4 justify-end items-center">
              {generateSelectedImage()}
              <Button
                onClick={() => showSelectImageModal(true)}
                className=" border border-gray-300 px-4 py-2 text-gray-500 hover:border-gray-600 hover:text-gray-900"
                btntext="Kép kiválasztása"></Button>
            </div>
          </div>
          <ImageSettings editableContent={editableContent} addRef={addRef} />
          {/* icon */}
          {/* <IconList icons={icons} onSelect={handleIconSelect} /> */}
          {/* selected icon */}
          <div className="w-full flex flex-row flex-nowrap border-b border-t my-4 py-2">
            <label
              htmlFor={"selectedIcon"}
              className="w-1/4 text-normal text-gray-400 whitespace-pre-line flex-flex-col flex-wrap pr-2">
              <p className="w-full font-bold">Kiválasztott ikon: </p>
              <span className="w-full text-sm text-gray-600 whitespace-pre-line">
                Válassza ki, hogy milyen ikont szeretne megjeleníteni.
              </span>
            </label>
            <div className="flex flex-row w-3/4 justify-center items-center">
              <p className="flex flex-col justify-center items-center font-semibold">
                Ikon neve: {selectedIcon}{" "}
                <span className="flex size-48">{icons[selectedIcon]}</span>
              </p>
            </div>
          </div>
          {/* <IconSettings editableContent={editableContent} addRef={addRef} /> */}
          {/* text options */}
          {/* <TextContent editableContent={editableContent} addRef={addRef} /> */}
          {/* link options */}
          {/* <LinkSettings editableContent={editableContent} addRef={addRef} /> */}
          <ModalButton btntext={"Mentés"} callback={submitContentBox} />
        </div>
      )}

      <Modal
        title={"Képtár"}
        show={selectImageModal}
        onClose={() => showSelectImageModal(false)}
        height={"100%"}>
        {/* <MediaStore
          targetModal={showSelectImageModal}
          selectType="editor-image"
        /> */}
      </Modal>
    </div>
  );
};

export default EditorContentBox;
