import React, { useRef, useEffect } from "react";
import SelectInput from "@/components/shared/selectinput/SelectInput";
import dynamic from "next/dynamic";

const SunEditor = dynamic(() => import("suneditor-react"), { ssr: false });
const ColorPicker = dynamic(() => import("react-best-gradient-color-picker"), {
  ssr: false,
});

const TextContent = ({ editableContent, addRef }) => {
  const inputRefs = useRef([]);

  useEffect(() => {
    Object.entries(inputRefs.current).forEach(([key, ref]) => {
      addRef(key, ref);
    });
  });

  return (
    <div className={`w-full`}>
      {/* text content position */}
      <div className="flex flex-row w-full mb-4 pb-4 border-b">
        <label
          htmlFor={"titlePosition"}
          className="w-1/4 text-normal text-gray-400 whitespace-pre flex-flex-col flex-wrap pr-2">
          <p className="w-full font-bold">Cím elhelyezkedése: </p>
          <span className="w-full text-sm text-gray-600 whitespace-pre-line">
            Válassza ki, hogy a cím elem a tartalmazó dobozban milyen pozícióban
            helyezkedjen el - (alapértelmezett érték: Relatív).
          </span>
        </label>

        <SelectInput
          options={initialData.position}
          className="w-3/4"
          placeholder={"Válasszon cím pozíciót"}
          backspaceRemovesValue={false}
          name={"titlePosition"}
          menuPosition={"fixed"}
          ref={(r) => (inputRefs.current[index++] = r)}
          defaultValue={
            editableContent?.[0]?.content?.[0]?.titlePosition
              ? initialData.position.filter(
                  (x) =>
                    x.value === editableContent?.[0].content[0].titlePosition,
                )
              : initialData?.position[0]
          }
          onChange={(val, e) => {
            // second parameter shows action triggered
            // dispatch(selectParentPage({ parent: val }));
          }}
          required
        />
      </div>
      {/* text content top right bottom left - % */}
      <div className="flex flex-row w-full mb-4 pb-4 border-b">
        <label
          htmlFor={"titleDistance"}
          className="w-1/4 text-normal text-gray-400 whitespace-pre flex-flex-col flex-wrap pr-2">
          <p className="w-full font-bold">Cím távolsága: </p>
          <span className="w-full text-sm text-gray-600 whitespace-pre-line">
            Válassza ki, hogy a cím elem a tartalmazó dobozban - a doboz négy
            sarkától milyen távolságra helyezkedjen el %-ban - (alapértelmezett
            érték: 0 0 0 0).
          </span>
        </label>

        <div className="flex flex-row flex-nowrap justify-evenly items-center">
          <div className="flex flex-row flex-nowrap w-1/4 justify-evenly items-center max-h-10">
            <span className="fill-gray-600 w-[2rem] h-[2rem]">{icons.up}</span>
            <input
              type="text"
              name="titlePositionTop"
              id="titlePositionTop"
              ref={(r) => (inputRefs.current[index++] = r)}
              className="w-3/4 border h-max p-2"
              defaultValue={
                editableContent?.[0]?.content?.[0]?.titlePositionTop ?? 0
              }
            />
          </div>
          <div className="flex flex-row flex-nowrap w-1/4 justify-evenly items-center max-h-10">
            <span className="fill-gray-600 w-[2rem] h-[2rem]">
              {icons.right}
            </span>
            <input
              type="text"
              name="titlePositionRight"
              id="titlePositionRight"
              ref={(r) => (inputRefs.current[index++] = r)}
              className="w-3/4 border h-max p-2"
              defaultValue={
                editableContent?.[0]?.content?.[0]?.titlePositionRight ?? 0
              }
            />
          </div>
          <div className="flex flex-row flex-nowrap w-1/4 justify-evenly items-center max-h-10">
            <span className="fill-gray-600 w-[2rem] h-[2rem]">
              {icons.down}
            </span>
            <input
              type="text"
              name="titlePositionBottom"
              id="titlePositionBottom"
              ref={(r) => (inputRefs.current[index++] = r)}
              className="w-3/4 border h-max p-2"
              defaultValue={
                editableContent?.[0]?.content?.[0]?.titlePositionBottom ?? 0
              }
            />
          </div>
          <div className="flex flex-row flex-nowrap w-1/4 justify-evenly items-center max-h-10">
            <span className="fill-gray-600 w-[2rem] h-[2rem]">
              {icons.left}
            </span>
            <input
              type="text"
              name="titlePositionLeft"
              id="titlePositionLeft"
              ref={(r) => (inputRefs.current[index++] = r)}
              className="w-3/4 border h-max p-2"
              defaultValue={
                editableContent?.[0]?.content?.[0]?.titlePositionLeft ?? 0
              }
            />
          </div>
        </div>
      </div>
      {/* title text */}
      <div className="flex flex-row w-full mb-4 pb-4 border-b h-max-content">
        <label
          htmlFor={"titleText"}
          className="w-1/4 text-normal text-gray-400 whitespace-pre flex-flex-col flex-wrap pr-2">
          <p className="w-full font-bold">Cím szövege: </p>
          <span className="w-full text-sm text-gray-600 whitespace-pre-line">
            Adjon meg cím szöveget.
          </span>
        </label>
        <SunEditor
          lang="en"
          name="titleText"
          defaultValue={titleText}
          width="100%"
          height="100%"
          placeholder="Cím szövege"
          autoFocus={false}
          onChange={handleEditorContentChange}
          setOptions={{
            buttonList: [
              ["font", "fontSize", "formatBlock"],
              [
                "bold",
                "underline",
                "italic",
                "strike",
                "subscript",
                "superscript",
              ],
              ["align", "list", "table"],
              ["fontColor", "hiliteColor"],
              ["outdent", "indent"],
              ["undo", "redo"],
              ["removeFormat"],
              ["link"],
              ["fullScreen", "showBlocks", "codeView", "save", "preview"],
            ],
            tableWidth: "100%",
            tableStyles: {
              border: "1px solid black",
            },
            callBackSave: (contents) => handleEditorContentChange(contents),
          }}
        />
      </div>
      {/* title text importance */}
      <div className="flex flex-row w-full mb-4 pb-4 border-b">
        <label
          htmlFor={"titleType"}
          className="w-1/4 text-normal text-gray-400 whitespace-pre flex-flex-col flex-wrap pr-2">
          <p className="w-full font-bold">Cím fontossága: </p>
          <span className="w-full text-sm text-gray-600 whitespace-pre-line">
            Válassza ki, hogy milyen fontosságú legyen a cím elem -
            (alapértelmezett érték: H1). A H1 elemet jellemzően csak az oldal
            tetején érdemes használni és egy oldalon csak egy H1 elem legyen.
          </span>
        </label>

        <SelectInput
          options={initialData.textTypes}
          className="w-3/4 z-50"
          placeholder={"Válasszon cím fontosságot"}
          menuPosition={"fixed"}
          backspaceRemovesValue={false}
          name={"titleType"}
          ref={(r) => (inputRefs.current[index++] = r)}
          defaultValue={
            editableContent?.[0]?.content?.[0]?.titleType
              ? initialData.textTypes.filter(
                  (x) => x.value === editableContent?.[0].content[0].titleType,
                )
              : initialData.textTypes[0]
          }
          onChange={(val, e) => {
            // second parameter shows action triggered
            // dispatch(selectParentPage({ parent: val }));
          }}
          required
        />
      </div>
      {/* title font size */}
      <div className="flex flex-row w-full mb-4 pb-4 border-b">
        <label
          htmlFor={"titleFontSize"}
          className="w-1/4 text-normal text-gray-400 whitespace-pre-line flex-flex-col flex-wrap pr-2">
          <p className="w-full font-bold">Szöveg mérete: </p>
          <span className="w-full text-sm text-gray-600 whitespace-pre-line">
            Megadhatja, hogy a szöveg elemnek mekkora legyen a mérete. Pl.: 28px
            vagy 1em, 2rem, stb. Alapértelmezett: 1rem
          </span>
        </label>

        <input
          type="text"
          name="titleFontSize"
          id="titleFontSize"
          ref={(r) => (inputRefs.current[index++] = r)}
          className="w-3/4 border h-max p-2"
          defaultValue={
            editableContent?.[0]?.content?.[0]?.titleFontSize ?? "1rem"
          }
        />
      </div>
      {/* title weight */}
      <div className="flex flex-row w-full mb-4 pb-4 border-b">
        <label
          htmlFor={"fontWeight"}
          className="w-1/4 text-normal text-gray-400 whitespace-pre flex-flex-col flex-wrap pr-2">
          <p className="w-full font-bold">Cím betű súly: </p>
          <span className="w-full text-sm text-gray-600 whitespace-pre-line">
            Válassza ki, hogy milyen súlyú legyen a cím elem - (alapértelmezett
            érték: normal).
          </span>
        </label>

        <SelectInput
          options={initialData.fontWeight}
          className="w-3/4 z-50"
          placeholder={"Válasszon cím betű súlyt"}
          menuPosition={"fixed"}
          backspaceRemovesValue={false}
          name={"fontWeight"}
          ref={(r) => (inputRefs.current[index++] = r)}
          defaultValue={
            editableContent?.[0]?.content?.[0]?.fontWeight
              ? initialData.fontWeight.filter(
                  (x) => x.value === editableContent?.[0].content[0].fontWeight,
                )
              : initialData.fontWeight[12]
          }
          onChange={(val, e) => {
            // second parameter shows action triggered
            // dispatch(selectParentPage({ parent: val }));
          }}
          required
        />
      </div>

      {/* title line height */}
      <div className="flex flex-row w-full mb-4 pb-4 border-b">
        <label
          htmlFor={"titleLineHeight"}
          className="w-1/4 text-normal text-gray-400 whitespace-pre-line flex-flex-col flex-wrap pr-2">
          <p className="w-full font-bold">Cím elem sortáv: </p>
          <span className="w-full text-sm text-gray-600 whitespace-pre-line">
            Adjon meg cím elem sortávot. Pl.: 28px vagy 1em, 2rem, stb.
          </span>
        </label>
        <input
          type="text"
          name="titleLineHeight"
          id="titleLineHeight"
          ref={(r) => (inputRefs.current[index++] = r)}
          className="w-3/4 border h-max p-2"
          defaultValue={
            editableContent?.[0]?.content?.[0]?.titleLineHeight ?? "28px"
          }
        />
      </div>
      {/* title padding */}
      <div className="flex flex-row w-full mb-4 pb-4 border-b">
        <label
          htmlFor={"titlePadding"}
          className="w-1/4 text-normal text-gray-400 whitespace-pre-line flex-flex-col flex-wrap pr-2">
          <p className="w-full font-bold">Cím eltartás: </p>
          <span className="w-full text-sm text-gray-600 whitespace-pre-line">
            Megadhatja, hogy a cím elemnek mekkora eltartása legyen px-ben.
            Alapértelmezett: 0 0 0 0
          </span>
        </label>

        <div className="flex flex-row flex-nowrap w-1/4 justify-evenly items-center max-h-10">
          <span className="fill-gray-600 w-[2rem] h-[2rem]">{icons.up}</span>
          <input
            type="text"
            name="titlePaddingTop"
            id="titlePaddingTop"
            ref={(r) => (inputRefs.current[index++] = r)}
            className="w-3/4 border h-max p-2"
            defaultValue={
              editableContent?.[0]?.content?.[0]?.titlePaddingTop ?? 0
            }
          />
        </div>
        <div className="flex flex-row flex-nowrap w-1/4 justify-evenly items-center max-h-10">
          <span className="fill-gray-600 w-[2rem] h-[2rem]">{icons.right}</span>
          <input
            type="text"
            name="titlePaddingRight"
            id="titlePaddingRight"
            ref={(r) => (inputRefs.current[index++] = r)}
            className="w-3/4 border h-max p-2"
            defaultValue={
              editableContent?.[0]?.content?.[0]?.titlePaddingRight ?? 0
            }
          />
        </div>
        <div className="flex flex-row flex-nowrap w-1/4 justify-evenly items-center max-h-10">
          <span className="fill-gray-600 w-[2rem] h-[2rem]">{icons.down}</span>
          <input
            type="text"
            name="titlePaddingBottom"
            id="titlePaddingBottom"
            ref={(r) => (inputRefs.current[index++] = r)}
            className="w-3/4 border h-max p-2"
            defaultValue={
              editableContent?.[0]?.content?.[0]?.titlePaddingBottom ?? 0
            }
          />
        </div>
        <div className="flex flex-row flex-nowrap w-1/4 justify-evenly items-center max-h-10">
          <span className="fill-gray-600 w-[2rem] h-[2rem]">{icons.left}</span>
          <input
            type="text"
            name="titlePaddingLeft"
            id="titlePaddingLeft"
            ref={(r) => (inputRefs.current[index++] = r)}
            className="w-3/4 border h-max p-2"
            defaultValue={
              editableContent?.[0]?.content?.[0]?.titlePaddingLeft ?? 0
            }
          />
        </div>
      </div>
      {/* font family */}
      <div className="flex flex-row w-full mb-4 pb-4 border-b">
        <label
          htmlFor={"fontFamily"}
          className="w-1/4 text-normal text-gray-400 whitespace-pre flex-flex-col flex-wrap pr-2">
          <p className="w-full font-bold">Betűtípus: </p>
          <span className="w-full text-sm text-gray-600 whitespace-pre-line">
            Válassza ki, hogy milyen betűtípust használjon a cím elem -
            (alapértelmezett érték: Arial).
          </span>
        </label>

        <SelectInput
          options={initialData.fontFamily}
          className="w-3/4"
          placeholder={"Válasszon betűtípust"}
          menuPosition={"fixed"}
          backspaceRemovesValue={false}
          name={"fontFamily"}
          ref={(r) => (inputRefs.current[index++] = r)}
          defaultValue={
            editableContent?.[0]?.content?.[0]?.fontFamily
              ? initialData.fontFamily.filter(
                  (x) => x.value === editableContent?.[0].content[0].fontFamily,
                )
              : initialData.fontFamily[0]
          }
          onChange={(val, e) => {
            // second parameter shows action triggered
            // dispatch(selectParentPage({ parent: val }));
          }}
          required
        />
      </div>
      {/* title animation type */}
      <div className="flex flex-row w-full mb-4 p-4 border-b">
        <label
          htmlFor={"animationTypes"}
          className="w-1/4 text-normal text-gray-400 whitespace-pre-line flex-flex-col flex-wrap pr-2">
          <p className="w-full font-bold">Cím animációja: </p>
          <span className="w-full text-sm text-gray-600 whitespace-pre-line">
            Válassza ki a cím elem animációját. (alapértelmezett: Nincs
            animáció)
          </span>
        </label>

        <SelectInput
          options={initialData.animation}
          className="w-3/4"
          menuPosition={"fixed"}
          placeholder={"Válasszon animáció típust"}
          backspaceRemovesValue={false}
          name={"animationTypes"}
          ref={(r) => (inputRefs.current[index++] = r)}
          defaultValue={
            editableContent?.[0]?.content?.[0]?.animationTypes
              ? initialData.animation.filter(
                  (x) =>
                    x.value ===
                    editableContent?.[0]?.content?.[0]?.animationTypes,
                )
              : initialData.animation[0]
          }
          onChange={(val, e) => {
            // second parameter shows action triggered
            // dispatch(selectParentPage({ parent: val }));
          }}
          required
        />
      </div>
      {/* title animation delay */}
      <div className="flex flex-row w-full mb-4 pb-4 border-b">
        <label
          htmlFor={"animationDelay"}
          className="w-1/4 text-normal text-gray-400 whitespace-pre-line flex-flex-col flex-wrap pr-2">
          <p className="w-full font-bold">Cím animáció késleltetése: </p>
          <span className="w-full text-sm text-gray-600 whitespace-pre-line">
            Megadhatja, hogy a cím elemnek mennyi legyen az animáció
            késleltetése. Alapértelmezett: 1s
          </span>
        </label>
        <div className="flex flex-row flex-nowrap justify-evenly items-center">
          <input
            type="text"
            name="animationDelay"
            id="animationDelay"
            ref={(r) => (inputRefs.current[index++] = r)}
            className="w-3/4 border h-max p-2"
            defaultValue={
              editableContent?.[0]?.content?.[0]?.animationDelay ?? 1
            }
          />
        </div>
      </div>
      {/* title animation duration */}
      <div className="flex flex-row w-full mb-4 pb-4 border-b">
        <label
          htmlFor={"animationDuration"}
          className="w-1/4 text-normal text-gray-400 whitespace-pre-line flex-flex-col flex-wrap pr-2">
          <p className="w-full font-bold">Cím animáció időtartama: </p>
          <span className="w-full text-sm text-gray-600 whitespace-pre-line">
            Megadhatja, hogy a cím elemnek mennyi legyen az animáció időtartama.
            (pl.: 0.5, 2, 4) Alapértelmezett: 3s
          </span>
        </label>
        <div className="flex flex-row flex-nowrap justify-evenly items-center">
          <input
            type="text"
            name="animationDuration"
            id="animationDuration"
            ref={(r) => (inputRefs.current[index++] = r)}
            className="w-3/4 border h-max p-2"
            defaultValue={
              editableContent?.[0]?.content?.[0]?.animationDuration ?? 3
            }
          />
        </div>
      </div>
      {/* title background color */}
      <div className="flex flex-row w-full mb-4 pb-4 border-b">
        <label
          htmlFor={"titleBackgroundColor"}
          className="w-1/4 text-normal text-gray-400 whitespace-pre flex-flex-col flex-wrap pr-2">
          <p className="w-full font-bold">Háttér szín: </p>
          <span className="w-full text-sm text-gray-600 whitespace-pre-line">
            Válassza ki, hogy milyen színű legyen a cím elem háttere -
            (alapértelmezett érték: #fff - Fehér).
          </span>
        </label>

        <div className="w-3/4 flex flex-row justify-center align-center">
          <ColorPicker
            value={titleBackgroundColor}
            onChange={setTitleBackgroundColor}
          />
        </div>
      </div>
      {/* title font color */}
      <div className="flex flex-row w-full mb-4 pb-4 border-b">
        <label
          htmlFor={"fontColor"}
          className="w-1/4 text-normal text-gray-400 whitespace-pre flex-flex-col flex-wrap pr-2">
          <p className="w-full font-bold">Betű szín: </p>
          <span className="w-full text-sm text-gray-600 whitespace-pre-line">
            Válassza ki, hogy milyen színű legyen a cím elem - (alapértelmezett
            érték: #212121 - Fekete).
          </span>
        </label>
        <div className="w-3/4 flex flex-row justify-center align-center">
          <ColorPicker value={titleTextColor} onChange={setTitleTextColor} />
        </div>
      </div>
      {/* text */}
      <div className="flex flex-row w-full mb-4 pb-4 border-b h-max-content">
        <label
          htmlFor={"subText"}
          className="w-1/4 text-normal text-gray-400 whitespace-pre flex-flex-col flex-wrap pr-2">
          <p className="w-full font-bold">Kiegészítő szövege: </p>
          <span className="w-full text-sm text-gray-600 whitespace-pre-line">
            Adjon meg kiegészítő szöveget.
          </span>
        </label>
        <SunEditor
          lang="en"
          name="subText"
          defaultValue={subText}
          width="100%"
          height="100%"
          placeholder="Kiegészítő szöveg"
          autoFocus={false}
          onChange={handleTextEditorContentChange}
          setOptions={{
            buttonList: [
              ["font", "fontSize", "formatBlock"],
              [
                "bold",
                "underline",
                "italic",
                "strike",
                "subscript",
                "superscript",
              ],
              ["align", "list", "table"],
              ["fontColor", "hiliteColor"],
              ["outdent", "indent"],
              ["undo", "redo"],
              ["removeFormat"],
              ["link"],
              ["fullScreen", "showBlocks", "codeView", "save", "preview"],
            ],
            tableWidth: "100%",
            tableStyles: {
              border: "1px solid black",
            },
            callBackSave: (contents) => handleTextEditorContentChange(contents),
          }}
        />
      </div>
    </div>
  );
};

export default TextContent;
