import React, { useState } from "react";
import FacebookShareButton from "./FacebookShareButton";
import Input from "../Input/Input";
import {
  VALIDATOR_REQUIRE,
  VALIDATOR_MINLENGTH,
  VALIDATOR_MAXLENGTH,
} from "../../Utils/validators";
import { useForm } from "../../hooks/custom-form-hook";

const FacebookShare = ({ data }) => {
  //   const [shareUrl, setShareUrl] = useState("");
  //   const [shareTitle, setShareTitle] = useState("");
  //   const [shareImage, setShareImage] = useState("");
  const [formState, handleInput, handleSetInputData] = useForm(data, false);

  const shareUrl = "https://example.com";
  const shareTitle = "Your Page Title";
  const shareImage = "https://example.com/image.jpg";
  const customText = "custom text content";

  return (
    <div>
      {/* shareTitle */}
      <Input
        element="input"
        id="shareTitle"
        type="text"
        name="shareTitle"
        placeholder="Megosztandó cím"
        inputcls="w-full border-2 text-center p-2 my-2 outline-blue-500"
        validators={[
          VALIDATOR_REQUIRE(),
          VALIDATOR_MINLENGTH(2),
          VALIDATOR_MAXLENGTH(254),
        ]}
        errorText={"Nem lehet üres"}
        onInput={handleInput}
        initialValid={true}
        value={data?.body?.data?.articleTitle?.value}
      />
      {/* shareUrl */}
      <Input
        element="input"
        id="shareUrl"
        type="text"
        name="shareUrl"
        placeholder="Megosztandó url"
        inputcls="w-full border-2 text-center p-2 my-2 outline-blue-500"
        validators={[
          VALIDATOR_REQUIRE(),
          VALIDATOR_MINLENGTH(2),
          VALIDATOR_MAXLENGTH(254),
        ]}
        errorText={"Nem lehet üres"}
        onInput={handleInput}
        initialValid={true}
        value={data?.body?.data?.articleSlug?.value}
      />
      <FacebookShareButton
        shareUrl={shareUrl}
        shareTitle={shareTitle}
        shareImage={shareImage}
        customText={customText}
      />
    </div>
  );
};

export default FacebookShare;
